﻿$(function () {

    // Ajax handling of the Login button
    $("#cmdLogin").on("click",
        function (e) {


            // Basic validation.
            $("#loginerror").hide();
            if ($("#cUserName").val() == "" || $("#cPassword").val() == "") {
                // alert("Enter Username and Password please !");
                $("#loginerror").html("Enter Username and Password please !");
                $("#loginerror").show();
                return;
            }

            // We first check whether information has been fully entered.
            // We get all the Data from frmRegister and hit the server's function to generate an OTP.
            // Once OTP is generated, we show another form to allow the user to enter the OTPs.
            var formdata = $("#frmLogin").serialize() + "&type=login";

            // Ley us hit the server function KycRegister function on the server using ajax.
            $.ajax("KycRegister.kycssnp",
                  {
                      async: false,
                      cache: false,
                      type: "POST",
                      data: formdata,
                      dataType: 'json',  // Ther KycRegister function will return a JSon object.
                      success: function (data) {
                          $("#loginerror").hide();
                          if (data.error) {
                              //showMessage(data.error, { title: "KYC New Registration error" });
                              $("#loginerror").html(data.error);
                              $("#loginerror").show();
                              return;
                          }
                          // No error has occurred. This means that the server has sent the
                          // Javascript to redirect us to the main page.
                          eval(data.javascript);
                      } // Eof : success
                  }); // Eof : $.ajax

            e.preventDefault();
            return;
        }
      );
    // If a user clicks on the Register button, we should send an eMail/SMS with OTP and show a popup
    // where he can enter the email-OTP and sms-OTP.
    $("#cmdRegister").on("click",
        function (e) {
            // We first check whether information has been fully entered.
            // We get all the Data from frmRegister and hit the server's function to generate an OTP.
            // Once OTP is generated, we show another form to allow the user to enter the OTPs.
            var formdata = $("#frmRegister").serialize() + "&type=register";

            // Ley us hit the server function KycRegister function on the server using ajax.
            $.ajax("KycRegister.kycssnp",
                  {
                      async: false,
                      cache: false,
                      type: "POST",
                      data: formdata,
                      dataType: 'json',  // Ther KycRegister function will return a JSon object.
                      success: function (data) {
                          $("#regerror").hide();
                          if (data.error) {
                              //showMessage(data.error, { title: "KYC New Registration error" });
                              $("#regerror").html(data.error);
                              $("#regerror").show();
                              return;
                          }
                          // Ok ! No error occurred at the server-end. That means that the registration is
                          // available.
                          // Also note that the server has, by now, sent the eMail and SMS with the respective
                          // OTPs to the user. 
                          // We now show the OTP Dialog.
                          $("#otperror").hide();
                          $('#otpModal').modal({ backdrop: 'static' });
                          return;
                      } // Eof : success
                  }); // Eof : $.ajax

            e.preventDefault();
            return;
        }
      );

    //cmdOtpRegister
    // 
    // FOR THE TIME BEING, WE WILL SUPPRESS THE EMAIL OTP TOTALLY.
    $("#cmdOtpRegister").on("click", function (e) {

        // Validation
        $("#otperror").hide();
        
        // TEMPORARY : Email OTP Suppressed
        if ($("#cMobileOtp").val() == "") {
            $("#otperror").html("Please enter the OTP recieved by you !").show();
            return;
        };

        // We accumulate the data from both the forms.
        var formdata = $("#frmRegister").serialize() + "&" + $("#frmKycOtp").serialize() + "&type=otp";

        // Now send the Data to the server's KycRegister function. Note that this is the same function
        // that was used when the user clicked on the "Register" button on the opening screen. This is
        // necessary to make sure that registration details are still valid and the OTP matches.
        // Ley us hit the server function KycRegister function on the server using ajax.
        $.ajax("KycRegister.kycssnp",
              {
                  async: false,
                  cache: false,
                  type: "POST",
                  data: formdata,
                  dataType: 'json',  // Ther KycRegister function will return a JSon object.
                  success: function (data) {

                      //alert(data.success);

                      // We hide the error panel
                      $("#otperror").hide();

                      if (data.error) {
                          // Show the error Panel.
                          $("#otperror").html(data.error).show();
                          return;
                      };

                      if (data.success) {
                          // The client has successfuly entered the OTPs and the registration is done.
                          // First we hide the dialog.
                          $("#otpModal").modal("hide");
                          // We show the congratulatory message.
                          showMessage(data.success, { title: "Congratulations" });

                          // The server has sent a javascript [to set a cookie]. We need to
                          // set that cookie.
                          eval(data.javascript);

                          // Now we redirect the window to the KYCMAIN page.
                          //window.location.replace('kyc/kycmain.kycswc');
                      };

                  }
              }); // Eof : $.ajax

        e.preventDefault();
        return;
    });
});


////-------------------------------
//// Forgot Password
////-------------------------------
//$(function() {

//    $("#cmdForgotPwd").on("click",
//        function (e) {
//            urlDialog("KYC/KYCForgotPassword.Kycsswc");
//            e.preventDefault();
//            return;
//        }
//      );
//});