﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="pledgeSetup.aspx.cs" Inherits="Connect_DotNet.CDSLMPI.pledgeSetup" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta charset="UTF-8">
  <title>CDSL Pledge Setup</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap CSS -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <style>
    body {
      background-color: #f8f9fa;
    }
    .card {
      border-radius: 10px;
      box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
    }
    .form-group i {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: #6c757d;
    }
    .input-with-icon {
      position: relative;
    }
    .input-with-icon select {
      padding-left: 2.5rem;
    }
    .logo {
      max-height: 60px;
    }
  </style>

     <script>
        function requestData(type) {
            
            if ($('#<%= cboPledgor.ClientID %>').val() == null) {
                alert("Pledgor Not Available for Pledge")
                return;
            }

             if ($('#<%= cboPledgee.ClientID %>').val() == null) {
                alert("Pledgee Not Available for Pledge")
                return;
            }

            document.getElementById('hdnBtnRequestClicked').value = type;

            // Show the loading modal
            //showModalLoading();

            document.getElementById('<%= btnPledgeRequest.ClientID %>').click();
         }

         function handleCheckboxChange(isin, quantity) {
            // alert(isin);
             if (document.getElementById('chk_' + isin).checked) {
                 document.getElementById('txtQty_' + isin).value = quantity;
             }
             else {
                 document.getElementById('txtQty_' + isin).value = "";
             }
             
         }

    </script>

</head>
<body>
    <form id="form1" runat="server">
       <div class="container mt-2">
          <div class="text-center mb-2">
            <img src="../../custom/your_logo_large.png" alt="CDSL Logo" class="logo">
          </div>
          <div class="card">
            <div class="card-header bg-info text-white text-center">
              <h3 class="mb-0">CDSL Pledge Setup</h3>
            </div>
            <div class="card-body">
                <p>
			        The Margin Pledge Setup API is initiated by the Pledgor (investor) through the broker’s secure website or app. The pledge request is authenticated using an OTP sent by CDSL to the investor’s registered mobile number and email, and verified at the MPI Gateway.
		        </p>
                <asp:Label ID="lblmsg" runat="server" ForeColor="#CC0000" Visible="False"></asp:Label>
                <div id="divMain" runat="server">
                     <h4 id="hNameUCC" runat="server"></h4>
                    <div id="divSeting" runat="server">
                        <div class="form-group input-with-icon">
                          <i class="fas fa-user-tag"></i>
                          <label for="cboPledgor">Pledgor</label>
                          <asp:DropDownList CssClass="form-control" ID="cboPledgor" runat="server"></asp:DropDownList>
                      
                        </div>
                        <div class="form-group input-with-icon">
                          <i class="fas fa-building"></i>
                          <label for="cboExchange">Exchange</label>
                           <asp:DropDownList ID="cboExchange" runat="server" CssClass="form-control">
                              <asp:ListItem Text="NSE" Value="12" />
                              <asp:ListItem Text="BSE" Value="11" />
                               <asp:ListItem Text="NCDEX" Value="22" />
                               <asp:ListItem Text="MCX" Value="29" />
                            </asp:DropDownList>
                         </div>

                        <div class="form-group input-with-icon">
                          <i class="fas fa-layer-group"></i>
                          <label for="cboSegment">Segment</label>
                            <asp:DropDownList ID="cboSegment" runat="server" CssClass="form-control">
                              <asp:ListItem Text="All Segments" Value="AL" />
                              <asp:ListItem Text="Market Segments" Value="CM" />
                                <asp:ListItem Text="Future & Options Segments" Value="FO" />
                                <asp:ListItem Text="Currency Derivatives Segments" Value="CD" />
                                <asp:ListItem Text="SLB" Value="SB" />
                                <asp:ListItem Text="Commodity Derivatives Segments" Value="CO" />
                                <asp:ListItem Text="Debt Segments" Value="DT" />
                            </asp:DropDownList>
                        </div>

                        <div class="form-group input-with-icon">
                          <i class="fas fa-handshake"></i>
                          <label for="cboPledgee">Pledgee</label>
                          <asp:DropDownList ID="cboPledgee" runat="server" CssClass="form-control"></asp:DropDownList>
                        </div>
                        <div style="display:none">
                        <asp:Button ID="btnPledgeRequest" OnClick="btnPledgeRequest_Click" runat="server" Text="Button" />
                        <input type="hidden" id="hdnBtnRequestClicked" name="hdnBtnRequestClicked" runat="server" value="">
                     </div>
                        <button type="button" class="btn btn-lg btn-success mt-4" onclick="requestData('SecDtls')">
                      <i class="fas fa-check-circle mr-1"></i> Continue to next step
                    </button>
                    </div>
                </div>
                 <div class="mt-4" style="display:none" id="divSecurities" runat="server">
                     <h4 class="bg-light">Please select the securities you wish to pledge.</h4>

                     <div class="table-responsive">
                         <asp:PlaceHolder ID="phSecurities"  runat="server"></asp:PlaceHolder>
                     </div>
                        

                        <button type="button" class="btn btn-lg btn-primary mt-4" onclick="requestData('Confirm')">
                      <i class="fas fa-check mr-1"></i> Confirm and continue
                    </button>
                 </div>
               
            </div>
          </div>

         <div class="row">
			<div class="col-sm-12" style="text-align:right;">
				<a href="http://www.stansoftware.com">
					<div style="margin-right:20px; position:relative;top:5px;font-size:12px;font-weight:bold">Powered by</div>
					<img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						</a>
			</div>
		</div>
        </div>
    </form>

    <!-- Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>

   

</body>
</html>
