﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="CallStatusReport.aspx.cs" Inherits="Connect_DotNet.CallStatusReport" %>

<%@ Register Assembly="ssCommon" Namespace="ssCommon.Controls.BrowserControls" TagPrefix="ss" %>

<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>

    <!-- #CSS Links -->
	<!-- Basic Styles 
	<link rel="stylesheet" type="text/css" media="screen" href="../css/bootstrap.min.css">
        -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

	<link href="../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-skins.min.css">

	<!-- BootComplete http://getwebhelp.com/bootcomplete/ -->
	<link href="../scripts/BootStrap/plugins/bootcomplete/bootcomplete.css" rel="stylesheet" />
	
	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">
	
	<link href="../css/your_style.css" rel="stylesheet" />
    <link href="../css/font-awesome-animation.min.css" rel="stylesheet" />

	<style>
		.NoBorder td { border:none !important; padding:2px !important }
		.AlignMiddle td { vertical-align:middle !important }
	</style>
</head>
<body>
	<div class=container-fluid>
		<h2><i class="fa fa-table" aria-hidden="true"></i> Call Status Report</h2>
		<form id="frmCallStatus" runat="server">
			<asp:HiddenField ID=hdnSourceId runat="server" />
			<div class=row>
				<div class=col-sm-8>
					<table class="table table-condensed table-responsive NoBorder AlignMiddle">
						<tr>
							<td style="width:12%;text-align:right">From Date :</td>
							<td style="padding-left:0 !important">
								<dx:ASPxDateEdit ID=dtFrom runat="server" CssClass="form-control input-sm" Theme=MetropolisBlue></dx:ASPxDateEdit>
							</td>
							<td style="width:10%;text-align:right">To Date :</td>
							<td style="padding-left:0 !important"> 
								<dx:ASPxDateEdit ID=dtTo runat="server" CssClass="form-control input-sm" Theme=MetropolisBlue></dx:ASPxDateEdit>
							</td>
							<td style="width:20%">
								<ss:ASPxCheckBox ID=chkSuccess runat="server" Text="Successful Calls" Checked=true></ss:ASPxCheckBox>
							</td>
							<td>
								<ss:ASPxButton ID=btnView runat="server" Text="View" CssClass="btn btn-primary btn-sm" OnClick=btnView_Click></ss:ASPxButton>
							</td>
						</tr>
					</table>
				</div>
				<div class=col-sm-4></div>
			</div>
			<div class=row>
				<div class=col-sm-12>
					<dx:ASPxGridView ID=grdParent runat="server" ClientInstanceName=grdParent KeyFieldName="SourceId" EnableViewState=true Theme=MetropolisBlue 
						OnDetailRowExpandedChanged=grdParent_DetailRowExpandedChanged 
						Width=100% SettingsBehavior-AllowSort=false>
						<Styles>
							<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
						</Styles>
						<Columns>
							<dx:GridViewDataColumn FieldName="SourceId" Visible=false/>
							<dx:GridViewDataColumn FieldName="CalledBy" Caption="Called By" VisibleIndex="1" />
							<dx:GridViewDataColumn FieldName="Client" CellStyle-HorizontalAlign=Right
								HeaderStyle-HorizontalAlign=Right VisibleIndex="2" />
							<dx:GridViewDataColumn FieldName="AP" CellStyle-HorizontalAlign=Right
								HeaderStyle-HorizontalAlign=Right VisibleIndex="3"  />
							<dx:GridViewDataColumn FieldName="Inactive" CellStyle-HorizontalAlign=Right
								HeaderStyle-HorizontalAlign=Right Caption="Inactive Client" VisibleIndex="4" />
							<dx:GridViewDataColumn FieldName="Lead" CellStyle-HorizontalAlign=Right
								HeaderStyle-HorizontalAlign=Right Caption="Marketing Lead" VisibleIndex="5" />
						</Columns>
						<Templates>
							<DetailRow>
								<div style="padding: 3px 3px 2px 3px">
									<dx:ASPxPageControl runat="server" ID="pageControl" Width="100%" Theme=MetropolisBlue
										OnTabClick=pageControl_TabClick>
										<TabPages>
											<dx:TabPage Text="All" Visible="true">
												<ContentCollection>
													<dx:ContentControl runat="server">
														<dx:ASPxGridView ID=grdChildAll runat="server" KeyFieldName="SourceId,TargetId,CallTime" EnableViewState=true
															OnPageIndexChanged=grdChild_PageIndexChanged
															Width=100% SettingsBehavior-AllowSort=false Theme=MetropolisBlue>
															<Styles>
																<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
															</Styles>
															<Columns>
																<dx:GridViewDataColumn FieldName="SourceId" Visible=false/>
																<dx:GridViewDataColumn FieldName="CalledTo" Caption="Called To" VisibleIndex="1" />
																<dx:GridViewDataTextColumn FieldName="CallTime" Caption="Call Time" 
																	PropertiesTextEdit-DisplayFormatString="dd.MMM.yyyy hh:mm:ss tt" 
																	HeaderStyle-HorizontalAlign=Center CellStyle-HorizontalAlign=Center 
																	ReadOnly=true VisibleIndex="2" />
																<dx:GridViewDataColumn FieldName="Type" Caption="Target Type" VisibleIndex="3"  />
																<dx:GridViewDataColumn FieldName="Status" VisibleIndex="4" />
																<dx:GridViewDataColumn FieldName="Remarks" VisibleIndex="5" />
															</Columns>
														</dx:ASPxGridView>
													</dx:ContentControl>
												</ContentCollection>
											</dx:TabPage>
											<dx:TabPage Text="Client" Visible="true">
												<ContentCollection>
													<dx:ContentControl runat="server">
														<dx:ASPxGridView ID=grdChildClient runat="server" KeyFieldName="SourceId,TargetId,CallTime" EnableViewState=true
															OnPageIndexChanged=grdChild_PageIndexChanged
															Width=100% SettingsBehavior-AllowSort=false Theme=MetropolisBlue>
															<Styles>
																<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
															</Styles>
															<Columns>
																<dx:GridViewDataColumn FieldName="SourceId" Visible=false/>
																<dx:GridViewDataColumn FieldName="CalledTo" Caption="Called To" VisibleIndex="1" />
																<dx:GridViewDataTextColumn FieldName="CallTime" Caption="Call Time" 
																	PropertiesTextEdit-DisplayFormatString="dd.MMM.yyyy hh:mm:ss tt" 
																	HeaderStyle-HorizontalAlign=Center CellStyle-HorizontalAlign=Center 
																	ReadOnly=true VisibleIndex="2" />
																<dx:GridViewDataColumn FieldName="Status" VisibleIndex="3" />
																<dx:GridViewDataColumn FieldName="Remarks" VisibleIndex="4" />
															</Columns>
														</dx:ASPxGridView>
													</dx:ContentControl>
												</ContentCollection>
											</dx:TabPage>
											<dx:TabPage Text="AP" Visible="true">
												<ContentCollection>
													<dx:ContentControl runat="server">
														<dx:ASPxGridView ID=grdChildAp runat="server" KeyFieldName="SourceId,TargetId,CallTime" EnableViewState=true
															OnPageIndexChanged=grdChild_PageIndexChanged
															Width=100% SettingsBehavior-AllowSort=false Theme=MetropolisBlue>
															<Styles>
																<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
															</Styles>
															<Columns>
																<dx:GridViewDataColumn FieldName="SourceId" Visible=false/>
																<dx:GridViewDataColumn FieldName="CalledTo" Caption="Called To" VisibleIndex="1" />
																<dx:GridViewDataTextColumn FieldName="CallTime" Caption="Call Time" 
																	PropertiesTextEdit-DisplayFormatString="dd.MMM.yyyy hh:mm:ss tt" 
																	HeaderStyle-HorizontalAlign=Center CellStyle-HorizontalAlign=Center 
																	ReadOnly=true VisibleIndex="2" />
																<dx:GridViewDataColumn FieldName="Status" VisibleIndex="3" />
																<dx:GridViewDataColumn FieldName="Remarks" VisibleIndex="4" />
															</Columns>
														</dx:ASPxGridView>
													</dx:ContentControl>
												</ContentCollection>
											</dx:TabPage>
											<dx:TabPage Text="Inactive Client" Visible="true">
												<ContentCollection>
													<dx:ContentControl runat="server">
														<dx:ASPxGridView ID=grdChildInactive runat="server" KeyFieldName="SourceId,TargetId,CallTime" EnableViewState=true
															OnPageIndexChanged=grdChild_PageIndexChanged
															Width=100% SettingsBehavior-AllowSort=false Theme=MetropolisBlue>
															<Styles>
																<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
															</Styles>
															<Columns>
																<dx:GridViewDataColumn FieldName="SourceId" Visible=false/>
																<dx:GridViewDataColumn FieldName="CalledTo" Caption="Called To" VisibleIndex="1" />
																<dx:GridViewDataTextColumn FieldName="CallTime" Caption="Call Time" 
																	PropertiesTextEdit-DisplayFormatString="dd.MMM.yyyy hh:mm:ss tt" 
																	HeaderStyle-HorizontalAlign=Center CellStyle-HorizontalAlign=Center 
																	ReadOnly=true VisibleIndex="2" />
																<dx:GridViewDataColumn FieldName="Status" VisibleIndex="3" />
																<dx:GridViewDataColumn FieldName="Remarks" VisibleIndex="4" />
															</Columns>
														</dx:ASPxGridView>
													</dx:ContentControl>
												</ContentCollection>
											</dx:TabPage>
											<dx:TabPage Text="Marketing Lead" Visible="true">
												<ContentCollection>
													<dx:ContentControl runat="server">
														<dx:ASPxGridView ID=grdChildLead runat="server" KeyFieldName="SourceId,TargetId,CallTime" EnableViewState=true
															OnPageIndexChanged=grdChild_PageIndexChanged
															Width=100% SettingsBehavior-AllowSort=false Theme=MetropolisBlue>
															<Styles>
																<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
															</Styles>
															<Columns>
																<dx:GridViewDataColumn FieldName="SourceId" Visible=false/>
																<dx:GridViewDataColumn FieldName="CalledTo" Caption="Called To" VisibleIndex="1" />
																<dx:GridViewDataTextColumn FieldName="CallTime" Caption="Call Time" 
																	PropertiesTextEdit-DisplayFormatString="dd.MMM.yyyy hh:mm:ss tt" 
																	HeaderStyle-HorizontalAlign=Center CellStyle-HorizontalAlign=Center 
																	ReadOnly=true VisibleIndex="2" />
																<dx:GridViewDataColumn FieldName="Status" VisibleIndex="3" />
																<dx:GridViewDataColumn FieldName="Remarks" VisibleIndex="4" />
															</Columns>
														</dx:ASPxGridView>
													</dx:ContentControl>
												</ContentCollection>
											</dx:TabPage>
										</TabPages>
									</dx:ASPxPageControl>
							</DetailRow>
						</Templates>
						<ClientSideEvents DetailRowExpanding="function(s, e) { Row_Click(s, e) }" />
					</dx:ASPxGridView>
				</div>
			</div>
		</form>
	</div>
 
	<!--================================================== -->
		<!--
	<script src="../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../js/bootstrap/bootstrap.min.js"></script>
            -->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>

	<!-- StanSoft Script -->
	<script src="../scripts/ssajax.js"></script>

	<script>
		function Row_Click(s, e) {
			document.getElementById("hdnSourceId").value = grdParent.GetRowKey(e.visibleIndex)
		}
	</script>
</body>
</html>
