﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Client_MtfReg.aspx.cs" Inherits="Connect_DotNet.Client_MtfReg" %>
<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<!DOCTYPE html>

<html>
<head runat="server">
	<title></title>

	<!-- Basic Styles 
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
        -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-skins.min.css">

	<!-- BootComplete http://getwebhelp.com/bootcomplete/ -->
	<link href="../../scripts/BootStrap/plugins/bootcomplete/bootcomplete.css" rel="stylesheet" />

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">

	<link href="../../css/your_style.css" rel="stylesheet" />
	<link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />

	<style>
		#btnSubmit, #chkAgree { font-size:16px; font-weight:bold }
	</style>
</head>
<body>
	<div class="container-fluid">
	<form id="frmClMtfReg" runat="server">
		<asp:HiddenField ID="hdnIsAgreementPresent" runat="server" />
		<div class="row">
			<div class="col-xs-12">
				<div id="divAgreement" runat="server" width="100%"></div>
			</div>
		</div>
		<br />
		<div id="divSubmit" runat="server" class="row" style="background-color:lightskyblue;padding:10px">
			<div class="col-sm-4"></div>
			<div class="col-sm-2" style="padding-right:2px !important">
				<dx:ASPxCheckBox ID="chkAgree" ClientInstanceName="chkAgree" runat="server" Text="I Agree for MTF." Theme="MetropolisBlue">
					<ClientSideEvents CheckedChanged="function(s,e) { 
							btnSubmit.SetEnabled(chkAgree.GetChecked());
						}" />
				</dx:ASPxCheckBox>
			</div>
			<div class="col-sm-2" style="padding-left:2px !important">
				<dx:ASPxButton ID="btnSubmit" ClientInstanceName="btnSubmit" runat="server" Text="Submit" 
					HoverStyle-BackColor="ForestGreen" Theme="MetropolisBlue"
					OnClick="btnSubmit_Click">
					<ClientSideEvents Click="function(s,e) { btnSubmit_Click(s,e);	}" />
				</dx:ASPxButton>
			</div>
			<div class="col-sm-4"></div>
		</div>

		<div id="divWait" style="text-align:center; position:fixed; top:30%; left:40%; visibility:hidden; z-index:100000; 
				border:1px solid lightgray; border-radius:15px; box-shadow:0px 0px 10px black; background-color:white; padding:10px">
			<i class="fa fa-spinner fa-4x fa-pulse fa-fw" aria-hidden="true"></i>
			<h6>Please Wait.....</h6>
		</div>

		<div class="row">
			<div class="col-xs-12">
				<div ID="divSuccessful" runat="server" Width="100%" Visible="false">
					<h1 class="text-center text-success">
						<i class="fa fa-check"></i> Congratulations . . . !
						<br />
						<small>You have successfully registered for MTF with us.</small>
						<br />
						<small>Please check your registered mail id for confirmation mail.</small>
						<br />
						<small>Thank You !</small>
					</h1>
				</div>
			</div>
		</div>
	</form>
	<div style="height:100px"></div>
	</div>

	<!--================================================== -->
	<!--
    <script src="../../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../../js/bootstrap/bootstrap.min.js"></script>
    -->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>

	<script>
		$(document).ready(function () {
			btnSubmit.SetEnabled(chkAgree.GetChecked());
		});

		function btnSubmit_Click(s, e) {
			e.processOnServer = document.getElementById("hdnIsAgreementPresent").value == "T";
			if(e.processOnServer) $('#divWait').css('visibility', 'visible');
		}
	</script>

</body>
</html>
