﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Notification.aspx.cs" Inherits="Connect_DotNet.Notification" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>

	<!-- Basic Styles 
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
        -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-skins.min.css">

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">

	<link href="../../css/your_style.css" rel="stylesheet" />
	<link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />

	<style>
		table { margin:1px }
		table td { padding:2px }
		.chatText { font-size:13px }
		.chatTextHeader { font-size:9px;color:gray }
		.chatToBack { background-color:#e3eaa7;border-radius:10px;padding:5px 10px }
	</style>
</head>
<body>
    <form id="frmBroadcast" runat="server">
		<asp:HiddenField ID=hdnLoginUserName runat="server" />
		<asp:HiddenField ID=hdnLoginUserId runat="server" />
		<asp:HiddenField ID=hdnLoginType runat="server" />
		<div class=container-fluid>
			<div id=divSender class=row runat=server>
				<table style="width:99%">
					<tr>
						<td style="text-align:right;width:45%">
							<h5>Send notification to all</h5>
						</td>
						<td>
							<select id=lstUserTypes class=form-control>
								<option value="BRANCH">Branches</option>
								<option value="DEALER">Dealers</option>
								<option value="GROUP">Groups</option>
								<option value="FUNDMGR">Fund Managers</option>
								<option value="RM">Relationship Managers</option>
								<option value="SUB-BROKER">Sub-Brokers</option>
							</select>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<textarea id="txtMsg" rows=6 class=form-control style="resize:none" spellcheck="true"></textarea>
						</td>
					</tr>
					<tr>
						<td colspan="2" style="text-align:right">
							<input id="btnSend" type="button" value="Send" class="btn btn-success" />
						</td>
					</tr>
				</table>
			</div>
			<div id=divReceiver class=row runat=server>
				<div id=divNotification style="height:100%;overflow-y:auto"></div>
			</div>
		</div>
    </form>

	<!-- --------------- Scripts --------------- -->
	<!--
    <script src="../../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../../js/bootstrap/bootstrap.min.js"></script>
    -->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>

	<script src="../scripts/jquery.signalR-2.2.2.min.js"></script>
	<script src='<%: ResolveClientUrl("~/signalr/hubs") %>'></script>

	<script>
		$(document).ready(function () {
			$("#txtMsg").focus();

			$.connection.hub.qs = {
				"userName": $("#hdnLoginUserName").val(),
				"userId": $("#hdnLoginUserId").val(),
				"userType": $("#hdnLoginType").val()
			};

			var notifyProxy = $.connection.notifyHub;
			$.connection.hub.start().done(function () {
				$("#btnSend").click(function (e) {
					if($("#txtMsg").val() == "") {
						$("#txtMsg").focus();
						return;
					}

					notifyProxy.server.broadcastMsgToAll($("#hdnLoginUserName").val(), $("#lstUserTypes").val(), $("#txtMsg").val());

					$("#txtMsg").val("").focus();
				});
			}).fail(function (error) {
				console.log('SignalR Error: ' + error);
			});

			notifyProxy.client.recieveMessage = function (sender, dtTm, msg) {
				$("#divNotification").append('<div class="alert alert-warning fade in">' +
					'<button class="close" data-dismiss="alert">×</button>' +
					'<i class="fa-fw fa fa-info"></i>' +
					'<strong>Notification!</strong><br/>' +
					'<i class=chatTextHeader>' +
					sender + ' @ ' + dtTm +
					'</i><br><label class="control-label chatText" style="white-space:pre-wrap">' +
					msg + '</label>' +
					'</div>');

				$("#divNotification").scrollTop($("#divNotification").prop("scrollHeight"));

				var divNotification = window.parent.document.getElementById("divNotification");
				if(divNotification.style.display == "none") {
					var lblNotifyCount = window.parent.document.getElementById("lblNotifyCount");
					lblNotifyCount.innerText = +lblNotifyCount.innerText + 1;

					var icnNotify = window.parent.document.getElementById("icnNotify");
					icnNotify.style.color = "dodgerblue";

					window.parent.bounceEffect("icnNotify");
				}
			}
		});
	</script>
	<!-- --------------------------------------- -->
</body>
</html>
