﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="AuthorizedRepresentative.aspx.cs" Inherits="Connect_DotNet.ReActivation.AuthorizedRepresentative" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<!DOCTYPE html>

<html>
<head runat="server">
  <title>Authorized representative</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>


  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />
</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }


    </style>
     <script>

          window.onload = function () {

             
         }

         function saveData(type) {

             if (type == "Add") {

                 //if (document.getElementById('authorizedRepresentativeName').value == "") {
                 //    alertModal("Error - Authorized Representative", "Please enter Name!");
                 //    return;
                 //}

                  if (document.getElementById('authorizedRepresentativeName').value == "") {
                     saveData('Skip');
                     return;
                 }

                 if (document.getElementById('authorizedRepresentativeRelation').value == "") {
                     alertModal("Error - Authorized Representative", "Please enter Relation!");
                     return;
                 }

                 if (document.getElementById('authorizedRepresentativeDOB').value == "") {
                     alertModal("Error - Authorized Representative", "Please enter Date of Birth!");
                     return;
                 }

                 var enteredAge = getAge(document.getElementById('authorizedRepresentativeDOB').value);

                 if (enteredAge < 18) {
                     alertModal("Error : Authorized Representative", "Date of Birth not valid! Authorized representative's age is minor! Authorized representative's age should be from 18 years.");
                     return false
                 }


                 if (document.getElementById('cmbAuthorizedRepresentativeGender').value == "") {
                     alertModal("Error - Authorized Representative", "Please select Gender!");
                     return;
                 }

                 if (document.getElementById('authorizedRepresentativeNationality').value == "") {
                     alertModal("Error - Authorized Representative", "Please enter Nationality!");
                     return;
                 }

                 if (document.getElementById('authorizedRepresentativeAddress').value == "") {
                     alertModal("Error - Authorized Representative", "Please enter current address with pincode!");
                     return;
                 }

                 if (!IsMobileNumber(document.getElementById('authorizedRepresentativeMobile'))) {
                     return;
                 }
                 if (!ValidateEmail(document.getElementById('authorizedRepresentativeEmail'))) {
                     return;
                 }

                 if (validateFileExtensionByFileName(document.getElementById('hiddenauthorizedRepresentativePassportSizePhotoFile').value, "Authorized Representative passport size photo", "JPG,PNG,JPEG") == false) {
                     return;
                 }


                 if (validateFileExtensionByFileName(document.getElementById("hiddenauthorizedRepresentativeSignatureImageFile").value, "Authorized Representative signature image", "JPG,PNG,JPEG") == false) {
                     return;
                 }

                 if (document.getElementById('authorizedRepresentativePanCard').value == "") {
                     alertModal("Error - Authorized Representative", "Please enter Pan Card!");
                     return;
                 }


                 if (validateFileExtensionByFileName(document.getElementById("hiddenauthorizedRepresentativePANFile").value, "Authorized Representative PAN card ", "JPG,PNG,JPEG,PDF") == false) {
                     return;
                 }

                 if (document.getElementById('authorizedRepresentativeAadhaar').value == "") {
                     alertModal("Error - Authorized Representative", "Please enter Aadhaar!");
                     return;
                 }

                 if (validateFileExtensionByFileName(document.getElementById("hiddenauthorizedRepresentativeAadhaarFile").value, "Authorized Representative Aadhaar Copy", "JPG,PNG,JPEG,PDF") == false) {
                     return;
                 }

             }

             document.getElementById('hdnBtnContinueClicked').value = type;

             $('#modalLoading').modal('show');
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();

         }

         function IsMobileNumber(number) {
                var val = number.value
                if (/^\d{10}$/.test(val)) {
                    // value is ok, use it
                    return true
                } else {
                    alertModal("Error", "Invalid number; must be 10 digits!");
                    //alert("Invalid number; must be 10 digits!")
                    number.focus()
                    return false
                }
         }

         function ValidateEmail(input) {

            var validRegex = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;

            if (input.value.match(validRegex)) {

                input.focus();
                return true;

            } else {

                //alert("Invalid email address!");
                alertModal("Error", "Invalid email address!");

                input.focus();

                return false;

            }

        }

         function validateFileExtensionByFileName(fileName, uploadType, fileTypes) {


             if (fileName == "") {
                 alertModal("Error : " + uploadType + " file upload", "Please select for upload " + uploadType + " file in " + fileTypes + " format!");
                 return false;
             }

             const fileTypesArray = fileTypes.split(",");

             let matchesNameExtns = "";
             for (let i = 0; i < fileTypesArray.length; i++) {

                 if (i == fileTypesArray.length - 1) {
                     matchesNameExtns += "." + fileTypesArray[i] + "$";
                 }
                 else {
                     matchesNameExtns += "." + fileTypesArray[i] + "$|";
                 }

             }

             var fileElementFileName = fileName.toUpperCase();

             if (fileElementFileName.match(matchesNameExtns) == null) {
                 alertModal("Error : " + uploadType + " file upload", "Invalid file selected! Please select for upload " + uploadType + " file in " + fileTypes + " format!");
                 return false;
             }

             return true;

         }

         function successAsyncFileUpload(sender, args) {

             const contolName = $(sender._element).find('input').attr('id');
             $(sender._element).find('input').css("background-color", "white");

             const hiddenContolName = 'hidden' + contolName.replace(/(^.+)(_.+$)/, '$1')


             var filename = $(sender._element).find('input').val().replace("C:\\fakepath\\", "");

             document.getElementById(hiddenContolName).value = filename;


         }

         function getAge(DOB) {
            var today = new Date();
            var birthDate = new Date(DOB);
            var age = today.getFullYear() - birthDate.getFullYear();
            var m = today.getMonth() - birthDate.getMonth();
            if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
                age--;
            }
            return age;
         }

         function alertModal(title, body) {
              // Display error message to the user in a modal
              $('#alert-modal-title').html(title);
            $('#alert-modal-body').html(body);

            if (title.match("Error") == "Error") {
                $('#alert-modal-body').addClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-success");
            }

            else if (title == "Request added") {
                $('#alert-modal-body').addClass("alert-success");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
            }
            else
            {
                $('#alert-modal-body').addClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-success");
            }
            
             $('#alert-modal').modal('show');
             $('#modalLoading').modal('hide');
         }

        
    </script>
    


    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                    <div class="col-md-3">
                        <center>
                        <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:200px; padding-top:10px">
                        </center>
                    </div>
                    <div class="col-md-9">
                        <h2 class="lblTopHeader"><i class="fa fa-user" aria-hidden="true"></i> Authorized Representative <span style="font-size:16px"> - Optional you can <a href="#" onclick="saveData('Skip');"><i class="fa fa-external-link" aria-hidden="true"></i> Skip this step</a></span></h2> 
                        <p>Addition of authorized representative –  The following information of Authorized representative need to be submitted</p>
                    </div>
                </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">

                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div class="row">
                                          <div class="col-md-8">
                                              <div id="divAuthorizedRepresentative">
                                                <div class="row">
                                                    <div class="col-sm-6">
                                                            <div class="form-group">
                                                            <label for="authorizedRepresentativeName" class="control-label col-sm-4">Name*:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="text" class="form-control" runat="server" id="authorizedRepresentativeName" maxlength="100">
                                                                </div>
                                                            </div>
                                                    </div>
                                                    <div class="col-sm-6">
                                                            <div class="form-group">
                                                            <label for="authorizedRepresentativeKYCNo" class="control-label col-sm-4">KYC No.(if available):</label>
                                                                <div class="col-sm-8">
                                                                    <input type="text" class="form-control" runat="server" id="authorizedRepresentativeKYCNo" maxlength="10">
                                                                </div>
                                                            </div>
                                                    </div>
                                                </div>
                                                <div class="row" style="padding-top:20px">
                                                    <div class="col-sm-6">
                                                            <div class="form-group">
                                                            <label for="authorizedRepresentativeRelation" class="control-label col-sm-4">Relation*:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="text" class="form-control" runat="server" id="authorizedRepresentativeRelation" maxlength="100">
                                                                </div>
                                                            </div>
                                                    </div>
                                                    <div class="col-sm-6">
                                                    </div>
                                                </div>
                                                <div class="row" style="padding-top:20px">
                                                    <div class="col-sm-6">
                                                            <div class="form-group">
                                                            <label for="authorizedRepresentativeFatherSpouseName" class="control-label col-sm-4">Father/Spouse Name:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="text" class="form-control" runat="server" id="authorizedRepresentativeFatherSpouseName" maxlength="100">
                                                                </div>
                                                            </div>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <div class="form-group">
                                                            <label for="authorizedRepresentativeMotherName" class="control-label col-sm-4">Mother Name:</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" class="form-control" runat="server" id="authorizedRepresentativeMotherName" maxlength="100">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row" style="padding-top:20px">
                                                    <div class="col-sm-6">
                                                            <div class="form-group">
                                                            <label for="authorizedRepresentativeDOB" class="control-label col-sm-4">Date of Birth*:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="date" class="form-control" id="authorizedRepresentativeDOB" runat="server">
                                                                </div>
                                                            </div>
                                                    </div>
                                                    <div class="col-sm-6">
                                                            <div class="form-group">
                                                            <label for="cmbAuthorizedRepresentativeGender" class="control-label col-sm-4">Gender*:</label>
                                                                <div class="col-sm-8">
                                                                    <asp:DropDownList ID="cmbAuthorizedRepresentativeGender" CssClass="form-control" runat="server">
                                                                        <asp:ListItem Value="M">Male</asp:ListItem>
                                                                        <asp:ListItem Value="F">Female</asp:ListItem>
                                                                        <asp:ListItem Value="T">Transgender</asp:ListItem>
                                                                    </asp:DropDownList>
                                                                </div>
                                                            </div>
                                                    </div>
                                                </div>
                                                <div class="row" style="padding-top:20px">
                                                    <div class="col-sm-6">
                                                            <div class="form-group">
                                                            <label for="authorizedRepresentativeNationality" class="control-label col-sm-4">Nationality*:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="text" class="form-control" id="authorizedRepresentativeNationality" runat="server" maxlength="100">
                                                                </div>
                                                            </div>
                                                    </div>
                                                    <div class="col-sm-6">
                                                            <div class="form-group">
                                                            <label for="authorizedRepresentativeAddress" class="control-label col-sm-4">Address*:</label>
                                                                <div class="col-sm-8">
                                                                    <textarea class="form-control" id="authorizedRepresentativeAddress" runat="server" placeholder="Enter Current Address with PIN code" name="authorizedRepresentativeAddress" rows="3"></textarea>
                                                                </div>
                                                            </div>
                                                    </div>
                                                </div>
                                                <div class="row" style="padding-top:20px">
                                                    <div class="col-sm-6">
							                            <div class="form-group">
								                            <label for="authorizedRepresentativeMobile" class="control-label col-sm-4">Mobile*:</label>
								                            <div class="col-sm-8">
									                            <input type="number"  class="form-control" id="authorizedRepresentativeMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
								                            </div>
							                            </div>
                                                    </div>
                                                    <div class="col-sm-6">
							                            <div class="form-group">
								                            <label for="authorizedRepresentativeEmail" class="control-label col-sm-4">Email*:</label>
								                            <div class="col-sm-8">
									                            <input type="text"  class="form-control" id="authorizedRepresentativeEmail" runat="server" placeholder="Email" maxlength="80">
								                            </div>
							                            </div>
                                                    </div>
                                                </div>
                    
                                                <div class="row" style="padding-top:20px">
                                                    <div class="col-sm-6">
                                                        <div class="form-group">
                                                            <label for="authorizedRepresentativePassportSizePhotoFile" class="control-label col-sm-4">Passport size photo*:</label>
                                                            <div class="col-sm-8">
                                                                <ajaxToolkit:AsyncFileUpload ID="authorizedRepresentativePassportSizePhotoFile" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="authorizedRepresentativePassportSizePhotoFile_UploadedComplete" runat="server" />
                                                                <input type="hidden" id="hiddenauthorizedRepresentativePassportSizePhotoFile" value="" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label for="authorizedRepresentativeSignatureImageFile" class="control-label col-sm-4">Signature image*:</label>
                                                        <div class="col-sm-8">
                                                            <ajaxToolkit:AsyncFileUpload ID="authorizedRepresentativeSignatureImageFile" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="authorizedRepresentativeSignatureImageFile_UploadedComplete" runat="server" />
                                                            <input type="hidden" id="hiddenauthorizedRepresentativeSignatureImageFile" value="" />
                                                        </div>
                                                    </div>
                                                    </div>
                                                    </div>
                                                <div class="row" style="padding-top:20px">
                                                    <div class="col-sm-6">
                                                            <div class="form-group">
                                                            <label for="authorizedRepresentativePanCard" class="control-label col-sm-4">PAN Card*:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="text" class="form-control" runat="server" id="authorizedRepresentativePanCard"  maxlength="20">
                                                                </div>
                                                            </div>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <div class="form-group">
                                                            <label for="authorizedRepresentativePANFile" class="control-label col-sm-4">Copy of PAN*:</label>
                                                            <div class="col-sm-8">
                                                                <ajaxToolkit:AsyncFileUpload ID="authorizedRepresentativePANFile" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="authorizedRepresentativePANFile_UploadedComplete" runat="server" />
                                                                <input type="hidden" id="hiddenauthorizedRepresentativePANFile" value="" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row" style="padding-top:20px">
                                                    <div class="col-sm-6">
                                                            <div class="form-group">
                                                            <label for="authorizedRepresentativeAadhaar" class="control-label col-sm-4">Aadhaar*:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="number" class="form-control" runat="server" id="authorizedRepresentativeAadhaar" maxlength="20" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                                                                </div>
                                                            </div>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <div class="form-group">
                                                            <label for="authorizedRepresentativeAadhaarFile" class="control-label col-sm-4">Copy of Aadhaar (Both side)*:</label>
                                                            <div class="col-sm-8">
                                                                <ajaxToolkit:AsyncFileUpload ID="authorizedRepresentativeAadhaarFile" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="authorizedRepresentativeAadhaarFile_UploadedComplete" runat="server" />
                                                                <input type="hidden" id="hiddenauthorizedRepresentativeAadhaarFile" value="" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm-12">
                                                        <div style="padding-top:10px; padding-left:10px;">
                                                            <button type="button" class="btn btn-success btn-lg" id="btnSaveContinue" onclick="saveData('Add');" runat="server" style="margin-top:5px" ><i class="fa fa-check" aria-hidden="true"></i> Save & Continue</button>
                                                            &nbsp;
                                                            <button type="button" class="btn btn-primary btn-lg" id="btnSkipStep" onclick="saveData('Skip');" runat="server" style="margin-top:5px" ><i class="fa fa-external-link" aria-hidden="true"></i> Skip this Step</button>
                                                            <p>
                                                                  <br />
                                                                  <i>
                                                                    *By clicking the above <b>'Save and Continue'</b> button, I agree that i have read <a href="#">Terms & Conditions</a>.
                                                                  </i>
                                                              </p>

                                                              <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                                              </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                              <hr />
                                          </div>
                                          <div class="col-md-4">
                                            <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4">
                                                <div class="alert alert-info" id="divAlertInfoMsg" runat="server">
                                                </div>
                                                <div class="alert alert-warning">
                                                    <strong>Warning!</strong> In case Aadhaar is uploaded, please remember: <br />
                                                    <span style="font-size:11px; color:red" id="spanAadhaarUploadNotes" runat="server">
                                                    </span>
                                                </div>
                                            </div>

                                              <h3 id="hFullName" runat="server"></h3>
                                             <p>
                                              Date of Birth : <u><span id="spanDOB" runat="server"></span></u>
                                              <br />
                                               PAN : <u><span id="spanPAN" runat="server"></span></u>
                                               <br />
                                               Aaadhaar : <u><span id="spanAadhaar" runat="server"></span></u>
                                             </p>
                                             <br />
                                             <p>
                                                 <b><span id="spanBrokerName" runat="server">Standard Broker</span></b> for conducting online KYC for reactivation trading and demat account
                                             </p>
                                             <p>
                                                The Aadhaar and the PAN should belong to you and your name, dob also must match in both documents Aadhaar and PAN , if it does not, then you can resolve the name mismatch issue by changing your name on the PAN Card from <a href="https://www.onlineservices.nsdl.com/paam/endUserRegisterContact.html">NSDL</a>  or on the Aadhaar Card from <a href="https://www.uidai.gov.in">UIDAI</a>.
                                             </p>
                                             <p>
                                                Your Aadhaar number is never visible or available to us.
                                             </p>

                                          </div>
                                      </div>
                                  </div>
                              </div>
                              

                            </ContentTemplate>
                        </asp:UpdatePanel>
                          <hr />
                             <div id="divPreviousSteps" runat="server">
                                <h4>Go to previous step </h4> 
                                <ul class="list-inline">
                                <li><a href="contact.aspx"><i class="fas fa-envelope fa-lg me-3 fa-fw" aria-hidden="true"></i> Contact</a></li>
                                <li><a href="DigiLockerKYC.aspx" id="hlinkDigiLocker" runat="server"><i class="fa fa-cloud-download" aria-hidden="true"></i> DigiLocker</a></li>
                                <li><a href="manuallyProcessing.aspx" id="hlinkAddress" runat="server"><i class="fa fa-id-card" aria-hidden="true"></i> Address</a></li>
                                <li><a href="capturePhoto.aspx" id="hlinkCapturePhoto" runat="server"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                <li><a href="profile.aspx" id="hlinkIncomeProfile" runat="server"><i class="fa fa-inr" aria-hidden="true"></i> Income Profile</a></li>
                                <li><a href="TradingPreference.aspx" id="hlinkTradingPreference" runat="server"><i class="fa fa-exchange" aria-hidden="true"></i> Trading Preference</a></li>
                                <li><a href="BankDetails.aspx" id="hlinkBankDetails" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Bank</a></li>
                                <li><a href="Nomination.aspx" id="hlinkNomination" runat="server"><i class="fa fa-users" aria-hidden="true"></i> Nomination</a></li>
                                <li><a href="dematAccount.aspx" id="hlinkDematAccount" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Demat Account</a></li>
                                </ul>
                            </div>

                      </div>
                    </div>
                  </div>
                </div>
              </div>
                
            </div>


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
                      <br />
                      <br />
			    </div>
                
             </div>

          </div>
        </section>
    </form>
     <div id="alert-modal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="alert-modal-title" class="modal-title"></h4>
              </div>
              <div id="alert-modal-body" class="modal-body"></div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">OK</button>
              </div>
            </div>
          </div>
        </div>

     <div class="modal fade" id="modalLoading" tabindex="-1" role="dialog" aria-labelledby="modalLoadingLabel">
      <div class="modal-dialog modal-md">
        <div class="modal-content">
          <div class="modal-header">
          </div>
          <div class="modal-body">
              <center>
                    <h4>Please wait..Your request is being processed..</h4>
                    <p>Do not close browser window....</p>
                    <img src="../ekyc/images/Loading.gif" alt="Loading" style="width:150px;" />
               </center>
          </div>

          <div class="modal-footer">
          </div>
        </div>
      </div>
    </div>

</body>
</html>
