﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="BankDetails.aspx.cs" Inherits="Connect_DotNet.ReActivation.BankDetails" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<!DOCTYPE html>

<html>
<head runat="server">
  <title>Add a Bank account</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
<script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>

      <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />
</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }
    </style>
     <script>

          function SameAsPresentDetailsClick(chkbxSameDetails) {
             if (chkbxSameDetails.checked == false) {
                 document.getElementById('txtBankIFSC').value = "";
                 document.getElementById('txtBankAccountNumber').value = "";
                 document.getElementById('txtConfirmBankAccountNumber').value = "";
                 document.getElementById('cmbBanks').value = "";
             }
             else {
                 setTimeout(function () {
                     location.reload();
                 }, 200);
             }
         }

         function findBank() {

             $('#modalLoading').modal('show');

             if (document.getElementById('txtBankIFSC').value == "") {
                 alertModal("Error", "Please provide a valid IFSC Code! for Search your Bank!");
                 $('#modalLoading').modal('hide');
             }
   
         }

         function addBank() {

             if (document.getElementById('cmbBanks') == null || document.getElementById('txtBankIFSC').value == "") {
                 alertModal("Error", "Please provide a valid IFSC Code! for Search your Bank!");
                 return;
             }

             if (document.getElementById('cmbBanks').value == "") {
                 alertModal("Error", "IFSC Code not found in our database! Please provide a valid IFSC Code!");
                 return;
             }

             if (document.getElementById('txtBankAccountNumber').value == "") {
                 alertModal("Error", "Please enter your bank account number!");
                 return;
             }

             if (document.getElementById('txtConfirmBankAccountNumber').value == "") {
                 alertModal("Error", "Please confirm bank account number!");
                 return;
             }

             if (document.getElementById('txtBankAccountNumber').value != document.getElementById('txtConfirmBankAccountNumber').value) {
                 alertModal("Error", "Confirm bank account number mismatch!");
                 return;
             }

             if (document.getElementById('hdnBankValidation').value != "API") {

                 if (document.getElementById('selectBankVerificationType').value == "") {
                     alertModal("Error", "Please select how to verification your bank a/c!");
                     return;
                 }

                 if (validateFileExtensionByFileName(document.getElementById('spanBankVerificationFileUpload').innerHTML, "Bank verification file (Canceled Cheque/Passbook 1st Page)", "JPG,PNG,JPEG") == false) {
                     return;
                 }

             }


             document.getElementById('hdnBtnContinueClicked').value = "Continue";

             $('#modalLoading').modal('show');
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();

         }

         function successAsyncFileUpload(sender, args) {

             if ($(sender._element).find('input').attr('id').match("bankVerificationAsyncFile") == "bankVerificationAsyncFile") {

                 $(sender._element).find('input').css("background-color", "white");

                 var filename = $(sender._element).find('input').val().replace("C:\\fakepath\\", "");

                 document.getElementById('spanBankVerificationFileUpload').innerHTML = filename;
                 document.getElementById('spanBankVerificationFileUpload').style.backgroundColor = "lime";

             }
         }

         function validateFileExtensionByElementId(fileElementId, ElementType, fileTypes) {

             var fileElement = document.getElementById(fileElementId)
             var fileElementFileName = "";

             if (fileElement.value != "") {
                 fileElementFileName = fileElement.files.item(0).name.toUpperCase();
             }

             return validateFileExtensionByFileName(fileElementFileName, ElementType, fileTypes);

         }

         function validateFileExtensionByFileName(fileName, uploadType, fileTypes) {


             if (fileName == "") {
                 alertModal("Error : " + uploadType + " file upload", "Please select for upload " + uploadType + " file in " + fileTypes + " format!");
                 return false;
             }

             const fileTypesArray = fileTypes.split(",");

             let matchesNameExtns = "";
             for (let i = 0; i < fileTypesArray.length; i++) {

                 if (i == fileTypesArray.length - 1) {
                     matchesNameExtns += "." + fileTypesArray[i] + "$";
                 }
                 else {
                     matchesNameExtns += "." + fileTypesArray[i] + "$|";
                 }

             }

             var fileElementFileName = fileName.toUpperCase();

             if (fileElementFileName.match(matchesNameExtns) == null) {
                 alertModal("Error : " + uploadType + " file upload", "Invalid file selected! Please select for upload " + uploadType + " file in " + fileTypes + " format!");
                 return false;
             }

             return true;

         }

         function alertModal(title, body) {
              // Display error message to the user in a modal
              $('#alert-modal-title').html(title);
            $('#alert-modal-body').html(body);

            if (title.match("Error") == "Error") {
                $('#alert-modal-body').addClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-success");
            }

            else if (title == "Request added" || title == "Success") {
                $('#alert-modal-body').addClass("alert-success");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
            }
            else
            {
                $('#alert-modal-body').addClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-success");
            }
            
             $('#alert-modal').modal('show');
             $('#modalLoading').modal('hide');
         }

        
    </script>
    


    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                    <div class="col-md-3">
                        <center>
                        <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:200px; padding-top:10px">
                        </center>
                    </div>
                    <div class="col-md-9">
                        <h2 class="lblTopHeader"><i class="fa fa-university" aria-hidden="true"></i> Add a Bank account</h2>
                        <p>Add a Bank account with your Name which you will transact funds for trading.</p>
                    </div>
                </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">

                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div id="divChangeNewBank" runat="server" style="display:none">
                                        <div class="row" style="padding-top:10px;">
                                            <div class="col-sm-6">
                                                <h4>Same as present primary Bank? <input type="checkbox" onchange="SameAsPresentDetailsClick(this)" data-on="Yes" data-off="No" checked data-toggle="toggle"></h4>
                                            </div>
                                        </div>
                                      </div>
                                      <div class="row">
                                          <div class="col-md-7">
                                              <div class="form-outline flex-fill mb-0">
                                                <label class="form-label" for="txtIFSC"><i class="fa fa-university" aria-hidden="true"></i> IFSC Code*</label>
                                                 <div>
                                                  <div class="row">
                                                      <div class="col-sm-8">
                                                            <input type="text" class="form-control" id="txtBankIFSC" runat="server" placeholder="Type IFSC">
                                                       </div>
                                                      <div class="col-sm-4">
                                                            <asp:Button ID="btnFindBank" CssClass="btn btn-info" OnClientClick="findBank();" runat="server" OnClick="btnFindBank_Click" Text="Find Bank" />
                                                        </div>
                                                  </div>
                                                 </div>
                                              </div>
                                              <div class="form-outline flex-fill mb-0" style="padding-top:10px">
                                                <label class="form-label" for="cmbBanks"><i class="fa  fa-university" aria-hidden="true"></i> Select Bank* </label>
                                                <asp:DropDownList ID="cmbBanks" CssClass="form-control" runat="server">
                                                </asp:DropDownList>
                                              </div>
                                              <div class="form-outline flex-fill mb-0" style="padding-top:10px">
                                                  <label class="form-label" for="txtBankAccountNumber"><i class="fa fa-credit-card" aria-hidden="true"></i> Bank account number*</label>
                                                  <input type="number"  class="form-control" id="txtBankAccountNumber" maxlength="20" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Bank account number">
                                               </div>
                                               <div class="form-outline flex-fill mb-0">
                                                  <label class="form-label" for="txtConfirmBankAccountNumber"><i class="fa fa-credit-card" aria-hidden="true"></i> Confirm bank account number*</label>
                                                  <input type="number"  class="form-control" id="txtConfirmBankAccountNumber" maxlength="20" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Confirm bank account number">
                                               </div>
                                              <div id="divBankValidation" runat="server">
                                                  <input type="hidden" id="hdnBankValidation" name="hdnBankValidation" runat="server" value="">
                                                  <div class="form-outline flex-fill mb-0" style="padding-top:10px">
                                                      <label for="selectBankValidationType" class="form-label"><i class="fa fa-upload" aria-hidden="true"></i> Upload file for account verification*:</label>
                                                      <div>
                                                          <div class="row">
                                                            <div class="col-sm-6">
                                                                <select class="form-control" id="selectBankVerificationType" runat="server">
                                                                    <option>Canceled Cheque</option>
                                                                    <option>Passbook 1st Page</option>
                                                                </select>
                                                             </div>
                                                            <div class="col-sm-6" style="padding-left:30px; padding-top:10px">
                                                                <div class="form-group">
                                                                   <!-- <input type="file" class="form-control-file border" name="bankVerificationFile" id="bankVerificationFile" accept='.jpg,.png,.jpeg'>-->
                                                                    <ajaxToolkit:AsyncFileUpload ID="bankVerificationAsyncFile" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="bankVerificationAsyncFile_UploadedComplete" runat="server" />
                                                                    <span id="spanBankVerificationFileUpload" runat="server"></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                          <div class="col-md-5">
                                             <h2 id="hFullName" runat="server"></h2>
                                              <p>
                                              Date of Birth : <u><span id="spanDOB" runat="server"></span></u>
                                              <br />
                                               PAN : <u><span id="spanPAN" runat="server"></span></u>
                                               <br />
                                               Aaadhaar : <u><span id="spanAadhaar" runat="server"></span></u>
                                             </p>
                                             <br />
                                             <p>
                                                 <b><span id="spanBrokerName" runat="server">Standard Broker</span></b> for conducting online KYC for reactivation trading and demat account
                                             </p>
                                             <p>
                                                The Aadhaar and the PAN should belong to you and your name, dob also must match in both documents Aadhaar and PAN , if it does not, then you can resolve the name mismatch issue by changing your name on the PAN Card from <a href="https://www.onlineservices.nsdl.com/paam/endUserRegisterContact.html">NSDL</a>  or on the Aadhaar Card from <a href="https://www.uidai.gov.in">UIDAI</a>.
                                             </p>
                                             <p>
                                                Your Aadhaar number is never visible or available to us.
                                             </p>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                              <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                  <button type="button" class="btn btn-success btn-lg" id="btnContinue" onclick="addBank();" runat="server" ><i class="fa fa-check" aria-hidden="true"></i> Save and Continue</button>
                                  
                                  <p>
                                      <br />
                                      <i>
                                        *By clicking the above button, I agree that i have read <a href="#">Terms & Conditions</a>.
                                      </i>
                                  </p>
                                  <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                  </div>
                                  <br />
                                  <br />
                              </div>
                           </ContentTemplate>
                        </asp:UpdatePanel>
                          <hr />
                          <div id="divPreviousSteps" runat="server">
                                <h4>Go to previous step </h4> 
                                <ul class="list-inline">
                                <li><a href="contact.aspx"><i class="fas fa-envelope fa-lg me-3 fa-fw" aria-hidden="true"></i> Contact</a></li>
                                <li><a href="DigiLockerKYC.aspx" id="hlinkDigiLocker" runat="server"><i class="fa fa-cloud-download" aria-hidden="true"></i> DigiLocker</a></li>
                                <li><a href="manuallyProcessing.aspx" id="hlinkAddress" runat="server"><i class="fa fa-id-card" aria-hidden="true"></i> Address</a></li>
                                <li><a href="capturePhoto.aspx" id="hlinkCapturePhoto" runat="server"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                <li><a href="profile.aspx" id="hlinkIncomeProfile" runat="server"><i class="fa fa-inr" aria-hidden="true"></i> Income Profile</a></li>
                                <li><a href="TradingPreference.aspx" id="hlinkTradingPreference" runat="server"><i class="fa fa-exchange" aria-hidden="true"></i> Trading Preference</a></li>
                                </ul>
                            </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
			    </div>
             </div>

          </div>
        </section>
    </form>
     <div id="alert-modal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="alert-modal-title" class="modal-title"></h4>
              </div>
              <div id="alert-modal-body" class="modal-body"></div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">OK</button>
              </div>
            </div>
          </div>
        </div>

    <div class="modal fade" id="modalLoading" tabindex="-1" role="dialog" aria-labelledby="modalLoadingLabel">
      <div class="modal-dialog modal-md">
        <div class="modal-content">
          <div class="modal-header">
          </div>
          <div class="modal-body">
              <center>
                    <h4>Please wait..Your request is being processed..</h4>
                    <p>Do not close browser window....</p>
                    <img src="../ekyc/images/Loading.gif" alt="Loading" style="width:150px;" />
               </center>
          </div>

          <div class="modal-footer">
          </div>
        </div>
      </div>
    </div>

</body>
</html>
