﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ConfirmDetails.aspx.cs" Inherits="Connect_DotNet.ReActivation.ConfirmDetails" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>Account Reactivation</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <style>
        .margineTop10{
            margin-top:10px
        }

    </style>

</head>
<body>
    <script>
        
        function requestData(reqType) {

            document.getElementById('hdnBtnRequestClicked').value = reqType;
             $('#modalLoading').modal('show');
             document.getElementById('<%= btnRequest.UniqueID %>').click();

        }

        function continueForchanges() {
            if (document.getElementById('optionMobile').checked == false &&
                document.getElementById('optionEmail').checked == false &&
                document.getElementById('optionAddress').checked == false &&
                document.getElementById('optionIncome').checked == false) {
                alertModal("Error - Option not selected", "Please choose minimum one parameter that you need to be changed!","danger");
                return;

            }

            var changesParameters = "";

            if (document.getElementById('optionMobile').checked == true) {
                changesParameters = "Mobile";
            }
            
            if (document.getElementById('optionEmail').checked == true) {
                
                changesParameters = changesParameters+getCommaByValue(changesParameters) + "Email";
            }
            if (document.getElementById('optionAddress').checked == true) {
                changesParameters = changesParameters+getCommaByValue(changesParameters) + "Address";
            }
            if (document.getElementById('optionIncome').checked == true) {
                changesParameters = changesParameters+getCommaByValue(changesParameters) + "Income";
            }
                        
            document.getElementById('hdnBtnRequestClicked').value = changesParameters;
             $('#modalLoading').modal('show');
             document.getElementById('<%= btnRequest.UniqueID %>').click();
        }

        function getCommaByValue(changesParams) {

            if (changesParams != "") {
                return ",";
            }

            return "";
        }

         function alertModal(title, body, alertType) {
              // Display error message to the user in a modal
              $('#alert-modal-title').html(title);
                 $('#alert-modal-body').html(body);

            if (alertType == "danger") {
                $('#alert-modal-body').addClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-success");
            }

            else if (alertType == "success") {
                $('#alert-modal-body').addClass("alert-success");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
            }
            else
            {
                $('#alert-modal-body').addClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-success");
            }
            
             $('#alert-modal').modal('show');
             $('#modalLoading').modal('hide');
        }

    </script>
    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <section class="vh-100">
            <div class="container h-100">
                <div class="row">
                    <div class="col-md-3">
                        <center>
                        <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:200px; padding-top:10px">
                        </center>
                    </div>
                    <div class="col-md-9">
                        <h2 class="lblTopHeader"><i class="fa fa-user" aria-hidden="true"></i> Process for Account Reactivation</h2>
                        <p id="paraTitle" runat="server">Your account is <b>Inactive</b>. Your last trade date was [<span id="spanLastTradeDt" style="font-weight:bold" runat="server"></span>]. Please reactivate your account.</p>
                    </div>
                </div>
                 <div class="row d-flex justify-content-center align-items-center">
                    <div class="col-lg-12 col-xl-11">
                        <div class="card text-black" style="border-radius: 25px;">
                            <div class="card-body p-md-5" id="divMain" runat="server">
                                <div class="d-flex flex-row align-items-center mb-4">
                                    <div class="row justify-content-center">
                                        <div class="col-md-10 col-lg-10">
                                            <div class="progress">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                                                </div>
                                            </div>
                                            <div class="modal-dialog" style="width:100%">
                                                <!-- Modal content-->
                                                <div class="modal-content">
                                                  <div class="modal-body">
                                                    <div id="divDetails">
                                                        <div class="row justify-content-center">
                                                            <div class="col-lg-6">
                                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                                <label class="form-label" for="txtPAN"><i class="fa-solid fa-id-card"></i> PAN</label>
                                                                <input type="text"  class="form-control" id="txtPAN" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" readonly="readonly" placeholder="NA">
                                                              </div>
                                                            </div>
                                                            <div class="col-lg-6">
                                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                                <label class="form-label" for="txtUCC"><i class="fas fa-user fa-lg me-3 fa-fw"></i> UCC</label>
                                                                <input type="text"  class="form-control" id="txtUCC" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" readonly="readonly" placeholder="NA">
                                                              </div>
                                                            </div>
                                                        </div>
                                                        <div class="row justify-content-center">
                                                            <div class="col-lg-12">
                                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                                <label class="form-label" for="txtName"><i class="fas fa-user fa-lg me-3 fa-fw"></i> Name</label>
                                                                <input type="text"  class="form-control" id="txtName" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" readonly="readonly" placeholder="NA">
                                                              </div>
                                                            </div>
                                                        </div>
                                                        <div class="row justify-content-center">
                                                            <div class="col-lg-6">
                                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                                  <label class="form-label" for="txtMobile"><i class="fas fa-mobile fa-lg me-3 fa-fw"></i> Mobile</label>
                                                                  <input type="number"  class="form-control" id="txtMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" readonly="readonly" placeholder="NA">
                                                              </div>
                                                            </div>
                                                            <div class="col-lg-6">
                                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                                  <label class="form-label" for="txtEmail"><i class="fas fa-envelope fa-lg me-3 fa-fw"></i> Email</label>
                                                                  <input type="email"  class="form-control" id="txtEmail" maxlength="300" runat="server" readonly="readonly" placeholder="NA">
                                                              </div>
                                                            </div>
                                                        </div>
                                                        <div class="row justify-content-center">
                                                            <div class="col-lg-6">
                                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                                  <label class="form-label" for="txtAddress"><i class="fa-solid fa-address-card"></i> Address</label>
                                                                  <textarea class="form-control" id="txtAddress" maxlength="500" rows="4" runat="server" readonly="readonly" placeholder="NA"/>
                                                              </div>
                                                            </div>
                                                            <div class="col-lg-6">
                                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                                  <label class="form-label" for="txtAnualIncome"><i class="fa-solid fa-inr"></i> Anual Income Range</label>
                                                                  <input type="text"  class="form-control" id="txtAnualIncome" runat="server" readonly="readonly" placeholder="NA">
                                                              </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                  </div>
                                                  <div class="modal-footer" style="text-align:left">
                                                      <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                                                        <ContentTemplate>
                                                            <div id="divProceedToAll"  style="display:none" runat="server">
                                                                <h4 style="color:red">Your account been <b>Inactive</b> for more than 2 years. Your last trade date was [<span id="spanLastTradeDate" style="font-weight:bold" runat="server"></span>].</h4>
                                                                <button type="button" class="btn btn-lg btn-primary margineTop10" onclick="requestData('All')"><i class="fa-solid fa-check"></i> Continue to Reactivate your account</button>
                                                            </div>
                                                            <div id="divButtons"  runat="server">
                                                                <h4>Is the above information is correct? If correct, please select 'Yes'; otherwise, select 'No' for make any changes.</h4>
                                                                <div style="text-align:center">
                                                                <button type="button" class="btn btn-lg btn-danger margineTop10" data-toggle="modal" data-target="#modalSelectChanges"><i class="fa-solid fa-times"></i> No, above information is not correct</button>
                                                                <button type="button" class="btn btn-lg btn-success margineTop10" onclick="requestData('Sent OTP')"><i class="fa-solid fa-check"></i> Yes, above information is correct</button>
                                                                </div>
                                                            </div>
                                                            <div style="display:none">
                                                                <asp:Button ID="btnRequest" runat="server" Text="" OnClick="btnRequest_Click" /> 
                                                                <input type="hidden" id="hdnBtnRequestClicked" name="hdnBtnRequestClicked" runat="server" value="">
                                                            </div>
                                                            <div id="divOTP"  runat="server"  style="display:none">
                                                                <h2 class="lblTopHeader">Verify your Mobile and Email <i class="fas fa-envelope fa-lg me-3 fa-fw"></i></h2>
                                                                <h5 style="color:green" id="msgOTPSentSuccessfully" runat="server">OTP has been sent successfully to your Mobile number and Email id.</h5>
                                                                <div class="row justify-content-center">
                                                                <div class="col-lg-6">
                                                                    <div class="form-outline flex-fill mb-0 margineTop10">
                                                                        <label class="form-label" for="txtMobileOTP"><i class="fas fa-mobile fa-lg me-3 fa-fw"></i> Mobile OTP</label>
                                                                        <input type="number" class="form-control" id="txtMobileOTP" maxlength="6" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Mobile OTP">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-6">
                                                                    <div class="form-outline flex-fill mb-0 margineTop10">
                                                                        <label class="form-label" for="txtEmailOTP"><i class="fas fa-envelope fa-lg me-3 fa-fw"></i> Email OTP</label>
                                                                        <input type="number" class="form-control" id="txtEmailOTP" maxlength="6" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Email OTP">
                                                                        
                                                                    </div>
                                                                </div>
                                                                </div>
                                                          
                                                                <div style="text-align:left">
                                                                    <button type="button" class="btn btn-lg btn-success margineTop10" id="btnOTPEmailValidate" onclick="requestData('Validate OTP')"><i class="fa fa-check" aria-hidden="true"></i> Verify and confirm</button>
                                                                    <button type="button" class="btn btn-lg btn-primary margineTop10" id="btnOTPEmailResend" onclick="requestData('Sent OTP')"><i class="fa fa-repeat" aria-hidden="true"></i> Resend OTP</button>
                                                                </div>
                                                                <br />
                                                                <br />
                                                                <span id="spanDebugOTP" runat="server" style="display:none"></span>
                                                            </div>
                                                        </ContentTemplate>
                                                      </asp:UpdatePanel>
                                                  </div>
                                                </div>

                                              </div>
                                            <div class="progress">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                                                </div>
                                            </div>
                                        </div>
                                   </div>
                                 </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div id="divErrorMsg" runat="server" style="margin-top:20px; height: 100%; display:none; width: 100%; text-align: center;">
                                        <div class="alert alert-danger" role="alert">
				                            <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span> <span id="spanError" runat="server"></span>
			                            </div>
                                        <div id="divLinkReKYCStatus" style="display:none" runat="server">
                                            <a id="linkReKYCStatus" runat="server" class="btn btn-info btn-lg">Go to ReKYC Status</a>
                                        </div>
		                            </div>
                                </div>
                           </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6" >

                    </div>
                    <div class="col-sm-6 poweredBy" style="text-align:right;">
                        <span style="font-size:small;text-align:right">Powered by</span></br>
				        <a href="http://www.stansoftware.com">
					        <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						        </a>
			        </div>
                 </div>
            </div>
        </section>
        <div id="modalSelectChanges" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modalSelectChanges-title" class="modal-title">Please choose which parameter(s) need to be changed</h4>
              </div>
              <div id="modalSelectChanges-body" class="modal-body">
                  <div class="form-check">
                      <label class="form-check-label" for="optionMobile">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionMobile" name="optionMobile" value="Mobile">&nbsp;Mobile
                      </label>
                    </div>
                    <div class="form-check">
                      <label class="form-check-label" for="optionEmail">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionEmail" name="optionEmail" value="Email">&nbsp;Email
                      </label>
                    </div>
                    <div class="form-check">
                      <label class="form-check-label" for="optionAddress">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionAddress" name="optionAddress" value="Address">&nbsp;Address
                      </label>
                    </div>
                    <div class="form-check">
                      <label class="form-check-label" for="optionAddress">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionIncome" name="optionIncome" value="Income">&nbsp;Income
                      </label>
                    </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-lg btn-primary" onclick="continueForchanges();"><i class="fa-solid fa-check"></i> Continue</button>
              </div>
            </div>
          </div>
        </div>
    </form>
    
    <div id="alert-modal" class="modal fade">
        <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 id="alert-modal-title" class="modal-title"></h4>
            </div>
            <div id="alert-modal-body" class="modal-body"></div>
            <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">OK</button>
            </div>
        </div>
        </div>
    </div>
    
    <div class="modal fade" id="modalLoading" tabindex="-1" role="dialog" aria-labelledby="modalLoadingLabel">
      <div class="modal-dialog modal-md">
        <div class="modal-content">
          <div class="modal-header">
          </div>
          <div class="modal-body">
              <center>
                    <h4>Please wait..Your request is being processed..</h4>
                    <p>Do not close browser window....</p>
                    <img src="../ekyc/images/Loading.gif" alt="Loading" style="width:150px;" />
               </center>
          </div>

          <div class="modal-footer">
          </div>
        </div>
      </div>
    </div>

</body>
</html>
