﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="DigiLockerKYC.aspx.cs" Inherits="Connect_DotNet.ReActivation.DigiLockerKYC" %>

<!DOCTYPE html>

<html>
<head>
  <title>Aadhaar KYC (DigiLocker)</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
      <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />
</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }
    </style>
     <script>

           window.onload = function () {

             if (document.getElementById('hdnMsgModalOpen').value != "") {

                 const hdnMsgModalOpenArray = document.getElementById('hdnMsgModalOpen').value.split("####");
                 var titleMsg = hdnMsgModalOpenArray[0];
                 var Msg = hdnMsgModalOpenArray[1];

                 document.getElementById('hdnMsgModalOpen').value = "";
                 alertModal(titleMsg, Msg);

             }
             
         }


          function ContinueDigiLocker(type) {
              document.getElementById('hdnBtnContinueClicked').value = type;

              $('#modalLoading').modal('show');
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
             
         }

         

         function alertModal(title, body) {
              // Display error message to the user in a modal
              $('#alert-modal-title').html(title);
            $('#alert-modal-body').html(body);

            if (title.match("Error") == "Error") {
                $('#alert-modal-body').addClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-success");
            }

            else if (title == "Request added") {
                $('#alert-modal-body').addClass("alert-success");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
            }
            else
            {
                $('#alert-modal-body').addClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-success");
            }
            
             $('#alert-modal').modal('show');
             $('#modalLoading').modal('hide');
         }

        
    </script>
    


    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                    <div class="col-md-3">
                        <center>
                        <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:200px; padding-top:10px">
                        </center>
                    </div>
                    <div class="col-md-9">
                        <h2 class="lblTopHeader"><i class="fa fa-user" aria-hidden="true"></i> Connect to DigiLocker</h2>
                        <p>Fetch your data from aadhaar, PAN via digilocker.</p>
                    </div>
                </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">
                          <input type="hidden" id="hdnMsgModalOpen" name="hdnMsgModalOpen" runat="server" value="">
                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div class="row">
                                          <div class="col-md-7">
                                              <h3><i class="fa fa-cloud-download" aria-hidden="true"></i> Fetch aadhaar, PAN from DigiLocker for reKYC</h3>
                                              <p>
                                                  Share your aadhaar related information from DigiLocker account for KYC. Your Aadhaar number/copy will not be stored.
                                              </p>
                                             <p>
                                                The Aadhaar <b><span id="spanAadhaar" runat="server"></span></b> and the PAN <b><span id="spanPAN" runat="server"></span></b> should belong to you, the applicant, if it does not, your application will be rejected.
                                             </p>
                                              <p>
                                                  Your name <b><span id="spanName" runat="server"></span></b> also must match in both documents Aadhaar and PAN , if it does not, then you can resolve the name mismatch issue by changing your name on the PAN Card from <a href="https://www.onlineservices.nsdl.com/paam/endUserRegisterContact.html">NSDL</a>  or on the Aadhaar Card from <a href="https://www.uidai.gov.in">UIDAI</a>.
                                              </p>
                                          </div>
                                          <div class="col-md-5">
                                              <h4>What is DigiLocker</h4>
                                              <p>
                                                  DigiLocker is a digitization service provided by the Indian Ministry of Electronics and Information Technology under its Digital India initiative. DigiLocker allows access to digital versions of various documents
                                              </p>
                                              
                                              <h4>Why do we need your Aadhaar?</h4>
                                              <p>
                                                  Name, Gender, Address and Date of Birth from Aadhaar for KYC registration
                                              </p>
                                              <p>
                                                Your Aadhaar number is never visible or available to us
                                              </p>

                                          </div>
                                      </div>
                                  </div>
                              </div>
                              <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                 <button type="button" class="btn btn-success btn-lg" id="btnContinue" onclick="ContinueDigiLocker('DigiLocker');" style="margin-top:5px" runat="server" ><i class="fa fa-cloud-download" aria-hidden="true"></i> Continue with DigiLocker</button>
                                  <span style="font-size:18px; font-weight:bold;">OR <a class="link-secondary" href="manuallyProcessing.aspx" id="btnManually" style="font-size:14px"> <i class="fa fa-edit" aria-hidden="true"></i> <u>Go through Manually</u></a></span> 
                                  
                                  <p>
                                      <br />
                                      <i>
                                        *By clicking the above 'Continue with DigiLocker' button, I agree that i have read <a href="#">Aadhaar user consent document</a> an voluntarily consent to share my Aadhaar information (excluding the Aadhaar number) with <b><span id="spanBrokerName" runat="server">Standard Broker</span></b> for conducting online KYC for openinig a trading and demat account adhering to KRA regulation 2011 and PMLA guidelines 2002.
                                      </i>
                                  </p>
                                  <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                  </div>
                                  <br />
                                  <br />
                              </div>

                            </ContentTemplate>
                        </asp:UpdatePanel>
                          <hr />
                          <h4>Go to previous step </h4> 
                            <ul class="list-inline">
                                <li><a href="contact.aspx"><i class="fas fa-envelope fa-lg me-3 fa-fw" aria-hidden="true"></i> Contact</a></li>
                            </ul>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
 
              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
			    </div>
             </div>

          </div>
        </section>
    </form>
     <div id="alert-modal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="alert-modal-title" class="modal-title"></h4>
              </div>
              <div id="alert-modal-body" class="modal-body"></div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">OK</button>
              </div>
            </div>
          </div>
        </div>
    
    <div class="modal fade" id="modalLoading" tabindex="-1" role="dialog" aria-labelledby="modalLoadingLabel">
      <div class="modal-dialog modal-md">
        <div class="modal-content">
          <div class="modal-header">
          </div>
          <div class="modal-body">
              <center>
                    <h4>Please wait..Your request is being processed..</h4>
                    <p>Do not close browser window....</p>
                    <img src="../ekyc/images/Loading.gif" alt="Loading" style="width:150px;" />
               </center>
          </div>

          <div class="modal-footer">
          </div>
        </div>
      </div>
    </div>

</body>
</html>
