﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Nomination.aspx.cs" Inherits="Connect_DotNet.ReActivation.Nomination" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<!DOCTYPE html>

<html>
<head runat="server">
  <title>Nomination</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
    <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
  
        <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />

</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }
    </style>
     <script>

         window.onload = function () {
            
         }

         function pageLoad(sender, args) {

             if (document.getElementById('hdnActivaTab').value != "") {
                 activaTab(document.getElementById('hdnActivaTab').value);
                 document.getElementById('hdnActivaTab').value = "";
             }
         }

          function SameAsPresentDetailsClick(chkbxSameDetails) {
              if (chkbxSameDetails.checked == false) {

                  document.getElementById("selectNom1Prefix").value = "";
                  document.getElementById("txtNom1Name").value = "";
                  document.getElementById("txtNom1Relation").value = "";
                  document.getElementById("txtNom1Percent").value = "";
                  document.getElementById("txtNom1Add1").value = "";
                  document.getElementById("txtNom1Add2").value = "";
                  document.getElementById("txtNom1Add3").value = "";
                  document.getElementById("txtNom1City").value = "";
                  document.getElementById("txtNom1Pincode").value = "";
                  document.getElementById("cmbNom1State").value = "";
                  document.getElementById("cmbNom1Country").value = "";
                  document.getElementById("txtNom1Mobile").value = "";
                  document.getElementById("txtNom1Email").value = "";
                  document.getElementById("cmbNom1IdType").value = "";
                  document.getElementById("txtNom1IDNo").value = "";
                  document.getElementById("dtNom1DateofBirth").value = "";
                  document.getElementById("chkNom1IsMinor").value = "";
                  document.getElementById("selectNom1MinorGuardianPrefix").value = "";
                  document.getElementById("txtNom1MinorGuardianName").value = "";
                  document.getElementById("txtNom1MinorGuardianRelation").value = "";
                  document.getElementById("txtNom1MinorGuardianAdd1").value = "";
                  document.getElementById("txtNom1MinorGuardianAdd2").value = "";
                  document.getElementById("txtNom1MinorGuardianAdd3").value = "";
                  document.getElementById("txtNom1MinorGuardianCity").value = "";
                  document.getElementById("txtNom1MinorGuardianPincode").value = "";
                  document.getElementById("cmbNom1MinorGuardianState").value = "";
                  document.getElementById("cmbNom1MinorGuardianCountry").value = "";
                  document.getElementById("txtNom1MinorGuardianMobile").value = "";
                  document.getElementById("txtNom1MinorGuardianEmail").value = "";
                  document.getElementById("cmbNom1MinorGuardianIdType").value = "";
                  document.getElementById("txtNom1MinorGuardianIDNo").value = "";

                  document.getElementById("selectNom2Prefix").value = "";
                  document.getElementById("txtNom2Name").value = "";
                  document.getElementById("txtNom2Relation").value = "";
                  document.getElementById("txtNom2Percent").value = "";
                  document.getElementById("txtNom2Add1").value = "";
                  document.getElementById("txtNom2Add2").value = "";
                  document.getElementById("txtNom2Add3").value = "";
                  document.getElementById("txtNom2City").value = "";
                  document.getElementById("txtNom2Pincode").value = "";
                  document.getElementById("cmbNom2State").value = "";
                  document.getElementById("cmbNom2Country").value = "";
                  document.getElementById("txtNom2Mobile").value = "";
                  document.getElementById("txtNom2Email").value = "";
                  document.getElementById("cmbNom2IdType").value = "";
                  document.getElementById("txtNom2IDNo").value = "";
                  document.getElementById("dtNom2DateofBirth").value = "";
                  document.getElementById("chkNom2IsMinor").value = "";
                  document.getElementById("selectNom2MinorGuardianPrefix").value = "";
                  document.getElementById("txtNom2MinorGuardianName").value = "";
                  document.getElementById("txtNom2MinorGuardianRelation").value = "";
                  document.getElementById("txtNom2MinorGuardianAdd1").value = "";
                  document.getElementById("txtNom2MinorGuardianAdd2").value = "";
                  document.getElementById("txtNom2MinorGuardianAdd3").value = "";
                  document.getElementById("txtNom2MinorGuardianCity").value = "";
                  document.getElementById("txtNom2MinorGuardianPincode").value = "";
                  document.getElementById("cmbNom2MinorGuardianState").value = "";
                  document.getElementById("cmbNom2MinorGuardianCountry").value = "";
                  document.getElementById("txtNom2MinorGuardianMobile").value = "";
                  document.getElementById("txtNom2MinorGuardianEmail").value = "";
                  document.getElementById("cmbNom2MinorGuardianIdType").value = "";
                  document.getElementById("txtNom2MinorGuardianIDNo").value = "";

                  document.getElementById("selectNom3Prefix").value = "";
                  document.getElementById("txtNom3Name").value = "";
                  document.getElementById("txtNom3Relation").value = "";
                  document.getElementById("txtNom3Percent").value = "";
                  document.getElementById("txtNom3Add1").value = "";
                  document.getElementById("txtNom3Add2").value = "";
                  document.getElementById("txtNom3Add3").value = "";
                  document.getElementById("txtNom3City").value = "";
                  document.getElementById("txtNom3Pincode").value = "";
                  document.getElementById("cmbNom3State").value = "";
                  document.getElementById("cmbNom3Country").value = "";
                  document.getElementById("txtNom3Mobile").value = "";
                  document.getElementById("txtNom3Email").value = "";
                  document.getElementById("cmbNom3IdType").value = "";
                  document.getElementById("txtNom3IDNo").value = "";
                  document.getElementById("dtNom3DateofBirth").value = "";
                  document.getElementById("chkNom3IsMinor").value = "";
                  document.getElementById("selectNom3MinorGuardianPrefix").value = "";
                  document.getElementById("txtNom3MinorGuardianName").value = "";
                  document.getElementById("txtNom3MinorGuardianRelation").value = "";
                  document.getElementById("txtNom3MinorGuardianAdd1").value = "";
                  document.getElementById("txtNom3MinorGuardianAdd2").value = "";
                  document.getElementById("txtNom3MinorGuardianAdd3").value = "";
                  document.getElementById("txtNom3MinorGuardianCity").value = "";
                  document.getElementById("txtNom3MinorGuardianPincode").value = "";
                  document.getElementById("cmbNom3MinorGuardianState").value = "";
                  document.getElementById("cmbNom3MinorGuardianCountry").value = "";
                  document.getElementById("txtNom3MinorGuardianMobile").value = "";
                  document.getElementById("txtNom3MinorGuardianEmail").value = "";
                  document.getElementById("cmbNom3MinorGuardianIdType").value = "";
                  document.getElementById("txtNom3MinorGuardianIDNo").value = "";

              }
             else {
                 setTimeout(function () {
                     location.reload();
                 }, 200);
             }
         }

         function setMinorAddressSameAsNominee(isChecked, slno) {
             //alert(slno);

             if (isChecked == true) {
                 document.getElementById('txtNom' + slno + 'MinorGuardianAdd1').value = document.getElementById('txtNom' + slno + 'Add1').value;
                 document.getElementById('txtNom' + slno + 'MinorGuardianAdd2').value = document.getElementById('txtNom' + slno + 'Add2').value;
                 document.getElementById('txtNom' + slno + 'MinorGuardianAdd3').value = document.getElementById('txtNom' + slno + 'Add3').value;
                 document.getElementById('txtNom' + slno + 'MinorGuardianCity').value = document.getElementById('txtNom' + slno + 'City').value;
                 document.getElementById('txtNom' + slno + 'MinorGuardianPincode').value = document.getElementById('txtNom' + slno + 'Pincode').value;
                 document.getElementById('cmbNom' + slno + 'MinorGuardianState').value = document.getElementById('cmbNom' + slno + 'State').value;
                 document.getElementById('cmbNom' + slno + 'MinorGuardianCountry').value = document.getElementById('cmbNom' + slno + 'Country').value;
             }
             else {
                 document.getElementById('txtNom' + slno + 'MinorGuardianAdd1').value = "";
                 document.getElementById('txtNom' + slno + 'MinorGuardianAdd2').value = "";
                 document.getElementById('txtNom' + slno + 'MinorGuardianAdd3').value = "";
                 document.getElementById('txtNom' + slno + 'MinorGuardianCity').value = "";
                 document.getElementById('txtNom' + slno + 'MinorGuardianPincode').value = "";
                 document.getElementById('cmbNom' + slno + 'MinorGuardianState').value = "";
                 document.getElementById('cmbNom' + slno + 'MinorGuardianCountry').value = "IN";
             }

             

         }

         function IsMobileNumber(number) {
                var val = number.value
                if (/^\d{10}$/.test(val)) {
                    // value is ok, use it
                    return true
                } else {
                    alertModal("Error", "Invalid number; must be 10 digits!");
                    number.focus()
                    return false
                }
         }

         function optoutNomination() {
             
             if (document.getElementById('selectMakeNominees').value == "No") {
                 document.getElementById('btnContinue').style.display = "none";
                 document.getElementById('divOptOutNominees').style.display = "block";
                 document.getElementById('divNominees').style.display = "none";
                 $('#confirmOptoutNominationModal').modal('show');
             }
             else {
                 cancelOptoutNomination();
             }
   
         }

         function cancelOptoutNomination() {
             document.getElementById('selectMakeNominees').value = "Yes";
             document.getElementById('btnContinue').style.display = "block";
             document.getElementById('divOptOutNominees').style.display = "none";
             document.getElementById('divNominees').style.display = "block";
         }

         function activaTab(tab){
              $('.nav-tabs a[href="#' + tab + '"]').tab('show');
            };

         function getAge(DOB) {
            var today = new Date();
            var birthDate = new Date(DOB);
            var age = today.getFullYear() - birthDate.getFullYear();
            var m = today.getMonth() - birthDate.getMonth();
            if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
                age--;
            }
            return age;
         }

         function saveNomination(operation) {

             //saveNomination("Opt Out")
             //saveNomination("Add Nominee")

             if (operation == "Add Nominee") {

                 if (addNominees() == false) {
                     return;
                 }

             }
             else if (operation != "Opt Out") {
                 return;
             }

             document.getElementById('hdnBtnContinueClicked').value = operation; // Opt Out | Add Nominee
             $('#modalLoading').modal('show');

             document.getElementById('<%= btnContinueClick.UniqueID %>').click();

         }
         

         function addNominees() {

             if (validateNominee(1) == false) {
                 return false;
             }


             if (document.getElementById('txtNom1Name').value != '' &&
                 document.getElementById('txtNom2Name').value != '') {

                 if (validateNominee(2) == false) {
                     return false;
                 }
             }
             

             if (document.getElementById('txtNom1Name').value != '' &&
                 document.getElementById('txtNom2Name').value != '' &&
                 document.getElementById('txtNom3Name').value != '') {

                 if (validateNominee(3) == false) {
                     return false;
                 }
             }

             if (Number(document.getElementById('hdnNomResidualPercent').value)>0) {

                 alertModal("Error : Nominations share available!", document.getElementById('hdnNomResidualPercent').value + "% nominations share available! Total nominations share should be made 100%");
                 return false;
             }

             return true;


         }

         function validateNominee(nomNo) {

             if (document.getElementById('txtNom' + nomNo + 'Name').value == '') {
                 alertModal("Error : Nominee " + nomNo, "Please enter Nominee Name!");
                 return false;
             }

             if (document.getElementById('txtNom'+nomNo+'Percent').value == "" || document.getElementById('txtNom'+nomNo+'Percent').value == "0.00") {
                 alertModal("Error : Nominee "+nomNo, "Please enter Nominee Percent 1 to 100!");
                 return false;
             }

             
             //alert('hdnNominee' + nomNo + 'Share' + document.getElementById('hdnNominee' + nomNo + 'Share').value);
             //alert('hdnNomResidualPercent' + document.getElementById('hdnNomResidualPercent').value);
             
             var NomResidualPercent = Number(document.getElementById('hdnNomResidualPercent').value) + Number(document.getElementById('hdnNominee' + nomNo + 'Share').value);

             //alert('NomResidualPercent' + NomResidualPercent);
             
             if (document.getElementById('txtNom'+nomNo+'Percent').value < 1 || document.getElementById('txtNom'+nomNo+'Percent').value > NomResidualPercent) {

                 if (Number(NomResidualPercent) == 0) {
                     alertModal("Error : Nominee "+nomNo, "Total 100 percent nominee share already completed!");
                     return false;
                 }

                 alertModal("Error : Nominee "+nomNo, "Please enter Nominee Percent 1 to " + NomResidualPercent);
                 return false;
             }


             if (document.getElementById('txtNom'+nomNo+'Add1').value == "") {
                 alertModal("Error : Nominee "+nomNo, "Please enter Nominee Address"+nomNo+"!");
                 return false;
             }
             if (document.getElementById('txtNom'+nomNo+'Pincode').value == "") {
                 alertModal("Error : Nominee "+nomNo, "Please enter Nominee Pincode!");
                 return false;
             }

             if (document.getElementById('cmbNom'+nomNo+'State').value == "") {
                 alertModal("Error : Nominee "+nomNo, "Please select Nominee State!");
                 return false;
             }

             if (document.getElementById('cmbNom'+nomNo+'Country').value == "") {
                 alertModal("Error : Nominee "+nomNo, "Please enter Nominee Country!");
                 return false;
             }

             if (document.getElementById('txtNom'+nomNo+'IDNo').value == "") {
                 alertModal("Error : Nominee "+nomNo, "Please enter valid document ID!");
                 return false;
             }

             if (document.getElementById('txtNom'+nomNo+'Mobile').value != "") {
                 if (!IsMobileNumber(document.getElementById('txtNom'+nomNo+'Mobile')))
                     return false;
             }

             if (document.getElementById('txtNom'+nomNo+'Email').value != "") {
                 if (!ValidateEmail(document.getElementById('txtNom'+nomNo+'Email')))
                     return false;
             }

             if (validateFileExtensionByFileName(document.getElementById('spannom'+nomNo+'DocAsyncFileUpload').innerHTML, "Nominee"+nomNo+" Id Proof", "JPG,PNG,JPEG,PDF") == false) {
                 return false;
             }

             if (document.getElementById('dtNom'+nomNo+'DateofBirth').value == "") {
                 alertModal("Error : Nominee "+nomNo, "Please enter Nominee Date of Birth!");
                 return false;
             }

             var enteredAge = getAge(document.getElementById('dtNom'+nomNo+'DateofBirth').value);

             if (enteredAge > 17 && document.getElementById('chkNom'+nomNo+'IsMinor').checked) {
                 alertModal("Error : Nominee "+nomNo, "Date of Birth not valid! Nominee's age is not minor nominee! A nominee who is under the legal age that is 18 years of age is known as a minor nominee");
                 return false
             }

             if (enteredAge < 18 && !document.getElementById('chkNom'+nomNo+'IsMinor').checked) {
                 alertModal("Error : Nominee "+nomNo, "Date of Birth not valid! Nominee's age is minor nominee! A nominee who is under the legal age that is 18 years of age is known as a minor nominee. Please fill out minor nominee guardian details");
                 return false
             }

             if (document.getElementById('chkNom'+nomNo+'IsMinor').checked) {

                 activaTab('ModalNominee'+nomNo+'MinorGuardianTab');

                 if (document.getElementById('txtNom'+nomNo+'MinorGuardianName').value == "") {
                     alertModal("Error : Nominee "+nomNo, "Please enter Minor Nominee Guardian Name!");
                     return false;
                 }

                 if (document.getElementById('txtNom'+nomNo+'MinorGuardianAdd'+nomNo+'').value == "") {
                     alertModal("Error : Nominee "+nomNo, "Please enter Minor Nominee Guardian Address"+nomNo+"!");
                     return false;
                 }
                 if (document.getElementById('txtNom'+nomNo+'MinorGuardianPincode').value == "") {
                     alertModal("Error : Nominee "+nomNo, "Please enter Minor Nominee Guardian Pincode!");
                     return false;
                 }


                 if (document.getElementById('cmbNom'+nomNo+'MinorGuardianState').value == "") {
                     alertModal("Error : Nominee "+nomNo, "Please select Minor Nominee Guardian State!");
                     return false;
                 }

                 if (document.getElementById('cmbNom'+nomNo+'MinorGuardianCountry').value == "") {
                     alertModal("Error : Nominee "+nomNo, "Please enter Minor Nominee Guardian Country!");
                     return false;
                 }

                 if (document.getElementById('txtNom'+nomNo+'MinorGuardianIDNo').value == "") {
                     alertModal("Error : Nominee "+nomNo, "Please enter Minor Nominee Guardian's valid document ID!");
                     return false;
                 }

                 if (validateFileExtensionByFileName(document.getElementById('spannom'+nomNo+'MinorGuardianDocAsyncFileUpload').innerHTML, "Minor Nominee"+nomNo+" Guardian's Id Proof", "JPG,PNG,JPEG,PDF") == false) {
                     return false;
                 }

                 if (document.getElementById('txtNom'+nomNo+'MinorGuardianMobile').value != "") {
                     if (!IsMobileNumber(document.getElementById('txtNom'+nomNo+'MinorGuardianMobile')))
                         return false;
                 }

                 if (document.getElementById('txtNom'+nomNo+'MinorGuardianEmail').value != "") {
                     if (!ValidateEmail(document.getElementById('txtNom'+nomNo+'MinorGuardianEmail')))
                         return false;
                 }



             }

             document.getElementById('hdnNominee' + nomNo + 'Share').value = document.getElementById('txtNom' + nomNo + 'Percent').value;
             document.getElementById('hdnNomResidualPercent').value = Number(NomResidualPercent) - Number(document.getElementById('txtNom' + nomNo + 'Percent').value);

             //alert('hdnNominee' + nomNo + 'Share' + document.getElementById('hdnNominee' + nomNo + 'Share').value);
             //alert('NomResidualPercent' + document.getElementById('hdnNomResidualPercent').value);

             if (document.getElementById('hdnNominee1Share').value>0 &&
                 document.getElementById('txtNom2Name').value == '') {

                 document.getElementById('txtNom2Percent').value = document.getElementById('hdnNomResidualPercent').value;
                 document.getElementById('txtNom3Percent').value = "0";
             }
             

             if (document.getElementById('hdnNominee2Share').value>0 &&
                 document.getElementById('txtNom3Name').value == '') {

                 document.getElementById('txtNom3Percent').value = document.getElementById('hdnNomResidualPercent').value;
             }

             return true;
             
         }



         function successAsyncFileUpload(sender, args) {

             const contolName = $(sender._element).find('input').attr('id');
             //alert('span' + contolName.replace(/(^.+)(_.+$)/, '$1'));
             const spanContolName =  'span' + contolName.replace(/(^.+)(_.+$)/, '$1')

             $(sender._element).find('input').css("background-color", "white");

             var filename = $(sender._element).find('input').val().replace("C:\\fakepath\\", "");

             document.getElementById(spanContolName).innerHTML = filename;
             document.getElementById(spanContolName).style.backgroundColor = "lime";


         }

         function ValidateEmail(input) {

            var validRegex = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;

            if (input.value.match(validRegex)) {

                input.focus();
                return true;

            } else {

                //alert("Invalid email address!");
                alertModal("Error", "Invalid email address!");

                input.focus();

                return false;

            }

         }

         function validateFileExtensionByElementId(fileElementId, ElementType, fileTypes) {

             var fileElement = document.getElementById(fileElementId)
             var fileElementFileName = "";

             if (fileElement.value != "") {
                 fileElementFileName = fileElement.files.item(0).name.toUpperCase();
             }

             return validateFileExtensionByFileName(fileElementFileName, ElementType, fileTypes);

         }

         function validateFileExtensionByFileName(fileName, uploadType, fileTypes) {


             if (fileName == "") {
                 alertModal("Error : " + uploadType + " file upload", "Please select for upload " + uploadType + " file in " + fileTypes + " format!");
                 return false;
             }

             const fileTypesArray = fileTypes.split(",");

             let matchesNameExtns = "";
             for (let i = 0; i < fileTypesArray.length; i++) {

                 if (i == fileTypesArray.length - 1) {
                     matchesNameExtns += "." + fileTypesArray[i] + "$";
                 }
                 else {
                     matchesNameExtns += "." + fileTypesArray[i] + "$|";
                 }

             }

             var fileElementFileName = fileName.toUpperCase();

             if (fileElementFileName.match(matchesNameExtns) == null) {
                 alertModal("Error : " + uploadType + " file upload", "Invalid file selected! Please select for upload " + uploadType + " file in " + fileTypes + " format!");
                 return false;
             }

             return true;

         }

         function alertModal(title, body) {
              // Display error message to the user in a modal
              $('#alert-modal-title').html(title);
            $('#alert-modal-body').html(body);

            if (title.match("Error") == "Error") {
                $('#alert-modal-body').addClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-success");
            }

            else if (title == "Request added") {
                $('#alert-modal-body').addClass("alert-success");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
            }
            else
            {
                $('#alert-modal-body').addClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-success");
            }
            
              $('#alert-modal').modal('show');
         }

        
    </script>
    


    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                <div class="col-md-3">
                    <center>
                    <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:200px; padding-top:10px">
                    </center>
                </div>
                <div class="col-md-9">
                    <h2 class="lblTopHeader"><i class="fa fa-users" aria-hidden="true"></i> Nominees</h2>
                    <p> Nominees can be added, you can also Opt-out of Nomination.</p>
                </div>
              </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">

                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                    <input type="hidden" id="hdnActivaTab" name="hdnActivaTab" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div class="row">
                                          <div class="col-md-8">

                                              <div class="form-outline flex-fill mb-0">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <h4>Do you wish to make Nominees?</h4>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <select class="form-control" style="width:50%" onchange="optoutNomination();" id="selectMakeNominees" runat="server">
                                                                <option>Yes</option>  
                                                                <option>No</option>
                                                            </select>
                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                              <div id="divChangeNewNominee" runat="server" style="display:none">
                                                    <div class="row" style="padding-top:10px; ">
                                                        <div class="col-sm-6">
                                                            <h4>Same as present Nominees details? <input type="checkbox" data-on="Yes" data-off="No"  onchange="SameAsPresentDetailsClick(this)" checked data-toggle="toggle"></h4>
                                                        </div>
                                                    </div>
                                                </div>
                                              <div id="divOptOutNominees" runat="server">
                                                  <div class="alert alert-danger">
                                                    <strong>Opt-out of Nomination</strong> You do not wish to appoint any nominee.
                                                  </div>
                                                  <button type="button" class="btn btn-lg btn-success" data-dismiss="modal" id="btnContinueOptoutNomination" onclick="saveNomination('Opt Out')"><i class="fa fa-check" aria-hidden="true"></i> Continue</button>
                                              </div>
                                              <div id="divNominees" runat="server">
                                                <input type="hidden"  id="hdnNomResidualPercent" name="hdnNomResidualPercent" runat="server" value="100">
                                                <input type="hidden"  id="hdnNominee1Share" name="hdnNominee1Share" runat="server" value="">
                                                <input type="hidden"  id="hdnNominee2Share" name="hdnNominee2Share" runat="server" value="">
                                                <input type="hidden"  id="hdnNominee3Share" name="hdnNominee3Share" runat="server" value="">
                                                <ul class="nav nav-tabs" style="padding-top:10px">
                                                    <li class="active"><a data-toggle="tab" href="#Nominee1Tab">Nominee 1</a></li>
                                                    <li><a data-toggle="tab" href="#Nominee2Tab">Nominee 2</a></li>
                                                    <li><a data-toggle="tab" href="#Nominee3Tab">Nominee 3</a></li>
                                                </ul>
                                                <br>
                                               <div class="tab-content">
                                                  <div id="Nominee1Tab" class="tab-pane fade in active">
                                                    <ul class="nav nav-tabs">
                                                        <li class="active"><a data-toggle="tab" href="#ModalNominee1Tab">Nominee1 details</a></li>
                                                        <li><a data-toggle="tab" href="#ModalNominee1MinorGuardianTab">Minor Nominee1 Guardian</a></li>
                                                    </ul>
                                                    <br>
                                                    <div class="tab-content">
                                                        <div id="ModalNominee1Tab" class="tab-pane fade in active">
                                                            <div class="row">
                                                            <div class="col-sm-5">
                                                                <label for="txtNom1Name" class="control-label col-sm-5">Name*:</label>
                                                                <div class="col-sm-7">
                                                                    <select class="form-control" id="selectNom1Prefix" runat="server">
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-7">
                                                                <div class="form-group">
                                                                    <div class="col-sm-12">
                                                                        <input type="text" class="form-control" id="txtNom1Name" runat="server" placeholder="Full Name"  maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1Relation" class="control-label col-sm-4">Relation:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom1Relation" runat="server" placeholder="Relation" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1Percent" class="control-label col-sm-4">Share %*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input  type="number" class="form-control" id="txtNom1Percent" runat="server" placeholder="% Share">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:20px">
                                                                <div class="col-sm-12">
                                                                    <div class="row">
                                                                        <div class="col-sm-2">
                                                                        </div>
                                                                        <div class="col-sm-8">
                                                                            <label class="form-check-label" for="chkbNom1AddSameAsApplicant">&nbsp;<asp:CheckBox ID="chkbNom1AddSameAsApplicant" OnCheckedChanged="chkbNom1AddSameAsApplicant_CheckedChanged" runat="server" AutoPostBack="true" />&nbsp;&nbsp;Address same as applicant?</label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1Add1" class="control-label col-sm-4">Address 1*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom1Add1" runat="server" placeholder="Address 1" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="txtNom1Add2" class="control-label col-sm-4">Address 2:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtNom1Add2" runat="server" placeholder="Address 2" maxlength="50">
                                                                    </div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1Add3" class="control-label col-sm-4">Address 3:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom1Add3" runat="server" placeholder="Address 3" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1City" class="control-label col-sm-4">City:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom1City" runat="server" placeholder="City" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1Pincode" class="control-label col-sm-4">Pincode*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtNom1Pincode" runat="server" placeholder="Pincode">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom1State" class="control-label col-sm-4">State*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom1State" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom1Country" class="control-label col-sm-4">Country*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom1Country" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1Mobile" class="control-label col-sm-4">Mobile:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="number"  class="form-control" id="txtNom1Mobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1Email" class="control-label col-sm-4">Email:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom1Email" runat="server" placeholder="Email"  maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom1IdType" class="control-label col-sm-4">Id Type*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom1IdType" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1IDNo" class="control-label col-sm-4">ID No*:</label>
                                                                        <div class="col-sm-8">
                                                                        <input type="text"  class="form-control" id="txtNom1IDNo" runat="server" placeholder="Document ID"  maxlength="50">
                                                                        </div>
                                        
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="nom1DocAsyncFileUpload" class="control-label col-sm-4">Upload document*:</label>
                                                                    <div class="col-sm-8">
                                                                        <ajaxToolkit:AsyncFileUpload ID="nom1DocAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="nom1DocAsyncFileUpload_UploadedComplete" runat="server" />
                                                                        <span id="spannom1DocAsyncFileUpload" runat="server"></span>
                                                                    </div>
                                                                </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="dtNom1DateofBirth" class="control-label col-sm-4">DOB*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="date" class="form-control" id="dtNom1DateofBirth" runat="server">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-check">
                                                                        <label class="form-check-label" for="chkNom1IsMinor">
                                                                            &nbsp;<input type="checkbox" class="form-check-input" onchange="if(this.checked==false){activaTab('ModalNominee1Tab');} else {activaTab('ModalNominee1MinorGuardianTab');}"  id="chkNom1IsMinor" runat="server" name="chkNom1IsMinor">&nbsp;&nbsp; Nominee is minor?
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="ModalNominee1MinorGuardianTab" class="tab-pane fade in">
                                                            <div class="row">
                                                            <div class="col-sm-5">
                                                                <label for="txtNom1MinorGuardianName" class="control-label col-sm-5">Name*:</label>
                                                                <div class="col-sm-7">
                                                                    <select class="form-control" id="selectNom1MinorGuardianPrefix" runat="server">
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-7">
                                                                <div class="form-group">
                                                                    <div class="col-sm-12">
                                                                        <input type="text" class="form-control" id="txtNom1MinorGuardianName" runat="server" placeholder="Guardian Name" maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1MinorGuardianRelation" class="control-label col-sm-4">Relation:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom1MinorGuardianRelation" runat="server" placeholder="Relation" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-2">
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-check">
                                                                        <label class="form-check-label" for="chkAddressSameAsNominee1">
                                                                            &nbsp;<input type="checkbox" class="form-check-input" onchange="setMinorAddressSameAsNominee(this.checked,'1');"  id="chkAddressSameAsNominee1" runat="server" name="chkAddressSameAsNominee1">&nbsp;&nbsp;  Address same as Nominee?
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1MinorGuardianAdd1" class="control-label col-sm-4">Address 1*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom1MinorGuardianAdd1" runat="server" placeholder="Address 1" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="txtNom1MinorGuardianAdd2" class="control-label col-sm-4">Address 2:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtNom1MinorGuardianAdd2" runat="server" placeholder="Address 2" maxlength="50">
                                                                    </div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1MinorGuardianAdd3" class="control-label col-sm-4">Address 3:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom1MinorGuardianAdd3" runat="server" placeholder="Address 3" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1MinorGuardianCity" class="control-label col-sm-4">City:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom1MinorGuardianCity" runat="server" placeholder="City" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1MinorGuardianPincode" class="control-label col-sm-4">Pincode*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtNom1MinorGuardianPincode" runat="server" placeholder="Pincode">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom1MinorGuardianState" class="control-label col-sm-4">State*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom1MinorGuardianState" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom1MinorGuardianCountry" class="control-label col-sm-4">Country*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom1MinorGuardianCountry" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1MinorGuardianMobile" class="control-label col-sm-4">Mobile:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="number"  class="form-control" id="txtNom1MinorGuardianMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1MinorGuardianEmail" class="control-label col-sm-4">Email:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom1MinorGuardianEmail" runat="server" placeholder="Email" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom1MinorGuardianIdType" class="control-label col-sm-4">Id Type*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom1MinorGuardianIdType" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1MinorGuardianIDNo" class="control-label col-sm-4">ID No*:</label>
                                                                        <div class="col-sm-8">
                                                                        <input type="text"  class="form-control" id="txtNom1MinorGuardianIDNo" runat="server" placeholder="ID No" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="nom1MinorGuardianDocAsyncFileUpload" class="control-label col-sm-4">Upload document*:</label>
                                                                    <div class="col-sm-8">
                                                                        <ajaxToolkit:AsyncFileUpload ID="nom1MinorGuardianDocAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="nom1MinorGuardianDocAsyncFileUpload_UploadedComplete" runat="server" />
                                                                        <span id="spannom1MinorGuardianDocAsyncFileUpload" runat="server"></span>
                                                                    </div>
                                                                </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                  </div>
                                                  <div id="Nominee2Tab" class="tab-pane fade in">
                                                       <ul class="nav nav-tabs">
                                                        <li class="active"><a data-toggle="tab" href="#ModalNominee2Tab">Nominee2 details</a></li>
                                                        <li><a data-toggle="tab" href="#ModalNominee2MinorGuardianTab">Minor Nominee2 Guardian</a></li>
                                                    </ul>
                                                    <br>
                                                    <div class="tab-content">
                                                        <div id="ModalNominee2Tab" class="tab-pane fade in active">
                                                            <div class="row">
                                                            <div class="col-sm-5">
                                                                <label for="txtNom2Name" class="control-label col-sm-5">Name*:</label>
                                                                <div class="col-sm-7">
                                                                    <select class="form-control" id="selectNom2Prefix" runat="server">
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-7">
                                                                <div class="form-group">
                                                                    <div class="col-sm-12">
                                                                        <input type="text" class="form-control" id="txtNom2Name" runat="server" placeholder="Full Name"  maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2Relation" class="control-label col-sm-4">Relation:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom2Relation" runat="server" placeholder="Relation" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2Percent" class="control-label col-sm-4">Share %*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input  type="number" class="form-control" id="txtNom2Percent" runat="server" placeholder="% Share">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:20px">
                                                                <div class="col-sm-12">
                                                                    <div class="row">
                                                                        <div class="col-sm-2">
                                                                        </div>
                                                                        <div class="col-sm-8">
                                                                            <label class="form-check-label" for="chkbNom2AddSameAsApplicant">&nbsp;<asp:CheckBox ID="chkbNom2AddSameAsApplicant" OnCheckedChanged="chkbNom2AddSameAsApplicant_CheckedChanged" runat="server" AutoPostBack="true" />&nbsp;&nbsp;Address same as applicant?</label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2Add1" class="control-label col-sm-4">Address 1*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom2Add1" runat="server" placeholder="Address 1" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="txtNom2Add2" class="control-label col-sm-4">Address 2:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtNom2Add2" runat="server" placeholder="Address 2" maxlength="50">
                                                                    </div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2Add3" class="control-label col-sm-4">Address 3:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom2Add3" runat="server" placeholder="Address 3" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2City" class="control-label col-sm-4">City:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom2City" runat="server" placeholder="City" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2Pincode" class="control-label col-sm-4">Pincode*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtNom2Pincode" runat="server" placeholder="Pincode">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom2State" class="control-label col-sm-4">State*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom2State" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom2Country" class="control-label col-sm-4">Country*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom2Country" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2Mobile" class="control-label col-sm-4">Mobile:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="number"  class="form-control" id="txtNom2Mobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2Email" class="control-label col-sm-4">Email:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom2Email" runat="server" placeholder="Email"  maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom2IdType" class="control-label col-sm-4">Id Type*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom2IdType" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2IDNo" class="control-label col-sm-4">ID No*:</label>
                                                                        <div class="col-sm-8">
                                                                        <input type="text"  class="form-control" id="txtNom2IDNo" runat="server" placeholder="Document ID"  maxlength="50">
                                                                        </div>
                                        
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="nom2DocAsyncFileUpload" class="control-label col-sm-4">Upload document*:</label>
                                                                    <div class="col-sm-8">
                                                                        <ajaxToolkit:AsyncFileUpload ID="nom2DocAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="nom2DocAsyncFileUpload_UploadedComplete" runat="server" />
                                                                        <span id="spannom2DocAsyncFileUpload" runat="server"></span>
                                                                    </div>
                                                                </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="dtNom2DateofBirth" class="control-label col-sm-4">DOB*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="date" class="form-control" id="dtNom2DateofBirth" runat="server">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-check">
                                                                        <label class="form-check-label" for="chkNom2IsMinor">
                                                                            &nbsp;<input type="checkbox" class="form-check-input" onchange="if(this.checked==false){activaTab('ModalNominee2Tab');} else {activaTab('ModalNominee2MinorGuardianTab');}"  id="chkNom2IsMinor" runat="server" name="chkNom2IsMinor">&nbsp;&nbsp; Nominee is minor?
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="ModalNominee2MinorGuardianTab" class="tab-pane fade in">
                                                            <div class="row">
                                                            <div class="col-sm-5">
                                                                <label for="txtNom2MinorGuardianName" class="control-label col-sm-5">Name*:</label>
                                                                <div class="col-sm-7">
                                                                    <select class="form-control" id="selectNom2MinorGuardianPrefix" runat="server">
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-7">
                                                                <div class="form-group">
                                                                    <div class="col-sm-12">
                                                                        <input type="text" class="form-control" id="txtNom2MinorGuardianName" runat="server" placeholder="Guardian Name" maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2MinorGuardianRelation" class="control-label col-sm-4">Relation:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom2MinorGuardianRelation" runat="server" placeholder="Relation" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-2">
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-check">
                                                                        <label class="form-check-label" for="chkAddressSameAsNominee2">
                                                                            &nbsp;<input type="checkbox" class="form-check-input" onchange="setMinorAddressSameAsNominee(this.checked,'2');"  id="chkAddressSameAsNominee2" runat="server" name="chkAddressSameAsNominee2">&nbsp;&nbsp;  Address same as Nominee?
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2MinorGuardianAdd1" class="control-label col-sm-4">Address 1*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom2MinorGuardianAdd1" runat="server" placeholder="Address 1" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="txtNom2MinorGuardianAdd2" class="control-label col-sm-4">Address 2:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtNom2MinorGuardianAdd2" runat="server" placeholder="Address 2" maxlength="50">
                                                                    </div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2MinorGuardianAdd3" class="control-label col-sm-4">Address 3:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom2MinorGuardianAdd3" runat="server" placeholder="Address 3" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2MinorGuardianCity" class="control-label col-sm-4">City:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom2MinorGuardianCity" runat="server" placeholder="City" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2MinorGuardianPincode" class="control-label col-sm-4">Pincode*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtNom2MinorGuardianPincode" runat="server" placeholder="Pincode">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom2MinorGuardianState" class="control-label col-sm-4">State*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom2MinorGuardianState" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom2MinorGuardianCountry" class="control-label col-sm-4">Country*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom2MinorGuardianCountry" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2MinorGuardianMobile" class="control-label col-sm-4">Mobile:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="number"  class="form-control" id="txtNom2MinorGuardianMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2MinorGuardianEmail" class="control-label col-sm-4">Email:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom2MinorGuardianEmail" runat="server" placeholder="Email" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom2MinorGuardianIdType" class="control-label col-sm-4">Id Type*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom2MinorGuardianIdType" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2MinorGuardianIDNo" class="control-label col-sm-4">ID No*:</label>
                                                                        <div class="col-sm-8">
                                                                        <input type="text"  class="form-control" id="txtNom2MinorGuardianIDNo" runat="server" placeholder="ID No" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="nom2MinorGuardianDocAsyncFileUpload" class="control-label col-sm-4">Upload document*:</label>
                                                                    <div class="col-sm-8">
                                                                        <ajaxToolkit:AsyncFileUpload ID="nom2MinorGuardianDocAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="nom2MinorGuardianDocAsyncFileUpload_UploadedComplete" runat="server" />
                                                                        <span id="spannom2MinorGuardianDocAsyncFileUpload" runat="server"></span>
                                                                    </div>
                                                                </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                  </div>
                                                  <div id="Nominee3Tab" class="tab-pane fade in">
                                                       <ul class="nav nav-tabs">
                                                        <li class="active"><a data-toggle="tab" href="#ModalNominee3Tab">Nominee3 details</a></li>
                                                        <li><a data-toggle="tab" href="#ModalNominee3MinorGuardianTab">Minor Nominee3 Guardian</a></li>
                                                    </ul>
                                                    <br>
                                                    <div class="tab-content">
                                                        <div id="ModalNominee3Tab" class="tab-pane fade in active">
                                                            <div class="row">
                                                            <div class="col-sm-5">
                                                                <label for="txtNom3Name" class="control-label col-sm-5">Name*:</label>
                                                                <div class="col-sm-7">
                                                                    <select class="form-control" id="selectNom3Prefix" runat="server">
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-7">
                                                                <div class="form-group">
                                                                    <div class="col-sm-12">
                                                                        <input type="text" class="form-control" id="txtNom3Name" runat="server" placeholder="Full Name"  maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3Relation" class="control-label col-sm-4">Relation:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom3Relation" runat="server" placeholder="Relation" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3Percent" class="control-label col-sm-4">Share %*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input  type="number" class="form-control" id="txtNom3Percent" runat="server" placeholder="% Share">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:20px">
                                                                <div class="col-sm-12">
                                                                    <div class="row">
                                                                        <div class="col-sm-2">
                                                                        </div>
                                                                        <div class="col-sm-8">
                                                                            <label class="form-check-label" for="chkbNom3AddSameAsApplicant">&nbsp;<asp:CheckBox ID="chkbNom3AddSameAsApplicant" OnCheckedChanged="chkbNom3AddSameAsApplicant_CheckedChanged" runat="server" AutoPostBack="true" />&nbsp;&nbsp;Address same as applicant?</label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3Add1" class="control-label col-sm-4">Address 1*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom3Add1" runat="server" placeholder="Address 1" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="txtNom3Add2" class="control-label col-sm-4">Address 2:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtNom3Add2" runat="server" placeholder="Address 2" maxlength="50">
                                                                    </div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3Add3" class="control-label col-sm-4">Address 3:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom3Add3" runat="server" placeholder="Address 3" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3City" class="control-label col-sm-4">City:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom3City" runat="server" placeholder="City" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3Pincode" class="control-label col-sm-4">Pincode*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtNom3Pincode" runat="server" placeholder="Pincode">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom3State" class="control-label col-sm-4">State*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom3State" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom3Country" class="control-label col-sm-4">Country*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom3Country" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3Mobile" class="control-label col-sm-4">Mobile:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="number"  class="form-control" id="txtNom3Mobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3Email" class="control-label col-sm-4">Email:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom3Email" runat="server" placeholder="Email"  maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom3IdType" class="control-label col-sm-4">Id Type*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom3IdType" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3IDNo" class="control-label col-sm-4">ID No*:</label>
                                                                        <div class="col-sm-8">
                                                                        <input type="text"  class="form-control" id="txtNom3IDNo" runat="server" placeholder="Document ID"  maxlength="50">
                                                                        </div>
                                        
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="nom3DocAsyncFileUpload" class="control-label col-sm-4">Upload document*:</label>
                                                                    <div class="col-sm-8">
                                                                        <ajaxToolkit:AsyncFileUpload ID="nom3DocAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="nom3DocAsyncFileUpload_UploadedComplete" runat="server" />
                                                                        <span id="spannom3DocAsyncFileUpload" runat="server"></span>
                                                                    </div>
                                                                </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="dtNom3DateofBirth" class="control-label col-sm-4">DOB*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="date" class="form-control" id="dtNom3DateofBirth" runat="server">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-check">
                                                                        <label class="form-check-label" for="chkNom3IsMinor">
                                                                            &nbsp;<input type="checkbox" class="form-check-input" onchange="if(this.checked==false){activaTab('ModalNominee3Tab');} else {activaTab('ModalNominee3MinorGuardianTab');}"  id="chkNom3IsMinor" runat="server" name="chkNom3IsMinor">&nbsp;&nbsp; Nominee is minor?
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="ModalNominee3MinorGuardianTab" class="tab-pane fade in">
                                                            <div class="row">
                                                            <div class="col-sm-5">
                                                                <label for="txtNom3MinorGuardianName" class="control-label col-sm-5">Name*:</label>
                                                                <div class="col-sm-7">
                                                                    <select class="form-control" id="selectNom3MinorGuardianPrefix" runat="server">
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-7">
                                                                <div class="form-group">
                                                                    <div class="col-sm-12">
                                                                        <input type="text" class="form-control" id="txtNom3MinorGuardianName" runat="server" placeholder="Guardian Name" maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3MinorGuardianRelation" class="control-label col-sm-4">Relation:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom3MinorGuardianRelation" runat="server" placeholder="Relation" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-2">
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-check">
                                                                        <label class="form-check-label" for="chkAddressSameAsNominee3">
                                                                            &nbsp;<input type="checkbox" class="form-check-input" onchange="setMinorAddressSameAsNominee(this.checked,'3');"  id="chkAddressSameAsNominee3" runat="server" name="chkAddressSameAsNominee3">&nbsp;&nbsp;  Address same as Nominee?
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3MinorGuardianAdd1" class="control-label col-sm-4">Address 1*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom3MinorGuardianAdd1" runat="server" placeholder="Address 1" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="txtNom3MinorGuardianAdd2" class="control-label col-sm-4">Address 2:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtNom3MinorGuardianAdd2" runat="server" placeholder="Address 2" maxlength="50">
                                                                    </div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3MinorGuardianAdd3" class="control-label col-sm-4">Address 3:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom3MinorGuardianAdd3" runat="server" placeholder="Address 3" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3MinorGuardianCity" class="control-label col-sm-4">City:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom3MinorGuardianCity" runat="server" placeholder="City" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3MinorGuardianPincode" class="control-label col-sm-4">Pincode*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtNom3MinorGuardianPincode" runat="server" placeholder="Pincode">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom3MinorGuardianState" class="control-label col-sm-4">State*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom3MinorGuardianState" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom3MinorGuardianCountry" class="control-label col-sm-4">Country*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom3MinorGuardianCountry" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3MinorGuardianMobile" class="control-label col-sm-4">Mobile:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="number"  class="form-control" id="txtNom3MinorGuardianMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3MinorGuardianEmail" class="control-label col-sm-4">Email:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom3MinorGuardianEmail" runat="server" placeholder="Email" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom3MinorGuardianIdType" class="control-label col-sm-4">Id Type*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom3MinorGuardianIdType" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3MinorGuardianIDNo" class="control-label col-sm-4">ID No*:</label>
                                                                        <div class="col-sm-8">
                                                                        <input type="text"  class="form-control" id="txtNom3MinorGuardianIDNo" runat="server" placeholder="ID No" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="nom3MinorGuardianDocAsyncFileUpload" class="control-label col-sm-4">Upload document*:</label>
                                                                    <div class="col-sm-8">
                                                                        <ajaxToolkit:AsyncFileUpload ID="nom3MinorGuardianDocAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="nom3MinorGuardianDocAsyncFileUpload_UploadedComplete" runat="server" />
                                                                        <span id="spannom3MinorGuardianDocAsyncFileUpload" runat="server"></span>
                                                                    </div>
                                                                </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                  </div>
                                               </div>
                                              </div>
                                          
                                              <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                                  <br />
                                                  <div class="alert alert-info" id="divAlertInfoMsg" runat="server">
                                                  </div>
                                                  <div class="alert alert-warning">
                                                      <strong>Warning!</strong> In case Aadhaar is uploaded, please remember: <br />
                                                      <span style="font-size:11px; color:red" id="spanAadhaarUploadNotes" runat="server">
                                                      </span>
                                                  </div>

                                                  <button type="button" class="btn btn-success btn-lg" id="btnContinue" onclick="saveNomination('Add Nominee');" runat="server" ><i class="fa fa-check" aria-hidden="true"></i> Save and Continue</button>
                                                  
                                                  <p>
                                                      <br />
                                                      <i>
                                                        *By clicking the above button, I agree that i have read <a href="#">Terms & Conditions</a>.
                                                      </i>
                                                  </p>
                                                  <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                                  </div>
                                                  <br />
                                                  <br />
                                              </div>

                                          </div>

                                          <div class="col-md-4">
                                             <h3 id="hFullName" runat="server"></h3>
                                             <p>
                                              Date of Birth : <u><span id="spanDOB" runat="server"></span></u>
                                              <br />
                                               PAN : <u><span id="spanPAN" runat="server"></span></u>
                                               <br />
                                               Aaadhaar : <u><span id="spanAadhaar" runat="server"></span></u>
                                             </p>
                                             <br />
                                             <p>
                                                 <b><span id="spanBrokerName" runat="server">Standard Broker</span></b> for conducting online KYC for reactivation trading and demat account
                                             </p>
                                             <p>
                                                The Aadhaar and the PAN should belong to you and your name, dob also must match in both documents Aadhaar and PAN , if it does not, then you can resolve the name mismatch issue by changing your name on the PAN Card from <a href="https://www.onlineservices.nsdl.com/paam/endUserRegisterContact.html">NSDL</a>  or on the Aadhaar Card from <a href="https://www.uidai.gov.in">UIDAI</a>.
                                             </p>
                                             <p>
                                                Your Aadhaar number is never visible or available to us.
                                             </p>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                           </ContentTemplate>
                        </asp:UpdatePanel>
                                 <hr />
                              <div id="divPreviousSteps" runat="server">
                                <h4>Go to previous step </h4> 
                                <ul class="list-inline">
                                <li><a href="contact.aspx"><i class="fas fa-envelope fa-lg me-3 fa-fw" aria-hidden="true"></i> Contact</a></li>
                                <li><a href="DigiLockerKYC.aspx" id="hlinkDigiLocker" runat="server"><i class="fa fa-cloud-download" aria-hidden="true"></i> DigiLocker</a></li>
                                <li><a href="manuallyProcessing.aspx" id="hlinkAddress" runat="server"><i class="fa fa-id-card" aria-hidden="true"></i> Address</a></li>
                                <li><a href="capturePhoto.aspx" id="hlinkCapturePhoto" runat="server"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                <li><a href="profile.aspx" id="hlinkIncomeProfile" runat="server"><i class="fa fa-inr" aria-hidden="true"></i> Income Profile</a></li>
                                <li><a href="TradingPreference.aspx" id="hlinkTradingPreference" runat="server"><i class="fa fa-exchange" aria-hidden="true"></i> Trading Preference</a></li>
                                <li><a href="BankDetails.aspx" id="hlinkBankDetails" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Bank</a></li>
                                </ul>
                            </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
			    </div>
             </div>

          </div>
        </section>
    </form>

    <div id="confirmOptoutNominationModal" class="modal fade">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="cancelOptoutNomination();"><span aria-hidden="true">&times;</span></button>
                <h2>Opt-out of Nomination</h2>
              </div>
              <div class="modal-body">
                  <h4 id="confirmOptoutModalbody">Do you really want to Opt-out of Nomination?</h4>
                  <br />
                  <h4><u>Declaration</u></h4>
                  <p>
                      I / We hereby confirm that I / We do not wish to appoint any nominee(s) in my / our trading / Demat account and understand the issues involved in non-appointment of nominee(s) and further are aware that in case of death of all the account holder(s), my / our legal heirs would need to submit all the requisite documents / information for claiming of assets held in my / our trading / Demat account, which may also include documents issued by Court or other such competent authority, based on the value of assets held in the trading / Demat account.
                  </p>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <button type="button" class="btn btn-lg btn-primary" data-dismiss="modal" onclick="cancelOptoutNomination();" id="btnConfirmOptoutNominationModalNo" style="margin-top:5px">No, I don't agree</button>
                  <button type="button" class="btn btn-lg btn-danger" data-dismiss="modal" id="btnConfirmOptoutNominationModalYes" onclick="saveNomination('Opt Out')" style="margin-top:5px">Yes, I agree and want to opt out</button>
              </div>
            </div>
          </div>
        </div>

     <div id="alert-modal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="alert-modal-title" class="modal-title"></h4>
              </div>
              <div id="alert-modal-body" class="modal-body"></div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">OK</button>
              </div>
            </div>
          </div>
        </div>

    <div class="modal fade" id="modalLoading" tabindex="-1" role="dialog" aria-labelledby="modalLoadingLabel">
      <div class="modal-dialog modal-md">
        <div class="modal-content">
          <div class="modal-header">
          </div>
          <div class="modal-body">
              <center>
                    <h4>Please wait..Your request is being processed..</h4>
                    <p>Do not close browser window....</p>
                    <img src="../ekyc/images/Loading.gif" alt="Loading" style="width:150px;" />
               </center>
          </div>

          <div class="modal-footer">
          </div>
        </div>
      </div>
    </div>

</body>
</html>
