﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="uploadDocuments.aspx.cs" Inherits="Connect_DotNet.ReActivation.uploadDocuments" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>Upload documents</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
   <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
   <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

        <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />

</head>
<body>
    <style>
        .margineTop10{
            margin-top:10px
        }


    </style>
     <script>

         window.onload = function () {

             if (document.getElementById('hdnMsgModalOpen').value != "") {

                 const hdnMsgModalOpenArray = document.getElementById('hdnMsgModalOpen').value.split("####");
                 var titleMsg = hdnMsgModalOpenArray[0];
                 var Msg = hdnMsgModalOpenArray[1];

                 document.getElementById('hdnMsgModalOpen').value = "";
                 alertModal(titleMsg, Msg);

             }
             
        }
        

         function saveData() {

             

             if (validateFileExtensionByElementId("IncomeProofFile", "Income proof", "JPG,PNG,JPEG,PDF") == false) {
                 return;
             }

             if (document.getElementById('divSignature').style.display == "block") {
                 if (validateFileExtensionByElementId("fileSignature", "Wet Signature image", "JPG,PNG,JPEG") == false) {
                     return;
                 }
             }


             if (document.getElementById('divPANfile').style.display == "block") {

                 if (validateFileExtensionByElementId("filePAN", "Copy of PAN card", "JPG,PNG,JPEG,PDF") == false) {
                     return;
                 }
             }

             if (document.getElementById('divAadhaarFile').style.display == "block") {

                 if (validateFileExtensionByElementId("fileAadhaar", "Copy of Aadhaar card", "JPG,PNG,JPEG,PDF") == false) {
                     return;
                 }

             }

             

             document.getElementById('hdnBtnContinueClicked').value = "Continue";
             $('#modalLoading').modal('show');
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
         }

        

         function validateFileExtensionByElementId(fileElementId, ElementType, fileTypes) {

                var fileElement = document.getElementById(fileElementId)
                var fileElementFileName = "";

                if (fileElement.value != "") {
                    fileElementFileName = fileElement.files.item(0).name.toUpperCase();
                }

                return validateFileExtensionByFileName(fileElementFileName, ElementType, fileTypes);

            }

            function validateFileExtensionByFileName(fileName, uploadType, fileTypes) {


                if (fileName == "") {
                    alertModal("Error : " + uploadType + " upload", "Please upload your " + uploadType + " in " + fileTypes + " format!");
                    return false;
                }

                const fileTypesArray = fileTypes.split(",");

                let matchesNameExtns = "";
                for (let i = 0; i < fileTypesArray.length; i++) {

                    if (i == fileTypesArray.length - 1) {
                        matchesNameExtns += "." + fileTypesArray[i] + "$";
                    }
                    else {
                        matchesNameExtns += "." + fileTypesArray[i] + "$|";
                    }

                }

                var fileElementFileName = fileName.toUpperCase();

                if (fileElementFileName.match(matchesNameExtns) == null) {
                    alertModal("Error : " + uploadType + " file upload", "Invalid file selected! Please select for upload " + uploadType + " file in " + fileTypes + " format!");
                    return false;
                }

                return true;

         }


         function alertModal(title, body) {
              // Display error message to the user in a modal
              $('#alert-modal-title').html(title);
            $('#alert-modal-body').html(body);

            if (title.match("Error") == "Error") {
                $('#alert-modal-body').addClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-success");
            }

            else if (title.match("success") == "success") {
                $('#alert-modal-body').addClass("alert-success");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");

                if (title == "Link send successfully") {
                    document.getElementById("divContinueIfDone").style = "display:block";
                    document.getElementById("divStartRecording").style = "display:none";
                    document.getElementById("divContinueNext").style = "display:none";
                }
                
            }
            else
            {
                $('#alert-modal-body').addClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-success");
            }
            
             $('#alert-modal').modal('show');
             $('#modalLoading').modal('hide');
         }

    </script>
    <form id="form1" runat="server" enctype="multipart/form-data">
        <br />
        <section class="vh-100">
              <div class="container h-100">
                  <div class="row">
                    <div class="col-md-3">
                        <center>
                        <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:200px; padding-top:10px">
                        </center>
                    </div>
                    <div class="col-md-9">
                        <h2 class="lblTopHeader"><i class="fa fa-upload" aria-hidden="true"></i> Upload documents </h2>
                        <p>Upload documents :  Income proof, Wet Signature, Copy of PAN, Copy of Aadhaar</p>
                    </div>
                  </div>
                  <div class="progress">
                    <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                    </div>
                  </div>
                  <div class="row d-flex justify-content-center align-items-center">
                  <div class="col-lg-12 col-xl-11">
                    <div class="card text-black" style="border-radius: 25px;">
                      <div class="card-body p-md-5">
                        <div class="row justify-content-center">
                          <div class="col-md-12">
                                <div style="display:none">
                                <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                <input type="hidden" id="hdnMsgModalOpen" name="hdnMsgModalOpen" runat="server" value="">
                                </div>
                                <div class="d-flex flex-row align-items-center mb-4">
                                    <div class="form-outline flex-fill mb-0 margineTop10">
                                        <div class="row"  style="padding-top:20px">
                                            <div class="col-sm-7">
                                                    <div class="form-group">
                                                    <label for="cmbIncomeProof" class="control-label col-sm-4">Income Proof*:</label>
                                                        <div class="col-sm-8">
                                                            <asp:DropDownList ID="cmbIncomeProof" CssClass="form-control" runat="server">
                                                            <asp:ListItem Value="01">Bank statement(6 months for F&O/ 3 months for Cash)</asp:ListItem>
                                                            <asp:ListItem Value="02">ITR for last 2 years for NI/ ITR for last 1 year for Individual</asp:ListItem>
                                                            <asp:ListItem Value="03">Form 16 of Last Assessment Year</asp:ListItem>
                                                            <asp:ListItem Value="04">Current Demat holding statement(signed ad stamped)</asp:ListItem>
                                                            <asp:ListItem Value="05">Networth certificate certified by CA</asp:ListItem>
                                                            <asp:ListItem Value="06">Proof of Ownership of immovable property</asp:ListItem>
                                                            <asp:ListItem Value="07">Mutual funds A/c Statement</asp:ListItem>
                                                            <asp:ListItem Value="08">FD certificate</asp:ListItem>
                                                            <asp:ListItem Value="09">Proof of Investment in Fixed return sequries(bond/debenture etc.)</asp:ListItem>
                                                            </asp:DropDownList>
                                                            <table style="margin-top:10px; margin-left:-20px">
                                                                <tr>
                                                                    <td>1.*&nbsp;</td>
                                                                    <td><input type="file" class="form-control-file border" id="IncomeProofFile" name="IncomeProofFile" accept='.jpg,.png,.jpeg,.pdf'></td>
                                                                    <td>2.&nbsp;</td>
                                                                    <td><input type="file" class="form-control-file border" id="IncomeProofFile2" name="IncomeProofFile2" accept='.jpg,.png,.jpeg,.pdf'></td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row" style="padding-top:20px">
                                            <div class="col-sm-7">
                                                <div class="row">
                                                    <div class="col-sm-12">
                                                        <div id="divSignature" runat="server">
                                                            <div class="form-group">
                                                                <label for="fileSignature" class="control-label col-sm-4">Wet Signature image*:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="file" class="form-control-file border" id="fileSignature" name="fileSignature" accept='.jpg,.png,.jpeg'>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm-12">
                                                         <div id="divPANfile" runat="server">
                                                            <div class="form-group">
                                                                <label for="filePAN" class="control-label col-sm-4">Copy of PAN card*:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="file" class="form-control-file border" id="filePAN" name="filePAN" accept='.jpg,.png,.jpeg,.pdf'>
                                                                </div>
                                                            </div>
                                                        </div>
                                                     </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm-12">
                                                        <div id="divAadhaarFile" runat="server">
                                                        <div class="form-group">
                                                            <label for="fileAadhaar" class="control-label col-sm-4">Copy of Aadhaar (Both side)*:</label>
                                                            <div class="col-sm-8">
                                                                <input type="file" class="form-control-file border" id="fileAadhaar" name="fileAadhaar" accept='.jpg,.png,.jpeg,.pdf'>
                                                                <span style="color:red; font-size:11px" id="spanAadhaarUploadNotes" runat="server">
                                                                </span> 
                                                            </div>
                                                        </div>
                                                       </div>
                                                    </div>
                                               </div>
                                                <div class="row">
                                                    <div class="col-sm-12">
                                                        <br />
                                                        <p>
                                                            <i>* Uploaded files size should be less than 2MB.</i><br />
                                                        </p>
                                                        <p>
                                                            <i>* Please ensure that you submit your documents in an acceptable format and that your documents are not password protected.</i><br />
                                                        </p>
                                                        <p>
                                                            <i>* Please don't upload corrupted files, This will cause rejection of your eKYC request.</i>
                                                        </p>
                                                        <div class="row">
                                                            <div class="col-sm-2">
                                                            </div>
                                                            <div class="col-sm-4 col-md-6">
                                                                <div style="text-align:center; padding-top:10px;">
                                                                    <button type="button" class="btn btn-success btn-lg" style="margin-bottom:20px" onclick="saveData();"><i class="fa fa-cloud-upload" aria-hidden="true"></i> Submit Documents</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="col-sm-5">
                                                <div id="divPhoto" runat="server">
                                                    <div class="row">
                                                      <div class="col-xs-6">
                                                          <center>
                                                          <img id="ImgAadhaar" width="160" height="200" src="" alt="Aadhaar Photo" runat="server">
                                                          <br />
                                                          <span>Fetch from Aadhaar</span>
                                                           </center>
                                                      </div>
                                                      <div class="col-xs-6">
                                                          <center>
                                                          <img id="ImgLivePhotoCaptured" width="160" height="200" src="" alt="Aadhaar Photo" runat="server">
                                                          <br />
                                                          <span>Live photo captured</span>
                                                           </center>
                                                      </div>
                                                  </div>
                                                </div>
                                              
                                            </div>
                                         </div>
                                    </div>
                                    <hr />
                                    <div id="divPreviousSteps" runat="server">
                                        <h4>Go to previous step </h4> 
                                        <ul class="list-inline">
                                        <li><a href="contact.aspx"><i class="fas fa-envelope fa-lg me-3 fa-fw" aria-hidden="true"></i> Contact</a></li>
                                        <li><a href="DigiLockerKYC.aspx" id="hlinkDigiLocker" runat="server"><i class="fa fa-cloud-download" aria-hidden="true"></i> DigiLocker</a></li>
                                        <li><a href="manuallyProcessing.aspx" id="hlinkAddress" runat="server"><i class="fa fa-id-card" aria-hidden="true"></i> Address</a></li>
                                        <li><a href="capturePhoto.aspx" id="hlinkCapturePhoto" runat="server"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                        <li><a href="profile.aspx" id="hlinkIncomeProfile" runat="server"><i class="fa fa-inr" aria-hidden="true"></i> Income Profile</a></li>
                                        <li><a href="TradingPreference.aspx" id="hlinkTradingPreference" runat="server"><i class="fa fa-exchange" aria-hidden="true"></i> Trading Preference</a></li>
                                        <li><a href="BankDetails.aspx" id="hlinkBankDetails" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Bank</a></li>
                                        <li><a href="Nomination.aspx" id="hlinkNomination" runat="server"><i class="fa fa-users" aria-hidden="true"></i> Nomination</a></li>
                                        <li><a href="dematAccount.aspx" id="hlinkDematAccount" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Demat Account</a></li>
                                        <li><a href="AuthorizedRepresentative.aspx" id="hlinkAuthorizedRepresentative" runat="server"><i class="fa fa-user-circle" aria-hidden="true"></i> Authorized Representative</a></li>
                                       </ul>
                                 </div>
                                  
                                 <div>
                            </div>
                                <div class="row">
                                    <div class="col-sm-6" >

                                    </div>
                                    <div class="col-sm-6 poweredBy" style="text-align:right;">
                                        <span style="font-size:small;text-align:right">Powered by</span></br>
				                        <a href="http://www.stansoftware.com">
					                        <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						                        </a>
			                        </div>
                                    </div>
                            </div>
                           </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
        </section>



    </form>
    
      <div id="alert-modal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="alert-modal-title" class="modal-title"></h4>
              </div>
              <div id="alert-modal-body" class="modal-body"></div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">OK</button>
              </div>
            </div>
          </div>
        </div>

    <div class="modal fade" id="modalLoading" tabindex="-1" role="dialog" aria-labelledby="modalLoadingLabel">
      <div class="modal-dialog modal-md">
        <div class="modal-content">
          <div class="modal-header">
          </div>
          <div class="modal-body">
              <center>
                    <h4>Please wait..Your request is being processed..</h4>
                    <p>Do not close browser window....</p>
                    <img src="../ekyc/images/Loading.gif" alt="Loading" style="width:150px;" />
               </center>
          </div>

          <div class="modal-footer">
          </div>
        </div>
      </div>
    </div>

</body>
</html>
