﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ReKYCstatus.aspx.cs" Inherits="Connect_DotNet.ReKYC.ReKYCstatus" %>

<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>ReKYC Status</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">
</head>
<body>
    <script>
        function gridRefresh() {

            //alert(document.getElementById("selectReKYCType").value);
            grdReKYCStatus.Refresh();
        }

    </script>
    <form id="frmReKYCStatus" runat="server">
        <div class="container-fluid">
		    <h1><i class="fa fa-user-pen" aria-hidden="true"></i> ReKYC Status</h1>
            <div class="row">
                <div class="col-sm-4">
                    <div class="form-outline flex-fill mb-0" style="margin-top:10px; margin-bottom:10px">
                    <label class="form-label" for="selectOccupation"><i class="fa fa-filter" aria-hidden="true"></i> ReKYC Type</label>
                        <select class="form-control" id="selectReKYCType" onchange="gridRefresh()" runat="server">
                            <option>Account Modification</option>
                            <option>Account Closure</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-4">
                </div>
                <div class="col-sm-4">
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                  <dx:ASPxGridView ID="grdReKYCStatus" ClientInstanceName="grdReKYCStatus" AutoGenerateColumns="False" CssClass="table" Theme="MetropolisBlue" Width="100%" runat="server" OnHtmlRowCreated="grdReKYCStatus_HtmlRowCreated">
                      <Columns>
                           <dx:GridViewDataMemoColumn FieldName="REQID" CellStyle-HorizontalAlign="Left" Caption="Req Id"  Width="50px" VisibleIndex="0">
                                <DataItemTemplate> 
                                    <span style="color:darkslategrey; font-size:12px"><%# Eval("REQID") %></span>
                                </DataItemTemplate>
                                <CellStyle HorizontalAlign="Left"></CellStyle>
                            </dx:GridViewDataMemoColumn>
                          <dx:GridViewDataMemoColumn FieldName="date" CellStyle-HorizontalAlign="Left" Caption="Req Date" Width="60px" VisibleIndex="1">
                                <DataItemTemplate> 
                                    <span><%# Eval("date") %></span>
                                </DataItemTemplate>
                                <CellStyle HorizontalAlign="Left"></CellStyle>
                            </dx:GridViewDataMemoColumn>
                          <dx:GridViewDataMemoColumn FieldName="ServiceType" CellStyle-HorizontalAlign="Left" Caption="Service Details" Width="40%" VisibleIndex="2">
                                <DataItemTemplate>
                                    <span style="color:midnightblue;"><%# Eval("Service") %></span>
                                </DataItemTemplate>
                                <CellStyle HorizontalAlign="Left"></CellStyle>
                            </dx:GridViewDataMemoColumn>
                           <dx:GridViewDataTextColumn FieldName="status" Width="35%" Caption="Current Status" VisibleIndex="3">
                                <DataItemTemplate>
                                    <table>
                                        <tr>
                                            <td>
                                                <span id="spanStatus" runat="server" style="font-size:12px;"><%# Eval("STATUS") %></span>&nbsp;
                                                <span id="spancheckedon"  style="font-size:12px;" runat="server">[<%# Eval("currentdate") %>]</span> &nbsp;
                                            </td>
                                            <td>
                                                <div id="divBtnModalInfo" style="display:none" runat="server">
                                                 <!-- Trigger the modal with a button -->
                                                  <button type="button" class="btn btn-danger btn-xs" onclick="modalInfoView('Rejected Reason [<%# Eval("REQID") %>]', '<%# Eval("rejectReason") %>');"><i class="fa fa-exclamation-triangle"></i></button>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                    
                                    
                                </DataItemTemplate>
                            </dx:GridViewDataTextColumn>
                      </Columns>
                      <SettingsBehavior AllowFocusedRow="True"></SettingsBehavior>
                      <SettingsPager Mode="EndlessPaging">
                      </SettingsPager>
                      <Settings ShowGroupedColumns="True" ShowGroupPanel="False" GridLines="Horizontal" />
                      <SettingsDetail ShowDetailRow="false" />
                      <SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
                      <Styles>
                        <Header Font-Bold="False" Font-Underline="False" VerticalAlign="Middle">
                        </Header>
                        <Cell>
                            <BorderBottom BorderColor="#336666" BorderStyle="Solid" BorderWidth="1px" />
                        </Cell>
                        <FocusedRow BackColor="WhiteSmoke">
                        </FocusedRow>
                        <Cell ForeColor="Black"></Cell>
                    </Styles>
                  </dx:ASPxGridView>
                <!-- Modal -->
                    <div class="modal fade" id="modalInfo" role="dialog">
                    <div class="modal-dialog modal-md">
                        <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                            <h4 class="modal-title" id="titleModalInfo" runat="server"></h4>
                        </div>
                        <div class="modal-body" id="bodyModalInfo" runat="server">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                    </div>
                </div>
              </div>
        </div>
    </form>
    <script>

        AdjustSize();

        function AdjustSize() {
            var height = Math.max(0, document.documentElement.clientHeight);
            grdReKYCStatus.SetHeight(height - 150);
        }

        function modalInfoView(title, bodytext) {
            //alert(bodytext);
            $('#titleModalInfo').html(title);
            $('#bodyModalInfo').html(bodytext);
            $('#modalInfo').modal('show');
        }

    </script>
</body>
</html>
