﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="OpenAccount.aspx.cs" Inherits="Connect_DotNet.eKYC.OpenAccount" %>

<!--     
eKyc System MAIN Entrance Page
-->

<!DOCTYPE html>
<html>
<head runat="server">
    <title>Open Account</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <!-- application specific stylesheets -->
    <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />
</head>
<body>

     <script>

          function IsMobileNumber(number) {
                var val = number.value
                if (/^\d{10}$/.test(val)) {
                    // value is ok, use it
                    return true
                } else {
                    alertModal("Error", "Invalid number; must be 10 digits!");
                    //alert("Invalid number; must be 10 digits!")
                    number.focus()
                    return false
                }
         }

         function sendMobileOTP(reSend) {

            var btnSendMobileOTP = document.getElementById('btnSendMobileOTP');
            var txtMobile = document.getElementById('txtMobile');
            var txtMobileOTP = document.getElementById('txtMobileOTP');
            var btnOTPMobileResend = document.getElementById('btnOTPMobileResend');
            var btnOTPMobileValidate = document.getElementById('btnOTPMobileValidate');

             txtMobileOTP.value = "";

             //alert(document.getElementById('chkbxIagree').checked);


            if (txtMobile.value == "") {
                alertModal("Error", "Please enter Mobile number!");
                return;
            }

            if (!IsMobileNumber(txtMobile))
                 return;

             
             if (document.getElementById('chkbxIagree').checked == false && reSend == false) {

                 alertModal("Error", "Please agree Terms of service!");
                 return;

             }

             document.getElementById('hdnBtnMobileVerificationClicked').value = "Sent OTP";
             //document.getElementById('divResendValidate').style = "display:block";

             
             $('#modalLoading').modal('show');
            document.getElementById('<%= btnMobileVerification.UniqueID %>').click();


         }

         function validateMobileOTP() {

             var txtMobileOTP = document.getElementById('txtMobileOTP');

             if (txtMobileOTP.value == "") {
                 alertModal("Error", "Please enter OTP!");
                 return;
             }

             document.getElementById('hdnBtnMobileVerificationClicked').value = "Validate OTP";

             $('#modalLoading').modal('show');
             document.getElementById('<%= btnMobileVerification.UniqueID %>').click();
         }

         function alertModal(title, body) {
             // Display error message to the user in a modal
             $('#alert-modal-title').html(title);
             $('#alert-modal-body').html(body);

             if (title.match("Error") == "Error") {
                 $('#alert-modal-body').addClass("alert-danger");
                 $('#alert-modal-body').removeClass("alert-info");
                 $('#alert-modal-body').removeClass("alert-success");
             }

             else if (title == "Request added") {
                 $('#alert-modal-body').addClass("alert-success");
                 $('#alert-modal-body').removeClass("alert-info");
                 $('#alert-modal-body').removeClass("alert-danger");
             }
             else {
                 $('#alert-modal-body').addClass("alert-info");
                 $('#alert-modal-body').removeClass("alert-danger");
                 $('#alert-modal-body').removeClass("alert-success");
             }

             
             $('#alert-modal').modal('show');

             $('#modalLoading').modal('hide');
         }
        
    </script>

    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                <div class="col-md-3">
                    <center>
                    <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:200px; padding-top:10px">
                    </center>
                </div>
                <div class="col-md-9">
                    <h2 class="lblTopHeader">Open Account <i class="fa fa-user" aria-hidden="true"></i></h2>
                    <p>Open a trading and demat account and start investing.</p>
                </div>
              </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5" id="divMain" runat="server">
                    <div class="row justify-content-center">
                      <div class="col-md-10 col-lg-6">

                        <p class="h2 fw-bold mb-5 mx-1 mx-md-4 mt-4">Signup Now
                            <br />
                            <small>or track your existing application</small>
                        </p>
                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnMobileVerification" runat="server" Text="" OnClick="btnMobileVerification_Click" /> 
                                    <input type="hidden" id="hdnBtnMobileVerificationClicked" name="hdnBtnMobileVerificationClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                <div class="form-outline flex-fill mb-0">
                                  <label class="form-label" for="txtMobile"><i class="fas fa-mobile fa-lg me-3 fa-fw"></i> Enter Mobile</label>
                                  <input type="number"  class="form-control" id="txtMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Mobile No.">
                                  <small id="smMsg" runat="server">You will receive an OTP on your number</small>
                      
                                </div>
                              </div>

                              <input type="number" class="form-control" id="txtMobileOTP"  maxlength="6" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter OTP" style="display:none">

                              <div class="form-check d-flex justify-content-center mb-5" style="margin-top:10px" id="divChkbxIagree" runat="server" >
                                <input class="form-check-input me-2" type="checkbox" value="" id="chkbxIagree" />
                                <label class="form-check-label" for="chkbxIagree">
                                  I agree all statements in <a href="#" onclick="$('#modalTerms').modal('show');">Terms and Conditions</a>
                                </label>
                              </div>

                              <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4" >
                                <button type="button" class="btn btn-primary btn-lg" id="btnSendMobileOTP" onclick="sendMobileOTP(false)" runat="server" ><i class="fa fa-bell" aria-hidden="true"></i> Continue</button>
                              </div>
                              <div id="divResendValidate" runat="server" style="display:none; margin-top:10px" >
                                <button type="button" class="btn btn-lg btn-success btnpadingtop" style="margin-top:5px" id="btnOTPMobileValidate" onclick="validateMobileOTP()"><i class="fa fa-check" aria-hidden="true"></i> Verify and confirm OTP</button>
                                <button type="button" class="btn btn-lg btn-primary btnpadingtop" style="margin-top:5px" id="btnOTPMobileResend" onclick="sendMobileOTP(true)"><i class="fa fa-repeat" aria-hidden="true"></i> Resend OTP</button>
                                  <br />
                                  <br />
                                  <span id="spanDebugOTP" runat="server" style="display:none"></span>
                              </div>
                            </ContentTemplate>
                        </asp:UpdatePanel>
                      </div>
                      <div class="col-md-10 col-lg-6 ">
                          <div class="mobilePage_FeaturedImage FeaturedImage modal-content rounded-4 shadow" style="margin-top:5px">
                              <!-- The image will be loaded from the css -->
                          </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
              <!--<div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>-->

              <div id="divErrorMsg" runat="server" style="margin-top:20px; height: 100%; display:none; width: 100%; text-align: center;">
                        <div class="alert alert-danger" role="alert">
				            <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span> <span id="spanError" runat="server"></span>
			            </div>
		            </div>


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span></br>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
			    </div>
             </div>

          </div>
        </section>
        
    </form>

    <div id="alert-modal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="alert-modal-title" class="modal-title"></h4>
              </div>
              <div id="alert-modal-body" class="modal-body"></div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">OK</button>
              </div>
            </div>
          </div>
        </div>

    <div class="modal fade" id="modalLoading" tabindex="-1" role="dialog" aria-labelledby="modalLoadingLabel">
      <div class="modal-dialog modal-md">
        <div class="modal-content">
          <div class="modal-header">
          </div>
          <div class="modal-body">
              <center>
                    <h4>Please wait..Your request is being processed..</h4>
                    <p>Do not close browser window....</p>
                    <img src="images/Loading.gif" alt="Loading" style="width:150px;" />
               </center>
          </div>

          <div class="modal-footer">
          </div>
        </div>
      </div>
    </div>

    <!-- Modal -->
<div class="modal fade" id="modalTerms" tabindex="-1" role="dialog" aria-labelledby="modalTermsLabel">
  <div class="modal-dialog modal-lg" style=" height: 97%;">
    <div class="modal-content" style=" height: 97%;">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h2 class="modal-title" id="modalTermsLabel">Terms and Conditions</h2>
      </div>
      <div class="modal-body" style="max-height: calc(75%);  overflow-y: scroll;">
        <div id="divtermsandconditionsHTML">
            <%=termsandconditionsHTML%>
        </div>
      </div>

      <div class="modal-footer">
          <div id="divSubmitBtns">
            <p id="divLocation" style="font-size:10px"></p>
            <button type="button" class="btn btn-success btn-lg" data-dismiss="modal"><i class="fa fa-check" aria-hidden="true"></i> Ok</button>
          </div>
        
      </div>
    </div>
  </div>
</div>

</body>
</html>
