﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="PANVerification.aspx.cs" Inherits="Connect_DotNet.eKYC.PANVerification" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>Open Account</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />

</head>
<body>
    <style>
        .margineTop10{
            margin-top:10px
        }
    </style>
     
    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                <div class="col-md-3">
                    <center>
                    <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px; padding-top:10px">
                    </center>
                </div>
                <div class="col-md-9">
                    <h2 class="lblTopHeader">PAN Verification <i class="fa fa-user" aria-hidden="true"></i></h2>
                    <p>We need to verify the status of your PAN card. Please enter your date-of-Birth as recorded in the PAN card.</p>
                </div>
               </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-10 col-lg-6">

                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnPANVerification" runat="server" Text="" OnClick="btnPANVerification_Click"/> 
                                    <input type="hidden" id="hdnBtnPANVerificationClicked" name="hdnBtnPANVerificationClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                    <label class="form-label" for="txtPAN"><i class="fa fa-id-card"></i> Enter your PAN Number *</label>
                                    <input type="text"  class="form-control" id="txtPAN" runat="server" placeholder="Enter PAN" maxlength="10">
                                  </div>
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                    <label class="form-label" for="dtBirthdate"><i class="fa fa-calendar"></i> Date of Birth*</label>
                                    <input type="date"  class="form-control" id="dtBirthdate" runat="server" placeholder="Enter Birthdate" min="1900-01-01">
                                  </div>
                              </div>

                              <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                  <button type="button" class="btn btn-lg btn-success btnpadingtop" id="btnVerification" runat="server" onclick="panVerification('panVerification');"><i class="fa fa-check" aria-hidden="true"></i> Verify PAN</button>
                                  <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                  </div>

                                  <button type="button" class="btn btn-primary btn-lg" id="btnContinue" onclick="panVerification('panVerificationNext');" runat="server" style="display:none" ><i class="fa fa-share-square" aria-hidden="true"></i> Continue </button>
                              </div>

                            </ContentTemplate>
                        </asp:UpdatePanel>
                      </div>
                      <div class="col-md-10 col-lg-6" style="padding-top:20px; text-align:center ">
                          <img src="images/PAN.png" alt="Sample image" style="width:70%">
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
              <!--<div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>-->
             <br /><br />
              <!-- Features Section -->
                <section id="features" class="py-5">
                    <center>
                    <hr style="color:silver;width:50%;padding:10px;margin:0px;" />
                    </center>
                    <div class="container text-center">
                        <h2 class="mb-4">Why Verify Your PAN?</h2>
                        <div class="row">
                            <div class="col-md-4">
                                <h4>Regulator Compliance</h4>
                                <p>PAN is a mandatory requirement for all transactions in the securities market, as per SEBI guidelines and the Prevention of Money Laundering (PML) Act13. Although PAN is not considered an identity proof, it serves as a key identification number for financial transactions</p>
                            </div>
                            <div class="col-md-4">
                                <h4>Identification and Verification</h4>
                                <p>Your PAN is linked to your other personal details, like Aadhaar, Bank accounts, etc. So, PAN verification authenticates your identity with us and the regulators.</p>
                            </div>
                            <div class="col-md-4">
                                <h4>Transaction Facilitation</h4>
                                <p>A validated PAN allows you to transact smoothely with a SEBI Registered entity like us.</p>
                            </div>
                        </div>
                    </div>
                </section>


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span></br>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
			    </div>
             </div>

          </div>
        </section>
        
    </form>


    <script>

         $(document).ready(function () {
             var today = new Date();
             var day = today.getDate() > 9 ? today.getDate() : "0" + today.getDate(); // format should be "DD" not "D" e.g 09
             var month = (today.getMonth() + 1) > 9 ? (today.getMonth() + 1) : "0" + (today.getMonth() + 1);
             var year = today.getFullYear();

             $("#dtBirthdate").attr('max', year + "-" + month + "-" + day);
         });


         // Client-side validation
         function panVerification(verificationValue) {

             if (document.getElementById('txtPAN').value == "") {
                 alertModal("Oops", "You have not entered your PAN number. This step is crucial and needs to be done. Please enter teh details as required correctly.");
                 return;
             }

             if (document.getElementById('dtBirthdate').value == "") {
                 alertModal("Oops", "Please enter or select your Date of Birth");
                 return;
             }

             document.getElementById('hdnBtnPANVerificationClicked').value = verificationValue;

             showModalLoading();

             // Force click the Verify Button
             document.getElementById('<%= btnPANVerification.UniqueID %>').click();
             
         }

    </script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="js/ekyc.js"></script>    
</body>
</html>
