﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ClickToCall.aspx.cs" Inherits="Connect_DotNet.ClickToCall" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>
	
	<!-- #CSS Links -->
	<!-- Basic Styles -->
    <!--
	<link rel="stylesheet" type="text/css" media="screen" href="../css/bootstrap.min.css">
    -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

	<link href="../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-skins.min.css">
	
	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">
	
	<link href="../css/your_style.css" rel="stylesheet" />

	<style>
		#tblCall { border:none !important }
		#tblCall th, #tblCall td {
			padding:0 5px 0 0px !important;
			vertical-align:middle !important;
			border:none !important;
		}
		#tblCall td:nth-child(odd) { text-align:right }

		.completionList { max-height:250px;min-width:350px;overflow-y:auto;background-color:white;border:1px solid silver;margin:0;padding:3px }
		.listItem { color:black;padding:3px }
		.itemHighlighted { background-color:lightyellow;padding:3px }
	</style>

</head>
<body>
	<div class="container-fluid">
		<h2>Click On Call</h2>
		<div class="row">
			<div class="col-sm-8">
				<form id="frmCall" runat="server">
					<asp:ScriptManager ID=ScriptManager1 runat="server" EnablePageMethods="true" EnablePartialRendering="true"></asp:ScriptManager>
					<table id="tblCall" class="table table-condensed table-responsive">
						<colgroup><col style="width:10%"/><col style="width:20%"/><col /><col style="width:10%"/></colgroup>
						<tr>
							<td>Call to</td>
							<td>
								<asp:DropDownList ID=ddlTo runat="server" Width="100%" AutoPostBack="true" CssClass="form-control input-sm" OnSelectedIndexChanged="ddlTo_SelectedIndexChanged">
									<asp:ListItem Value="CLIENT" Selected="True">Client</asp:ListItem>
									<asp:ListItem Value="SUBBR">Sub-Broker(AP)</asp:ListItem>
								</asp:DropDownList>
							</td>
							<td>
								<ajaxToolkit:AutoCompleteExtender ID=AutoCompleteExtender1 runat="server" 
									CompletionListCssClass="completionList"
									CompletionListItemCssClass="listItem"
									CompletionListHighlightedItemCssClass="itemHighlighted"
									ServiceMethod="GetCompletionList"
									MinimumPrefixLength="1"    
									CompletionInterval="10" 
									EnableCaching="false"
									TargetControlID="txtEntity"    
									FirstRowSelected="false" 
									OnClientItemSelected="SelectedItem">   
								</ajaxToolkit:AutoCompleteExtender>
								<asp:HiddenField ID=hdnEntityValue runat="server" />
								<asp:TextBox ID=txtEntity runat="server" Width="100%" CssClass="form-control input-sm"></asp:TextBox>
							</td>
							<td><asp:Button ID=btnCall runat="server" Text="Call" CssClass="btn btn-primary" OnClick="btnCall_Click"/></td>
						</tr>
					</table>
				</form>
			</div>
			<div class="col-sm-4"></div>
		</div>
	</div>

    <!--
	<script src="../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../js/bootstrap/bootstrap.min.js"></script>
    -->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>

	<script type="text/javascript" src="../scripts/ssajax.js"></script>

	<script>
		function SelectedItem( source, eventArgs ) {
			document.getElementById("hdnEntityValue").value =  eventArgs.get_value();
			//alert(" Key :" + eventArgs.get_text() + "  Value :  " + eventArgs.get_value());
			//alert(document.getElementById("hdnEntityValue").value);
		}
	</script>
</body>
</html>
