﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="InventoryStockHoldings.aspx.cs" Inherits="Connect_DotNet.InventoryStockHoldings" EnableViewState="true" %>

<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<%@ Register Assembly="ssCommon" Namespace="ssCommon.Controls.BrowserControls" TagPrefix="ss" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>

	<!-- #CSS Links -->
	<!-- Basic Styles 
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
        -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-skins.min.css">

	<!-- BootComplete http://getwebhelp.com/bootcomplete/ -->
	<link href="../../scripts/BootStrap/plugins/bootcomplete/bootcomplete.css" rel="stylesheet" />

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">

	<link href="../../css/your_style.css" rel="stylesheet" />
	<link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />

	<style>
		#tblInput { border:none !important }
		.NoBorder td { border:none !important }
		.AlignMiddle td { vertical-align:middle !important }
	</style>
</head>
<body>
	<div class=container-fluid>
		<h2><i class="fa fa-hand-rock-o" aria-hidden="true"></i> Inventory Stock Holdings</h2>
		<form id="frmHoldings" runat="server">
			<asp:HiddenField ID=hdnProductCd runat="server" />
			<div class=row>
				<div class=col-sm-6>
					<table id=tblInput class="table table-responsive table-condensed NoBorder AlignMiddle">
						<tr>
							<td style="text-align:right">Inventory Head :</td>
							<td>
								<dx:ASPxComboBox ID=cboInventoryHeads runat="server" CssClass="form-control input-sm" Theme=MetropolisBlue></dx:ASPxComboBox>
							</td>
							<td>
								<ss:ASPxButton ID=btnView runat="server" Text="View" CssClass="btn btn-primary" OnClick=btnView_Click></ss:ASPxButton>
							</td>
						</tr>
					</table>
				</div>
				<div class=col-sm-6></div>
			</div>
			<div class=row>
				<div class=col-sm-12>
					<dx:ASPxGridView ID=grdHoldings runat="server" ClientInstanceName=grdHoldings KeyFieldName="ProductCd" 
						Width=100% Theme=MetropolisBlue SettingsBehavior-AllowSort=false
						OnDetailRowExpandedChanged=grdHoldings_DetailRowExpandedChanged>
						<Styles>
							<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
						</Styles>
						<Columns>
							<dx:GridViewDataColumn FieldName="ProductCd" Visible=false />
							<dx:GridViewDataColumn FieldName="Product" Caption=Particulars VisibleIndex="1" />
							<dx:GridViewDataTextColumn FieldName="HO Holdings" VisibleIndex="2" ReadOnly=true 
								PropertiesTextEdit-DisplayFormatString="0.00" HeaderStyle-HorizontalAlign=Right />
							<dx:GridViewDataTextColumn FieldName="Branch Holdings" VisibleIndex="3" ReadOnly=true 
								PropertiesTextEdit-DisplayFormatString="0.00" HeaderStyle-HorizontalAlign=Right />
							<dx:GridViewDataTextColumn FieldName="Staff Holdings" VisibleIndex="4" ReadOnly=true 
								PropertiesTextEdit-DisplayFormatString="0.00" HeaderStyle-HorizontalAlign=Right />
							<dx:GridViewDataTextColumn FieldName="AP Holdings" VisibleIndex="5" ReadOnly=true 
								PropertiesTextEdit-DisplayFormatString="0.00" HeaderStyle-HorizontalAlign=Right />
							<dx:GridViewDataTextColumn FieldName="Net Holdings" VisibleIndex="6" ReadOnly=true 
								PropertiesTextEdit-DisplayFormatString="0.00" HeaderStyle-HorizontalAlign=Right />
						</Columns>
						<Templates>
							<DetailRow>
								<div style="padding: 3px 3px 2px 3px">
									<dx:ASPxPageControl runat="server" ID="pageControl" Width="100%" Theme=MetropolisBlue
										OnTabClick=pageControl_TabClick>
										<TabPages>
											<dx:TabPage Text="Branch Holdings" Visible="true">
												<ContentCollection>
													<dx:ContentControl runat="server">
														<dx:ASPxGridView ID=grdBranchHoldings runat="server" EnableViewState=true
															OnPageIndexChanged=grdChild_PageIndexChanged
															Width=50% SettingsBehavior-AllowSort=false Theme=MetropolisBlue>
															<Styles>
																<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
															</Styles>
															<Columns>
																<dx:GridViewDataColumn FieldName="Holder" VisibleIndex="1" />
																<dx:GridViewDataTextColumn FieldName="Quantity" VisibleIndex="2" ReadOnly=true 
																	PropertiesTextEdit-DisplayFormatString="0.00" HeaderStyle-HorizontalAlign=Right />
															</Columns>
														</dx:ASPxGridView>
													</dx:ContentControl>
												</ContentCollection>
											</dx:TabPage>
											<dx:TabPage Text="Staff Holdings" Visible="true">
												<ContentCollection>
													<dx:ContentControl runat="server">
														<dx:ASPxGridView ID=grdStaffHoldings runat="server" EnableViewState=true
															OnPageIndexChanged=grdChild_PageIndexChanged
															Width=50% SettingsBehavior-AllowSort=false Theme=MetropolisBlue>
															<Styles>
																<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
															</Styles>
															<Columns>
																<dx:GridViewDataColumn FieldName="Holder" VisibleIndex="1" />
																<dx:GridViewDataTextColumn FieldName="Quantity" VisibleIndex="2" ReadOnly=true 
																	PropertiesTextEdit-DisplayFormatString="0.00" HeaderStyle-HorizontalAlign=Right />
															</Columns>
														</dx:ASPxGridView>
													</dx:ContentControl>
												</ContentCollection>
											</dx:TabPage>
											<dx:TabPage Text="AP Holdings" Visible="true">
												<ContentCollection>
													<dx:ContentControl runat="server">
														<dx:ASPxGridView ID=grdApHoldings runat="server" EnableViewState=true
															OnPageIndexChanged=grdChild_PageIndexChanged
															Width=50% SettingsBehavior-AllowSort=false Theme=MetropolisBlue>
															<Styles>
																<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
															</Styles>
															<Columns>
																<dx:GridViewDataColumn FieldName="Holder" VisibleIndex="1" />
																<dx:GridViewDataTextColumn FieldName="Quantity" VisibleIndex="2" ReadOnly=true 
																	PropertiesTextEdit-DisplayFormatString="0.00" HeaderStyle-HorizontalAlign=Right />
															</Columns>
														</dx:ASPxGridView>
													</dx:ContentControl>
												</ContentCollection>
											</dx:TabPage>
										</TabPages>
									</dx:ASPxPageControl>
							</DetailRow>
						</Templates>
						<ClientSideEvents DetailRowExpanding="function(s, e) { Row_Click(s, e) }" />
					</dx:ASPxGridView>
				</div>
			</div>
		</form>
	</div>

	<!--================================================== 

	<script src="../../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../../js/bootstrap/bootstrap.min.js"></script>
        -->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>


	<!-- StanSoft Script -->
	<script src="../../scripts/ssajax.js"></script>

	<script>
		function Row_Click(s, e)
		{
			document.getElementById("hdnProductCd").value = grdHoldings.GetRowKey(e.visibleIndex)
		}
	</script>
</body>
</html>
