﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="AddScannedImage.aspx.cs" Inherits="Connect_DotNet.AddScannedImage" %>

<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<%@ Register Assembly="ssCommon" Namespace="ssCommon.Controls.BrowserControls" TagPrefix="ss" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>

	<!-- #CSS Links -->
	<!-- Basic Styles -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">

	<link href="../../css/your_style.css" rel="stylesheet" />
	<link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />

	<style>
		table td { vertical-align:middle !important; padding:2px !important }
		.alignRight { text-align:right }
		.noBorder { border:none !important }
			.noBorder td { border:none !important }
	</style>
</head>
<body style="overflow:hidden">
	<br />
    <form id="frmScannedImage" runat="server">
	<asp:ScriptManager ID=ScriptManager1 runat="server" EnablePageMethods="true" EnablePartialRendering="true"></asp:ScriptManager>
    <table id=tblInput class="table table-responsive table-condensed noBorder">
		<colgroup><col style="width:20%"/><col /><col style="width:10%"/><col style="width:5%"/></colgroup>
		<tr>
			<td class=alignRight>File Type</td>
			<td>
				<dx:ASPxComboBox ID=cboFileType runat="server" ClientInstanceName="cboFileType"
					CssClass="form-control input-sm" Theme=MetropolisBlue>
					<Items>
						<dx:ListEditItem Text=Image Value="0" />
						<dx:ListEditItem Text=File Value="1" />
					</Items>
				</dx:ASPxComboBox>
			</td>
			<td></td><td></td>
		</tr>
		<tr>
			<td class=alignRight>Category</td>
			<td>
				<dx:ASPxComboBox ID=cboCategory ClientInstanceName=cboCategory runat="server" 
					CssClass="form-control input-sm" Theme=MetropolisBlue>
					<ClientSideEvents SelectedIndexChanged="function(s, e) { cboCategory_SelectedIndexChanged(); }" />
				</dx:ASPxComboBox>
			</td>
		</tr>
		<tr>
			<td class=alignRight>Image Type</td>
			<td>
				<ss:ASPxTextBox ID=txtImageType ClientInstanceName=txtImageType MaxLength=20 runat="server" 
					CssClass="form-control input-sm" Theme=MetropolisBlue>
				</ss:ASPxTextBox>
			</td>
		</tr>
		<tr>
			<td class=alignRight>Description</td>
			<td>
				<ss:ASPxTextBox ID=txtDescr MaxLength=100 runat="server" CssClass="form-control input-sm" Theme=MetropolisBlue>
				</ss:ASPxTextBox>
			</td>
		</tr>
		<tr>
			<td class=alignRight style="vertical-align:top !important">Notes</td>
			<td>
				<dx:ASPxMemo ID=txtNotes runat="server" Height="70" Width="100%" 
					CssClass="form-control input-sm" Theme=MetropolisBlue>
				</dx:ASPxMemo>
			</td>
		</tr>
		<tr>
			<td class=alignRight style="vertical-align:top !important">Image</td>
			<td>
				<asp:UpdatePanel ID=UpdatePanel5 runat="server">
					<ContentTemplate>
						<asp:FileUpload ID=uldImage AllowMultiple="false" runat="server" CssClass="form-control input-sm" />
						<asp:HiddenField ID=hdnScnImgFolder runat="server" />
						<dx:ASPxLabel ID=lblUploadStatus runat="server"></dx:ASPxLabel>
					</ContentTemplate>
					<Triggers>
						<asp:PostBackTrigger ControlID="btnUpload" />
					</Triggers>
				</asp:UpdatePanel>
			</td>
			<td style="vertical-align:top !important">
				<dx:ASPxButton ID=btnUpload Text="Upload" runat="server" OnClick=btnUpload_Click CssClass="btn btn-success btn-sm">
					<ClientSideEvents Click="function(s,e) { e.processOnServer = btnUpload_click(s,e); }" />
				</dx:ASPxButton>
			</td>
		</tr>
    </table>
    </form>

	<!--================================================== -->
	<script src="../../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../../js/bootstrap/bootstrap.min.js"></script>

	<script>
		parent.$("#btn1").hide();

		$(document).ready(function () {
		});

		function cboCategory_SelectedIndexChanged()
		{
			txtImageType.SetText(cboCategory.GetText());
		}

		function btnUpload_click(s, e) {
			var uldImage = document.getElementById("uldImage");
			var uploadFile = uldImage.files[0];
			var lblUploadStatus = document.getElementById("lblUploadStatus");

			var permittedExt = [".png", ".jpg", ".jpeg", ".bmp", ".tif", ".tiff"];
			if(cboFileType.GetValue() == "1") {
				permittedExt = [".pdf", ".xls", ".xlsx", ".csv", ".txt"];
			}

			var extAllowed = false;
			for(var index = 0; index < permittedExt.length; index++) {
				var extension = uldImage.value.substr(uldImage.value.length - permittedExt[index].length).toLowerCase();
				extAllowed = permittedExt.includes(extension);
				if(extAllowed) break;
			}

			lblUploadStatus.style.color = "crimson";
			var error = "";
			if(uploadFile.size > 1000000) {
				error = "File size must be within 1MB<br>";
			}
			if(extAllowed == false) {
				if(cboFileType.GetValue() == "0") {
					error += "Image format allowed are .png, .jpg, .jpeg, .bmp, .tif, .tiff";
				}
				else {
					error += "File format allowed are .pdf, .xls, .xlsx, .csv, .txt";
				}
			}

			if(error != "") {
				lblUploadStatus.innerHTML = error;
				uldImage.value = null;
				return false;
			}

			return true;
		}

	</script>
</body>
</html>
