﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="NewClientRequest.aspx.cs" Inherits="Connect_DotNet.NewClientRequest" %>

<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<!DOCTYPE html>

<html>
<head runat="server">
	<title></title>

	<!-- #CSS Links -->
	<!-- Basic Styles -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-skins.min.css">

	<!-- BootComplete http://getwebhelp.com/bootcomplete/ -->
	<link href="../../scripts/BootStrap/plugins/bootcomplete/bootcomplete.css" rel="stylesheet" />

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">

	<link href="../../css/your_style.css" rel="stylesheet" />
	<link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />

	<style>
		#tblInput, #tblButtons { border:none !important }
			#tblInput th, #tblInput td, #tblButtons th, #tblButtons td { border:none !important; padding:3px !important }

		.alignRight { text-align: right; vertical-align:middle !important }

		.completionList { max-height: 250px; min-width: 350px; overflow-y: auto; background-color: white; border: 1px solid silver; margin: 0; padding: 3px }
		.listItem { color: black; padding: 3px }
		.itemHighlighted { background-color: lightyellow; padding: 3px }

		.borderless td { border: none !important }
		.form-group { margin-bottom: 0px }

		.form-horizontal .form-group { margin-left: 0px !important; margin-right: 0px !important }

		.marginbottom { margin-bottom: 5px !important }

		.tblpadding td { padding: 2px !important }

		#lstPendingClientList { overflow-y:scroll !important }

		#myWizard li { padding:0 0 0 20px; height:32px; line-height:32px; font-size:14px }
			#myWizard li .chevron { border-top-width: 17px; border-bottom-width: 17px; border-left-width: 10px; }
			#myWizard .actions { padding:0 10px; height:32px; line-height:32px }
	</style>

	<script>
		function SelectedItem(source, eventArgs) {
			document.getElementById("hdnEntityCd").value = eventArgs.get_value();
		}
	</script>
</head>
<body>
	<div class="container-fluid">
		<!--<h2><i class="fa fa-user-plus" aria-hidden="true"></i> KYC Form Entry</h2>-->
		<br />
		<form id="frmClientRequest" runat="server" class="form-horizontal">
			<asp:ScriptManager ID="ScriptManager1" runat="server" EnablePageMethods="true"></asp:ScriptManager>
			<asp:HiddenField ID=hdnKycSource runat="server" />
			
				<div class=row>
					<asp:UpdatePanel ID=UpdatePanel1 runat="server">
					<ContentTemplate>
						<div class="col-sm-2">
							<dx:ASPxButton ID="btnFromLead" ToolTip="KYC from Lead" Native=true CssClass="btn btn-xs btn-warning" 
								Text="KYC from Lead" runat=server Width=100% OnClick=btnKycList_Click>
								<ClientSideEvents Click="function(s,e) { 
									$('#ipleasewait').css('visibility', 'visible');
									$('#hdnKycSource').val('LEAD');
								}" />
							</dx:ASPxButton>
						</div>
						<div class="col-sm-2">						
							<dx:ASPxButton ID="btnIncomplete" ToolTip="Open Incomplete KYC" Native=true CssClass="btn btn-xs btn-primary" 
								Text="Open Incomplete KYC" runat=server Width=100% OnClick=btnKycList_Click>
								<ClientSideEvents Click="function(s,e) { 
									$('#ipleasewait').css('visibility', 'visible');
									$('#hdnKycSource').val('INCOMPLETE');
								}" />
							</dx:ASPxButton>
						</div>
						<div class="modal fade" id="modalKycList" role="dialog">
							<div class="modal-dialog modal-md">
								<!-- Modal content-->
								<div class="modal-content">
									<div class="modal-header ">
										<h4 class="modal-title"><i class="fa fa-list" aria-hidden="true"></i> KYC List</h4>
									</div>
									<div class="modal-body">
										<input type="text" id="txtSearch" onkeyup="searchNames()" placeholder="Search for names.." class="form-control input-sm">
										<dx:ASPxListBox ID="lstPendingClientList" ClientInstanceName="lstPendingClientList" CssClass="form-control input-sm"
											SelectedIndex="-1" Width="100%" Height=250 runat="server" ValueType="System.String" Native=true 
											OnCallback=lstPendingClientList_Callback>
										</dx:ASPxListBox>
									</div>
									<div class="modal-footer">
										<asp:Button ID=btnOk runat="server" Text="Ok" CssClass="btn btn-success" OnClick=btnOk_Click />
										<button type="button" id="btnCancel" data-dismiss="modal" class="btn btn-danger">
											Cancel
										</button>
									</div>
								</div>
							</div>
						</div>
					</ContentTemplate>
					</asp:UpdatePanel>
					<div class="col-sm-2">
						<dx:ASPxButton ID="btnNewRequest" ToolTip="Add New KYC" Native=true CssClass="btn btn-xs btn-success" 
							Text="Add New KYC" runat="server" Width=100% OnClick="btnNewRequest_Click">
						</dx:ASPxButton>
					</div>
				</div>
				<br />
				<div class="row">
					<div class="col-sm-12">
						<div class="panel panel-default">
							<div class="panel-body status">	
								<div id="divWizardFuelux" runat="server" class="fuelux">
								
									<div class="wizard" id="myWizard">
										<ul class="steps">
											<li data-target="#step1" class="active">
												<span class="badge badge-info">1</span>General<span class="chevron"></span>
											</li>
											<li data-target="#step2">
												<span class="badge">2</span>Introducer<span class="chevron"></span>
											</li>
											<li data-target="#step3">
												<span class="badge">3</span>Operation<span class="chevron"></span>
											</li>
											<li data-target="#step4">
												<span class="badge">4</span>DP A/Cs<span class="chevron"></span>
											</li>
											<li data-target="#step5">
												<span class="badge">5</span>Agreement<span class="chevron"></span>
											</li>
											<li data-target="#step6">
												<span class="badge">6</span>Bank A/Cs<span class="chevron"></span>
											</li>
											<li data-target="#step7">
												<span class="badge">7</span>Personal<span class="chevron"></span>
											</li>
											<li data-target="#step8">
												<span class="badge">8</span>Others<span class="chevron"></span>
											</li>
											<li data-target="#step9">
												<span class="badge">9</span>Images<span class="chevron"></span>
											</li>
										</ul>
										<div class="actions">
											<button id=btnPrev type="button" class="btn btn-xs btn-primary">
												<i class="fa fa-arrow-left"></i> Prev
											</button>
											<button id=btnNext type="button" class="btn btn-xs btn-success" data-last="Save">
												Next <i class="fa fa-arrow-right"></i>
											</button>
										</div>
									</div>

									<div class="step-content">

										<div class="step-pane active" id="step1">
											<!-- <h3><strong>Step 1 </strong> - General</h3> -->
											<br />
											<fieldset>
												<table id="tblInputstep1" class="table table-responsive borderless tblpadding">
													<colgroup>
														<col style="width:10%" /><col style="width:35%" />
														<col style="width:20%" /><col style="width:30%" />
													</colgroup>
													<tr>
														<td class="alignRight">Name :</td>
														<td colspan="2">
															<div class="form-group has-error" style="width: 100%">
																<div class="input-group">
																	<dx:ASPxTextBox ID="txtName" ClientInstanceName="txtName" runat="server" Width="100%" 
																		CssClass="form-control input-sm upper" Theme=MetropolisBlue>
																	</dx:ASPxTextBox>
																	<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																</div>
															</div>
														</td>
													</tr>
													<tr>
														<td class="alignRight">Type :</td>
														<td>
															<dx:ASPxComboBox ID=cboAccType ClientInstanceName="cboAccType" runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
																<Items>
																	<dx:ListEditItem Selected="true" Text="Normal" Value="Normal" />
																	<dx:ListEditItem Text="Franchisee" Value="Franchisee" />
																	<dx:ListEditItem Text="Franchisee Client" Value="Franchisee Client" />
																	<dx:ListEditItem Text="FI" Value="FI" />
																	<dx:ListEditItem Text="FII" Value="FII" />
																	<dx:ListEditItem Text="Sub-Broker" Value="Sub-Broker" />
																	<dx:ListEditItem Text="Trading Member" Value="Trading Member" />
																	<dx:ListEditItem Text="Pms Client" Value="Pms Client" />
																	<dx:ListEditItem Text="Pms Client" Value="Pms Custodian" />
																</Items>
															</dx:ASPxComboBox>
														</td>
														<td class="alignRight">Branch :</td>
														<td>
															<dx:ASPxComboBox ID=cboBranches ClientInstanceName=cboBranches runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxComboBox>
														</td>
													</tr>
												</table>
												<div class="tab-content" style="border-bottom:1px solid lightgray">
													<div class="tab-pane active" id="tab-pane-gen">

														<ul class="nav nav-tabs">
															<li class="active">
																<a href="#Contacts" data-toggle="tab" aria-expanded="false">Contact Details</a>
															</li>
															<li>
																<a href="#Correspondence" data-toggle="tab" aria-expanded="true">Correspondence Address</a>
															</li>
															<li>
																<a href="#Residence" data-toggle="tab" aria-expanded="false">Residence Address</a>
															</li>
															<li>
																<a href="#Foreign" data-toggle="tab" aria-expanded="false">Foreign Address</a>
															</li>
															<li>
																<a href="#Holders" data-toggle="tab" aria-expanded="false">Joint Holders</a>
															</li>
														</ul>

														<div class="tab-content padding-10">

															<div class="tab-pane active in" id="Contacts">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td class="alignRight">Mobile No. :</td>
																		<td>
																			<div class="form-group has-error" style="width: 100%">
																				<div class="input-group">
																					<dx:ASPxTextBox ID=txtMobile ClientInstanceName="txtMobile" runat="server" Width="100%" 
																						CssClass="form-control input-sm">
																					</dx:ASPxTextBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">Email :</td>
																		<td>
																			<div class="form-group has-error" style="width: 100%">
																				<div class="input-group">
																					<dx:ASPxTextBox ID=txtEmail1 ClientInstanceName="txtEmail1" runat="server" Width="100%" 
																						CssClass="form-control input-sm email" Theme=MetropolisBlue>
																					</dx:ASPxTextBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																</table>
															</div>

															<div class="tab-pane fade" id="Correspondence">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td class="alignRight">Address :</td>
																		<td colspan="3">
																			<div class="form-group has-error" style="width: 100%">
																				<div class="input-group">
																					<dx:ASPxTextBox ID=txtAddress1 ClientInstanceName="txtAddress1" runat="server" Width="100%" 
																						CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxTextBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																	<tr>
																		<td></td>
																		<td colspan="3">
																			<dx:ASPxTextBox ID=txtAddress2 ClientInstanceName="txtAddress2" runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td></td>
																		<td colspan="3">
																			<dx:ASPxTextBox ID=txtAddress3 ClientInstanceName="txtAddress3" runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Pin Code :</td>
																		<td>
																			<div class="form-group has-error" style="width: 100%">
																				<div class="input-group">
																					<dx:ASPxTextBox ID=txtPinCode ClientInstanceName="txtPinCode" runat="server" Width="100%" 
																						CssClass="form-control input-sm digit" Theme=MetropolisBlue>
																					</dx:ASPxTextBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">City :</td>
																		<td>
																			<div class="form-group has-error" style="width: 100%">
																				<div class="input-group">
																					<dx:ASPxTextBox ID=txtCity ClientInstanceName="txtCity" runat="server" Width="100%" 
																						CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxTextBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">State / Union Territory :</td>
																		<td>
																			<div class="form-group has-success" style="width: 100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboState ClientInstanceName="cboState" runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">Country :</td>
																		<td>
																			<div class="form-group has-success" style="width: 100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboCountry ClientInstanceName="cboCountry" runat="server" Width="100%" 
																						CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Phones :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtPhone ClientInstanceName="txtPhone" runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Fax :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtFax ClientInstanceName="txtFax" runat="server" Width="100%" 
																				CssClass="form-control input-sm digit" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																</table>
															</div>

															<div class="tab-pane fade" id="Residence">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td></td>
																		<td colspan="3">
																			<dx:ASPxCheckBox ID=chkIsResidanceAddressSame runat="server" 
																				Text="Same as Correspondence Address !!" Theme=MetropolisBlue>
																				<ClientSideEvents CheckedChanged="function(s, e) { FillResidanceAddress(s, e); }" />
																			</dx:ASPxCheckBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Address :</td>
																		<td colspan="3">
																			<dx:ASPxTextBox ID=txtResidanceAddress1 ClientInstanceName="txtResidanceAddress1" runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td></td>
																		<td colspan="3">
																			<dx:ASPxTextBox ID=txtResidanceAddress2 ClientInstanceName="txtResidanceAddress2" runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td></td>
																		<td colspan="3">
																			<dx:ASPxTextBox ID=txtResidanceAddress3 ClientInstanceName="txtResidanceAddress3" runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Pin Code :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtResidancePinCode ClientInstanceName="txtResidancePinCode" runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">City :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtResidanceCity ClientInstanceName="txtResidanceCity" runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">State / Union Territory :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboResidanceState ClientInstanceName="cboResidanceState" runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxComboBox>
																		</td>
																		<td class="alignRight">Country :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboResidanceCountry ClientInstanceName="cboResidanceCountry" runat="server" 
																				Width="100%" CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxComboBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Phones :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtResidancePhone ClientInstanceName="txtResidancePhone" runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Fax :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtResidanceFax ClientInstanceName="txtResidanceFax" runat="server" Width="100%" 
																				CssClass="form-control input-sm digit" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																</table>
															</div>

															<div class="tab-pane fade" id="Foreign">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup><col style="width:20%" /><col style="width:30%" /><col style="width:20%" /><col style="width:30%" /></colgroup>
																	<tr>
																		<td class="alignRight">Address :</td>
																		<td colspan="3">
																			<dx:ASPxTextBox ID=txtForeignAddress1 runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td></td>
																		<td colspan="3">
																			<dx:ASPxTextBox ID=txtForeignAddress2 runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td></td>
																		<td colspan="3">
																			<dx:ASPxTextBox ID=txtForeignAddress3 runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Pin Code :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtForeignPinCode runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">City :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtForeignCity runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">State / Union Territory :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtForeignState runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Country :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboForeignCountry runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxComboBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Phones :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtForeignPhone ClientInstanceName="txtTel" runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Fax :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtForeignFax runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																</table>
															</div>

															<div class="tab-pane fade" id="Holders">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup><col style="width:20%" /><col style="width:30%" /><col style="width:20%" /><col style="width:30%" /></colgroup>
																	<tr>
																		<td class="alignRight">2nd Holder Name :</td>
																		<td>
																			<dx:ASPxTextBox ID=txt2ndHolderName runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">2nd Holder PAN :</td>
																		<td>
																			<dx:ASPxTextBox ID=txt2ndHolderPAN runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">3rd Holder Name :</td>
																		<td>
																			<dx:ASPxTextBox ID=txt3rdHolderName runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">3rd Holder PAN :</td>
																		<td>
																			<dx:ASPxTextBox ID=txt3rdHolderPAN runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Mode of Account Holding :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboAccHoldingMode runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																				<Items>
																					<dx:ListEditItem Text="(None)" Value=""/>
																					<dx:ListEditItem Text="Single" Value="1"/>
																					<dx:ListEditItem Text="Joint" Value="2"/>
																					<dx:ListEditItem Text="Anyone Or Survivor" Value="3"/>
																				</Items>
																			</dx:ASPxComboBox>
																		</td>
																		<td></td>
																		<td></td>
																	</tr>
																</table>
															</div>

														</div>
													</div>
												</div>
												<br />
												<div>
													<table class="table table-responsive borderless tblpadding">
														<colgroup><col style="width:10%" /><col style="width:90%" /></colgroup>
														<tr>
															<td class="alignRight" style="vertical-align:top !important">
																Notes :
															</td>
															<td colspan="3">
																<dx:ASPxMemo ID=txtNotes ClientInstanceName="txtNotes" runat="server" Height="70" Width="100%" 
																	CssClass="form-control input-sm" Theme=MetropolisBlue>
																</dx:ASPxMemo>
															</td>
														</tr>
													</table>
												</div>
											</fieldset>
										</div>

										<div class="step-pane" id="step2">
											<!-- <h3><strong>Step 2 </strong>- Introducer</h3> -->
											<br />
											<fieldset>
												<table id="tblInputstep2" class="table table-responsive borderless tblpadding">
													<colgroup><col style="width:20%" /><col style="width:30%" /><col style="width:20%" /><col style="width:30%" /></colgroup>
													<tr>
														<td class="alignRight">Introducer's Client ID [if any]:</td>
														<td>
															<dx:ASPxTextBox ID=txtIntroducerClientID runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
														<td class="alignRight">Category of Introducer :</td>
														<td>
															<dx:ASPxComboBox ID=cboCategoryofIntroducer runat="server" Width="100%" 
																CssClass="form-control input-sm" SelectedIndex="-1" Theme=MetropolisBlue>
																<Items>
																	<dx:ListEditItem Selected="true" Text="Individual [01]" Value="01" />
																	<dx:ListEditItem Text="Partnership Firm [02]" Value="02" />
																	<dx:ListEditItem Text="HUF [03]" Value="03" />
																	<dx:ListEditItem Text="Public & Private Companies [04]" Value="04" />
																	<dx:ListEditItem Text="Trust/Society [05]" Value="05" />
																	<dx:ListEditItem Text="Mutual Fund [06]" Value="06" />
																	<dx:ListEditItem Text="Domestic Financial Institution [07]" Value="07" />
																	<dx:ListEditItem Text="Bank [08]" Value="08" />
																	<dx:ListEditItem Text="Insurance [09]" Value="09" />
																	<dx:ListEditItem Text="Statutory Bodies [10]" Value="10" />
																	<dx:ListEditItem Text="NRI [11]" Value="11" />
																	<dx:ListEditItem Text="FII [12]" Value="12" />
																	<dx:ListEditItem Text="OCB [13]" Value="13" />
																	<dx:ListEditItem Text="Foreign Ven Cap Funds/Direct Foreign Inv [14]" Value="14" />
																	<dx:ListEditItem Text="PMS Clients [15]" Value="15" />
																	<dx:ListEditItem Text="New Pension System (NPS) [16]" Value="16" />
																	<dx:ListEditItem Text="Association (QFIG/A) [17]" Value="17" />
																	<dx:ListEditItem Text="(QFI-I) [18]" Value="18" />
																	<dx:ListEditItem Text="Non Govt.Organisation [19]" Value="19" />
																	<dx:ListEditItem Text="Foreign Venture Capital Fund [20]" Value="20" />
																	<dx:ListEditItem Text="Depository Receipts [21]" Value="21" />
																	<dx:ListEditItem Text="LLP" Value="LLP" />
																	<dx:ListEditItem Text="Others [99]" Value="99" />
																	<dx:ListEditItem Text="Unknown" Value="" />
																</Items>
															</dx:ASPxComboBox>
														</td>
													</tr>
													<tr>
														<td class="alignRight">Name of Introducer :</td>
														<td>
															<dx:ASPxTextBox ID=txtIntroducerName runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
														<td class="alignRight">Description of Category :</td>
														<td>
															<dx:ASPxTextBox ID=txtIntroducerCategoryDescription runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
													</tr>
													<tr>
														<td class="alignRight">
															<dx:ASPxLabel ID=ASPxLabel3 runat="server" Text="Address :"></dx:ASPxLabel>
														</td>
														<td colspan="2">
															<dx:ASPxTextBox ID=txtIntroducerAddress1 runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
													</tr>
													<tr>
														<td></td>
														<td colspan="2">
															<dx:ASPxTextBox ID=txtIntroducerAddress2 runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
													</tr>
													<tr>
														<td></td>
														<td colspan="2">
															<dx:ASPxTextBox ID=txtIntroducerAddress3 runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
													</tr>
													<tr>
														<td class="alignRight">Pin Code :</td>
														<td>
															<dx:ASPxTextBox ID=txtIntroducerPinCode runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
														<td class="alignRight">City :</td>
														<td>
															<dx:ASPxTextBox ID=txtIntroducerCity runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
													</tr>
													<tr>
														<td class="alignRight">Phones :</td>
														<td>
															<dx:ASPxTextBox ID=txtIntroducerPhone runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
														<td class="alignRight">Country :</td>
														<td>
															<dx:ASPxComboBox ID=cboIntroducerCountry runat="server" Width="100%" 
																SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxComboBox>
														</td>
													</tr>
													<tr>
														<td class="alignRight">Father / Spouse Name :</td>
														<td>
															<dx:ASPxTextBox ID=txtIntroducerFatherOrSpouseName runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
														<td class="alignRight">Relationship of the TM with Introducer :</td>
														<td>
															<dx:ASPxTextBox ID=txtIntroducerRelationship runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
													</tr>
													<tr>
														<td class="alignRight">Identity Proof :</td>
														<td>
															<dx:ASPxComboBox ID=cboIntroducerIdProof runat="server" Width="100%" 
																SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																<Items>
																	<dx:ListEditItem Selected="True" Text="(None)" Value="" />
																	<dx:ListEditItem Text="PAN Card" Value="PAN" />
																	<dx:ListEditItem Text="Voter ID" Value="Voter ID" />
																	<dx:ListEditItem Text="Passport" Value="Passport" />
																	<dx:ListEditItem Text="Driving License" Value="Driving License" />
																</Items>
															</dx:ASPxComboBox>
														</td>
														<td></td>
														<td></td>
													</tr>
													<tr>
														<td class="alignRight">ID Number :</td>
														<td>
															<dx:ASPxTextBox ID=txtIntroducerIdNumber runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
														<td class="alignRight">Expiry Date :</td>
														<td>
															<dx:ASPxDateEdit ID=dtIdExpiryDate runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue 
																DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
															</dx:ASPxDateEdit>
														</td>
													</tr>
												</table>

												<div class="tab-content">
													<div class="tab-pane active" id="hrInroducer">

														<ul class="nav nav-tabs">
															<li class="active">
																<a href="#ContactPerson" data-toggle="tab" aria-expanded="true">Contact Person</a>
															</li>
														</ul>

														<div class="tab-content padding-10">
															<div class="tab-pane active in" id="ContactPerson">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td class="alignRight">Name :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtCPName runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Father/Spouse Name :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtCPFatherSpouseName runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Designation :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtCPDesignation runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">DIN :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtCPDin runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Address :</td>
																		<td colspan="2">
																			<dx:ASPxTextBox ID=txtCPAddress runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">City :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtCPCity runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">PIN :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtCPPin runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">State :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboCPState runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxComboBox>
																		</td>
																		<td class="alignRight">Country :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboCPCountry runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxComboBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">PAN Number :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtCPPanNumber runat="server" Width="100%" 
																				CssClass="form-control input-sm panno" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Phone :</td>
																		<td>
																			<div class="form-group has-error" style="width: 100%">
																				<div class="input-group">
																					<dx:ASPxTextBox ID=txtCPPhone ClientInstanceName="txtCPPhone" runat="server" Width="100%" 
																						CssClass="form-control input-sm digit" Theme=MetropolisBlue>
																					</dx:ASPxTextBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Email :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtCPEmail runat="server" Width="100%" 
																				CssClass="form-control input-sm email" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td></td>
																		<td></td>
																	</tr>
																</table>
															</div>
														</div>

													</div>
												</div>
											</fieldset>
										</div>

										<div class="step-pane" id="step3">
											<!-- <h3><strong>Step 3 </strong>- Operation</h3> -->
											<br />
											<fieldset>
												<table id="tblInputstep3" class="table table-responsive borderless tblpadding">
													<colgroup>
														<col style="width:25%" /><col style="width:25%" />
														<col style="width:25%" /><col style="width:25%" />
													</colgroup>
													<tr>
														<td class="alignRight">Obligation Limit :</td>
														<td>
															<div class="input-group">
																<span class="input-group-addon"><i class="fa fa-inr" aria-hidden="true"></i></span>
																<dx:ASPxTextBox ID=txtObligationLimit runat="server" Text="0.00" Width="100%" 
																	CssClass="form-control input-sm" Theme=MetropolisBlue>
																</dx:ASPxTextBox>
															</div>
														</td>
														<td class="alignRight">Default CTCL System :</td>
														<td>
															<dx:ASPxComboBox ID=cboCtclSystems runat="server" Width="100%" 
																CssClass="form-control input-sm" SelectedIndex=-1 Theme=MetropolisBlue>
																<Items>
																	<dx:ListEditItem Text="(None)" Value="" />
																	<dx:ListEditItem Text="NEAT" Value="NEAT" />
																	<dx:ListEditItem Text="ODIN" Value="ODIN" />
																	<dx:ListEditItem Text="OMNESYS" Value="OMNESYS" />
																	<dx:ListEditItem Text="NEATPLUS" Value="NEATPLUS" />
																	<dx:ListEditItem Text="ASIANCERC" Value="ASIANCERC" />
																	<dx:ListEditItem Text="NOW" Value="NOW" />
																	<dx:ListEditItem Text="ORION" Value="ORION" />
																</Items>
															</dx:ASPxComboBox>
														</td>
													</tr>
													<tr>
														<td class="alignRight">Gross Exposure Margin % :</td>
														<td>
															<div class="input-group">
																<span class="input-group-addon"><i class="fa fa-inr" aria-hidden="true"></i></span>
																<dx:ASPxTextBox ID=txtGrossExposureMarginPercent runat="server" Width="100%" Text="0.00" 
																	CssClass="form-control input-sm" Theme=MetropolisBlue>
																</dx:ASPxTextBox>
															</div>
														</td>
														<td class="alignRight">Client Operation choice :</td>
														<td>
															<dx:ASPxComboBox ID=cboClientChoice runat="server" Width="100%" 
																CssClass="form-control input-sm" SelectedIndex=-1 Theme=MetropolisBlue>
																<Items>
																	<dx:ListEditItem Text="Offline Client [O]" Value="O" />
																	<dx:ListEditItem Text="Online Client [N]" Value="N" />
																	<dx:ListEditItem Selected="true" Text="Both [B]" Value="B" />
																</Items>
															</dx:ASPxComboBox>
														</td>
													</tr>
													<tr>
														<td class="alignRight">Contract Type :</td>
														<td>
															<dx:ASPxComboBox ID=cboContractType runat="server" Width="100%" 
																SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
															<Items>
																<dx:ListEditItem Selected="true" Text="A" Value="A" />
																<dx:ListEditItem Text="B" Value="B" />
																<dx:ListEditItem Text="Non" Value="" />
															</Items>
															</dx:ASPxComboBox>
														</td>
														<td></td>
														<td>
															<dx:ASPxCheckBox ID=chkClientTakesEConnect runat="server" 
																Text="Client takes e-Connect" Theme=MetropolisBlue>
															</dx:ASPxCheckBox>
														</td>
													</tr>
													<tr>
														<td class="alignRight">Contract Numbering Pattern :</td>
														<td><dx:ASPxComboBox ID=cboContractNumberingPattern runat="server" Width="100%" 
															SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
															<Items>
																<dx:ListEditItem Selected="true" Text="Full" Value="Full" />
																<dx:ListEditItem Text="Sharewise" Value="Sharewise" />
																<dx:ListEditItem Text="Orderwise" Value="Orderwise" />
															</Items>
															</dx:ASPxComboBox>
														</td>
														<td></td>
														<td>
															<dx:ASPxCheckBox ID=chkPrintPhysicalContract runat="server" 
																Text="Do not print physical contract" Theme=MetropolisBlue>
															</dx:ASPxCheckBox>
														</td>
													</tr>
													<tr>
														<td class="alignRight">F&O Daily Exposure Limit :</td>
														<td>
															<div class="input-group">
																<span class="input-group-addon"><i class="fa fa-inr" aria-hidden="true"></i></span>
																<dx:ASPxTextBox ID=txtFNODailyExposureLimit runat="server" Text="0.00" Width="100%" 
																	CssClass="form-control input-sm" Theme=MetropolisBlue>
																</dx:ASPxTextBox>
																<span class="input-group-addon">Lacs</span>
															</div>
														</td>
													</tr>
												</table>
											</fieldset>
										</div>

										<div class="step-pane" id="step4">
											<!-- <h3><strong>Step 4 </strong>- DP A/Cs</h3> -->
											<br />
											<fieldset>
												<table class="table table-condensed table-responsive borderless">
													<tr>
														<td style="text-align: left">
															<button type="button" class="btn btn-primary" onclick="DPAddEdit('Insert','','');">
																<i class="fa fa-plus"></i> ADD
															</button>
														</td>
													</tr>
												</table>
												<dx:ASPxGridView ID="grdDP" ClientInstanceName="grdDP" KeyFieldName="DPCODE" Theme="MetropolisBlue" 
													AutoGenerateColumns="False" Width="100%" runat="server"  OnCustomCallback=grdDP_CustomCallback>
													<Styles>
														<AlternatingRow BackColor="#f0ffff"></AlternatingRow>
													</Styles>
													<Settings GridLines="Horizontal" />
													<Columns>
														<dx:GridViewDataTextColumn Width="22%" Caption="Account" VisibleIndex="0">
															<DataItemTemplate>
																<table class="table-condensed table-responsive borderless">
																	<tr>
																		<td>
																			<dx:ASPxLabel ID=lblAccountTypetxt runat="server" Text="Account Type"></dx:ASPxLabel>
																			:
																			<dx:ASPxLabel ID=lblAccountType runat="server" Text='<%# Eval("type") %>' Font-Size="Small"></dx:ASPxLabel>
																		</td>
																	</tr>
																	<tr>
																		<td>
																			<dx:ASPxLabel ID=lblExchangetxt runat="server" Text="Exchange"></dx:ASPxLabel>
																			:
																			<dx:ASPxLabel ID=lblExchange runat="server" Text='<%# Eval("exchange") %>'></dx:ASPxLabel>
																		</td>
																	</tr>
																</table>
															</DataItemTemplate>
														</dx:GridViewDataTextColumn>
														<dx:GridViewDataTextColumn Width="30%" Caption="DP Details" VisibleIndex="1">
															<DataItemTemplate>
																<table class="table-condensed table-responsive borderless">
																	<tr>
																		<td>
																			<dx:ASPxLabel ID=lblDPCodetxt runat="server" Text="DP Code"></dx:ASPxLabel>
																			:
																			<dx:ASPxLabel ID=lblDPCode runat="server" Text='<%# Eval("dpcode") %>' Font-Size="Small"></dx:ASPxLabel>
																		</td>
																	</tr>
																	<tr>
																		<td>
																			<dx:ASPxLabel ID=lblDPName runat="server" Text='<%# Eval("Dp_Name") %>'></dx:ASPxLabel>
																		</td>
																	</tr>
																	<tr>
																		<td>
																			<dx:ASPxLabel ID=lblDPIDtxt runat="server" Text="DP ID"></dx:ASPxLabel>
																			:
																			<dx:ASPxLabel ID=lblDPID runat="server" Text='<%# Eval("DpId") %>'></dx:ASPxLabel>
																		</td>
																	</tr>
																</table>
															</DataItemTemplate>
														</dx:GridViewDataTextColumn>
														<dx:GridViewDataTextColumn Width="25%" Caption="Client Details" VisibleIndex="2">
															<DataItemTemplate>
																<table class="table-condensed table-responsive borderless">
																	<tr>
																		<td>
																			<dx:ASPxLabel ID=lblClientIDtxt runat="server" Text="Client ID"></dx:ASPxLabel>
																			:
																			<dx:ASPxLabel ID=lblClientID runat="server" Text='<%# Eval("clientid") %>' Font-Size="Small"></dx:ASPxLabel>
																		</td>
																	</tr>
																	<tr>
																		<td>
																			<dx:ASPxLabel ID=lblClientNametxt runat="server" Text="Client Name"></dx:ASPxLabel>
																			:
																			<dx:ASPxLabel ID=lblClientName runat="server" Text='<%# Eval("clientname") %>'></dx:ASPxLabel>
																		</td>
																	</tr>
																</table>
															</DataItemTemplate>
														</dx:GridViewDataTextColumn>
														<dx:GridViewDataTextColumn Caption="POA ? Property" FieldName="POA_RECVD" VisibleIndex="3">
														</dx:GridViewDataTextColumn>
														<dx:GridViewDataTextColumn Width="10%" VisibleIndex="4">
															<DataItemTemplate>
																<table class="table-condensed table-responsive borderless">
																	<tr>
																		<td>
																			<a href="#" class="fa fa-pencil-square fa-2x" title="Update DP !!!" onclick="DPAddEdit('Update','<%# Eval("dpcode") %>','<%# Eval("clientid") %>');" aria-hidden="true"></a>
																		</td>
																		<td>
																			<a href="#" class="fa fa-times fa-2x" onclick="SetEntityToHidden('dpcode=<%# Eval("dpcode") %>&&clientid=<%# Eval("clientid") %>' )" title="Delete this DP!!" data-toggle="modal" data-target="#ModalconfirmDelete" aria-hidden="true"></a>
																		</td>
																	</tr>
																</table>
															</DataItemTemplate>
														</dx:GridViewDataTextColumn>
													</Columns>
													<SettingsPager Mode="EndlessPaging"></SettingsPager>
													<SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
												</dx:ASPxGridView>
											</fieldset>
										</div>

										<div class="step-pane" id="step5">
											<!-- <h3><strong>Step 5 </strong>- Agreement</h3> -->
											<br />
											<fieldset>
												<table id="tblInputstep5" class="table table-responsive borderless tblpadding">
													<colgroup>
														<col style="width:20%" /><col style="width:30%" />
														<col style="width:20%" /><col style="width:30%" />
													</colgroup>
													<tr>
														<td class="alignRight">Client Type :</td>
														<td>
															<dx:ASPxComboBox ID=cboAgreeClientType runat="server" Width="100%" SelectedIndex="-1" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
																<Items>
																	<dx:ListEditItem Selected="true" Text="Individual [01]" Value="01" />
																	<dx:ListEditItem Text="Partnership Firm [02]" Value="02" />
																	<dx:ListEditItem Text="HUF [03]" Value="03" />
																	<dx:ListEditItem Text="Public & Private Companies [04]" Value="04" />
																	<dx:ListEditItem Text="Trust/Society [05]" Value="05" />
																	<dx:ListEditItem Text="Mutual Fund [06]" Value="06" />
																	<dx:ListEditItem Text="Domestic Financial Institution [07]" Value="07" />
																	<dx:ListEditItem Text="Bank [08]" Value="08" />
																	<dx:ListEditItem Text="Insurance [09]" Value="09" />
																	<dx:ListEditItem Text="Statutory Bodies [10]" Value="10" />
																	<dx:ListEditItem Text="NRI [11]" Value="11" />
																	<dx:ListEditItem Text="FII [12]" Value="12" />
																	<dx:ListEditItem Text="OCB [13]" Value="13" />
																	<dx:ListEditItem Text="Foreign Ven Cap Funds/Direct Foreign Inv [14]" Value="14" />
																	<dx:ListEditItem Text="PMS Clients [15]" Value="15" />
																	<dx:ListEditItem Text="New Pension System (NPS) [16]" Value="16" />
																	<dx:ListEditItem Text="Association (QFIG/A) [17]" Value="17" />
																	<dx:ListEditItem Text="(QFI-I) [18]" Value="18" />
																	<dx:ListEditItem Text="Non Govt.Organisation [19]" Value="19" />
																	<dx:ListEditItem Text="Foreign Venture Capital Fund [20]" Value="20" />
																	<dx:ListEditItem Text="Depository Receipts [21]" Value="21" />
																	<dx:ListEditItem Text="LLP" Value="LLP" />
																	<dx:ListEditItem Text="Others [99]" Value="99" />
																	<dx:ListEditItem Text="Unknown" Value="" />
																</Items>
															</dx:ASPxComboBox>
														</td>
														<td class="alignRight">Active Date :</td>
														<td>
															<dx:ASPxDateEdit ID=dtAgreeActiveDate runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue
																DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
															</dx:ASPxDateEdit>
														</td>
													</tr>
													<%--<tr>
														<td class="alignRight"><dx:ASPxLabel ID=ShLabel54 runat="server" Text="Description of Category :"></dx:ASPxLabel></td>
													<td><dx:ASPxTextBox ID=txtAgreementCategoryDescription runat="server" Width="100%" MaxLength="100" Native="true" CssClass="form-control input-sm"></dx:ASPxTextBox></td>
														<td class="alignRight"><dx:ASPxLabel ID=ShLabel53 runat="server" Text="Business Comentcement Date :"></dx:ASPxLabel></td>
														<td><dx:ASPxDateEdit ID=dtAgreementBusinessComentcementDate  ClientInstanceName="dtAgreementBusinessComentcementDate " runat="server" Width="100%" CssClass="form-control input-sm" ></dx:ASPxDateEdit></td>
													</tr>--%>
													<tr>
														<td class="alignRight">Mapin ID :</td>
														<td>
															<dx:ASPxTextBox ID=txtAgreeMapinID runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
														<td class="alignRight">Business Commencement Date :</td>
														<td>
															<dx:ASPxDateEdit ID=dtAgreeBusinessComentcementDate runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue
																DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
															</dx:ASPxDateEdit>
														</td>
													</tr>
													<%--<tr>
														<td class="alignRight"><dx:ASPxLabel ID=ShLabel64 runat="server" Text="Mapin ID :"></dx:ASPxLabel></td>
														<td><dx:ASPxTextBox ID=txtAgreementMapinID runat="server" Width="100%" MaxLength="100" Native="true" CssClass="form-control input-sm"></dx:ASPxTextBox></td>
														<td class="alignRight"><dx:ASPxLabel ID=ShLabel63 runat="server" Text="Closure Date :"></dx:ASPxLabel></td>
														<td><dx:ASPxDateEdit ID=dtAgreementClosureDate  ClientInstanceName="dtAgreementClosureDate" runat="server" Width="100%" CssClass="form-control input-sm" ></dx:ASPxDateEdit></td>
													</tr>--%>
													<tr>
														<td class="alignRight">UID ADHAR :</td>
														<td>
															<dx:ASPxTextBox ID=txtAgreeUidadhar runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
														<td></td>
														<td></td>
														<%--<td class="alignRight"><dx:ASPxLabel ID=ShLabel55 runat="server" Text="Suspension Date :"></dx:ASPxLabel></td>
																	<td><dx:ASPxDateEdit ID=dtAgreementSuspensionDate  runat="server" Width="100%" CssClass="form-control input-sm" ></dx:ASPxDateEdit></td>--%>
													</tr>
													<tr>
														<td class="alignRight">Register For :</td>
														<td colspan="3">
															<dx:ASPxCheckBoxList ID="chbListAgreeSegments" ValueField="co" 
																TextField="system" runat="server" RepeatColumns="9" Theme=MetropolisBlue>
															</dx:ASPxCheckBoxList>
														</td>
													</tr>
												</table>

												<div class="tab-content">
													<div class="tab-pane active" id="tab-paneAgreement">

														<ul class="nav nav-tabs">
															<li class="active">
																<a href="#GeneralOptions" data-toggle="tab" aria-expanded="true">General</a>
															</li>
															<li class="">
																<a href="#Registration" data-toggle="tab" aria-expanded="true">Registration Details</a>
															</li>
															<li class="">
																<a href="#Passport" data-toggle="tab" aria-expanded="false">Passport</a>
															</li>
															<li class="">
																<a href="#ITFile" data-toggle="tab" aria-expanded="false">IT File</a>
															</li>
															<li class="">
																<a href="#DrivingLicence" data-toggle="tab" aria-expanded="false">Driving Licence</a>
															</li>
															<li class="">
																<a href="#VoterID" data-toggle="tab" aria-expanded="false">Voter ID</a>
															</li>
															<li class="">
																<a href="#RationCard" data-toggle="tab" aria-expanded="false">Ration Card</a>
															</li>
														</ul>

														<div class="tab-content padding-10">
											
															<div class="tab-pane active in" id="GeneralOptions">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td></td>
																		<td class="alignRight" colspan="3">
																			<dx:ASPxCheckBox ID=chkRegFormRecived runat="server" 
																				Text="Registration form Received ?" Theme=MetropolisBlue>
																			</dx:ASPxCheckBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Order Less Than 1 Lakhs :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboOrderLessThan1Laks runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																				<Items>
																					<dx:ListEditItem Text="No" Value="N" />
																					<dx:ListEditItem Selected="true" Text="Yes" Value="Y" />
																				</Items>
																			</dx:ASPxComboBox>
																		</td>
																		<td class="alignRight">Client Setting Through :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboClientSettingThrough runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																				<Items>
																					<dx:ListEditItem Selected="true" Text="Custodian [N]" Value="N" />
																					<dx:ListEditItem Text="Trading Member [T]" Value="T" />
																					<dx:ListEditItem Text="Both [B]" Value="B" />
																				</Items>
																			</dx:ASPxComboBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Client Photo ID Proof :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboClientPhotoIDProof runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																				<Items>
																					<dx:ListEditItem Selected="true" Text="PAN Card" Value="PAN Card" />
																					<dx:ListEditItem Text="Voter ID" Value="Voter ID" />
																					<dx:ListEditItem Text="Adhar Card" Value="Adhar Card" />
																				</Items>
																			</dx:ASPxComboBox>
																		</td>
																		<td class="alignRight">Client Address Proof :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboClientAddressProof runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																				<Items>
																					<dx:ListEditItem Selected="true" Text="Voter ID" Value="Voter ID" />
																					<dx:ListEditItem Text="Passport" Value="Passport" />
																					<dx:ListEditItem Text="Adhar Card" Value="Adhar Card" />
																					<dx:ListEditItem Text="Driving Licence" Value="Driving Licence" />
																				</Items>
																			</dx:ASPxComboBox>
																		</td>
																	</tr>
																</table>
															</div>

															<div class="tab-pane in" id="Registration">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td class="alignRight">Regn. # :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtRegin runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Place :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtPlace runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Registration Authority :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtRegAuthority runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Date Registration :</td>
																		<td>
																			<dx:ASPxDateEdit ID=dtRegDate runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue
																				DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																			</dx:ASPxDateEdit>
																		</td>
																	</tr>
																</table>
															</div>

															<div class="tab-pane in" id="Passport">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td class="alignRight">Number :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtRegPassportNumber runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Place :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtRegPlace runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Date From :</td>
																		<td>
																			<dx:ASPxDateEdit ID=dtRegDateFrom runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue
																				DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																			</dx:ASPxDateEdit>
																		</td>
																		<td class="alignRight">Date To :</td>
																		<td>
																			<dx:ASPxDateEdit ID=dtRegDateTo runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue
																				DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																			</dx:ASPxDateEdit>
																		</td>
																	</tr>
																</table>
															</div>

															<div class="tab-pane in" id="ITFile">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td class="alignRight">PAN Number :</td>
																		<td>
																			<div class="form-group has-error" style="width: 100%">
																				<div class="input-group">
																					<dx:ASPxTextBox ID=txtRegPanNumber ClientInstanceName="txtRegPanNumber" 
																						runat="server" Width="100%" CssClass="form-control input-sm panno" Theme=MetropolisBlue>
																					</dx:ASPxTextBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">GR Number :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtRegGrNumber runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Word / Circle / Special Range Number :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtRegRangeNumber runat="server" Width="100%"
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																</table>
															</div>

															<div class="tab-pane in" id="DrivingLicence">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td class="alignRight">Number :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtRegLicenceNo runat="server" Width="100%"  
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Place :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtRegLicencePlace runat="server" Width="100%"  
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Date From :</td>
																		<td>
																			<dx:ASPxDateEdit ID=dtRegLicenceDateFrom runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue
																				DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																			</dx:ASPxDateEdit>
																		</td>
																		<td class="alignRight">Date To :</td>
																		<td>
																			<dx:ASPxDateEdit ID=dtRegLicenceDateTo runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue
																				DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																			</dx:ASPxDateEdit>
																		</td>
																	</tr>
																</table>
															</div>

															<div class="tab-pane in" id="VoterID">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td class="alignRight">Number :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtRegVoterIDNo runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Place :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtRegVoterIDPlace runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Date :</td>
																		<td>
																			<dx:ASPxDateEdit ID=dtRegVoterIDDate runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue
																				DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																			</dx:ASPxDateEdit>
																		</td>
																	</tr>
																</table>
															</div>

															<div class="tab-pane in" id="RationCard">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td class="alignRight">Number :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtRegRationCardNo runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Place :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtRegRationCardPlace runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Date :</td>
																		<td>
																			<dx:ASPxDateEdit ID=dtRegRationCardDate runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue
																				DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																			</dx:ASPxDateEdit>
																		</td>
																	</tr>
																</table>
															</div>

														</div>
													</div>
												</div>
											</fieldset>
										</div>

										<div class="step-pane" id="step6">
											<!--  <h3><strong>Step 6 </strong>- Bank A/Cs</h3> -->
											<br />
											<fieldset>
												<table class="table table-condensed table-responsive borderless">
													<tr>
														<td style="text-align: left">
															<button type="button" class="btn btn-primary" onclick="BankAddEdit('Insert','','');">
																<i class="fa fa-plus"></i> ADD BANK
															</button>
														</td>
													</tr>
												</table>
												<dx:ASPxGridView ID="grdBankAccount" ClientInstanceName="grdBankAccount" KeyFieldName="bankcd" 
													Theme="MetropolisBlue" AutoGenerateColumns="False" Width="100%" runat="server" OnCustomCallback=grdBankAccount_CustomCallback>
													<Settings GridLines="Horizontal" />
													<Columns>
														<dx:GridViewDataTextColumn Width="13%" Caption="Account Type" FieldName="type" VisibleIndex="0" />
														<dx:GridViewDataTextColumn Width="22%" Caption="Bank Details" VisibleIndex="1">
															<DataItemTemplate>
																<table class="table-condensed table-responsive borderless">
																				<tr>
																					<td>
																						<dx:ASPxLabel ID=ShLabel77 runat="server" Text="Bank Code"></dx:ASPxLabel>
																						:
																						<dx:ASPxLabel ID=ShLabel106 runat="server" Text='<%# Eval("bankcd") %>'></dx:ASPxLabel>
																					</td>
																				</tr>
																				<tr>
																					<td>
																						<dx:ASPxLabel ID=ShLabel108 runat="server" Text='<%# Eval("descr") %>'></dx:ASPxLabel>
																					</td>
																				</tr>
																				<tr>
																					<td>
																						<dx:ASPxLabel ID=lblrtgstxt runat="server" Text="RTGS / IFSC Code"></dx:ASPxLabel>
																						:
																						<dx:ASPxLabel ID=lblrtgs runat="server" Text='<%# Eval("rtgs") %>' Font-Size="Small"></dx:ASPxLabel>
																					</td>
																				</tr>
																				<tr>
																					<td>
																						<dx:ASPxLabel ID=lblMICRNOtxt runat="server" Text="MICR NO"></dx:ASPxLabel>
																						:
																						<dx:ASPxLabel ID=lblMICRNO runat="server" Text='<%# Eval("micrno") %>'></dx:ASPxLabel>
																					</td>
																				</tr>
																			</table>
															</DataItemTemplate>
														</dx:GridViewDataTextColumn>
														<dx:GridViewDataTextColumn Width="22%" Caption="Bank Account" VisibleIndex="2">
															<DataItemTemplate>
																<table class="table-condensed table-responsive borderless">
																				<tr>
																					<td>
																						<dx:ASPxLabel ID=ShLabel28 runat="server" Text="A/c No."></dx:ASPxLabel>
																						:
																						<dx:ASPxLabel ID=ShLabel43 runat="server" Text='<%# Eval("acno") %>'></dx:ASPxLabel>
																					</td>
																				</tr>
																				<tr>
																					<td>
																						<dx:ASPxLabel ID=ShLabel109 runat="server" Text="A/c. Type"></dx:ASPxLabel>
																						:
																						<dx:ASPxLabel ID=ShLabel110 runat="server" Text='<%# Eval("actype") %>'></dx:ASPxLabel>
																					</td>
																				</tr>
																			</table>
															</DataItemTemplate>
														</dx:GridViewDataTextColumn>
														<dx:GridViewDataTextColumn Width="22%" Caption="Client Details" VisibleIndex="3">
															<DataItemTemplate>
																<table class="table-condensed table-responsive borderless">
																				<tr>
																					<td>
																						<dx:ASPxLabel ID=ShLabel77 runat="server" Text="Ben. Code"></dx:ASPxLabel>
																						:
																						<dx:ASPxLabel ID=ShLabel106 runat="server" Text='<%# Eval("BankClCd") %>'></dx:ASPxLabel>
																					</td>
																				</tr>
																				<tr>
																					<td>
																						<dx:ASPxLabel ID=ShLabel107 runat="server" Text="A/c Name"></dx:ASPxLabel>
																						:
																						<dx:ASPxLabel ID=ShLabel108 runat="server" Text='<%# Eval("ClientName") %>'></dx:ASPxLabel>
																					</td>
																				</tr>
																			</table>
															</DataItemTemplate>
														</dx:GridViewDataTextColumn>
														<dx:GridViewDataTextColumn Caption="POA ?" FieldName="poa_recvd" VisibleIndex="4" />
														<dx:GridViewDataTextColumn Caption="SI ?" FieldName="nri_si" VisibleIndex="5" />
														<dx:GridViewDataTextColumn Width="10%" VisibleIndex="6">
															<DataItemTemplate>
																<table class="table-condensed table-responsive borderless">
																				<tr>
																					<td>
																						<a href="#" class="fa fa-pencil-square fa-2x" title="Update Bank Account !!!" onclick="BankAddEdit('Update','<%# Eval("bankcd") %>','<%# Eval("acno") %>');"></a>
																					</td>
																					<td>
																						<a href="#" class="fa fa-times fa-2x" title="Delete this Bank Account!!" onclick="SetEntityToHidden('bankcd=<%# Eval("bankcd") %>&&acno=<%# Eval("acno") %>' )" data-toggle="modal" data-target="#ModalconfirmDelete" aria-hidden="true"></a>
																					</td>
																				</tr>
																			</table>
															</DataItemTemplate>
														</dx:GridViewDataTextColumn>
													</Columns>
													<SettingsPager Mode="EndlessPaging"></SettingsPager>
													<SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
												</dx:ASPxGridView>
											</fieldset>
										</div>

										<div class="step-pane" id="step7">
											<!-- <h3><strong>Step 7 </strong>- Personal</h3> -->
											<br />
											<fieldset>
												<div class="tab-content">
													<div class="tab-pane active" id="tab-pane-gen">

														<ul class="nav nav-tabs">
															<li class="active">
																<a href="#Details" data-toggle="tab" aria-expanded="false">Details</a>
															</li>
															<li>
																<a href="#KRA" data-toggle="tab" aria-expanded="true">KRA Details</a>
															</li>
														</ul>

														<div class="tab-content padding-10">

															<div class="tab-pane active in" id="Details">
																<h4>Personal Details :</h4>
																<table id="tblInputstep7" class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td class="alignRight">Date Of Birth / Incorp. :</td>
																		<td>
																			<div class="form-group has-error" style="width: 100%">
																				<div class="input-group">
																					<dx:ASPxDateEdit ID=dtDOBOrIncorp ClientInstanceName=dtDOBOrIncorp runat="server" 
																						Width="100%" CssClass="form-control input-sm" Theme=MetropolisBlue
																						DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																					</dx:ASPxDateEdit>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">Marriage Anniversary :</td>
																		<td>
																			<dx:ASPxDateEdit ID=dtMarriageAniversary runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue
																				DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																			</dx:ASPxDateEdit>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Gender :</td>
																		<td>
																			<div class="form-group has-error" style="width: 100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboGender ClientInstanceName=cboGender runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																						<Items>
																							<dx:ListEditItem Selected="true" Text="Male" Value="M" />
																							<dx:ListEditItem Text="Female" Value="F" />
																							<dx:ListEditItem Text="Transgender" Value="N" />
																						</Items>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">Preferred Language :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboLanguage runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxComboBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Other Occasion :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtOtherOccasions runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Occasion Type :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtOtherOccasionsType runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Occasion Date :</td>
																		<td>
																			<dx:ASPxDateEdit ID=dtOccasion runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue
																				DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																			</dx:ASPxDateEdit>
																		</td>
																		<td class="alignRight">Annual Income :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboPerAnnualIncome runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																				<Items>
																					<dx:ListEditItem Selected="true" Text="Below Rs. 100000" Value="Below Rs. 100000" />
																					<dx:ListEditItem Text="Rs. 100000 - 500000" Value="Rs. 100000 - 500000" />
																					<dx:ListEditItem Text="Rs. 500000 - 1000000" Value="Rs. 500000 - 1000000" />
																					<dx:ListEditItem Text="Rs. 1000000 - 2500000" Value="Rs. 1000000 - 2500000" />
																					<dx:ListEditItem Text="Above Rs. 2500000" Value="Above Rs. 2500000" />
																				</Items>
																			</dx:ASPxComboBox>
																		</td>
																	</tr>
																</table>
																<table class="table table-responsive borderless tblpadding">
																	<tr>
																		<td><h4>PMLA Information : Gross Annual Income</h4></td>
																		<td class=alignRight>
																			<button onclick="AddAnnualIncome(); return false;" class="btn btn-primary">
																				<i class="fa fa-plus"></i> Add
																			</button>
																		</td>
																	</tr>
																</table>
																<dx:ASPxGridView ID=grdAnnualIncome ClientInstanceName=grdAnnualIncome runat="server" 
																	Theme="MetropolisBlue" AutoGenerateColumns="False" Width="100%" OnCustomCallback=grdAnnualIncome_CustomCallback>
																	<Styles>
																		<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
																	</Styles>
																	<Columns>
																		<dx:GridViewDataColumn FieldName="SubCd" Visible=false VisibleIndex=0 />
																		<dx:GridViewDataColumn Caption="Financial Year" FieldName=Acc_Descr VisibleIndex=1 />
																		<dx:GridViewDataColumn Caption="Annual Income" FieldName=AnnIncome VisibleIndex=2 />
																		<dx:GridViewDataColumn Caption="Net Worth" FieldName=NetWorth VisibleIndex=3 HeaderStyle-HorizontalAlign=Right />
																		<dx:GridViewDataTextColumn Caption="Net Worth Dt." FieldName=NetWorthDt VisibleIndex=4 ReadOnly=true
																			HeaderStyle-HorizontalAlign=Center CellStyle-HorizontalAlign=Center PropertiesTextEdit-DisplayFormatString="dd/MM/yyyy hh:mm:ss tt" />
																		<dx:GridViewDataColumn Caption="Completed" FieldName=Completed VisibleIndex=5 HeaderStyle-HorizontalAlign=Center />
																		<dx:GridViewDataHyperLinkColumn Caption="Action" VisibleIndex="6" CellStyle-Cursor="pointer" HeaderStyle-Cursor="default">
																			<DataItemTemplate>
																				<a onclick="UpdateAnnualIncome('<%# Eval("SubCd") %>', '<%# Eval("Acc_Descr") %>');">Edit</a>
																			</DataItemTemplate>
																		</dx:GridViewDataHyperLinkColumn>
																		<dx:GridViewDataHyperLinkColumn Caption="Action" VisibleIndex="7" CellStyle-Cursor="pointer" HeaderStyle-Cursor="default">
																			<DataItemTemplate>
																				<a onclick="DeleteAnnualIncome('<%# Eval("SubCd") %>', '<%# Eval("Acc_Descr") %>');">Delete</a>
																			</DataItemTemplate>
																		</dx:GridViewDataHyperLinkColumn>
																	</Columns>
																</dx:ASPxGridView>
																<table class="table table-responsive borderless tblpadding">
																	<colgroup><col style="width:20%" /><col style="width:30%" /><col style="width:20%" /><col style="width:30%" /></colgroup>
																	<tr style="border-top:1px solid lightgray">
																		<td colspan=3></td>
																		<td>
																			<dx:ASPxCheckBox ID=chkSpecialCategory ClientInstanceName=chkSpecialCategory 
																				runat="server" Text="Special Category" Theme=MetropolisBlue>
																				<ClientSideEvents CheckedChanged="function(s, e) { chkSpecialCategory_CheckedChanged(); }" />
																			</dx:ASPxCheckBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Risk Profile :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboRiskProfile runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																				<Items>
																					<dx:ListEditItem Selected="true" Text="Low Risk" Value="Low Risk" />
																					<dx:ListEditItem Text="Medium Risk" Value="Medium Risk" />
																					<dx:ListEditItem Text="High Risk" Value="High Risk" />
																				</Items>
																			</dx:ASPxComboBox>
																		</td>
																		<td class="alignRight">CSC Detail :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboCscDetails ClientInstanceName=cboCscDetails runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																				<Items>
																					<dx:ListEditItem Selected="true" Text="(None)" Value="" />
																					<dx:ListEditItem Text="NRI" Value="NRI" />
																					<dx:ListEditItem Text="High Net-Worth" Value="High Net-Worth" />
																					<dx:ListEditItem Text="Trust" Value="Trust" />
																					<dx:ListEditItem Text="Charities" Value="Charities" />
																					<dx:ListEditItem Text="NGOs" Value="NGOs" />
																					<dx:ListEditItem Text="Org. Receiving Donation" Value="Org. Receiving Donation" />
																					<dx:ListEditItem Text="Close Family Shareholding" Value="Close Family Shareholding" />
																					<dx:ListEditItem Text="Beneficial Ownership" Value="Beneficial Ownership" />
																					<dx:ListEditItem Text="PEP" Value="PEP" />
																					<dx:ListEditItem Text="Foreign Exchange Offering Co." Value="Foreign Exchange Offering Co." />
																					<dx:ListEditItem Text="High Risk Countries Client" Value="High Risk Countries Client" />
																					<dx:ListEditItem Text="Non Face to Face Client" Value="Non Face to Face Client" />
																					<dx:ListEditItem Text="Dubious Reputed Client" Value="Dubious Reputed Client" />
																					<dx:ListEditItem Text="Minor" Value="Minor" />
																					<dx:ListEditItem Text="House Wife" Value="House Wife" />
																					<dx:ListEditItem Text="Senior Citizen" Value="Senior Citizen" />
																				</Items>
																			</dx:ASPxComboBox>
																		</td>
																	</tr>
																</table>
															</div>

															<div class="tab-pane" id="KRA">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td class="alignRight">Application Date :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxDateEdit ID=dtAppDate ClientInstanceName=dtAppDate runat="server" 
																						Width="100%" CssClass="form-control input-sm" Theme=MetropolisBlue
																						DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																					</dx:ASPxDateEdit>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">Application No. :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtAppNo runat="server" Width="100%"	
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Applicant Status :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboAppStatus ClientInstanceName=cboAppStatus runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">Marital Status :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboMaritalStatus ClientInstanceName=cboMaritalStatus runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Company Status :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboCompanyStatus runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxComboBox>
																		</td>
																		<td class="alignRight">Company Status (Other) :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtCompanyStatusOther runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>																		
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Annual Income :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboAnnualIncome ClientInstanceName=cboAnnualIncome runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">Income Date :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxDateEdit ID=dtIncomeDate ClientInstanceName=dtIncomeDate runat="server" Width="100%" 
																						CssClass="form-control input-sm" Theme=MetropolisBlue
																						DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																					</dx:ASPxDateEdit>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">PAN Proof Attached :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboPanProofAttached ClientInstanceName=cboPanProofAttached runat="server" Width="100%" 
																						SelectedIndex="1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																						<Items>
																							<dx:ListEditItem Text=No Value=N />
																							<dx:ListEditItem Text=Yes Value=Y />
																						</Items>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">PAN Exempted :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboPanEmempted ClientInstanceName=cboPanEmempted runat="server" Width="100%" 
																						SelectedIndex="0" CssClass="form-control input-sm" Theme=MetropolisBlue>
																						<Items>
																							<dx:ListEditItem Text=No Value=N />
																							<dx:ListEditItem Text=Yes Value=Y />
																						</Items>
																						<ClientSideEvents SelectedIndexChanged="function(s, e) { cboPanEmempted_SelectedIndexChanged(); }" />
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">PAN Exempt Category :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboPanExemptCat ClientInstanceName=cboPanExemptCat runat="server" 
																				Width="100%" SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxComboBox>
																		</td>
																		<td class="alignRight">PAN Exempt Proof :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboPanEmemptProof ClientInstanceName=cboPanEmemptProof runat="server" 
																				Width="100%" SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxComboBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Document Verification :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboDocVeri ClientInstanceName=cboDocVeri runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">Doc. for Correspondence Add. :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboCorresDoc ClientInstanceName=cboCorresDoc runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Doc. for Permanent Add. :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboPermDoc ClientInstanceName=cboPermDoc runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">Permanent Add. same as Corr. Add. :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboSameAsCorres ClientInstanceName=cboSameAsCorres runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																						<Items>
																							<dx:ListEditItem Text=No Value=N />
																							<dx:ListEditItem Text=Yes Value=Y />
																						</Items>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">State of Correspondence Add. :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboCorresState ClientInstanceName=cboCorresState runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">State of Permanent Add. :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboPermState ClientInstanceName=cboPermState runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">
																			<dx:ASPxLabel ID=ASPxLabel46 runat="server" Text="Country of Correspondence Add. :"></dx:ASPxLabel>
																		</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboCorresCountry ClientInstanceName=cboCorresCountry runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">Country of Permanent Add. :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboPermCountry ClientInstanceName=cboPermCountry runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Proof of Identity Submitted :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboIdentityProof runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxComboBox>
																		</td>
																		<td class="alignRight">Proof of Identity Submitted (Others) :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtIdentityProofOther runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Correspondence Add. Reference Id :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxTextBox ID=txtCorresRefId ClientInstanceName=txtCorresRefId runat="server" Width="100%" 
																						CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxTextBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">Date :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxDateEdit ID=dtCorresRefIdDate ClientInstanceName=dtCorresRefIdDate runat="server" Width="100%" 
																						CssClass="form-control input-sm" Theme=MetropolisBlue
																						DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																					</dx:ASPxDateEdit>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Permanent Add. Reference Id :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxTextBox ID=txtPermRefId ClientInstanceName=txtPermRefId runat="server" Width="100%" 
																						CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxTextBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">Date :</td>
																		<td>
																			<dx:ASPxDateEdit ID=dtPermRefIdDate runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue
																				DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																			</dx:ASPxDateEdit>
																		</td>
																	</tr>
																
																	<tr>
																		<td colspan=4>
																			<hr style="border:1px solid lightgray" />
																		</td>
																	</tr>

																	<tr>
																		<td class="alignRight">IPV Date :</td>
																		<td>
																			<dx:ASPxDateEdit ID=dtIpvDate runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue
																				DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																			</dx:ASPxDateEdit>
																		</td>
																		<td class="alignRight">IPV Name :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtIpvName runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">IPV Designation :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtIpvDesignation runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">IPV Organisation :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtIpvOrganisation runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Nationality :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboNationality runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxComboBox>
																		</td>
																		<td class="alignRight">Nationality (Others) :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboNationalityOthers ClientInstanceName=cboNationalityOthers runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Net-Worth :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtNetWorth runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Net-Worth Date :</td>
																		<td>
																			<dx:ASPxDateEdit ID=dtNetWorthDate runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue
																				DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy">
																			</dx:ASPxDateEdit>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Occupation for All :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtOccupationAll runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Place of Incorporation :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtIncorporation runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Any Other Information :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtOtherInfo runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">State - City :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboStateCity runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxComboBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Relationship :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboRelations runat="server" Width="100%" 
																				SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxComboBox>
																		</td>
																		<td class="alignRight">Any Other Info. / Internal Ref. No. :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtInternalRefNo runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																	<tr>
																		<td class="alignRight">Politically Exposed Person (PEP) :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboPep ClientInstanceName=cboPep runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																		<td class="alignRight">Occupation Details :</td>
																		<td>
																			<div class="form-group has-error" style="width:100%">
																				<div class="input-group">
																					<dx:ASPxComboBox ID=cboOccupations ClientInstanceName=cboOccupations runat="server" Width="100%" 
																						SelectedIndex="-1" CssClass="form-control input-sm" Theme=MetropolisBlue>
																					</dx:ASPxComboBox>
																					<span class="input-group-addon"><i class="glyphicon glyphicon-remove-circle"></i></span>
																				</div>
																			</div>
																		</td>
																	</tr>
																</table>
															</div>

														</div>
													</div>
												</div>
											</fieldset>
										</div>

										<div class="step-pane" id="step8">
											<!-- <h3><strong>Step 8 </strong>- Others</h3> -->
											<br />
											<fieldset>
												<table id="tblInputstep8" class="table table-responsive borderless tblpadding">
													<colgroup>
														<col style="width:20%" /><col style="width:30%" />
														<col style="width:20%" /><col style="width:30%" />
													</colgroup>
													<tr>
														<td class="alignRight">Father / Spouse Name :</td>
														<td>
															<dx:ASPxTextBox ID=txtOthersFatherSpouseName runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
														<td class="alignRight">Employer Name :</td>
														<td>
															<dx:ASPxTextBox ID=txtOthersEmployerName runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
													</tr>
													<tr>
														<td class="alignRight">Full Name of Guardian :</td>
														<td>
															<dx:ASPxTextBox ID=txtGuardianName runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
															</dx:ASPxTextBox>
														</td>
														<td class="alignRight">Whether a Direct Client of TM ?</td>
														<td>
															<dx:ASPxComboBox ID=cboClientOfTM runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
																<Items>
																	<dx:ListEditItem Text="No" Value="N" />
																	<dx:ListEditItem Selected="true" Text="Yes" Value="Y" />
																</Items>
															</dx:ASPxComboBox>
														</td>
													</tr>
													<tr>
														<td class="alignRight">Does the client have an Account with another TM :</td>
														<td>
															<dx:ASPxComboBox ID=cboClientHaveAccount runat="server" Width="100%" 
																CssClass="form-control input-sm" Theme=MetropolisBlue>
																<Items>
																	<dx:ListEditItem Text="No" Value="N" />
																	<dx:ListEditItem Selected="true" Text="Yes" Value="Y" />
																</Items>
															</dx:ASPxComboBox>
														</td>
													</tr>
												</table>
												<div class="tab-content">
													<div class="tab-pane active" id="tab-paneOthers">
													
														<ul class="nav nav-tabs">
															<li class="active">
																<a href="#relationship" data-toggle="tab" aria-expanded="true">Relationship</a>
															</li>
															<li class="">
																<a href="#OtherDetails" data-toggle="tab" aria-expanded="true">Other Details</a>
															</li>
														
														</ul>

														<div class="tab-content padding-10">
														
															<div class="tab-pane active in" id="relationship">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td colspan=2 class="alignRight">Relationship of the Client with TM / Director(s) of the TM :</td>
																		<td>
																			<dx:ASPxComboBox ID=cboRelationWith runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																				<Items>
																					<dx:ListEditItem Text="No" Value="N" />
																					<dx:ListEditItem Selected="true" Text="Yes" Value="Y" />
																				</Items>
																			</dx:ASPxComboBox>
																		</td>
																	</tr>
																	<tr>
																		<td colspan=4><br /></td>
																	</tr>
																	<tr>
																		<td class="alignRight">TM / Director(s) Name :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtTmDirectorName runat="server" Width="100%"
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">Relationship of the TM with the Director :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtTmDirectorRelation runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																	</tr>
																</table>
															</div>
														
															<div class="tab-pane in" id="OtherDetails">
																<table class="table table-responsive borderless tblpadding">
																	<colgroup>
																		<col style="width:20%" /><col style="width:30%" />
																		<col style="width:20%" /><col style="width:30%" />
																	</colgroup>
																	<tr>
																		<td colspan=2 class="alignRight">
																			Does the client have any other A/c with the same TM for any of the family members / associates ?
																		</td>
																		<td>
																			<dx:ASPxComboBox ID=cboHaveOtherAcount runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																				<Items>
																					<dx:ListEditItem Text="No" Value="N" />
																					<dx:ListEditItem Selected="true" Text="Yes" Value="Y" />
																				</Items>
																			</dx:ASPxComboBox>
																		</td>
																	</tr>
																	<tr>
																		<td colspan=4><br /></td>
																	</tr>
																	<tr>
																		<td class="alignRight">Family Group Code :</td>
																		<td>
																			<dx:ASPxTextBox ID=txtFamilyGroupCode runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																			</dx:ASPxTextBox>
																		</td>
																		<td class="alignRight">What their Settlement Mode ?</td>
																		<td>
																			<dx:ASPxComboBox ID=cboSettlementMode runat="server" Width="100%" 
																				CssClass="form-control input-sm" Theme=MetropolisBlue>
																				<Items>
																					<dx:ListEditItem Selected="true" Text="Independent" Value="I" />
																					<dx:ListEditItem Text="Joint" Value="J" />
																				</Items>
																			</dx:ASPxComboBox>
																		</td>
																	</tr>
																</table>
															</div>
														
															<%-- <div class="tab-pane in" id="TradingMembers">
																		<table class="table table-condensed table-responsive">
																			<tr>
																			<td style="text-align:left">
																				<button type="button" class="btn btn-primary" onclick="OtherTradingMemberAddEdit('Insert','');"><i class="fa fa-plus"></i> ADD</button>
																			</td>
																			<td style="text-align:center">
						
																			</td>
																			<td style="text-align:right">
						                    
																			</td>
																			<td style="text-align:left">
						                    
																			</td>
																			</tr>
																			<tr>
																			<td colspan="4">
																				<dx:ASPxGridView ID="grdTradingMember" ClientInstanceName="grdTradingMember" KeyFieldName="TMSEBINO" Theme="Office2010Silver" AutoGenerateColumns="False" Width="100%" runat="server">
																					<Settings  GridLines="Horizontal" />
																					<Columns>
																						<dx:GridViewDataTextColumn Caption="Other Sebi Reg# No." FieldName="TMSEBINO" VisibleIndex="0">
																						</dx:GridViewDataTextColumn>
																						<dx:GridViewDataTextColumn Caption="Name of The Other Trading Member" FieldName="TMNAME" VisibleIndex="1">
																						</dx:GridViewDataTextColumn>
																						<dx:GridViewDataTextColumn Caption="Client Alias" FieldName="CLTMALIAS" VisibleIndex="2">
																						</dx:GridViewDataTextColumn>
																						<dx:GridViewDataTextColumn Width="10%" Caption="#" VisibleIndex="10">
																							<DataItemTemplate>
																								<table class="table-condensed table-responsive borderless">
																									<tr>
																										<td>
																											<a href="#" class="fa fa-pencil-square fa-2x"  title="Update Trading Member !!!" onclick="OtherTradingMemberAddEdit('Update','<%# Eval("TMSEBINO") %>')" ></a>
																										</td>
																										<td>
																											<a href="#" class="fa fa-times fa-2x" title="Delete this Trading Member !!" onclick="SetEntityToHidden('TMSEBINO=<%# Eval("TMSEBINO") %>' )" data-toggle="modal" data-target="#ModalconfirmDelete" aria-hidden="true"></a>
																										</td>
																									</tr>
																								</table>
																							</DataItemTemplate>
																						</dx:GridViewDataTextColumn>
																					</Columns>
																					<SettingsPager Mode="EndlessPaging"></SettingsPager>
																					<SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
																				</dx:ASPxGridView>
																				</td>
																			</tr>
																	</table>
																	</div>--%>

														</div>

													</div>
												</div>
											</fieldset>
										</div>

										<div class="step-pane" id="step9">
											<!-- <h3><strong>Step 9 </strong>- Inmages [Finish]</h3> -->
											<br />
											<fieldset>
												<button onclick="AddImage(); return false;" class="btn btn-primary">
													<i class="fa fa-upload"></i> Upload Image / File
												</button>
												<br /><br />
												<dx:ASPxGridView ID=grdScanImage ClientInstanceName=grdScanImage runat="server" 
													Theme="MetropolisBlue" AutoGenerateColumns="False" Width="100%" OnCustomCallback=grdScanImage_CustomCallback>
													<Styles>
														<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
													</Styles>
													<Columns>
														<dx:GridViewDataColumn FieldName="SrlNo" Visible=false VisibleIndex=0 />
														<%--<dx:GridViewDataColumn VisibleIndex=1>
															<DataItemTemplate>
																<img style="height:50px;width:50px"
																	scr="data:image/jpg;base64,<%# Eval("BinImg") %>" />
															</DataItemTemplate>
														</dx:GridViewDataColumn>--%>
														<dx:GridViewDataColumn Caption="Category" FieldName=Category VisibleIndex=2 />
														<dx:GridViewDataColumn Caption="Image Type" FieldName=ImageType VisibleIndex=3 />
														<dx:GridViewDataColumn Caption="File Type" FieldName=FileType VisibleIndex=4 />
														<dx:GridViewDataColumn Caption="File Name" FieldName=FileName VisibleIndex=5 />
														<dx:GridViewDataTextColumn Caption="Date" FieldName=Date VisibleIndex=6 ReadOnly=true
															HeaderStyle-HorizontalAlign=Center CellStyle-HorizontalAlign=Center PropertiesTextEdit-DisplayFormatString="dd/MM/yyyy" />
														<dx:GridViewDataColumn Caption="Description" FieldName=Descr VisibleIndex=7 />
														<dx:GridViewDataColumn Caption="Notes" FieldName=Notes VisibleIndex=8 />
														<dx:GridViewDataHyperLinkColumn Caption="Action" VisibleIndex=9 CellStyle-Cursor="pointer" HeaderStyle-Cursor="default">
															<DataItemTemplate>
																<a onclick="DeleteImage('<%# Eval("SrlNo") %>');">Delete</a>
															</DataItemTemplate>
														</dx:GridViewDataHyperLinkColumn>
													</Columns>
												</dx:ASPxGridView>
											</fieldset>
										</div>
									
									</div>
								</div>

								<!-- Using This Callback control you can send all data Client to Server without Load page using PageSaveCallback control -->
								<dx:ASPxCallbackPanel ID="PageSaveCallback" SettingsLoadingPanel-Text="Saving . . ." ClientInstanceName="PageSaveCallback" runat="server" OnCallback="PageSaveCallback_Callback">
									<PanelCollection>
										<dx:PanelContent runat="server">
											<asp:HiddenField ID="hdnSubcd" runat="server" />
										</dx:PanelContent>
									</PanelCollection>
									<%--On Call Back End--%>
									<ClientSideEvents EndCallback="function(s, e) { OnPageSaved(s.cp_close); }" />
								</dx:ASPxCallbackPanel>

							</div>
						</div>
					</div>
				</div>

			<input runat="server" id="hdnModalconfirmEntity" type="hidden" />

			<div class="modal fade" id="ModalconfirmDelete" role="dialog">
				<div class="modal-dialog modal-md">
					<!-- Modal content-->
					<div class="modal-content">
						<div class="modal-header ">
							<h4 class="modal-title"><i class="fa fa-exclamation-triangle faa-flash animated" aria-hidden="true"></i>Are you sure?</h4>
						</div>
						<div class="modal-body">
							&nbsp;&nbsp;&nbsp;&nbsp;<span style="color: darkslategray">You are about to delete this Record !!!</span>
						</div>
						<div class="modal-footer">
							<button type="button" id="btnconfirmAccountDelete" data-dismiss="modal" onclick="PageSaveCallback.PerformCallback('AccountDelete');" class="btn btn-danger">Delete</button>
							<button type="button" id="btnconfirmAccountCancel" data-dismiss="modal" class="btn btn-success">Cancel</button>
						</div>
					</div>
				</div>
			</div>

		</form>

		<div id="ipleasewait" style="text-align:center; position:fixed; top:30%; left:40%; visibility:hidden; z-index:100000">
			<i class="fa fa-spinner fa-4x fa-pulse fa-fw" aria-hidden="true"></i>
			<h6>Please Wait.....</h6>
		</div>
	</div>

	<!--================================================== -->
	<script src="../../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../../js/bootstrap/bootstrap.min.js"></script>
	
	<!-- PAGE RELATED PLUGIN(S) -->
	<script src="../../js/plugin/bootstrap-wizard/jquery.bootstrap.wizard.min.js"></script>
	<script src="../../js/plugin/fuelux/wizard/wizard.min.js"></script>

	<!-- StanSoft Script -->
	<script src="../../scripts/ssajax.js"></script>

	<script type="text/javascript">

		$(document).ready(function () {

			$('.btn-prev').prop('disabled', true);

			CheckMandatory(false);

			chkSpecialCategory_CheckedChanged();

			cboPanEmempted_SelectedIndexChanged();

			//// Bind the NEXT button event
			$("#btnNext").on("click", function (event) {
				if(pagefunction()) {
					$('.wizard').wizard('next');
				}
			});

			//// Bind the PREV button event
			$("#btnPrev").on("click", function (event) {
				$('.wizard').wizard('previous');
			});
		});

		function openKycListModal() {
			$('#modalKycList').modal('show');
			$('#ipleasewait').css('visibility', 'hidden');
		}

		function SetEntityToHidden(Entity)
		{
			$("#hdnModalconfirmEntity").val(Entity);
		}


		function ShowError(step, ctext, cerror) {

			if(ctext == '') {
				$("#" + step + " fieldset").css("display", "none");

				var cError = '<div class="alert alert-danger fade in divError' + step + '">' +
								 '<button class="close" data-dismiss="alert">' +
								 '<i class="fa-fw fa fa-times"></i>' +
								 '</button>' +
								 '<i class="fa-fw fa fa-times"></i>' +
								 '<strong>Error!</strong> ' + cerror + '' +
							 '</div>';

				$("#" + step + "").append(cError);
			}
			else {
				$("#" + step + " fieldset").css("display", "block");
			}
		};


		function IsMandatoryValueSet(cControl, cControlTxt)
		{
			if(cControlTxt != '')
			{
				$("#" + cControl + "").parent().parent().removeClass("has-error").addClass("has-success");
				$("#" + cControl + "").parent().find("span i").removeClass("glyphicon glyphicon-remove-circle").addClass("fa fa-check");

				return true;
			}
			else
			{
				$("#" + cControl + "").parent().parent().removeClass("has-success").addClass("has-error");
				$("#" + cControl + "").parent().find("span i").removeClass("fa fa-check").addClass("glyphicon glyphicon-remove-circle");

				return false;
			}
		}


		function CheckMandatory(showMessage)
		{
			var ActivePage = $(".wizard .steps .active").attr('data-target');

			var errorMsg = '';

			if(ActivePage == "#step1")
			{
				if(!IsMandatoryValueSet("txtName", txtName.GetText())) {
					errorMsg += 'Please enter name.\n';
				}
				IsMandatoryValueSet("txtMobile", txtMobile.GetText());
				IsMandatoryValueSet("txtEmail1", txtEmail1.GetText());
				IsMandatoryValueSet("txtAddress1", txtAddress1.GetText());
				IsMandatoryValueSet("txtPinCode", txtPinCode.GetText());
				IsMandatoryValueSet("txtCity", txtCity.GetText());
				IsMandatoryValueSet("cboState", cboState.GetText());
				IsMandatoryValueSet("cboCountry", cboCountry.GetText());
			}
			if(ActivePage == "#step2")
			{
				IsMandatoryValueSet("txtCPPhone", txtCPPhone.GetText());
			}
			if(ActivePage == "#step5") {
				IsMandatoryValueSet("txtRegPanNumber", txtRegPanNumber.GetText());
			}
			if(ActivePage == "#step7") {
				IsMandatoryValueSet("dtDOBOrIncorp", dtDOBOrIncorp.GetText());
				IsMandatoryValueSet("cboGender", cboGender.GetText());
				IsMandatoryValueSet("dtAppDate", dtAppDate.GetText());
				IsMandatoryValueSet("cboAppStatus", cboAppStatus.GetText());
				IsMandatoryValueSet("cboMaritalStatus", cboMaritalStatus.GetText());
				IsMandatoryValueSet("cboAnnualIncome", cboAnnualIncome.GetText());
				IsMandatoryValueSet("dtIncomeDate", dtIncomeDate.GetText());
				IsMandatoryValueSet("cboPanProofAttached", cboPanProofAttached.GetText());
				IsMandatoryValueSet("cboPanEmempted", cboPanEmempted.GetText());
				IsMandatoryValueSet("cboDocVeri", cboDocVeri.GetText());
				IsMandatoryValueSet("cboCorresDoc", cboCorresDoc.GetText());
				IsMandatoryValueSet("cboPermDoc", cboPermDoc.GetText());
				IsMandatoryValueSet("cboSameAsCorres", cboSameAsCorres.GetText());
				IsMandatoryValueSet("cboCorresState", cboCorresState.GetText());
				IsMandatoryValueSet("cboPermState", cboPermState.GetText());
				IsMandatoryValueSet("cboCorresCountry", cboCorresCountry.GetText());
				IsMandatoryValueSet("cboPermCountry", cboPermCountry.GetText());
				IsMandatoryValueSet("txtCorresRefId", txtCorresRefId.GetText());
				IsMandatoryValueSet("dtCorresRefIdDate", dtCorresRefIdDate.GetText());
				IsMandatoryValueSet("txtPermRefId", txtPermRefId.GetText());
				IsMandatoryValueSet("cboNationalityOthers", cboNationalityOthers.GetText());
				IsMandatoryValueSet("cboPep", cboPep.GetText());
				IsMandatoryValueSet("cboOccupations", cboOccupations.GetText());
			}

			if(errorMsg != '') {
				if(showMessage) {
					alert(errorMsg);
				}
				return false;
			}
			return true;
		}
		

		// ----------------------------------------------------------------------------------------- //
		// This function is called when a user hits NEXT button.
		// ----------------------------------------------------------------------------------------- //
		function pagefunction() {
			// Javascript local checking.
			if(!CheckMandatory(true)) {
				// Checking has failed.
				return false;
			}

			// Server-side checking.
			var ActivePage = $(".wizard .steps .active").attr('data-target'); // Current Active Page
			PageSaveCallback.PerformCallback(ActivePage); // Call C# Callback event of PageSaveCallback Control

			return true;
		};


		$("input").on("keydown keypress focusout", function (e) {
			CheckMandatory(false);
		});


		//Accept only digit
		$('.digit').bind('keyup blur', function ()
		{
			var node = $(this);
			node.val(node.val().replace(/[^0-9]/g, ''));
		});


		//Email validation
		function validateEmail(emailField)
		{
			var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;

			if(reg.test(emailField.val()) == false)
			{
				emailField.val('');
			}
		}


		//Pan validation
		function validatePAN(panField)
		{
			var reg = /[A-Z]{5}[0-9]{4}[A-Z]{1}$/;

			if(reg.test(panField.val()) == false)
			{
				panField.val('');
			}
		}


		$("#ModalconfirmDelete").on("hidden.bs.modal", function ()
		{
			var dp = /^dpcode=.+$/;
			var bank = /^bankcd=.+$/;

			if(dp.test($("#hdnModalconfirmEntity").val()) == true)
			{
				grdDP.Refresh();
			}
			if(bank.test($("#hdnModalconfirmEntity").val()) == true)
			{
				grdBankAccount.Refresh();
			}
		});


		function FillResidanceAddress(s, e)
		{
			var value = s.GetChecked();

			if(value == true)
			{
				txtResidanceAddress1.SetText(txtAddress1.GetText());
				txtResidanceAddress2.SetText(txtAddress2.GetText());
				txtResidanceAddress3.SetText(txtAddress3.GetText());
				txtResidancePinCode.SetText(txtPinCode.GetText());
				txtResidanceCity.SetText(txtCity.GetText());
				cboResidanceState.SetText(cboState.GetText());
				cboResidanceCountry.SetText(cboCountry.GetText());
				txtResidancePhone.SetText(txtPhone.GetText());
				txtResidanceFax.SetText(txtFax.GetText());
			}
			else
			{
				txtResidanceAddress1.SetText('');
				txtResidanceAddress2.SetText('');
				txtResidanceAddress3.SetText('');
				txtResidancePinCode.SetText('');
				txtResidanceCity.SetText('');
				cboResidanceState.SetSelectedIndex(-1);
				cboResidanceCountry.SetSelectedIndex(-1);
				txtResidancePhone.SetText('');
				txtResidanceFax.SetText('');
			}
		}


		function chkSpecialCategory_CheckedChanged()
		{
			cboCscDetails.SetEnabled(chkSpecialCategory.GetChecked());
		}


		function cboPanEmempted_SelectedIndexChanged()
		{
			var isPanExempted = cboPanEmempted.GetValue() == "Y";
			cboPanExemptCat.SetEnabled(isPanExempted);
			cboPanEmemptProof.SetEnabled(isPanExempted);
		}


		// --------------------------------------------------------------------------------------------------------------------- //
		// DP Account Adding/Editing 
		// --------------------------------------------------------------------------------------------------------------------- //
		function DPAddEdit(type, dpcode, clientid) {
			var subCd = document.getElementById('<%= hdnSubcd.ClientID%>').value;
			// If subCd is nothing then do not process further
			if(subCd == "") return;

			// Dialog Title
			var cTitle = "<i class=\"fa fa-plus\"></i> Add DP";
			if(type == "Update") {
				cTitle = "<i class=\"fa fa-pencil-square\"></i> Update DP";
			}

			// Create the options object for the dialog.
			var opts = {
				type: "OKCANCEL",
				//type: "",
				//url: "AddEdit_DP_Account.aspx?&subcd=" + subCd + "&type=" + type + "&dpcode=" + dpcode + "&clientid=" + clientid + "&sessionid=" + '<%= Request.QueryString["sessionid"] %>',
				url: "dotnet/KYC/AddEdit_DP_Account.aspx?&subcd=" + subCd + "&type=" + type + "&dpcode=" + dpcode + "&clientid=" + clientid,
				title: cTitle,
				savecaption: "<i class=\"fa fa-floppy-o\"></i> Save",
				cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
				width: 450,
				height: 450,
				reload: false,			// Reload the page [Grid] when a successful save happens
				// We make sure that the RefreshGrid function is fired once we successfully update the data.
				fnpostsuccess: function () {
					grdDP.PerformCallback("refresh");
				},

				reloadwindow: null	// Rev 3.9.2016 : We will hit the parent function [see below] but want the
				// current window to be reloaded.
			};
			// Remember : that we open the dialog in the PARENT frame. 
			parent.urlFormDialog(opts);
		}


		// --------------------------------------------------------------------------------------------------------------------- //
		// Bank Account Adding/Editing 
		// --------------------------------------------------------------------------------------------------------------------- //
		function BankAddEdit(type, bankcd, acno) {
			var subCd = document.getElementById('<%= hdnSubcd.ClientID%>').value;
			// If subCd is nothing then do not process further
			if(subCd == "") return;

			var cTitle = "<i class=\"fa fa-plus\"></i> Add Bank Account";
			if(type == "Update") {
				cTitle = "<i class=\"fa fa-pencil-square\"></i> Update Bank Account";
			}

			var opts = {
				type: "OKCANCEL",
				//type: "",
				//url: "AddEdit_Bank_Account.aspx?&subcd=" + subCd + "&type=" + type + "&bankcd=" + bankcd + "&acno=" + acno + "&sessionid=" + '<%= Request.QueryString["sessionid"] %>',
				url: "dotnet/KYC/AddEdit_Bank_Account.aspx?&subcd=" + subCd + "&type=" + type + "&bankcd=" + bankcd + "&acno=" + acno,
				title: cTitle,
				savecaption: "<i class=\"fa fa-floppy-o\"></i> Save",
				cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
				width: 450,
				height: 480,
				reload: false,			// Reload the page [Grid] when a successful save happens

				// We make sure that the RefreshGrid function is fired once we successfully update the data.
				fnpostsuccess: function () {
					grdBankAccount.PerformCallback("refresh");
				},

				reloadwindow: null	// Rev 3.9.2016 : We will hit the parent function [see below] but want the
				// current window to be reloaded.
			};
			parent.urlFormDialog(opts);
		}

		// --------------------------------------------------------------------------------------------------------------------- //
		// Trading Member Adding/Editing 
		// --------------------------------------------------------------------------------------------------------------------- //
<%--		function OtherTradingMemberAddEdit(type, TMSEBINO) {
			var subCd = document.getElementById('<%= hdnSubcd.ClientID%>').value;
			// If subCd is nothing then do not process further
			if(subCd == "") return;

			var cTitle = "<i class=\"fa fa-plus\"></i> Add Trading Member";
			if(type == "Update") {
				cTitle = "<i class=\"fa fa-pencil-square\"></i> Update Trading Member";
			}

			var opts = {
				type: "OKCANCEL",
				//type: "",
				url: "dotnet/KYC/AddEdit_Trading_Member.aspx?&subcd=" + subCd + "&type=" + type + "&TMSEBINO=" + TMSEBINO + "&sessionid=" + '<%= Request.QueryString["sessionid"] %>',
				title: cTitle,
				savecaption: "<i class=\"fa fa-floppy-o\"></i> Save",
				cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
				width: 450,
				height: 480,
				reload: false,			// Reload the page [Grid] when a successful save happens

				// We make sure that the RefreshGrid function is fired once we successfully update the data.
				fnpostsuccess: function () { grdTradingMember.Refresh(); },

				reloadwindow: null	// Rev 3.9.2016 : We will hit the parent function [see below] but want the
				// current window to be reloaded.
			};
			parent.urlFormDialog(opts);
		}
--%>


		// --------------------------------------------------------------------------------------------------------------------- //
		// Annual Income Add
		// --------------------------------------------------------------------------------------------------------------------- //
		function AddAnnualIncome() {
			var subCd = document.getElementById('<%= hdnSubcd.ClientID%>').value;
			// If subCd is nothing then do not process further
			if(subCd == "") return;

			var opts = {
				type: "OKCANCEL",
				url: "dotnet/KYC/AnnualIncomeAddEdit.aspx?subCd=" + subCd,
				title: "<i class='fa fa-money'></i> Annual Income",
				savecaption: "<i class=\"fa fa-floppy-o\"></i> Save",
				cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
				width: 500,
				height: 550,
				reload: false,
				fnpostsuccess: function () { grdAnnualIncome.PerformCallback("refresh"); },
				reloadwindow: null
			};
			parent.urlFormDialog(opts);
		}


		// --------------------------------------------------------------------------------------------------------------------- //
		// Annual Income Update
		// --------------------------------------------------------------------------------------------------------------------- //
		function UpdateAnnualIncome(SubCd, Acc_Descr) {
			// If subCd or acc_Descr is nothing then do not process further
			if(subCd == "" || acc_Descr == "") return;

			var opts = {
				type: "OKCANCEL",
				url: "dotnet/KYC/AnnualIncomeAddEdit.aspx?subCd=" + subCd + "&accDescr=" + acc_Descr,
				title: "<i class='fa fa-money'></i> Annual Income",
				savecaption: "<i class=\"fa fa-floppy-o\"></i> Save",
				cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
				width: 500,
				height: 550,
				reload: false,
				fnpostsuccess: function () { grdAnnualIncome.PerformCallback("refresh"); },
				reloadwindow: null
			};
			parent.urlFormDialog(opts);
		}

		// --------------------------------------------------------------------------------------------------------------------- //
		// Annual Income Delete
		// --------------------------------------------------------------------------------------------------------------------- //
		function DeleteAnnualIncome(subCd, acc_Descr)
		{
			// If subCd or acc_Descr is nothing then do not process further
			if(subCd == "" || acc_Descr == "") return;

			var result = confirm("Do you really want to delete this entry?");
			if(result) {
				$.ajax({
					type: "POST",
					url: "NewClientRequest.aspx/DeleteAnnualIncome",
					data: "{subCd:'" + subCd + "', accDescr:'" + acc_Descr + "'}",
					contentType: "application/json; charset=utf-8",
					dataType: "json",
					success: function () {
						grdAnnualIncome.PerformCallback("refresh");
					},
					failure: function (response) {
						alert(response.d);
					}
				})
			}
		}


		// --------------------------------------------------------------------------------------------------------------------- //
		// Scanned Image Add
		// --------------------------------------------------------------------------------------------------------------------- //
		function AddImage()
		{
			var subCd = document.getElementById('<%= hdnSubcd.ClientID%>').value;
			// If subCd is nothing then do not process further
			if(subCd == "") return;

			var opts = {
				type: "OKCANCEL",
				url: "dotnet/KYC/AddScannedImage.aspx?subCd=" + subCd,
				title: "<i class='fa fa-upload'></i> Upload Image / File",
				savecaption: "<i class=\"fa fa-times\"></i> Close",
				cancelcaption: "<i class=\"fa fa-times\"></i>",
				width: 500,
				height: 417,
				reload: false,
				fnpostsuccess: function () {
					grdScanImage.PerformCallback("refresh");
				},
				reloadwindow: null
			};
			parent.urlFormDialog(opts);
		}


		// --------------------------------------------------------------------------------------------------------------------- //
		// Scanned Image Delete
		// --------------------------------------------------------------------------------------------------------------------- //
		function DeleteImage(srlNo) {
			// If srlNo is nothing then do not process further
			if(srlNo == "") return;

			var result = confirm("Do you really want to delete this entry?");
			if(result) {
				$.ajax({
					type: "POST",
					url: "NewClientRequest.aspx/DeleteScannedImage",
					data: "{srlNo:'" + srlNo + "'}",
					contentType: "application/json; charset=utf-8",
					dataType: "json",
					success: function () {
						grdScanImage.PerformCallback("refresh");
					},
					failure: function (response) {
						alert(response.d);
					}
				})
			}
		}


		function OnPageSaved(cpclose) {
			//if(cpclose == "#step1") {
			//	// When we add a new KYC then the pending KYC list box should be refreshed to
			//	// reflect the new entry. The refresh is done based on the selected index of
			//	// item in the list box. If nothing is selected it implies a new entry.
			//	if(lstPendingClientList.GetSelectedIndex() == -1) {
			//		// Ajax callback function of devexpress ASPxListBox
			//		lstPendingClientList.PerformCallback("refresh");
			//	}
			//}

			// After step 9
			if(cpclose == "#step9")	{
				$(".wizard, .step-content").css("display", "none");

				var cFinished = '<h1 class="text-center text-success">' +
									 '<i class="fa fa-check"></i> Congratulations!' +
									 '<br>' +
									 '<small>All data successfully submitted.</small>' +
									 //'<small>You have successfully submitted all information with us.</small>' +
									 //'<br>' +
									 //'<small>We send a email for email verification. Please verify your email ASAP. </small>' +
									 '<br>' +
									 '<small>Thank You</small>' +
								 '</h1>';

				$(".fuelux").append(cFinished);
			}
		}

		function searchNames() {
			// Declare variables
			var input, filter, select, option, i;
			input = document.getElementById('txtSearch');
			filter = input.value.toUpperCase();
			select = document.getElementById("lstPendingClientList");
			option = select.getElementsByTagName('option');

			// Loop through all list items, and hide those who don't match the search query
			for(i = 0; i < option.length; i++) {
				if(option[i].innerHTML.toUpperCase().indexOf(filter) > -1) {
					option[i].style.display = "";
				} else {
					option[i].style.display = "none";
				}
			}
		}

	</script>
</body>
</html>


<!--
			function CheckMandatory(showMessage)
		{
			var ActivePage = $(".wizard .steps .active").attr('data-target');

			var errorMsg = '';

			if(ActivePage == "#step1")
			{
				if(!IsMandatoryValueSet("txtName", txtName.GetText())) {
					errorMsg += 'Please enter name.\n';
				}
				if(!IsMandatoryValueSet("txtMobile", txtMobile.GetText())) {
					errorMsg += 'In Contact Details Tab : Please enter mobile.\n';
				}
				if(!IsMandatoryValueSet("txtEmail1", txtEmail1.GetText())) {
					errorMsg += 'In Contact Details Tab : Please enter email.\n';
				}
				if(!IsMandatoryValueSet("txtAddress1", txtAddress1.GetText())) {
					errorMsg += 'In Correspondence Address Tab : Please enter address.\n';
				}
				if(!IsMandatoryValueSet("txtPinCode", txtPinCode.GetText())) {
					errorMsg += 'In Correspondence Address Tab : Please enter pin code.\n';
				}
				if(!IsMandatoryValueSet("txtCity", txtCity.GetText())) {
					errorMsg += 'In Correspondence Address Tab : Please enter city.\n';
				}
				if(!IsMandatoryValueSet("cboState", cboState.GetText())) {
					errorMsg += 'In Correspondence Address Tab : Please select state.\n';
				}
				if(!IsMandatoryValueSet("cboCountry", cboCountry.GetText())) {
					errorMsg += 'In Correspondence Address Tab : Please select country.\n';
				}
			}
			if(ActivePage == "#step2")
			{
				if(!IsMandatoryValueSet("txtCPPhone", txtCPPhone.GetText())) {
					errorMsg += 'In Contact Person Tab : Please enter phone.\n';
				}
			}
			if(ActivePage == "#step5") {
				if(!IsMandatoryValueSet("txtRegPanNumber", txtRegPanNumber.GetText())) {
					errorMsg += 'In IT File Tab : Please enter PAN.\n';
				}
			}
			if(ActivePage == "#step7") {
				if(!IsMandatoryValueSet("dtDOBOrIncorp", dtDOBOrIncorp.GetText())) {
					errorMsg += 'In Details Tab : Please enter date of birth.\n';
				}
				if(!IsMandatoryValueSet("cboGender", cboGender.GetText())) {
					errorMsg += 'In Details Tab : Please select gender.\n';
				}
				if(!IsMandatoryValueSet("dtAppDate", dtAppDate.GetText())) {
					errorMsg += 'In KRA Details Tab : Please enter application date.\n';
				}
				if(!IsMandatoryValueSet("cboAppStatus", cboAppStatus.GetText())) {
					errorMsg += 'In KRA Details Tab : Please enter application status.\n';
				}
				if(!IsMandatoryValueSet("cboMaritalStatus", cboMaritalStatus.GetText())) {
					errorMsg += 'In KRA Details Tab : Please select maritial status.\n';
				}
				if(!IsMandatoryValueSet("cboAnnualIncome", cboAnnualIncome.GetText())) {
					errorMsg += 'In KRA Details Tab : Please enter annual income.\n';
				}
				if(!IsMandatoryValueSet("dtIncomeDate", dtIncomeDate.GetText())) {
					errorMsg += 'In KRA Details Tab : Please enter income date.\n';
				}
				if(!IsMandatoryValueSet("cboPanProofAttached", cboPanProofAttached.GetText())) {
					errorMsg += 'In KRA Details Tab : Please select PAN proof.\n';
				}
				if(!IsMandatoryValueSet("cboPanEmempted", cboPanEmempted.GetText())) {
					errorMsg += 'In KRA Details Tab : Please select PAN exempted.\n';
				}
				if(!IsMandatoryValueSet("cboDocVeri", cboDocVeri.GetText())) {
					errorMsg += 'In KRA Details Tab : Please select document verification.\n';
				}
				if(!IsMandatoryValueSet("cboCorresDoc", cboCorresDoc.GetText())) {
					errorMsg += 'In KRA Details Tab : Please select doc. for corres. address.\n';
				}
				if(!IsMandatoryValueSet("cboPermDoc", cboPermDoc.GetText())) {
					errorMsg += 'In KRA Details Tab : Please select doc. for perma. address.\n';
				}
				if(!IsMandatoryValueSet("cboSameAsCorres", cboSameAsCorres.GetText())) {
					errorMsg += 'In KRA Details Tab : Please select perma. address same as corres. address.\n';
				}
				if(!IsMandatoryValueSet("cboCorresState", cboCorresState.GetText())) {
					errorMsg += 'In KRA Details Tab : Please select corres. state.\n';
				}
				if(!IsMandatoryValueSet("cboPermState", cboPermState.GetText())) {
					errorMsg += 'In KRA Details Tab : Please select prema. state.\n';
				}
				if(!IsMandatoryValueSet("cboCorresCountry", cboCorresCountry.GetText())) {
					errorMsg += 'In KRA Details Tab : Please select corres. country.\n';
				}
				if(!IsMandatoryValueSet("cboPermCountry", cboPermCountry.GetText())) {
					errorMsg += 'In KRA Details Tab : Please select prema. country.\n';
				}
				if(!IsMandatoryValueSet("txtCorresRefId", txtCorresRefId.GetText())) {
					errorMsg += 'In KRA Details Tab : Please enter corres. ref. Id.\n';
				}
				if(!IsMandatoryValueSet("dtCorresRefIdDate", dtCorresRefIdDate.GetText())) {
					errorMsg += 'In KRA Details Tab : Please enter corres. ref. Id date.\n';
				}
				if(!IsMandatoryValueSet("txtPermRefId", txtPermRefId.GetText())) {
					errorMsg += 'In KRA Details Tab : Please enter prema. ref. Id.\n';
				}
				if(!IsMandatoryValueSet("cboNationalityOthers", cboNationalityOthers.GetText())) {
					errorMsg += 'In KRA Details Tab : Please select nationality others.\n';
				}
				if(!IsMandatoryValueSet("cboPep", cboPep.GetText())) {
					errorMsg += 'In KRA Details Tab : Please select PEP.\n';
				}
				if(!IsMandatoryValueSet("cboOccupations", cboOccupations.GetText())) {
					errorMsg += 'In KRA Details Tab : Please select occupation.\n';
				}
			}

			//if(errorMsg != '') {
			//	if(showMessage) {
			//		alert(errorMsg);
			//	}
			//	return false;
			//}
			return true;
		}

-->