﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="BulkAssign.aspx.cs" Inherits="Connect_DotNet.LeadManagement.BulkAssign" %>
<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>

    <!-- #CSS Links -->
	<!-- Basic Styles 
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
        -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-skins.min.css">

	<!-- BootComplete http://getwebhelp.com/bootcomplete/ -->
	<link href="../../scripts/BootStrap/plugins/bootcomplete/bootcomplete.css" rel="stylesheet" />
	
	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">
	
	<link href="../../css/your_style.css" rel="stylesheet" />
    <link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />

    <style type="text/css">
        .borderless td, .borderless th {
            border:none !important ;
        }
        .borderless > thead > tr > th, .borderless > tbody > tr > th, .borderless > tfoot > tr > th, .borderless > thead > tr > td, .borderless > tbody > tr > td, .borderless > tfoot > tr > td {
            padding: 1px !important ;
        }
        
        .table{
            border:none !important ;
        }

        .dxgvCSD /*For grid*/
        {

             border-top: 1px solid;
             border-bottom: 1px solid;

             height: auto !important;
             max-height: 150px !important; /*Custom grid size*/

        }

         html, body {
            background:none!important;
            background-color:linen;
        }

         .alignRight { text-align:right }
         .alignLeft { text-align:left }

		/*.completionList
		{	
			z-index: 100000 !important;
		}
		.listItem
		{
			z-index: 100000 !important;
		}
		.itemHighlighted
		{
			z-index: 100000 !important;
		}*/
         
    </style>
	
	<script>
		function SelectedStaff(source, eventArgs) {
		    document.getElementById("hdnorgcode").value = eventArgs.get_value();
		}
	</script>

</head>
<body>
    <form id="frmLeadBulkAssign" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
        <div class="container-fluid">
	        <br />
            <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                <ContentTemplate>
                    <div class="row">
                        <div class="col-sm-1">
                        </div>
                        <div class="col-sm-10">
                            <legend>Bulk Assignment</legend>
                        </div>
                        <div class="col-sm-1">
                        </div>
                     </div>
                    <div class="row">
                        <div class="col-sm-1">
                        </div>
                        <div class="col-sm-5">
                             <table class="table table-responsive borderless">
                                <colgroup><col style="width:30%"/><col style="width:70%"/></colgroup>
                                <tr runat="server" id="trAssignment">
                                <td class="alignRight"><dx:ASPxLabel ID=ASPxLabel2 runat="server" Text="Assignment :"></dx:ASPxLabel></td>
			                    <td><dx:ASPxComboBox ID="cboAssignment" Width="100%" CssClass="form-control input-sm" AutoPostBack="true"  Native="true" ClientInstanceName="cboAssignment" runat="server" ValueType="System.String" EnableIncrementalFiltering="true" OnSelectedIndexChanged="cboAssignment_SelectedIndexChanged">
                                    </dx:ASPxComboBox>
			                    </td>
                                </tr>
                                <tr>
			                    <td class="alignRight">
                                    <dx:ASPxLabel ID=ASPxLabel4 runat="server" Text="Count :" ></dx:ASPxLabel>
			                    </td>
			                    <td>
                                    <dx:ASPxSpinEdit ID="spinLeadAssignCount" ClientInstanceName="spinLeadAssignCount" Height="30px" MinValue="1" MaxValue="100" runat="server" Number="1">
                                    </dx:ASPxSpinEdit>
			                    </td>
		                    </tr>
                            <tr>
                                <td></td><td style="vertical-align:top; text-align:right";>
                                    <dx:ASPxButton ID=btnAssign ClientInstanceName="btnAssign" runat="server" Text="Apply" Native="true"  CssClass="btn btn-info" OnClick="btnAssign_Click">
                                        <ClientSideEvents 
                                             Click="
                                            function(s, e) {
                                            
                                            if (spinLeadAssignCount.GetInputElement().value=='')
                                            {return false;}
                                            
                                            $('#ipleasewait').css('visibility', 'visible');

                                            //btnAssign.SetEnabled(false);

                                            }"
                                            />
                                    </dx:ASPxButton>
                                </td>
                            </tr>
                        </table>
                        </div>
                        <div class="col-sm-5">
                            <table class="table table-responsive borderless">
                                <colgroup><col style="width:30%"/><col style="width:70%"/></colgroup>
                                <tr>
                                    <td class="alignRight">
                                        <dx:ASPxLabel ID=lblBulkAssignmentType runat="server" Text="Bulk Assign Type :" Visible="false"></dx:ASPxLabel>
			                        </td>
                                    <td>
                                        <dx:ASPxComboBox ID="cboBulkAssignmentType" Width="100%" CssClass="form-control input-sm" AutoPostBack="true"  Native="true" ClientInstanceName="cboBulkAssignmentType" runat="server" ValueType="System.String" EnableIncrementalFiltering="true" Visible="false" OnSelectedIndexChanged="cboBulkAssignmentType_SelectedIndexChanged">
                                            <Items>
                                            <%--<dx:ListEditItem Text="Auto" Value="AUTO" />--%>
                                            <dx:ListEditItem Text="Multi Select" Value="MULTI" />
                                            <dx:ListEditItem Selected="true"  Text="Single" Value="SINGLE" />
                                            </Items>
                                        </dx:ASPxComboBox>
                                    </td>
                                 </tr>
                                <%--<tr id="trStaffupto" runat="server" visible="false" >
                                    <td class="alignRight"><dx:ASPxLabel ID=ASPxLabel1 runat="server" Text="Staff up to :"></dx:ASPxLabel></td>
                                    <td>
                                        <dx:ASPxSpinEdit ID="spinEditStaffupto" ClientInstanceName="spinLeadAssignCount" Height="30px" runat="server" Number="1">
                                        </dx:ASPxSpinEdit>
                                    </td>
                                </tr>--%>
                                <tr id="trAssigtostaff" runat="server" visible="false" >
                                <td class="alignRight"><dx:ASPxLabel ID=lblAssignment runat="server" Text="* Staff Name :"></dx:ASPxLabel></td>
			                    <td>
				                    <ajaxToolkit:AutoCompleteExtender ID=AutoCompleteExtender2 runat="server" 
					                    CompletionListCssClass="completionList"
					                    CompletionListItemCssClass="listItem"
					                    CompletionListHighlightedItemCssClass="itemHighlighted"
					                    ServiceMethod="GetStaffList"
					                    MinimumPrefixLength="1"    
					                    CompletionInterval="10" 
					                    EnableCaching="false"
					                    TargetControlID="txtstaff"    
					                    FirstRowSelected="false" 
					                    OnClientItemSelected="SelectedStaff">   
				                    </ajaxToolkit:AutoCompleteExtender>
				                    <asp:HiddenField ID=hdnorgcode runat="server" />
				                    <asp:TextBox ID=txtstaff runat="server" Width="100%" CssClass="form-control input-sm"></asp:TextBox>
			                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-sm-1">
                        </div>
                    </div>
                <br />
                <div class="row">
                    <div class="col-sm-1">
                    </div>
                    <div class="col-sm-5">
                        <table class="table table-responsive borderless">
                        <colgroup><col style="width:40%"/><col style="width:60%"/></colgroup>
                            <tr>
                            <td>
                                <dx:ASPxLabel ID=ASPxLabel3 Font-Size="Small" runat="server" Text="Total Leads :"></dx:ASPxLabel>
                                <dx:ASPxLabel ID=lblLeadCount runat="server" Font-Size="Small" Text="0"></dx:ASPxLabel>
                            </td>
						    <td>
                                <dx:ASPxLabel ID=ASPxLabel7 Font-Size="Small" runat="server" Text="Remaining Leads :"></dx:ASPxLabel>
                                <dx:ASPxLabel ID=lblRemLeadCount runat="server" Font-Size="Small" Text="0"></dx:ASPxLabel>
						    </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                   <dx:ASPxGridView ID="grdUnAssignLead" KeyFieldName="LeadCd" ClientInstanceName="grdUnAssignLead" runat="server" AutoGenerateColumns="false" Width="100%" Theme="Office2010Silver"  >
                                    <Settings  GridLines="Horizontal" ShowColumnHeaders="true" />
                                    <Columns>
						                <dx:GridViewDataTextColumn FieldName="LeadCd" Caption="Lead Cd" Width="30%" >
						                </dx:GridViewDataTextColumn>
                                        <dx:GridViewDataTextColumn FieldName="Descr" Caption="Lead Name" Width="70%" >
						                </dx:GridViewDataTextColumn>
					                </Columns>
						            <SettingsPager Mode="ShowPager" NumericButtonCount="3" PageSize="10"></SettingsPager>
						            <SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
					            </dx:ASPxGridView>
                                </td>
                            </tr>
                    </table>
                    </div>
                    <div class="col-sm-5">
                        <table class="table table-responsive borderless">
                            <colgroup><col style="width:40%"/><col style="width:60%"/></colgroup>
                                <tr>
                                <td>
                                    <dx:ASPxLabel ID=ASPxLabel5 Font-Size="Small" runat="server" Text="Lead Assign :"></dx:ASPxLabel>
                                    <dx:ASPxLabel ID=lblAssginLeadCount runat="server" Font-Size="Small" Text="0"></dx:ASPxLabel>
                                </td>
							    <td>
							    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <dx:ASPxGridView ID="grdAssignTo" KeyFieldName="staff" ClientInstanceName="grdAssignTo" runat="server" AutoGenerateColumns="false" Width="100%" Theme="Office2010Silver"  >
                                        <Settings  GridLines="Horizontal" ShowColumnHeaders="true" />
                                        <Columns>
                                            <dx:GridViewDataTextColumn FieldName="assignstatus" Caption="Status" Width="30%" >
						                    </dx:GridViewDataTextColumn>
						                    <dx:GridViewDataTextColumn FieldName="staff" Caption="Staff" Width="60%" >
						                    </dx:GridViewDataTextColumn>
                                            <dx:GridViewDataTextColumn FieldName="count" Caption="Count" Width="10%" >
						                    </dx:GridViewDataTextColumn>
					                    </Columns>
						                <SettingsPager Mode="EndlessPaging"></SettingsPager>
						                <SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
					                </dx:ASPxGridView>
                                    </td>
                                </tr>
                        </table>
                    </div>
                    <div class="col-sm-1">
                    </div>
                </div>
                <div class="modal fade " id="ModalAssignment"   role="dialog" >
                    <div class="modal-dialog modal-lg" style="width:60%!important">
                        <!-- Modal content-->
                        <div class="modal-content">
                            <div class="modal-header ">
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                <h4 runat="server" id="hModalAssignmenttitle" class="modal-title"><i class="fa fa-share-square-o"></i> Assignment Success</h4>
                            </div>
                            <div class="modal-body" style="height:100px">
                                <br />
                                <div runat="server" id="msgdiv" class="alert alert-success fade in">
                                    <i class="fa-fw fa fa-check"></i>
                                    <strong>Info!</strong> <span runat="server" id="spanmsg"></span>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" id="btnclose" class="btn btn-primary" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                            </div>
                        </div>
                    </div>
                </div>

              <div class="modal fade" id="ModalErrormsg" role="dialog">
				<div class="modal-dialog modal-md">
					<!-- Modal content-->
					<div class="modal-content">
						<div class="modal-header ">
							<h4 class="modal-title"><i class="fa fa-exclamation-triangle faa-flash animated" aria-hidden="true"></i>Error on Lead Assignment!!!</h4>
						</div>
						<div class="modal-body">
							&nbsp;&nbsp;&nbsp;&nbsp;<span id="spanErrorMsg" runat="server" style="color: darkslategray"></span>
						</div>
						<div class="modal-footer">
							<button type="button" data-dismiss="modal" class="btn btn-primary">Close</button>
						</div>
					</div>
				</div>
			</div>

            <div class="modal fade" id="ModalMultiSelect" role="dialog">
				<div class="modal-dialog" style="width:70%">
					<!-- Modal content-->
					<div class="modal-content">
						<div class="modal-header ">
							<h4 class="modal-title"><i class="fa fa-check-square" aria-hidden="true"></i> Select Staff for Lead Assignment</h4>
						</div>
						<div class="modal-body" style="overflow: auto; height: 400px">
                            <dx:ASPxCheckBoxList Width="100%" ID="chkbxlstAssignStaff" ClientInstanceName="chkbxlstAssignStaff" runat="server" RepeatColumns="3" ValueType="System.String" Theme="Aqua"></dx:ASPxCheckBoxList>
						</div>
						<div class="modal-footer">
                            <button type="button" onclick="chkbxlstAssignStaff.SelectAll();" class="btn btn-success">Select All</button>
                            <button type="button" onclick="chkbxlstAssignStaff.UnselectAll();" class="btn btn-danger">Clear</button>
							<button type="button" data-dismiss="modal" class="btn btn-primary">Done</button>
						</div>
					</div>
				</div>
			</div>

                </ContentTemplate>
            </asp:UpdatePanel>
        </div>
        
        <div id="ipleasewait" style="text-align: center; position: fixed; top: 30%; left: 40%; visibility:hidden;">
			<i class="fa fa-spinner fa-4x fa-pulse fa-fw" aria-hidden="true"></i>
			<h6>Please Wait.....</h6>
		</div>
    </form>

    <!--================================================== -->
		<!--
	<script src="../../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../../js/bootstrap/bootstrap.min.js"></script>
    -->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>

	<!-- PAGE RELATED PLUGIN(S) -->
	<script src="../../js/plugin/bootstrap-wizard/jquery.bootstrap.wizard.min.js"></script>
	<script src="../../js/plugin/fuelux/wizard/wizard.min.js"></script>

	<!-- StanSoft Script -->

	<script src="../../scripts/ssajax.js"></script>
    <script>
        parent.$('#btn1').hide();
    </script>

</body>
</html>
