﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="LeadList.aspx.cs" Inherits="Connect_DotNet.LeadManagement.LeadList" %>
<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>

    
    <!-- #CSS Links -->
	<!-- Basic Styles 
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
        -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-skins.min.css">

	<!-- BootComplete http://getwebhelp.com/bootcomplete/ -->
	<link href="../../scripts/BootStrap/plugins/bootcomplete/bootcomplete.css" rel="stylesheet" />
	
	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">
	
	<link href="../../css/your_style.css" rel="stylesheet" />
    <link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />


	<style>
		
         .borderless td, .borderless th {
            border:none !important ;
        }
        .borderless > thead > tr > th, .borderless > tbody > tr > th, .borderless > tfoot > tr > th, .borderless > thead > tr > td, .borderless > tbody > tr > td, .borderless > tfoot > tr > td {
            padding: 1px !important ;
        }
        .alignRight { text-align:right }
        .alignLeft { text-align:left }
        
	            

                .alink:link {
                    color: #3276B1;
                }

                /* visited link */
                .alink:visited {
                    color: #3276B1;
                }

                /* mouse over link */
                .alink:hover {
                    color: hotpink;
                    /*color:black;*/
                }

                /* selected link */
                .alink:active {
                    color: #3276B1;
                }



	</style>

	<script>
       
		function Validate() {
			if(txtSearch.GetText() == "") return false;
			
			return true;
		}
		function GridRefress() {
		    $("#SearchPanelDiv").collapse("hide");
		    grdLeadList.Refresh();
		    
		    
		    //setTimeout(function () { grdLeadList.Refresh(); }, 5000);
		    
		}
		
	</script>
</head>
<body style="background:white!important">
    
	<div class="container-fluid">
		<%--<h2><i class="fa fa-list " aria-hidden="true"></i> Lead List</h2>--%>
        <br />
				<form id="frmLeadList" class="form-inline"  runat="server">
                    <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
                     <table>
                        <tr>
                            <td style="padding-bottom: 5px">
                                <a href="#SearchPanelDiv" class="btn btn-info btn-xs" data-toggle="collapse" >Search Panel ▼</a>
                            </td>
                            <td style="padding-left: 5px; padding-bottom: 5px">
                                <button type="button" id="btnExpand" class="btn btn-success btn-xs" onclick="ExpandAll();">
                                <i class="fa fa-expand"></i> Expand All</button>
                                <button type="button" id="btnHide" style="display:none" class="btn btn-danger btn-xs" onclick="HideAll()">
                                <i class="fa fa-compress"></i> Hide All</button>
                            </td>
                            <td style="padding-left: 5px; padding-bottom: 5px" id="tdAddLead" runat="server">
                                <button type="button" class="btn btn-primary btn-xs" onclick="LeadAddEdit('ADD');">
                                <i class="fa fa-plus"></i> New Lead</button>
		                    </td>

                            <td style="padding-left: 5px; padding-bottom: 5px" id="tdLeadImport" runat="server">
                                <button type="button" class="btn btn-primary btn-xs" onclick="LeadImport()">
                                    <i class="fa fa-upload"></i> Lead Import</button>
		                    </td>
                            <td style="padding-left: 5px; padding-bottom: 5px" id="tdLeadBulkAssign" runat="server">
                                <button type="button" class="btn btn-primary btn-xs" onclick="BulkAssign()">
                                    <i class="fa fa-share-square-o"></i> Bulk Assign</button>
		                    </td>
                        </tr>
                    </table>
    
                    <div id="SearchPanelDiv" class="collapse" >
                        <asp:UpdatePanel ID="UpdatePanel1" runat="server" >
                            <ContentTemplate >   
					            <table id="tblInput" class="table table-condensed " style="font-size:small; background-color:#FFFFFF">
						        <tr>
                                    <td class="alignRight">Lead Type </td>
                                    <td>
                                        <dx:ASPxComboBox ID="cmbLeadType" runat="server" ClientInstanceName="cmbLeadType" CssClass="form-control input-sm" EnableIncrementalFiltering="true" ValueType="System.String" Width="100%">
                                        </dx:ASPxComboBox>
                                    </td>
                                    <td class="alignRight">
                                        Lead Status
                                    </td>
                                    <td>
                                        <dx:ASPxComboBox ID=cmbLeadStatus Width="100%" runat="server" Native="true" ClientInstanceName="cmbLeadStatus" CssClass="form-control input-sm" ValueType="System.String" EnableIncrementalFiltering="true">
                                            
                                        </dx:ASPxComboBox>
                                    </td>                            
                                    <td class="alignRight">
                                        DND Status
                                    </td>
                                    <td>
                                        <dx:ASPxComboBox ID="cmbDNDStatus" Width="100%" CssClass="form-control input-sm" ClientInstanceName="cmbDNDStatus" runat="server" ValueType="System.String" EnableIncrementalFiltering="true">
                                        </dx:ASPxComboBox>
                                    </td>
                                    </tr>
                                <tr>
                                    <td class="alignRight">Source </td>
                                    <td>
                                        <dx:ASPxComboBox ID="cmbLeadSource" runat="server" ClientInstanceName="cbmLeadSource" CssClass="form-control input-sm" EnableIncrementalFiltering="true" ValueType="System.String" Width="100%">
                                        </dx:ASPxComboBox>
                                    </td>
                                    <td class="alignRight">
                                        Assignment
                                    </td>
                                    <td>
                                        <dx:ASPxComboBox ID="cmbAssignment" Width="100%" CssClass="form-control input-sm" ClientInstanceName="cmbAssignment" runat="server" ValueType="System.String" EnableIncrementalFiltering="true">
                                        </dx:ASPxComboBox>
                                    </td>
                                    <td class="alignRight">Rank </td>
                                    <td>
                                    <dx:ASPxComboBox ID="cmbRank" runat="server" ClientInstanceName="cmbRank" CssClass="form-control input-sm" EnableIncrementalFiltering="true" ValueType="System.String" Width="100%">
                                        <Items>
                                            <dx:ListEditItem Text="Low  [0-5]" Value="0-5" />
                                            <dx:ListEditItem Text="High [6-10]" Value="6-10" />
                                            <dx:ListEditItem Selected="true"  Text="All" Value="All" />
                                        </Items>
                                    </dx:ASPxComboBox>
                                    </td>
                                <tr>
                                    <td></td>
                                    <td>
                                        <dx:ASPxTextBox ID="txtSearch" runat="server" ClientInstanceName="txtSearch" CssClass="form-control input-sm" MaxLength="100" Native="true" NullText="Search By Name, Mobile, Email, Phone" Width="100%">
                                        </dx:ASPxTextBox>
                                    </td>
                                    <td class="alignRight">Show Upto</td>
                                    <td>
                                        <dx:ASPxSpinEdit ID="spinLeadUptoCount" ClientInstanceName="spinLeadUptoCount" Height="30px" MinValue="1" MaxValue="10000"  runat="server" Number="100">
                                        </dx:ASPxSpinEdit>
                                    </td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td>
                                        <table class="borderless">
                                            <tr>
                                                <td>
                                                    <button class="btn btn-primary" onclick="GridRefress(); return false" type="submit">
                                                        Search
                                                    </button>
                                                </td>
                                                <td>
                                                   <asp:Button ID="btnReset" runat="server" CssClass="btn btn-danger" Text="Reset" OnClick="btnReset_Click" />
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                                </table>
                            </ContentTemplate>
                        </asp:UpdatePanel>
                    </div>

                    <table style="width: 100%;">
						<tr>
							<td>
								<dx:ASPxGridView ID="grdLeadList" ClientInstanceName="grdLeadList"  KeyFieldName="LeadCd" runat="server" AutoGenerateColumns="False" Width="100%" Theme="BlackGlass" OnHtmlRowPrepared="grdLeadList_HtmlRowPrepared" OnHtmlRowCreated="grdLeadList_HtmlRowCreated" EnableTheming="True" CssClass="table " >
                                    <Settings  GridLines="Horizontal" ShowGroupedColumns="false"  ShowColumnHeaders="true" ShowGroupPanel="false" />
									<Columns>
										<dx:GridViewDataTextColumn Caption="Lead Details" Width="21%" CellStyle-VerticalAlign="Top">
											<DataItemTemplate>
                                                <table class="borderless" >
													<tr>
														<td>
                                                            <dx:ASPxLabel ID=lblDataName runat="server" Text='<%# Eval("Descr") %>'></dx:ASPxLabel> [<dx:ASPxLabel ID=lblLead runat="server" Text='<%# Eval("LeadCd") %>'></dx:ASPxLabel>]
														</td>
													</tr>
                                                    <tr>
														<td>
                                                            <dx:ASPxLabel ID=ShLabel1 runat="server" Text="Type"></dx:ASPxLabel>
                                                            :
                                                            <dx:ASPxLabel ID=ShLabel2 runat="server" Text='<%# Eval("TypeDescr") %>' Font-Size="Small"></dx:ASPxLabel>
														</td>
													</tr>
												</table>
											</DataItemTemplate>

                                        <CellStyle VerticalAlign="Top"></CellStyle>
										</dx:GridViewDataTextColumn>
										<dx:GridViewDataTextColumn Caption="Contact" Width="16%" CellStyle-VerticalAlign="Top">
											<DataItemTemplate>
												<table class="borderless" >
                                                    <tr id=trDataMobile runat="server">
														<td>
                                                            <dx:ASPxLabel ID=lblDataMobileText runat="server" Text="Mobile"></dx:ASPxLabel>
                                                            :
                                                            <dx:ASPxLabel ID=lblDataMobile runat="server" Text='<%# Eval("Mobile") %>' Font-Size="Small"></dx:ASPxLabel>                                                             
														</td>
													</tr>
                                                    <tr id=tr1 runat="server">
														<td>
                                                            <dx:ASPxLabel ID=ASPxLabel4 runat="server" Text="DND Status"></dx:ASPxLabel>
                                                            :
                                                            <dx:ASPxLabel ID=ASPxLabel5 runat="server" Text='<%# Eval("DndDescr") %>' Font-Size="Small"></dx:ASPxLabel>
														</td>
													</tr>
												</table>
											</DataItemTemplate>

                                        <CellStyle VerticalAlign="Top"></CellStyle>
										</dx:GridViewDataTextColumn>
                                        <dx:GridViewDataTextColumn Caption="Assignment"  VisibleIndex="3" Width="23%" CellStyle-VerticalAlign="Top">
                                            <DataItemTemplate>
                                                <table class="borderless" >
                                                    <tr>
														<td>
                                                            <dx:ASPxLabel ID=ASPxLabel7 runat="server" Text='<%# Eval("AssignDescr") %>'></dx:ASPxLabel> [ <dx:ASPxLabel ID=lblDataAssignByDate runat="server" Text='<%# Eval("AssignDate") %>'></dx:ASPxLabel> ]
														</td>
													</tr>
													<tr id=trDataAssignBy runat="server">
														<td>
                                                            <dx:ASPxLabel ID=lblDataAssignByText runat="server" Text="By"></dx:ASPxLabel>
                                                            :
                                                            <dx:ASPxLabel ID=lblDataAssignBy runat="server" Text='<%# Eval("AssignFrom") %>'></dx:ASPxLabel>
														</td>
													</tr>
                                                    <tr>
														<td runat="server" id="tdDataAssignTo">
                                                            <dx:ASPxLabel ID=lblDataAssignToText runat="server" Text="To"></dx:ASPxLabel>
                                                            :
                                                            <dx:ASPxLabel ID=lblDataAssignTo runat="server" Text='<%# Eval("AssignTo") %>'></dx:ASPxLabel>
														</td>
													</tr>
                                                </table>
                                            </DataItemTemplate>

                                        <CellStyle VerticalAlign="Top"></CellStyle>
                                        </dx:GridViewDataTextColumn>
                                        <dx:GridViewDataTextColumn Caption="Status"  VisibleIndex="3" Width="23%" CellStyle-VerticalAlign="Top">
                                            <DataItemTemplate>
                                                 <table class="borderless">
                                                    <tr>
                                                        <td>
                                                            <table runat="server" id="tblDataStatus" title='<%# Eval("Remarks") %>' >
                                                                <tr>
														            <td>
                                                                        <dx:ASPxLabel ID="lblDataStatus" runat="server"  Text='<%# Eval("StatusDescr") %>' ></dx:ASPxLabel> [<dx:ASPxLabel ID="lblStatusDate" runat="server"  Text='<%# Eval("HistDate") %>' ></dx:ASPxLabel>]
														            </td>
													            </tr>
                                                            </table>

                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxPanel ID="ASPxPanelDataCallBy" runat="server">
                                                                <PanelCollection>
                                                                    <dx:PanelContent runat="server">
                                                                        <dx:ASPxLabel ID="lblDataCallBytext" runat="server" Text="Staff">
                                                                        </dx:ASPxLabel>
                                                                        :
                                                                        <dx:ASPxLabel ID="lblDataCallBy" runat="server" Text='<%# Eval("EntityDescr") %>'>
                                                                        </dx:ASPxLabel>
                                                                    </dx:PanelContent>
                                                                </PanelCollection>
                                                            </dx:ASPxPanel>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </DataItemTemplate>

                                        <CellStyle VerticalAlign="Top"></CellStyle>
                                        </dx:GridViewDataTextColumn>
                                        <dx:GridViewDataTextColumn VisibleIndex="3" CellStyle-VerticalAlign="Top" Name="LeadCall">
                                            <DataItemTemplate>
                                                <div runat="server" id="divLeadCall">
                                                    <a href="#"  onclick="CallByMe('<%# Eval("LeadCd") %>', document.getElementById('hdnStaffCode').value, document.getElementById('hdnStaffType').value);" title="Click to Call!!" class="fa fa-phone-square" style="color:green; font-size:20px"></a>
                                                 </div>
                                            </DataItemTemplate>

                                        <CellStyle VerticalAlign="Top"></CellStyle>
                                        </dx:GridViewDataTextColumn>
                                        <dx:GridViewDataTextColumn VisibleIndex="3" CellStyle-VerticalAlign="Top">
                                            <DataItemTemplate>
                                                <div runat="server" id="divLeadBlock">
                                                    <a href='#'  onclick="LeadBlockByMe('<%# Eval("LeadCd") %>', document.getElementById('hdnStaffCode').value, document.getElementById('hdnStaffType').value);"  title="Lead Assign to SELF!!!" class="fa fa-caret-square-o-right" style="color:#3276B1;font-size:20px"></a>
                                                </div>
                                            </DataItemTemplate>

                                        <CellStyle VerticalAlign="Top"></CellStyle>
                                        </dx:GridViewDataTextColumn>
                                        <dx:GridViewDataTextColumn VisibleIndex="3" CellStyle-VerticalAlign="Top">
                                            <DataItemTemplate>
                                                <div runat="server" id="divLeadStatus">
                                                    <a href="#" " title="Update Lead Status" onclick="UpdateStatus('<%# Eval("LeadCd") %>', '<%= Convert.ToString(Session["connectSessionid"]) %>');" class="fa fa-pencil-square" style="color:green; font-size:20px"></i></a>
                                                </div>
                                            </DataItemTemplate>

                                        <CellStyle VerticalAlign="Top"></CellStyle>
                                        </dx:GridViewDataTextColumn>
                                        <dx:GridViewDataTextColumn VisibleIndex="3" CellStyle-VerticalAlign="Top">
                                            <DataItemTemplate>
                                                <div runat="server" id="divLeadAssign">
                                                    <a href='#'  class="fa fa-share-square-o"  title="Lead Assign!!!" onclick="AssignLead('<%# Eval("LeadCd") %>');" style="color:#3276B1; font-size:20px"></a>
                                                </div>
                                            </DataItemTemplate>

                                        <CellStyle VerticalAlign="Top"></CellStyle>
                                        </dx:GridViewDataTextColumn>
                                        <dx:GridViewDataTextColumn VisibleIndex="3" CellStyle-VerticalAlign="Top">
                                            <DataItemTemplate>
                                                <div runat="server" id="divEditUpdateLead">
                                                    <a href="#"  title="Edit and Update Lead" onclick="LeadAddEdit('EDIT','<%# Eval("LeadCd") %>');" class="fa fa-info-circle" style="color:green;font-size:20px"></a>
                                                </div>
                                            </DataItemTemplate>

                                        <CellStyle VerticalAlign="Top"></CellStyle>
                                        </dx:GridViewDataTextColumn>
                                        <dx:GridViewDataTextColumn VisibleIndex="3" CellStyle-VerticalAlign="Top">
                                            <DataItemTemplate>
                                                <div runat="server" id="divAddSchedule">
                                                    <a href='#'  title="Add Schedule!!!" class="fa fa-calendar-plus-o" style="color:#3276B1; font-size:18px" ></i></a>
                                                </div>
                                            </DataItemTemplate>

                                        <CellStyle VerticalAlign="Top"></CellStyle>
                                        </dx:GridViewDataTextColumn>
									</Columns>
                                    <Styles>
                                        <AlternatingRow BackColor="#EFEEF0">
                                        </AlternatingRow>
                                        <FocusedRow BackColor="LightYellow" ForeColor="Black">
                                        </FocusedRow>
                                        <CommandColumn Spacing="5px">
                                        </CommandColumn>
                                    </Styles>
                                    <SettingsBehavior AllowFocusedRow="True"/>
                                    <SettingsPager  Mode="ShowPager" PageSize="10"></SettingsPager>
									<SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
                                    <SettingsDetail ShowDetailRow="True" ExportMode="All" />
								    <Templates>
                                        <DetailRow>
                                            <div>
                                                <legend runat="server" id="legendLeadName"><%# Eval("Descr") %> [<%# Eval("LeadCd") %>]</legend>
                                                <table id="tblInput" class="table table-condensed " style="font-size:small; background-color:#FFFFFF">
                                                    <colgroup><col style="width:21%"/><col style="width:16.5%"/><col style="width:23.5%"/><col style="width:23.5%"/><col style="width:15.5%"/></colgroup>
                                                    <thead>
									                    <tr>
										                    <th>Lead Details</th>
										                    <th>Contact</th>
										                    <th>Assignment</th>
										                    <th>Status</th>
                                                            <th></th>
									                    </tr>
								                    </thead>
                                                    <tbody>
						                                <tr>
                                                            <td>
                                                              <table class="borderless" >
                                                                <tr>
														            <td>
                                                                        <dx:ASPxLabel ID=lblLeadText runat="server" Text="Lead"></dx:ASPxLabel>
                                                                        :
                                                                        <dx:ASPxLabel ID=lblLead runat="server" Text='<%# Eval("LeadCd") %>'></dx:ASPxLabel>
														            </td>
													            </tr>
													            <tr>
														            <td>
                                                                        <dx:ASPxLabel ID=lblNameText runat="server" Text="Name"></dx:ASPxLabel>
                                                                        :
                                                                        <dx:ASPxLabel ID=lblName runat="server" Text='<%# Eval("Descr") %>'></dx:ASPxLabel>
														            </td>
													            </tr>
                                                                <tr>
														            <td>
                                                                        <dx:ASPxLabel ID=ShLabel1 runat="server" Text="Lead Type"></dx:ASPxLabel>
                                                                        :
                                                                        <dx:ASPxLabel ID=ShLabel2 runat="server" Text='<%# Eval("TypeDescr") %>' Font-Size="Small"></dx:ASPxLabel>
														            </td>
													            </tr>
                                                                <tr>
														            <td>
                                                                        <dx:ASPxLabel ID=ASPxLabel2 runat="server" Text="Rank"></dx:ASPxLabel>
                                                                        :
                                                                        <dx:ASPxLabel ID=ASPxLabel9 runat="server" Text='<%# Eval("Rank") %>' Font-Size="Small"></dx:ASPxLabel>
														            </td>
													            </tr>
                                                                <tr runat="server" id="trSource">
														            <td>
                                                                        <dx:ASPxLabel ID=lblSourceText runat="server" Text="Source"></dx:ASPxLabel>
                                                                        :
                                                                        <dx:ASPxLabel ID=lblSource runat="server" Text='<%# Eval("SourceDescr") %>' Font-Size="Small"></dx:ASPxLabel>
														            </td>
													            </tr>
													            <tr runat="server" id="trleadtypeName">
														            <td>
                                                                        <dx:ASPxLabel ID=lblSourceIdNameText runat="server" ></dx:ASPxLabel>
                                                                        :
                                                                        <dx:ASPxLabel ID=lblSourceIdName runat="server" ></dx:ASPxLabel>
														            </td>
                                                                </tr>
                                                                <tr runat="server" id="trLastTrade">
                                                                    <td>
                                                                        <dx:ASPxLabel ID="ASPxLabel1" runat="server" Text='Last Trade'>
                                                                        </dx:ASPxLabel>
                                                                        : <i class="fa fa-inr" aria-hidden="true"></i>  
                                                                        <dx:ASPxLabel ID="lblTurnover" runat="server" Text='' ></dx:ASPxLabel> [ <dx:ASPxLabel ID="lblLastTrdt" runat="server" Text='' ></dx:ASPxLabel> ]             
                                                                    </td>
                                                                </tr>
                                                                <tr runat="server" id="trSegments">
                                                                    <td>
                                                                        <dx:ASPxLabel ID="ASPxLabel5" runat="server" Text='Segments'>
                                                                        </dx:ASPxLabel>
                                                                        :
                                                                        <dx:ASPxLabel ID="lblSegments" runat="server" Text=''></dx:ASPxLabel>             
                                                                    </td>
                                                                </tr>
												            </table>
                                                            </td>
                                                            <td>
                                                              <table class="borderless" >
                                                                <tr id=trMobile runat="server">
														            <td>
                                                                        <dx:ASPxLabel ID=lblMobileText runat="server" Text="Mobile"></dx:ASPxLabel>
                                                                        :
                                                                        <dx:ASPxLabel ID=lblMobile runat="server" Text='<%# Eval("Mobile") %>' Font-Size="Small"></dx:ASPxLabel>                                                             
														            </td>
													            </tr>
                                                                <tr id=tr1 runat="server">
														            <td>
                                                                        <dx:ASPxLabel ID=ASPxLabel4 runat="server" Text="DND Status"></dx:ASPxLabel>
                                                                        :
                                                                        <dx:ASPxLabel ID=ASPxLabel6 runat="server" Text='<%# Eval("DndDescr") %>' Font-Size="Small"></dx:ASPxLabel>
														            </td>
													            </tr>
													            <tr id=trPhone runat="server">
														            <td>
                                                                        <dx:ASPxLabel ID=lblPhoneText runat="server" Text="Office Tel"></dx:ASPxLabel>
                                                                        :
															            <dx:ASPxLabel ID=lblPhone runat="server" Text='<%# Eval("Phone") %>'></dx:ASPxLabel>
														            </td>
                                                                </tr>
													            <tr id=trEmail runat="server">
														            <td>
															            <dx:ASPxLabel ID=lblEmailText runat="server" Text="Email"></dx:ASPxLabel>
                                                                        :
                                                                        <a href="mailto:<%# Eval("Email") %>" class="alink" ><%# Eval("Email") %></a>
														            </td>
													            </tr>
													            <tr id=trWebSite runat="server">
														            <td>
                                                                        <dx:ASPxLabel ID=ShLabel4 runat="server" Text="Web Site"></dx:ASPxLabel>
                                                                        :
                                                                        <a href="http://<%# Eval("Website") %>" class="alink" target="_blank" ><%# Eval("Website") %></a>
														            </td>
													            </tr>
												            </table>
                                                            </td>
                                                            <td>
                                                              <table class="borderless" >
                                                                <tr>
														            <td>
                                                                        <dx:ASPxLabel ID=ASPxLabel7 runat="server" Text='<%# Eval("AssignDescr") %>'></dx:ASPxLabel> [ <dx:ASPxLabel ID=lblAssignByDate runat="server" Text='<%# Eval("AssignDate") %>'></dx:ASPxLabel> ]
														            </td>
													            </tr>
													            <tr id=trAssignBy runat="server">
														            <td>
                                                                        <dx:ASPxLabel ID=lblAssignByText runat="server" Text="By"></dx:ASPxLabel>
                                                                        :
                                                                        <dx:ASPxLabel ID=lblAssignBy runat="server" Text='System'></dx:ASPxLabel>
														            </td>
													            </tr>
                                                                <tr>
														            <td runat="server" id="tdAssignTo">
                                                                        <dx:ASPxLabel ID=lblAssignToText runat="server" Text="To"></dx:ASPxLabel>
                                                                        :
                                                                        <dx:ASPxLabel ID=lblAssignTo runat="server" Text='<%# Eval("AssignTo") %>'></dx:ASPxLabel>
														            </td>
													            </tr>
                                                            </table>
                                                            </td>
                                                            <td>
                                                              <table class="borderless">
                                                                <tr>
                                                                    <td>
                                                                        <table runat="server" id="tblStatus" title='<%# Eval("Remarks") %>' >
                                                                            <tr>
														                        <td>
                                                                                    <dx:ASPxLabel ID="lblStatus" runat="server"  Text='<%# Eval("StatusDescr") %>' ></dx:ASPxLabel> [<dx:ASPxLabel ID="lblStatusDate" runat="server"  Text='<%# Eval("HistDate") %>' ></dx:ASPxLabel>]
														                        </td>
													                        </tr>
                                                                        </table>

                                                                    </td>
                                                                </tr>
                                                                 <%--<tr id="trRemainderdt" runat="server">
                                                                    <td>
                                                                        <dx:ASPxLabel ID="ASPxLabel2" runat="server" Text="Remainder">
                                                                        </dx:ASPxLabel>
                                                                        :
                                                                        <dx:ASPxLabel ID="lblRemainderdt" runat="server" Text=''>
                                                                        </dx:ASPxLabel>
                                                                    </td>
                                                                </tr>--%>
                                                                <tr>
                                                                    <td>
                                                                        <dx:ASPxPanel ID="ASPxPanelCallBy" runat="server">
                                                                            <PanelCollection>
                                                                                <dx:PanelContent runat="server">
                                                                                    <dx:ASPxLabel ID="lblCallBytext" runat="server" Text="Staff">
                                                                                    </dx:ASPxLabel>
                                                                                    :
                                                                                    <dx:ASPxLabel ID="lblCallBy" runat="server" Text='System'>
                                                                                    </dx:ASPxLabel>
                                                                                </dx:PanelContent>
                                                                            </PanelCollection>
                                                                        </dx:ASPxPanel>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <dx:ASPxPanel ID="ASPxPanelInstruction" runat="server" >
                                                                            <PanelCollection>
                                                                                <dx:PanelContent runat="server">
                                                                                    <dx:ASPxLabel ID="ASPxLabel111" runat="server" Text="Note">
                                                                                    </dx:ASPxLabel>
                                                                                    :
                                                                                    <dx:ASPxLabel ID="lblInstruction" runat="server" Text='<%# Eval("Remarks") %>'>
                                                                                    </dx:ASPxLabel>
                                                                                    <br />
                                                                                 </dx:PanelContent>
                                                                            </PanelCollection>
                                                                        </dx:ASPxPanel>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                            </td>
                                                            <td></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </DetailRow>
                                    </Templates>
								</dx:ASPxGridView>
							</td>
						</tr>
					</table>
                    <asp:HiddenField ID="hdnStaffCode" runat="server" />
                    <asp:HiddenField ID="hdnStaffType" runat="server" />

				</form>
                <br />
               <%-- <button type="button" class="btn btn-success btn-lg" onclick="LeadAddEdit('ADD');" ><i class="fa fa-plus"></i> Add Lead</button>
                <button type="button" class="btn btn-primary btn-lg" onclick="LeadImport()"><i class="fa fa-upload"></i> Lead Import</button>
                <br />
                <br />
                <br />
                <br />--%>
	</div>

	<!--================================================== -->
		<!--
	<script src="../../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../../js/bootstrap/bootstrap.min.js"></script>
            -->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>


	<!-- StanSoft Script -->
	<script src="../../scripts/ssajax.js"></script>

	<script>
        
		function UpdateStatus(LeadCd, SessionId) {
		    var cTitle = "<i class=\"fa fa-pencil-square\"></i> Lead [" + LeadCd + "] Status Update";
			var opts = {
			    type: "OKCANCEL",
			    //type: "",
			    url: "dotnet/LeadManagement/LeadStatus.aspx?&sessionid=" + SessionId + "&LeadCd=" + LeadCd,
				title: cTitle,
				savecaption: "<i class=\"fa fa-floppy-o\"></i> Update",
				cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
				width: '50%',
			    height: 600,
			    reload: false,			// Reload the page [Grid] when a successful save happens
			    // We make sure that the RefreshGrid function is fired once we successfully update the data.
			    fnpostsuccess: function () { grdLeadList.Refresh(); },
				reloadwindow: window	// Rev 3.9.2016 : We will hit the parent function [see below] but want the
				// current window to be reloaded.
			};

			// Note that we are firing the script on the MAIN page and not in this iFrame.
			parent.urlFormDialog(opts);
		}

        
        function LeadAddEdit(mode, leadcd) {

		    cTitle = "<i class=\"fa fa-pencil-square-o\"></i> Edit and Update Lead";

            
		    if (mode == 'ADD')
		    {
		        var cTitle = "<i class=\"fa fa-plus\"></i> Add new Lead";
		        leadcd = '';
		    }

			var opts = {
			    type: "OKCANCEL",
			    //type: "",
			    //url: "dotnet/LeadManagement/LeadAddEdit.aspx?&sessionid=" + '<%= Request.QueryString["sessionid"] %>',
			    url: "dotnet/LeadManagement/LeadAddEdit.aspx?LeadCd=" + leadcd,
				title: cTitle,
				savecaption: "<i class=\"fa fa-floppy-o\"></i> Save",
				cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
				width: '60%',
			    height: 660,
			    reload: false,			// Reload the page [Grid] when a successful save happens
			    // We make sure that the RefreshGrid function is fired once we successfully update the data.
			    fnpostsuccess: function () { grdLeadList.Refresh(); },
				reloadwindow: window	// Rev 3.9.2016 : We will hit the parent function [see below] but want the
				// current window to be reloaded.
			};

			// Note that we are firing the script on the MAIN page and not in this iFrame.
			parent.urlFormDialog(opts);
		}

	    function LeadImport() {
	        var cTitle = "<i class=\"fa fa-upload\"></i> Lead Import";
			var opts = {
			    //type: "",
			    type: "OKCANCEL",
			    url: "dotnet/LeadManagement/LeadImport.aspx",
			    title: cTitle,
			    savecaption: "<i class=\"fa fa-check-circle\"></i> Ok",
			    cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
			    width: '60%',
				height: 660,
				reload: false,			// Reload the page [Grid] when a successful save happens
			    // We make sure that the RefreshGrid function is fired once we successfully update the data.
				fnpostsuccess: function () { grdLeadList.Refresh(); },
				reloadwindow: window	// Rev 3.9.2016 : We will hit the parent function [see below] but want the
				// current window to be reloaded.
			};

			// Note that we are firing the script on the MAIN page and not in this iFrame.
			parent.urlFormDialog(opts);
	    }

	    function BulkAssign() {
	        var cTitle = "<i class=\"fa fa-share-square-o\"></i> Bulk Assign";
			var opts = {
			    //type: "",
			    type: "OKCANCEL",
			    //url: "BulkAssign.aspx?&sessionid=" + '<%= Request.QueryString["sessionid"] %>',
			    url: "dotnet/LeadManagement/BulkAssign.aspx",
			    title: cTitle,
			    savecaption: "<i class=\"fa fa-check-circle\"></i> Ok",
			    cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
			    width: '70%',
				height: 660,
				reload: false,			// Reload the page [Grid] when a successful save happens
			    // We make sure that the RefreshGrid function is fired once we successfully update the data.
				fnpostsuccess: function () { grdLeadList.Refresh(); },
				reloadwindow: window	// Rev 3.9.2016 : We will hit the parent function [see below] but want the
				// current window to be reloaded.
			};

			// Note that we are firing the script on the MAIN page and not in this iFrame.
			parent.urlFormDialog(opts);
        }

		function AssignLead(LeadCd) {
		    var cTitle = "<i class=\"fa fa-share-square-o\"></i> Lead Assignment";
		    var opts = {
		        type: "OKCANCEL",
		        url: "dotnet/LeadManagement/AssignLead.aspx?LeadCd=" + LeadCd,
		        title: cTitle,
		        savecaption: "<i class=\"fa fa-share-square-o\"></i> Assign",
		        cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
		        width: '40%',
		        height: 550,
		        reload: false,			// Reload the page [Grid] when a successful save happens
		        // We make sure that the RefreshGrid function is fired once we successfully update the data.
		        fnpostsuccess: function () { grdLeadList.Refresh(); },
		        reloadwindow: window	// Rev 3.9.2016 : We will hit the parent function [see below] but want the
		        // current window to be reloaded.
		    };

		    // Note that we are firing the script on the MAIN page and not in this iFrame.
		    parent.urlFormDialog(opts);
		}

	    function LeadBlockByMe(leadcd, StaffCode, StaffType) {
	        var result = confirm("Do you want to Assigned this Lead to Self ?");

		    if (result) {
		        $.ajax({
		            type: "POST",
		            url: "LeadList.aspx/LeadBlockByMe",
		            data: "{cleadcd:'" + leadcd + "', cStaffCode:'" + StaffCode + "', cStaffType:'" + StaffType + "' }",
		            contentType: "application/json; charset=utf-8",
		            dataType: "json",
		            success: function (response) {
		                grdLeadList.Refresh();
		                if (response.d != '') { alert(response.d); }
		            },
		            failure: function (response) {
		                alert(response.d);
		            }
		        })
		    }
	    }

	    function CallByMe(LeadCd, StaffCode, StaffType) {
	        var result = confirm("Do you want to Call?");
	        if (result) {
	            $.ajax({
	                type: "POST",
	                url: "LeadList.aspx/CallByMe",
	                data: "{LeadCd:'" + LeadCd + "', StaffCode:'" + StaffCode + "', StaffType:'" + StaffType + "' }",
	                contentType: "application/json; charset=utf-8",
	                dataType: "json",
	                success: function (response) {
	                    grdLeadList.Refresh();
	                    if (response.d != '') { alert(response.d); }
	                },
	                failure: function (response) {
	                    alert(response.d);
	                }
	            })
	        }
	    }
	   
	    function ExpandAll() {
	        grdLeadList.ExpandAllDetailRows();
	        $("#btnHide").css('display', 'block');
	        $("#btnExpand").css('display', 'none');
	        
	    }

	    function HideAll() {
	        grdLeadList.CollapseAllDetailRows();
	        $("#btnHide").css('display', 'none');
	        $("#btnExpand").css('display', 'block');
	    }

       


	</script>
</body>
</html>
