﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="livetrades_sngl.aspx.cs" Inherits="Connect_DotNet.Mobile.livetrades_sngl" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>
    <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  
	<!-- Basic Styles -->

    <!--  Bootstrap v3.3.7 -->
	<!--
        <link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
    -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">

	<link href="../../css/font-awesome.min.css" rel="stylesheet" />
    

    <!-- Rev 13-08-2024 [Mithun/Abhay] - We upgraded the versions of Bootstrap and Jquery and used CDN 
		<script src="../../js/libs/jquery-2.1.1.min.js"></script>
	-->
	<script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
	
    <!-- BOOTSTRAP JS 
		<script src="../../js/bootstrap/bootstrap.min.js"></script>
	-->
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>

	<!-- StanSoft Script -->
	<script src="../../scripts/ssajax.js"></script>

    <script type="text/javascript">  
        $(document).ready(function () {  
            setLiveTrades();
            setInterval("setLiveTrades()", 10000);
        });
        

        function setLiveTrades() {
             $.ajax({  
                url: 'LiveTradesService.asmx/GetLiveTrades',  
                dataType: "json", 
                data: { subcd: '<%= cSubcd %>',lasttrdt: $('#hdnLastTRDT').val(),lasttrtime: $('#hdnLastTRDTIME').val() },
                method: 'post',  
                success: function (data) {  
                    var LiveTradesTable = $('#tblLiveTrades tbody');  
                    //LiveTradesTable.empty();  
                   // LiveTradesTable.prepend(data);  
                    //http://localhost/shrdbms/dotnet/mobile/livetrades.aspx?sessionid=5TX0OAKK506616

                    var liveTradesData = "";

                    $(data).each(function (index, trade) {  
                        liveTradesData += '<tr class="' + trade.RowClass + '">'+
                                            '<td><b><i class="fa fa-angle-double-right txt-color-darken"></i></b> ' + trade.TrdTime + ' </td>' +
                                            '<td>' + trade.TrdProduct + '</td>'+
                                            '<td>' + trade.TrdStatus + '</td>'+
                                            '<td>' + trade.TrdUnit + '</td>'+
                                            '<td><i class="fa fa-inr" aria-hidden="true"></i> ' + trade.TrdRate + '</td>'+
                                        '</tr>';  
                    }); 

                    if (liveTradesData != "") {
                        $("#hTradeRecordsStatus").hide();
                    }
                    else {
                        //No records found...
                        $("#hTradeRecordsStatus").html('<i class="fa fa-exclamation-triangle"  aria-hidden="true"></i> No records found...')
                        $("#hTradeRecordsStatus").css("color", "darkred");
                    }

                    LiveTradesTable.prepend(liveTradesData);
                    $('#hdnLastTRDT').val(data[0].TrdDate);
                    $('#hdnLastTRDTIME').val(data[0].TrdTime);

                    //alert(liveTradesData);
                    
                    
                    

                },  
                error: function (err) {  
                    //alert(err);  
                }  
             });

            //alert($('#tblLiveTrades tbody').html());
        }  

    </script>
    </head>
<body  class="bg-success">

    <form id="form1" runat="server">
           <div class="container">
            <div class="row">
	            <div class="col-xs-12" style="padding-left:0px;padding-right:0px">
                    <table id="tblLiveTrades" class="table table-striped" style="font-size:11px; border-bottom:groove">
                            <thead>
                               <tr>
                                <th colspan="5">
                                <h2><i class="fa fa-calendar" aria-hidden="true"></i> Trades done today  <button type="button" class="btn btn-sm btn-primary" onclick="setLiveTrades();"><i class="fa fa-refresh" aria-hidden="true"></i> Refress</button></h2>
                                    
                                </th>
                                
                              </tr>
                              <tr>
                                <th>Time</th>
                                <th>Product</th>
                                <th>Status</th>
                                <th>Unit</th>
                                <th>Rate <i class="fa fa-inr" aria-hidden="true"></i></th>
                              </tr>
                            </thead>
                    <tbody id="tbodyTrades">
                    </tbody>
                    </table>
                    <h4 style="text-align:center;" id="hTradeRecordsStatus"><i class="fa fa-spinner" aria-hidden="true"></i> Loading...</h4>
                    </div>
            </div>
              <input type="hidden" id="hdnLastTRDTIME" value="" name="hiddenLastTRDTIME">
              <input type="hidden" id="hdnLastTRDT" value="" name="hiddenLastTRDT">
              <input type="hidden" id="hdnSubcd" runat="server" value="" name="hiddenSubcd">

            </div>
    </form>
</body>
</html>
