﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Chat.aspx.cs" Inherits="Connect_DotNet.Chat" %>
<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<!DOCTYPE html>
<html>
<head runat="server">
	<title></title>

	<!-- Basic Styles 
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
        -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-skins.min.css">

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">

	<link href="../../css/your_style.css" rel="stylesheet" />
	<link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />

	<style>
		table { margin:1px }
		table td { padding:2px }
		.chatTextHeader { font-size:9px;color:gray }
		.chatText { font-size:13px }
		.chatFromBack { margin-right:15%;background-color:#deeaee;border-radius:10px;padding:5px 10px }
		.chatToBack { margin-left:15%;background-color:#e3eaa7;border-radius:10px;padding:5px 10px }
		.oldMsgLnk { margin:0 30%;background-color:dimgray;color:white;border-radius:20px;padding:5px 10px;text-align:center;cursor:pointer }

		#lblChatCaption { padding-left:2px }
	</style>
</head>
<body>
	<form id="frmChat" runat="server">
		<asp:ScriptManager ID=ScriptManager1 runat="server" EnablePageMethods=true></asp:ScriptManager>
		<asp:HiddenField ID=hdnLoginUserName runat="server" />
		<asp:HiddenField ID=hdnLoginUserId runat="server" />
		<asp:HiddenField ID=hdnLoginType runat="server" />
		<div class=container-fluid>
			<div class=row>
				<table>
					<tr>
						<td>
							<div style="height:400px;width:200px">
								<%--<div style="height:6%;padding:2px">
									<dx:ASPxLabel ID=lblChatCaption runat="server" Text=""></dx:ASPxLabel>
								</div>--%>
								<div style="height:100%;border:1px solid gray;background-color:white">
									<div style="height:90%">
										<asp:UpdatePanel ID=UpdatePanel1 runat="server">
											<ContentTemplate>
												<dx:ASPxListBox ID=lstOnline ClientInstanceName=lstOnline runat="server" ValueType="System.String"
													Width=97% Height=335px Theme=MetropolisBlue SelectionMode=Single Border-BorderStyle="None">
													<ItemImage Width=12px></ItemImage>
													<ItemStyle ForeColor=Black BackColor=White
														SelectedStyle-ForeColor=Black SelectedStyle-BackColor=White
														HoverStyle-ForeColor=Black HoverStyle-BackColor=LightGray Wrap=True 
														Font-Size="11px"/>
													<ClientSideEvents SelectedIndexChanged="function(s,e){
													lstOnline_SelectedIndexChanged(s,e);
												}" />
												</dx:ASPxListBox>
												<asp:Timer ID=tmrUpdateOnlineList Interval=1000 runat="server" OnTick=tmrUpdateOnlineList_Tick></asp:Timer>
											</ContentTemplate>
										</asp:UpdatePanel>
									</div>
									<div style="border-top:1px solid gray;height:11%">
										<dx:ASPxTextBox ID=txtSearch ClientInstanceName="txtSearch" runat="server" Width="97%"
											Border-BorderStyle="None" NullText="Search . . ." CssClass="form-control">
										</dx:ASPxTextBox>
									</div>
								</div>
							</div>
						</td>
						<td>
							<div style="height:400px;width:457px;border:1px solid gray;background-color:white">
								<div style="height:10%;border-bottom:1px solid gray;background-color:cornflowerblue;color:white">
									<h4 id=lblChatUserName style="height:100%;padding:5px 10px"></h4>
									<asp:Label ID=lblChatUserId runat="server" Style="display: none"></asp:Label>
								</div>
								<div id=divChat style="height:80%;overflow-y:auto"></div>
								<div style="border-top:1px solid gray;height:10%">
									<input id=txtMsg type=text style="width:100%;height:100%;border:none;padding:10px"
										placeholder="Type your message here . . ." class=form-control />
								</div>
							</div>
						</td>
					</tr>
				</table>
			</div>
		</div>
	</form>

	<!-- --------------- Scripts --------------- -->
	<!-- <script src="../../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../../js/bootstrap/bootstrap.min.js"></script>-->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>


	<script src="../scripts/jquery.signalR-2.2.2.min.js"></script>
	<script src='<%: ResolveClientUrl("~/signalr/hubs") %>'></script>

	<script>
		$(document).ready(function () {
			$("#txtMsg").focus();

			// -------------------------------------------------
			//if($("#hdnLoginType").val() == "CLIENT") {
			//	$.connection.hub.qs = {
			//		"userName": $("#hdnLoginUserName").val(),
			//		"userId": $("#hdnLoginUserId").val(),
			//		"userType": "CLIENT"
			//	};
			//}
			//else if($("#hdnLoginType").val() == "CRM") {
			//	$.connection.hub.qs = {
			//		"userName": $("#hdnLoginUserName").val(),
			//		"userId": $("#hdnLoginUserId").val(),
			//		"userType": "STAFF"
			//	};
			//}

			var userType = "";
			switch($("#hdnLoginType").val()) {
				case "CLIENT":
					userType = "Clients";
					break;
				case "BRANCH":
					userType = "Branches";
					break;
				case "CRM":
					userType = "CRMs";
					break;
				case "DEALER":
					userType = "Dealers";
					break;
				case "SUB-BROKER":
					userType = "APs";
					break;
				case "RM":
					userType = "RMs";
					break;
			}

			$.connection.hub.qs = {
				"userName": $("#hdnLoginUserName").val(),
				"userId": $("#hdnLoginUserId").val(),
				"userType": userType
			};
			// -------------------------------------------------

			var chatProxy = $.connection.chatHub;
			$.connection.hub.start().done(function () {
				$("#txtMsg").keyup(function (e) {
					if(e.which != 13) return;
					if($("#lblChatUserId").text() == "" || $("#txtMsg").val() == "") {
						$("#txtMsg").val("").focus();
						return;
					}

					// -------------------------------------------------
					//if($("#hdnLoginType").val() == "CLIENT") {
					//	chatProxy.server.sendMsgToParticular($("#hdnLoginUserId").val(),
					//		$("#lblChatUserId").text(), "STAFF", $("#txtMsg").val());
					//}
					//else if($("#hdnLoginType").val() == "CRM") {
					//	chatProxy.server.sendMsgToParticular($("#hdnLoginUserId").val(),
					//		$("#lblChatUserId").text(), "CLIENT", $("#txtMsg").val());
					//}

					chatProxy.server.sendMsgToParticular($("#hdnLoginUserId").val(),
							$("#lblChatUserId").text(), userType, $("#txtMsg").val());
					// -------------------------------------------------

					var dtTm = getCurrentDateTime();
					$("#divChat").append('<div style="margin:5px">' +
						'<div class=chatFromBack>' +
						'<i class=chatTextHeader>' +
						$("#hdnLoginUserName").val() + ' @ ' + dtTm +
						'</i><br><label class="control-label chatText">' +
						$("#txtMsg").val() + '</label></div></div>');

					$("#divChat").scrollTop($("#divChat").prop("scrollHeight"));
					$("#txtMsg").val("").focus();
				});
			}).fail(function (error) {
				console.log('SignalR Error: ' + error);
			});

			chatProxy.client.recieveMessage = function (formId, toId, dtTm, msg) {
				if($("#lblChatUserId").text() == formId) {
					$("#divChat").append('<div style="margin:5px">' +
						'<div class=chatToBack>' +
						'<i class=chatTextHeader>' +
						$('#lblChatUserName').text() + ' @ ' + dtTm +
						'</i><br><label class="control-label chatText">' +
						msg + '</label></div></div>');

					$("#divChat").scrollTop($("#divChat").prop("scrollHeight"));
				}
				
				var divChatServer = window.parent.document.getElementById("divChatServer");
				if(divChatServer.style.display == "none") {
					var lblChatCount = window.parent.document.getElementById("lblChatCount");
					lblChatCount.innerText = +lblChatCount.innerText + 1;

					var icnChat = window.parent.document.getElementById("icnChat");
					icnChat.style.color = "dodgerblue";

					window.parent.bounceEffect("icnChat");
				}
			}
		});

		function lstOnline_SelectedIndexChanged(s, e) {
			if(s.GetSelectedItem().value != "") {
				$("#lblChatUserName").text(s.GetSelectedItem().text.split("[")[0]);
				$("#lblChatUserId").text(s.GetSelectedItem().value);

				$("#divChat").empty();
				GetAllMsgs($("#hdnLoginUserId").val(), $("#lblChatUserId").text(), 0);
				//$("#divChat").scrollTop($("#divChat").prop("scrollHeight"));
			}
		}

		function getCurrentDateTime() {
			var dt = new Date();
			var date = pad(dt.getDate(), 2) + "/" + pad((dt.getMonth() + 1), 2) + "/" + dt.getFullYear();
			var time = pad(dt.getHours(), 2) + ":" + pad(dt.getMinutes(), 2) + ":" + pad(dt.getSeconds(), 2);
			return date + " " + time;
		}

		function pad(number, length) {
			var str = '' + number;
			while(str.length < length) {
				str = '0' + str;
			}
			return str;
		}

		function GetAllMsgs(fromId, toId, msgCount) {
			PageMethods.GetAllMessages(fromId, toId, msgCount, OnSuccess, OnError);

			function OnSuccess(response) {
				$("#divChat").append(response);
				$("#divChat").scrollTop($("#divChat").prop("scrollHeight"));
			}

			function OnError(response) {
				alert("WebMethod GetPreviousMessages CallBack Error: " + response);
			}
		}

		var msgCount = 0;
		function OldMsgs_OnClick()
		{
			var currentScrollHeight = $("#divChat").scrollTop();
			if(currentScrollHeight == 0) {
				msgCount += 10;
				$("#divChat").empty();
				GetAllMsgs($("#hdnLoginUserId").val(), $("#lblChatUserId").text(), msgCount);
			}
		}

	</script>
	<!-- --------------------------------------- -->
</body>
</html>
