﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="IPV.aspx.cs" Inherits="Connect_DotNet.ReKYC.IPV" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>Webcam Verification (IPV)</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link href="../eKyc/css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="../eKyc/js/ekyc.js"></script>    

    <script>
        var videoStream;
        var mediaRecorder;
        var recordedBlobs = [];

        async function startPreview() {
            try {
                const stream = await navigator.mediaDevices.getUserMedia({ video: true, audio: true });
                document.getElementById("videoPreview").srcObject = stream;
                mediaRecorder = new MediaRecorder(stream);
                mediaRecorder.ondataavailable = handleDataAvailable;
                mediaRecorder.onstop = handleStop;
                //startRecordButton.disabled = false;
            } catch (error) {
                console.error('Error accessing webcam:', error);
            }
        }


        function startRecording() {

            getLocation();
            //alert(navigator);
            //alert(navigator.mediaDevices);
            document.getElementById("divContinueNext").style = "display:none";
            document.getElementById("countdown").innerHTML = "";
            document.getElementById("divStartRecording").style = "display:none";
            document.getElementById("divRecording").style = "display:block; color:darkgreen";
            
            

            navigator.mediaDevices.getUserMedia({ video: true, audio: true })
                .then(function (stream) {
                    videoStream = stream;
                    var videoElement = document.getElementById("videoPreview");
                    videoElement.srcObject = stream;
                    mediaRecorder = new MediaRecorder(stream);
                    mediaRecorder.ondataavailable = handleDataAvailable;
                    mediaRecorder.start();
                })
                .catch(function (error) {
                    alert(error);
                    console.log("Error accessing media devices: " + error);
                });

            updateCountdown();
        }

        function stopRecording() {
            mediaRecorder.stop();
            videoStream.getTracks().forEach(function (track) {
                track.stop();
            });
        }

        function handleDataAvailable(event) {
            if (event.data && event.data.size > 0) {
                recordedBlobs.push(event.data);
            }
        }

        function downloadRecording() {
            
            var blob = new Blob(recordedBlobs, { type: 'video/webm' });
            var url = window.URL.createObjectURL(blob);
            var a = document.createElement('a');
            a.style.display = 'none';
            a.href = url;
            a.download = 'recorded-video.webm';
            document.body.appendChild(a);
            a.click();
            setTimeout(function () {
                document.body.removeChild(a);
                window.URL.revokeObjectURL(url);
            }, 100);
        }

        function handleStop() {
            stopRecording();

            document.getElementById("divContinueNext").style = "display:none";
            showModalLoading();

            const locationandtime = document.getElementById("hdnLatitude").value + "####" + document.getElementById("hdnLongitude").value + "####" + document.getElementById("hdnTimestamp").value;
            setTimeout(function () {
                const blob = new Blob(recordedBlobs, { type: 'video/webm' });
                const formData = new FormData();

                formData.append('video', blob, 'recorded_video.webm');
                formData.append('locationandtime', locationandtime);

                // Send the video data to the server using an HTTP POST request
                fetch(window.location.href, {
                    method: 'POST',
                    body: formData,
                })
                    .then(function (response) {
                        if (!response.ok) {
                            alert("Network response was not ok");
                        }
                        return response.text();
                    })
                    .then(function (responseText) {
                        //alert(responseText);
                        // You can work with the responseText here
                        // Video data successfully uploaded

                        if (responseText == "Success") {
                            window.location.replace(window.location.href + "?res=1");
                        }
                        else {
                            document.getElementById("divStartRecording").style = "display:block";
                            alertModal("Error", responseText);
                        }

                        

                    })
                    .catch(function (error) {
                        alert("Fetch error: "+ error);
                        //console.error("Fetch error:", error);
                    });

                //.then(response => {
                //    if (response.ok) {
                //        alert(response.text());
                //        // Video data successfully uploaded
                //        $('#modalLoading').modal('hide');
                //        //window.location.replace(window.location.href+"?res=1");

                //    } else {
                //        // Handle error
                //        $('#modalLoading').modal('hide');
                //    }
                //})
                //.catch(error => {
                //    // Handle error
                //});
            }, 500);


        }


        function reStartRecording() {
            stopRecording();
            setTimeout(function () {
                startRecording();
            }, 100);
        }

    </script>
</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }


    </style>
     <script>

         window.onload = function () {
             startPreview();
             getLocation();
         }

         function getLocation() {
             if (navigator.geolocation) {
                 navigator.geolocation.getCurrentPosition(showPosition);
             } else {
                 document.getElementById("divLocation").innerHTML = "Geolocation is not supported by this browser.";
             }
         }

         function showPosition(position) {

             let date = new Date(); // object of the date class
             //timestamp = date.getTime(); // To get the timestamp
             //timestamp = date.toString();
             let timestamp = ("0" + date.getDate()).slice(-2) + '-' + ("0" + (date.getMonth() + 1)).slice(-2) + '-' + date.getFullYear() + ' ' + date.toString().replace(/^.+(\d{2}:\d{2}:\d{2}.+)\(.+$/,"$1");
             
             //alert(date);
             //alert(date.toUTCString());
             //alert(date.toString());
             //alert(date.toISOString());
             

             document.getElementById("divLocation").innerHTML = "Latitude: " + position.coords.latitude +
                 ", Longitude: " + position.coords.longitude +
                 ", Timestamp: " + timestamp;


             document.getElementById("hdnLatitude").value = position.coords.latitude;
             document.getElementById("hdnLongitude").value = position.coords.longitude;
             document.getElementById("hdnTimestamp").value = timestamp;


         }
        

         function sendIPVlink(value) {

             document.getElementById('hdnBtnContinueClicked').value = value;

             showModalLoading();
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();

         }

         function alertModalLinkSend(title, body) {

             if (title == "Link send successfully") {
                 document.getElementById("divContinueIfDone").style = "display:block";
                 document.getElementById("divStartRecording").style = "display:none";
                 document.getElementById("divContinueNext").style = "display:none";
             }

             alertModal(title, body);
         }
         

    </script>

    <script>
    // Set the target number to count down from
    let targetNumber = 0;

    // Function to update the countdown number
        function updateCountdown() {
            const countdownElement = document.getElementById("countdown");
            countdownElement.innerHTML = targetNumber;

            // If the countdown is over, display a message
            if (targetNumber === 16) {

                //countdownElement.innerHTML = "Countdown expired!";
                document.getElementById("divContinueNext").style = "display:block";
                document.getElementById("divRecording").style = "display:none";
                stopRecording();

                targetNumber = 0;

            } else {
                targetNumber++;
                setTimeout(updateCountdown, 1000); // Update every second
            }
        }

  </script>

    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
              <div class="container h-100">
                  <div class="row">
                    <div class="col-md-3">
                        <center>
                        <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px; padding-top:10px">
                        </center>
                    </div>
                    <div class="col-md-9">
                        <h2 class="lblTopHeader"><i class="fa fa-video-camera" aria-hidden="true"></i> <i class="fa fa-user" aria-hidden="true"></i> Webcam Verification (IPV) </h2>
                        <p>In-Person Verification (IPV) is the process of verifying that the person reKYC the account and the documents submitted are of the same person</p>
                    </div>
                  </div>
                  <div class="progress">
                    <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                    </div>
                  </div>
                  <div class="row d-flex justify-content-center align-items-center">
                  <div class="col-lg-12 col-xl-11">
                    <div class="card text-black" style="border-radius: 25px;">
                      <div class="card-body p-md-5">
                        <div class="row justify-content-center">
                          <div class="col-md-12">
                              <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                                <ContentTemplate>
                                  <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                  </div>
                                 </ContentTemplate>
                              </asp:UpdatePanel>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div class="row">
                                          <div class="col-md-6">
                                              <h4>Generate a random number code from System</h4>
                                              <h1>
                                                  Code: <span id="spanNumberCode" style="font-weight:bolder;" runat="server"></span>
                                              </h1>
                                              <p>
                                                  You need to write the this system generated code <b><%=spanNumberCode.InnerHtml %></b> on a piece of paper and hold it in
                                                    front on the camera Ensure that the face and code are clearly visible. Like below sample: 72927
                                              </p>
                                              <p style="padding-left:20px">
                                                  <img src="../ekyc/images/sampleIPV.png" class="img-rounded" alt="Cinque Terre" width="140"> 
                                              </p>
                                              <p>
                                                  Alternatively you can <b>speak</b> this code <span style="font-weight:bold; font-size:18px"><%=spanNumberCode.InnerHtml %></span> front on the camera, and then shake your hand. Ensure that the face clearly visible and your voice should be audible.
                                              </p>
                                              <p style="font-size:smaller; margin-top:10px">
                                                    If you do not have a camera on this device, there is no need to worry. Just click on the
                                                    "I Don't have a Camera" button and I will send you a link on your phone using WhatsApp, SMS and
                                                    even eMail. Just click the link on your phone and I will use your phone's camera to capture
                                                    your pic. Make sure to have a live Internet connection on your phone.
                                                </p>
                                              <center>
                                                <a class="btn btn-md btn-danger" href="javascript:sendIPVlink('Send');" >I Don't have a Camera</a>
                                              </center>
                                                <br />
                                                <br />
                                          </div>
                                          <div class="col-md-6">
                                              <input type="hidden" id="hdnLatitude" name="hdnLatitude" runat="server" value="">
                                              <input type="hidden" id="hdnLongitude" name="hdnLongitude" runat="server" value="">
                                              <input type="hidden" id="hdnTimestamp" name="hdnTimestamp" runat="server" value="">
                                              <p id="divLocation"></p>
                                              <div style="text-align:center; padding-top:10px">
                                                  <video id="videoPreview" width="99%"  autoplay muted></video>
                                                  <h4>Code: <b><%=spanNumberCode.InnerHtml %></b></h4>
                                                <br />
                                              <h1 id="divRecording" style="color:darkgreen; display:none"><span style="font-size:25px;">Recording..</span> <span id="countdown"></span>/15</h1>
                                              <div id="divStartRecording">
                                                  <a class="btn btn-primary btn-lg" id="btnStartRecording" onclick="startRecording();"><i class="fa fa-video-camera" aria-hidden="true"></i> Start Recording</a>
                                              </div>
                                              <div id="divContinueNext" style="display:none">
                                                  <a class="btn btn-success btn-lg" id="btnContinueNext" runat="server" onclick="handleStop();" style="margin-top:5px"><i class="fa fa-check" aria-hidden="true"></i> Save and Continue</a>
                                                  <a class="btn btn-danger btn-lg" id="btnReStartRecording"  onclick="reStartRecording();" style="margin-top:5px"><i class="fa fa-repeat" aria-hidden="true"></i> Restart <i class="fa fa-video-camera" aria-hidden="true"></i></a>
                                              </div>
                                              <div id="divContinueIfDone" style="display:none">
                                                  <a class="btn btn-success btn-lg" id="btnContinueIfDone" onclick="sendIPVlink('Done');" style="margin-top:5px"><i class="fa fa-check" aria-hidden="true"></i> Continue</a>
                                              </div>
                                              </div>
                                              
                                          </div>
                                      </div>
                                  </div>
                                  <hr />
                                   <h4>Go to previous step </h4> 
                                 <ul class="list-inline">
                                     <li><a href="ConfirmDetails.aspx?cnfmrset=1" id="hlinkChooseParameters" runat="server"><i class="fa fa-solid fa-list-check" aria-hidden="true"></i> Reset Modifications</a></li>
                                    <li><a href="contact.aspx" id="hlinkContact" runat="server"><i class="fas fa-envelope fa-lg me-3 fa-fw" aria-hidden="true"></i> Contact</a></li>
                                    <li><a href="DigiLockerKYC.aspx" id="hlinkDigiLocker" runat="server"><i class="fa fa-cloud-download" aria-hidden="true"></i> DigiLocker</a></li>
                                    <li><a href="manuallyProcessing.aspx" id="hlinkManuallyProcessing" runat="server"><i class="fa fa-id-card" aria-hidden="true"></i> <span id="spanManuallyProcessing" runat="server">Address|DOB</span> </a></li>
                                    <li><a href="takePhoto.aspx" id="hlinkCapturePhoto" runat="server"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                    <li><a href="incomeProfile.aspx" id="hlinkIncomeProfile" runat="server"><i class="fa fa-inr" aria-hidden="true"></i> Income Profile</a></li>
                                    <li><a href="TradingPreference.aspx" id="hlinkTradingPreference" runat="server"><i class="fa fa-exchange" aria-hidden="true"></i> Trading Preference</a></li>
                                    <li><a href="BankDetails.aspx" id="hlinkBankDetails" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Bank</a></li>
                                    <li><a href="Nomination.aspx" id="hlinkNomination" runat="server"><i class="fa fa-users" aria-hidden="true"></i> Nomination</a></li>
                                    <li><a href="dematAccount.aspx" id="hlinkDematAccount" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Demat Account</a></li>
                                    <li><a href="AuthorizedRepresentative.aspx" id="hlinkAuthorizedRepresentative" runat="server"><i class="fa fa-user-circle" aria-hidden="true"></i> Authorized Representative</a></li>
                                    <li><a href="uploadDocuments.aspx" id="hlinkUploadDocuments" runat="server"><i class="fa fa-upload" aria-hidden="true"></i> Upload documents</a></li>
                                </ul>
                             </div>
                           </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
        </section>
    </form>


</body>
</html>