﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Login.aspx.cs" Inherits="Connect_DotNet.ReKYC.Login" %>

<!--     
eKyc System MAIN Entrance Page
-->

<!DOCTYPE html>
<html>
<head runat="server">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login for ReKYC</title>

     <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
           /* background-color: #f8f9fa; */
           background-color: #309FD3;
        }
        .login-container {
            max-width: 500px;
            margin: 100px auto;
            padding: 30px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .login-header {
            text-align: center;
            margin-bottom: 30px;
        }
        .login-header img {
            height: 60px;
            margin-bottom: 15px;
        }
        .login-header h2 {
            color: #2c3e50;
            font-weight: 600;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-control {
            height: 45px;
            border-radius: 5px;
        }
        .btn-login {
            background-color: #3498db;
            border: none;
            color: white;
            height: 45px;
            border-radius: 5px;
            font-weight: 600;
            width: 100%;
        }
        .btn-login:hover {
            background-color: #2980b9;
        }
        .step {
            display: none;
        }
        .step.active {
            display: block;
        }
        .otp-input {
            letter-spacing: 30px;
            font-size: 24px;
            text-align: center;
            padding-left: 15px;
        }
        .resend-otp {
            cursor: pointer;
            color: #3498db;
        }
        .progress {
            height: 8px;
            margin-bottom: 30px;
        }
        .progress-bar {
            background-color: #3498db;
        }
    </style>

</head>
<body>

    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <div class="container">
            <div class="login-container">
                <div class="login-header">
                    <img src="../../custom/your_logo_large.png" alt="REKYC Logo">
                    <h2>ReKYC Portal Login</h2>
                </div>

                <div class="progress">
                    <div class="progress-bar" role="progressbar" style="width: 33%;" aria-valuenow="33" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
                 <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                    <ContentTemplate>
                        
                        <div style="display:none">
                            <asp:Button ID="btnContinueClicked" runat="server" Text="" OnClick="btnContinueClicked_Click" />     
                            <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                            <input type="hidden" id="hdnPassword" name="hdnPassword" runat="server" value="">
                        </div>
                        <div id="divMain" runat="server">
                            <!-- Step 1: UCC/PAN and Password -->
                            <div id="step1" class="step active">
                                <div class="text-center mb-4">
                                    <h5>Welcome Back!</h5>
                                    <p>To update your KYC details or activate your account, please log in using your UCC or PAN</p>
                                </div>
                                <div id="loginForm">
                                    <div class="form-group">
                                        <label for="txtUserId">UCC/PAN Card Number</label>
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fas fa-id-card"></i></span>
                                            <input type="text" runat="server" class="form-control" id="txtUserId" placeholder="Enter UCC or PAN Card Number">
                                        </div>
                                    </div>
                                    <div id="divPassword" runat="server" style="display:none">
                                        <div class="form-group">
                                            <label for="txtPassword">Password</label>
                                            <div class="input-group">
                                                <span class="input-group-text"><i class="fas fa-lock"></i></span>
                                                <input type="password" runat="server" class="form-control" id="txtPassword" placeholder="Enter Password" >
                                                <span class="input-group-text"><i class="fas fa-eye" onclick="TogglePassword()" id="togglePassword"></i></span>
                                            </div>
                                        </div>
                                        <div class="form-group text-end">
                                            <a data-bs-toggle="modal" data-bs-target="#forgotPasswordModal" class="text-decoration-none">Forgot Password?</a>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-login" id="btnStep1" onclick="ContinueNextStep(1)">Continue</button>
                                </div>
                            </div>
                            <!-- Step 2: OTP Verification -->
                            <div id="step2" class="step">
                                <div class="text-center mb-4">
                                    <h5>Mobile/Email OTP Verification</h5>
                                    <p>We've sent a 6-digit OTP to your registered mobile number <span id="spanMobileNumber" runat="server"></span> and your email address <span id="spanEmailId" runat="server"></span></p>
                                </div>
                                <div id="otpForm">
                                    <div class="form-group text-center">
                                        <input type="text" runat="server" class="form-control otp-input" id="txtOTP" maxlength="6" placeholder="______" >
                                    </div>
                                    <span id="spanDebugOTP" runat="server" style="display:none"></span>
                                    <div class="form-group text-center mt-3">
                                        <p>Didn't receive OTP? <span class="resend-otp" id="resendOtp" onclick="ContinueNextStep(3)">Resend OTP</span></p>
                                    </div>
                                    <button type="button" class="btn btn-login" id="btnVerifyOtp" onclick="ContinueNextStep(2)">Verify & Login</button>
                                    <button type="button" class="btn btn-outline-secondary mt-2" id="btnBackToLogin" onclick="location.reload()">Back to Login</button>
                                </div>
                            </div>

                            <!-- Step 3: Success Message -->
                            <div id="step3" class="step">
                                <div class="text-center">
                                    <div class="mb-4">
                                        <i class="fas fa-check-circle" style="font-size: 60px; color: #2ecc71;"></i>
                                    </div>
                                    <h4 class="mb-3">Login Successful!</h4>
                                    <p>You are being redirected to your dashboard...</p>
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                </div>
                            </div>

                        </div>
                           <div id="divErrorMsg" runat="server" style="margin-top:20px; height: 100%; display:none; width: 100%; text-align: center;">
                                <div class="alert alert-danger" role="alert">
				                    <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span> <span id="spanError" runat="server"></span>
			                    </div>
		                    </div>

                    </ContentTemplate>
                </asp:UpdatePanel>
            </div>
        </div>

    </form>

<!-- Modal -->
<div class="modal fade" id="forgotPasswordModal" tabindex="-1" aria-labelledby="forgotPasswordLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="modal-title" id="forgotPasswordLabel">Forgot Password</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <!-- Modal Body -->
      <div class="modal-body">
        If you've forgotten your password and wish to retrieve it, please visit the 
        <strong>Backoffice login page</strong> and click on 
        <strong>"Forgot Password"</strong> to initiate the recovery process.
      </div>

      <!-- Modal Footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>


    <div class="row" style="margin:10px">
        <div class="col-sm-6" >

        </div>
        <div class="col-sm-6 poweredBy" style="text-align:right;">
            <span style="font-size:small;text-align:right">Powered by</span></br>
		    <a href="http://www.stansoftware.com">
			    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
				    </a>
	    </div>
    </div>
       <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/crypto-js/4.1.1/crypto-js.min.js"></script>
    
    <script>

        function simulateCredentialValidation() {

            // Simulate API call delay
            // Update UI for OTP step
            $('.step').removeClass('active');
            $('#step2').addClass('active');
            $('.progress-bar').css('width', '66%');

            // Focus OTP field
            $('#txtOTP').focus();

            // Reset button
            $('#btnStep1').html('Continue');

            setTimeout(function () {

                alert('OTP has been sent successfully to your mobile and email');

            }, 1500);

        }
    

        function ContinueNextStep(stepno) {

            if (stepno == 1) {

                $('#txtOTP').val('');

                if ($('#hdnPassword').val() != "" && $('#txtPassword').val() == "") {
                    $('#txtPassword').val($('#hdnPassword').val());
                }

                const userId = $('#txtUserId').val();
                const password = $('#txtPassword').val();

                // Simple validation

                if (!userId) {
                    alert('Please enter UCC/PAN');
                    return;
                }

                if (!password) {
                    alert('Please enter Password');
                    return;
                }

                // Show loading state
                $('#btnStep1').html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Validating...');
                document.getElementById('hdnBtnContinueClicked').value = "Validating";

                var cipherPassword = CryptoJS.AES.encrypt(password, "mithuntest").toString();

                document.getElementById('txtPassword').value = cipherPassword;

                document.getElementById('<%= btnContinueClicked.UniqueID %>').click();

            }

            else if (stepno == 3) {

                $('#txtOTP').val('');

                // Show loading state
                $('#btnStep2').html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> resending OTP...');
                document.getElementById('hdnBtnContinueClicked').value = "reSend";
                document.getElementById('<%= btnContinueClicked.UniqueID %>').click();

            }

            else if (stepno == 2) {
                const otp = $('#txtOTP').val();

                if (otp.length !== 6) {
                    alert('Please enter a valid 6-digit OTP');
                    return;
                }

                // Show loading state
                $('#btnVerifyOtp').html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Verifying...');

                document.getElementById('hdnBtnContinueClicked').value = "ValidateOTP";
                document.getElementById('<%= btnContinueClicked.UniqueID %>').click();
            }
        }

        // Toggle password visibility
        function TogglePassword() {
              const password = $('#txtPassword');
                const type = password.attr('type') === 'password' ? 'text' : 'password';
                password.attr('type', type);
                $(this).toggleClass('fa-eye fa-eye-slash');
        }

        //$(document).ready(function() {
        //    // Toggle password visibility
        //    $('#togglePassword').click(function() {
        //        const password = $('#txtPassword');
        //        const type = password.attr('type') === 'password' ? 'text' : 'password';
        //        password.attr('type', type);
        //        $(this).toggleClass('fa-eye fa-eye-slash');
        //    });


            //// Step 1: Validate credentials and proceed to OTP
            //$('#btnStep1').click(function() {
            //    const userId = $('#txtUserId').val();
            //    const password = $('#password').val();
                
            //    // Simple validation
            //    if (!userId || !password) {
            //        alert('Please enter both UCC/PAN and Password');
            //        return;
            //    }


            //    // Here you would typically make an AJAX call to validate credentials
            //    // For demo, we'll simulate a successful validation
            //    //simulateCredentialValidation(userId, password);

            //});

            //// Step 2: Verify OTP
            //$('#btnVerifyOtp').click(function() {
            //    const otp = $('#txtOTP').val();
                
            //    if (otp.length !== 6) {
            //        alert('Please enter a valid 6-digit OTP');
            //        return;
            //    }

            //    // Here you would typically make an AJAX call to verify OTP
            //    // For demo, we'll simulate a successful verification
            //    simulateOtpVerification(otp);
            //});

            //// Resend OTP
            //$('#resendOtp').click(function() {
            //    // Simulate OTP resend
            //    alert('New OTP has been sent to your mobile number');
            //    $('#txtOTP').val('');
            //});

            //// Back to login
            //$('#btnBackToLogin').click(function() {
            //    $('.step').removeClass('active');
            //    $('#step1').addClass('active');
            //    $('.progress-bar').css('width', '33%');
            //});


        //    // Simulate credential validation (replace with actual AJAX call)
        //    function simulateCredentialValidation(userId, password) {
        //        // Show loading state
        //        $('#btnStep1').html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Validating...');
                
        //        // Simulate API call delay
        //        setTimeout(function() {
        //            // For demo purposes, we'll assume credentials are valid
        //            // In real implementation, check server response
        //            const isValid = true;
                    
        //            if (isValid) {
        //                // Update UI for OTP step
        //                $('.step').removeClass('active');
        //                $('#step2').addClass('active');
        //                $('.progress-bar').css('width', '66%');
                        
        //                // Focus OTP field
        //                $('#txtOTP').focus();
        //            } else {
        //                alert('Invalid UCC/PAN or Password. Please try again.');
        //            }
                    
        //            // Reset button
        //            $('#btnStep1').html('Continue');

        //        }, 1500);
        //    }

        //    // Simulate OTP verification (replace with actual AJAX call)
        //    function simulateOtpVerification(otp) {
        //        // Show loading state
        //        $('#btnVerifyOtp').html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Verifying...');
                
        //        // Simulate API call delay
        //        setTimeout(function() {
        //            // For demo purposes, we'll assume OTP is valid
        //            // In real implementation, check server response
        //            const isValid = true;
                    
        //            if (isValid) {
        //                // Update UI for success step
        //                $('.step').removeClass('active');
        //                $('#step3').addClass('active');
        //                $('.progress-bar').css('width', '100%');
                        
        //                // Simulate redirect to dashboard
        //                setTimeout(function() {
        //                    window.location.href = 'dashboard.html';
        //                }, 2000);
        //            } else {
        //                alert('Invalid OTP. Please try again.');
        //            }
                    
        //            // Reset button
        //            $('#btnVerifyOtp').html('Verify & Login');
        //        }, 1500);
        //    }
        //});
    </script>
</body>
</html>
