﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="NominationNew.aspx.cs" Inherits="Connect_DotNet.ReKYC.NominationNew" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<!DOCTYPE html>

<html>
<head runat="server">
  <title>Add a Bank account</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
    <link href="../eKyc/css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
    <script src="../eKyc/js/ekyc.js"></script>
      
</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }
    </style>
     <script>

         function togglePasswordAndValidate(targetId, currentInput) {
             var targetInput = document.getElementById(targetId);

             // Allow only numbers
             currentInput.value = currentInput.value.replace(/\D/g, '');

             currentInput.type = currentInput.value.length > 0 ? "text" : "password";

             // Hide the other field if input is not empty
             targetInput.type = currentInput.value.length > 0 ? "password" : "text";

             if (currentInput.value.length > currentInput.maxLength)
                 currentInput.value = currentInput.value.slice(0, currentInput.maxLength);
         }

          function disableCopyPaste(event) {
            event.preventDefault();
            alert("Copy-paste is disabled for this field.");
         }

         function viwNomDetails(nomineeNo, descr, relation, percent, mobile) {
             alert(nomineeNo + ", " + descr + ", " + relation + ", " + percent + ", " + mobile);
         }

         function addBankPopup() {

             document.getElementById('AddEditBankModalHeader').innerHTML = "<i class=\"fa fa-university\" aria-hidden=\"true\"></i> Add Bank";

             document.getElementById('selectBankType').value = "Secondary";

             if (document.getElementById('cmbBanks') != null && document.getElementById('txtBankIFSC') != "") {
                 setSelectedValue(document.getElementById('cmbBanks'), "");
             }

             document.getElementById('txtBankAcName').value = "";
             document.getElementById('txtBankIFSC').value = "";
             document.getElementById('txtBankAccountNumber').value = "";
             document.getElementById('txtConfirmBankAccountNumber').value = "";
             document.getElementById("spanBankVerificationAsyncFileUpload").innerHTML = "";

             //document.getElementById('divAddEditBankModalFooter').innerHTML =
             //    "<button type=\"button\" class=\"btn btn-primary\" onclick=\"AddRequest('Add Bank')\">Add Request</button>" +
             //    "<button type=\"button\" class=\"btn btn-danger\" data-dismiss=\"modal\">Cancel</button>";

             $('#AddEditBankModal').modal('toggle');
         }

         function setPrimaryBankPopup(TYPE, BankName, MICR, RTGS, bankAcNo, CLIENTNAME) {

             document.getElementById("txtPrimaryBankName").value = BankName;
             document.getElementById("txtPrimaryBankAcNo").value = bankAcNo

             $('#confirmSetPrimaryBankModal').modal('show');
         }

          function removeBankAlert(bankType, bankAcNo, BankName) {

            if (bankType=="Primary") {
                 alertModal("Opps! Problem with Removing primary Bank Account", "You can't remove your primary bank account? To remove your primary bank account, you must set another bank account as your primary account, then remove the old one");
                 return;
            }
            
            $('#confirmRemoveBankModalbody').html("Do you really want to remove Bank " + BankName + " - Acno: " + bankAcNo + "?");

            document.getElementById("hdnRemoveBankAcNo").value = bankAcNo;
            document.getElementById("hdnRemoveBankName").value = BankName;

            $('#confirmRemoveBankModal').modal('show');
            
         }

         function removeBank(bankAcNo, BankName) {

             $('#confirmRemoveBankModal').modal('hide');

             document.getElementById('hdnBtnContinueClicked').value = "Remove Bank" + "#" + bankAcNo;
             

             document.getElementById('<%= btnContinueClick.UniqueID %>').click();

             //grdBanks.Refresh();
         }

         function setPrimaryBank() {
             document.getElementById('hdnBtnContinueClicked').value = "Set Primary Bank" + "#" + document.getElementById("txtPrimaryBankAcNo").value;
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
         }

         function addBank() {

             if (document.getElementById('txtBankIFSC').value == "") {
                 alertModal("Opps! Problem with the IFSC Code", "Please provide a valid IFSC code to search for your bank");
                 return;
             }

             var foundIFSC = false;

             if (document.getElementById('cmbBanks') != null) {

                 if (document.getElementById('cmbBanks').value != "") {
                     foundIFSC = true;
                 }
             }

             if (foundIFSC != true) {

                 if (document.getElementById('txtBank').value == "") {
                     alertModal("Opps! Problem with the Bank Name", "Please enter your Bank Name");
                     return;
                 }

                 if (document.getElementById('txtBankMICR').value == "") {
                     alertModal("Opps! Problem with the MICR", "Please enter your bank MICR");
                     return;
                 }

             }


             if (document.getElementById('txtBankAccountNumber').value == "") {
                 alertModal("Opps! Problem with the Bank Account Number", "Please enter your bank account number");
                 return;
             }

             if (document.getElementById('txtConfirmBankAccountNumber').value == "") {
                 alertModal("Opps! Problem with the Bank Account Number", "Please confirm the bank account number");
                 return;
             }

             if (document.getElementById('txtBankAccountNumber').value != document.getElementById('txtConfirmBankAccountNumber').value) {
                 alertModal("Opps! Problem with the Bank Account Number", "There is a mismatch in the bank account number. Please confirm and correct it");
                 return;
             }

             if (document.getElementById('hdnBankValidation').value != "API") {

                 
                 if (document.getElementById('selectBankValidationType').value == "") {
                     alertModal("Opps! Problem with the Bank Verification", "Please select how to verification your bank a/c");
                     return;
                 }

                 if (validateFileExtensionByFileName(document.getElementById('spanBankVerificationAsyncFileUpload').innerHTML, "Bank verification file (Canceled Cheque/Passbook 1st Page)", "JPG,PNG,JPEG") == false) {
                     return;
                 }

             }
             document.getElementById('hdnBtnContinueClicked').value = "Add Bank" + "#" + document.getElementById('txtConfirmBankAccountNumber').value;

             showModalLoading();

             document.getElementById('<%= btnContinueClick.UniqueID %>').click();

         }

         function saveBankDetals() {

             document.getElementById('hdnBtnContinueClicked').value = "SaveBankDetals";
             showModalLoading();
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
         }

         function CleanExistingFileData() {
             document.getElementById('spanBankVerificationAsyncFileUpload').innerHTML = "";
             document.getElementById('spanBankVerificationAsyncFileUpload').style.backgroundColor = "white";

             // Find the file upload control by its ID
             var asyncFileUpload = document.getElementById('<%= bankVerificationAsyncFileUpload.ClientID %>');

             // Find the input of type 'file' inside the div
             const fileInput = asyncFileUpload.querySelector("input[type='file']");

             // Find the input of type 'hidden' inside the div
             const hiddenInput = asyncFileUpload.querySelector("input[type='hidden']");

             fileInput.value = ''; // Clear the input
             hiddenInput.value = '';
         }

         function successAsyncFileUpload(sender, args) {

             if ($(sender._element).find('input').attr('id').match("bankVerificationAsyncFile") == "bankVerificationAsyncFile") {

                 $(sender._element).find('input').css("background-color", "white");

                 var filename = $(sender._element).find('input').val().replace("C:\\fakepath\\", "");

                 document.getElementById('spanBankVerificationAsyncFileUpload').innerHTML = filename;
                 document.getElementById('spanBankVerificationAsyncFileUpload').style.backgroundColor = "lime";

             }
         }

         function validateFileExtensionByElementId(fileElementId, ElementType, fileTypes) {

             var fileElement = document.getElementById(fileElementId)
             var fileElementFileName = "";

             if (fileElement.value != "") {
                 fileElementFileName = fileElement.files.item(0).name.toUpperCase();
             }

             return validateFileExtensionByFileName(fileElementFileName, ElementType, fileTypes);

         }

         function validateFileExtensionByFileName(fileName, uploadType, fileTypes) {


             if (fileName == "") {
                 alertModal("Opps! Problem with the Bank Verification file Upload", "Please select and upload a bank verification document (Cancelled Cheque or the first page of the Passbook or Bank Statement) in " + fileTypes + " format");
                 return false;
             }

             const fileTypesArray = fileTypes.split(",");

             let matchesNameExtns = "";
             for (let i = 0; i < fileTypesArray.length; i++) {

                 if (i == fileTypesArray.length - 1) {
                     matchesNameExtns += "." + fileTypesArray[i] + "$";
                 }
                 else {
                     matchesNameExtns += "." + fileTypesArray[i] + "$|";
                 }

             }

             var fileElementFileName = fileName.toUpperCase();

             if (fileElementFileName.match(matchesNameExtns) == null) {
                 alertModal("Opps! Problem with the Bank Verification file Upload", "Invalid file selected! Please select and upload a bank verification document (Cancelled Cheque or the first page of the Passbook or Bank Statement) in " + fileTypes + " format");
                 return false;
             }

             return true;

         }



         
         function optoutNomination() {
             
             if (document.getElementById('selectMakeNominees').value == "No") {
                 document.getElementById('btnContinue').style.display = "none";
                 document.getElementById('divOptOutNominees').style.display = "block";
                 document.getElementById('divNominees').style.display = "none";
                 $('#confirmOptoutNominationModal').modal('show');
             }
             else {
                 cancelOptoutNomination();
             }
   
         }

         function cancelOptoutNomination() {
             document.getElementById('selectMakeNominees').value = "Yes";
             document.getElementById('btnContinue').style.display = "block";
             document.getElementById('divOptOutNominees').style.display = "none";
             document.getElementById('divNominees').style.display = "block";
         }
        
    </script>
    
    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                    <div class="col-md-3">
                        <center>
                        <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px;  padding-top:10px">
                        </center>
                    </div>
                    <div class="col-md-6">
                        <h2 class="lblTopHeader"><i class="fa fa-users" aria-hidden="true"></i> Nominees</h2>
                        <p> Nominees can be added, you can also Opt-out of Nomination.</p>
                     </div>
                    <div class="col-md-3" style="display:flex;flex-direction:column;align-items:flex-end;">
                        <h5 id="hFullName" style="margin:0px;" runat="server"></h5>
                        <span>UCC: <span id="spanUCC" runat="server"></span></span>
                        <span>DOB: <span id="spanDOB" runat="server"></span></span>
                        <span>PAN: <span id="spanPAN" runat="server"></span></span>
                        <span style="display:none">Aadhaar: <span id="spanAadhaar" runat="server"></span></span>
                    </div>
                </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-8">
                        <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div style="display:none">
                                          <div class="row justify-content-center">
                                            <div class="col-md-12">
                                                <h4>Existing Details</h4>
                                                <div class="table-responsive">
                                                    <table class="table table-striped" style="border-bottom:dashed; border-top:dashed; border-width:2px;">
                                                        <thead class="thead-dark">
                                                            <tr>
                                                                <th>Name</th>
                                                                <th>Relation</th>
                                                                <th>Share %</th>
                                                                <th>Mobile</th>
                                                                <th>Date of Birth</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="tbodyNominees" runat="server">
                                                        </tbody>
                                                    </table>
                                                    <br />
                                                    </div>
                                            </div>
                                        </div>
                                      </div>
                                    <div class="form-outline flex-fill mb-0">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <h4>Do you wish to make Nominees?</h4>
                                            </div>
                                            <div class="col-md-6">
                                                <select class="form-control" style="width:50%" onchange="optoutNomination();" id="selectMakeNominees" runat="server">
                                                    <option>Yes</option>  
                                                    <option>No</option>
                                                </select>
                                                            
                                            </div>
                                        </div>
                                    </div>
                                    <div id="divOptOutNominees" runat="server">
                                        <div class="alert alert-danger">
                                        <strong>Opt-out of Nomination</strong> You do not wish to appoint any nominee.
                                        </div>
                                        <button type="button" class="btn btn-lg btn-success" data-dismiss="modal" id="btnContinueOptoutNomination" onclick="saveNomination('Opt Out')"><i class="fa fa-check" aria-hidden="true"></i> Continue</button>
                                    </div>
                                    <div id="divNominees" runat="server">
                                        <div class="row">
                                            <div class="col-md-12">
                                            <h4><i class="fa fa-list-alt" aria-hidden="true"></i> Available Nominees</h4>
                                            <button type="button" class="btn btn-primary btn-sm" id="btnAddNewBank" style="margin-bottom:20px" onclick="addBankPopup();"><i class="fa fa-plus" aria-hidden="true"></i> Add New Nominee</button>
                                            <dx:ASPxGridView ID="grdNominees" ClientInstanceName="grdNominees" AutoGenerateColumns="False" CssClass="table" Theme="MetropolisBlue" Width="100%" runat="server">
                                                <Columns>
                                                    <dx:GridViewDataMemoColumn FieldName="descr" CellStyle-HorizontalAlign="Left" Caption="Name" Width="45%" VisibleIndex="0">
                                                        <CellStyle HorizontalAlign="Left"></CellStyle>
                                                            <DataItemTemplate>
                                                            <span><span><%# Eval("descr") %></span>
                                                            <br />
                                                            <span>Mobile</span> : <span><%# Eval("mobile") %></span>
                                                            <div>
                                                                <button type="button" class="btn btn-default btn-xs" onclick="viwNomDetails('<%# Eval("nomineeNo") %>','<%# Eval("descr") %>','<%# Eval("relation") %>','<%# Eval("percent") %>','<%# Eval("mobile") %>')"><i class="fa fa-eye" aria-hidden="true"></i> Details</button>
                                                                <button type="button" class="btn btn-default btn-xs" onclick="setPrimaryBankPopup('<%# Eval("nomineeNo") %>','<%# Eval("descr") %>','<%# Eval("relation") %>','<%# Eval("percent") %>','<%# Eval("mobile") %>')"><i class="fa fa-edit" aria-hidden="true"></i> Edit</button>
                                                                <button type="button" class="btn btn-default btn-xs" onclick="removeBankAlert('<%# Eval("nomineeNo") %>', '<%# Eval("descr") %>','<%# Eval("relation") %>','<%# Eval("percent") %>','<%# Eval("mobile") %>')"><i class="fa fa-times" aria-hidden="true"></i> Remove</button>
                                                            </div>
                                                        </DataItemTemplate>
                                                    </dx:GridViewDataMemoColumn>
                                                    <dx:GridViewDataTextColumn FieldName="relation" Width="25%" Caption="Relation" VisibleIndex="2">
                                                        <DataItemTemplate>
                                                            <span><%# Eval("relation") %></span>
                                                        </DataItemTemplate>
                                                    </dx:GridViewDataTextColumn>
                                                    <dx:GridViewDataTextColumn FieldName="percent" Width="15%" Caption="Share %" VisibleIndex="3">
                                                        <DataItemTemplate>
                                                            <span><%# Eval("percent") %></span>
                                                        </DataItemTemplate>
                                                    </dx:GridViewDataTextColumn>
                                                    <dx:GridViewDataTextColumn Width="60px" FieldName="modStatus" Caption="Status" VisibleIndex="4">
                                                            <CellStyle HorizontalAlign="Center"></CellStyle>
                                                        <DataItemTemplate>
                                                            <span><%# Eval("modStatus") %></span>
                                                        </DataItemTemplate>
                                                    </dx:GridViewDataTextColumn>
                                                    </Columns>
                                                    <SettingsBehavior AllowFocusedRow="True"></SettingsBehavior>
                                                    <SettingsPager Mode="EndlessPaging">
                                                    </SettingsPager>
                                                    <Settings ShowGroupedColumns="True" ShowGroupPanel="False" GridLines="Horizontal" />
                                                    <SettingsDetail ShowDetailRow="false" />
                                                    <SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
                                                    <Styles>
                                                    <Header Font-Bold="False" Font-Underline="False" VerticalAlign="Middle">
                                                    </Header>
                                                    <Cell>
                                                        <BorderBottom BorderColor="#336666" BorderStyle="Solid" BorderWidth="1px" />
                                                    </Cell>
                                                    <FocusedRow BackColor="WhiteSmoke">
                                                    </FocusedRow>
                                                    <Cell ForeColor="Black"></Cell>
                                                </Styles>
                                                </dx:ASPxGridView>
                                        </div>
                                        </div>
                                    </div>
                                  </div>
                              </div>
                              <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                  <button type="button" class="btn btn-success btn-lg" id="btnContinue" onclick="saveBankDetals();" runat="server" ><i class="fa fa-check" aria-hidden="true"></i> Save and Continue</button>
                                  <p>
                                      <br />
                                      <i>
                                        *By clicking the above button, I agree that i have read <a href="../ekyc/terms.aspx?type=bank" target="_blank">Terms & Conditions</a>.
                                      </i>
                                  </p>
                                  <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                  </div>
                              </div>
                           </ContentTemplate>
                        </asp:UpdatePanel>
                           <hr />
                          <div id="divPreviousSteps" runat="server">
                                <h4>Go to previous step </h4> 
                                <ul class="list-inline">
                                    <li><a href="ConfirmDetails.aspx?cnfmrset=1" id="hlinkChooseParameters" runat="server"><i class="fa fa-solid fa-list-check" aria-hidden="true"></i> Reset Modifications</a></li>
                                    <li><a href="contact.aspx" id="hlinkContact" runat="server"><i class="fas fa-envelope fa-lg me-3 fa-fw" aria-hidden="true"></i> Contact</a></li>
                                    <li><a href="DigiLockerKYC.aspx" id="hlinkDigiLocker" runat="server"><i class="fa fa-cloud-download" aria-hidden="true"></i> DigiLocker</a></li>
                                    <li><a href="manuallyProcessing.aspx" id="hlinkManuallyProcessing" runat="server"><i class="fa fa-id-card" aria-hidden="true"></i> <span id="spanManuallyProcessing" runat="server">Address|DOB</span> </a></li>
                                    <li><a href="takePhoto.aspx" id="hlinkCapturePhoto" runat="server"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                    <li><a href="incomeProfile.aspx" id="hlinkIncomeProfile" runat="server"><i class="fa fa-inr" aria-hidden="true"></i> Income Profile</a></li>
                                    <li><a href="TradingPreference.aspx" id="hlinkTradingPreference" runat="server"><i class="fa fa-exchange" aria-hidden="true"></i> Trading Preference</a></li>
                                    <li><a href="BankDetails.aspx" id="hlinkBankDetails" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Bank</a></li>
                                    <li><a href="dematAccount.aspx" id="hlinkDematAccount" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Demat Account</a></li>
                                    <li><a href="AuthorizedRepresentative.aspx" id="hlinkAuthorizedRepresentative" runat="server"><i class="fa fa-user-circle" aria-hidden="true"></i> Authorized Representative</a></li>
                                    <li><a href="uploadDocuments.aspx" id="hlinkUploadDocuments" runat="server"><i class="fa fa-upload" aria-hidden="true"></i> Upload documents</a></li>
                                </ul>
                            </div>
                      </div>
                        <div class="col-md-4">
                            <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                <div class="ekycCard">
                                <div class="ekycCardTitle">
                                    <h4 style="margin-bottom:0px;">Why do I need Nominees?</h4>
                                </div>
                                <div>
                                    To avoid Inheritance Complications! Without a nominee, the distribution of assets may become complicated, potentially leading to disputes among legal heirs. Appointing a nominee helps ensure that your wishes regarding the distribution of your securities are respected
                                </div>
                                <div class="ekycCardTitle">
                                    <h4 style="margin-bottom:0px;">How many Nominees can I appoint?</h4>
                                </div>
                                <div>
                                    You can divide your Holdings amongst a maximum of 10 nominees, with their %age shares adding up to 100%
                                </div>
                                </div>
                                <br />
                                <div class="alert alert-info" id="divAlertInfoMsg" style="display:none" runat="server">
                                </div>
                                <div class="alert alert-warning">
                                    <b>Important Note for Aadhaar Upload:</b> 
                                    <hr style="margin-top:5px; margin-bottom:5px" />
                                    <span style="font-size:12px;" id="spanAadhaarUploadNotes" runat="server">
                                    </span>
                                    <hr />
                                    <i><b>Disclaimer:</b> Keep the file size under 2MB.<br />Use one of these formats: JPG, PNG, JPEG, or PDF.</i>
                                    <p class="margineTop10">
                                    Please ensure that the files you upload are <b>not password-protected</b> and <b>not corrupted</b>
                                    </p>
                                </div>
                            </div>
                            <p style="display:none">
                                <b><span id="spanBrokerName" runat="server">Standard Broker</span></b> for conducting online ReKYC for trading and demat account
                            </p>
                        </div>
                       
                    </div>
                  </div>
                </div>
              </div>
            </div>

              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
			    </div>
             </div>

          </div>
        </section>

        <div id="AddEditBankModal" class="modal fade">
           <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="AddEditBankModalHeader"><i class="fa fa-university" aria-hidden="true"></i> Add Bank</h4>
                </div>
                <div class="modal-body">
                    <input type="hidden"  id="hdnAddEditBankValue" name="hdnAddEditBankValue" runat="server" value="">
                    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                        <ContentTemplate>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-2">
                                    <label for="txtBankIFSC" class="control-label">IFSC*:</label>
                                </div>
                                <div class="col-sm-6">
                                    <input type="text" class="form-control" id="txtBankIFSC" runat="server" placeholder="Type IFSC">
                                </div>
                                <div class="col-sm-4">
                                    <asp:Button ID="btnFindBank" CssClass="btn btn-info" runat="server" OnClick="btnFindBank_Click" Text="Find Bank" />
                                </div>
                           </div>
                            <div style="padding-top:10px">
                                <div id="divSelectBank" runat="server">
                                    <div class="row">
                                        <div class="col-sm-2"></div>
                                        <div class="col-sm-8">
                                            <asp:DropDownList ID="cmbBanks" Visible="false" CssClass="form-control" runat="server">
                                            </asp:DropDownList>
                                         </div>
                                     </div>
                                </div>
                                <div id="divEnterBankDetails" runat="server" style="display:none">
                                    <div class="row">
                                        <div class="col-sm-2">
                                            <label for="txtBank" class="control-label">Bank Name and MICR*:</label>
                                        </div>
                                        <div class="col-sm-6">
                                            <input type="text" class="form-control" id="txtBank" runat="server" placeholder="Enter Bank Name">
                                        </div>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="txtBankMICR" runat="server" placeholder="Enter MICR">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-2">
                                    <label for="selectBankType" class="control-label">Type:</label>
                                </div>
                                 <div class="col-sm-4">
                                    <select class="form-control" id="selectBankType" onchange="if(this.value=='Primary'){alertModal('New Bank selected as Primary', 'Your available primary Bank will be automatically changed as <b>secondary</b>');}" runat="server">
                                        <option>Primary</option>
                                        <option selected="selected">Secondary</option>
                                    </select>
                                </div>
                                <div class="col-sm-2">
                                    <label for="selectBankType" class="control-label">Account Type:</label>
                                </div>
                                 <div class="col-sm-4">
                                    <select class="form-control" id="selectAccountType"  runat="server">
                                        <option selected="selected">Savings</option>
                                        <option>Current</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-2">
                                    <label for="txtBankAccountNumber" class="control-label">A/C No*:</label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="number" class="form-control" id="txtBankAccountNumber" runat="server" placeholder="Account number" maxlength="20" oninput="togglePasswordAndValidate('txtConfirmBankAccountNumber', this)">
                                 </div>
                             </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-2">
                                    <label for="txtConfirmBankAccountNumber" class="control-label">Confirm A/C No*:</label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="password" class="form-control" id="txtConfirmBankAccountNumber"  runat="server" placeholder="Account number" maxlength="20" 
                                        onkeypress="CleanExistingFileData();"   
                                        oncopy="disableCopyPaste(event)" 
                                        onpaste="disableCopyPaste(event)" 
                                        oncut="disableCopyPaste(event)" 
                                        oninput="togglePasswordAndValidate('txtBankAccountNumber', this)">
                                 </div>
                             </div>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                     <div id="divBankValidation" runat="server">
                         <div class="row" style="padding-top:10px">
                            <div class="col-sm-2">
                                <label for="txtBankAcName" class="control-label">Name:</label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" class="form-control" id="txtBankAcName" runat="server" placeholder="A/c Name" maxlength="50">
                             </div>
                         </div>
                         <div class="row" style="padding-top:10px">
                             <div class="col-sm-2">
                                <label for="selectBankValidationType" class="control-label">Validation*:</label>
                            </div>
                            <div class="col-sm-5">
                                <select class="form-control" id="selectBankValidationType" runat="server">
                                    <option>Canceled Cheque</option>
                                    <option>Passbook 1st page</option>
                                    <option>Bank Statement</option>
                                </select>
                             </div>
                            <div class="col-sm-5" style="padding-left:30px; padding-top:10px">
                                <div class="form-group">
                                    <ajaxToolkit:AsyncFileUpload ID="bankVerificationAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="bankVerificationAsyncFile_UploadedComplete" runat="server" />
                                        <span id="spanBankVerificationAsyncFileUpload" runat="server"></span>
                                </div>
                            </div>
                        </div>
                     </div>
                </div>
                <div class="modal-footer" style="text-align:center">
                    <div id="divAddEditBankModalFooter">
                        <button type="button" class="btn btn-primary" id="btnAddBankModal" onclick="addBank();">Add Bank</button>
                        <button type="button" class="btn btn-danger" id="btnAddBankModalCancel" data-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </div>
            </div>
        </div>    

        <div id="confirmSetPrimaryBankModal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="confirmSetPrimaryBankModalHeader" class="modal-title"><i class="fa fa-university" aria-hidden="true"></i> Set Primary Bank </h4>
              </div>
              <div class="modal-body">
                  <p id="confirmSetPrimaryBankModalbody">Do you really want to set this Bank to Primary?</p>
                  <div class="row" style="padding-top:10px">
                        <div class="col-sm-2">
                            <label for="txtBankAcName" class="control-label">Bank*:</label>
                        </div>
                        <div class="col-sm-8">
                            <input type="text" readonly="readonly" class="form-control" id="txtPrimaryBankName" runat="server">
                         </div>
                     </div>
                  <div class="row" style="padding-top:10px">
                        <div class="col-sm-2">
                            <label for="txtPrimaryBankAcNo" class="control-label">A/C No*:</label>
                        </div>
                        <div class="col-sm-8">
                            <input type="number" readonly="readonly" class="form-control" id="txtPrimaryBankAcNo" runat="server">
                         </div>
                     </div>
                  <br />
                  <span style="font-size:12px;"><i>Your available <b>Primary Bank</b> will be automatically changed as <b>Secondary</b></i></span>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <button type="button" class="btn btn-success" data-dismiss="modal" id="btnSetPrimaryBankModalYes" onclick="setPrimaryBank()">Set Primary</button>
                  <button type="button" class="btn btn-danger" data-dismiss="modal">No</button>
              </div>
            </div>
          </div>
        </div>

        <div id="confirmRemoveBankModal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="confirmRemoveBankModalHeader" class="modal-title"> Remove Bank</h4>
              </div>
              <div class="modal-body">
                  <p id="confirmRemoveBankModalbody">Do you really want to remove Bank?</p>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <input type="hidden" id="hdnRemoveBankAcNo" runat="server" name="hdnRemoveBankAcNo" value="">
                  <input type="hidden" id="hdnRemoveBankName" runat="server" name="hdnRemoveBankName" value="">
                  <button type="button" class="btn btn-primary" data-dismiss="modal" id="btnConfirmRemoveBankModalNo">No</button>
                  <button type="button" class="btn btn-danger" data-dismiss="modal" id="btnRemoveBankModalYes" onclick="removeBank(document.getElementById('hdnRemoveBankAcNo').value, document.getElementById('hdnRemoveBankName').value)">Yes</button>
              </div>
            </div>
          </div>
        </div>


        <div id="confirmOptoutNominationModal" class="modal fade">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="cancelOptoutNomination();"><span aria-hidden="true">&times;</span></button>
                <h2>Opt-out of Nomination</h2>
              </div>
              <div class="modal-body">
                  <h4 id="confirmOptoutModalbody">Do you really want to Opt-out of Nomination?</h4>
                  <br />
                  <h4><u>Declaration</u></h4>
                  <p>
                      I / We hereby confirm that I / We do not wish to appoint any nominee(s) in my / our trading / Demat account and understand the issues involved in non-appointment of nominee(s) and further are aware that in case of death of all the account holder(s), my / our legal heirs would need to submit all the requisite documents / information for claiming of assets held in my / our trading / Demat account, which may also include documents issued by Court or other such competent authority, based on the value of assets held in the trading / Demat account.
                  </p>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <button type="button" class="btn btn-lg btn-primary" data-dismiss="modal" onclick="cancelOptoutNomination();" id="btnConfirmOptoutNominationModalNo" style="margin-top:5px">No, I don't agree</button>
                  <button type="button" class="btn btn-lg btn-danger" data-dismiss="modal" id="btnConfirmOptoutNominationModalYes" onclick="saveNomination('Opt Out')" style="margin-top:5px">Yes, I agree and want to opt out</button>
              </div>
            </div>
          </div>
        </div>
    </form>
    


</body>
</html>
