﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="accountClosure.aspx.cs" Inherits="Connect_DotNet.ReKYC.accountClosure" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>Account Closure Form</title>
     <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <style>
        * {
    margin: 0;
    padding: 0;
}

html {
    height: 100%;
}

/*Background color*/
body {
    /*background-color: #9C27B0;*/
    /*background-image: linear-gradient(120deg, #34A853, #81D4FA);*/
}

/*form styles*/
#msform {
    text-align: center;
    position: relative;
    margin-top: 20px;
}

#msform fieldset .form-card {
    background: white;
    border: 0 none;
    border-radius: 0px;
    box-shadow: 0 2px 2px 2px rgba(0, 0, 0, 0.2);
    padding: 20px 40px 30px 40px;
    box-sizing: border-box;
    width: 98%;
    margin: 0 3% 20px 3%;

    /*stacking fieldsets above each other*/
    position: relative;
}

#msform fieldset {
    background: white;
    border: 0 none;
    border-radius: 0.5rem;
    box-sizing: border-box;
    width: 100%;
    margin: 0;
    padding-bottom: 20px;

    /*stacking fieldsets above each other*/
    position: relative;
}

/*Hide all except first fieldset*/
#msform fieldset:not(:first-of-type) {
    display: none;
}

#msform fieldset .form-card {
    text-align: left;
    color: #9E9E9E;
}


#msform input, #msform textarea {
    padding: 0px 8px 4px 8px;
    border: none;
    border-bottom: 1px solid #ccc;
    border-radius: 0px;
    margin-bottom: 25px;
    margin-top: 2px;
    /*width: 100%;*/
    box-sizing: border-box;
    font-family: montserrat;
    color: #2C3E50;
    font-size: 16px;
    letter-spacing: 1px;
}

#msform input:focus, #msform textarea:focus {
    -moz-box-shadow: none !important;
    -webkit-box-shadow: none !important;
    box-shadow: none !important;
    border: none;
    font-weight: bold;
    border-bottom: 2px solid skyblue;
    outline-width: 0;
}

/*Blue Buttons*/
#msform .action-button {
    width: 100px;
    background: #1DBAF7;
    font-weight: bold;
    color: white;
    border: 0 none;
    border-radius: 0px;
    cursor: pointer;
    padding: 10px 5px;
    margin: 10px 5px;
}

#msform .action-button:hover, #msform .action-button:focus {
    box-shadow: 0 0 0 2px white, 0 0 0 3px skyblue;
}

/*Previous Buttons*/
#msform .action-button-previous {
    width: 100px;
    background: #616161;
    font-weight: bold;
    color: white;
    border: 0 none;
    border-radius: 0px;
    cursor: pointer;
    padding: 10px 5px;
    margin: 10px 5px;
}

#msform .action-button-previous:hover, #msform .action-button-previous:focus {
    box-shadow: 0 0 0 2px white, 0 0 0 3px #616161;
}

/*Dropdown List Exp Date*/
select.list-dt {
    border: none;
    outline: 0;
    border-bottom: 1px solid #ccc;
    padding: 2px 5px 3px 5px;
    margin: 2px;
}

select.list-dt:focus {
    border-bottom: 2px solid skyblue;
}

/*The background card*/
.card {
    z-index: 0;
    border: none;
    border-radius: 0.5rem;
    position: relative;
}

/*FieldSet headings*/
.fs-title {
    font-size: 25px;
    color: #2C3E50;
    margin-bottom: 10px;
    font-weight: bold;
    text-align: left;
}

/*progressbar*/
#progressbar {
    margin-bottom: 30px;
    overflow: hidden;
    color: lightgrey;
}

#progressbar .active {
    color: #000000;
}

#progressbar li {
    list-style-type: none;
    font-size: 12px;
    width: 25%;
    float: left;
    position: relative;
}

/*Icons in the ProgressBar*/
#progressbar #chooseaccount:before {
    font-family: FontAwesome;
    content: "\f0a6";
}

#progressbar #trading:before {
    font-family: FontAwesome;
    content: "\f201";
}

#progressbar #depository:before {
    font-family: FontAwesome;
    content: "\f19c";
}

#progressbar #confirm:before {
    font-family: FontAwesome;
    content: "\f00c";
}

/*ProgressBar before any progress*/
#progressbar li:before {
    width: 50px;
    height: 50px;
    line-height: 45px;
    display: block;
    font-size: 18px;
    color: #ffffff;
    background: lightgray;
    border-radius: 50%;
    margin: 0 auto 10px auto;
    padding: 2px;
}

/*ProgressBar connectors*/
#progressbar li:after {
    content: '';
    width: 100%;
    height: 2px;
    background: lightgray;
    position: absolute;
    left: 0;
    top: 25px;
    z-index: -1;
}

/*Color number of the step and the connector before it*/
#progressbar li.active:before, #progressbar li.active:after {
    background: #1DBAF7;
}

/*Imaged Radio Buttons*/
.radio-group {
    position: relative;
    margin-bottom: 25px;
}

.radio {
    display:inline-block;
    width: 204;
    height: 104;
    border-radius: 0;
    background: lightblue;
    box-shadow: 0 2px 2px 2px rgba(0, 0, 0, 0.2);
    box-sizing: border-box;
    cursor:pointer;
    margin: 8px 2px; 
}

.radio:hover {
    box-shadow: 2px 2px 2px 2px rgba(0, 0, 0, 0.3);
}

.radio.selected {
    box-shadow: 1px 1px 2px 2px rgba(0, 0, 0, 0.1);
}

/*Fit image in bootstrap div*/
.fit-image{
    width: 100%;
    object-fit: cover;
}
/*For remove padding in checkbox list*/
.checkbox label, .radio label {
    padding-left: 0px!important;
}
    </style>
    <script>
$(document).ready(function(){
    
var current_fs, next_fs, previous_fs; //fieldsets
var opacity;

    $(".next").click(function () {

        if ($(this).attr('id') == "btnTradingNext") {

            
            var chkBoxListDepositories = document.getElementById('<%=chblDepositories.ClientID %>');

            if (chkBoxListDepositories != null) {
                for (i = 0; i < chkBoxListDepositories.getElementsByTagName("input").length; i++) {

                    var selectedDepositoryValue = chkBoxListDepositories.getElementsByTagName("span")[i].getAttribute("data-value");
                    var selectedDepositoryActualValue = selectedDepositoryValue.replace("#", "");

                    if (chkBoxListDepositories.getElementsByTagName("input")[i].checked == true) {

                        document.getElementById('divDepository' + selectedDepositoryActualValue).style.display = "block";
                    }
                    else {
                        document.getElementById('divDepository' + selectedDepositoryActualValue).style.display = "none";
                    }
                }
            }
            
            


        }

        if ($(this).attr('id') == "btnDPNext") {

            
            var chkBoxListDepositories = document.getElementById('<%=chblDepositories.ClientID %>');

            if (chkBoxListDepositories != null) {

                for (i = 0; i < chkBoxListDepositories.getElementsByTagName("input").length; i++) {
                    if (chkBoxListDepositories.getElementsByTagName("input")[i].checked == true) {
                        //alert(chkBoxListDepositories.getElementsByTagName("input")[i].value);
                        //alert(i);
                        //alert(chkBoxListDepositories.getElementsByTagName("span")[i].getAttribute("data-value"));
                        //alert(chkBoxListDepositories.getElementsByTagName("span")[i].innerHTML);
                        //alert(chkBoxListDepositories.getElementsByTagName("label")[i].innerHTML);

                        //var txtdpTargetDPID = document.getElementById('txtdpTargetDPID' + chkBoxListDepositories.getElementsByTagName("input")[i].value.replace("#", ""));

                        // Value not working using javascript from some browser (chkBoxListDepositories.getElementsByTagName("input")[i].value). 
                        //Thats why we using li.Attributes.Add("data-value", li.Value); in server side and 
                        //chkBoxListDepositories.getElementsByTagName("span")[i].getAttribute("data-value") in client side
                        var selectedDepositoryValue = chkBoxListDepositories.getElementsByTagName("span")[i].getAttribute("data-value");
                        var selectedDepositoryActualValue = selectedDepositoryValue.replace("#", "");

                        //alert(selectedDepositoryValue);
                        //alert(selectedDepositoryActualValue);

                        var DPClientSignatureimage = document.getElementById('DPClientSignatureimage' + selectedDepositoryActualValue)

                        //alert('Selected file: ' + DPClientSignatureimage.files.item(0).name);
                        //alert('Selected file: ' + DPClientSignatureimage.files.item(0).size);
                        //alert('Selected file: ' + DPClientSignatureimage.files.item(0).type);


                        if (DPClientSignatureimage != null) {

                            if (DPClientSignatureimage.value == "") {
                                alert("Please select client signature image file in JPG, PNG format for [" + selectedDepositoryValue + "]");
                                return;
                            }

                            var DPClientSignatureimageFileName = DPClientSignatureimage.files.item(0).name.toUpperCase();
                            if (DPClientSignatureimageFileName.match(".JPG$|.PNG$") == null) {
                                alert("Please select client signature image file in JPG, PNG format for [" + selectedDepositoryValue + "]");
                                return;
                            }
                        }


                        var txtdpTargetDPID = document.getElementById('txtdpTargetDPID' + selectedDepositoryActualValue);

                        if (txtdpTargetDPID == null) { continue; }


                        var txtTargetClientId = document.getElementById('txtTargetClientId' + selectedDepositoryActualValue);
                        var targetDPmasterFile = document.getElementById('targetDPmasterFile' + selectedDepositoryActualValue)
                        //alert(txtdpTargetDPID.value);
                        //alert(txtTargetClientId.value);
                        //alert(targetDPmasterFile.value);

                        if (txtdpTargetDPID.value == "") {
                            alert("Please enter target DPID for [" + selectedDepositoryValue + "]");
                            return;
                        }

                        if (txtTargetClientId.value == "") {
                            alert("Please enter target ClientId for [" + selectedDepositoryValue + "]");
                            return;
                        }

                        if (targetDPmasterFile.value == "") {
                            alert("Please select target DP client master file in JPG, PNG format for [" + selectedDepositoryValue + "]");
                            return;
                        }

                        var targetDPmasterFileName = targetDPmasterFile.files.item(0).name.toUpperCase();
                        if (targetDPmasterFileName.match(".JPG$|.PNG$") == null) {
                            alert("Please select target DP client master file in JPG, PNG format for [" + selectedDepositoryValue + "]");
                            return;
                        }
                    }
                }

            }

            document.getElementById("finalCardTitle").innerHTML = "";
            document.getElementById("divTermsandconditions").style.display = "none";
            document.getElementById("divLoading").style.display = "block";
            document.getElementById("hdnBtnSubmiClicked").value = "1";
            document.getElementById("<%=btnSubmit.UniqueID %>").click();

        }

    current_fs = $(this).parent();
    next_fs = $(this).parent().next();
    
    //Add Class Active
    $("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");
    
    //show the next fieldset
    next_fs.show(); 
    //hide the current fieldset with style
    current_fs.animate({opacity: 0}, {
        step: function(now) {
            // for making fielset appear animation
            opacity = 1 - now;

            current_fs.css({
                'display': 'none',
                'position': 'relative'
            });
            next_fs.css({'opacity': opacity});
        }, 
        duration: 600
    });
});

$(".previous").click(function(){
    
    current_fs = $(this).parent();
    previous_fs = $(this).parent().prev();
    
    //Remove class active
    $("#progressbar li").eq($("fieldset").index(current_fs)).removeClass("active");
    
    //show the previous fieldset
    previous_fs.show();

    //hide the current fieldset with style
    current_fs.animate({opacity: 0}, {
        step: function(now) {
            // for making fielset appear animation
            opacity = 1 - now;

            current_fs.css({
                'display': 'none',
                'position': 'relative'
            });
            previous_fs.css({'opacity': opacity});
        }, 
        duration: 600
    });
});

$('.radio-group .radio').click(function(){
    $(this).parent().find('.radio').removeClass('selected');
    $(this).addClass('selected');
});

$(".submit").click(function(){
    return false;
})
    
});
    </script>


<script language="javascript" type="text/javascript">

    function AccountTypeCheckBoxListSelect() {
        
        var chkBoxListDepositories = document.getElementById('<%=chblDepositories.ClientID %>');
        var chkBoxListAccountType = document.getElementById('<%=chblAccountType.ClientID %>');
        
        if (chkBoxListAccountType.getElementsByTagName("input")[1].checked == false) {

            for (i = 0; i < chkBoxListDepositories.getElementsByTagName("input").length; i++) {
                chkBoxListDepositories.getElementsByTagName("input")[i].checked = false;
            }
        }
        else {

            for (i = 0; i < chkBoxListDepositories.getElementsByTagName("input").length; i++) {
                chkBoxListDepositories.getElementsByTagName("input")[i].checked = true;
            }

        }

        setErrorInfoMsg();
        
    }

    function setErrorInfoMsg() {

        var chkBoxListAccountType = document.getElementById('<%=chblAccountType.ClientID %>');

        if (chkBoxListAccountType.getElementsByTagName("input")[0].checked == false) {
            document.getElementById("divTradingMsg").style.display = "block";
            document.getElementById("divtradingcard").style.display = "none";

        }
        else {
            document.getElementById("divTradingMsg").style.display = "none";
            document.getElementById("divtradingcard").style.display = "block";
        }

        if (chkBoxListAccountType.getElementsByTagName("input")[1].checked == false) {
            document.getElementById("divdepositoryMsg").style.display = "block";
            document.getElementById("divdepositorycard").style.display = "none";
        }
        else {
            document.getElementById("divdepositoryMsg").style.display = "none";
            document.getElementById("divdepositorycard").style.display = "block";
        }

        if (chkBoxListAccountType.getElementsByTagName("input")[0].checked == false && chkBoxListAccountType.getElementsByTagName("input")[1].checked == false) {
            document.getElementById("divErrorMsg").style.display = "block";
            document.getElementById("btnNextFirstPage").style.visibility = "hidden";
            document.getElementById("spanErrorMsg").innerHTML = "To close your trading/Depository account, you must select any of these or both, then press Next button.";
        }
        else if (chkBoxListAccountType.getElementsByTagName("input")[0].checked == false && chkBoxListAccountType.getElementsByTagName("input")[1].checked == true) {

            
            var DPCount = document.getElementById('<%=chblDepositories.ClientID %>').getElementsByTagName("input").length;
            var ClosedDPCount = 0;

            //alert(DPCount);

            for (i = 0; i < DPCount; i++) {
                if (document.getElementById('<%=chblDepositories.ClientID %>').getElementsByTagName("input")[i].checked) {
                    ClosedDPCount = ClosedDPCount+1;
                }
            }
           // alert(ClosedDPCount);

            if (DPCount == ClosedDPCount) {

                document.getElementById("divErrorMsg").style.display = "block";
                document.getElementById("btnNextFirstPage").style.visibility = "hidden";
                document.getElementById("spanErrorMsg").innerHTML = "You can not close your all demat account without closing trading account. If there are multiple demat accounts linked to the trading account, one demat account should be linked with the trading account, and the rest of the demat accounts can be closed";
            }
            else {
                document.getElementById("divErrorMsg").style.display = "none";
                document.getElementById("btnNextFirstPage").style.visibility = "visible";
            }


        }
        else {
            document.getElementById("divErrorMsg").style.display = "none";
            document.getElementById("btnNextFirstPage").style.visibility = "visible";
        }

    }

    function DepositoriesCheckBoxListSelect()
    {
        
        var chkBoxListDepositories = document.getElementById('<%=chblDepositories.ClientID %>');
        var chkBoxListAccountType = document.getElementById('<%=chblAccountType.ClientID %>');

        var anyDepositorieschecked = false;

        for (i = 0; i < chkBoxListDepositories.getElementsByTagName("input").length; i++) {
            if (chkBoxListDepositories.getElementsByTagName("input")[i].checked == true) {
                anyDepositorieschecked = true;
            }
        }

        if (anyDepositorieschecked == true) {
            chkBoxListAccountType.getElementsByTagName("input")[1].checked = true;
        }
        else {
            chkBoxListAccountType.getElementsByTagName("input")[1].checked = false;
        }

        setErrorInfoMsg();

    }
</script>

 <script>

     window.onload = function () {

         getLocation();

     }

      function getLocation() {
             if (navigator.geolocation) {
                 navigator.geolocation.getCurrentPosition(showPosition);
             } else {
                 document.getElementById("divLocation").innerHTML = "Geolocation is not supported by this browser.";
             }
         }

     function showPosition(position) {

         let date = new Date(); // object of the date class

         let timestamp = ("0" + date.getDate()).slice(-2) + '-' + ("0" + (date.getMonth() + 1)).slice(-2) + '-' + date.getFullYear() + ' ' + date.toString().replace(/^.+(\d{2}:\d{2}:\d{2}.+)\(.+$/, "$1");


         document.getElementById("divLocation").innerHTML = "Latitude: " + position.coords.latitude +
             ", Longitude: " + position.coords.longitude +
             ", Timestamp: " + timestamp;


         document.getElementById("hdnLatitude").value = position.coords.latitude;
         document.getElementById("hdnLongitude").value = position.coords.longitude;
         document.getElementById("hdnTimestamp").value = timestamp;


     }
 
  function activateButton(element) {

      document.getElementById('btnContinue').disabled = element.checked==false;

      <%--if(element.checked) {
          document.getElementById('<%=btnSubmit.ClientID %>').disabled = false;
          document.getElementById('<%=btnSubmit.ClientID %>').style = "padding:10px; font-size:large; background-color:darkblue; color:aliceblue";
       }
       else  {
          document.getElementById('<%=btnSubmit.ClientID %>').disabled = true;
          document.getElementById('<%=btnSubmit.ClientID %>').style = "padding:10px; font-size:large; background-color:white; color:gray";
      }--%>

      

      

     }


     function sendOTP() {
         document.getElementById("finalCardTitle").innerHTML = "Validate OTP";
         document.getElementById("divTermsandconditions").style.display = "none";
         document.getElementById("spanOTPErrorMsg").style.display = "none";

         document.getElementById("divOTPValidate").style.display = "none";

         document.getElementById("divOTP").style.display = "block";
         document.getElementById("divLoading").style.display = "block";
         document.getElementById("hdnBtnOTPClicked").value = "1";
         
         document.getElementById("<%=btnOTP.UniqueID %>").click();
         

     }

     function validateOTP() {

         
            if (txtOTP.value == "") {
                setErrorMsg("Invalid OTP entered!");
                return;
            }

         document.getElementById("finalCardTitle").innerHTML = "Request submission";
         document.getElementById("divOTPValidate").style.display = "none";
         document.getElementById("divLoading").style.display = "block";
         document.getElementById("hdnBtnOTPClicked").value = "2";

         document.getElementById("spanOTPErrorMsg").style.display = "none";

         document.getElementById("<%=btnOTP.UniqueID %>").click();
     }

     function setErrorMsg(errorMsg) {
         
         document.getElementById("spanOTPErrorMsg").style.display = "block";
         document.getElementById("spanOTPErrorMsg").innerHTML = "<i class='fa fa-exclamation-triangle' aria-hidden='true'></i> " + errorMsg;

         //alert(errorMsg);
         document.getElementById("divLoading").style.display = "none";
     }

     function previewPDF() {
         document.getElementById("hdnBtnSubmiClicked").value = "2";
         document.getElementById("<%=btnSubmit.UniqueID %>").click();
     }

     function showFinal() {

         current_fs = $("#btnNextFirstPage").parent();
         next_fs = $("#btnDPNext").parent().next();

         //Add Class Active

         $("#progressbar li").eq(0).addClass("active");
         $("#progressbar li").eq(1).addClass("active");
         $("#progressbar li").eq(2).addClass("active");
         $("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");

         //show the next fieldset
         next_fs.show();
         //hide the current fieldset with style
         current_fs.animate({ opacity: 0 }, {
             step: function (now) {
                 // for making fielset appear animation
                 opacity = 1 - now;

                 current_fs.css({
                     'display': 'none',
                     'position': 'relative'
                 });
                 next_fs.css({ 'opacity': opacity });
             },
             duration: 600
         });

         document.getElementById("finalCardTitle").innerHTML = "Legal terms and conditions";
         document.getElementById("divTermsandconditions").style.display = "block";
         document.getElementById("divLoading").style.display = "none";

     }


</script>

   <%-- <script type = "text/javascript">
  function DisableButton() {
      document.getElementById("<%=btnSubmit.ClientID %>").disabled = true;
  }
  window.onbeforeunload = DisableButton;
  </script>--%>
</head>
<body>
    
    <!-- MultiStep Form -->
<div class="container-fluid" id="grad1">
    <div class="row justify-content-center mt-0">
        <div class="col-md-10">
            
            <div class="card">
                <center>
                <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:200px; padding-top:10px">
                </center>
                <h2><strong>Close Account</strong></h2>
                <p>You can use this process to close your account. Fill all form field to go to next step</p>
                <!--
                 <div class="alert alert-danger">
                    <strong>Note!</strong> This page is under testing please do not try to make request.
                  </div>
                -->
                <div class="row">
                    <div class="col-md-12">
                        <form id="msform" runat="server" enctype="multipart/form-data">
                            
                            <asp:ScriptManager runat="server"></asp:ScriptManager>

                              <div id="divMainErrorMsg" runat="server" style="display: none; height: 100%; width: 100%; text-align: center;">
                                        <div class="alert alert-danger" role="alert">
									       <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span> <span id="spanError" runat="server"></span>
						                 </div>
				                    </div>
                            <div id="divMain" runat="server">
                                    <!-- progressbar -->
                                    <ul id="progressbar">
                                        <li class="active" id="chooseaccount"><strong>Choose Account</strong></li>
                                        <li id="trading"><strong>Trading account</strong></li>
                                        <li id="depository"><strong>Depository account</strong></li>
                                        <li id="confirm"><strong>Finish</strong></li>
                                    </ul>
                                    <!-- fieldsets -->
                                    <fieldset>
                                        <div class="form-card">
                                            <div class="page-header">
                                                <h2 class="fs-title">What do you want to close?</h2>
                                            </div>
                                            <div style="margin-left:20px">
                                                <asp:CheckBoxList ID="chblAccountType" CssClass="checkbox" runat="server" onchange="AccountTypeCheckBoxListSelect()">
                                                    <asp:ListItem Value="Trading" Enabled="false">Trading account</asp:ListItem>
                                                    <asp:ListItem Value="Depository" Enabled="false">Depository account</asp:ListItem>
                                                </asp:CheckBoxList>
                                                <div id="divDepository" style="padding-left:10px">
                                                     <asp:CheckBoxList ID="chblDepositories" CssClass="checkbox" runat="server" onchange="DepositoriesCheckBoxListSelect()">
                                                    </asp:CheckBoxList>
                                                </div>
                                            </div>
                                            <!--
                                            <div class="checkbox">
                                              <label><input type="checkbox" checked="checked" value="">Trading account</label>
                                            </div>
                                            <div class="checkbox">
                                              <label><input type="checkbox" value="" data-toggle="collapse" data-target="#divDepository">Depository account</label>
                                                  <div id="divDepository" class="collapse" style="padding-left:10px">
                                                    <div class="checkbox">
                                                      <label><input type="checkbox" checked="checked" value="">DPId: 12345 ClientId: 6585144</label>
                                                    </div>
                                                    <div class="checkbox">
                                                      <label><input type="checkbox" checked="checked" value="">DPId: 85544 ClientId: 9566542</label>
                                                    </div>
                                                  </div>
                                            </div>
                                            -->
                                     
                                        </div>
                                
                                        <div id="divErrorMsg" style="display: none; height: 100%; width: 100%; text-align: center;">
                                            <div class="alert alert-danger" role="alert">
									           <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span> <span id="spanErrorMsg"></span>
						                     </div>
				                        </div>

                                        <input type="button" id="btnNextFirstPage" name="next" class="next action-button" value="Next Step"/>
                                
                                    </fieldset>
                                    <fieldset>
                                        <div id="divTradingMsg" runat="server" style="display: none; height: 100%; width: 100%; text-align: center;">
						                    <h3><span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span> Trading account not selected!</h3>      
                                            <div class="alert alert-info" role="alert">
									           To select trading account just back to Previous step.
						                     </div>
				                        </div>
                                        <div class="form-card" id="divtradingcard" runat="server">
                                            <div class="page-header">
                                                <h2 class="fs-title">Close Trading account</h2>
                                            </div>
                                            <div class="form-group">
                                                <label for="tradingucc" class="col-sm-2" >Your UCC:</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="tradingucc" readonly="readonly" id="tradingucc" runat="server" value="" placeholder="UCC"  />
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="tradingname" class="control-label col-sm-2" >Sole/First Holder:</label>
                                                <div class="col-sm-10">
                                                  <input type="text" class="form-control" name="tradingname" readonly="readonly" id="tradingname" runat="server" value="" placeholder="Name"/>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="tradingLedgerbalance" class="control-label col-sm-2" >Ledger balance:</label>
                                                <div class="col-sm-10">
                                                  <input type="text" class="form-control" name="tradingLedgerbalance" readonly="readonly" id="tradingLedgerbalance" runat="server" value="" placeholder="NA"/>
                                                </div>
                                            </div>
                                            <textarea class="form-control" rows="3" id="tradingClosureReason" runat="server" placeholder="Reason for Closure"></textarea>
                                        </div>
                                        <input type="button" name="previous" class="previous action-button-previous" value="Previous"/>
                                        <input type="button" name="next" class="next action-button" id="btnTradingNext" value="Next Step"/>
                                    </fieldset>
                                    <fieldset>
                                        
                                        <div id="divdepositoryMsg" runat="server" style="display: none; height: 100%; width: 100%; text-align: center;">
						                    <h3><span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span> Depository account not selected!</h3>      
                                            <div class="alert alert-info" role="alert">
									           To select depository accounts just back to Previous step.
						                     </div>
				                        </div>
                                        <div class="form-card" id="divdepositorycard" runat="server">
                                            <div class="page-header">
                                                <h2 class="fs-title">Close Depository account</h2>      
                                            </div>
                                            
                                                <%=cDpDetailsHtml%>

                                        </div>

                                        <input type="button" name="previous" class="previous action-button-previous" value="Previous"/>
                                        <input type="button" name="next" id="btnDPNext" class="next action-button" value="Final Step"/>
                                        
                                    </fieldset>
                                    <fieldset>
                                        <div class="form-card">
                                            <div class="page-header">
                                            <h2 class="fs-title text-center" id="finalCardTitle">Legal terms and conditions</h2>
                                            </div>
                                            <br><br>
                                            <div class="row justify-content-center">
                                                <div class="col-8 text-center">
                                                    <div id="divTermsandconditions">
                                                        <%=termsandconditionsHTML%>
                                                        <input type="hidden" id="hdnLatitude" name="hdnLatitude" runat="server" value="">
                                                        <input type="hidden" id="hdnLongitude" name="hdnLongitude" runat="server" value="">
                                                        <input type="hidden" id="hdnTimestamp" name="hdnTimestamp" runat="server" value="">
                                                        <p id="divLocation" style="font-size:11px; font-weight:bold"></p>
                                                        <h4><input type="checkbox" name="terms" id="terms" onchange="activateButton(this)"> I Agree Terms & Coditions</h4>
                                                        <button type="button" class="btn btn-info btn-lg" id="btnPDFDownload" style="margin-top:5px" onclick="previewPDF();"><i class="fa fa-file-pdf" aria-hidden="true"></i> Preview PDF</button> 
                                                        <button type="button" class="btn btn-lg btn-danger btnpadingtop" runat="server" id="btnContinue" disabled="disabled" onclick="sendOTP()" style="margin-top:5px"><i class="fa fa-check" aria-hidden="true"></i> Continue to Close</button>
                                                    </div>
                                                    <div id="divLoading" runat="server" style="display:none">
                                                        <center>
                                                            <h3>Please wait..Your request is being processed..</h3>
                                                            <p>Do not close browser window....</p>
                                                            <img src="Loading.gif" alt="Loading" style="width:150px;">
                                                        </center>
                                                    </div>
                                                    <div style="display:none">
                                                        <input type="hidden" id="hdnBtnSubmiClicked" name="hdnBtnSubmiClicked" runat="server" value="">
                                                        <asp:Button ID="btnSubmit"  runat="server" OnClick="btnSubmit_Click" Text="" />
                                                    </div>
                                                    <div id="divOTP" runat="server" style="display:none">
                                                     <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                                                        <ContentTemplate>
                                                            <div id="divOTPValidate" runat="server" style="display:none">
                                                                <div class="row">
                                                                    <div class="col-sm-6">
                                                                        <span id="spanMsg" runat="server" style="color:green"></span>
                                                                        <span id="spanOTP" style="display:none" runat="server"></span>
                                                                        <br />
                                                                        <br />
                                                                        <input type="text" class="form-control" id="txtOTP" runat="server" placeholder="Enter OTP">
                                                                        <button type="button" class="btn btn-lg btn-success btnpadingtop" id="btnOTPValidate" onclick="validateOTP()"><i class="fa fa-share-square" aria-hidden="true"></i> Submit</button>
                                                                        <button type="button" class="btn btn-lg btn-primary btnpadingtop" id="btnOTPResend" onclick="sendOTP()"><i class="fa fa-repeat" aria-hidden="true"></i> Resend</button>
                                                                    </div>
                                                                    <div class="col-sm-6">
                                                                    </div>
                                                                </div>
                                                                
                                                            </div>
                                                            <div style="display:none">
                                                                <asp:Button ID="btnOTP"  runat="server" OnClick="btnOTP_Click" Text="" />
                                                                <input type="hidden" id="hdnBtnOTPClicked" name="hdnBtnOTPClicked" runat="server" value="">
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <br />
                                                                    <span id="spanOTPErrorMsg" style="color:red" runat="server"></span>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                </div>
                                                            </div>
                                                        </ContentTemplate>
                                                     </asp:UpdatePanel>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </fieldset>

                            </div>

                           
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
