﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="accountModification.aspx.cs" Inherits="Connect_DotNet.ReKYC.accountModification" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>Account Modification</title>
    <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <style>
        .btnpadingtop{
            margin-top:3px;
        }

        .btnBankPrimary{
            display:none;
        }
        .btnBankSecondary{
            display:block;
        }

        .PrimaryToPrimary{
            display:none;
        }
        .SecondaryToSecondary{
            display:none;
        }
        .PrimaryToSecondary{
            display:block;
        }
        .SecondaryToPrimary{
            display:block;
        }

        /* explanatory text style */
        .explanation
        {
            font-size:10pt;
        }

    </style>

   <!--  <script>
        
        window.onload = function Pageonload() {

            var parentUrl = window.parent.location.href;
            alert(parentUrl);
        } 
        

    </script>-->
    
    <script type="text/javascript">
        //window.onload = function () {
        //    alertImportantNotes('All');
        //}

        function disableTab(option) {

            if (document.getElementById('option' + option).checked == false) {
                document.getElementById(option).style = "display:none";
                document.getElementById('li'+option).style = "display:none";
                //$('#li'+option).addClass("disabled");
            }
            //else {
            //    activaTab(option);
            //}
        }

        function disableTabs() {

            disableTab(document.getElementById('optionAuthorizedRepresentative').value);
            disableTab(document.getElementById('optionSegments').value);
            disableTab(document.getElementById('optionIncomeRange').value);
            disableTab(document.getElementById('optionDDPI').value);
            disableTab(document.getElementById('optionNomination').value);
            disableTab(document.getElementById('optionDPDetails').value);
            disableTab(document.getElementById('optionBankDetails').value);
            disableTab(document.getElementById('optionDateofBirth').value);
            disableTab(document.getElementById('optionAddress').value);
            disableTab(document.getElementById('optionEmail').value);
            disableTab(document.getElementById('optionMobile').value);
        }

        function continueForchanges() {

            if (document.getElementById('optionMobile').checked == false &&
                document.getElementById('optionEmail').checked == false &&
                document.getElementById('optionAddress').checked == false &&
                document.getElementById('optionDateofBirth').checked == false &&
                document.getElementById('optionBankDetails').checked == false &&
                document.getElementById('optionDPDetails').checked == false &&
                document.getElementById('optionNomination').checked == false &&
                document.getElementById('optionDDPI').checked == false &&
                document.getElementById('optionIncomeRange').checked == false &&
                document.getElementById('optionSegments').checked == false &&
                document.getElementById('optionAuthorizedRepresentative').checked == false) {
                //alert("Please choose minimum one parameter that you need to be changed!");
                alertModal("Error - Option not selected", "Please choose minimum one parameter that you need to be changed!", "danger");
                return;
            }

            disableTabs();

            if (document.getElementById('optionMobile').checked == true ||
                document.getElementById('optionEmail').checked == true ||
                document.getElementById('optionAddress').checked == true ||
                document.getElementById('optionDateofBirth').checked == true) {

                if (document.getElementById('hdnDigiLockerModalOpen').value == "Yes") {

                    document.getElementById('hdnDigiLockerModalOpen').value = "";
                    $('#OpenDigiLockerModal').modal('show');

                }
            }

            $('#modalSelectChanges').modal('hide');

            //alert(document.getElementById('optionAuthorizedRepresentative').checked);
        }

        window.onload = function () {
            
            getLocation();

            if (document.getElementById('hdnBtnSubmitModificationRequestsClicked').value == "OpenSelectChangesModal") {
                document.getElementById('hdnBtnSubmitModificationRequestsClicked').value = "";
                $('#modalSelectChanges').modal('show');
            }

            if (document.getElementById('hdnBtnSubmitModificationRequestsClicked').value == "OpenDigiLockerModal") {

                document.getElementById('hdnBtnSubmitModificationRequestsClicked').value = "";
                $('#OpenDigiLockerModal').modal('show');
                
            }

            if (document.getElementById('hdnDigiLockerOpenTab').value != "" && document.getElementById('hdnDigiLockerOpenTab').value != "ok") {

                disableTabs();
                activaTab(document.getElementById('hdnDigiLockerOpenTab').value);
                document.getElementById('hdnDigiLockerOpenTab').value = "ok";

            }

            if (document.getElementById('hdnErrorMsgModalOpen').value != "") {
                
                const errorMsgModalOpenArray = document.getElementById('hdnErrorMsgModalOpen').value.split("####");
                var titleMsg = errorMsgModalOpenArray[0];
                var Msg = errorMsgModalOpenArray[1];

                alertModal(titleMsg, Msg);
                document.getElementById('hdnErrorMsgModalOpen').value = "";
                
                if (titleMsg.match("Error") == 'Error') {

                    //if (titleMsg.match("Location permission denied")=="Location permission denied") {
                    //    return;
                    //}

                    setTimeout(function () {
                        //location.reload();
                        location.replace("accountModification.aspx");
                    }, 5000);

                }
                //else {  //RISK DISCLOSURES ON DERIVATIVES

                //    setTimeout(function () {
                //        $('#RiskDisclosureAlertModal').modal('toggle');
                //    }, 5000);

                    
                    
                //}
                
                return;

            }

            if (document.getElementById('hdnBtnSubmitModificationRequestsClicked').value == "4") {
                showmodalTermsandConditions();
                document.getElementById('divTabcontent').style = "display:none";
                
            }



        }


        function getLocation() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(showPosition);

            } else {
                document.getElementById("divLocation").innerHTML = "Geolocation is not supported by this browser.";
            }
        }

        function showPosition(position) {

            let date = new Date(); // object of the date class

            let timestamp = ("0" + date.getDate()).slice(-2) + '-' + ("0" + (date.getMonth() + 1)).slice(-2) + '-' + date.getFullYear() + ' ' + date.toString().replace(/^.+(\d{2}:\d{2}:\d{2}.+)\(.+$/, "$1");


            document.getElementById("divLocation").innerHTML = "Latitude: " + position.coords.latitude +
                ", Longitude: " + position.coords.longitude +
                ", Timestamp: " + timestamp;


            document.getElementById("hdnLatitude").value = position.coords.latitude;
            document.getElementById("hdnLongitude").value = position.coords.longitude;
            document.getElementById("hdnTimestamp").value = timestamp;

        }

        function showmodalTermsandConditions() {

                document.getElementById('hdnBtnSubmitModificationRequestsClicked').value = "";
                document.getElementById('divLoading').style = "display:none";
                document.getElementById('modalTermsLabel').innerHTML = "Terms and Conditions";
                document.getElementById('divtermsandconditionsHTML').style = "display:block";
                document.getElementById('divSubmitBtns').style = "display:block";

                openTermsandConditions();
        }

        function alertImportantNotes(NotesType) {
            var Notes = "1. Aadhaar, Voter ID, etc document sould be scan both sides for upload. <br/>2. Uploading incompleted documents can be rejected your ReKYC request. <br/>3. Upload only <b>masked Aadhaar</b>(First 8 digits should be blocked or blackened. <br/>4. Signature images accepted only in JPG and PNG format.  <br/> 5. Documents files sould be uploaded in JPG, PNG and PDF format. ";

            if (NotesType == "Aadhaar") {
                Notes = "1. Aadhaar and Voter ID document sould be scan both sides for upload. <br/>2. Uploading incompleted documents can be rejected your ReKYC request. <br/>3. Upload only <b>masked Aadhaar</b>(First 8 digits should be blocked or blackened.<br/> 4. Documents files sould be uploaded in JPG, PNG and PDF format. "
            }

            if (NotesType == "Signature") {
                Notes = "1. Signature image accepted only in JPG and PNG format. <br/>2. Uploading incompleted documents can be rejected your ReKYC request. "
            }

            if (NotesType == "Other") {
                Notes = "1. Uploading incompleted documents can be rejected your ReKYC request. <br/>2. Documents files sould be uploaded in JPG, PNG and PDF format. "
            }

            alertModal("*Important Notes", Notes);
        }

    </script>

    <script>

        
        function addAccountModification(ModType) {
            //document.getElementById('divModificationRequests').style = "display:block";
            document.getElementById('linkFinalSubmission').style = "display:block";
            document.getElementById('divFinalSubmission').style = "display:block";
            document.getElementById('hdnModType').value = ModType;
            alertModal("Request added", ModType + " request added. After added all your changes. Please click on <b>Submit all Request</b> button for final submission");
            RefreshGrid();
            setTimeout(function() {$('#alert-modal').modal('hide');  $('.modal-backdrop').css('display', 'none');}, 2000);
            
        }

        function FinalSubmissionClick() {
            document.getElementById('hdnModType').value = 'NA';

            document.getElementById('divFinalSubmission').style = "display:none";
            activaTab('FinalSubmission');
            RefreshGrid();
            grdModificationRequests.Refresh();
            //alert('Please click on Submit all Request button for final submission. Submit multiple modifications in one request');
        }

        //function addAccountModification(title,details) {
        //    document.getElementById('divModificationRequests').style = "display:block";
        //    //document.getElementById('alertInfoMsg').style = "display:block";
        //    //document.getElementById('spanInfoMsg').innerHTML = "<strong>"+title+":</strong> " + details;
        //    document.getElementById('hdnModType').value = "UpdateMobile";
        //    RefreshGrid();
        //    //setTimeout(hideDivModificationRequests, 3000);
        //}

      

        function RefreshGrid() {
            grdModificationRequests.Refresh();
        }

        function AddRequest(ModType) {

            document.getElementById('hdnModType').value = "NA";

            if (ModType == "Add Authorized Representative") {

                if (document.getElementById('authorizedRepresentativeName').value == "") {
                    alertModal("Error - Authorized Representative", "Please enter Name!");
                    return;
                }

                if (document.getElementById('authorizedRepresentativeRelation').value == "") {
                    alertModal("Error - Authorized Representative", "Please enter Relation!");
                    return;
                }

                if (document.getElementById('authorizedRepresentativeDOB').value == "") {
                    alertModal("Error - Authorized Representative", "Please enter Date of Birth!");
                    return;
                }

                if (document.getElementById('cmbAuthorizedRepresentativeGender').value == "") {
                    alertModal("Error - Authorized Representative", "Please select Gender!");
                    return;
                }

                if (document.getElementById('authorizedRepresentativeNationality').value == "") {
                    alertModal("Error - Authorized Representative", "Please enter Nationality!");
                    return;
                }

                if (document.getElementById('authorizedRepresentativeAddress').value == "") {
                    alertModal("Error - Authorized Representative", "Please enter current address with pincode!");
                    return;
                }

                if (!IsMobileNumber(document.getElementById('authorizedRepresentativeMobile'))) {
                    return;
                }
                if (!ValidateEmail(document.getElementById('authorizedRepresentativeEmail'))) {
                    return;
                }
                

                //if (document.getElementById('authorizedRepresentativePassportSizePhotoFile').value == "") {
                //    alertModal("Error - Authorized Representative", "Please upload representative passport size photo file in JPG, PNG format!");
                //    return;
                //}

                if (validateFileExtensionByElementId("authorizedRepresentativePassportSizePhotoFile", "Authorized Representative passport size photo", "JPG,PNG,JPEG") == false) {
                    return;
                }

                //if (document.getElementById('authorizedRepresentativeSignatureImageFile').value == "") {
                //    alertModal("Error - Authorized Representative", "Please upload representative signature image file in JPG, PNG format!");
                //    return;
                //} 

                if (validateFileExtensionByElementId("authorizedRepresentativeSignatureImageFile", "Authorized Representative signature image", "JPG,PNG,JPEG") == false) {
                    return;
                }

                if (document.getElementById('authorizedRepresentativePanCard').value == "") {
                    alertModal("Error - Authorized Representative", "Please enter Pan Card!");
                    return;
                }

                // if (document.getElementById('authorizedRepresentativePANFile').value == "") {
                //    alertModal("Error - Authorized Representative", "Please upload representative PAN Copy file in JPG, PNG, PDF format!");
                //    return;
                //}

                if (validateFileExtensionByElementId("authorizedRepresentativePANFile", "Authorized Representative PAN card ", "JPG,PNG,JPEG,PDF") == false) {
                    return;
                }

                if (document.getElementById('authorizedRepresentativeAadhaar').value == "") {
                    alertModal("Error - Authorized Representative", "Please enter Aadhaar!");
                    return;
                }

                //if (document.getElementById('authorizedRepresentativeAadhaarFile').value == "") {
                //    alertModal("Error - Authorized Representative", "Please upload representative Aadhaar Copy file in JPG, PNG, PDF format!");
                //    return;
                //}

                if (validateFileExtensionByElementId("authorizedRepresentativeAadhaarFile", "Authorized Representative Aadhaar Copy", "JPG,PNG,JPEG,PDF") == false) {
                    return;
                }
                
                document.getElementById('divAuthorizedRepresentative').style = "display:none";

                addAccountModification(ModType);
                document.getElementById('btnAddAuthorizedRepresentative').disabled = true;

            }

            var isDigiLocker = false;

            if (document.getElementById('hdnDigiLockerOpenTab').value != "") {
                isDigiLocker = true;
            }


            if (ModType == "Update Address") {

                //if (document.getElementById('AddressProofFile').value == "") {
                //    alertModal("Error", "Please select client address proof file in JPG, PNG, PDF format!");
                //    return;
                //}
                if (isDigiLocker == false) {
                    if (validateFileExtensionByElementId("AddressProofFile", "Client address proof", "JPG,PNG,JPEG,PDF") == false) {
                        return;
                    }
                }

                if (document.getElementById('txtAddress1').value == "") {
                    alertModal("Error", "Please enter Address1!");
                    return;
                }

                if (document.getElementById('txtAddressCity').value == "") {
                    alertModal("Error", "Please enter City!");
                    return;
                }

                if (document.getElementById('txtAddressPincode').value == "") {
                    alertModal("Error", "Please enter Pincode!");
                    return;
                }

                if (document.getElementById('cmbAddressState').value == "") {
                    alertModal("Error", "Please enter State!");
                    return;
                }

                if (document.getElementById('chkCorrAddrSameAsPerm').checked == false) {

                    //if (document.getElementById('corrAddressProofFile').value == "") {
                    //    alertModal("Error", "Please select client correspondence address proof file in JPG, PNG, PDF format!");
                    //    return;
                    //}

                    
                    if (validateFileExtensionByElementId("corrAddressProofFile", "Client correspondence address proof", "JPG,PNG,JPEG,PDF") == false) {
                        return;
                    }
                    

                    if (document.getElementById('txtCorrAddress1').value == "") {
                        alertModal("Error", "Please enter Correspondence Address1!");
                        return;
                    }

                    if (document.getElementById('txtCorrAddressCity').value == "") {
                        alertModal("Error", "Please enter Correspondence Address City!");
                        return;
                    }

                    if (document.getElementById('txtCorrAddressPincode').value == "") {
                        alertModal("Error", "Please enter Correspondence Address Pincode!");
                        return;
                    }

                    if (document.getElementById('cmbCorrAddressState').value == "") {
                        alertModal("Error", "Please enter Correspondence Address State!");
                        return;
                    }

                }

                addAccountModification(ModType);
                document.getElementById('divAddress').style = "display:none";
                document.getElementById('btnAddressAdd').disabled = true;


            }

            if (ModType == "Update DOB") {

                if (isDigiLocker == false) {
                    if (validateFileExtensionByElementId("DOBProofFile", "Client Date of Birth proof", "JPG,PNG,JPEG,PDF") == false) {
                        return;
                    }
                }

                if (document.getElementById('dtDateofBirth').value == "") {
                    alertModal("Error", "Please enter your Date of Birth!");
                    return;
                }

                addAccountModification(ModType);
                document.getElementById('divDateofBirth').style = "display:none";
                document.getElementById('btnDOBAdd').disabled = true;
            }

            if (ModType == "Update Income Range") {

                if (validateFileExtensionByElementId("IncomeProofFile", "Client Income proof", "JPG,PNG,JPEG,PDF") == false) {
                    return;
                }

                //if (document.getElementById('cmbIncomeProof').value == "02") {
                //    if (validateFileExtensionByElementId("IncomeProofFile2", "Client Income proof", "JPG,PNG,JPEG,PDF") == false) {
                //        return;
                //    }
                //}
                

                if (document.getElementById('cmbIncomeRange').value == "") {
                    alertModal("Error", "Please select Income Range!");
                    return;
                }

                addAccountModification(ModType);
                document.getElementById('divIncomeRange').style = "display:none";
                document.getElementById('btnIncomeRangeAdd').disabled = true;
            }
            
             if (ModType == "Opt out of Nomination") {
                 addAccountModification(ModType);
                 document.getElementById('btnNomineeAddition').disabled = true;
                 document.getElementById('btnOptoutNomination').disabled = true;
                 document.getElementById('btnConfirmOptoutNominationModalYes').disabled = true;
                 document.getElementById('divNomination').style = "display:none";
                 //alert(ModType);
                 //FinalSubmissionClick();
                 $('#confirmOptoutNominationModal').modal('toggle');

                 document.getElementById('hdnNomResidualPercent').value = "";
            }

            if (ModType.match("Remove Nominee") == "Remove Nominee") {

                addAccountModification(ModType);

                document.getElementById('hdnNomineesAvailable').value = Number(document.getElementById('hdnNomineesAvailable').value) - 1;


                 if (document.getElementById('hdnNomineesAvailable').value >= 3) {

                    document.getElementById('btnNomineeAddition').disabled = true;
                    document.getElementById('btnOptoutNomination').disabled = true;
                    document.getElementById('btnConfirmOptoutNominationModalYes').disabled = true;
                    document.getElementById('divNomination').style = "display:none";

                    //FinalSubmissionClick();
                }

                //alert(document.getElementById('hdnModTypeValue').value.split("#")[0]);
                var exsistingNomineeShare = setNomineeExsistingShare(document.getElementById('hdnModTypeValue').value.split("#")[0]);

                //alert(exsistingNomineeShare);

                emptyNomineeShare(document.getElementById('hdnModTypeValue').value.split("#")[0]);

                document.getElementById('hdnNomResidualPercent').value = Number(document.getElementById('hdnNomResidualPercent').value) + exsistingNomineeShare;

                //alert(document.getElementById('hdnNomResidualPercent').value);
                $('#confirmRemoveNomineeModal').modal('toggle');

            }

            if (ModType == "Add Nominee" || ModType == "Update Nominee") {

                if (document.getElementById('txtNomName').value == "") {
                    alertModal("Error : Add/Update Nominee", "Please enter Nominee Name!");
                    return;
                }
                
                if (document.getElementById('txtNomPercent').value == ""|| document.getElementById('txtNomPercent').value == "0.00") {
                    alertModal("Error : Add/Update Nominee", "Please enter Nominee Percent 1 to 100!");
                    return;
                }

                //if (document.getElementById('txtNomPercent').value<1 || document.getElementById('txtNomPercent').value>100) {
                //    alertModal("Error : Add/Update Nominee", "Please enter Nominee Percent 1 to 100!");
                //    return;
                //}

                var NomResidualPercent = Number(document.getElementById('hdnNomResidualPercent').value);

                if (document.getElementById('hdnNomAvailablePercent').value != "" && ModType == "Update Nominee") {

                    NomResidualPercent = Number(document.getElementById('hdnNomResidualPercent').value) + Number(document.getElementById('hdnNomAvailablePercent').value);
                }

                if (document.getElementById('txtNomPercent').value < 1 || document.getElementById('txtNomPercent').value > NomResidualPercent) {

                    //alert(NomResidualPercent);

                    if (Number(NomResidualPercent) == 0) {
                        alertModal("Error : Add/Update Nominee", "Total 100 percent nominee share already completed!");
                        return;
                    }

                    alertModal("Error : Add/Update Nominee", "Please enter Nominee Percent 1 to " + NomResidualPercent);
                    return;
                }

                


                if (document.getElementById('txtNomAdd1').value == "") {
                    alertModal("Error : Add/Update Nominee", "Please enter Nominee Address1!");
                    return;
                }
                if (document.getElementById('txtNomPincode').value == "") {
                    alertModal("Error : Add/Update Nominee", "Please enter Nominee Pincode!");
                    return;
                }

                //alert(document.getElementById('cmbNomState').value);

                if (document.getElementById('cmbNomState').value == "") {
                    alertModal("Error : Add/Update Nominee", "Please select Nominee State!");
                    return;
                }

                if (document.getElementById('cmbNomCountry').value == "") {
                    alertModal("Error : Add/Update Nominee", "Please enter Nominee Country!");
                    return;
                }

                if (document.getElementById('txtNomIDNo').value == "") {
                    alertModal("Error : Add/Update Nominee", "Please enter valid document ID!");
                    return;
                }

                if (document.getElementById('txtNomMobile').value != "") {
                    if (!IsMobileNumber(document.getElementById('txtNomMobile')))
                        return;
                }
                
                if (document.getElementById('txtNomEmail').value != "") {
                    if (!ValidateEmail(document.getElementById('txtNomEmail')))
                        return;
                }

                //if (document.getElementById('spanNomDocAsyncFileUpload').innerHTML == "") {
                //    alertModal("Error : Add/Update Nominee", "Please upload proof of document!");
                //    return;
                //}

                if (validateFileExtensionByFileName(document.getElementById('spanNomDocAsyncFileUpload').innerHTML, "Nominee's id proof", "JPG,PNG,JPEG,PDF") == false) {
                    return;
                }
                
                
                if (document.getElementById('dtNomDateofBirth').value == "") {
                    alertModal("Error : Add/Update Nominee", "Please enter Nominee Date of Birth!");
                    return;
                }

                var enteredAge = getAge(document.getElementById('dtNomDateofBirth').value);

                if (enteredAge > 17 && document.getElementById('chkNomIsMinor').checked) {
                    alertModal("Error : Add/Update Nominee", "Date of Birth not valid! Nominee's age is not minor nominee! A nominee who is under the legal age that is 18 years of age is known as a minor nominee");
                    //document.getElementById('chkNomIsMinor').checked = false;
                    return
                }

                if (enteredAge < 18 && !document.getElementById('chkNomIsMinor').checked) {
                    alertModal("Error : Add/Update Nominee", "Date of Birth not valid! Nominee's age is minor nominee! A nominee who is under the legal age that is 18 years of age is known as a minor nominee. Please fill out minor nominee guardian details");
                   // document.getElementById('chkNomIsMinor').checked = true;
                    return
                }

                if (document.getElementById('chkNomIsMinor').checked) {

                    activaTab('ModalNomineeMinorGuardianTab');

                    if (document.getElementById('txtNomMinorGuardianName').value == "") {
                        alertModal("Error : Add/Update Nominee", "Please enter Minor Nominee Guardian Name!");
                        return;
                    }

                    if (document.getElementById('txtNomMinorGuardianAdd1').value == "") {
                        alertModal("Error : Add/Update Nominee", "Please enter Minor Nominee Guardian Address1!");
                        return;
                    }
                    if (document.getElementById('txtNomMinorGuardianPincode').value == "") {
                        alertModal("Error : Add/Update Nominee", "Please enter Minor Nominee Guardian Pincode!");
                        return;
                    }


                    if (document.getElementById('cmbNomMinorGuardianState').value == "") {
                        alertModal("Error : Add/Update Nominee", "Please select Minor Nominee Guardian State!");
                        return;
                    }

                    if (document.getElementById('cmbNomMinorGuardianCountry').value == "") {
                        alertModal("Error : Add/Update Nominee", "Please enter Minor Nominee Guardian Country!");
                        return;
                    }

                    if (document.getElementById('txtNomMinorGuardianIDNo').value == "") {
                        alertModal("Error : Add/Update Nominee", "Please enter Minor Nominee Guardian's valid document ID!");
                        return;
                    }

                    //if (document.getElementById('spanNomGuardianDocAsyncFileUpload').innerHTML == "") {
                    //    alertModal("Error : Add/Update Nominee", "Please upload Minor Nominee Guardian's id proof!");
                    //    return;
                    //}

                    if (validateFileExtensionByFileName(document.getElementById('spanNomGuardianDocAsyncFileUpload').innerHTML, "Minor Nominee Guardian's id proof", "JPG,PNG,JPEG,PDF") == false) {
                        return;
                    }

                    if (document.getElementById('txtNomMinorGuardianMobile').value != "") {
                        if (!IsMobileNumber(document.getElementById('txtNomMinorGuardianMobile')))
                            return;
                    }
                
                    if (document.getElementById('txtNomMinorGuardianEmail').value != "") {
                        if (!ValidateEmail(document.getElementById('txtNomMinorGuardianEmail')))
                            return;
                    }


                }

                if (ModType == "Add Nominee") {

                    document.getElementById('hdnNomineesAvailable').value = Number(document.getElementById('hdnNomineesAvailable').value) + 1;

                    if (document.getElementById('hdnAddNomineeValue').value == "") {

                        document.getElementById('hdnAddNomineeValue').value = 3;
                    }

                    document.getElementById('hdnAddNomineeValue').value = Number(document.getElementById('hdnAddNomineeValue').value) + 1;



                }
                else {

                    emptyNomineeShare(document.getElementById('hdnModTypeValue').value);
                }


                document.getElementById('hdnNomResidualPercent').value = Number(NomResidualPercent) - Number(document.getElementById('txtNomPercent').value);

                


                //if (Number(document.getElementById('hdnNomResidualPercent').value)>0) {

                //    alertModal("Alert : " + document.getElementById('hdnNomResidualPercent').value + " percent nominations residual share available",
                //    "Summation of nomination percentage among nominees should be 100.<br/> Available <b>" + document.getElementById('hdnNomResidualPercent').value + " percent residual share</b> automatically will be add to your <b>1st Nominee</b> if you not add any other Nominee");
                //    return;

                //}
                

                ModType = ModType + ": " + document.getElementById('txtNomName').value;

                //alert(document.getElementById('hdnNomineesAvailable').value);

                addAccountModification(ModType);
                grdNominees.Refresh();

                //alert(document.getElementById('hdnNomineesAvailable').value);
                
                if (document.getElementById('hdnNomineesAvailable').value >= 3) {
                    //alert(2);
                    document.getElementById('btnNomineeAddition').disabled = true;
                    document.getElementById('btnOptoutNomination').disabled = true;
                    document.getElementById('btnConfirmOptoutNominationModalYes').disabled = true;
                    document.getElementById('divNomination').style = "display:none";

                    //FinalSubmissionClick();
                }

                document.getElementById('btnOptoutNomination').disabled = true;
                document.getElementById('btnConfirmOptoutNominationModalYes').disabled = true;

                $('#AddEditNomineeModal').modal('toggle');


            }
            
            if (ModType == "Add Bank") {

                
                if (document.getElementById('selectBankType').value == "") {
                    alertModal("Error", "Please select bank a/c Type!");
                    return;
                }

                if (document.getElementById('cmbBanks') == null || document.getElementById('txtBankIFSC') == "") {
                    alertModal("Error", "Please provide a valid IFSC Code! for Search your Bank!");
                    return;
                }

                if (document.getElementById('cmbBanks').value == "") {
                    alertModal("Error", "IFSC Code not found in our database! Please provide a valid IFSC Code!");
                    return;
                }

                if (document.getElementById('txtBankAcNo').value == "") {
                    alertModal("Error", "Please enter your bank account number!");
                    return;
                }

                if (document.getElementById('hdnBankValidation').value != "") {
                    $('#modalLoading').modal('show');
                    document.getElementById('btnFindBank').click();
                    return;
                }

                if (document.getElementById('txtBankAcName').value == "") {
                    alertModal("Error", "Please enter your bank account name!");
                    return;
                }
                
                if (document.getElementById('selectBankValidationType').value == "") {
                    alertModal("Error", "Please select how to validate your bank a/c!");
                    return;
                }

                if (validateFileExtensionByFileName(document.getElementById('spanBankValidationAsyncFileUpload').innerHTML, "Bank validation file (Canceled Cheque/Bank Statement/Passbook 1st Page)", "JPG,PNG,JPEG,PDF") == false) {
                    return;
                }


                //alert(document.getElementById('txtBankIFSC').value);
                //alert(document.getElementById('cmbBanks').value);

                document.getElementById('hdnBankAvailable').value = Number(document.getElementById('hdnBankAvailable').value) + 1;

                ModType = ModType + ": " + $("#cmbBanks option:selected").text() + "| AcNo -" + document.getElementById('txtBankAcNo').value;
                addAccountModification(ModType);
                grdBanks.Refresh();
                $('#AddEditBankModal').modal('toggle');

               // document.getElementById('btnAddNewBank').disabled = true;

            }

            if (ModType.match("Remove Bank") == "Remove Bank") {
                addAccountModification(ModType);
                document.getElementById('hdnBankAvailable').value = Number(document.getElementById('hdnBankAvailable').value) - 1;
                $('#confirmRemoveBankModal').modal('toggle');

                //FinalSubmissionClick();

            }

            if (ModType == "Add DP") {

                 if (document.getElementById('selectDPType').value == "") {
                    alertModal("Error", "Please select DP Type!");
                    return;
                }
                
                if (document.getElementById('txtDPName').value == "") {
                    alertModal("Error", "Please enter DP Name!");
                    return;
                }

                if (document.getElementById('txtDPID').value == "") {
                    alertModal("Error", "Please enter DPID!");
                    return;
                }

                if (document.getElementById('txtDPClientID').value == "") {
                    alertModal("Error", "Please enter ClientID!");
                    return;
                }

                if (document.getElementById('spanDPClientMasterAsyncFileUpload').innerHTML != "") {

                    if (validateFileExtensionByFileName(document.getElementById('spanDPClientMasterAsyncFileUpload').innerHTML, "DP Client Master", "JPG,PNG,JPEG,PDF") == false) {
                        return;
                    }
                }

                ModType = ModType + ": " + document.getElementById('txtDPID').value + document.getElementById('txtDPClientID').value;
                addAccountModification(ModType);
                grdDP.Refresh();
                $('#AddDPModal').modal('toggle');

            }
        }
        
        function verificationThenAddBank(ModType) {

            $('#modalLoading').modal('hide');
            setTimeout(function () { $('#alert-modal').modal('hide'); }, 1500);

            document.getElementById('hdnBankAvailable').value = Number(document.getElementById('hdnBankAvailable').value) + 1;
            addAccountModification(ModType);
            grdBanks.Refresh();
            $('#AddEditBankModal').modal('toggle');
        }

        function getAge(DOB) {
            var today = new Date();
            var birthDate = new Date(DOB);
            var age = today.getFullYear() - birthDate.getFullYear();
            var m = today.getMonth() - birthDate.getMonth();
            if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
                age--;
            }
            return age;
        }

        function optoutNomineeAlert() {

            //if (document.getElementById('hdnNomineesAvailable').value == 0) {
            //    alertModal("Error", "You have no existing nominee for Opt Out");
            //    return;
            //}

            $('#confirmOptoutModalbody').html("<h4>Do you really want to Opt-out of Nomination?</h4>");
            $('#confirmOptoutNominationModal').modal('toggle');

        }

        

        function setNomineeExsistingShare(NomineeNo) {

            var exsistingNomineeShare = 0;

            if (NomineeNo == "1") {
                exsistingNomineeShare = Number(document.getElementById('hdnNominee1Share').value);
            }
            if (NomineeNo == "2") {
                exsistingNomineeShare = Number(document.getElementById('hdnNominee2Share').value);
            }
            if (NomineeNo == "3") {
                exsistingNomineeShare = Number(document.getElementById('hdnNominee3Share').value);
            }

            return exsistingNomineeShare;

        }

        function emptyNomineeShare(NomineeNo) {

            if (NomineeNo == "1") {
                document.getElementById('hdnNominee1Share').value = "";
            }

            if (NomineeNo == "2") {
                document.getElementById('hdnNominee2Share').value = "";
            }

            if (NomineeNo == "3") {
                document.getElementById('hdnNominee3Share').value = "";
            }

        }

        function addNomineePopup() {

            if (document.getElementById('hdnNomineesAvailable').value>=3) {
                alertModal("Error : Add Nominee", "Maximum 3 nominees can be allowed! For add new nominee you need to remove old nominee then add <br/><br/> Or you can also edit existing nominee with new data");
                return;
            }


            //alert(document.getElementById('hdnNomineesAvailable').value);

            document.getElementById('hdnNomineeMode').value = "Add";

            document.getElementById('AddEditNomineeModalHeader').innerHTML = "<i class=\"fa fa-user-plus\" aria-hidden=\"true\"></i> Add Nominee";

            // Clean existing file data
            //-----------------------------------------------
            //document.getElementById('hdnNomDocAsyncFileUpload').value = "";
            //document.getElementById('hdnNomGuardianDocAsyncFileUpload').value = "";
            document.getElementById('spanNomDocAsyncFileUpload').innerHTML = "";
            document.getElementById('spanNomGuardianDocAsyncFileUpload').innerHTML = "";

            //------------------------------------------------

            document.getElementById('txtNomName').value = "";
            document.getElementById('selectNomPrefix').value = "";
            document.getElementById('txtNomRelation').value = "";

            document.getElementById('txtNomPercent').value = document.getElementById('hdnNomResidualPercent').value;

            if (document.getElementById('hdnNomineesAvailable').value == 2) {
                document.getElementById('txtNomPercent').readOnly = true;
            }

            document.getElementById('txtNomAdd1').value = "";
            document.getElementById('txtNomAdd2').value = "";
            document.getElementById('txtNomAdd3').value = "";
            document.getElementById('txtNomCity').value = "";
            document.getElementById('txtNomPincode').value = "";
            setSelectedValue(document.getElementById('cmbNomState'), "");
            setSelectedValue(document.getElementById('cmbNomCountry'), "IN");
            document.getElementById('txtNomMobile').value = "";
            document.getElementById('txtNomPhone').value = "";
            document.getElementById('txtNomEmail').value = "";
            setSelectedValue(document.getElementById('cmbNomIdType'), "");
            document.getElementById('txtNomIDNo').value = "";
            document.getElementById('chkNomIsMinor').checked = false;
            document.getElementById('dtNomDateofBirth').value = "";
            document.getElementById('selectNomMinorGuardianPrefix').value = "";
            document.getElementById('txtNomMinorGuardianName').value = "";
            document.getElementById('txtNomMinorGuardianRelation').value = "";
            document.getElementById('txtNomMinorGuardianAdd1').value = "";
            document.getElementById('txtNomMinorGuardianAdd2').value = "";
            document.getElementById('txtNomMinorGuardianAdd3').value = "";
            document.getElementById('txtNomMinorGuardianCity').value = "";
            document.getElementById('txtNomMinorGuardianPincode').value = "";
            setSelectedValue(document.getElementById('cmbNomMinorGuardianState'), "");
            setSelectedValue(document.getElementById('cmbNomMinorGuardianCountry'), "IN");
            document.getElementById('txtNomMinorGuardianMobile').value = "";
            document.getElementById('txtNomMinorGuardianPhone').value = "";
            document.getElementById('txtNomMinorGuardianEmail').value = "";
            setSelectedValue(document.getElementById('cmbNomMinorGuardianIdType'), "");
            document.getElementById('txtNomMinorGuardianIDNo').value = "";

            document.getElementById('divAddEditNomineeModalFooter').innerHTML =
                "<button type=\"button\" class=\"btn btn-primary\" onclick=\"AddRequest('Add Nominee')\">Add Request</button>" +
                "<button type=\"button\" class=\"btn btn-danger\" data-dismiss=\"modal\">Cancel</button>";
            
            $('#AddEditNomineeModal').modal('toggle');

        }

        function updateNomineePopup(NomineeNo, Date, Prefix, Descr, Percent, Relation, Add1, Add2, Add3, City, Pincode, State, Country, Mobile, Phone, Email, IdType, IdNumber, IsMinor, DOB, GdPrefix, GdDescr, GdRelation, GdAdd1, GdAdd2, GdAdd3, GdCity, GdPincode, GdState, GdCountry, GdMobile, GdPhone, GdEmail, GdIdType, GdIdNumber)
        {
            //alert(Descr + NomineeNo);
            document.getElementById('AddEditNomineeModalHeader').innerHTML = "<i class=\"fa fa-user-edit\" aria-hidden=\"true\"></i> Edit Nominee";
            document.getElementById('hdnNomineeMode').value = "Update";

             // Clean existing file data
            //-----------------------------------------------
            //document.getElementById('hdnNomDocAsyncFileUpload').value = "";
            //document.getElementById('hdnNomGuardianDocAsyncFileUpload').value = "";
            document.getElementById('spanNomDocAsyncFileUpload').innerHTML = "";
            document.getElementById('spanNomGuardianDocAsyncFileUpload').innerHTML = "";
            
            //------------------------------------------------

            document.getElementById('hdnModTypeValue').value = NomineeNo;
            document.getElementById('txtNomName').value = Descr;
            document.getElementById('selectNomPrefix').value = Prefix;
            document.getElementById('txtNomRelation').value = Relation;
            document.getElementById('txtNomPercent').value = Percent;
            document.getElementById('hdnNomAvailablePercent').value = Percent;

            if (document.getElementById('hdnNomineesAvailable').value == 2 || document.getElementById('txtNomPercent').value=="") {
                document.getElementById('txtNomPercent').value = document.getElementById('hdnNomResidualPercent').value;
            }

            //if (document.getElementById('hdnNomineesAvailable').value == 2) {
            //    document.getElementById('txtNomPercent').readOnly = true;
            //}
            

            document.getElementById('txtNomAdd1').value = Add1;
            document.getElementById('txtNomAdd2').value = Add2;
            document.getElementById('txtNomAdd3').value = Add3;
            document.getElementById('txtNomCity').value = City;
            document.getElementById('txtNomPincode').value = Pincode;
            setSelectedValue(document.getElementById('cmbNomState'), State);
            setSelectedValue(document.getElementById('cmbNomCountry'), Country);
            document.getElementById('txtNomMobile').value = Mobile;
            document.getElementById('txtNomPhone').value = Phone;
            document.getElementById('txtNomEmail').value = Email;
            setSelectedValue(document.getElementById('cmbNomIdType'), IdType);
            document.getElementById('txtNomIDNo').value = IdNumber;

            if (IsMinor == "True") {
                document.getElementById('chkNomIsMinor').checked = true;
            }
            
            document.getElementById('dtNomDateofBirth').value = DOB;
            document.getElementById('selectNomMinorGuardianPrefix').value = GdPrefix;
            document.getElementById('txtNomMinorGuardianName').value = GdDescr;
            document.getElementById('txtNomMinorGuardianRelation').value = GdRelation;
            document.getElementById('txtNomMinorGuardianAdd1').value = GdAdd1;
            document.getElementById('txtNomMinorGuardianAdd2').value = GdAdd2;
            document.getElementById('txtNomMinorGuardianAdd3').value = GdAdd3;
            document.getElementById('txtNomMinorGuardianCity').value = GdCity;
            document.getElementById('txtNomMinorGuardianPincode').value = GdPincode;
            setSelectedValue(document.getElementById('cmbNomMinorGuardianState'), GdState);
            setSelectedValue(document.getElementById('cmbNomMinorGuardianCountry'), GdCountry);
            document.getElementById('txtNomMinorGuardianMobile').value = GdMobile;
            document.getElementById('txtNomMinorGuardianPhone').value = GdPhone;
            document.getElementById('txtNomMinorGuardianEmail').value = GdEmail;
            setSelectedValue(document.getElementById('cmbNomMinorGuardianIdType'), GdIdType);
            document.getElementById('txtNomMinorGuardianIDNo').value = GdIdNumber;



            document.getElementById('divAddEditNomineeModalFooter').innerHTML =
                "<button type=\"button\" class=\"btn btn-success\" onclick=\"AddRequest('Update Nominee')\">Add Request</button>" +
                "<button type=\"button\" class=\"btn btn-danger\" data-dismiss=\"modal\">Cancel</button>";

            


            $('#AddEditNomineeModal').modal('toggle');
        }

        
        function setSelectedValue(selectObj, valueToSet) {
            for (var i = 0; i < selectObj.options.length; i++) {
                //alert(selectObj.options[i].value);
                //alert(valueToSet);
                if (selectObj.options[i].value == valueToSet) {
                    //alert('match');
                    selectObj.options[i].selected = true;
                    return;
                }
            }
        }

        function activaTab(tab){
          $('.nav-tabs a[href="#' + tab + '"]').tab('show');
        };

        function setAdressDataFetchFromDigiLocker(isAddressFetchdigilocker) {

            if (isAddressFetchdigilocker == true) {
                document.getElementById('txtAadhaarAddress').style = "display:block";
                document.getElementById('btnDigiLockerFetchdataAddress').style = "display:block";
            }
            else {
                document.getElementById('txtAadhaarAddress').style = "display:none";
                document.getElementById('btnDigiLockerFetchdataAddress').style = "display:none";
            }

        }

        function fetchAdressDataFromDigiLocker() {

            if (document.getElementById('txtAadhaarAddress').value == "" || document.getElementById('txtAadhaarAddress').value.length!=12) {
                alertModal("Error", "Please enter 12 digit Aadhaar number to fetch your address details using digilocker!");
                return;
            }


            document.getElementById('txtAddress1').value = "15/24, Brahmapur NathPara";
            document.getElementById('txtAddress2').value = "PO-Garia";
            document.getElementById('txtAddress3').value = "PS-Banshdrani";
            document.getElementById('txtAddressCity').value = "Kolkata";
            document.getElementById('txtAddressPincode').value = "700084";
            document.getElementById('cmbAddressState').value = "WB";

        }

        function alertModal(title, body) {
            // Display error message to the user in a modal
            $('#alert-modal-title').html(title);
            $('#alert-modal-body').html(body);

            if (title.match("Error") == "Error") {
                $('#alert-modal-body').addClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-success");
            }

            else if (title == "Request added" || title == "Success") {
                $('#alert-modal-body').addClass("alert-success");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
            }
            else {
                $('#alert-modal-body').addClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-success");
            }

            $('#modalLoading').modal('hide');
            $('#alert-modal').modal('show');
        }

        function removeNomineeAlert(NomineeNo, Name) {

            if ( document.getElementById('hdnNomineesAvailable').value=="1" || document.getElementById('hdnNomineesAvailable').value =="0") {
                //You have to keep at least one nominee or maximum three nominees. If there is no nominee in your account then, your request will be accepted as Nominee Opt-out Request
                $('#confirmOptoutModalbody').html("You have to keep at least one nominee or maximum three nominees. If there is no nominee in your account then, your request will be accepted as Nominee Opt-out Request. <br/><br/> <h4>Do you really want to Opt-out of Nomination?</h4>");
                $('#confirmOptoutNominationModal').modal('toggle');
                return;
            }
            
            $('#confirmRemoveNomineeModalHeader').html("Remove Nominee " + NomineeNo);
            $('#confirmRemoveNomineeModalbody').html("Do you really want to remove nominee " + NomineeNo + " - " + Name + "?");
            $('#confirmRemoveNomineeModal').modal('show');
            document.getElementById("hdnRemoveNomineeNo").value = NomineeNo;
            document.getElementById("hdnRemoveNomineeName").value = Name;

            //document.getElementById("btnRemoveNomineeModalYes").addEventListener("click", removeNominee(NomineeNo, Name));
            
        }

        function removeNominee(NomineeNo, Name) {

            document.getElementById('hdnModTypeValue').value = NomineeNo + "#" + Name;
            AddRequest("Remove Nominee" + NomineeNo);
            grdNominees.Refresh();
        }

        function addBankPopup() {

            document.getElementById('AddEditBankModalHeader').innerHTML = "<i class=\"fa fa-university\" aria-hidden=\"true\"></i> Add Bank";

            document.getElementById('selectBankType').value = "Secondary";

            if (document.getElementById('cmbBanks') != null && document.getElementById('txtBankIFSC') != "") {
                setSelectedValue(document.getElementById('cmbBanks'), "");
            }

            document.getElementById('txtBankAcName').value = "";
            document.getElementById('txtBankIFSC').value = "";
            document.getElementById('txtBankAcNo').value = "";
            document.getElementById("spanBankValidationAsyncFileUpload").innerHTML = "";

            document.getElementById('divAddEditBankModalFooter').innerHTML =
                "<button type=\"button\" class=\"btn btn-primary\" onclick=\"AddRequest('Add Bank')\">Add Request</button>" +
                "<button type=\"button\" class=\"btn btn-danger\" data-dismiss=\"modal\">Cancel</button>";
            
            $('#AddEditBankModal').modal('toggle');
        }

        function addDPPopup() {
            document.getElementById("txtDPID").value = "";
            //document.getElementById("txtDPClientID").value = "";
            document.getElementById("txtDPClientID").value = Math.floor(Math.random() * 100000000);
            document.getElementById("txtDPName").value = "";
            document.getElementById("selectDPType").value = "Secondary";
            document.getElementById("spanDPClientMasterAsyncFileUpload").innerHTML = "";

            $('#AddDPModal').modal('toggle');
        }

        function setPrimaryBankPopup(TYPE,BankName,MICR,RTGS,bankAcNo,CLIENTNAME) {

            
            if (TYPE == "Secondary") {
                alertModal("Change this Bank type as Primary", "Your available primary Bank will be automatically changed as <b>secondary</b>");
            }

            document.getElementById("txtPrimaryBankName").value = BankName;
            document.getElementById("txtPrimaryBankAcNo").value = bankAcNo

            $('#confirmSetPrimaryBankModal').modal('show');
        }

        function setPrimaryBank() {

            //AddRequest("Set Primary Bank : " + document.getElementById("txtPrimaryBankName").value + "|" + document.getElementById("txtPrimaryBankAcNo").value);
            addAccountModification("Set Primary Bank : " + document.getElementById("txtPrimaryBankName").value + "|" + document.getElementById("txtPrimaryBankAcNo").value);
            grdBanks.Refresh();
        }

        function removeBankAlert(bankType, bankAcNo, BankName) {

             if (document.getElementById('hdnBankAvailable').value == "1" || document.getElementById('hdnBankAvailable').value == "0") {
                 //You have to keep at least one Bank
                 alertModal("Error : Remove bank account", "You have to keep at least one bank? To remove your only one bank account, you must add a new account and set it as your primary account, then remove the old one");
                 return;
            }

            if (bankType=="Primary") {
                 alertModal("Error : Remove primary bank account", "You can't remove your primary bank account? To remove your primary bank account, you must set another bank account as your primary account, then remove the old one");
                 return;
            }

            //if (bankType=="Primary") {
            //     alertModal("Alert : Remove primary bank account", "Please select your primary bank account");
            //}

            
            $('#confirmRemoveBankModalHeader').html("Remove Bank");
            $('#confirmRemoveBankModalbody').html("Do you really want to remove Bank " + BankName + " - Acno: " + bankAcNo + "?");

            document.getElementById("hdnRemoveBankAcNo").value = bankAcNo;
            document.getElementById("hdnRemoveBankName").value = BankName;

            $('#confirmRemoveBankModal').modal('show');

            
            
        }

        function removeBank(bankAcNo, BankName) {

            AddRequest("Remove Bank : "+ BankName + "|" + bankAcNo);
            grdBanks.Refresh();
        }


        function setPrimaryDPPopup(TYPE,DPID,CLIENTID,DPName) {

            if (TYPE == "Primary") {
                alertModal("Change this DP type as Primary", "Your available primary DP will be automatically changed as <b>secondary</b>");
            }

            document.getElementById("txtSetPrimaryDPName").value = DPName;
            document.getElementById("txtSetPrimaryDPID").value = DPID
            document.getElementById("txtSetPrimaryDPClientID").value = CLIENTID;
            document.getElementById("hdnSetPrimaryDPID").value = DPID;

            $('#confirmSetPrimaryDPModal').modal('show');
        }

        function SetPrimaryDP() {

            addAccountModification("Set Primary DP : " + document.getElementById("txtSetPrimaryDPName").value + "|" + document.getElementById("txtSetPrimaryDPID").value+ "|" + document.getElementById("txtSetPrimaryDPClientID").value);
            grdDP.Refresh();
        }

    </script>

    

</head>
<body>
    <script type="text/JavaScript">

        function ContinueDigiLocker(Type) {


            if (Type == 'DigiLocker') {

                //alert(document.getElementById('optionAuthorizedRepresentative').checked);
                document.getElementById('hdnBtnSubmitModificationRequestsClicked').value = Type;
                document.getElementById('<%= btnSubmitModificationRequests.UniqueID %>').click();

            }
            else {
                $('#OpenDigiLockerModal').modal('hide');
            }
        }

            <!-- Begin
            function TestFileType( fileName, fileTypes ) {
            if (!fileName) return;

            dots = fileName.split(".")
            //get the part AFTER the LAST period.
            fileType = "." + dots[dots.length-1];

            return (fileTypes.join(".").indexOf(fileType) != -1) ?
            alert('That file is OK!') : 
            alert("Please only upload files that end in types: \n\n" + (fileTypes.join(" .")) + "\n\nPlease select a new file and try again.");
            }
            // -->

        //TestFileType(this.form..uploadfile.value, ['gif', 'jpg', 'png', 'jpeg']);
    </script>
    <script type="text/javascript" lang="javascript">

        function selectSegmentsType(chbxSegmentsType) {

            //alert(chbxSegmentsType.value);
            //alert(chbxSegmentsType.checked);

            var segmentsCheckBoxList = document.getElementById('<%= chblSegments.ClientID %>');

            for (var i = 0; i < segmentsCheckBoxList.getElementsByTagName("input").length; i++) {


                var segmentValue = segmentsCheckBoxList.getElementsByTagName("span")[i].getAttribute("data-value");

                const segmentValueArray = segmentValue.split("#");
                var cSystem = segmentValueArray[0].trim();
                var cCo = segmentValueArray[1].trim();
                var cStatus = segmentValueArray[2].trim();
                var segment = segmentValueArray[3].trim();
                var realExchange = segmentValueArray[4].trim();


                if (chbxSegmentsType.value == segment) {
                    segmentsCheckBoxList.getElementsByTagName("input")[i].checked = chbxSegmentsType.checked;

                    setExchangesValue(chbxSegmentsType, realExchange);
                }



            }

            addParaToExchangesSpan(chbxSegmentsType);

        }

        function setExchangeValueToSpan(chbxSegmentsType, realExchange, spanExchange) {

            if (chbxSegmentsType.checked == true) {

                var exchangeValue = spanExchange.innerHTML + ", " + realExchange;
                let re = /(^,)\s(.+$)/;
                spanExchange.innerHTML = exchangeValue.replace(re, "$2");
            }
            else {
                spanExchange.innerHTML = "";
            }
        }

        function setExchangesValue(chbxSegmentsType, realExchange) {

            if (chbxSegmentsType.value == "Equity") {
                setExchangeValueToSpan(chbxSegmentsType, realExchange, document.getElementById('spanEquityExchange'));
            }

            else if (chbxSegmentsType.value == "Derivative") {
                setExchangeValueToSpan(chbxSegmentsType, realExchange, document.getElementById('spanDerivativeExchange'));
            }
            else if (chbxSegmentsType.value === "Currency") {
                setExchangeValueToSpan(chbxSegmentsType, realExchange, document.getElementById('spanCurrencyExchange'));
            }
            else if (chbxSegmentsType.value == "Commodity") {
                setExchangeValueToSpan(chbxSegmentsType, realExchange, document.getElementById('spanCommodityExchange'));
            }
            else if (chbxSegmentsType.value == "MF") {
                setExchangeValueToSpan(chbxSegmentsType, realExchange, document.getElementById('spanMFExchange'));
            }

            else if (chbxSegmentsType.value == "SLB") {
                setExchangeValueToSpan(chbxSegmentsType, realExchange, document.getElementById('spanSLBExchange'));
            }


        }

        function addParaToUperControl(Control) {
            if (Control.innerHTML != "") {
                Control.innerHTML = "<p>&nbsp;&nbsp;&nbsp;&nbsp;" + Control.innerHTML + "</p>";
            }
            else {
                Control.innerHTML = "";
            }
        }

         function addParaToExchangesSpan(chbxSegmentsType) {

             if (chbxSegmentsType.value == "Equity") {
                 addParaToUperControl(document.getElementById('spanEquityExchange'));
            }

             else if (chbxSegmentsType.value == "Derivative") {
                 addParaToUperControl(document.getElementById('spanDerivativeExchange'));
            }
             else if (chbxSegmentsType.value === "Currency") {
                 addParaToUperControl(document.getElementById('spanCurrencyExchange'));
            }
             else if (chbxSegmentsType.value == "Commodity") {
                 addParaToUperControl(document.getElementById('spanCommodityExchange'));
            }
             else if (chbxSegmentsType.value == "MF") {
                 addParaToUperControl(document.getElementById('spanMFExchange'));
            }

             else if (chbxSegmentsType.value == "SLB") {
                 addParaToUperControl(document.getElementById('spanSLBExchange'));
            }


        }

        function selectSegment() {
            
            selectSegmentsType(document.getElementById('checkEquity'));
            selectSegmentsType(document.getElementById('checkDerivative'));
            selectSegmentsType(document.getElementById('checkCurrency'));
            selectSegmentsType(document.getElementById('checkCommodity'));

            selectSegmentsType(document.getElementById('checkMF'));
            selectSegmentsType(document.getElementById('checkSLB'));


        }



        function checkDerivativesSegments() {

            
            var segmentsCheckBoxList = document.getElementById('<%= chblSegments.ClientID %>');

            //system = 'NFO' THEN 'NSE-FO'
            //system = 'BFO' THEN 'BSE-FO'
            //system = 'CNFO' THEN 'NSE-CDS'
            //system = 'CBFO' THEN 'BSE-CDS'
            //system = 'MCFO' THEN 'MCX'
            //system = 'NFOCOM' THEN 'NSE-COMM'
            //system = 'BFOCOM' THEN 'BSE-COMM'

            var NFO = false;
            var BFO = false;
            var CNFO = false;
            var CBFO = false;
            var MCFO = false;
            var NFOCOM = false;
            var BFOCOM = false;

            for (var i = 0; i < segmentsCheckBoxList.getElementsByTagName("input").length; i++) {

                //alert(segmentsCheckBoxList.getElementsByTagName("input")[i].checked);
                //alert(segmentsCheckBoxList.getElementsByTagName("input")[i].value);
                //alert(segmentsCheckBoxList.getElementsByTagName("span")[i].getAttribute("data-value"));

                var segmentValue = segmentsCheckBoxList.getElementsByTagName("span")[i].getAttribute("data-value");
                
                const segmentValueArray = segmentValue.split("#");
                var cSystem = segmentValueArray[0].trim();
                var cCo = segmentValueArray[1].trim();
                var cStatus = segmentValueArray[2].trim();


                if (cStatus != "Active" && cSystem == "NFO" && segmentsCheckBoxList.getElementsByTagName("input")[i].checked) {
                    NFO = true;
                }
                else if (cStatus != "Active" && cSystem == "BFO" && segmentsCheckBoxList.getElementsByTagName("input")[i].checked) {
                    BFO = true;
                }
                else if (cStatus != "Active" && cSystem == "CNFO" && segmentsCheckBoxList.getElementsByTagName("input")[i].checked) {
                    CNFO = true;
                }
                else if (cStatus != "Active" && cSystem == "CBFO" && segmentsCheckBoxList.getElementsByTagName("input")[i].checked) {
                    CBFO = true;
                }
                else if (cStatus != "Active" && cSystem == "MCFO" && segmentsCheckBoxList.getElementsByTagName("input")[i].checked) {
                    MCFO = true;
                }
                else if (cStatus != "Active" && cSystem == "NFOCOM" && segmentsCheckBoxList.getElementsByTagName("input")[i].checked) {
                    NFOCOM = true;
                }
                else if (cStatus != "Active" && cSystem == "BFOCOM" && segmentsCheckBoxList.getElementsByTagName("input")[i].checked) {
                    BFOCOM = true;
                }
                //else if (segmentValue.match("BFOCOM") == "BFOCOM" && segmentsCheckBoxList.getElementsByTagName("input")[i].checked) {
                //    BFOCOM = true;
                //}
            }


            var isDerivativesSegments = (NFO == true || BFO == true || CNFO == true || CBFO == true || MCFO == true || NFOCOM == true || BFOCOM == true);

            //alert(isDerivativesSegments);

            if (isDerivativesSegments == true) {

                if ((NFO == true || BFO == true) && document.getElementById('checkDerivative').checked == true) {
                    $('#RiskDisclosureAlertModal').modal('toggle');
                }
                

                setTimeout(function () {
                        $('#uploadDerivativesDocumentsModal').modal('toggle');
                    }, 2000);
                
            }


            return isDerivativesSegments;

        }

        function validateFileExtensionByElementId(fileElementId, ElementType, fileTypes) {

            var fileElement = document.getElementById(fileElementId)
            var fileElementFileName = "";

            if (fileElement.value != "") {
                fileElementFileName = fileElement.files.item(0).name.toUpperCase();
            }

            return validateFileExtensionByFileName(fileElementFileName, ElementType, fileTypes);

        }

        function AddDDPIRequest() {

            var selectedvalue = $('#<%= rblDDPIAdditionRevocation.ClientID %> input:checked').val();
            //alert(selectedvalue);

            ModType = "DDPI " + selectedvalue;
            addAccountModification(ModType);
            document.getElementById('divDDPI').style = "display:none";
            
        }

        function updateSegmentsRequest() {
       
            if (checkDerivativesSegments() == true) {
                return;
            }
           
            addAccountModification('Update Segments');
            document.getElementById('divSegments').style = "display:none";
        }

        function updateSegmentsRequestWithDerivativesDocuments() {

            if (validateFileExtensionByElementId("derivativesIncomeProofFile", "Client Income proof for Derivatives", "JPG,PNG,JPEG,PDF") == false) {
                    return;
                }

                if (document.getElementById('cmbDerivativesIncomeProof').value == "") {
                    alertModal("Error", "Please select Income Range for Derivatives!");
                    return;
            }

            addAccountModification('Update Segments');
            document.getElementById('divSegments').style = "display:none";
            $('#uploadDerivativesDocumentsModal').modal('hide');
            
        }

        function validateFileExtensionByFileName(fileName, uploadType, fileTypes) {


            if (fileName == "") {
                alertModal("Error : "+ uploadType+" file upload", "Please select for upload " + uploadType + " file in " + fileTypes + " format!");
                return false;
            }

            const fileTypesArray = fileTypes.split(",");

            let matchesNameExtns = "";
            for (let i = 0; i < fileTypesArray.length; i++) {

                if (i == fileTypesArray.length - 1) {
                    matchesNameExtns += "." + fileTypesArray[i]+ "$";
                }
                else {
                    matchesNameExtns += "." + fileTypesArray[i] + "$|";
                }
                
            }

            var fileElementFileName = fileName.toUpperCase();
            //alert(fileElementFileName.match(".JPG$|.PNG$|.PDF$"));
            //alert(fileElementFileName.match(matchesNameExtns));
            
            if (fileElementFileName.match(matchesNameExtns) == null) {
                alertModal("Error : "+ uploadType+" file upload", "Invalid file selected! Please select for upload " + uploadType + " file in " + fileTypes + " format!");
                return false;
            }

            return true;

        }

        function successAsyncFileUpload(sender, args) {

            //alert($(sender._element).find('input').attr('id'));

            if ($(sender._element).find('input').attr('id').match("nomDocAsyncFileUpload") == "nomDocAsyncFileUpload") {

                var filename = $(sender._element).find('input').val().replace("C:\\fakepath\\", "");
                //alert(filename);
                
                document.getElementById('spanNomDocAsyncFileUpload').innerHTML = filename;
                document.getElementById('spanNomDocAsyncFileUpload').style.backgroundColor = "lime";

                //document.getElementById('spanNomDocAsyncFileUpload').innerHTML = document.getElementById('hdnNomDocAsyncFileUpload').value;
            }

            if ($(sender._element).find('input').attr('id').match("nomMinorGuardianDocAsyncFileUpload") == "nomMinorGuardianDocAsyncFileUpload") {
                //alert($(sender._element).find('input').val());
                var filename = $(sender._element).find('input').val().replace("C:\\fakepath\\", "");
                //alert(filename);
                
                document.getElementById('spanNomGuardianDocAsyncFileUpload').innerHTML = filename;
                document.getElementById('spanNomGuardianDocAsyncFileUpload').style.backgroundColor = "lime";

                //document.getElementById('spanNomGuardianDocAsyncFileUpload').innerHTML = document.getElementById('hdnNomGuardianDocAsyncFileUpload').value;
            }


            if ($(sender._element).find('input').attr('id').match("dpClientMasterAsyncFileUpload") == "dpClientMasterAsyncFileUpload") {
                
                var filename = $(sender._element).find('input').val().replace("C:\\fakepath\\", "");
                
                document.getElementById('spanDPClientMasterAsyncFileUpload').innerHTML = filename;
                document.getElementById('spanDPClientMasterAsyncFileUpload').style.backgroundColor = "lime";

            }

            if ($(sender._element).find('input').attr('id').match("bankValidationAsyncFileUpload") == "bankValidationAsyncFileUpload") {
                
                var filename = $(sender._element).find('input').val().replace("C:\\fakepath\\", "");
                
                document.getElementById('spanBankValidationAsyncFileUpload').innerHTML = filename;
                document.getElementById('spanBankValidationAsyncFileUpload').style.backgroundColor = "lime";

            }


            $(sender._element).find('input').css("background-color", "white");
            $(sender._element).find('input').val('');

            
            
        }
        
        function IsMobileNumber(number) {
                var val = number.value
                if (/^\d{10}$/.test(val)) {
                    // value is ok, use it
                    return true
                } else {
                    alertModal("Error", "Invalid number; must be 10 digits!");
                    //alert("Invalid number; must be 10 digits!")
                    number.focus()
                    return false
                }
            }

        function sendMobileOTP() {

            var btnSendMobileOTP = document.getElementById('btnSendMobileOTP');
            var txtMobile = document.getElementById('txtMobile');
            var txtMobileOTP = document.getElementById('txtMobileOTP');
            var btnOTPMobileResend = document.getElementById('btnOTPMobileResend');
            var btnOTPMobileValidate = document.getElementById('btnOTPMobileValidate');

            txtMobileOTP.value = "";


            if (txtMobile.value == "") {
                alertModal("Error", "Please enter new Mobile number!");
                //alert('Please enter new Mobile number!');
                return;
            }

            if (txtMobile.value == document.getElementById('txtMobileOld').value) {
                alertModal("Error", "Old and new Mobile number can't be same!");
                return;
            }
            
            if (!IsMobileNumber(txtMobile))
                return;

            document.getElementById('hdnBtnUpdateMobileClicked').value = "Sent OTP";
            document.getElementById('<%= btnUpdateMobile.UniqueID %>').click();

            alertModal("OTP sent", "OTP has been sent successfully to your mobile number " + txtMobile.value);

            //btnSendMobileOTP.style = "display:none";
            //txtMobileOTP.style = "display:block";
            document.getElementById('divResendValidate').style = "display:block";

        }
        
        function validateMobileOTP() {

            var txtMobile = document.getElementById('txtMobile');
            var txtMobileOTP = document.getElementById('txtMobileOTP');

            if (txtMobileOTP.value == "") {
                //alert('Invalid OTP entered!');
                alertModal("Error: Update Mobile", "Invalid OTP entered!");
                return;
            }

            document.getElementById('hdnBtnUpdateMobileClicked').value = "Validate OTP";
            document.getElementById('<%= btnUpdateMobile.UniqueID %>').click();

            //addUpdateMobileRequest();

        }

        function addUpdateMobileRequest() {

            var txtMobile = document.getElementById('txtMobile');
            var txtMobileOTP = document.getElementById('txtMobileOTP');

            txtMobileOTP.style = "display:none";
            document.getElementById('divResendValidate').style = "display:none";

            //txtMobile.disabled = true;

            document.getElementById('divMobile').style = "display:none";

            //addAccountModification("Request Added", "Update new mobile number "+ txtMobile.value);
            addAccountModification("Update Mobile");
        }

        function clickBtnSubmitAllRequest(tValue) {

            document.getElementById('hdnBtnSubmitModificationRequestsClicked').value = tValue;
            
            

            if (tValue == "1" || tValue == "3") {
                document.getElementById('divLoading').style = "display:block";
                document.getElementById('modalTermsLabel').innerHTML = "Request submission";
                document.getElementById('divtermsandconditionsHTML').style = "display:none";
                document.getElementById('divSubmitBtns').style = "display:none";

            }
            else if (tValue == "2") {
                document.getElementById('divLoading').style = "display:none";
            }

            
            document.getElementById('<%= btnSubmitModificationRequests.UniqueID %>').click();

        }


        function isNomResidualPercentAvailable() {

            if (document.getElementById('hdnNomResidualPercent').value != "") {

                if (Number(document.getElementById('hdnNomResidualPercent').value) > 0) {

                    //alertModal("Alert : " + document.getElementById('hdnNomResidualPercent').value + " percent nominations residual share available",
                    //    "Summation of nomination percentage among nominees should be 100.<br/> Available <b>" + document.getElementById('hdnNomResidualPercent').value + " percent residual share</b> automatically will be add to your <b>1st Nominee</b> if you not add any other Nominee");

                    if (Number(document.getElementById('hdnNomResidualPercent').value) == 100) {

                        alertModal("Error : No nomination found, " + document.getElementById('hdnNomResidualPercent').value + " percent nominations share available",
                        "1. You can <b>opt out of nomination</b>. <br/>2. You can <b>add nominees</b>. <br/>Please note that summation of nomination percentage among nominees should be 100.  1 to 100 percent share should be allocated to a Nominee");
                    }
                    else {
                        alertModal("Error : " + document.getElementById('hdnNomResidualPercent').value + " percent nominations residual share available",
                        "Summation of nomination percentage among nominees should be 100.<br/> Available <b>" + document.getElementById('hdnNomResidualPercent').value + " percent residual share</b> should be allocated to a Nominee");
                    }

                    activaTab('Nomination');
                    return true;

                }

                return false;
            }

            return false;

        }

        function isNomAvailableWithoutShare() {

            if (document.getElementById('hdnNomResidualPercent').value != "") {

                if (document.getElementById('hdnNominee1Share').value != "" || document.getElementById('hdnNominee2Share').value != "" || document.getElementById('hdnNominee2Share').value != "") {

                    alertModal("Error : Nominee available without nomination share",
                        "Summation of nomination percentage among nominees should be 100.<br/> 1 to 100 % share should be allocated to a Nominee. You need to edit or remove this Nominee.");
                    activaTab('Nomination');
                    return true;
                }

                return false;
            }

            return false;

        }


        function submitAllRequest() {

            if (Number(document.getElementById('hdnNomResidualPercent').value) !="") {

                if (isNomAvailableWithoutShare()) {
                    return;
                }

                if (isNomResidualPercentAvailable()) {
                    return;
                }

                

            }

            openTermsandConditions();
            
            clickBtnSubmitAllRequest('1');

            
        }


        function openTermsandConditions() {
            $('#modalTerms').modal('show');
        }

        
        function sendEmailOTP() {

            var btnSendEmailOTP = document.getElementById('btnSendEmailOTP');
            var txtEmail = document.getElementById('txtEmail');
            var txtEmailOTP = document.getElementById('txtEmailOTP');
            var btnOTPEmailResend = document.getElementById('btnOTPEmailResend');
            var btnOTPEmailValidate = document.getElementById('btnOTPEmailValidate');

            txtEmailOTP.value = "";


            if (txtEmail.value == "") {
                //alert('Please enter new Email!');
                alertModal("Error", "Please enter new Email Id!");
                return;
            }

            if (txtEmail.value == document.getElementById('txtEmailOld').value) {
                alertModal("Error", "Old and new Email ID can't be same!");
                return;
            }
            
            if (!ValidateEmail(txtEmail))
                return;

            document.getElementById('hdnBtnUpdateEmailClicked').value = "Sent OTP";
            document.getElementById('<%= btnUpdateEmail.UniqueID %>').click();

            alertModal("OTP sent", "OTP has been sent successfully to new email id " + txtEmail.value);

            //btnSendEmailOTP.style = "display:none";
            //txtEmailOTP.style = "display:block";
            //alert('OTP has been sent successfully to your email ' + txtEmail.value);

            document.getElementById('divEmailResendValidate').style = "display:block";
            

        }


        function ValidateEmail(input) {

            var validRegex = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;

            if (input.value.match(validRegex)) {

                input.focus();
                return true;

            } else {

                //alert("Invalid email address!");
                alertModal("Error", "Invalid email address!");

                input.focus();

                return false;

            }

        }

        function validateEmailOTP() {

            var txtEmail = document.getElementById('txtEmail');
            var txtEmailOTP = document.getElementById('txtEmailOTP');

            if (txtEmailOTP.value == "") {
                //alert('Invalid OTP entered!');
                alertModal("Error", "Invalid OTP entered!");
                return;
            }


            document.getElementById('hdnBtnUpdateEmailClicked').value = "Validate OTP";
            document.getElementById('<%= btnUpdateEmail.UniqueID %>').click();

        }

        function addUpdatEmailRequest() {

            var txtEmail = document.getElementById('txtEmail');
            var txtEmailOTP = document.getElementById('txtEmailOTP');
            
            txtEmailOTP.style = "display:none";
            document.getElementById('divEmailResendValidate').style = "display:none";

            //txtEmail.disabled = true;
            document.getElementById('divEmail').style = "display:none";
            
            addAccountModification("Update Email");
        }
         

    </script>
    <form id="form1" runat="server">

        <asp:ScriptManager runat="server"></asp:ScriptManager>

        <!--
         <div class="container d-flex flex-column align-items-center">
             <h1 class="fst-italic lh-1 mb-4">Page is under construction its is Coming Soon</h1>
             <p class="mb-5">We're working hard to finish the development of this project.</p>
          </div>
        -->
       <input type="hidden" id="hdnModType" name="hdnModType" runat="server" value="">
        <input type="hidden" id="hdnModTypeValue" name="hdnModTypeValue" runat="server" value="">

        <input type="hidden" runat="server" id="hdnErrorMsgModalOpen" value="" name="hidden">
        <input type="hidden" runat="server" id="hdnDigiLockerOpenTab" value="" name="hidden">
        <input type="hidden" runat="server" id="hdnDigiLockerModalOpen" value="" name="hidden">

       <div class="container" id="divMain" runat="server">
          <div class="row">
            <div class="col-md-3">
                <center>
                <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:200px; height:100px; padding-top:10px">
                </center>
            </div>
            <div class="col-md-9">
                <h2>Account Modification <i class="fa fa-user-pen" aria-hidden="true"></i></h2>
                <p>Re-KYC. As per RBI guidelines on KYC norms, Banks need to periodically update customer identification documents in the records of their account holders.</p>
            </div>
          </div>
           <div class="form-group">
                <label for="txtName" class="control-label col-sm-1">Name:</label>
                <div class="col-sm-5">
                <input type="text" class="form-control" value="" readonly="readonly" id="txtName" runat="server">
                </div>
                <label for="txtUCC" class="control-label col-sm-1">UCC:</label>
                <div class="col-sm-2">
                <input type="text" class="form-control" value="" readonly="readonly" id="txtUCC" runat="server">
                </div>
                <label for="txtUCC" class="control-label col-sm-1">PAN:</label>
                <div class="col-sm-2">
                <input type="text" class="form-control" value="" readonly="readonly" id="txtPAN" runat="server">
                </div>
            </div>
           <br />
           <br />
          <div class="progress">
            <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
            </div>
          </div>
          <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#Instruction"><i class="fa fa-book" aria-hidden="true"></i> Instruction</a></li>
            <li id="liMobile"><a data-toggle="tab" href="#Mobile"><i class="fa fa-mobile" aria-hidden="true"></i> Mobile</a></li>
            <li id="liEmail"><a data-toggle="tab" href="#Email"><i class="fa fa-envelope" aria-hidden="true"></i> Email</a></li>
            <li id="liAddress"><a data-toggle="tab" href="#Address"><i class="fa fa-address-card" aria-hidden="true"></i> Address</a></li>
            <li id="liDateofBirth"><a data-toggle="tab" href="#DateofBirth"><i class="fa fa-calendar" aria-hidden="true"></i> DOB</a></li>
            <li id="liIncomeRange"><a data-toggle="tab" href="#IncomeRange"><i class="fa fa-inr" aria-hidden="true"></i> Income</a></li>
            <li id="liBankDetails"><a data-toggle="tab" href="#BankDetails"><i class="fa fa-university" aria-hidden="true"></i> Bank</a></li>
            <li id="liDPDetails"><a data-toggle="tab" href="#DPDetails"><i class="fa fa-university" aria-hidden="true"></i> DP</a></li>
            <li id="liNomination"><a data-toggle="tab" href="#Nomination"><i class="fa fa-users" aria-hidden="true"></i> Nomination</a></li>
            <li id="liAuthorizedRepresentative"><a data-toggle="tab" href="#AuthorizedRepresentative"><i class="fa fa-user" aria-hidden="true"></i> Auth Rep</a></li>
            <li id="liDDPI"><a data-toggle="tab" href="#DDPI"><i class="fa fa-user" aria-hidden="true"></i> DDPI</a></li>
            <li id="liSegments"><a data-toggle="tab" href="#Segments"><i class="fa fa-exchange" aria-hidden="true"></i> Segments</a></li>
            <li><a data-toggle="tab" href="#FinalSubmission" id="linkFinalSubmission" style="display:none;" onclick="FinalSubmissionClick()"><i class="fa fa-arrow-circle-down" aria-hidden="true"></i> Final Submission</a></li>
          </ul>

          <div class="tab-content" id="divTabcontent">
            <div id="Instruction" class="tab-pane fade in active">
                <h3><i class="fa fa-book" aria-hidden="true"></i> Instruction</h3>
                <div id="divInstructionContent" runat="server">
                </div>
            </div>
            <div id="Mobile" class="tab-pane fade">
                <h3><i class="fa fa-mobile" aria-hidden="true"></i> Update Mobile number</h3>
                <p>&nbsp;<span class="explanation">Note that the OTP will go to the new Mobile number</span></p>
                <br />
                <div id="divMobile">
                    <div class="row">
                        <div class="form-group">
                            <label for="txtMobileOld" class="control-label col-sm-2">Current Mobile No.:</label>
                            <div class="col-sm-8">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <input type="number"  class="form-control" id="txtMobileOld" readonly="readonly" runat="server" placeholder="NA">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <br />
                    <div class="row">
                        <div class="form-group">
                          <label for="txtMobile" class="control-label col-sm-2">New Mobile No.:</label>
                          <div class="col-sm-8">
                              <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                                  <ContentTemplate>
                                      <div style="display:none">
                                        <asp:Button ID="btnUpdateMobile" runat="server" Text="" OnClick="btnUpdateMobile_Click" /> 
                                        <input type="hidden" id="hdnBtnUpdateMobileClicked" name="hdnBtnUpdateMobileClicked" runat="server" value="">
                                     </div>
                                      <div class="row">
                                         <div class="col-sm-6">
                                             <input type="number"  class="form-control" id="txtMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter New Mobile No.">
                                         </div>
                                         <div class="col-sm-6">
                                             <button type="button" class="btn btn-sm btn-primary btnpadingtop" runat="server" id="btnSendMobileOTP" onclick="sendMobileOTP()"><i class="fa fa-bell" aria-hidden="true"></i> Send OTP</button>
                                         </div>
                                     </div>
                                      <div class="row" style="margin-top:10px">
                                          <div class="col-sm-6">
                                              <input type="text" class="form-control" id="txtMobileOTP" runat="server" placeholder="Enter OTP" style="display:none">
                                          </div>
                                          <div class="col-sm-6">
                                          </div>
                                      </div>
                                  </ContentTemplate>
                              </asp:UpdatePanel>
                              <div class="row" style="margin-top:10px">
                                  <div class="col-sm-6">
                                      <div id="divResendValidate" runat="server" style="display:none">
                                          <button type="button" class="btn btn-sm btn-primary btnpadingtop" id="btnOTPMobileValidate" onclick="validateMobileOTP()"><i class="fa fa-share-square" aria-hidden="true"></i> Add Request</button>
                                          <button type="button" class="btn btn-sm btn-primary btnpadingtop" id="btnOTPMobileResend" onclick="sendMobileOTP()"><i class="fa fa-repeat" aria-hidden="true"></i> Resend</button>
                                      </div>
                                  </div>
                                  <div class="col-sm-6">
                                  </div>
                              </div>
                          </div>
                          <div class="col-sm-2">
                          </div>
                        </div>
                    </div>
               </div>
            </div>
            <div id="Email" class="tab-pane fade">
              <h3><i class="fa fa-envelope" aria-hidden="true"></i> Update Email ID</h3>
                <p><span class="explanation">* OTP will go to the new Email ID</span></p>
                <br />
                <div id="divEmail">
                    <div class="row">
                        <div class="form-group">
                            <label for="txtEmailOld" class="control-label col-sm-2">Current Email ID:</label>
                            <div class="col-sm-8">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <input type="text"  class="form-control" id="txtEmailOld" runat="server" readonly="readonly" placeholder="NA">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <br />
                    <div class="row">
                        <div class="form-group">
                          <label for="txtEmail" class="control-label col-sm-2">New Email ID:</label>
                          <div class="col-sm-8">
                              <asp:UpdatePanel ID="UpdatePanel3" runat="server">
                                  <ContentTemplate>
                                      <div style="display:none">
                                        <asp:Button ID="btnUpdateEmail" runat="server" Text="" OnClick="btnUpdateEmail_Click" /> 
                                        <input type="hidden" id="hdnBtnUpdateEmailClicked" name="hdnBtnUpdateEmailClicked" runat="server" value="">
                                     </div>
                                      <div class="row">
                                         <div class="col-sm-6">
                                             <input type="text"  class="form-control" id="txtEmail" runat="server" placeholder="Enter New Email" maxlength="80">
                                         </div>
                                         <div class="col-sm-6">
                                             <button type="button" class="btn btn-sm btn-primary btnpadingtop" runat="server" id="btnSendEmailOTP" onclick="sendEmailOTP()"><i class="fa fa-bell" aria-hidden="true"></i> Send OTP</button>
                                         </div>
                                     </div>
                                      <div class="row" style="margin-top:10px">
                                          <div class="col-sm-6">
                                              <input type="text" class="form-control" id="txtEmailOTP" runat="server" placeholder="Enter OTP" style="display:none">
                                          </div>
                                          <div class="col-sm-6">
                                          </div>
                                      </div>
                                  </ContentTemplate>
                              </asp:UpdatePanel>
                              
                              <div class="row" style="margin-top:10px">
                                  <div class="col-sm-6">
                                      <div id="divEmailResendValidate" style="display:none">
                                          <button type="button" class="btn btn-sm btn-primary btnpadingtop" id="btnOTPEmailValidate" onclick="validateEmailOTP()"><i class="fa fa-share-square" aria-hidden="true"></i> Add Request</button>
                                          <button type="button" class="btn btn-sm btn-primary btnpadingtop" id="btnOTPEmailResend" onclick="sendEmailOTP()"><i class="fa fa-repeat" aria-hidden="true"></i> Resend</button>
                                      </div>
                                  </div>
                                  <div class="col-sm-6">
                                  </div>
                              </div>
                          </div>
                          <div class="col-sm-2">
                          </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="Address" class="tab-pane fade">
              <h3><i class="fa fa-address-card" aria-hidden="true"></i> Update Address</h3>
                <p><span class="explanation">Address proof document will have to be uploaded<br />* indicates mandatory fields</span> 

                   
                </p>
                <br />
                <div id="divAddress">
                    <div class="container">
                        <ul class="nav nav-tabs">
                            <li class="active"><a data-toggle="tab" href="#PermanentAddressTab">Permanent Address</a></li>
                            <li><a data-toggle="tab" href="#CorrespondenceAddressTab" id="hrefCorrespondenceAddress" style="display:none">Correspondence Address</a></li>
                          </ul>
                          <br>
                        <div class="tab-content">
                            <div id="PermanentAddressTab" class="tab-pane fade in active">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="txtOldPermAddress" class="control-label col-sm-4">Current Per. Address:</label>
                                            <div class="col-sm-8">
                                                <textarea class="form-control" id="txtOldPermAddress" runat="server" placeholder="NA" readonly="readonly"  name="txtOldPermAddress" rows="3"></textarea>
                                                <br />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                         <div class="form-group">
                                            <label for="cmbAddressProof" class="control-label col-sm-4">Address Proof*:</label>
                                             <div class="col-sm-8">
                                                 <asp:DropDownList ID="cmbAddressProof" CssClass="form-control" runat="server">
                                                    <asp:ListItem Value="31">UID/Aadhaar</asp:ListItem>
                                                    <asp:ListItem Value="06">Voter Identity Card</asp:ListItem>
                                                    <asp:ListItem Value="01">Passport</asp:ListItem>
                                                    <asp:ListItem Value="02">Driving License</asp:ListItem>
                                                    <asp:ListItem Value="03">Latest Bank Passbook</asp:ListItem>
                                                    <asp:ListItem Value="04">Bank Account Statement/Passbook</asp:ListItem>
                                                    <asp:ListItem Value="05">Latest Demat Account Statement (Should not be Older than 3 Months)</asp:ListItem>
                                                    <asp:ListItem Value="07">Ration Card</asp:ListItem>
                                                    <asp:ListItem Value="08">Registered Lease or Sale Agreement of Residence</asp:ListItem>
                                                    <asp:ListItem Value="09">Latest Land Line Telephone Bill (Should not be Older than 3 Months)</asp:ListItem>
                                                    <asp:ListItem Value="10">Latest Electricity Bill (Should not be Older than 3 Months)</asp:ListItem>
                                                    <asp:ListItem Value="11">Gas Bill (Should not be Older than 3 Months)</asp:ListItem>
                                                    <asp:ListItem Value="12">Registration Certificate issued under Shops and Establishment</asp:ListItem>
                                                    <asp:ListItem Value="13">Flat Maintenance bill (Should not be Older than 3 Months)</asp:ListItem>
                                                    <asp:ListItem Value="14">Insurance Copy</asp:ListItem>
                                                    <asp:ListItem Value="15">Self Declaration by High Court / Supreme Court Judges</asp:ListItem>
                                                    <asp:ListItem Value="16">Power of Attorney given by FII/sub-account to the Custodians ( which are during notarized and/or apostiled or consularised )</asp:ListItem>
                                                    <asp:ListItem Value="17">Proof of Address issued by Bank Managers of Scheduled Commercial Banks</asp:ListItem>
                                                    <asp:ListItem Value="18">Proof of address issued by Elected representatives to the Legislature Assembly</asp:ListItem>
                                                    <asp:ListItem Value="19">Proof of Address issued by Parliament</asp:ListItem>
                                                    <asp:ListItem Value="20">Proof of Address issued by any Government / Statutory Authority</asp:ListItem>
                                                    <asp:ListItem Value="21">Proof of Address issued by Notary Public</asp:ListItem>
                                                    <asp:ListItem Value="22">Proof of Address issued by Gazetted Officer</asp:ListItem>
                                                    <asp:ListItem Value="23">ID Card with address issued by Central / State Goverment and its Departments</asp:ListItem>
                                                    <asp:ListItem Value="24">ID Card with address issued by Statutory / Regulatory Authorities</asp:ListItem>
                                                    <asp:ListItem Value="25">ID Card with address issued by Public Sector Undertakings</asp:ListItem>
                                                    <asp:ListItem Value="26">ID Card with address issued by Scheculded Commercial Banks</asp:ListItem>
                                                    <asp:ListItem Value="27">ID Card with address issued by Public Financial Intitution</asp:ListItem>
                                                    <asp:ListItem Value="28">ID Card with address issued by Colleges affiliated to Universities</asp:ListItem>
                                                    <asp:ListItem Value="29">ID Card issued by Professional Bodies such as ICAI, ICWAI, ICSI, Bar Council etc.</asp:ListItem>
                                                </asp:DropDownList>
                                              </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6" style="padding-left:30px">
                                        <div id="divAddressProofFile" runat="server" style="display:block">
                                            <div class="form-group">
                                            <input type="file" id="AddressProofFile" runat="server" class="form-control-file border" name="AddressProofFile" accept='.jpg,.png,.jpeg,.pdf'>
                                          </div>
                                            <span style="color:red; font-size:10px">
                                                In case Aadhaar is uploaded, please remember: <br />
                                                1) Upload a single PDF or Image with both sides of the Aadhaar card, <br />
                                                2) Please Blacken or block the first 8 digits of Aadhaar Number to avoid rejection of your Re-KYC request.
                                             </span> 
                                        </div>
                                    </div>
                                </div>
                                <div class="row" style="padding-top:10px; padding-bottom:10px" >
                                    <div class="col-sm-2">
                                    </div>
                                    <div class="col-sm-8">
                                        <div class="row" style="padding-left:10px">
                                            <div class="col-sm-6">
                                                <div class="form-check" style="display:none">
                                                  <label class="form-check-label" for="chkAddressFetchdigilocker">
                                                    <input type="checkbox" class="form-check-input" id="chkAddressFetchdigilocker" runat="server" name="chkAddressFetchdigilocker" onchange="setAdressDataFetchFromDigiLocker(this.checked)">&nbsp; Fetch from digiLocker using Aadhaar
                                                      <input type="number" class="form-control" id="txtAadhaarAddress" runat="server" placeholder="Aadhaar number" style="display:none"> <button type="button" class="btn btn-info btn-xs" id="btnDigiLockerFetchdataAddress" style="display:none" onclick="fetchAdressDataFromDigiLocker()"><i class="fa fa-globe" aria-hidden="true"></i> Fetch data..</button>
                                                  </label>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                          <label for="txtAddress1" class="control-label col-sm-4">Address 1*:</label>
                                          <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtAddress1" runat="server" placeholder="Enter Address 1"  maxlength="50">
                                          </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                          <label for="txtAddress2" class="control-label col-sm-4">Address 2:</label>
                                          <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtAddress2" runat="server" placeholder="Enter Address 2"  maxlength="50">
                                          </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                          <label for="txtAddress3" class="control-label col-sm-4">Address 3:</label>
                                          <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtAddress3" runat="server" placeholder="Enter Address 3"  maxlength="50">
                                          </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                          <label for="txtAddressCity" class="control-label col-sm-4">City*:</label>
                                          <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtAddressCity" runat="server" placeholder="Enter City"  maxlength="50">
                                          </div>
                                        </div>
                                    </div>
                               </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                          <label for="txtAddressPincode" class="control-label col-sm-4">Pincode*:</label>
                                          <div class="col-sm-8">
                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtAddressPincode" runat="server" placeholder="Enter Pincode">
                                          </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                          <label for="cmbAddressState" class="control-label col-sm-4">State*:</label>
                                          <div class="col-sm-8">
                                            <asp:DropDownList ID="cmbAddressState" CssClass="form-control" runat="server">
                                                </asp:DropDownList>
                                          </div>
                                        </div>
                                    </div>
                               </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                          <label for="cmbAddressCountry" class="control-label col-sm-4">Country*:</label>
                                          <div class="col-sm-8">
                                            <asp:DropDownList ID="cmbAddressCountry" onchange="if (this.value!='IN') {document.getElementById('cmbAddressState').value='XX'} else { document.getElementById('cmbAddressState').value='WB' }" CssClass="form-control" runat="server">
                                                </asp:DropDownList>
                                          </div>
                                        </div>
                                    </div>
                               </div>
                            </div>
                            <div id="CorrespondenceAddressTab" class="tab-pane fade in">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="txtOldCorrAddress" class="control-label col-sm-4">Current Corr. Address:</label>
                                            <div class="col-sm-8">
                                                <textarea class="form-control" id="txtOldCorrAddress" runat="server" placeholder="NA" readonly="readonly"  name="txtOldPermAddress" rows="3"></textarea>
                                                <br />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                         <div class="form-group">
                                            <label for="cmbCorrAddressProof" class="control-label col-sm-4">Address Proof*:</label>
                                             <div class="col-sm-8">
                                                 <asp:DropDownList ID="cmbCorrAddressProof" CssClass="form-control" runat="server">
                                                    <asp:ListItem Value="31">UID/Aadhaar</asp:ListItem>
                                                    <asp:ListItem Value="06">Voter Identity Card</asp:ListItem>
                                                    <asp:ListItem Value="01">Passport</asp:ListItem>
                                                    <asp:ListItem Value="02">Driving License</asp:ListItem>
                                                    <asp:ListItem Value="03">Latest Bank Passbook</asp:ListItem>
                                                    <asp:ListItem Value="04">Bank Account Statement/Passbook</asp:ListItem>
                                                    <asp:ListItem Value="05">Latest Demat Account Statement (Should not be Older than 3 Months)</asp:ListItem>
                                                    <asp:ListItem Value="07">Ration Card</asp:ListItem>
                                                    <asp:ListItem Value="08">Registered Lease or Sale Agreement of Residence</asp:ListItem>
                                                    <asp:ListItem Value="09">Latest Land Line Telephone Bill (Should not be Older than 3 Months)</asp:ListItem>
                                                    <asp:ListItem Value="10">Latest Electricity Bill (Should not be Older than 3 Months)</asp:ListItem>
                                                    <asp:ListItem Value="11">Gas Bill (Should not be Older than 3 Months)</asp:ListItem>
                                                    <asp:ListItem Value="12">Registration Certificate issued under Shops and Establishment</asp:ListItem>
                                                    <asp:ListItem Value="13">Flat Maintenance bill (Should not be Older than 3 Months)</asp:ListItem>
                                                    <asp:ListItem Value="14">Insurance Copy</asp:ListItem>
                                                    <asp:ListItem Value="15">Self Declaration by High Court / Supreme Court Judges</asp:ListItem>
                                                    <asp:ListItem Value="16">Power of Attorney given by FII/sub-account to the Custodians ( which are during notarized and/or apostiled or consularised )</asp:ListItem>
                                                    <asp:ListItem Value="17">Proof of Address issued by Bank Managers of Scheduled Commercial Banks</asp:ListItem>
                                                    <asp:ListItem Value="18">Proof of address issued by Elected representatives to the Legislature Assembly</asp:ListItem>
                                                    <asp:ListItem Value="19">Proof of Address issued by Parliament</asp:ListItem>
                                                    <asp:ListItem Value="20">Proof of Address issued by any Government / Statutory Authority</asp:ListItem>
                                                    <asp:ListItem Value="21">Proof of Address issued by Notary Public</asp:ListItem>
                                                    <asp:ListItem Value="22">Proof of Address issued by Gazetted Officer</asp:ListItem>
                                                    <asp:ListItem Value="23">ID Card with address issued by Central / State Goverment and its Departments</asp:ListItem>
                                                    <asp:ListItem Value="24">ID Card with address issued by Statutory / Regulatory Authorities</asp:ListItem>
                                                    <asp:ListItem Value="25">ID Card with address issued by Public Sector Undertakings</asp:ListItem>
                                                    <asp:ListItem Value="26">ID Card with address issued by Scheculded Commercial Banks</asp:ListItem>
                                                    <asp:ListItem Value="27">ID Card with address issued by Public Financial Intitution</asp:ListItem>
                                                    <asp:ListItem Value="28">ID Card with address issued by Colleges affiliated to Universities</asp:ListItem>
                                                    <asp:ListItem Value="29">ID Card issued by Professional Bodies such as ICAI, ICWAI, ICSI, Bar Council etc.</asp:ListItem>
                                                </asp:DropDownList>
                                              </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6" style="padding-left:30px">
                                          <div class="form-group">
                                            <input type="file" id="corrAddressProofFile" runat="server" class="form-control-file border" name="corrAddressProofFile" accept='.jpg,.png,.jpeg,.pdf'>
                                          </div>
                                        <span style="color:red; font-size:10px">
                                            In case Aadhaar is uploaded, please remember: <br />
                                            1) Upload a single PDF or Image with both sides of the Aadhaar card, <br />
                                            2) Please Blacken or block the first 8 digits of Aadhaar Number to avoid rejection of your Re-KYC request.
                                         </span> 
                                    </div>
                                </div>
                                <div class="row" style="padding-top:10px; padding-bottom:10px" >
                                    <div class="col-sm-2">
                                    </div>
                                    <div class="col-sm-8">
                                        <div class="row" style="padding-left:10px">
                                            <div class="col-sm-6">
                                                <div class="form-check" style="display:none">
                                                  <label class="form-check-label" for="chkCorrAddressFetchdigilocker">
                                                    <input type="checkbox" class="form-check-input" id="chkCorrAddressFetchdigilocker" runat="server" name="chkAddressFetchdigilocker" onchange="setAdressDataFetchFromDigiLocker(this.checked)">&nbsp; Fetch from digiLocker using Aadhaar
                                                      <input type="number" class="form-control" id="txtAadhaarCorrAddress" runat="server" placeholder="Aadhaar number" style="display:none"> <button type="button" class="btn btn-info btn-xs" id="btnDigiLockerFetchdataCorrAddress" style="display:none" onclick="fetchAdressDataFromDigiLocker()"><i class="fa fa-globe" aria-hidden="true"></i> Fetch data..</button>
                                                  </label>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                          <label for="txtCorrAddress1" class="control-label col-sm-4">Address 1*:</label>
                                          <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtCorrAddress1" runat="server" placeholder="Enter Address 1" maxlength="50">
                                          </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                          <label for="txtCorrAddress2" class="control-label col-sm-4">Address 2:</label>
                                          <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtCorrAddress2" runat="server" placeholder="Enter Address 2" maxlength="50">
                                          </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                          <label for="txtCorrAddress3" class="control-label col-sm-4">Address 3:</label>
                                          <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtCorrAddress3" runat="server" placeholder="Enter Address 3" maxlength="50">
                                          </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                          <label for="txtCorrAddressCity" class="control-label col-sm-4">City*:</label>
                                          <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtCorrAddressCity" runat="server" placeholder="Enter City" maxlength="50">
                                          </div>
                                        </div>
                                    </div>
                               </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                          <label for="txtCorrAddressPincode" class="control-label col-sm-4">Pincode*:</label>
                                          <div class="col-sm-8">
                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtCorrAddressPincode" runat="server" placeholder="Enter Pincode">
                                          </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                          <label for="cmbCorrAddressState" class="control-label col-sm-4">State*:</label>
                                          <div class="col-sm-8">
                                            <asp:DropDownList ID="cmbCorrAddressState" CssClass="form-control" runat="server">
                                                </asp:DropDownList>
                                          </div>
                                        </div>
                                    </div>
                               </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                          <label for="cmbCorrAddressCountry" class="control-label col-sm-4">Country*:</label>
                                          <div class="col-sm-8">
                                            <asp:DropDownList ID="cmbCorrAddressCountry" onchange="if (this.value!='IN') {document.getElementById('cmbCorrAddressState').value='XX'} else { document.getElementById('cmbCorrAddressState').value='WB' }" CssClass="form-control" runat="server">
                                                </asp:DropDownList>
                                          </div>
                                        </div>
                                    </div>
                               </div>
                            </div>
                        </div>
                   </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-check">
                                <div style="padding-top:10px; padding-left:20px">
                                    <label class="form-check-label" for="chkCorrAddrSameAsPerm">
                                        &nbsp;<input type="checkbox" class="form-check-input" id="chkCorrAddrSameAsPerm" runat="server" name="chkCorrAddrSameAsPerm" onchange="if(this.checked==false){activaTab('CorrespondenceAddressTab'); document.getElementById('hrefCorrespondenceAddress').style = 'display:block'; } else {activaTab('PermanentAddressTab'); document.getElementById('hrefCorrespondenceAddress').style = 'display:none';}" checked="checked">&nbsp;&nbsp; Correspondence address is same as the Permanent address
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div style="text-align:center; padding-top:10px">
                                <button type="button" class="btn btn-md btn-primary btnpadingtop" id="btnAddressAdd" onclick="AddRequest('Update Address')"><i class="fa fa-share-square" aria-hidden="true"></i> Update address</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="DateofBirth" class="tab-pane fade">

                <h3><i class="fa fa-calendar" aria-hidden="true"></i> Update Date of Birth</h3>
                <p>&nbsp;*The Date of Birth proof document is required.</p>
                <br />
                <div id="divDateofBirth">
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="txtEmailOld" class="control-label col-sm-4">Existing record:</label>
                                <div class="col-sm-8">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <input type="date"  class="form-control" id="dtDateofBirthOld" runat="server" readonly="readonly" placeholder="NA">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" style="padding-top:10px">
                        <div class="col-sm-6">
                             <div class="form-group">
                                <label for="cmbDateofBirthProof" class="control-label col-sm-4">DOB Proof:</label>
                                 <div class="col-sm-8">
                                     <asp:DropDownList ID="cmbDateofBirthProof" CssClass="form-control" runat="server">
                                        <asp:ListItem Value="31">UID/Aadhaar</asp:ListItem>
                                        <asp:ListItem Value="06">Voter Identity Card</asp:ListItem>
                                        <asp:ListItem Value="01">Passport</asp:ListItem>
                                        <asp:ListItem Value="02">Driving License</asp:ListItem>
                                        <asp:ListItem Value="32">Pancard</asp:ListItem>
                                        <asp:ListItem Value="33">10th class Admit Card</asp:ListItem>
                                    </asp:DropDownList>
                                  </div>
                            </div>
                        </div>
                        <div class="col-sm-6" style="padding-left:30px">
                            <div id="divDOBProofFile" runat="server" style="display:block">
                              <div class="form-group">
                                <input type="file" class="form-control-file border" id="DOBProofFile" name="DOBProofFile" accept='.jpg,.png,.jpeg,.pdf'>
                              </div>
                                <span style="color:red; font-size:10px">
                                    In case Aadhaar is uploaded, please remember: <br />
                                    1) Upload a single PDF or Image with both sides of the Aadhaar card, <br />
                                    2) Please Blacken or block the first 8 digits of Aadhaar Number to avoid rejection of your Re-KYC request.
                                </span> 
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="dtDateofBirth" class="control-label col-sm-4">Date of Birth:</label>
                                <div class="col-sm-8">
                                    <input type="date" class="form-control" id="dtDateofBirth" runat="server">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                             <button type="button" class="btn btn-md btn-primary btnpadingtop" id="btnDOBAdd" onclick="AddRequest('Update DOB')"><i class="fa fa-share-square" aria-hidden="true"></i> Update DOB</button>
                        </div>
                    </div>
                </div>
            </div>
            <div id="IncomeRange" class="tab-pane fade">
                <h3><i class="fa fa-inr" aria-hidden="true"></i> Update Income Range</h3>
                <p>&nbsp;* Select your anual income range.</p>
                <br />
                <div id="divIncomeRange">
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="txtCurrentIncome" class="control-label col-sm-4">Current Income:</label>
                                <div class="col-sm-8">
                                    <input type="text"  class="form-control" id="txtCurrentIncome" runat="server" readonly="readonly" placeholder="NA">
                                </div>
                            </div>
                          </div>
                    </div>
                    <div class="row"  style="padding-top:10px">
                        <div class="col-sm-6">
                             <div class="form-group">
                                <label for="cmbIncomeProof" class="control-label col-sm-4">Income Proof:</label>
                                 <div class="col-sm-8">
                                     <asp:DropDownList ID="cmbIncomeProof" CssClass="form-control" runat="server">
                                        <asp:ListItem Value="01">Bank statement(6 months for F&O/ 3 months for Cash)</asp:ListItem>
                                        <asp:ListItem Value="02">ITR for last 2 years for NI/ ITR for last 1 year for Individual</asp:ListItem>
                                        <asp:ListItem Value="03">Form 16 of Last Assessment Year</asp:ListItem>
                                        <asp:ListItem Value="04">Current Demat holding statement(signed ad stamped)</asp:ListItem>
                                        <asp:ListItem Value="05">Networth certificate certified by CA</asp:ListItem>
                                        <asp:ListItem Value="06">Proof of Ownership of immovable property</asp:ListItem>
                                        <asp:ListItem Value="07">Mutual funds A/c Statement</asp:ListItem>
                                        <asp:ListItem Value="08">FD certificate</asp:ListItem>
                                        <asp:ListItem Value="09">Proof of Investment in Fixed return sequries(bond/debenture etc.)</asp:ListItem>
                                    </asp:DropDownList>
                                  </div>
                            </div>
                        </div>
                        <div class="col-sm-6" style="padding-left:30px">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <table>
                                            <tr>
                                                <td>
                                                    1.* &nbsp;
                                                </td>
                                                <td>
                                                    <div class="form-group" style="padding-top:10px">
                                                        <input type="file" class="form-control-file border" id="IncomeProofFile" name="IncomeProofFile" accept='.jpg,.png,.jpeg,.pdf'>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    2.
                                                </td>
                                                <td>
                                                    <div class="form-group" style="padding-top:10px">
                                                        <input type="file" class="form-control-file border" id="IncomeProofFile2" name="IncomeProofFile2" accept='.jpg,.png,.jpeg,.pdf'>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                        
                                    </div>
                                </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                             <div class="form-group">
                                <label for="cmbIncomeRange" class="control-label col-sm-4">Income Range:</label>
                                 <div class="col-sm-8">
                                      <asp:DropDownList ID="cmbIncomeRange" CssClass="form-control" runat="server">
                                        <asp:ListItem Value="0001">Below Rs. 1 Lac</asp:ListItem>
                                        <asp:ListItem Value="0006">Rs. 1-5 Lacs</asp:ListItem>
                                        <asp:ListItem Value="0007">Rs. 5-10 Lacs</asp:ListItem>
                                        <asp:ListItem Value="0008">Rs. 10-25 Lacs</asp:ListItem>
                                        <asp:ListItem Value="0010">Rs. 25 Lacs - 1 Core</asp:ListItem>
                                        <asp:ListItem Value="0011">More than Rs. 1 Core</asp:ListItem>
                                    </asp:DropDownList>
                                  </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                             <button type="button" class="btn btn-md btn-primary btnpadingtop" id="btnIncomeRangeAdd" onclick="AddRequest('Update Income Range')"><i class="fa fa-share-square" aria-hidden="true"></i> Update Income Range</button>
                        </div>
                    </div>
                </div>
          </div>
            <div id="BankDetails" class="tab-pane fade">
                <h3><i class="fa fa-university" aria-hidden="true"></i> Add/Remove/Update bank accounts</h3>
                <p>&nbsp;* Add/Remove/Update bank accounts.</p>
                <br />
                <input type="hidden" id="hdnBankAvailable" name="hdnBankAvailable" runat="server" value="">
                <div class="row">
                    <div class="col-md-12">
                        <h4><i class="fa fa-list-alt" aria-hidden="true"></i> Available Banks</h4>
                        <button type="button" class="btn btn-primary btn-sm" id="btnAddNewBank" style="margin-bottom:20px" onclick="addBankPopup();"><i class="fa fa-plus" aria-hidden="true"></i> Add New Bank</button>
                        <dx:ASPxGridView ID="grdBanks" ClientInstanceName="grdBanks" AutoGenerateColumns="False" CssClass="table" Theme="MetropolisBlue" Width="100%" runat="server" OnHtmlRowCreated="grdBanks_HtmlRowCreated">
                            <Columns>
                                <dx:GridViewDataMemoColumn FieldName="BANK" CellStyle-HorizontalAlign="Left" Caption="Bank" Width="35%" VisibleIndex="0">
                                    <CellStyle HorizontalAlign="Left"></CellStyle>
                                      <DataItemTemplate>
                                        <span><%# Eval("TYPE") %></span> : <span><%# Eval("BANK") %></span>
                                        <br />
                                        <span>IFSC</span> : <span><%# Eval("RTGS") %></span>
                                        <div style=" display:<%# Eval("btnDisplay") %>">
                                            <button type="button" class="btn btn-default btn-xs btnBank<%# Eval("TYPE") %>" onclick="setPrimaryBankPopup('<%# Eval("TYPE") %>','<%# Eval("BANK") %>','<%# Eval("MICR") %>','<%# Eval("RTGS") %>','<%# Eval("ACNO") %>','<%# Eval("CLIENTNAME") %>')"><i class="fa fa-edit" aria-hidden="true"></i> Set Primary</button>
                                            <button type="button" class="btn btn-default btn-xs" onclick="removeBankAlert('<%# Eval("TYPE") %>','<%# Eval("ACNO") %>', '<%# Eval("BANK") %>')"><i class="fa fa-times" aria-hidden="true"></i> Remove</button>
                                        </div>
                                    </DataItemTemplate>
                                </dx:GridViewDataMemoColumn>
                                <dx:GridViewDataTextColumn FieldName="ACNO" Width="30%" Caption="Account" VisibleIndex="2">
                                    <DataItemTemplate>
                                        <span><%# Eval("ACNO") %></span>
                                    </DataItemTemplate>
                                </dx:GridViewDataTextColumn>
                                <dx:GridViewDataTextColumn FieldName="CLIENTNAME" Width="25%" Caption="Name" VisibleIndex="3">
                                    <DataItemTemplate>
                                        <span><%# Eval("CLIENTNAME") %></span>
                                    </DataItemTemplate>
                                </dx:GridViewDataTextColumn>
                                <dx:GridViewDataTextColumn Width="60px" FieldName="modStatus" Caption="Status" VisibleIndex="4">
                                        <CellStyle HorizontalAlign="Center"></CellStyle>
                                    <DataItemTemplate>
                                        <span><%# Eval("modStatus") %></span>
                                    </DataItemTemplate>
                                </dx:GridViewDataTextColumn>
                              </Columns>
                              <SettingsBehavior AllowFocusedRow="True"></SettingsBehavior>
                              <SettingsPager Mode="EndlessPaging">
                              </SettingsPager>
                              <Settings ShowGroupedColumns="True" ShowGroupPanel="False" GridLines="Horizontal" />
                              <SettingsDetail ShowDetailRow="false" />
                              <SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
                              <Styles>
                                <Header Font-Bold="False" Font-Underline="False" VerticalAlign="Middle">
                                </Header>
                                <Cell>
                                    <BorderBottom BorderColor="#336666" BorderStyle="Solid" BorderWidth="1px" />
                                </Cell>
                                <FocusedRow BackColor="WhiteSmoke">
                                </FocusedRow>
                                <Cell ForeColor="Black"></Cell>
                            </Styles>
                          </dx:ASPxGridView>
                    </div>
                </div>
            </div>
           <div id="DPDetails" class="tab-pane fade">
                <h3><i class="fa fa-university" aria-hidden="true"></i> Update DP Details</h3>
                <p>&nbsp;* Update DP Details</p>
                <br />
                <div class="row">
                    <div class="col-md-12">
                        <h4><i class="fa fa-list-alt" aria-hidden="true"></i> Available DP</h4>
                        <button type="button" class="btn btn-primary btn-sm" id="btnAddDP" style="margin-bottom:20px" onclick="addDPPopup();"><i class="fa fa-plus" aria-hidden="true"></i> Add New DP</button>
                        <dx:ASPxGridView ID="grdDP" ClientInstanceName="grdDP" AutoGenerateColumns="False" CssClass="table" Theme="MetropolisBlue" Width="100%" runat="server">
                            <Columns>
                                <dx:GridViewDataMemoColumn FieldName="DPName" CellStyle-HorizontalAlign="Left" Caption="DP Name" Width="35%" VisibleIndex="0">
                                    <CellStyle HorizontalAlign="Left"></CellStyle>
                                      <DataItemTemplate>
                                        <span><%# Eval("TYPE") %></span> : <span><%# Eval("DPName") %></span>
                                        <div style=" display:<%# Eval("btnDisplay") %>">
                                            <button type="button" class="btn btn-default btn-xs <%# Eval("TYPE") %>ToPrimary" onclick="setPrimaryDPPopup('<%# Eval("TYPE") %>','<%# Eval("DPID") %>','<%# Eval("CLIENTID") %>','<%# Eval("DPName") %>')"><i class="fa fa-edit" aria-hidden="true"></i> Set Primary</button>
                                        </div>
                                    </DataItemTemplate>
                                </dx:GridViewDataMemoColumn>
                                <dx:GridViewDataTextColumn FieldName="DPID" Width="30%" Caption="DP Id" VisibleIndex="2">
                                    <DataItemTemplate>
                                        <span><%# Eval("DPID") %></span>
                                    </DataItemTemplate>
                                </dx:GridViewDataTextColumn>
                                <dx:GridViewDataTextColumn FieldName="CLIENTID" Width="25%" Caption="Client ID" VisibleIndex="3">
                                    <DataItemTemplate>
                                        <span><%# Eval("ClientID") %></span>
                                    </DataItemTemplate>
                                </dx:GridViewDataTextColumn>
                                <dx:GridViewDataTextColumn Width="60px" FieldName="modStatus" Caption="Status" VisibleIndex="4">
                                        <CellStyle HorizontalAlign="Center"></CellStyle>
                                    <DataItemTemplate>
                                        <span><%# Eval("modStatus") %></span>
                                    </DataItemTemplate>
                                </dx:GridViewDataTextColumn>
                              </Columns>
                              <SettingsBehavior AllowFocusedRow="True"></SettingsBehavior>
                              <SettingsPager Mode="EndlessPaging">
                              </SettingsPager>
                              <Settings ShowGroupedColumns="True" ShowGroupPanel="False" GridLines="Horizontal" />
                              <SettingsDetail ShowDetailRow="false" />
                              <SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
                              <Styles>
                                <Header Font-Bold="False" Font-Underline="False" VerticalAlign="Middle">
                                </Header>
                                <Cell>
                                    <BorderBottom BorderColor="#336666" BorderStyle="Solid" BorderWidth="1px" />
                                </Cell>
                                <FocusedRow BackColor="WhiteSmoke">
                                </FocusedRow>
                                <Cell ForeColor="Black"></Cell>
                            </Styles>
                          </dx:ASPxGridView>
                    </div>
                </div>
           </div>
           <div id="Nomination" class="tab-pane fade">
                <h3><i class="fa fa-users" aria-hidden="true"></i> Nominee Addition/Remove/Opt out</h3>
                <p>&nbsp;* Nominee addition,Nominee remove, Opt out of Nomination</p>
                <br />
               <div id="divNomination">
                    <div class="row">
                        <div class="col-md-12">
                            <h4><i class="fa fa-list-alt" aria-hidden="true"></i> Available Nominees</h4>
                            <button type="button" id="btnNomineeAddition" class="btn btn-primary btn-sm" style="margin-bottom:20px" onclick="addNomineePopup()" ><i class="fa fa-plus" aria-hidden="true"></i> Nominee addition</button>
                            <button type="button" id="btnOptoutNomination" class="btn btn-danger btn-sm" style="margin-bottom:20px" onclick="optoutNomineeAlert()"><i class="fa fa-times" aria-hidden="true"></i> Opt out of Nomination</button>
                            <input type="hidden" id="hdnNomineesAvailable" name="hdnNomineesAvailable" runat="server" value="">
                            <input type="hidden" id="hdnNomAvailablePercent" name="hdnNomAvailablePercent" runat="server" value="">
                            <input type="hidden"  id="hdnNominee1Share" name="hdnNominee1Share" runat="server" value="">
                            <input type="hidden"  id="hdnNominee2Share" name="hdnNominee2Share" runat="server" value="">
                            <input type="hidden"  id="hdnNominee3Share" name="hdnNominee3Share" runat="server" value="">
                            <dx:ASPxGridView ID="grdNominees" ClientInstanceName="grdNominees" AutoGenerateColumns="False" CssClass="table" Theme="MetropolisBlue" Width="100%" runat="server" OnHtmlRowCreated="grdBanks_HtmlRowCreated">
                                 
                                <Columns>
                                    <dx:GridViewDataMemoColumn FieldName="Descr" CellStyle-HorizontalAlign="Left" Caption="Name" Width="30%" VisibleIndex="0">
                                        <DataItemTemplate>
                                            <span><%# Eval("Descr") %></span>
                                            <br />
                                            <div style=" display:<%# Eval("btnDisplay") %>">
                                            <button type="button" class="btn btn-default btn-xs" onclick="updateNomineePopup('<%# Eval("NomineeNo") %>','<%# Eval("Date") %>','<%# Eval("Prefix") %>','<%# Eval("Descr") %>','<%# Eval("Percent") %>','<%# Eval("Relation") %>','<%# Eval("Add1") %>','<%# Eval("Add2") %>','<%# Eval("Add3") %>','<%# Eval("City") %>','<%# Eval("Pincode") %>','<%# Eval("State") %>','<%# Eval("Country") %>','<%# Eval("Mobile") %>','<%# Eval("Phone") %>','<%# Eval("Email") %>','<%# Eval("IdType") %>','<%# Eval("IdNumber") %>','<%# Eval("IsMinor") %>','<%# Eval("DOB") %>','<%# Eval("GdPrefix") %>','<%# Eval("GdDescr") %>','<%# Eval("GdRelation") %>','<%# Eval("GdAdd1") %>','<%# Eval("GdAdd2") %>','<%# Eval("GdAdd3") %>','<%# Eval("GdCity") %>','<%# Eval("GdPincode") %>','<%# Eval("GdState") %>','<%# Eval("GdCountry") %>','<%# Eval("GdMobile") %>','<%# Eval("GdPhone") %>','<%# Eval("GdEmail") %>','<%# Eval("GdIdType") %>','<%# Eval("GdIdNumber") %>')"><i class="fa fa-edit" aria-hidden="true"></i> Edit</button>
                                            <button type="button" class="btn btn-default btn-xs" onclick="removeNomineeAlert('<%# Eval("NomineeNo") %>','<%# Eval("Descr") %>')"><i class="fa fa-times" aria-hidden="true"></i> Remove</button>
                                            </div>

                                        </DataItemTemplate>
                                        <CellStyle HorizontalAlign="Left"></CellStyle>
                                    </dx:GridViewDataMemoColumn>
                                    <dx:GridViewDataTextColumn FieldName="Add1" Width="35%" Caption="Address" VisibleIndex="1">
                                        <DataItemTemplate>
                                            <span><%# Eval("Add1") %>, <%# Eval("Add2") %>, <%# Eval("Add3") %>, <%# Eval("City") %>, <%# Eval("Pincode") %>, <%# Eval("State") %>, <%# Eval("Country") %></span>
                                        </DataItemTemplate>
                                        <CellStyle HorizontalAlign="Left"></CellStyle>
                                    </dx:GridViewDataTextColumn>
                                    <dx:GridViewDataTextColumn FieldName="Relation" Width="25%" Caption="Relationship" VisibleIndex="2">
                                    </dx:GridViewDataTextColumn>
                                    <dx:GridViewDataTextColumn FieldName="Percent" Width="40px" Caption="%" VisibleIndex="3">
                                        <CellStyle HorizontalAlign="Center"></CellStyle>
                                    </dx:GridViewDataTextColumn>
                                    <dx:GridViewDataTextColumn Width="60px" FieldName="modStatus" Caption="Status" VisibleIndex="4">
                                        <CellStyle HorizontalAlign="Center"></CellStyle>
                                    </dx:GridViewDataTextColumn>
                                </Columns>
                          <SettingsBehavior AllowFocusedRow="True"></SettingsBehavior>
                          <SettingsPager Mode="EndlessPaging">
                          </SettingsPager>
                          <Settings ShowGroupedColumns="True" ShowGroupPanel="False" GridLines="Horizontal" />
                          <SettingsDetail ShowDetailRow="false" />
                          <SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
                          <Styles>
                            <Header Font-Bold="False" Font-Underline="False" VerticalAlign="Middle">
                            </Header>
                            <Cell>
                                <BorderBottom BorderColor="#336666" BorderStyle="Solid" BorderWidth="1px" />
                            </Cell>
                            <FocusedRow BackColor="WhiteSmoke">
                            </FocusedRow>
                            <Cell ForeColor="Black"></Cell>
                        </Styles>
                      </dx:ASPxGridView>
                        </div>
                    </div>
               </div>
           </div>
           <div id="AuthorizedRepresentative" class="tab-pane fade">
                <h3><i class="fa fa-user" aria-hidden="true"></i> Addition of authorized representative</h3>
                <p>&nbsp;* Addition of authorized representative –  The following information of Authorized representative need to be submitted</p>
                <br />
               <div id="divAuthorizedRepresentative">
                    <div class="row">
                        <div class="col-sm-6">
                             <div class="form-group">
                                <label for="authorizedRepresentativeName" class="control-label col-sm-4">Name*:</label>
                                 <div class="col-sm-8">
                                      <input type="text" class="form-control" runat="server" id="authorizedRepresentativeName" maxlength="100">
                                  </div>
                             </div>
                        </div>
                        <div class="col-sm-6">
                             <div class="form-group">
                                <label for="authorizedRepresentativeKYCNo" class="control-label col-sm-4">KYC No.(if available):</label>
                                 <div class="col-sm-8">
                                      <input type="text" class="form-control" runat="server" id="authorizedRepresentativeKYCNo" maxlength="10">
                                  </div>
                             </div>
                        </div>
                    </div>
                   <div class="row" style="padding-top:20px">
                        <div class="col-sm-6">
                             <div class="form-group">
                                <label for="authorizedRepresentativeRelation" class="control-label col-sm-4">Relation*:</label>
                                 <div class="col-sm-8">
                                      <input type="text" class="form-control" runat="server" id="authorizedRepresentativeRelation" maxlength="100">
                                  </div>
                             </div>
                        </div>
                        <div class="col-sm-6">
                        </div>
                    </div>
                    <div class="row" style="padding-top:20px">
                        <div class="col-sm-6">
                                <div class="form-group">
                                <label for="authorizedRepresentativeFatherSpouseName" class="control-label col-sm-4">Father/Spouse Name:</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" runat="server" id="authorizedRepresentativeFatherSpouseName" maxlength="100">
                                    </div>
                                </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="authorizedRepresentativeMotherName" class="control-label col-sm-4">Mother Name:</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" runat="server" id="authorizedRepresentativeMotherName" maxlength="100">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" style="padding-top:20px">
                        <div class="col-sm-6">
                                <div class="form-group">
                                <label for="authorizedRepresentativeDOB" class="control-label col-sm-4">Date of Birth*:</label>
                                    <div class="col-sm-8">
                                        <input type="date" class="form-control" id="authorizedRepresentativeDOB" runat="server">
                                    </div>
                                </div>
                        </div>
                        <div class="col-sm-6">
                                <div class="form-group">
                                <label for="cmbAuthorizedRepresentativeGender" class="control-label col-sm-4">Gender*:</label>
                                    <div class="col-sm-8">
                                        <asp:DropDownList ID="cmbAuthorizedRepresentativeGender" CssClass="form-control" runat="server">
                                            <asp:ListItem Value="M">Male</asp:ListItem>
                                            <asp:ListItem Value="F">Female</asp:ListItem>
                                            <asp:ListItem Value="T">Transgender</asp:ListItem>
                                        </asp:DropDownList>
                                    </div>
                                </div>
                        </div>
                    </div>
                    <div class="row" style="padding-top:20px">
                        <div class="col-sm-6">
                                <div class="form-group">
                                <label for="authorizedRepresentativeNationality" class="control-label col-sm-4">Nationality*:</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" id="authorizedRepresentativeNationality" runat="server" maxlength="100">
                                    </div>
                                </div>
                        </div>
                        <div class="col-sm-6">
                                <div class="form-group">
                                <label for="authorizedRepresentativeAddress" class="control-label col-sm-4">Address*:</label>
                                    <div class="col-sm-8">
                                        <textarea class="form-control" id="authorizedRepresentativeAddress" runat="server" placeholder="Enter Current Address with PIN code" name="authorizedRepresentativeAddress" rows="3"></textarea>
                                    </div>
                                </div>
                        </div>
                    </div>
                   <div class="row" style="padding-top:20px">
                        <div class="col-sm-6">
							<div class="form-group">
								<label for="authorizedRepresentativeMobile" class="control-label col-sm-4">Mobile*:</label>
								<div class="col-sm-8">
									<input type="number"  class="form-control" id="authorizedRepresentativeMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
								</div>
							</div>
                        </div>
                        <div class="col-sm-6">
							<div class="form-group">
								<label for="authorizedRepresentativeEmail" class="control-label col-sm-4">Email*:</label>
								<div class="col-sm-8">
									<input type="text"  class="form-control" id="authorizedRepresentativeEmail" runat="server" placeholder="Email" maxlength="80">
								</div>
							</div>
                        </div>
                    </div>
                    
                   <div class="row" style="padding-top:20px">
                       <div class="col-sm-6">
                            <div class="form-group">
                                <label for="authorizedRepresentativePassportSizePhotoFile" class="control-label col-sm-4">Passport size photo*:</label>
                                <div class="col-sm-8">
                                    <input type="file" class="form-control-file border" name="authorizedRepresentativePassportSizePhotoFile" id="authorizedRepresentativePassportSizePhotoFile" accept='.jpg,.png,.jpeg'>
                                </div>
                            </div>
                       </div>
                       <div class="col-sm-6">
                        <div class="form-group">
                            <label for="authorizedRepresentativeSignatureImageFile" class="control-label col-sm-4">Signature image*:</label>
                            <div class="col-sm-8">
                                <input type="file" class="form-control-file border" id="authorizedRepresentativeSignatureImageFile" name="authorizedRepresentativeSignatureImageFile" accept='.jpg,.png,.jpeg'>
                            </div>
                        </div>
                        </div>
                     </div>
                    <div class="row" style="padding-top:20px">
                        <div class="col-sm-6">
                             <div class="form-group">
                                <label for="authorizedRepresentativePanCard" class="control-label col-sm-4">PAN Card*:</label>
                                 <div class="col-sm-8">
                                      <input type="text" class="form-control" runat="server" id="authorizedRepresentativePanCard"  maxlength="20">
                                  </div>
                             </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="authorizedRepresentativePANFile" class="control-label col-sm-4">Copy of PAN*:</label>
                                <div class="col-sm-8">
                                    <input type="file" class="form-control-file border" id="authorizedRepresentativePANFile" name="authorizedRepresentativePANFile" accept='.jpg,.png,.jpeg,.pdf'>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" style="padding-top:20px">
                        <div class="col-sm-6">
                                <div class="form-group">
                                <label for="authorizedRepresentativeAadhaar" class="control-label col-sm-4">Aadhaar*:</label>
                                    <div class="col-sm-8">
                                        <input type="number" class="form-control" runat="server" id="authorizedRepresentativeAadhaar" maxlength="20" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                                    </div>
                                </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="authorizedRepresentativeAadhaarFile" class="control-label col-sm-4">Copy of Aadhaar (Both side)*:</label>
                                <div class="col-sm-8">
                                    <input type="file" class="form-control-file border" id="authorizedRepresentativeAadhaarFile" name="authorizedRepresentativeAadhaarFile" accept='.jpg,.png,.jpeg,.pdf'>
                                    <span style="color:red; font-size:10px">
                                        1) Upload a single PDF or Image with both sides of the Aadhaar card, <br />
                                        2) Please Blacken or block the first 8 digits of Aadhaar Number to avoid rejection of your Re-KYC request.
                                    </span> 
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div style="text-align:center; padding-top:10px">
                                <button type="button" class="btn btn-md btn-primary btnpadingtop" id="btnAddAuthorizedRepresentative" onclick="AddRequest('Add Authorized Representative')"><i class="fa fa-user-plus" aria-hidden="true"></i> Add Auth Representative</button>
                            </div>
                        </div>
                    </div>
               </div>
           </div>
           <div id="DDPI" class="tab-pane fade">
                <h3><i class="fa fa-user" aria-hidden="true"></i> DDPI addition/revocation</h3>
                <p>&nbsp;* DDPI addition/revocation </p>
                <br />
               <div id="divDDPI">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="alert alert-info" id="divDDPImsg" runat="server">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <table style="width:400px;">
                                <tr>
                                    <td style="width: 211px;">  
                                        <asp:Label ID="Label7" runat="server"   
                                            Text="Request for DDPI change"></asp:Label>  
                                    </td>  
                                    <td style="width: 224px;">
                                        <asp:RadioButtonList ID="rblDDPIAdditionRevocation" runat="server">
                                            <asp:ListItem Value="Addition" Selected="True"> &nbsp; DDPI Addition</asp:ListItem>
                                            <asp:ListItem Value="Revocation"> &nbsp; DDPI Revocation</asp:ListItem>
                                        </asp:RadioButtonList>
                                    </td>
                                 </tr>
                             </table>
                        

                        </div>
                    </div>
                    <div class="row">
                            <div class="col-sm-12">
                                <div style="text-align:center; padding-top:10px">
                                    <button type="button" class="btn btn-md btn-primary btnpadingtop" id="btnDDPIAdditionRevocationRequest" onclick="AddDDPIRequest()"><i class="fa fa-plus" aria-hidden="true"></i> Add Request</button>
                                </div>
                            </div>
                        </div>
               </div>
           </div>
           <div id="Segments" class="tab-pane fade">
                <h3><i class="fa fa-exchange" aria-hidden="true"></i> Update Segments</h3>
                <p>&nbsp;* Update Segments. Segment Addition and Revocation.  </p>
                <br />
               <div id="divSegments">
                    <div class="row">
                        <div class="col-sm-10">
                            <h4><u>Available Segments are:</u></h4>
                            <br />
                            <!--<span>
                                1. If you want to <b>deactivate</b> your old segment, then please uncheck the check box of that segment.
                                <br />
                                <br />
                                2. If you want to <b>activate</b> new segment then check the new segment you want to activate.
                            </span>--> 
                            <div style="padding-left:5%; font-size:20px">
                                <div class="form-check" id="divCheckEquity" runat="server">
                                  <input type="checkbox" class="form-check-input" id="checkEquity" runat="server" name="checkEquity" value="Equity" onchange="selectSegmentsType(this)" >
                                  <label class="form-check-label" for="check1">Equity</label>
                                    <span style="font-size:medium; padding-left:20px" id="spanEquityExchange" runat="server"></span>
                                </div>
                                <div class="form-check" id="divCheckDerivative" runat="server">
                                  <input type="checkbox" class="form-check-input" id="checkDerivative" runat="server" name="checkDerivative" value="Derivative" onchange="selectSegmentsType(this)">
                                  <label class="form-check-label" for="check2">Equity Derivative</label>
                                    <span style="font-size:medium; padding-left:20px;" id="spanDerivativeExchange" runat="server"></span>
                                </div>
                                <div class="form-check" id="divCheckCurrency" runat="server">
                                  <input type="checkbox" class="form-check-input" id="checkCurrency" runat="server" name="checkCurrency" value="Currency" onchange="selectSegmentsType(this)">
                                  <label class="form-check-label" for="check2">Currency</label>
                                    <span style="font-size:medium; padding-left:20px" id="spanCurrencyExchange" runat="server"></span>
                                </div>
                                <div class="form-check" id="divCheckCommodity" runat="server">
                                  <input type="checkbox" class="form-check-input" id="checkCommodity" runat="server" name="checkCommodity" value="Commodity" onchange="selectSegmentsType(this)">
                                  <label class="form-check-label" for="check2">Commodity</label>
                                    <span style="font-size:medium; padding-left:20px" id="spanCommodityExchange" runat="server"></span>
                                </div>
                                <div class="form-check" id="divCheckMF" runat="server">
                                  <input type="checkbox" class="form-check-input" id="checkMF" runat="server" name="checkMF" value="MF" onchange="selectSegmentsType(this)">
                                  <label class="form-check-label" for="checkMF">MF</label>
                                    <span style="font-size:medium; padding-left:20px" id="spanMFExchange" runat="server"></span>
                                </div>
                                <div class="form-check" id="divCheckSLB" runat="server">
                                  <input type="checkbox" class="form-check-input" id="checkSLB" runat="server" name="checkSLB" value="SLB" onchange="selectSegmentsType(this)">
                                  <label class="form-check-label" for="checkSLB">SLB</label>
                                    <span style="font-size:medium; padding-left:20px" id="spanSLBExchange" runat="server"></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div style="padding-left:50px; display:none">
                                <asp:CheckBoxList ID="chblSegments" CssClass="checkbox" Font-Size="Large" onchange="selectSegment()"   runat="server">
                                </asp:CheckBoxList>
                             </div>
                        </div>
                        
                    </div>
                     <div class="row">
                        <div class="col-sm-10">
                            <div style="padding-left:5%; padding-top:20px">
                                <button type="button" class="btn btn-md btn-primary btnpadingtop" id="btnUpdateSegments" onclick="updateSegmentsRequest()"><i class="fa fa-exchange" aria-hidden="true"></i> Update Segments Request</button>
                            </div>
                        </div>
                         <div class="col-sm-2">
                         </div>
                    </div>
                </div>
           </div>
           <div id="FinalSubmission" class="tab-pane fade">
                <h3><i class="fa fa-list-alt" aria-hidden="true"></i> All Modification Requests</h3>
                <p>&nbsp;*Please click on Submit all Request button for final submission </p>
                <br />
                <div class="row">
                    <div class="col-lg-12">
                        <div id="divModificationRequests" runat="server">
                            
                            <button type="button" class="btn btn-success btn-lg" style="margin-bottom:20px" onclick="submitAllRequest();"><i class="fa fa-cloud-download" aria-hidden="true"></i> Submit all Requests</button>
                            <dx:ASPxGridView ID="grdModificationRequests" ClientInstanceName="grdModificationRequests" AutoGenerateColumns="False" CssClass="table" Theme="MetropolisBlue" Width="100%" runat="server" OnHtmlRowCreated="grdBanks_HtmlRowCreated">
                                <Columns>
                                    <dx:GridViewDataTextColumn FieldName="Slno" Width="50px" Caption="Slno" VisibleIndex="0">
                                    </dx:GridViewDataTextColumn>
                                    <dx:GridViewDataTextColumn FieldName="recordType" Width="30%" Caption="Type" VisibleIndex="1">
                                    </dx:GridViewDataTextColumn>
                                     <dx:GridViewDataMemoColumn FieldName="Modification" CellStyle-HorizontalAlign="Left" Caption="Modification" Width="70%" VisibleIndex="2">
                                        <CellStyle HorizontalAlign="Left"></CellStyle>
                                    </dx:GridViewDataMemoColumn>
                          </Columns>
                          <SettingsBehavior AllowFocusedRow="True"></SettingsBehavior>
                          <SettingsPager Mode="EndlessPaging">
                          </SettingsPager>
                          <Settings ShowGroupedColumns="True" ShowGroupPanel="False" GridLines="Horizontal" />
                          <SettingsDetail ShowDetailRow="false" />
                          <SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
                          <Styles>
                            <Header Font-Bold="False" Font-Underline="False" VerticalAlign="Middle">
                            </Header>
                            <Cell>
                                <BorderBottom BorderColor="#336666" BorderStyle="Solid" BorderWidth="1px" />
                            </Cell>
                            <FocusedRow BackColor="WhiteSmoke">
                            </FocusedRow>
                            <Cell ForeColor="Black"></Cell>
                        </Styles>
                      </dx:ASPxGridView>
                        </div>
                    </div>
                </div>
           </div>

           
        </div>

        </div>
        <div class="container" style="margin-top:20px">
            <div class="alert alert-info" style="display:none" id="alertInfoMsg">
              <span id="spanInfoMsg">Indicates a neutral informative change or action.</span>
            </div>
         <div class="progress">
            <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
            </div>
          </div>
            <div class="row">
                <div class="col-md-12">
                    <div id="divErrorMsg" runat="server" style="margin-top:20px; height: 100%; display:none; width: 100%; text-align: center;">
                        <div class="alert alert-danger" role="alert">
				            <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span> <span id="spanError" runat="server"></span>
			            </div>
                        <div id="divLinkReKYCStatus" style="display:none" runat="server">
                            <a id="linkReKYCStatus" runat="server" class="btn btn-info btn-lg">Go to ReKYC Status</a>
                        </div>
		            </div>
                </div>
           </div>
            <div class="row">
                <div class="col-md-12">
                    <div id="divFinalSubmission" style="display:none;">
                        <a data-toggle="tab" class="btn btn-info btn-lg" href="#" id="btnFinalSubmission"  onclick="FinalSubmissionClick()"><i class="fa fa-arrow-circle-down" aria-hidden="true"></i> Final Submission</a>
                        <br />
                        <br />
                    </div>
                </div>
            </div>
        </div>
        <div style="display:none">
            <input type="hidden" id="hdnLatitude" name="hdnLatitude" runat="server" value="">
            <input type="hidden" id="hdnLongitude" name="hdnLongitude" runat="server" value="">
            <input type="hidden" id="hdnTimestamp" name="hdnTimestamp" runat="server" value="">
            <asp:Button ID="btnSubmitModificationRequests" runat="server" Text=""  OnClick="btnSubmitModificationRequests_Click" />
            <input type="hidden" id="hdnBtnSubmitModificationRequestsClicked" name="hdnBtnSubmitModificationRequestsClicked" runat="server" value="">
        </div>

        <div id="modalSelectChanges" class="modal fade">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modalSelectChanges-title" class="modal-title">Please choose which parameter(s) need to be changed</h4>
              </div>
              <div id="modalSelectChanges-body" class="modal-body">
                  <div class="form-check">
                      <label class="form-check-label" for="optionMobile">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionMobile" name="optionMobile" value="Mobile">&nbsp;Mobile
                      </label>
                      : <span runat="server" id="spanMobile"></span>
                    </div>
                  
                    <div class="form-check">
                      <label class="form-check-label" for="optionEmail">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionEmail" name="optionEmail" value="Email">&nbsp;Email
                      </label>
                        : <span runat="server" id="spanEmail"></span>
                    </div>
                    <div class="form-check">
                      <label class="form-check-label" for="optionAddress">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionAddress" name="optionAddress" value="Address">&nbsp;Address
                      </label>
                        : <span runat="server" id="spanAddress"></span>
                    </div>
                    <div class="form-check">
                      <label class="form-check-label" for="optionDateofBirth">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionDateofBirth" name="optionDateofBirth" value="DateofBirth">&nbsp;Date of Birth
                      </label>
                        : <span runat="server" id="spanDateofBirth"></span>
                    </div>
                    <div class="form-check">
                      <label class="form-check-label" for="optionIncomeRange">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionIncomeRange" name="optionIncomeRange" value="IncomeRange">&nbsp;Income Range
                      </label>
                        : <span runat="server" id="spanIncomeRange"></span>
                    </div>
                    <div class="form-check">
                      <label class="form-check-label" for="optionBankDetails">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionBankDetails" name="optionBankDetails" value="BankDetails">&nbsp;Bank Details
                      </label>
                        : <span runat="server" id="spanBankDetails"></span>
                    </div>
                    <div class="form-check">
                      <label class="form-check-label" for="optionDPDetails">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionDPDetails" name="optionDPDetails" value="DPDetails">&nbsp;DP Details
                      </label>
                        : <span runat="server" id="spanDPDetails"></span>
                    </div>
                    <div class="form-check">
                      <label class="form-check-label" for="optionNomination">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionNomination" name="optionNomination" value="Nomination">&nbsp;Nomination
                      </label>
                        : <span runat="server" id="spanNomination"></span>
                    </div>
                    <div class="form-check">
                      <label class="form-check-label" for="optionDDPI">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionDDPI" name="optionDDPI" value="DDPI">&nbsp;DDPI
                      </label>
                        : <span runat="server" id="spanDDPI"></span>
                    </div>
                  <div class="form-check">
                      <label class="form-check-label" for="optionSegments">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionSegments" name="optionSegments" value="Segments">&nbsp;Segments
                      </label>
                      : <span runat="server" id="spanSegments"></span>
                    </div>
                   <div class="form-check">
                      <label class="form-check-label" for="optionAuthorizedRepresentative">
                        <input type="checkbox" class="form-check-input" runat="server" id="optionAuthorizedRepresentative" name="optionAuthorizedRepresentative" value="AuthorizedRepresentative">&nbsp;Authorized Representative
                      </label>
                       : <span runat="server" id="spanAuthorizedRepresentative"></span>
                    </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-lg btn-primary" onclick="continueForchanges();"><i class="fa-solid fa-check"></i> Continue</button>
              </div>
            </div>
          </div>
        </div>

        <div id="AddEditNomineeModal" class="modal fade">
            <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="AddEditNomineeModalHeader"><i class="fa fa-user-plus" aria-hidden="true"></i> Add Nominee</h4>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="hdnAddNomineeValue" name="hdnAddNomineeValue" runat="server" value="">
                    <input type="hidden" id="hdnNomineeMode" name="hdnNomineeMode" runat="server" value="">
                        <ul class="nav nav-tabs">
                        <li class="active"><a data-toggle="tab" href="#ModalNomineeTab">Nominee details</a></li>
                        <li><a data-toggle="tab" href="#ModalNomineeMinorGuardianTab">Minor Nominee Guardian</a></li>
                        </ul>
                        <br>
                    <div class="tab-content">
                        <div id="ModalNomineeTab" class="tab-pane fade in active">
                            <div class="row">
                            <div class="col-sm-5">
                                <label for="txtNomName" class="control-label col-sm-5">Name*:</label>
                                <div class="col-sm-7">
                                    <select class="form-control" id="selectNomPrefix" runat="server">
                                        <option></option>
                                        <option>DR</option>
                                        <option>MD</option>
                                        <option>MISS</option>
                                        <option>MR</option>
                                        <option>MRS</option>
                                        <option>MS</option>
                                        <option>SK</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-7">
                                <div class="form-group">
                                    <div class="col-sm-12">
                                        <input type="text" class="form-control" id="txtNomName" runat="server" placeholder="Full Name"  maxlength="50">
                                    </div>
                                </div>
                            </div>
                        </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomRelation" class="control-label col-sm-4">Relation:</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtNomRelation" runat="server" placeholder="Relation" maxlength="50">
                                            <!--<asp:DropDownList ID="cmbNomRelation" CssClass="form-control" runat="server">
                                                <asp:ListItem Value="01">Spouse</asp:ListItem>
                                                <asp:ListItem Value="02">Son</asp:ListItem>
                                                <asp:ListItem Value="03">Daughter</asp:ListItem>
                                                <asp:ListItem Value="04">Father</asp:ListItem>
                                                <asp:ListItem Value="05">Mother</asp:ListItem>
                                                <asp:ListItem Value="06">Brother</asp:ListItem>
                                                <asp:ListItem Value="07">Sister</asp:ListItem>
                                                <asp:ListItem Value="08">Grandson</asp:ListItem>
                                                <asp:ListItem Value="09">Granddaughter</asp:ListItem>
                                                <asp:ListItem Value="10">Grandfather</asp:ListItem>
                                                <asp:ListItem Value="11">Grandmother</asp:ListItem>
                                                <asp:ListItem Value="13">Others</asp:ListItem>
                                            </asp:DropDownList>-->
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomPercent" class="control-label col-sm-4">Percent*:</label>
                                        <div class="col-sm-8">
                                            <input  type="number" class="form-control" id="txtNomPercent" runat="server" placeholder="% Share">
                                            <input type="hidden"  id="hdnNomResidualPercent" name="hdnNomResidualPercent" runat="server" value="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomAdd1" class="control-label col-sm-4">Address 1*:</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtNomAdd1" runat="server" placeholder="Address 1" maxlength="50">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                    <label for="txtNomAdd2" class="control-label col-sm-4">Address 2:</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" id="txtNomAdd2" runat="server" placeholder="Address 2" maxlength="50">
                                    </div>
                                </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomAdd3" class="control-label col-sm-4">Address 3:</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtNomAdd3" runat="server" placeholder="Address 3" maxlength="50">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomCity" class="control-label col-sm-4">City:</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtNomCity" runat="server" placeholder="City" maxlength="50">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomPincode" class="control-label col-sm-4">Pincode*:</label>
                                        <div class="col-sm-8">
                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtNomPincode" runat="server" placeholder="Pincode">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="cmbNomState" class="control-label col-sm-4">State*:</label>
                                        <div class="col-sm-8">
                                            <asp:DropDownList ID="cmbNomState" CssClass="form-control" runat="server">
                                            </asp:DropDownList>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="cmbNomCountry" class="control-label col-sm-4">Country*:</label>
                                        <div class="col-sm-8">
                                            <asp:DropDownList ID="cmbNomCountry" CssClass="form-control" runat="server">
                                            </asp:DropDownList>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomMobile" class="control-label col-sm-4">Mobile:</label>
                                        <div class="col-sm-8">
                                            <input type="number"  class="form-control" id="txtNomMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomPhone" class="control-label col-sm-4">Phone:</label>
                                        <div class="col-sm-8">
                                        <input type="number"  class="form-control" id="txtNomPhone" runat="server" placeholder="Phone">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomEmail" class="control-label col-sm-4">Email:</label>
                                        <div class="col-sm-8">
                                            <input type="text"  class="form-control" id="txtNomEmail" runat="server" placeholder="Email"  maxlength="50">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="cmbNomIdType" class="control-label col-sm-4">Id Type*:</label>
                                        <div class="col-sm-8">
                                            <asp:DropDownList ID="cmbNomIdType" CssClass="form-control" runat="server">
                                                <asp:ListItem Value="E">UID / AADHAR</asp:ListItem>
                                                <asp:ListItem Value="B">Voter Identity Card</asp:ListItem>
                                                <asp:ListItem Value="A">Passport</asp:ListItem>
                                                <asp:ListItem Value="C">PAN</asp:ListItem>
                                                <asp:ListItem Value="D">Driving License</asp:ListItem>
                                                <asp:ListItem Value="F">NREGA Job Card</asp:ListItem>
                                                <asp:ListItem Value="S01">SSId Issued by CG/SG/SB/RA/PSU/SCB/PFI</asp:ListItem>
                                                <asp:ListItem Value="S02">Simple/SimplifiedID issued by a Gazetted Officer</asp:ListItem>
                                                <asp:ListItem Value="Z">Others</asp:ListItem>
                                            </asp:DropDownList>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomIDNo" class="control-label col-sm-4">Document ID*:</label>
                                        <div class="col-sm-8">
                                        <input type="text"  class="form-control" id="txtNomIDNo" runat="server" placeholder="Document ID"  maxlength="50">
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                    <label for="nomDocAsyncFileUpload" class="control-label col-sm-4">Upload document*:</label>
                                    <div class="col-sm-8">
                                        <ajaxToolkit:AsyncFileUpload ID="nomDocAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="nomDocAsyncFileUpload_UploadedComplete" runat="server" />
                                        <!--<asp:HiddenField ID="hdnNomDocAsyncFileUpload" runat="server" />-->
                                        <span id="spanNomDocAsyncFileUpload" runat="server"></span>
                                    </div>
                                </div>
                                </div>
                                <div class="col-sm-6">
                                    <span style="color:red; font-size:10px">
                                        In case Aadhaar is uploaded, please remember: <br />
                                        1) Upload a single PDF or Image with both sides of the Aadhaar card, <br />
                                        2) Please Blacken or block the first 8 digits of Aadhaar Number to avoid rejection of your Re-KYC request.
                                    </span> 
                                </div>
                            </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="dtNomDateofBirth" class="control-label col-sm-4">Date of Birth*:</label>
                                        <div class="col-sm-8">
                                            <input type="date" class="form-control" id="dtNomDateofBirth" runat="server">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-check">
                                        <label class="form-check-label" for="chkNomIsMinor">
                                            &nbsp;<input type="checkbox" class="form-check-input" onchange="if(this.checked==false){activaTab('ModalNomineeTab');} else {activaTab('ModalNomineeMinorGuardianTab');}"  id="chkNomIsMinor" runat="server" name="chkNomIsMinor">&nbsp;&nbsp; Nominee is minor?
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="ModalNomineeMinorGuardianTab" class="tab-pane fade in">
                            <div class="row">
                            <div class="col-sm-5">
                                <label for="txtNomMinorGuardianName" class="control-label col-sm-5">Name*:</label>
                                <div class="col-sm-7">
                                    <select class="form-control" id="selectNomMinorGuardianPrefix" runat="server">
                                        <option></option>
                                        <option>DR</option>
                                        <option>MD</option>
                                        <option>MISS</option>
                                        <option>MR</option>
                                        <option>MRS</option>
                                        <option>MS</option>
                                        <option>SK</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-7">
                                <div class="form-group">
                                    <div class="col-sm-12">
                                        <input type="text" class="form-control" id="txtNomMinorGuardianName" runat="server" placeholder="Guardian Name" maxlength="50">
                                    </div>
                                </div>
                            </div>
                        </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomMinorGuardianRelation" class="control-label col-sm-4">Relation:</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtNomMinorGuardianRelation" runat="server" placeholder="Relation" maxlength="50">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomMinorGuardianAdd1" class="control-label col-sm-4">Address 1*:</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtNomMinorGuardianAdd1" runat="server" placeholder="Address 1" maxlength="50">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                    <label for="txtNomMinorGuardianAdd2" class="control-label col-sm-4">Address 2:</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" id="txtNomMinorGuardianAdd2" runat="server" placeholder="Address 2" maxlength="50">
                                    </div>
                                </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomMinorGuardianAdd3" class="control-label col-sm-4">Address 3:</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtNomMinorGuardianAdd3" runat="server" placeholder="Address 3" maxlength="50">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomMinorGuardianCity" class="control-label col-sm-4">City:</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control" id="txtNomMinorGuardianCity" runat="server" placeholder="City" maxlength="50">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomMinorGuardianPincode" class="control-label col-sm-4">Pincode*:</label>
                                        <div class="col-sm-8">
                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtNomMinorGuardianPincode" runat="server" placeholder="Pincode">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="cmbNomMinorGuardianState" class="control-label col-sm-4">State*:</label>
                                        <div class="col-sm-8">
                                            <asp:DropDownList ID="cmbNomMinorGuardianState" CssClass="form-control" runat="server">
                                            </asp:DropDownList>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="cmbNomMinorGuardianCountry" class="control-label col-sm-4">Country*:</label>
                                        <div class="col-sm-8">
                                            <asp:DropDownList ID="cmbNomMinorGuardianCountry" CssClass="form-control" runat="server">
                                            </asp:DropDownList>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomMinorGuardianMobile" class="control-label col-sm-4">Mobile:</label>
                                        <div class="col-sm-8">
                                            <input type="number"  class="form-control" id="txtNomMinorGuardianMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomMinorGuardianPhone" class="control-label col-sm-4">Phone:</label>
                                        <div class="col-sm-8">
                                        <input type="number"  class="form-control" id="txtNomMinorGuardianPhone" runat="server" placeholder="Phone">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomMinorGuardianEmail" class="control-label col-sm-4">Email:</label>
                                        <div class="col-sm-8">
                                            <input type="text"  class="form-control" id="txtNomMinorGuardianEmail" runat="server" placeholder="Email" maxlength="50">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="cmbNomMinorGuardianIdType" class="control-label col-sm-4">Id Type*:</label>
                                        <div class="col-sm-8">
                                            <asp:DropDownList ID="cmbNomMinorGuardianIdType" CssClass="form-control" runat="server">
                                                <asp:ListItem Value="E">UID / AADHAR</asp:ListItem>
                                                <asp:ListItem Value="B">Voter Identity Card</asp:ListItem>
                                                <asp:ListItem Value="A">Passport</asp:ListItem>
                                                <asp:ListItem Value="C">PAN</asp:ListItem>
                                                <asp:ListItem Value="D">Driving License</asp:ListItem>
                                                <asp:ListItem Value="F">NREGA Job Card</asp:ListItem>
                                                <asp:ListItem Value="S01">SSId Issued by CG/SG/SB/RA/PSU/SCB/PFI</asp:ListItem>
                                                <asp:ListItem Value="S02">Simple/SimplifiedID issued by a Gazetted Officer</asp:ListItem>
                                                <asp:ListItem Value="Z">Others</asp:ListItem>
                                            </asp:DropDownList>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="txtNomMinorGuardianIDNo" class="control-label col-sm-4">ID No*:</label>
                                        <div class="col-sm-8">
                                        <input type="text"  class="form-control" id="txtNomMinorGuardianIDNo" runat="server" placeholder="ID No" maxlength="50">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                    <label for="nomMinorGuardianDocAsyncFileUpload" class="control-label col-sm-4">Upload document*:</label>
                                    <div class="col-sm-8">
                                        <ajaxToolkit:AsyncFileUpload ID="nomMinorGuardianDocAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="nomMinorGuardianDocAsyncFileUpload_UploadedComplete" runat="server" />
                                        <!--<asp:HiddenField ID="hdnNomGuardianDocAsyncFileUpload" runat="server" />-->
                                        <span id="spanNomGuardianDocAsyncFileUpload" runat="server"></span>
                                    </div>
                                </div>
                                </div>
                                <div class="col-sm-6">
                                    <span style="color:red; font-size:10px">
                                        In case Aadhaar is uploaded, please remember: <br />
                                        1) Upload a single PDF or Image with both sides of the Aadhaar card, <br />
                                        2) Please Blacken or block the first 8 digits of Aadhaar Number to avoid rejection of your Re-KYC request.
                                    </span> 
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
                <div class="modal-footer" style="text-align:center">
                    <div id="divAddEditNomineeModalFooter">
                        <button type="button" class="btn btn-primary" onclick="AddRequest('Add Nominee')">Add Request</button>
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </div>
            </div>
        </div>    
         <div id="AddEditBankModal" class="modal fade">
           <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="AddEditBankModalHeader"><i class="fa fa-university" aria-hidden="true"></i> Add Bank</h4>
                </div>
                <div class="modal-body">
                    <input type="hidden"  id="hdnAddEditBankValue" name="hdnAddEditBankValue" runat="server" value="">
                    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                        <ContentTemplate>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-2">
                                    <label for="txtBankIFSC" class="control-label">IFSC*:</label>
                                </div>
                                <div class="col-sm-6">
                                    <input type="text" class="form-control" id="txtBankIFSC" runat="server" placeholder="Type IFSC">
                                </div>
                                <div class="col-sm-4">
                                    <asp:Button ID="btnFindBank" CssClass="btn btn-info" runat="server" OnClick="btnFindBank_Click" Text="Find Bank" />
                                </div>
                           </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-2"></div>
                                <div class="col-sm-8">
                                    <asp:DropDownList ID="cmbBanks" Visible="false" CssClass="form-control" runat="server">
                                    </asp:DropDownList>
                                 </div>
                             </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-2">
                                    <label for="selectBankType" class="control-label">Type:</label>
                                </div>
                                 <div class="col-sm-4">
                                    <select class="form-control" id="selectBankType" onchange="if(this.value=='Primary'){alertModal('New Bank selected as Primary', 'Your available primary Bank will be automatically changed as <b>secondary</b>');}" runat="server">
                                        <option>Primary</option>
                                        <option selected="selected">Secondary</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row" style="padding-top:10px">
                                <div class="col-sm-2">
                                    <label for="txtBankAcNo" class="control-label">A/C No*:</label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="number" class="form-control" id="txtBankAcNo" runat="server" placeholder="Account number" maxlength="20" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                                 </div>
                             </div>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                     <div id="divBankValidation" runat="server">
                         <input type="hidden" id="hdnBankValidation" name="hdnBankValidation" runat="server" value="">
                         <div class="row" style="padding-top:10px">
                            <div class="col-sm-2">
                                <label for="txtBankAcName" class="control-label">Name*:</label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" class="form-control" id="txtBankAcName" runat="server" placeholder="A/c Name" maxlength="50">
                             </div>
                         </div>
                         <div class="row" style="padding-top:10px">
                             <div class="col-sm-2">
                                <label for="selectBankValidationType" class="control-label">Validation*:</label>
                            </div>
                            <div class="col-sm-5">
                                <select class="form-control" id="selectBankValidationType" runat="server">
                                    <option>Canceled Cheque</option>
                                    <option>Passbook 1st page</option>
                                    <option>Bank Statement</option>
                                </select>
                             </div>
                            <div class="col-sm-5" style="padding-left:30px; padding-top:10px">
                                <div class="form-group">
                                    <ajaxToolkit:AsyncFileUpload ID="bankValidationAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="bankValidationAsyncFileUpload_UploadedComplete" runat="server" />
                                        <span id="spanBankValidationAsyncFileUpload" runat="server"></span>
                                </div>
                            </div>
                        </div>
                     </div>
                </div>
                <div class="modal-footer" style="text-align:center">
                    <div id="divAddEditBankModalFooter">
                        <button type="button" class="btn btn-primary" id="btnAddBankModal" onclick="AddRequest('Add Bank')">Add Request</button>
                        <button type="button" class="btn btn-danger" id="btnAddBankModalCancel" data-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </div>
            </div>
        </div>    

        <div id="confirmSetPrimaryBankModal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">
                  <h3 id="confirmSetPrimaryBankModalHeader"><i class="fa fa-university" aria-hidden="true"></i> Set Primary Bank </h3>
                  <p id="confirmSetPrimaryBankModalbody">Do you really want to set this Bank to Primary?</p>
                  <br />
                  <div class="row" style="padding-top:10px">
                        <div class="col-sm-2">
                            <label for="txtBankAcName" class="control-label">Bank*:</label>
                        </div>
                        <div class="col-sm-8">
                            <input type="text" readonly="readonly" class="form-control" id="txtPrimaryBankName" runat="server">
                         </div>
                     </div>
                  <div class="row" style="padding-top:10px">
                        <div class="col-sm-2">
                            <label for="txtPrimaryBankAcNo" class="control-label">A/C No*:</label>
                        </div>
                        <div class="col-sm-8">
                            <input type="number" readonly="readonly" class="form-control" id="txtPrimaryBankAcNo" runat="server">
                         </div>
                     </div>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <button type="button" class="btn btn-success" data-dismiss="modal" id="btnSetPrimaryBankModalYes" onclick="setPrimaryBank()">Set Primary</button>
                  <button type="button" class="btn btn-danger" data-dismiss="modal">No</button>
              </div>
            </div>
          </div>
        </div>


        <div id="confirmRemoveBankModal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">
                  <h3 id="confirmRemoveBankModalHeader">Remove Bank</h3>
                  <p id="confirmRemoveBankModalbody">Do you really want to remove Bank?</p>
                  <div id="divSelectPrimaryBank" style="display:none">
                      <div class="row">
                        <div class="col-sm-12">
                            <asp:UpdatePanel ID="UpdatePanel4" runat="server">
                                <ContentTemplate>
                                    <h4>Select primary Bank A/c</h4>
                                    <asp:RadioButtonList ID="rblSelectPrimaryBank" runat="server">
                                    </asp:RadioButtonList>
                                </ContentTemplate>
                            </asp:UpdatePanel>

                        </div>
                    </div>
                  </div>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <input type="hidden" id="hdnRemoveBankAcNo" runat="server" name="hdnRemoveBankAcNo" value="">
                  <input type="hidden" id="hdnRemoveBankName" runat="server" name="hdnRemoveBankName" value="">
                  <button type="button" class="btn btn-primary" data-dismiss="modal" id="btnConfirmRemoveBankModalNo">No</button>
                  <button type="button" class="btn btn-danger" data-dismiss="modal" id="btnRemoveBankModalYes" onclick="removeBank(document.getElementById('hdnRemoveBankAcNo').value, document.getElementById('hdnRemoveBankName').value)">Yes</button>
              </div>
            </div>
          </div>
        </div>



        <div id="AddDPModal" class="modal fade">
            <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="AddDPHeader"><i class="fa fa-plus" aria-hidden="true"></i> Add DP</h4>
                </div>
                <div class="modal-body">
                    
                    <div class="row" style="padding-top:10px">
                        
                      <div class="col-sm-6">
                          <div class="form-group">
                              <label for="selectDPType" class="control-label col-sm-4">Type:</label>
                              <div class="col-sm-8">
                                <select class="form-control" id="selectDPType" onchange="if(this.value=='Primary'){alertModal('New DP selected as Primary', 'Your available primary DP will be automatically changed as <b>secondary</b>');}" runat="server">
                                    <option>Primary</option>
                                    <option selected="selected">Secondary</option>
                                </select>
                              </div>
                           </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="txtDPName" class="control-label col-sm-4">DP Name*:</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" id="txtDPName" runat="server" placeholder="DP Name" maxlength="40">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" style="padding-top:10px">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="txtDPID" class="control-label col-sm-4">DP ID*:</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" id="txtDPID" runat="server" maxlength="8" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" placeholder="DP ID">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="txtDPClientID" class="control-label col-sm-4">Client ID*:</label>
                                <div class="col-sm-8">
                                    <input  type="number" class="form-control" id="txtDPClientID" maxlength="8" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"  runat="server" placeholder="Client ID">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" style="padding-top:10px">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="dpClientMasterAsyncFileUpload" class="control-label col-sm-4">Upload Client Master:</label>
                                <div class="col-sm-8">
                                    <ajaxToolkit:AsyncFileUpload ID="dpClientMasterAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="dpClientMasterAsyncFileUpload_UploadedComplete" runat="server" />
                                    <span id="spanDPClientMasterAsyncFileUpload" runat="server"></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                        </div>
                    </div>
                    <div class="row" style="padding-top:10px">
                        <div class="col-sm-2">
                        </div>
                        <div class="col-sm-10">
                            <span class="explanation">WARNING: If the account you are adding is not in our DP, then a signed and stamped copy of the <b>Client Master</b> arranged from your DP will have to be uploaded here. 
                                  If not uploaded, your request will be rejected.</span>
                        </div>
                    </div>
                </div>

                <div class="modal-footer" style="text-align:center">
                    <div id="divAddDPModalFooter">
                        <button type="button" class="btn btn-primary" onclick="AddRequest('Add DP')">Add Request</button>
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </div>
            </div>
        </div>    


        <div id="confirmSetPrimaryDPModal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">
                  <h3 id="confirmSetPrimaryDPModalHeader"><i class="fa fa-university" aria-hidden="true"></i> Set Primary DP </h3>
                  <p id="confirmSetPrimaryDPModalbody">Do you really want to set this DP as Primary?</p>
                  <br />
                  <div class="row" style="padding-top:10px">
                       <div class="col-sm-12">
                            <div class="form-group">
                               <label for="txtSetPrimaryDPName" class="control-label col-sm-4">DP Name:</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly="readonly" class="form-control" id="txtSetPrimaryDPName" runat="server">
                                </div>
                            </div>
                        </div>
                   </div>
                  <div class="row" style="padding-top:10px">
                        <div class="col-sm-12">
                            <div class="form-group">
                               <label for="txtSetPrimaryDPID" class="control-label col-sm-4">DPID:</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly="readonly" class="form-control" id="txtSetPrimaryDPID" runat="server">
                                </div>
                            </div>
                        </div>
                   </div>
                  <div class="row" style="padding-top:10px">
                        <div class="col-sm-12">
                            <div class="form-group">
                               <label for="txtSetPrimaryDPClientID" class="control-label col-sm-4">Client ID:</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly="readonly" class="form-control" id="txtSetPrimaryDPClientID" runat="server">
                                </div>
                            </div>
                        </div>
                     </div>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <input type="hidden" id="hdnSetPrimaryDPID" runat="server" name="hdnSetPrimaryDPID" value="">
                  <button type="button" class="btn btn-success" data-dismiss="modal" id="btnSetPrimaryDPModalYes" onclick="SetPrimaryDP()">Set Primary</button>
                  <button type="button" class="btn btn-danger" data-dismiss="modal">No</button>
              </div>
            </div>
          </div>
        </div>

        <div id="uploadDerivativesDocumentsModal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="modaluploadDerivativesDocumentsLabel"><i class="fa fa-file" aria-hidden="true"></i> Upload Documents for Derivatives </h4>
              </div>
              <div class="modal-body">
                  <span>
                      If you want to <b>active</b> Derivatives segments, then you need to upload Income Proof documents.
                  </span>
                  <div class="row"  style="padding-top:10px">
                        <div class="col-sm-7">
                             <div class="form-group">
                                <label for="cmbDerivativesIncomeProof" class="control-label col-sm-4">Income Proof:</label>
                                 <div class="col-sm-8">
                                     <asp:DropDownList ID="cmbDerivativesIncomeProof" CssClass="form-control" runat="server">
                                        <asp:ListItem Value="01">Bank statement(6 months for F&O/ 3 months for Cash)</asp:ListItem>
                                        <asp:ListItem Value="02">ITR for last 2 years for NI/ ITR for last 1 year for Individual</asp:ListItem>
                                        <asp:ListItem Value="03">Form 16 of Last Assessment Year</asp:ListItem>
                                        <asp:ListItem Value="04">Current Demat holding statement(signed ad stamped)</asp:ListItem>
                                        <asp:ListItem Value="05">Networth certificate certified by CA</asp:ListItem>
                                        <asp:ListItem Value="06">Proof of Ownership of immovable property</asp:ListItem>
                                        <asp:ListItem Value="07">Mutual funds A/c Statement</asp:ListItem>
                                        <asp:ListItem Value="08">FD certificate</asp:ListItem>
                                        <asp:ListItem Value="09">Proof of Investment in Fixed return sequries(bond/debenture etc.)</asp:ListItem>
                                    </asp:DropDownList>
                                  </div>
                            </div>
                        </div>
                        <div class="col-sm-5" style="padding-left:30px">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <table>
                                            <tr>
                                                <td>
                                                    1.* &nbsp;
                                                </td>
                                                <td>
                                                    <div class="form-group" style="padding-top:10px">
                                                        <input type="file" class="form-control-file border" id="derivativesIncomeProofFile" name="derivativesIncomeProofFile" accept='.jpg,.png,.jpeg,.pdf'>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    2.
                                                </td>
                                                <td>
                                                    <div class="form-group" style="padding-top:10px">
                                                        <input type="file" class="form-control-file border" id="derivativesIncomeProofFile2" name="derivativesIncomeProofFile2" accept='.jpg,.png,.jpeg,.pdf'>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                        
                                    </div>
                                </div>
                        </div>
                    </div>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <button type="button" class="btn btn-md btn-success btnpadingtop" id="btnuploadDerivativesDocumentsModalYes" onclick="updateSegmentsRequestWithDerivativesDocuments()"><i class="fa fa-upload" aria-hidden="true"></i> Upload Documents</button>
              </div>
            </div>
          </div>
        </div>

    </form>
    
<!-- Modal -->
<div class="modal fade" id="modalTerms" tabindex="-1" role="dialog" aria-labelledby="modalTermsLabel">
  <div class="modal-dialog modal-lg" style=" height: 97%;">
    <div class="modal-content" style=" height: 97%;">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h2 class="modal-title" id="modalTermsLabel">Terms and Conditions</h2>
      </div>
      <div class="modal-body" style="max-height: calc(75%);  overflow-y: scroll;">
          <div id="divLoading" runat="server" style="display:none">
            <center>
                <h3>Please wait..Your request is being processed..</h3>
                <p>Do not close browser window....</p>
                <img src="Loading.gif" alt="Loading" style="width:150px;">
            </center>
         </div>
          <div id="divtermsandconditionsHTML">
              <%=termsandconditionsHTML%>
          </div>

      </div>

      <div class="modal-footer">
          <div id="divSubmitBtns">
            <p id="divLocation" style="font-size:10px"></p>
            <button type="button" class="btn btn-primary btn-lg" id="btnPDFDownload" onclick="clickBtnSubmitAllRequest('2');"><i class="fa fa-file-pdf" aria-hidden="true"></i> Download PDF</button>
            <button type="button" class="btn btn-success btn-lg" id="btnIAgree" onclick="clickBtnSubmitAllRequest('3');"><i class="fa fa-check" aria-hidden="true"></i> I Agree and Submit</button>
          </div>
        
      </div>
    </div>
  </div>
</div>
    

     <div id="RiskDisclosureAlertModal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h2 id="RiskDisclosureAlertModalTitle" class="modal-title">RISK DISCLOSURES ON DERIVATIVES</h2>
              </div>
              <div id="RiskDisclosureAlertModalBody" class="modal-body">
                   <div class="entry-content">
                <p>
                   <i class="fa-solid fa-arrow-right"></i> 9 out of 10 individual traders in equity Futures and Options Segment, incurred net losses.
                </p>
                <p>
                   <i class="fa-solid fa-arrow-right"></i> On an average, loss makers registered net trading loss close to Rs 50,000.
                </p>
                <p>
                   <i class="fa-solid fa-arrow-right"></i> Over and above the net trading losses incurred, loss makers expended an additional 28% of net trading losses as transaction costs.
                </p>
                <p>
                    <i class="fa-solid fa-arrow-right"></i> Those making net trading profits, incurred between 15% to 50% of such profits as transaction cost.
                </p>
                       </div>

              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-lg btn-danger" data-dismiss="modal">I Agree and Accepting</button>
              </div>
            </div>
          </div>
        </div>

    <div id="alert-modal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="alert-modal-title" class="modal-title"></h4>
              </div>
              <div id="alert-modal-body" class="modal-body"></div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">OK</button>
              </div>
            </div>
          </div>
        </div>

     <div id="confirmOptoutNominationModal" class="modal fade">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4>Opt-out of Nomination</h4>
              </div>
              <div class="modal-body">
                  <p id="confirmOptoutModalbody">Do you really want to Opt-out of Nomination?</p>
                  <p><b>Note:</b> Your existing nominees will be deleted if any available.</p>
                  <h4><u>Declaration</u></h4>
                  <p>
                      I / We hereby confirm that I / We do not wish to appoint any nominee(s) in my / our trading / Demat account and understand the issues involved in non-appointment of nominee(s) and further are aware that in case of death of all the account holder(s), my / our legal heirs would need to submit all the requisite documents / information for claiming of assets held in my / our trading / Demat account, which may also include documents issued by Court or other such competent authority, based on the value of assets held in the trading / Demat account.
                  </p>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <button type="button" class="btn btn-primary" data-dismiss="modal" id="btnConfirmOptoutNominationModalNo">No, I don't agree</button>
                  <button type="button" class="btn btn-danger" data-dismiss="modal" id="btnConfirmOptoutNominationModalYes" onclick="AddRequest('Opt out of Nomination')">Yes, I agree and want to opt out</button>
              </div>
            </div>
          </div>
        </div>

    <div id="confirmRemoveNomineeModal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">
                  <h3 id="confirmRemoveNomineeModalHeader">Remove nominee</h3>
                  <p id="confirmRemoveNomineeModalbody">Do you really want to remove nominee?</p>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <input type="hidden" id="hdnRemoveNomineeNo" name="hdnRemoveNomineeNo" value="">
                  <input type="hidden" id="hdnRemoveNomineeName" name="hdnRemoveNomineeName" value="">
                  <button type="button" class="btn btn-primary" data-dismiss="modal" id="btnConfirmRemoveNomineeModalNo">No</button>
                  <button type="button" class="btn btn-danger" data-dismiss="modal" id="btnRemoveNomineeModalYes" onclick="removeNominee(document.getElementById('hdnRemoveNomineeNo').value, document.getElementById('hdnRemoveNomineeName').value)">Yes</button>
              </div>
            </div>
          </div>
        </div>

    
    <div id="OpenDigiLockerModal" class="modal fade">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-body">
                  <h3><i class="fa fa-cloud-download" aria-hidden="true"></i> Fetch your data from DigiLocker</h3>
                  <div class="row">
                     <div class="col-md-6">
                         <div class="alert alert-warning">
                          <strong><i class="fa fa-exclamation-circle" aria-hidden="true"></i></strong> If you are looking for modifications such as 
                            <h5><b> Address, Date of Birth, Mobile and Email </b></h5> then you can pull data from <b>DigiLocker</b>.
                        </div>
                        <p>
                            Share your Aadhaar and PAN related information from DigiLocker account for ReKYC. Your Aadhaar number/copy will not be stored.
                        </p>
                        <p>
                            The Aadhaar <b><span id="spanAadhaar" runat="server"></span></b> and PAN <b><span id="spanPAN" runat="server"></span></b> should belong to you, the applicant, if it does not, your application will be rejected.

                        </p>
                        <p>
                            Your name <b><span id="spanName" runat="server"></span></b> also must match in Aadhaar, if it does not, then you can resolve the name mismatch issue by changing your name on the PAN Card from <a href="https://www.onlineservices.nsdl.com/paam/endUserRegisterContact.html">NSDL</a>  or on the Aadhaar Card from <a href="https://www.uidai.gov.in">UIDAI</a>.
                        </p>
                      </div>
                      <div class="col-md-6">
                        <h4>What is DigiLocker</h4>
                        <p>
                            DigiLocker is a digitization service provided by the Indian Ministry of Electronics and Information Technology under its Digital India initiative. DigiLocker allows access to digital versions of various documents
                        </p>
                                              
                        <h4>Why do we need your DigiLocker?</h4>
                        <p>
                            Automatically fetch Name, Gender, Address, Date of Birth, Masking Aadhaar and Pan verification record for ReKYC Modification and KRA update.
                        </p>
                        <p>
                        Your full Aadhaar number is never visible or available to us
                        </p>
                    </div>
                  </div>
                  <p>
                    <br />
                    <i>
                    *By clicking the below 'Go with DigiLocker' button, I agree that i have read <a href="#">Aadhaar user consent document</a> an voluntarily consent to share my Aadhaar information (excluding the Aadhaar number) with <b><span id="spanBrokerName" runat="server"></span></b> for conducting online KYC for openinig a trading and demat account adhering to KRA regulation 2011 and PMLA guidelines 2002.
                    </i>
                </p>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <button type="button" class="btn btn-success btn-lg" id="btnDigiLocker" onclick="ContinueDigiLocker('DigiLocker');" style="margin-top:5px" runat="server" ><i class="fa fa-cloud-download" aria-hidden="true"></i> Go with DigiLocker</button>
                  <button type="button" class="btn btn-info btn-lg" id="btnManually" onclick="ContinueDigiLocker('Manually');" style="margin-top:5px" runat="server" ><i class="fa fa-share" aria-hidden="true"></i> Go through Manually</button>
                  <p style="padding-top:10px">
                      <strong><i class="fa fa-exclamation-circle" aria-hidden="true"></i></strong> If you <b>don’t</b> have Aadhaar card, Pancard access linked with DigiLocker, please click on <b>“Go through Manually”</b> to continue.
                  </p>
                  
              </div>
            </div>
          </div>
        </div>

    <div class="modal fade" id="modalLoading" tabindex="-1" role="dialog" aria-labelledby="modalLoadingLabel">
      <div class="modal-dialog modal-md">
        <div class="modal-content">
          <div class="modal-header">
          </div>
          <div class="modal-body">
              <center>
                    <h4>Please wait..Your request is being processed..</h4>
                    <p>Do not close browser window....</p>
                    <img src="../ekyc/images/Loading.gif" alt="Loading" style="width:150px;" />
               </center>
          </div>

          <div class="modal-footer">
          </div>
        </div>
      </div>
    </div>

    <script>

        //AdjustSize();

        //function AdjustSize() {
        //    var height = Math.max(0, document.documentElement.clientHeight);
        //    grdModificationRequests.SetHeight(height - 150);
        //}

    </script>


</body>
</html>
