﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="eSign.aspx.cs" Inherits="Connect_DotNet.ReKYC.eSign" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>Esign</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link href="../eKyc/css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />
    
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="../eKyc/js/ekyc.js"></script>

        

    <script>

         window.onload = function () {

             if (document.getElementById('hdnMsgModalOpen').value != "") {

                 const hdnMsgModalOpenArray = document.getElementById('hdnMsgModalOpen').value.split("####");
                 var titleMsg = hdnMsgModalOpenArray[0];
                 var Msg = hdnMsgModalOpenArray[1];

                 document.getElementById('hdnMsgModalOpen').value = "";
                 alertModal(titleMsg, Msg);
                 

             }

             getLocation();

             if (document.getElementById('hdnBtnContinueClicked').value == "") {
                  showModalLoading();
                 setTimeout(function() { processStart(); }, 1000);
             }
             
        }

        function processStart() {

            document.getElementById('hdnBtnContinueClicked').value = "0";
            document.getElementById('<%= btnContinueClick.UniqueID %>').click();

        }
 

         function getLocation() {
             if (navigator.geolocation) {
                 navigator.geolocation.getCurrentPosition(showPosition);
             } else {
                 document.getElementById("divLocation").innerHTML = "Geolocation is not supported by this browser.";
             }
         }

         function showPosition(position) {

             let date = new Date(); // object of the date class
             
             let timestamp = ("0" + date.getDate()).slice(-2) + '-' + ("0" + (date.getMonth() + 1)).slice(-2) + '-' + date.getFullYear() + ' ' + date.toString().replace(/^.+(\d{2}:\d{2}:\d{2}.+)\(.+$/,"$1");
             

             document.getElementById("divLocation").innerHTML = "Latitude: " + position.coords.latitude +
                 ", Longitude: " + position.coords.longitude +
                 ", Timestamp: " + timestamp;


             document.getElementById("hdnLatitude").value = position.coords.latitude;
             document.getElementById("hdnLongitude").value = position.coords.longitude;
             document.getElementById("hdnTimestamp").value = timestamp;


         }

        function saveData(actionType) {

            document.getElementById('hdnBtnContinueClicked').value = actionType;

            if (actionType != "1") {
                showModalLoading();
            }

            document.getElementById('<%= btnContinueClick.UniqueID %>').click();

        }


    </script>

</head>
<body>
    <form id="form1" runat="server">
        <br />
        <section class="vh-100">
              <div class="container h-100">
                  <div style="padding-left:5px">
                     <div class="row">
                        <div class="col-md-3">
                            <center>
                            <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px; padding-top:10px">
                            </center>
                        </div>
                        <div class="col-md-9">
                            <h1 class="lblTopHeader"><i class="fa fa-pencil" aria-hidden="true"></i> eSign PDF</h1>
                            <p>Online electronic signature service that can facilitate an Aadhaar holder to digitally sign a document</p>
                        </div>
                     </div>
                      <div class="progress">
                        <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                        </div>
                      </div>
                  </div>
                  <div class="row d-flex justify-content-center align-items-center">
                  <div class="col-lg-12 col-xl-11">
                    <div class="card text-black" style="border-radius: 25px;">
                      <div class="card-body p-md-5">
                        <div class="row justify-content-center">
                          <div class="col-md-12">
                                <div style="display:none">
                                <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                <input type="hidden" id="hdnMsgModalOpen" name="hdnMsgModalOpen" runat="server" value="">
                                </div>
                                <div class="d-flex flex-row align-items-center mb-4">
                                    <div class="form-outline flex-fill mb-0">
                                        <div id="divReloadPage" style="display:none" runat="server">
                                            <button type="button" class="btn btn-info btn-lg" id="btnReloadPage" style="margin-top:5px" onclick="location.replace('eSign.aspx');"><i class="fa-solid fa-rotate-right"></i> Reload Page</button>
                                        </div>
                                        <div id="divMainModalContent" runat="server">
                                            <div class="modal-dialog modal-lg" style="width:98%!important; margin-top:2px!important">
                                            <div class="modal-content">
                                              <div class="modal-header">
                                                <h2 class="modal-title" id="modalTermsLabel">Terms and Conditions</h2>
                                              </div>
                                              <div class="modal-body" style="max-height: calc(75%);">
                                                  <div id="divLoading" runat="server" style="display:none">
                                                    <center>
                                                        <h3>Please wait..Your request is being processed..</h3>
                                                        <p>Do not close browser window....</p>
                                                        <img src="images/Loading.gif" alt="Loading" style="width:150px;">
                                                    </center>
                                                 </div>
                                                  <div id="divtermsandconditionsHTML" runat="server">
                                                  </div>

                                              </div>

                                              <div class="modal-footer">
                                                  <div id="divSubmitBtns">
                                                      <input type="hidden" id="hdnLatitude" name="hdnLatitude" runat="server" value="">
                                                      <input type="hidden" id="hdnLongitude" name="hdnLongitude" runat="server" value="">
                                                      <input type="hidden" id="hdnTimestamp" name="hdnTimestamp" runat="server" value="">
                                                      <p id="divLocation"></p>
                                                      <button type="button" class="btn btn-primary btn-lg" id="btnPDFDownload" style="margin-top:5px" onclick="saveData('1');"><i class="fa fa-file-pdf" aria-hidden="true"></i> Preview PDF</button>
                                                      <button type="button" class="btn btn-success btn-lg" id="btnIAgree" style="margin-top:5px" onclick="saveData('2');"><i class="fa fa-check" aria-hidden="true"></i> I Agree and Continue</button>
                                                  </div>
                                                  <br />
                                              </div>
                                            </div>
                                          </div>
                                        </div>
                                    </div>
                                      <hr />
                                    <div id="divPreviousSteps" runat="server">
                                        <h4>Go to previous step </h4> 
                                        <ul class="list-inline">
                                        <li><a href="ConfirmDetails.aspx?cnfmrset=1" id="hlinkChooseParameters" runat="server"><i class="fa fa-solid fa-list-check" aria-hidden="true"></i> Reset Modifications</a></li>
                                        <li><a href="contact.aspx" id="hlinkContact" runat="server"><i class="fas fa-envelope fa-lg me-3 fa-fw" aria-hidden="true"></i> Contact</a></li>
                                        <li><a href="DigiLockerKYC.aspx" id="hlinkDigiLocker" runat="server"><i class="fa fa-cloud-download" aria-hidden="true"></i> DigiLocker</a></li>
                                        <li><a href="manuallyProcessing.aspx" id="hlinkManuallyProcessing" runat="server"><i class="fa fa-id-card" aria-hidden="true"></i> <span id="spanManuallyProcessing" runat="server">Address|DOB</span> </a></li>
                                        <li><a href="takePhoto.aspx" id="hlinkCapturePhoto" runat="server"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                        <li><a href="incomeProfile.aspx" id="hlinkIncomeProfile" runat="server"><i class="fa fa-inr" aria-hidden="true"></i> Income Profile</a></li>
                                        <li><a href="TradingPreference.aspx" id="hlinkTradingPreference" runat="server"><i class="fa fa-exchange" aria-hidden="true"></i> Trading Preference</a></li>
                                        <li><a href="BankDetails.aspx" id="hlinkBankDetails" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Bank</a></li>
                                        <li><a href="Nomination.aspx" id="hlinkNomination" runat="server"><i class="fa fa-users" aria-hidden="true"></i> Nomination</a></li>
                                        <li><a href="dematAccount.aspx" id="hlinkDematAccount" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Demat Account</a></li>
                                        <li><a href="AuthorizedRepresentative.aspx" id="hlinkAuthorizedRepresentative" runat="server"><i class="fa fa-user-circle" aria-hidden="true"></i> Authorized Representative</a></li>
                                        <li><a href="uploadDocuments.aspx" id="hlinkUploadDocuments" runat="server"><i class="fa fa-upload" aria-hidden="true"></i> Upload documents</a></li>
                                       </ul>
                                   </div>
                                  
                                </div>
                           </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                   <div class="row">
                        <div class="col-sm-6" >

                        </div>
                        <div class="col-sm-6 poweredBy" style="text-align:right;">
                        <span style="font-size:small;text-align:right">Powered by</span></br>
				        <a href="http://www.stansoftware.com">
					        <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						        </a>
			            </div>
                     </div>
                </div>
        </section>
          
    </form>


</body>
</html>
