﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="incomeProfile.aspx.cs" Inherits="Connect_DotNet.ReKYC.incomeProfile" %>

<!DOCTYPE html>

<html>
<head>
  <title>Income Profile</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  

  <!--
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/js/bootstrap.bundle.min.js"></script>
  -->
  
    <!--<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.slim.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
      -->

    <link href="../eKyc/css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="../eKyc/js/ekyc.js"></script>    

</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }

    </style>
     <script>

         function saveData() {

             if (document.getElementById('txtAnnualIncome').value == "") {
                 alertModal("Opps! Problem with the Annual Income", "Please enter your Annual Income");
                 return;
             }

             if (document.getElementById('txtAnnualIncome').value < 1) {
                 alertModal("Opps! Problem with the Annual Income", "Annual Income can't be 0 or negative");
                 return;
             }

             if (document.getElementById('txtTradingExperience').value == "") {
                 document.getElementById('txtTradingExperience').value = 0;
             }

             if (document.getElementById('txtTradingExperience').value != "") {

                 if (document.getElementById('txtTradingExperience').value < 0) {
                     alertModal("Error", "Trading Experience can't negetive!");
                     return;
                 }

             }
             

             if (document.getElementById('selectOccupation').value == "") {
                 alertModal("Error", "Please select Occupation!");
                 return;
             }
             

             document.getElementById('hdnBtnContinueClicked').value = "Continue";

             showModalLoading();
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
             
         }

         

        
    </script>
    


    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                <div class="col-md-3">
                    <center>
                    <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px; padding-top:10px">
                    </center>
                </div>
                <div class="col-md-6">
                    <h2 class="lblTopHeader"><i class="fa fa-inr" aria-hidden="true"></i> Income Profile</h2>
                    <p>Fill your annual income  and other relevant details</p>
                </div>
                <div class="col-md-3" style="display:flex;flex-direction:column;align-items:flex-end;">
                        <h5 id="hFullName" style="margin:0px;" runat="server"></h5>
                        <span>UCC: <span id="spanUCC" runat="server"></span></span>
                        <span>DOB: <span id="spanDOB" runat="server"></span></span>
                        <span>PAN: <span id="spanPAN" runat="server"></span></span>
                        <span style="display:none">Aadhaar: <span id="spanAadhaar" runat="server"></span></span>
                        <span id="spanMobile" runat="server"></span>
                        <span id="spanEmail" runat="server"></span>
                   </div>
              </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">

                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div class="row">
                                          <div class="col-md-6">
                                              <div class="form-outline flex-fill mb-0">
                                                  <label class="form-label" for="rdblMaritalStatus"><i class="fa fa-users fa-lg" aria-hidden="true"></i> Marital status*: </label>
                                                  <asp:RadioButtonList ID="rdblMaritalStatus" RepeatLayout="Flow" RepeatDirection="Horizontal" runat="server">
                                                    <asp:ListItem class="radio-inline" Value="S" Text="Single" Selected="True"></asp:ListItem>
                                                    <asp:ListItem class="radio-inline" Value="M" Text="Married"></asp:ListItem>
                                                    <asp:ListItem class="radio-inline" Value="W" Text="Widowed"></asp:ListItem>
                                                    <asp:ListItem class="radio-inline" Value="D" Text="Divorced"></asp:ListItem>
                                                    <asp:ListItem class="radio-inline" Value="SE" Text="Separated"></asp:ListItem>
                                                   </asp:RadioButtonList>
                                              </div>
                                              <br />
                                              <div class="form-outline flex-fill mb-0">
                                                  <label class="form-label" for="txtAnnualIncome"><i class="fa fa-inr fa-lg" aria-hidden="true"></i> Annual Income*</label>
                                                  <input type="number"  class="form-control" id="txtAnnualIncome" maxlength="30" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Annual Income in Rs.">
                                                  <!--<asp:DropDownList ID="cmbIncomeRange" CssClass="form-control" runat="server">
                                                    <asp:ListItem Value="0001">Upto Rs. 100000</asp:ListItem>
                                                    <asp:ListItem Value="0006">Rs. 100001 - 500000</asp:ListItem>
                                                    <asp:ListItem Value="0007">Rs. 500001 - 1000000</asp:ListItem>
                                                    <asp:ListItem Value="0008">Rs. 1000001 - 2500000</asp:ListItem>
                                                    <asp:ListItem Value="0009">More than Rs. 2500000</asp:ListItem>
                                                    <asp:ListItem Value="0010">Rs. 2500001 - 10000000</asp:ListItem>
                                                    <asp:ListItem Value="0011">More than Rs. 10000000</asp:ListItem>
                                                </asp:DropDownList>-->
                                               </div>
                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                  <label class="form-label" for="txtTradingExperience"><i class="fa fa-calendar" aria-hidden="true"></i> Trading Experience (in years)</label>
                                                  <input type="number"  class="form-control" id="txtTradingExperience" maxlength="2" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Trading Experience in Years.">
                                               </div>
                                              <div class="form-outline flex-fill mb-0 margineTop10">
                                                <label class="form-label" for="selectOccupation"><i class="fa fa-briefcase fa-lg me-3 fa-fw"></i> Occupation</label>
                                                  <select class="form-control" id="selectOccupation" runat="server">
                                                      <option>Service</option>
                                                      <option>Student</option>
                                                      <option>Housewife</option>
                                                      <option>Retired</option>
                                                      <option>Business</option>
                                                      <option>Professional</option>
                                                      <option>Agriculture</option>
                                                      <option>Landlord</option>
                                                      <option>Private Sector</option>
                                                      <option>Public Sector</option>
                                                      <option>Government Sector</option>
                                                      <option>Others</option>
                                                   </select>
                                              </div>
                                              <br />
                                              <div class="form-check form-switch">
                                                  <label class="form-check-label" for="checkPoliticallyExposed">Are you politically exposed?</label>
                                                  <input class="form-check-input" type="checkbox" id="checkPoliticallyExposed" runat="server" name="darkmode" value="yes">
                                              </div>
                                              <br />
                                              <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                                  <button type="button" class="btn btn-success btn-lg" id="btnContinue" onclick="saveData();" runat="server" ><i class="fa fa-check" aria-hidden="true"></i> Save & Continue</button>
                                  
                                                  <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                                  </div>
                                                  <br />
                                                  <br />
                                              </div>
                                          </div>
                                          <div class="col-md-6">
                                             <div class="row">
                                                  <div class="col-xs-6">
                                                      <center>
                                                      <img id="ImgAadhaar" width="160" height="200" src="" alt="Aadhaar Photo" runat="server">
                                                      <br />
                                                      <span>Fetch from Aadhaar</span>
                                                       </center>
                                                  </div>
                                                  <div class="col-xs-6">
                                                      <center>
                                                      <img id="ImgLivePhotoCaptured" width="160" height="200" src="" alt="Aadhaar Photo" runat="server">
                                                      <br />
                                                      <span>Live photo captured</span>
                                                       </center>
                                                  </div>
                                              </div>
                                                <div class="row">
                                                  <div class="col-xs-12">
                                                      <p style="margin-top:40px">
                                                          Address : <span id="spanAddress" runat="server"></span>
                                                     </p>
                                                  </div>
                                                </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                              

                            </ContentTemplate>
                        </asp:UpdatePanel>
                          <hr />
                         <div id="divPreviousSteps" runat="server">
                              <h4>Go to previous step </h4> 
                             <ul class="list-inline">
                                 <li><a href="ConfirmDetails.aspx?cnfmrset=1" id="hlinkChooseParameters" runat="server"><i class="fa fa-solid fa-list-check" aria-hidden="true"></i> Reset Modifications</a></li>
                                <li><a href="contact.aspx" id="hlinkContact" runat="server"><i class="fas fa-envelope fa-lg me-3 fa-fw" aria-hidden="true"></i> Contact</a></li>
                                <li><a href="DigiLockerKYC.aspx" id="hlinkDigiLocker" runat="server"><i class="fa fa-cloud-download" aria-hidden="true"></i> DigiLocker</a></li>
                                <li><a href="manuallyProcessing.aspx" id="hlinkManuallyProcessing" runat="server"><i class="fa fa-id-card" aria-hidden="true"></i> <span id="spanManuallyProcessing" runat="server">Address|DOB</span> </a></li>
                                <li><a href="takePhoto.aspx" id="hlinkCapturePhoto" runat="server"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                <li><a href="TradingPreference.aspx" id="hlinkTradingPreference" runat="server"><i class="fa fa-exchange" aria-hidden="true"></i> Trading Preference</a></li>
                                <li><a href="BankDetails.aspx" id="hlinkBankDetails" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Bank</a></li>
                                <li><a href="Nomination.aspx" id="hlinkNomination" runat="server"><i class="fa fa-users" aria-hidden="true"></i> Nomination</a></li>
                                <li><a href="dematAccount.aspx" id="hlinkDematAccount" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Demat Account</a></li>
                                <li><a href="AuthorizedRepresentative.aspx" id="hlinkAuthorizedRepresentative" runat="server"><i class="fa fa-user-circle" aria-hidden="true"></i> Authorized Representative</a></li>
                                <li><a href="uploadDocuments.aspx" id="hlinkUploadDocuments" runat="server"><i class="fa fa-upload" aria-hidden="true"></i> Upload documents</a></li>
                            </ul>
                       </div>

                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
                      <br />
                      <br />
			    </div>
                
             </div>

          </div>
        </section>
    </form>
     

</body>
</html>
