﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="manuallyProcessing.aspx.cs" Inherits="Connect_DotNet.ReKYC.manuallyProcessing" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<!DOCTYPE html>

<html>
<head runat="server">
  <title> Manually processing</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link href="../eKyc/css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />
    
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="../eKyc/js/ekyc.js"></script>    

</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }


    </style>
     <script>

          window.onload = function () {

             
         }

         function isElementHidden(element) {
            const style = window.getComputedStyle(element);
            return style.display === "none";
        }

         function SameAsPresentDetailsClick(chkbxSameDetails) {
             if (chkbxSameDetails.checked == false) {
                 document.getElementById('txtAdd1').value = "";
                 document.getElementById('txtAdd2').value = "";
                 document.getElementById('txtAdd3').value = "";
                 document.getElementById('txtPincode').value = "";
                 document.getElementById('txtCity').value = "";
                 document.getElementById('cmbState').value = "";
                 document.getElementById('cmbCountry').value = "";
             }
             else {
                 setTimeout(function () {
                     location.reload();
                 }, 200);
             }
         }

         function saveData() {

             if (!isElementHidden(document.getElementById('divAddress'))) {

                 if (document.getElementById('txtAdd1').value == "") {
                     alertModal("Opps! Problem with the Address", "Please enter the Address 1");
                     return;
                 }
                 if (document.getElementById('txtPincode').value == "") {
                     alertModal("Opps! Problem with the Address", "Please enter the Pincode");
                     return;
                 }

                 if (document.getElementById('cmbState').value == "") {
                     alertModal("Opps! Problem with the Address", "Please select the State");
                     return;
                 }

                 if (document.getElementById('cmbCountry').value == "") {
                     alertModal("Opps! Problem with the Address", "Please select the Country");
                     return;
                 }
             }

              if (!isElementHidden(document.getElementById('divDOB'))) {

                if (document.getElementById('dtDateofBirth').value == "") {
                    alertModal("Opps! Problem with the Date of Birth", "Please enter your Date of Birth");
                    return;
                }
               
             }

             showModalLoading();

             document.getElementById('<%= btnContinueClick.UniqueID %>').click();

         }

         

        
    </script>
    


    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                <div class="col-md-3">
                    <center>
                    <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px; padding-top:10px">
                    </center>
                </div>
                <div class="col-md-6">
                    <h2 class="lblTopHeader"><i class="fa fa-user" aria-hidden="true"></i> Manually processing</h2>
                    <p>Too bad you will now need to enter your details and also upload some documents manually</p>
                </div>
                <div class="col-md-3" style="display:flex;flex-direction:column;align-items:flex-end;">
                    <h5 id="hFullName" style="margin:0px;" runat="server"></h5>
                    <span>UCC: <span id="spanUCC" runat="server"></span></span>
                    <span>DOB: <span id="spanDOB" runat="server"></span></span>
                    <span>PAN: <span id="spanPAN" runat="server"></span></span>
                    <span>Aadhaar: <span id="spanAadhaar" runat="server"></span></span>
                    <span id="spanMobile" runat="server"></span>
                    <span id="spanEmail" runat="server"></span>
                </div>
              </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">

                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0">
                                      <div class="row">
                                          <div class="col-md-8">
                                              <div id="divData">
                                                  <div id="divAddress" runat="server" style="display:none">
                                                      <h3>Address</h3>
                                                      <hr />
                                                       <div class="row">
                                                            <div class="col-sm-12">
                                                                <div class="form-group">
                                                                    <label for="txtOldAddress" class="control-label col-sm-3">Existing Address:</label>
                                                                    <div class="col-sm-9">
                                                                        <textarea class="form-control" id="txtOldAddress" runat="server" placeholder="NA" readonly="readonly"  name="txtOldAddress" rows="4"></textarea>
                                                                        <br />
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                      <div id="divChangeNewAddress" runat="server" style="display:none">
                                                          <div class="row" style="padding-top:10px; padding-left:15px">
                                                              <div class="col-sm-6">
                                                                   <h4>Copy from existing Address <input type="checkbox" onchange="SameAsPresentDetailsClick(this)" data-on="Yes" data-off="No" checked data-toggle="toggle"></h4>
                                                              </div>
                                                          </div>
                                                      </div>
                                                        <div class="row" style="padding-top:10px">
                                                            <div class="col-sm-6">
                                                                <div class="form-group">
                                                                    <label for="txtAdd1" class="control-label col-sm-4">Address 1*:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtAdd1" runat="server" placeholder="Address 1" maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <div class="form-group">
                                                                <label for="txtAdd2" class="control-label col-sm-4">Address 2:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="text" class="form-control" id="txtAdd2" runat="server" placeholder="Address 2" maxlength="50">
                                                                </div>
                                                            </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group">
                                                                    <label for="txtAdd3" class="control-label col-sm-4">Address 3:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtAdd3" runat="server" placeholder="Address 3" maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <div class="form-group">
                                                                    <label for="txtCity" class="control-label col-sm-4">City:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtCity" runat="server" placeholder="City" maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group">
                                                                    <label for="txtPincode" class="control-label col-sm-4">Pincode*:</label>
                                                                    <div class="col-sm-8">
                                                                        <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtPincode" runat="server" placeholder="Pincode">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <div class="form-group">
                                                                    <label for="cmbState" class="control-label col-sm-4">State*:</label>
                                                                    <div class="col-sm-8">
                                                                        <asp:DropDownList ID="cmbState" CssClass="form-control" runat="server">
                                                                        </asp:DropDownList>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group">
                                                                    <label for="cmbCountry" class="control-label col-sm-4">Country*:</label>
                                                                    <div class="col-sm-8">
                                                                        <asp:DropDownList ID="cmbCountry" CssClass="form-control" runat="server">
                                                                        </asp:DropDownList>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                  </div>
                                                  <div id="divDOB" runat="server" style="display:none">
                                                      <br />
                                                      <h3>Date of Birth</h3>
                                                      <hr />
                                                      <div class="row">
                                                          <div class="col-sm-8">
                                                                <div class="form-group">
                                                                    <label for="txtEmailOld" class="control-label col-sm-4">Existing Record:</label>
                                                                    <div class="col-sm-8">
                                                                        <div class="row">
                                                                            <div class="col-sm-12">
                                                                                <input type="date"  class="form-control" id="dtDateofBirthOld" runat="server" readonly="readonly" placeholder="NA">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                       </div>
                                                       <div class="row">
                                                            <div class="col-sm-8">
                                                                <div class="form-group">
                                                                    <label for="dtDateofBirth" class="control-label col-sm-4">Date of Birth:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="date" class="form-control" id="dtDateofBirth" runat="server">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                  </div>
                                                  <br />
                                                <div class="row">
                                                    <div class="col-sm-12">
                                                        <div style="padding-top:10px; padding-left:10px;">
                                                            <button type="button" class="btn btn-success btn-lg" id="btnSaveContinue" onclick="saveData();" runat="server" style="margin-top:5px" ><i class="fa fa-check" aria-hidden="true"></i> Save & Continue</button> 
                                                            <span style="font-size:18px; font-weight:bold;">OR <a class="link-info" href="DigiLockerKYC.aspx" id="btnContinueDigiLocker" style="font-size:14px"> <i class="fa fa-cloud-download" aria-hidden="true"></i> <u>Go through DigiLocker</u></a></span> 
                                                        
                                                              <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                                              </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                          </div>
                                          <div class="col-md-4">
                                               <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                                    <div class="alert alert-warning">
                                                        <strong>Warning!</strong> Please remember that: <br />
                                                        <span id="spanAadhaarUploadNotes" runat="server">
                                                            If the data you entered does not match your PAN [<strong id="strongPAN" runat="server"></strong>] and Aadhaar [<strong id="strongAadhaar" runat="server"></strong>] then your application may be rejected.
                                                        </span>
                                                    </div>
                                                   <div class="alert alert-info">
                                                        <strong>Be Aware: </strong><br />
                                                        <span>
                                                            If the details entered by you do not match with your uploaded Documents, your application may be rejected
                                                        </span>
                                                    </div>
                                              </div>
                                             </p>
                                             <br />

                                              <div style="padding:20px;border-radius: 8px;box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);">
                                                  <b>Please keep the following Documents ready:</b>
                                                  <ol>
                                                      <li>Scanned image of PAN Card [png,jpeg,pdf]</li>
                                                      <li>Scanned Masked Aadhaar [png,jpeg,pdf]</li>
                                                  </ol>
                                             </div>

                                          </div>
                                      </div>
                                  </div>
                              </div>
                              

                            </ContentTemplate>
                        </asp:UpdatePanel>

                        <hr />
                          <div id="divPreviousSteps" runat="server">
                              <h4>Go to previous step </h4> 
                            <ul class="list-inline">
                                <li><a href="ConfirmDetails.aspx?cnfmrset=1" id="hlinkChooseParameters" runat="server"><i class="fa fa-solid fa-list-check" aria-hidden="true"></i> Reset Modifications</a></li>
                                <li><a href="contact.aspx" id="hlinkContact" runat="server"><i class="fas fa-envelope fa-lg me-3 fa-fw" aria-hidden="true"></i> Contact</a></li>
                                <li><a href="DigiLockerKYC.aspx" id="hlinkDigiLocker" runat="server"><i class="fa fa-cloud-download" aria-hidden="true"></i> DigiLocker</a></li>
                                <li><a href="takePhoto.aspx" id="hlinkCapturePhoto" runat="server"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                <li><a href="incomeProfile.aspx" id="hlinkIncomeProfile" runat="server"><i class="fa fa-inr" aria-hidden="true"></i> Income Profile</a></li>
                                <li><a href="TradingPreference.aspx" id="hlinkTradingPreference" runat="server"><i class="fa fa-exchange" aria-hidden="true"></i> Trading Preference</a></li>
                                <li><a href="BankDetails.aspx" id="hlinkBankDetails" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Bank</a></li>
                                <li><a href="Nomination.aspx" id="hlinkNomination" runat="server"><i class="fa fa-users" aria-hidden="true"></i> Nomination</a></li>
                                <li><a href="dematAccount.aspx" id="hlinkDematAccount" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Demat Account</a></li>
                                <li><a href="AuthorizedRepresentative.aspx" id="hlinkAuthorizedRepresentative" runat="server"><i class="fa fa-user-circle" aria-hidden="true"></i> Authorized Representative</a></li>
                                <li><a href="uploadDocuments.aspx" id="hlinkUploadDocuments" runat="server"><i class="fa fa-upload" aria-hidden="true"></i> Upload documents</a></li>
                            </ul>
                         </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
                
            </div>


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
                      <br />
                      <br />
			    </div>
                
             </div>

          </div>
        </section>
    </form>
     
</body>
</html>
