﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="SilentLoginAPITracker.aspx.cs" Inherits="Connect_DotNet.StanSoftAPI.SilentLoginAPITracker" %>

<!DOCTYPE html>

<html>
<head runat="server">
  <title>SharePro Silent Login API Tracker</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    
</head>
<body>
    <form id="form1" runat="server" class="container">
        <div  class="col-lg-4">
             <h2>Get Login Token</h2>
        <div class="form-group">
            <label for="txtURL">URL:</label>
            <asp:TextBox ID="txtURL" CssClass="form-control"  name="txtURL" runat="server"></asp:TextBox>
        </div>
        <div class="form-group">
          <label for="txtAPIkey">API Key:</label>
          <asp:TextBox ID="txtAPIkey" CssClass="form-control"  name="txtAPIkey"  runat="server"></asp:TextBox>
        </div>
        <div class="form-group">
            <label for="ddlLoginType">Login Type</label>
                <asp:DropDownList id="ddlLoginType" CssClass="form-control"  name="ddlLoginType"
                    runat="server">

                    <asp:ListItem Selected="True" Value="CLIENT"> Client </asp:ListItem>
                    <asp:ListItem Value="BRANCH"> Branch </asp:ListItem>
					<asp:ListItem Value="GROUP"> Group </asp:ListItem>
					<asp:ListItem Value="SB"> Sub-Broker </asp:ListItem>
					<asp:ListItem Value="DEALER"> Dealer </asp:ListItem>
					<asp:ListItem Value="RM"> Relationship Manager </asp:ListItem>
					<asp:ListItem Value="DP"> DP Client </asp:ListItem>
					<asp:ListItem Value="CRM"> CRM Login </asp:ListItem>
					<asp:ListItem Value="FM"> Fund Manager </asp:ListItem>
               </asp:DropDownList>
        </div>
        <div class="form-group">
          <label for="txtLoginId">Login Id:</label>
          <asp:TextBox ID="txtLoginId" CssClass="form-control"  name="txtLoginId"  runat="server"></asp:TextBox>
        </div>
        <asp:Button ID="btnGetToken" CssClass="btn btn-primary" OnClick="btnGetToken_Click" runat="server" Text="Get Token" />

        <br />
        <br />

        <div class="form-group">
          <label for="txtToken">Token:</label>
          <asp:TextBox ID="txtToken" CssClass="form-control" ReadOnly="true"  name="txtToken"  runat="server"></asp:TextBox>
        </div>
        
        <div id="divLogin" visible="false" runat="server">
           <asp:CheckBox ID="chkLoginOnly"  Checked="true"  runat="server" /> &nbsp; Login Only! &nbsp;&nbsp;<asp:Button ID="btnUserlogin" CssClass="btn btn-success" OnClick="btnUserlogin_Click" runat="server" Text="User Login" />
           <br />
            <br />
            <div class="form-group">
                <label for="txtSession">SessionId:</label>
                 <input id="txtSession" class="form-control" runat="server" readonly="readonly" name="txtSession"  type="text" />
            </div>
        </div>
        <br />
        <a href="https://docs.google.com/document/d/e/2PACX-1vS_ltEPJHypxO7qroo0qQ9JWMtPjZJ7k9JUFZTZ2DJENDZ15E3c-WN0R4jzKJagIEWMl2FwJn5k7-P7/pub" target="_blank">View Silent Login API Document</a>
            
        </div>
       
        <div class="col-lg-8">
             <h2>API Page</h2>
            <div class="form-group" id="divAPILoad" runat="server">
                <asp:DropDownList id="ddlAPIList" CssClass="form-control"  name="ddlAPIList"
                    AutoPostBack="True" onClick="javascript:setSessionId()"
                    OnSelectedIndexChanged="ddlAPIList_SelectedIndexChanged"
                    runat="server">

                  <asp:ListItem Selected="True" Value=""> Choose Page... </asp:ListItem>
                  <asp:ListItem Value="Ledger"> Get Ledger </asp:ListItem>
                    <asp:ListItem Value="LedgerReverseDateOrder"> Ledger with Reverse Date Order </asp:ListItem>
                    <asp:ListItem Value="LedgerPrintVallan"> Ledger With Vallan Details </asp:ListItem>
                    <asp:ListItem Value="LedgerShowCashShareMargin"> Ledger with Cash and Share Margin </asp:ListItem>
                    <asp:ListItem Value="LedgerSummariseDeliveriesSettlement"> Ledger Summarise Deliveries Settlement Wise </asp:ListItem>
                    <asp:ListItem Value="LedgerSummariseDerivativesDatewise"> Ledger Summarise Datewise (Derivatives) </asp:ListItem>
                    <asp:ListItem Value="LedgerIncludeAccruedMarginPenalty"> Ledger with Accrued Margin Penalty </asp:ListItem>
                    <asp:ListItem Value="LedgerIncludeInitialMargin"> Ledger with Initial Margin </asp:ListItem>
                    <asp:ListItem Value="LedgerCustom"> Ledger with Custom Filter </asp:ListItem>
                    <asp:ListItem Value="Dashboard"> Dashboard </asp:ListItem>
                    <asp:ListItem Value="ShMrgnRelRequest"> Share Margin Release Request </asp:ListItem>
                    <asp:ListItem Value="NetPositions"> Net Positions </asp:ListItem>
                    <asp:ListItem Value="TradeReg"> Trade Register </asp:ListItem>
                    <asp:ListItem Value="Profile"> Profile </asp:ListItem>
                    <asp:ListItem Value="LiveTrades"> Live Trades </asp:ListItem>
                    <asp:ListItem Value="AtomPayment"> Make Payment [ATOM] </asp:ListItem>
                    <asp:ListItem Value="RazorPayment">  Make Payment [RAZOR] </asp:ListItem>
                    <asp:ListItem Value="ChequeRequest"> Cheque Request </asp:ListItem>
                    <asp:ListItem Value="ChequeRequestStatus"> Cheque Request Status </asp:ListItem>
                    <asp:ListItem Value="SubsidiaryTrial"> Subsidiary Trial </asp:ListItem>
                    <asp:ListItem Value="ClientPortfolioReport"> Client Portfolio Report </asp:ListItem>
                    <asp:ListItem Value="HoldingStatement"> Holding Statement </asp:ListItem>
                    <asp:ListItem Value="IsinSearch"> ISIN Search </asp:ListItem>
                    <asp:ListItem Value="OSTicket"> osTicket (Support) </asp:ListItem>
                    <asp:ListItem Value="CustomPage"> Custom Page... </asp:ListItem>
                    

               </asp:DropDownList>

                <div id="divCustomPage" runat="server" visible="false" class="form-group">
                  <asp:TextBox ID="txtCustomPage" CssClass="form-control"  name="txtCustomPage"  runat="server"></asp:TextBox>
                   <asp:Button ID="btnViewCustomPage" CssClass="btn btn-xs btn-info" style="margin-bottom:2px" OnClick="btnViewCustomPage_Click" runat="server" Text="View Page" />
                </div>
                
              <iframe id="iframeAPILoad" src="http://www.stansoftware.com/wp-content/uploads/2020/07/APIBundle.png" width="100%" height="500px"  runat="server"></iframe>
                <br />
                <label runat="server" id="lblPageURL"></label>
        </div>
        </div>
    </form>
   <script type="text/javascript" src="https://www.cloud.stansoftware.com/shrdbms/scripts/ssajax.js"></script>

    <script>

        //alert(document.cookie);
        //alert(getCookie("ShrdbmsSessionId"));
       
        function iframeAPILoaded() {
              setSessionId();
        };

        function setSessionId() {

            //alert(getCookie("ShrdbmsSessionId"));
            document.getElementById('<%= txtSession.ClientID %>').value = getCookie("ShrdbmsSessionId");

        }


        function getCookie(cname) {
          var name = cname + "=";
          var decodedCookie = decodeURIComponent(document.cookie);
          var ca = decodedCookie.split(';');
          for(var i = 0; i <ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') {
              c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
              return c.substring(name.length, c.length);
            }
          }
          return "";
        }

    </script>

</body>
</html>
