﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="UpdateStatus.aspx.cs" Inherits="Connect_DotNet.UpdateStatus" %>



<%@ Register assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" namespace="DevExpress.Web" tagprefix="dx" %>


<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>
        <!-- #CSS Links -->
	<!-- Basic Styles 
	<link rel="stylesheet" type="text/css" media="screen" href="../css/bootstrap.min.css">
        -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">


	<link href="../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-skins.min.css">

	<!-- BootComplete http://getwebhelp.com/bootcomplete/ -->
	<link href="../scripts/BootStrap/plugins/bootcomplete/bootcomplete.css" rel="stylesheet" />
	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">
	<link href="../css/your_style.css" rel="stylesheet" />
    

    <style type="text/css">
        .borderless td, .borderless th {
            border:none !important ;
        }
        .borderless > thead > tr > th, .borderless > tbody > tr > th, .borderless > tfoot > tr > th, .borderless > thead > tr > td, .borderless > tbody > tr > td, .borderless > tfoot > tr > td {
            padding: 1px !important ;
        }
        
        .table{
            border:none !important ;
        }

        .dxgvCSD /*For grid*/
        {

             border-top: 1px solid;
             border-bottom: 1px solid;

             height: auto !important;
             max-height: 220px !important; /*Custom grid size*/

        }

        .alignRight { text-align:right }

        html, body {
            background:none!important;
            background-color:linen;
        }

    </style>

</head>
<body>
    <div class="container-fluid">
    <form id="form1" class="form-inline" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server" EnablePageMethods="true" EnablePartialRendering="true"></asp:ScriptManager>
        <br />
        <legend>
            <dx:ASPxLabel ID="lblClient" runat="server" Font-Bold="True" Font-Italic="False"
                            ForeColor="Gray" Font-Size="14px">
            </dx:ASPxLabel>
        </legend>
        <div id="tabs">
			<ul id="maintabs" class="nav nav-tabs">
				<li class="active"><a href="#divInfo" data-toggle="tab">Update New Status</a></li>
				<li><a href="#divHistory" data-toggle="tab">History</a></li>
			</ul>
			<div id="tabContents" class="tab-content">
                <br />
				<div id="divInfo" class="tab-pane active">
                    <asp:UpdatePanel ID="UpdatePanel2" runat="server" >
                        <ContentTemplate>
                            <table class="table table-responsive borderless" >
                                <tr>
                                    <td class="alignRight">
                                        New Status : 
                                    </td>
                                    <td>
                                        <dx:ASPxComboBox ID="cmbStatus" AutoPostBack="true" ClientInstanceName="cmbStatus" Width="100%"  runat="server" TextField="STATUS" SelectedIndex="0" ValueField="STATUSCD" CssClass="form-control input-sm" Native="true" ></dx:ASPxComboBox>
                                    </td>
                                    <td class="alignRight">
                                        <button id="btnStatusAdd" runat="server" class="btn btn-primary btn-xs" type="button" data-toggle="modal" data-target="#InsertStatusModal">
                                                <i class="fa fa-plus"></i> Add</button>
                                    </td>
                                </tr>
                                <tr id="trReminder"  runat="server">
				                    <td class="alignRight">
                                        * Reminder :
				                    </td>
				                    <td><dx:ASPxDateEdit ID=dtpReminderDate runat="server" Width="100%" CssClass="form-control input-sm" ></dx:ASPxDateEdit></td>
				                    <td class="alignRight">
                                        * Time :
				                    </td>
				                    <td>
                                        <dx:ASPxTimeEdit ID=tmpReminderTime runat="server" Width="100%" EditFormat="Custom" EditFormatString="hh:mm tt" CssClass="form-control input-sm" ></dx:ASPxTimeEdit>
				                    </td>
			                    </tr>
                                <tr>
                                    <td class="alignRight">
                                    </td>
                                    <td>
                                        <dx:ASPxCheckBox ID="chkbxBlock" Text="Booked by Me" runat="server" ></dx:ASPxCheckBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="alignRight">
                                        * Remarks : 
                                    </td>
                                    <td colspan="3">
                                        <dx:ASPxMemo ID="MemoRemarks" Width="100%" runat="server" Height="80" CssClass="form-control input-sm" MaxLength="200" Native="true"></dx:ASPxMemo>
                                    </td>
                            </table>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </div>
                <div id="divHistory" class="tab-pane">
                    <dx:ASPxGridView ID="grdHistoryOfStatus" ClientInstanceName="grdHistoryOfStatus" runat="server" AutoGenerateColumns="False" Theme="Office2010Silver" KeyFieldName="LOGCD" OnHtmlRowPrepared="grdHistoryOfStatus_HtmlRowPrepared" Width="100%" >
                        <SettingsPager Mode="EndlessPaging">
                        </SettingsPager>
                        <Settings  GridLines="Horizontal"  />
                        <Columns>
                            <dx:GridViewDataTextColumn Caption="Date" Name="Date" VisibleIndex="0" Width="25%">
                                <DataItemTemplate>
                                    <dx:ASPxLabel ID="lblDate" runat="server" Text='<%# Eval("StatusDate") %>' Font-Size="Small"></dx:ASPxLabel>
                                </DataItemTemplate>
                            </dx:GridViewDataTextColumn>
                            <dx:GridViewDataTextColumn Caption="Staff" FieldName="STAFFNAME" Name="Staff" VisibleIndex="1" Width="20%">
                                <DataItemTemplate>
                                    <dx:ASPxLabel ID="lblStaff" runat="server" Text='<%# Eval("STAFFNAME") %>' Font-Size="Small"></dx:ASPxLabel>
                                </DataItemTemplate>
                            </dx:GridViewDataTextColumn>
                            <dx:GridViewDataTextColumn Caption="Status" FieldName="STATUS" Name="Status" VisibleIndex="2" Width="20%">
                                <DataItemTemplate>
                                    <dx:ASPxLabel ID="lblStatus" runat="server" Text='<%# Eval("STATUS") %>' Font-Size="Small"></dx:ASPxLabel>
                                </DataItemTemplate>
                            </dx:GridViewDataTextColumn>
                            <%--<dx:GridViewDataCheckColumn Caption="Booked" FieldName="BOOKED" Name="Booked" VisibleIndex="3">
                            </dx:GridViewDataCheckColumn>--%>
                            <dx:GridViewDataTextColumn Caption="Remarks" FieldName="REMARKS" Name="Remarks" VisibleIndex="4" Width="35%">
                                <DataItemTemplate>
                                    <dx:ASPxLabel ID="lblRemarks" runat="server" Text='<%# Eval("REMARKS") %>' Font-Size="Small"></dx:ASPxLabel>
                                </DataItemTemplate>
                            </dx:GridViewDataTextColumn>
                        </Columns>
                        <SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
                    </dx:ASPxGridView>
                </div>
            </div>
        </div>
        <%--<asp:Button ID="btnTest" runat="server" Text="Test Button" OnClick="btnTest_Click" />--%>

           <div class="modal fade" id="InsertStatusModal" role="dialog" >
            <div class="modal-dialog modal-sm">
              <!-- Modal content-->
              <div class="modal-content">
                <div class="modal-header ">
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                  <h4 runat="server" id="hModaltitle" class="modal-title"><i class="fa fa-plus"></i> Insert Status</h4>
                </div>
                <div class="modal-body " style="height:280px">
                  <iframe runat="server" id="ifrmInsertStatus" src="AddNewStatus.aspx?STATUSTYPE=INACTIVE"   style="border:none;height:100%; width:100%" ></iframe>
                </div>
                <%--<div class="modal-footer">
                  <button type="button" class="btn btn-success" onclick="CallfromStatusIFrame();" >Save</button>
                  <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
                </div>--%>
              </div>
      
            </div>
          </div>
            <!-- End Modal -->
    </form>
    </div>
     <!-- PACE LOADER - turn this on if you want ajax loading to show (caution: uses lots of memory on iDevices)-->
		<script data-pace-options='{ "restartOnRequestAfter": true }' src="../js/plugin/pace/pace.min.js"></script>

    <!--
		<script src="../js/libs/jquery-2.1.1.min.js"></script>
    -->
		<!-- BOOTSTRAP JS 
		<script src="../js/bootstrap/bootstrap.min.js"></script>
            -->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>

        <!-- StanSoft Script -->
        <script src="../scripts/ssajax.js"></script>
        <script>
            ////parent.document.getElementById("btn0").click(f)
            //parent.$("#btn0").click(function () {
            //    //alert("Handler for .click() called.");
            //    document.getElementById('btnUpdate').click();
            //});

            //function AddNewStatus(cType) {

            //    var cTitle = "Update Status";
            //    var opts = {
            //        type: "OKCANCEL",
            //        url: "dotnet/AddNewStatus.aspx?&cType=" + cType + "&sessionid=" + $('#hdnSession').val(),
            //        title: cTitle,
            //        savecaption: "Save",
            //        cancelcaption: "Cancel",
            //        width: 400,
            //        height: 400,
            //        reload: true,			// Reload the page [Grid] when a successful save happens
            //        reloadwindow: window	// Rev 3.9.2016 : We will hit the parent function [see below] but want the
            //        // current window to be reloaded.
            //    };

            //    // Note that we are firing the script on the MAIN page and not in this iFrame.
            //    parent.urlFormDialog(opts);
            //}

            $('[id*="_DXMainTable"]').removeClass($('[id*="_DXMainTable"]').attr("class")).addClass("table table-hover table-condensed table-responsive ssGrid dataTable no-footer "); //body
            $('[class*="dxgvControl_"]').removeClass($('[class*="dxgvControl_"]').attr("class"));

            function CallfromStatusIFrame() {

                // Call IFrame function from parent page
                //$('[id*="ifrmInsertStatus"]').prop('contentWindow').parrentInsertStatus();

                $('#InsertStatusModal').modal('hide'); //Close modal
                location.reload();//page reload

                //cmbStatus.PerformCallback('');// Refress cmbStatus
                
            }

        </script>
</body>
</html>
