﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Nomination.aspx.cs" Inherits="Connect_DotNet.eKYC.Nomination" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<!DOCTYPE html>

<html>
<head runat="server">
  <title>Nomination</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />
</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }
    </style>
    

    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                <div class="col-md-3">
                    <center>
                    <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px; padding-top:10px">
                    </center>
                </div>
                <div class="col-md-6">
                    <h2 class="lblTopHeader"><i class="fa fa-users" aria-hidden="true"></i> Account Nominees</h2>
                    <p> You can designate <i>Nominees</i> for your new Account or may choose to opt out</p>
                </div>
                <div class="col-md-3" style="display:flex;flex-direction:column;align-items:flex-end;">
                    <h4 id="hFullName" runat="server" style="margin:0px;"></h4>
                    <span>DOB: <span id="spanDOB" runat="server"></span></span>
                    <span id="spanMobile" runat="server"></span>
                    <span id="spanEmail" runat="server"></span>
                </div>
               </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">

                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                    <input type="hidden" id="hdnActivaTab" name="hdnActivaTab" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div class="row">
                                          <div class="col-md-8">

                                              <div class="form-outline flex-fill mb-0">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <h4>Do you wish to make Nominees?</h4>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <select class="form-control" style="width:50%" onchange="optoutNomination();" id="selectMakeNominees" runat="server">
                                                                <option>Yes</option>  
                                                                <option>No</option>
                                                            </select>
                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                              <div id="divOptOutNominees" runat="server">
                                                  <div class="alert alert-danger">
                                                    <strong>Opt-out of Nomination</strong> You do not wish to appoint any nominee.
                                                  </div>
                                                  <button type="button" class="btn btn-lg btn-success" data-dismiss="modal" id="btnContinueOptoutNomination" onclick="saveNomination('Opt Out')"><i class="fa fa-check" aria-hidden="true"></i> Save and Continue</button>
                                              </div>
                                              <div id="divNominees" runat="server">
                                                <input type="hidden"  id="hdnNomResidualPercent" name="hdnNomResidualPercent" runat="server" value="100">
                                                <input type="hidden"  id="hdnNominee1Share" name="hdnNominee1Share" runat="server" value="">
                                                <input type="hidden"  id="hdnNominee2Share" name="hdnNominee2Share" runat="server" value="">
                                                <input type="hidden"  id="hdnNominee3Share" name="hdnNominee3Share" runat="server" value="">
                                                <ul class="nav nav-tabs" style="padding-top:10px">
                                                    <li class="active"><a data-toggle="tab" href="#Nominee1Tab"><h4>Nominee 1</h4></a></li>
                                                    <li><a data-toggle="tab" href="#Nominee2Tab"><h4>Nominee 2</h4></a></li>
                                                    <li><a data-toggle="tab" href="#Nominee3Tab"><h4>Nominee 3</h4></a></li>
                                                </ul>
                                                <br>
                                               <div class="tab-content">
                                                  <div id="Nominee1Tab" class="tab-pane fade in active">
                                                    <ul class="nav nav-tabs">
                                                        <li class="active"><a data-toggle="tab" href="#ModalNominee1Tab">Nominee1 details</a></li>
                                                        <li><a data-toggle="tab" href="#ModalNominee1MinorGuardianTab">Nominee1 Guardian (If a Minor)</a></li>
                                                    </ul>
                                                    <br>
                                                    <div class="tab-content">
                                                        <div id="ModalNominee1Tab" class="tab-pane fade in active">
                                                            <div class="row">
                                                            <div class="col-sm-5">
                                                                <label for="txtNom1Name" class="control-label col-sm-5">Nominee Name*:</label>
                                                                <div class="col-sm-7">
                                                                    <select class="form-control" id="selectNom1Prefix" runat="server">
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-7">
                                                                <div class="form-group">
                                                                    <div class="col-sm-12">
                                                                        <input type="text" class="form-control" id="txtNom1Name" runat="server" placeholder="Full Name"  maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom1Relation" class="control-label col-sm-4">Relation:</label>
                                                                        <div class="col-sm-8">
                                                                            <!--<input type="text" class="form-control" id="txtNom1Relation" runat="server" placeholder="Relation" maxlength="50">-->
                                                                             <asp:DropDownList ID="cmbNom1Relation" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1Percent" class="control-label col-sm-4">Share %*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input  type="number" class="form-control" id="txtNom1Percent" runat="server" placeholder="% Share">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:20px">
                                                                <div class="col-sm-12">
                                                                    <div class="row">
                                                                        <div class="col-sm-2">
                                                                        </div>
                                                                        <div class="col-sm-8">
                                                                            <label class="form-check-label" for="chkbNom1AddSameAsApplicant">&nbsp;<asp:CheckBox ID="chkbNom1AddSameAsApplicant" OnCheckedChanged="chkbNom1AddSameAsApplicant_CheckedChanged" runat="server" AutoPostBack="true" />&nbsp;&nbsp;Address same as applicant?</label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1Add1" class="control-label col-sm-4">Address 1*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom1Add1" runat="server" placeholder="Address 1" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="txtNom1Add2" class="control-label col-sm-4">Address 2:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtNom1Add2" runat="server" placeholder="Address 2" maxlength="50">
                                                                    </div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1Add3" class="control-label col-sm-4">Address 3:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom1Add3" runat="server" placeholder="Address 3" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1City" class="control-label col-sm-4">City:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom1City" runat="server" placeholder="City" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1Pincode" class="control-label col-sm-4">Pincode*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtNom1Pincode" runat="server" placeholder="Pincode">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom1State" class="control-label col-sm-4">State*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom1State" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom1Country" class="control-label col-sm-4">Country*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom1Country" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1Mobile" class="control-label col-sm-4">Mobile:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="number"  class="form-control" id="txtNom1Mobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1Email" class="control-label col-sm-4">Email:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom1Email" runat="server" placeholder="Email"  maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div style="border:0.5px solid silver; margin-top:10px;border-radius:4px;">
                                                                <span style="font-weight:bold;font-size:1.2em;color:silver;padding:10px 0px 0px 10px;">Upload Identification Document</span>
                                                                <div class="row" style="padding-top:10px;">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom1IdType" class="control-label col-sm-4">Id Type*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom1IdType" onchange="CleanExistingFileData('spannom1DocAsyncFileUpload', 'nom1DocAsyncFileUpload');"  CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1IDNo" class="control-label col-sm-4">ID No*:</label>
                                                                        <div class="col-sm-8">
                                                                        <input type="text"  class="form-control" id="txtNom1IDNo" runat="server" placeholder="Document ID"  maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="nom1DocAsyncFileUpload" class="control-label col-sm-4">Upload document*:</label>
                                                                        <div class="col-sm-8">
                                                                            <ajaxToolkit:AsyncFileUpload ID="nom1DocAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="nom1DocAsyncFileUpload_UploadedComplete" runat="server" />
                                                                            <span id="spannom1DocAsyncFileUpload" runat="server"></span>
                                                                        </div>
                                                                    </div>
                                                                    </div>
                                                                    <div class="col-sm-6">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="dtNom1DateofBirth" class="control-label col-sm-4">DOB*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="date" class="form-control" id="dtNom1DateofBirth" onchange="checkMinor('1')" runat="server">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-check">
                                                                        <label class="form-check-label" for="chkNom1IsMinor">
                                                                            &nbsp;<input type="checkbox" class="form-check-input" disabled="disabled" onchange="if(this.checked==false){activaTab('ModalNominee1Tab');} else {activaTab('ModalNominee1MinorGuardianTab');}"  id="chkNom1IsMinor" runat="server" name="chkNom1IsMinor">&nbsp;&nbsp; Nominee is minor?
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="ModalNominee1MinorGuardianTab" class="tab-pane fade in">
                                                            <div class="row">
                                                            <div class="col-sm-5">
                                                                <label for="txtNom1MinorGuardianName" class="control-label col-sm-5">Guardian Name*:</label>
                                                                <div class="col-sm-7">
                                                                    <select class="form-control" id="selectNom1MinorGuardianPrefix" runat="server">
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-7">
                                                                <div class="form-group">
                                                                    <div class="col-sm-12">
                                                                        <input type="text" class="form-control" id="txtNom1MinorGuardianName" runat="server" placeholder="Guardian Name" maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom1MinorGuardianRelation" class="control-label col-sm-4">Relation:</label>
                                                                        <div class="col-sm-8">
                                                                            <!--<input type="text" class="form-control" id="txtNom1MinorGuardianRelation" runat="server" placeholder="Relation" maxlength="50">-->
                                                                            <asp:DropDownList ID="cmbNom1MinorGuardianRelation" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-2">
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-check">
                                                                        <label class="form-check-label" for="chkAddressSameAsNominee1">
                                                                            &nbsp;<input type="checkbox" class="form-check-input" onchange="setMinorAddressSameAsNominee(this.checked,'1');"  id="chkAddressSameAsNominee1" runat="server" name="chkAddressSameAsNominee1">&nbsp;&nbsp;  Address same as Nominee?
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1MinorGuardianAdd1" class="control-label col-sm-4">Address 1*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom1MinorGuardianAdd1" runat="server" placeholder="Address 1" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="txtNom1MinorGuardianAdd2" class="control-label col-sm-4">Address 2:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtNom1MinorGuardianAdd2" runat="server" placeholder="Address 2" maxlength="50">
                                                                    </div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1MinorGuardianAdd3" class="control-label col-sm-4">Address 3:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom1MinorGuardianAdd3" runat="server" placeholder="Address 3" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1MinorGuardianCity" class="control-label col-sm-4">City:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom1MinorGuardianCity" runat="server" placeholder="City" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1MinorGuardianPincode" class="control-label col-sm-4">Pincode*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtNom1MinorGuardianPincode" runat="server" placeholder="Pincode">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom1MinorGuardianState" class="control-label col-sm-4">State*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom1MinorGuardianState" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom1MinorGuardianCountry" class="control-label col-sm-4">Country*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom1MinorGuardianCountry" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1MinorGuardianMobile" class="control-label col-sm-4">Mobile:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="number"  class="form-control" id="txtNom1MinorGuardianMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom1MinorGuardianEmail" class="control-label col-sm-4">Email:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom1MinorGuardianEmail" runat="server" placeholder="Email" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div style="border:0.5px solid silver; margin-top:10px;border-radius:4px;">
                                                                <span style="font-weight:bold;font-size:1.2em;color:silver;padding:10px 0px 0px 10px;">Upload Identification Document</span>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                            <label for="cmbNom1MinorGuardianIdType" class="control-label col-sm-4">Id Type*:</label>
                                                                            <div class="col-sm-8">
                                                                                <asp:DropDownList ID="cmbNom1MinorGuardianIdType" onchange="CleanExistingFileData('spannom1MinorGuardianDocAsyncFileUpload', 'nom1MinorGuardianDocAsyncFileUpload');" CssClass="form-control" runat="server">
                                                                                </asp:DropDownList>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                            <label for="txtNom1MinorGuardianIDNo" class="control-label col-sm-4">ID No*:</label>
                                                                            <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom1MinorGuardianIDNo" runat="server" placeholder="ID No" maxlength="50">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                        <label for="nom1MinorGuardianDocAsyncFileUpload" class="control-label col-sm-4">Upload document*:</label>
                                                                        <div class="col-sm-8">
                                                                            <ajaxToolkit:AsyncFileUpload ID="nom1MinorGuardianDocAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="nom1MinorGuardianDocAsyncFileUpload_UploadedComplete" runat="server" />
                                                                            <span id="spannom1MinorGuardianDocAsyncFileUpload" runat="server"></span>
                                                                        </div>
                                                                    </div>
                                                                    </div>
                                                                    <div class="col-sm-6">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                  </div>
                                                  <div id="Nominee2Tab" class="tab-pane fade in">
                                                       <ul class="nav nav-tabs">
                                                        <li class="active"><a data-toggle="tab" href="#ModalNominee2Tab">Nominee2 details</a></li>
                                                        <li><a data-toggle="tab" href="#ModalNominee2MinorGuardianTab">Nominee2 Guardian (If a Minor)</a></li>
                                                    </ul>
                                                    <br>
                                                    <div class="tab-content">
                                                        <div id="ModalNominee2Tab" class="tab-pane fade in active">
                                                            <div class="row">
                                                            <div class="col-sm-5">
                                                                <label for="txtNom2Name" class="control-label col-sm-5">Nominee Name*:</label>
                                                                <div class="col-sm-7">
                                                                    <select class="form-control" id="selectNom2Prefix" runat="server">
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-7">
                                                                <div class="form-group">
                                                                    <div class="col-sm-12">
                                                                        <input type="text" class="form-control" id="txtNom2Name" runat="server" placeholder="Full Name"  maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom2Relation" class="control-label col-sm-4">Relation:</label>
                                                                        <div class="col-sm-8">
                                                                            <!--<input type="text" class="form-control" id="txtNom2Relation" runat="server" placeholder="Relation" maxlength="50">-->
                                                                            <asp:DropDownList ID="cmbNom2Relation" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2Percent" class="control-label col-sm-4">Share %*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input  type="number" class="form-control" id="txtNom2Percent" runat="server" placeholder="% Share">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:20px">
                                                                <div class="col-sm-12">
                                                                    <div class="row">
                                                                        <div class="col-sm-2">
                                                                        </div>
                                                                        <div class="col-sm-8">
                                                                            <label class="form-check-label" for="chkbNom2AddSameAsApplicant">&nbsp;<asp:CheckBox ID="chkbNom2AddSameAsApplicant" OnCheckedChanged="chkbNom2AddSameAsApplicant_CheckedChanged" runat="server" AutoPostBack="true" />&nbsp;&nbsp;Address same as applicant?</label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2Add1" class="control-label col-sm-4">Address 1*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom2Add1" runat="server" placeholder="Address 1" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="txtNom2Add2" class="control-label col-sm-4">Address 2:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtNom2Add2" runat="server" placeholder="Address 2" maxlength="50">
                                                                    </div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2Add3" class="control-label col-sm-4">Address 3:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom2Add3" runat="server" placeholder="Address 3" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2City" class="control-label col-sm-4">City:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom2City" runat="server" placeholder="City" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2Pincode" class="control-label col-sm-4">Pincode*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtNom2Pincode" runat="server" placeholder="Pincode">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom2State" class="control-label col-sm-4">State*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom2State" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom2Country" class="control-label col-sm-4">Country*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom2Country" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2Mobile" class="control-label col-sm-4">Mobile:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="number"  class="form-control" id="txtNom2Mobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2Email" class="control-label col-sm-4">Email:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom2Email" runat="server" placeholder="Email"  maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div style="border:0.5px solid silver; margin-top:10px;border-radius:4px;">
                                                                <span style="font-weight:bold;font-size:1.2em;color:silver;padding:10px 0px 0px 10px;">Upload Identification Document</span>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                            <label for="cmbNom2IdType" class="control-label col-sm-4">Id Type*:</label>
                                                                            <div class="col-sm-8">
                                                                                <asp:DropDownList ID="cmbNom2IdType" onchange="CleanExistingFileData('spannom2DocAsyncFileUpload', 'nom2DocAsyncFileUpload');" CssClass="form-control" runat="server">
                                                                                </asp:DropDownList>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                            <label for="txtNom2IDNo" class="control-label col-sm-4">ID No*:</label>
                                                                            <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom2IDNo" runat="server" placeholder="Document ID"  maxlength="50">
                                                                            </div>
                                        
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                        <label for="nom2DocAsyncFileUpload" class="control-label col-sm-4">Upload document*:</label>
                                                                        <div class="col-sm-8">
                                                                            <ajaxToolkit:AsyncFileUpload ID="nom2DocAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="nom2DocAsyncFileUpload_UploadedComplete" runat="server" />
                                                                            <span id="spannom2DocAsyncFileUpload" runat="server"></span>
                                                                        </div>
                                                                    </div>
                                                                    </div>
                                                                    <div class="col-sm-6">
                                                                    </div>
                                                                </div>
                                                           </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="dtNom2DateofBirth" class="control-label col-sm-4">DOB*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="date" class="form-control" id="dtNom2DateofBirth" onchange="checkMinor('2')" runat="server">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-check">
                                                                        <label class="form-check-label" for="chkNom2IsMinor">
                                                                            &nbsp;<input type="checkbox" class="form-check-input" disabled="disabled" onchange="if(this.checked==false){activaTab('ModalNominee2Tab');} else {activaTab('ModalNominee2MinorGuardianTab');}"  id="chkNom2IsMinor" runat="server" name="chkNom2IsMinor">&nbsp;&nbsp; Nominee is minor?
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="ModalNominee2MinorGuardianTab" class="tab-pane fade in">
                                                            <div class="row">
                                                            <div class="col-sm-5">
                                                                <label for="txtNom2MinorGuardianName" class="control-label col-sm-5">Guardian Name*:</label>
                                                                <div class="col-sm-7">
                                                                    <select class="form-control" id="selectNom2MinorGuardianPrefix" runat="server">
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-7">
                                                                <div class="form-group">
                                                                    <div class="col-sm-12">
                                                                        <input type="text" class="form-control" id="txtNom2MinorGuardianName" runat="server" placeholder="Guardian Name" maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom2MinorGuardianRelation" class="control-label col-sm-4">Relation:</label>
                                                                        <div class="col-sm-8">
                                                                            <!--<input type="text" class="form-control" id="txtNom2MinorGuardianRelation" runat="server" placeholder="Relation" maxlength="50">-->
                                                                            <asp:DropDownList ID="cmbNom2MinorGuardianRelation" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-2">
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-check">
                                                                        <label class="form-check-label" for="chkAddressSameAsNominee2">
                                                                            &nbsp;<input type="checkbox" class="form-check-input" onchange="setMinorAddressSameAsNominee(this.checked,'2');"  id="chkAddressSameAsNominee2" runat="server" name="chkAddressSameAsNominee2">&nbsp;&nbsp;  Address same as Nominee?
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2MinorGuardianAdd1" class="control-label col-sm-4">Address 1*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom2MinorGuardianAdd1" runat="server" placeholder="Address 1" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="txtNom2MinorGuardianAdd2" class="control-label col-sm-4">Address 2:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtNom2MinorGuardianAdd2" runat="server" placeholder="Address 2" maxlength="50">
                                                                    </div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2MinorGuardianAdd3" class="control-label col-sm-4">Address 3:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom2MinorGuardianAdd3" runat="server" placeholder="Address 3" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2MinorGuardianCity" class="control-label col-sm-4">City:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom2MinorGuardianCity" runat="server" placeholder="City" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2MinorGuardianPincode" class="control-label col-sm-4">Pincode*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtNom2MinorGuardianPincode" runat="server" placeholder="Pincode">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom2MinorGuardianState" class="control-label col-sm-4">State*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom2MinorGuardianState" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom2MinorGuardianCountry" class="control-label col-sm-4">Country*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom2MinorGuardianCountry" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2MinorGuardianMobile" class="control-label col-sm-4">Mobile:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="number"  class="form-control" id="txtNom2MinorGuardianMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom2MinorGuardianEmail" class="control-label col-sm-4">Email:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom2MinorGuardianEmail" runat="server" placeholder="Email" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div style="border:0.5px solid silver; margin-top:10px;border-radius:4px;">
                                                                <span style="font-weight:bold;font-size:1.2em;color:silver;padding:10px 0px 0px 10px;">Upload Identification Document</span>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                            <label for="cmbNom2MinorGuardianIdType" class="control-label col-sm-4">Id Type*:</label>
                                                                            <div class="col-sm-8">
                                                                                <asp:DropDownList ID="cmbNom2MinorGuardianIdType" onchange="CleanExistingFileData('spannom2MinorGuardianDocAsyncFileUpload', 'nom2MinorGuardianDocAsyncFileUpload');" CssClass="form-control" runat="server">
                                                                                </asp:DropDownList>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                            <label for="txtNom2MinorGuardianIDNo" class="control-label col-sm-4">ID No*:</label>
                                                                            <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom2MinorGuardianIDNo" runat="server" placeholder="ID No" maxlength="50">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                        <label for="nom2MinorGuardianDocAsyncFileUpload" class="control-label col-sm-4">Upload document*:</label>
                                                                        <div class="col-sm-8">
                                                                            <ajaxToolkit:AsyncFileUpload ID="nom2MinorGuardianDocAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="nom2MinorGuardianDocAsyncFileUpload_UploadedComplete" runat="server" />
                                                                            <span id="spannom2MinorGuardianDocAsyncFileUpload" runat="server"></span>
                                                                        </div>
                                                                    </div>
                                                                    </div>
                                                                    <div class="col-sm-6">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                  </div>
                                                  <div id="Nominee3Tab" class="tab-pane fade in">
                                                       <ul class="nav nav-tabs">
                                                        <li class="active"><a data-toggle="tab" href="#ModalNominee3Tab">Nominee3 details</a></li>
                                                        <li><a data-toggle="tab" href="#ModalNominee3MinorGuardianTab">Nominee3 Guardian (If a Minor)</a></li>
                                                    </ul>
                                                    <br>
                                                    <div class="tab-content">
                                                        <div id="ModalNominee3Tab" class="tab-pane fade in active">
                                                            <div class="row">
                                                            <div class="col-sm-5">
                                                                <label for="txtNom3Name" class="control-label col-sm-5">Nominee Name*:</label>
                                                                <div class="col-sm-7">
                                                                    <select class="form-control" id="selectNom3Prefix" runat="server">
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-7">
                                                                <div class="form-group">
                                                                    <div class="col-sm-12">
                                                                        <input type="text" class="form-control" id="txtNom3Name" runat="server" placeholder="Full Name"  maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom3Relation" class="control-label col-sm-4">Relation:</label>
                                                                        <div class="col-sm-8">
                                                                            <!--<input type="text" class="form-control" id="txtNom3Relation" runat="server" placeholder="Relation" maxlength="50">-->
                                                                            <asp:DropDownList ID="cmbNom3Relation" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3Percent" class="control-label col-sm-4">Share %*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input  type="number" class="form-control" id="txtNom3Percent" runat="server" placeholder="% Share">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:20px">
                                                                <div class="col-sm-12">
                                                                    <div class="row">
                                                                        <div class="col-sm-2">
                                                                        </div>
                                                                        <div class="col-sm-8">
                                                                            <label class="form-check-label" for="chkbNom3AddSameAsApplicant">&nbsp;<asp:CheckBox ID="chkbNom3AddSameAsApplicant" OnCheckedChanged="chkbNom3AddSameAsApplicant_CheckedChanged" runat="server" AutoPostBack="true" />&nbsp;&nbsp;Address same as applicant?</label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3Add1" class="control-label col-sm-4">Address 1*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom3Add1" runat="server" placeholder="Address 1" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="txtNom3Add2" class="control-label col-sm-4">Address 2:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtNom3Add2" runat="server" placeholder="Address 2" maxlength="50">
                                                                    </div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3Add3" class="control-label col-sm-4">Address 3:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom3Add3" runat="server" placeholder="Address 3" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3City" class="control-label col-sm-4">City:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom3City" runat="server" placeholder="City" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3Pincode" class="control-label col-sm-4">Pincode*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtNom3Pincode" runat="server" placeholder="Pincode">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom3State" class="control-label col-sm-4">State*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom3State" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom3Country" class="control-label col-sm-4">Country*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom3Country" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3Mobile" class="control-label col-sm-4">Mobile:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="number"  class="form-control" id="txtNom3Mobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3Email" class="control-label col-sm-4">Email:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom3Email" runat="server" placeholder="Email"  maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div style="border:0.5px solid silver; margin-top:10px;border-radius:4px;">
                                                                <span style="font-weight:bold;font-size:1.2em;color:silver;padding:10px 0px 0px 10px;">Upload Identification Document</span>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                            <label for="cmbNom3IdType" class="control-label col-sm-4">Id Type*:</label>
                                                                            <div class="col-sm-8">
                                                                                <asp:DropDownList ID="cmbNom3IdType"  onchange="CleanExistingFileData('spannom3DocAsyncFileUpload', 'nom3DocAsyncFileUpload');" CssClass="form-control" runat="server">
                                                                                </asp:DropDownList>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                            <label for="txtNom3IDNo" class="control-label col-sm-4">ID No*:</label>
                                                                            <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom3IDNo" runat="server" placeholder="Document ID"  maxlength="50">
                                                                            </div>
                                        
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                        <label for="nom3DocAsyncFileUpload" class="control-label col-sm-4">Upload document*:</label>
                                                                        <div class="col-sm-8">
                                                                            <ajaxToolkit:AsyncFileUpload ID="nom3DocAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="nom3DocAsyncFileUpload_UploadedComplete" runat="server" />
                                                                            <span id="spannom3DocAsyncFileUpload" runat="server"></span>
                                                                        </div>
                                                                    </div>
                                                                    </div>
                                                                    <div class="col-sm-6">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="dtNom3DateofBirth" class="control-label col-sm-4">DOB*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="date" class="form-control" id="dtNom3DateofBirth" onchange="checkMinor('3')" runat="server">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <div class="form-check">
                                                                        <label class="form-check-label" for="chkNom3IsMinor">
                                                                            &nbsp;<input type="checkbox" class="form-check-input" disabled="disabled" onchange="if(this.checked==false){activaTab('ModalNominee3Tab');} else {activaTab('ModalNominee3MinorGuardianTab');}"  id="chkNom3IsMinor" runat="server" name="chkNom3IsMinor">&nbsp;&nbsp; Nominee is minor?
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="ModalNominee3MinorGuardianTab" class="tab-pane fade in">
                                                            <div class="row">
                                                            <div class="col-sm-5">
                                                                <label for="txtNom3MinorGuardianName" class="control-label col-sm-5">Guardian Name*:</label>
                                                                <div class="col-sm-7">
                                                                    <select class="form-control" id="selectNom3MinorGuardianPrefix" runat="server">
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-7">
                                                                <div class="form-group">
                                                                    <div class="col-sm-12">
                                                                        <input type="text" class="form-control" id="txtNom3MinorGuardianName" runat="server" placeholder="Guardian Name" maxlength="50">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom3MinorGuardianRelation" class="control-label col-sm-4">Relation:</label>
                                                                        <div class="col-sm-8">
                                                                            <!--<input type="text" class="form-control" id="txtNom3MinorGuardianRelation" runat="server" placeholder="Relation" maxlength="50">-->
                                                                            <asp:DropDownList ID="cmbNom3MinorGuardianRelation" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-2">
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-check">
                                                                        <label class="form-check-label" for="chkAddressSameAsNominee3">
                                                                            &nbsp;<input type="checkbox" class="form-check-input" onchange="setMinorAddressSameAsNominee(this.checked,'3');"  id="chkAddressSameAsNominee3" runat="server" name="chkAddressSameAsNominee3">&nbsp;&nbsp;  Address same as Nominee?
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3MinorGuardianAdd1" class="control-label col-sm-4">Address 1*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom3MinorGuardianAdd1" runat="server" placeholder="Address 1" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                    <label for="txtNom3MinorGuardianAdd2" class="control-label col-sm-4">Address 2:</label>
                                                                    <div class="col-sm-8">
                                                                        <input type="text" class="form-control" id="txtNom3MinorGuardianAdd2" runat="server" placeholder="Address 2" maxlength="50">
                                                                    </div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3MinorGuardianAdd3" class="control-label col-sm-4">Address 3:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom3MinorGuardianAdd3" runat="server" placeholder="Address 3" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3MinorGuardianCity" class="control-label col-sm-4">City:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text" class="form-control" id="txtNom3MinorGuardianCity" runat="server" placeholder="City" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3MinorGuardianPincode" class="control-label col-sm-4">Pincode*:</label>
                                                                        <div class="col-sm-8">
                                                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtNom3MinorGuardianPincode" runat="server" placeholder="Pincode">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom3MinorGuardianState" class="control-label col-sm-4">State*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom3MinorGuardianState" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="cmbNom3MinorGuardianCountry" class="control-label col-sm-4">Country*:</label>
                                                                        <div class="col-sm-8">
                                                                            <asp:DropDownList ID="cmbNom3MinorGuardianCountry" CssClass="form-control" runat="server">
                                                                            </asp:DropDownList>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row" style="padding-top:10px">
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3MinorGuardianMobile" class="control-label col-sm-4">Mobile:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="number"  class="form-control" id="txtNom3MinorGuardianMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Mobile">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label for="txtNom3MinorGuardianEmail" class="control-label col-sm-4">Email:</label>
                                                                        <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom3MinorGuardianEmail" runat="server" placeholder="Email" maxlength="50">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div style="border:0.5px solid silver; margin-top:10px;border-radius:4px;">
                                                                <span style="font-weight:bold;font-size:1.2em;color:silver;padding:10px 0px 0px 10px;">Upload Identification Document</span>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                            <label for="cmbNom3MinorGuardianIdType" class="control-label col-sm-4">Id Type*:</label>
                                                                            <div class="col-sm-8">
                                                                                <asp:DropDownList ID="cmbNom3MinorGuardianIdType" onchange="CleanExistingFileData('spannom3MinorGuardianDocAsyncFileUpload', 'nom3MinorGuardianDocAsyncFileUpload');" CssClass="form-control" runat="server">
                                                                                </asp:DropDownList>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                            <label for="txtNom3MinorGuardianIDNo" class="control-label col-sm-4">ID No*:</label>
                                                                            <div class="col-sm-8">
                                                                            <input type="text"  class="form-control" id="txtNom3MinorGuardianIDNo" runat="server" placeholder="ID No" maxlength="50">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row" style="padding-top:10px">
                                                                    <div class="col-sm-6">
                                                                        <div class="form-group">
                                                                        <label for="nom3MinorGuardianDocAsyncFileUpload" class="control-label col-sm-4">Upload document*:</label>
                                                                        <div class="col-sm-8">
                                                                            <ajaxToolkit:AsyncFileUpload ID="nom3MinorGuardianDocAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="nom3MinorGuardianDocAsyncFileUpload_UploadedComplete" runat="server" />
                                                                            <span id="spannom3MinorGuardianDocAsyncFileUpload" runat="server"></span>
                                                                        </div>
                                                                    </div>
                                                                    </div>
                                                                    <div class="col-sm-6">
                                                                    </div>
                                                                </div>
                                                           </div>
                                                        </div>
                                                    </div>
                                                  </div>
                                               </div>
                                              </div>
                                                <button type="button" class="btn btn-success btn-lg margineTop10" id="btnContinue" disabled="disabled" onclick="saveNomination('Add Nominee');" runat="server" ><i class="fa fa-check" aria-hidden="true"></i> Save and Continue</button>
                                                <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                                </div>
                                              <hr />
                                               <h4>Go to previous step </h4> 
                                             <ul class="list-inline">
                                                <li><a href="PANVerification.aspx"><i class="fa fa-id-card" aria-hidden="true"></i> PAN</a></li>
                                                <li><a href="selectSegments.aspx"><i class="fa fa-exchange" aria-hidden="true"></i> Segments</a></li>
                                                <li><a href="aadhaarKYC.aspx"><i class="fa fa-user" aria-hidden="true"></i> Aadhaar Data</a></li>
                                                <li><a href="capturePhoto.aspx"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                                <li><a href="profile.aspx"><i class="fa fa-user" aria-hidden="true"></i> Profile</a></li>
                                                <li><a href="addBank.aspx"><i class="fa fa-university" aria-hidden="true"></i> Bank</a></li>
                                            </ul>
                                          </div>

                                          <div class="col-md-4">
                                              <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">

                                                  <div class="ekycCard">
                                                      <div class="ekycCardTitle">
                                                          <h4 style="margin-bottom:0px;">Why do I need Nominees?</h4>
                                                      </div>
                                                      <div>
                                                          To avoid Inheritance Complications! Without a nominee, the distribution of assets may become complicated, potentially leading to disputes among legal heirs. Appointing a nominee helps ensure that your wishes regarding the distribution of your securities are respected
                                                      </div>
                                                      <div class="ekycCardTitle">
                                                      <h4 style="margin-bottom:0px;">How many Nominees can I appoint?</h4>
                                                      </div>
                                                      <div>
                                                          You can divide your Holdings amongst a maximum of 3 nominees, with their %age shares adding up to 100%
                                                      </div>

                                                  </div>


                                                  <br />
                                                  <div class="alert alert-info" id="divAlertInfoMsg" style="display:none" runat="server">
                                                  </div>
                                                  <div class="alert alert-warning">
                                                      <b>Important Note for Aadhaar Upload:</b> 
                                                      <hr style="margin-top:5px; margin-bottom:5px" />
                                                      <span style="font-size:12px;" id="spanAadhaarUploadNotes" runat="server">
                                                      </span>
                                                      <hr />
                                                      <i><b>Disclaimer:</b> Keep the file size under 2MB.<br />Use one of these formats: JPG, PNG, JPEG, or PDF.</i>
                                                      <p class="margineTop10">
                                                        Please ensure that the files you upload are <b>not password-protected</b> and <b>not corrupted</b>
                                                      </p>
                                                  </div>

                                                  <br />
                                                  <br />
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                           </ContentTemplate>
                        </asp:UpdatePanel>

                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
              <!--<div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>-->


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
			    </div>
             </div>

          </div>
        </section>
    </form>

    <div id="confirmOptoutNominationModal" class="modal fade">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="cancelOptoutNomination();"><span aria-hidden="true">&times;</span></button>
                <h2>Opt-out of Nomination</h2>
              </div>
              <div class="modal-body">
                  <h4 id="confirmOptoutModalbody">Do you really want to Opt-out of Nomination?</h4>
                  <br />
                  <h4><u>Declaration</u></h4>
                  <p>
                      I / We hereby confirm that I / We do not wish to appoint any nominee(s) in my / our trading / Demat account and understand the issues involved in non-appointment of nominee(s) and further are aware that in case of death of all the account holder(s), my / our legal heirs would need to submit all the requisite documents / information for claiming of assets held in my / our trading / Demat account, which may also include documents issued by Court or other such competent authority, based on the value of assets held in the trading / Demat account.
                  </p>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <button type="button" class="btn btn-lg btn-primary" data-dismiss="modal" onclick="cancelOptoutNomination();" id="btnConfirmOptoutNominationModalNo" style="margin-top:5px">No, I don't agree</button>
                  <button type="button" class="btn btn-lg btn-danger" data-dismiss="modal" id="btnConfirmOptoutNominationModalYes" onclick="saveNomination('Opt Out')" style="margin-top:5px">Yes, I agree and want to opt out</button>
              </div>
            </div>
          </div>
        </div>
    
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="js/ekyc.js"></script>

     <script>

         window.onload = function () {
            
         }

         function pageLoad(sender, args) {

             if (document.getElementById('hdnActivaTab').value != "") {
                 activaTab(document.getElementById('hdnActivaTab').value);
                 document.getElementById('hdnActivaTab').value = "";
             }
         }

         function setMinorAddressSameAsNominee(isChecked, slno) {
             //alert(slno);

             if (isChecked == true) {
                 document.getElementById('txtNom' + slno + 'MinorGuardianAdd1').value = document.getElementById('txtNom' + slno + 'Add1').value;
                 document.getElementById('txtNom' + slno + 'MinorGuardianAdd2').value = document.getElementById('txtNom' + slno + 'Add2').value;
                 document.getElementById('txtNom' + slno + 'MinorGuardianAdd3').value = document.getElementById('txtNom' + slno + 'Add3').value;
                 document.getElementById('txtNom' + slno + 'MinorGuardianCity').value = document.getElementById('txtNom' + slno + 'City').value;
                 document.getElementById('txtNom' + slno + 'MinorGuardianPincode').value = document.getElementById('txtNom' + slno + 'Pincode').value;
                 document.getElementById('cmbNom' + slno + 'MinorGuardianState').value = document.getElementById('cmbNom' + slno + 'State').value;
                 document.getElementById('cmbNom' + slno + 'MinorGuardianCountry').value = document.getElementById('cmbNom' + slno + 'Country').value;
             }
             else {
                 document.getElementById('txtNom' + slno + 'MinorGuardianAdd1').value = "";
                 document.getElementById('txtNom' + slno + 'MinorGuardianAdd2').value = "";
                 document.getElementById('txtNom' + slno + 'MinorGuardianAdd3').value = "";
                 document.getElementById('txtNom' + slno + 'MinorGuardianCity').value = "";
                 document.getElementById('txtNom' + slno + 'MinorGuardianPincode').value = "";
                 document.getElementById('cmbNom' + slno + 'MinorGuardianState').value = "";
                 document.getElementById('cmbNom' + slno + 'MinorGuardianCountry').value = "IN";
             }

             

         }

         function ShowModal(title, body) {
             alert(1);
                alertModal(title, body);
         }

         function IsMobileNumber(number) {
                var val = number.value
                if (/^\d{10}$/.test(val)) {
                    // value is ok, use it
                    return true
                } else {
                    alertModal("Opps! Problem with the Mobile Number", "Mobile Number must be 10 digits");
                    number.focus()
                    return false
                }
         }

         function optoutNomination() {
             
             if (document.getElementById('selectMakeNominees').value == "No") {
                 document.getElementById('btnContinue').style.display = "none";
                 document.getElementById('divOptOutNominees').style.display = "block";
                 document.getElementById('divNominees').style.display = "none";
                 $('#confirmOptoutNominationModal').modal('show');
             }
             else {
                 cancelOptoutNomination();
             }
   
         }

         function cancelOptoutNomination() {
             document.getElementById('selectMakeNominees').value = "Yes";
             document.getElementById('btnContinue').style.display = "block";
             document.getElementById('divOptOutNominees').style.display = "none";
             document.getElementById('divNominees').style.display = "block";
         }

         function activaTab(tab){
              $('.nav-tabs a[href="#' + tab + '"]').tab('show');
            };

         function getAge(DOB) {
            var today = new Date();
            var birthDate = new Date(DOB);
            var age = today.getFullYear() - birthDate.getFullYear();
            var m = today.getMonth() - birthDate.getMonth();
            if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
                age--;
            }
            return age;
         }

         function saveNomination(operation) {

             //saveNomination("Opt Out")
             //saveNomination("Add Nominee")

             if (operation == "Add Nominee") {

                 if (addNominees() == false) {
                     return;
                 }

             }
             else if (operation != "Opt Out") {
                 return;
             }

             document.getElementById('hdnBtnContinueClicked').value = operation; // Opt Out | Add Nominee
             showModalLoading();

             document.getElementById('<%= btnContinueClick.UniqueID %>').click();

         }
         

         function addNominees() {
             
             if (validateNominee(1) == false) {
                 return false;
             }


             if (document.getElementById('txtNom1Name').value != '' &&
                 document.getElementById('txtNom2Name').value != '') {

                 if (validateNominee(2) == false) {
                     return false;
                 }
             }
             

             if (document.getElementById('txtNom1Name').value != '' &&
                 document.getElementById('txtNom2Name').value != '' &&
                 document.getElementById('txtNom3Name').value != '') {

                 if (validateNominee(3) == false) {
                     return false;
                 }
             }

             if (Number(document.getElementById('hdnNomResidualPercent').value)>0) {

                 alertModal("Opps! Sharing not complete", document.getElementById('hdnNomResidualPercent').value + "% nominations share available!<br/><br/>Total Share of Nominations should be 100% added up for all nominees.");
                 return false;
             }

             return true;


         }

         function validateNominee(nomNo) {
             
             if (document.getElementById('txtNom' + nomNo + 'Name').value == '') {
                 alertModal("Opps! Problem with Nominee " + nomNo, "Please enter Nominee"+nomNo+"'s Name");
                 return false;
             }

             if (document.getElementById('txtNom'+nomNo+'Percent').value == "" || document.getElementById('txtNom'+nomNo+'Percent').value == "0.00") {
                 alertModal("Opps! Problem with Nominee " + nomNo, "Nominee" + nomNo + "'s Share of nomination in %age not specified");
                 return false;
             }

             
             //alert('hdnNominee' + nomNo + 'Share' + document.getElementById('hdnNominee' + nomNo + 'Share').value);
             //alert('hdnNomResidualPercent' + document.getElementById('hdnNomResidualPercent').value);
             
             var NomResidualPercent = Number(document.getElementById('hdnNomResidualPercent').value) + Number(document.getElementById('hdnNominee' + nomNo + 'Share').value);

             //alert('NomResidualPercent' + NomResidualPercent);
             
             if (document.getElementById('txtNom'+nomNo+'Percent').value < 1 || document.getElementById('txtNom'+nomNo+'Percent').value > NomResidualPercent) {

                 if (Number(NomResidualPercent) == 0) {
                     alertModal("Opps! Problem with total Nomination shares", "The total Nomination shares of all nominees put together cannot exceed be 100%");
                     return false;
                 }

                 alertModal("Opps! Problem with Nominee " + nomNo, "Please enter Nominee"+nomNo+"'s share % (1 to " + NomResidualPercent+")");
                 return false;
             }


             if (document.getElementById('txtNom'+nomNo+'Add1').value == "") {
                 alertModal("Opps! Problem with Nominee " + nomNo, "Please enter Nominee" + nomNo+ "'s Address");
                 return false;
             }
             if (document.getElementById('txtNom'+nomNo+'Pincode').value == "") {
                 alertModal("Opps! Problem with Nominee " + nomNo, "Please enter Nominee" + nomNo+ "'s Pincode");
                 return false;
             }

             if (document.getElementById('cmbNom'+nomNo+'State').value == "") {
                 alertModal("Opps! Problem with Nominee " + nomNo, "Please select Nominee" + nomNo+ "'s State");
                 return false;
             }

             if (document.getElementById('cmbNom'+nomNo+'Country').value == "") {
                 alertModal("Opps! Problem with Nominee " + nomNo, "Please enter Nominee" + nomNo+ "'s Country");
                 return false;
             }

             if (document.getElementById('txtNom'+nomNo+'IDNo').value == "") {
                 alertModal("Opps! Problem with Nominee " + nomNo, "Please enter a valid document ID for Nominee" + nomNo+ "");
                 return false;
             }

             //if (document.getElementById('txtNom'+nomNo+'Mobile').value != "") {
             //    if (!IsMobileNumber(document.getElementById('txtNom'+nomNo+'Mobile')))
             //        return false;
             //}

             //if (document.getElementById('txtNom'+nomNo+'Email').value != "") {
             //    if (!ValidateEmail(document.getElementById('txtNom'+nomNo+'Email')))
             //        return false;
             //}



             if (document.getElementById('txtNom' + nomNo + 'Mobile').value == "") {
                 alertModal("Opps! Problem with Nominee " + nomNo, "Please enter a valid Mobile Number for Nominee" + nomNo + "");
                 return false;
             }


              if (!IsMobileNumber(document.getElementById('txtNom'+nomNo+'Mobile')))
                 return false;


             if (document.getElementById('txtNom' + nomNo + 'Email').value == "") {
                 alertModal("Opps! Problem with Nominee " + nomNo, "Please enter a valid Email ID for Nominee" + nomNo + "");
                 return false;
             }

             if (!ValidateEmail(document.getElementById('txtNom'+nomNo+'Email')))
                 return false;


             if (validateFileExtensionByFileName(document.getElementById('spannom'+nomNo+'DocAsyncFileUpload').innerHTML, "Nominee"+nomNo+" Id Proof", "JPG,PNG,JPEG,PDF") == false) {
                 return false;
             }

             if (document.getElementById('dtNom'+nomNo+'DateofBirth').value == "") {
                 alertModal("Opps! Problem with Nominee " + nomNo, "Please enter Nominee" + nomNo+ "'s Date of Birth");
                 return false;
             }

             var enteredAge = getAge(document.getElementById('dtNom'+nomNo+'DateofBirth').value);

             if (enteredAge > 17 && document.getElementById('chkNom'+nomNo+'IsMinor').checked) {
                 alertModal("Opps! Problem with Nominee " + nomNo, "Date of Birth not valid<br/> Nominee" + nomNo+ "'s age is not minor nominee. A nominee who is under the legal age that is 18 years of age is known as a minor nominee");
                 return false
             }

             if (enteredAge < 18 && !document.getElementById('chkNom'+nomNo+'IsMinor').checked) {
                 alertModal("Opps! Problem with Nominee " + nomNo, "Nominee" + nomNo+ " seems to be a minor<br/> Any nominee who is under the legal age of 18 is a minor nominee, and requires filling of <i>Guardian Details</i>");
                 return false
             }

             if (document.getElementById('chkNom'+nomNo+'IsMinor').checked) {

                 activaTab('ModalNominee'+nomNo+'MinorGuardianTab');

                 if (document.getElementById('txtNom'+nomNo+'MinorGuardianName').value == "") {
                     alertModal("Opps! Problem with Nominee " + nomNo, "Please enter Minor Nominee's Guardian Name");
                     return false;
                 }

                 if (document.getElementById('txtNom'+nomNo+'MinorGuardianAdd'+nomNo+'').value == "") {
                     alertModal("Opps! Problem with Nominee " + nomNo, "Please enter the Address1 of the Minor Nominee's Guardian");
                     return false;
                 }
                 if (document.getElementById('txtNom'+nomNo+'MinorGuardianPincode').value == "") {
                     alertModal("Opps! Problem with Nominee " + nomNo, "Please enter the Pincode of the Minor Nominee's Guardian");
                     return false;
                 }


                 if (document.getElementById('cmbNom'+nomNo+'MinorGuardianState').value == "") {
                     alertModal("Opps! Problem with Nominee " + nomNo, "Please select the State of the Minor Nominee's Guardian ");
                     return false;
                 }

                 if (document.getElementById('cmbNom'+nomNo+'MinorGuardianCountry').value == "") {
                     alertModal("Opps! Problem with Nominee " + nomNo, "Please enter the Country of the Minor Nominee's Guardian");
                     return false;
                 }

                 if (document.getElementById('txtNom'+nomNo+'MinorGuardianIDNo').value == "") {
                     alertModal("Opps! Problem with Nominee " + nomNo, "Please enter a valid document ID for the Minor Nominee's Guardian");
                     return false;
                 }

                 if (validateFileExtensionByFileName(document.getElementById('spannom'+nomNo+'MinorGuardianDocAsyncFileUpload').innerHTML, "Minor Nominee"+nomNo+" Guardian's Id Proof", "JPG,PNG,JPEG,PDF") == false) {
                     return false;
                 }

                 if (document.getElementById('txtNom'+nomNo+'MinorGuardianMobile').value != "") {
                     if (!IsMobileNumber(document.getElementById('txtNom'+nomNo+'MinorGuardianMobile')))
                         return false;
                 }

                 if (document.getElementById('txtNom'+nomNo+'MinorGuardianEmail').value != "") {
                     if (!ValidateEmail(document.getElementById('txtNom'+nomNo+'MinorGuardianEmail')))
                         return false;
                 }



             }

             document.getElementById('hdnNominee' + nomNo + 'Share').value = document.getElementById('txtNom' + nomNo + 'Percent').value;
             document.getElementById('hdnNomResidualPercent').value = Number(NomResidualPercent) - Number(document.getElementById('txtNom' + nomNo + 'Percent').value);

             //alert('hdnNominee' + nomNo + 'Share' + document.getElementById('hdnNominee' + nomNo + 'Share').value);
             //alert('NomResidualPercent' + document.getElementById('hdnNomResidualPercent').value);

             if (document.getElementById('hdnNominee1Share').value>0 &&
                 document.getElementById('txtNom2Name').value == '') {

                 document.getElementById('txtNom2Percent').value = document.getElementById('hdnNomResidualPercent').value;
                 document.getElementById('txtNom3Percent').value = "0";
             }
             

             if (document.getElementById('hdnNominee2Share').value>0 &&
                 document.getElementById('txtNom3Name').value == '') {

                 document.getElementById('txtNom3Percent').value = document.getElementById('hdnNomResidualPercent').value;
             }

             return true;
             
         }



         function successAsyncFileUpload(sender, args) {

             const contolName = $(sender._element).find('input').attr('id');
             //alert('span' + contolName.replace(/(^.+)(_.+$)/, '$1'));
             const spanContolName =  'span' + contolName.replace(/(^.+)(_.+$)/, '$1')

             $(sender._element).find('input').css("background-color", "white");

             var filename = $(sender._element).find('input').val().replace("C:\\fakepath\\", "");

             document.getElementById(spanContolName).innerHTML = filename;
             document.getElementById(spanContolName).style.backgroundColor = "lime";
             document.getElementById("btnContinue").disabled = false;
         }

         function CleanExistingFileData(spanAsyncFileUploadId, asyncFileUploadId) {
             document.getElementById(spanAsyncFileUploadId).innerHTML = "";
             document.getElementById(spanAsyncFileUploadId).style.backgroundColor = "white";
                          
             // Find the file upload control by its ID
             var asyncFileUpload = document.getElementById(asyncFileUploadId);
             //var asyncFileUpload = document.querySelector('[id*="'+asyncFileUploadId+'"]');


             // Find the input of type 'file' inside the div
             const fileInput = asyncFileUpload.querySelector("input[type='file']");

             // Find the input of type 'hidden' inside the div
             const hiddenInput = asyncFileUpload.querySelector("input[type='hidden']");

             fileInput.value = ''; // Clear the input
             hiddenInput.value = '';
             document.getElementById("btnContinue").disabled = true;
         }

         function ValidateEmail(input) {

            var validRegex = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;

            if (input.value.match(validRegex)) {

                input.focus();
                return true;

            } else {

                //alert("Invalid email address!");
                alertModal("Opps! Problem with Email Address", "Invalid email address entered");

                input.focus();

                return false;

            }

         }

         function validateFileExtensionByElementId(fileElementId, ElementType, fileTypes) {

             var fileElement = document.getElementById(fileElementId)
             var fileElementFileName = "";

             if (fileElement.value != "") {
                 fileElementFileName = fileElement.files.item(0).name.toUpperCase();
             }

             return validateFileExtensionByFileName(fileElementFileName, ElementType, fileTypes);

         }

         function validateFileExtensionByFileName(fileName, uploadType, fileTypes) {


             if (fileName == "") {
                 alertModal("Opps! Problem with the " + uploadType + " file upload", "Please select and upload the file in " + fileTypes + " format");
                 return false;
             }

             const fileTypesArray = fileTypes.split(",");

             let matchesNameExtns = "";
             for (let i = 0; i < fileTypesArray.length; i++) {

                 if (i == fileTypesArray.length - 1) {
                     matchesNameExtns += "." + fileTypesArray[i] + "$";
                 }
                 else {
                     matchesNameExtns += "." + fileTypesArray[i] + "$|";
                 }

             }

             var fileElementFileName = fileName.toUpperCase();

             if (fileElementFileName.match(matchesNameExtns) == null) {
                 alertModal("Opps! Problem with the " + uploadType + " file upload", "Invalid file selected! Please select and upload the file in " + fileTypes + " format");
                 return false;
             }

             return true;

         }

         function checkMinor(nomNo) {

             var dobInput = document.getElementById("dtNom" + nomNo + "DateofBirth").value;
             if (!dobInput) return;

             var dob = new Date(dobInput);
             var today = new Date();
             var age = today.getFullYear() - dob.getFullYear();

             // Adjust for birth month/day
             var monthDiff = today.getMonth() - dob.getMonth();
             if (monthDiff < 0 || (monthDiff === 0 && today.getDate() < dob.getDate())) {
                 age--;
             }

             // Check the box if age is below 18
             document.getElementById("chkNom" + nomNo + "IsMinor").checked = age < 18;
         }


    </script>

</body>
</html>
