﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="OpenAccount.aspx.cs" Inherits="Connect_DotNet.eKYC.OpenAccount" %>

<!--     
eKyc System MAIN Entrance Page
-->

<!DOCTYPE html>
<html>
<head runat="server">
    <title>Open Account</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/crypto-js/4.1.1/crypto-js.min.js"></script>

    <!-- application specific stylesheets -->
    <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />
   
</head>
<body>

    <!-- ssAjax : StanSoft Javascript Library 
	<script type="text/javascript" src="../../scripts/ssajax.js"></script>
        -->
    <script type="text/javascript" src="js/ekyc.js"></script>

    <script>

        function startCountdown() {
            
             $('#modalLoading').modal('hide');

             let countdownTime = 30; // 30 seconds countdown
             let countdownInterval;
             
             document.getElementById('divResendValidate').style.display = 'block';

             document.getElementById('btnOTPMobileResend').style.display = 'none';
             document.getElementById('countdownTimer').style.display = 'block';

             let timerElement = document.getElementById('timer');
             timerElement.textContent = countdownTime;

             // Start countdown
             countdownInterval = setInterval(() => {
                 countdownTime--;
                 timerElement.textContent = countdownTime;

                 // When countdown ends
                 if (countdownTime <= 0) {
                     clearInterval(countdownInterval);
                     countdownTime = 30; // Reset countdown time
                     document.getElementById('countdownTimer').style.display = 'none';
                     document.getElementById('btnOTPMobileResend').style.display = 'inline-block';
                 }
             }, 1000);
         }
    </script>

     <script>

          function IsMobileNumber(number) {
                var val = number.value
                if (/^\d{10}$/.test(val)) {
                    // value is ok, use it
                    return true
                } else {
                    alertModal("Opps! Problem with the Mobile Number", "Invalid number; must be 10 digits");
                    //alert("Invalid number; must be 10 digits!")
                    number.focus()
                    return false
                }
         }

         
         function IagreeOnchange() {

             if (document.getElementById('chkbxIagree').checked == true) {

                 $('#modalTerms').modal('show');
             }
         }

         function sendMobileOTP(reSend) {

            var btnSendMobileOTP = document.getElementById('btnSendMobileOTP');
            var txtMobile = document.getElementById('txtMobile');
            var txtMobileOTP = document.getElementById('txtMobileOTP');
            var btnOTPMobileResend = document.getElementById('btnOTPMobileResend');
            var btnOTPMobileValidate = document.getElementById('btnOTPMobileValidate');

             txtMobileOTP.value = "";

             //alert(document.getElementById('chkbxIagree').checked);


            if (txtMobile.value == "") {
                alertModal("Opps! Problem with the Mobile Number", "Please enter Mobile number");
                return;
            }

            if (!IsMobileNumber(txtMobile))
                 return;

             
             if (document.getElementById('chkbxIagree').checked == false && reSend == false) {

                 alertModal("Oops! Hold on",
                     "You need to carefully read the Terms and Conditions of the process and agree to them. Click on the I have read checkbox and proceed please.");
                 return;

             }

             document.getElementById('hdnBtnMobileVerificationClicked').value = "Sent OTP";
             //document.getElementById('divResendValidate').style = "display:block";

             
             //$('#modalLoading').modal('show');
             showModalLoading();
            document.getElementById('<%= btnMobileVerification.UniqueID %>').click();


         }

         function validateMobileOTP() {
             var txtMobileOTP = document.getElementById('txtMobileOTP');

             // No value entered
             if (txtMobileOTP.value == "") {
                 alertModal("Oops", "You have not entered the OTP.<br/>Check your mobile and enter the correct OTP please!");
                 return;
             }

             document.getElementById('hdnBtnMobileVerificationClicked').value = "Validate OTP";

             showModalLoading();

             var otp = document.getElementById('txtMobileOTP').value;
             //alert("Original OTP: " + otp);
             var cipherOTP = CryptoJS.AES.encrypt(otp, "mithuntest").toString();
             //alert("Encrypted OTP: " + cipherOTP);

             document.getElementById('txtMobileOTP').value = cipherOTP;
             //alert("Input Value Now: " + document.getElementById('txtMobileOTP').value);

             document.getElementById('<%= btnMobileVerification.UniqueID %>').click();
         }

        
    </script>

    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                <div class="col-md-3">
                    <center>
                    <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px; padding-top:10px">
                    </center>
                </div>
                <div class="col-md-9">
                    <h2 class="lblTopHeader">Open Your Trading & Demat Account <i class="fa fa-user" aria-hidden="true"></i></h2>
                    <p>Open a trading and demat account and start investing.</p>
                </div>
              </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

               <header class="bg-primary text-white text-center py-5">
                    <div class="container" style="border-radius:10px;">
                        <h3 class="display-4">Paperless Processes for Digital India</h3>
                        <p class="lead">Complete your eKYC and start investing in just a few clicks!</p>
                    </div>
                </header>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5" id="divMain" runat="server">
                    <div class="row justify-content-center">
                      <div class="col-md-10 col-lg-6" >

                        <p class="h2 fw-bold mb-5 mx-1 mx-md-4 mt-4">Signup Now
                            <br />
                            <small>or track your existing application</small>
                        </p>
                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnMobileVerification" runat="server" Text="" OnClick="btnMobileVerification_Click" /> 
                                    <input type="hidden" id="hdnBtnMobileVerificationClicked" name="hdnBtnMobileVerificationClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                <div class="form-outline flex-fill mb-0">
                                  <label class="form-label" for="txtMobile"><i class="fas fa-mobile fa-lg me-3 fa-fw"></i> Enter Your Mobile Number</label>
                                  <input type="number"  class="form-control" id="txtMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Mobile No.">
                                  <small id="smMsg" runat="server" style="font-size:0.8em">You will receive an OTP on your Mobile Number</small>
                                    <!-- *abhay -->
                                    <div style="margin-top:5px">
                                        <label class="form-label" for="cmbDependancy"><i class="fas fa-user fa-lg me-3 fa-fw"></i>This account is being opened for</label>
                                        <asp:DropDownList ID="cmbDependancy" CssClass="form-control" runat="server"></asp:DropDownList>
                                    </div>
                                </div>
                              </div>

                              <!-- OTP Input -->
                              <input type="password" class="form-control inputOTP" id="txtMobileOTP"  maxlength="6" 
                                oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,6)" 
                                runat="server" placeholder="Enter the OTP" 
                                style="display:none;">

                              <div class="form-check d-flex justify-content-center mb-5" style="margin-top:10px" id="divChkbxIagree" runat="server" >
                                <input class="form-check-input me-2" type="checkbox" onchange="IagreeOnchange()" value="" id="chkbxIagree" />
                                <label class="form-check-label" for="chkbxIagree">
                                  I have read the <a href="#" onclick="$('#modalTerms').modal('show');">Terms and Conditions</a> and I agree to them
                                </label>
                              </div>

                              <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4" >
                                <button type="button" class="btn btn-primary btn-lg" id="btnSendMobileOTP" onclick="sendMobileOTP(false)" runat="server" ><i class="fa fa-bell" aria-hidden="true"></i> Continue</button>
                              </div>
                              <div id="divResendValidate" runat="server" style="display:none; margin-top:10px" >
                                <button type="button" class="btn btn-lg btn-success btnpadingtop" style="margin-top:5px" id="btnOTPMobileValidate" onclick="validateMobileOTP()"><i class="fa fa-check" aria-hidden="true"></i> Verify and confirm OTP</button>
                                <button type="button" class="btn btn-lg btn-primary btnpadingtop" style="margin-top:5px; display:none" id="btnOTPMobileResend" onclick="sendMobileOTP(true)"><i class="fa fa-repeat" aria-hidden="true"></i> Resend OTP</button>
                                <div id="countdownTimer" style="display: none;">
                                    You can request fresh OTP only after <b><span id="timer">30</span> seconds</b>
                                </div>
                                  <br />
                                  <br />
                                  <span id="spanDebugOTP" runat="server" style="display:none"></span>
                              </div>
                                <br />
                            </ContentTemplate>
                        </asp:UpdatePanel>
                      </div>
                      <div class="col-md-10 col-lg-6 " style="text-align:center">
                          <!-- The image will be loaded from the css 
                          <div class="mobilePage_FeaturedImage FeaturedImage modal-content rounded-4 shadow  hidden-xs hidden-sm" style="margin-top:5px">
                              
                          </div>
                              -->
                          <img src="images/ekyc-Aadhaar.png" alt="Sample image" style="width:75%;">
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
              <br />
              <!-- How It Works Section -->
                 <!-- How It Works Section -->
                <section id="steps" class="bg-light py-5">
                    <div class="container text-center">
                        <h2 class="mb-4">How It Works</h2>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="card shadow-sm">
                                    <div class="card-body">
                                        <h5 class="card-title">Step 1</h5>
                                        <p class="card-text">Fill out your details and upload documents for KYC verification.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card shadow-sm">
                                    <div class="card-body">
                                        <h5 class="card-title">Step 2</h5>
                                        <p class="card-text">Verify your identity using Aadhaar and PAN card online.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card shadow-sm">
                                    <div class="card-body">
                                        <h5 class="card-title">Step 3</h5>
                                        <p class="card-text">Activate your account and start trading and investing instantly.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

              <!--<div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>-->

              <div id="divErrorMsg" runat="server" style="margin-top:20px; height: 100%; display:none; width: 100%; text-align: center;">
                        <div class="alert alert-danger" role="alert">
				            <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span> <span id="spanError" runat="server"></span>
			            </div>
		            </div>


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span></br>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
			    </div>
             </div>

          </div>
        </section>
        
    </form>


    <!-- Modal -->
<div class="modal fade" id="modalTerms" tabindex="-1" role="dialog" aria-labelledby="modalTermsLabel">
  <div class="modal-dialog modal-lg" style=" height: 97%;">
    <div class="modal-content" style=" height: 97%;">
      <div class="modal-header bg-success">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h2 class="modal-title" id="modalTermsLabel">Terms and Conditions</h2>
      </div>
      <div class="modal-body" style="max-height: calc(75%);  overflow-y: scroll;">
        <div id="divtermsandconditionsHTML">
            <%=termsandconditionsHTML%>
        </div>
      </div>

      <div class="modal-footer">
          <div id="divSubmitBtns">
            <p id="divLocation" style="font-size:10px"></p>
            <button type="button" class="btn btn-success btn-lg" data-dismiss="modal"><i class="fa fa-check" aria-hidden="true"></i> Ok</button>
          </div>
        
      </div>
    </div>
  </div>
</div>

</body>
</html>
