﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="aadhaarKYC.aspx.cs" Inherits="Connect_DotNet.eKYC.aadhaarKYC" %>

<!DOCTYPE html>

<html>
<head>
  <title>Fetch Data from DigiLocker</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="js/ekyc.js"></script>    
      <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />
</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }
    </style>
     <script>

           window.onload = function () {


               if (document.getElementById('hdnDetailsModalOpen').value == "Show") {

                   document.getElementById('hdnDetailsModalOpen').value = "";
                   $('#detailsModal').modal('show');

               }

             if (document.getElementById('hdnMsgModalOpen').value != "") {

                 const hdnMsgModalOpenArray = document.getElementById('hdnMsgModalOpen').value.split("####");
                 var titleMsg = hdnMsgModalOpenArray[0];
                 var Msg = hdnMsgModalOpenArray[1];

                 document.getElementById('hdnMsgModalOpen').value = "";
                 alertModal(titleMsg, Msg);

             }
             
         }


          function ContinueDigiLocker(type) {
              document.getElementById('hdnBtnContinueClicked').value = type;

              showModalLoading();
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
             
         }

           function confirmDetails() {
              document.getElementById('hdnBtnContinueClicked').value = "ConfirmDetails";

              showModalLoading();
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
             
         }

          function confirmDetailsShowErrorAlert(title, body) {
             alertModal(title, body);
             $('#btnConfirmDetails').prop('disabled', true);
         }

        
    </script>
    


    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                <div class="col-md-3">
                    <center>
                    <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px; padding-top:10px">
                    </center>
                </div>
                <div class="col-md-9">
                    <h2 class="lblTopHeader"><i class="fa-solid fa-address-card"></i> Fetch Data from DigiLocker</h2>
                    <p>Let us save your time by fetching your PAN and Aadhaar data from DigiLocker.</p>
                </div>
              </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">
                          <input type="hidden" id="hdnMsgModalOpen" name="hdnMsgModalOpen" runat="server" value="">
                          <input type="hidden" id="hdnDetailsModalOpen" name="hdnDetailsModalOpen" runat="server" value="">
                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div class="row">
                                          <div class="col-md-7">
                                              <h3><i class="fa fa-cloud-download" aria-hidden="true"></i> Fetch data for KYC registration</h3>
                                              <p>
                                                  Let us save you time by fetching your documents and details from <i>DigiLocker</i> instead
                                                  of you having to upload them manually. Not just that, we will pick up important information
                                                  and documents and pre-fill the form for you.
                                              </p>
                                             <p>
                                                 We will also cross-verify the details entered by you with the documents that we 
                                                 retrieve from <i>DigiLocker</i>. Also make sure, that
                                                 the PAN number already entered by you [<b><span id="spanPAN" runat="server"></span></b>] should belong to you. If it does not, you need to reenter the correct PAN by <a href="PANVerification.aspx">starting over</a>.
                                             </p>
                                              <p>
                                                  Your name, <b><span id="spanName" runat="server"></span></b>, should also must match with both Aadhaar and PAN.
                                                  If it does not, then you need to resolve the name mismatch by changing your name on the 
                                                  PAN Card by visiting <a href="https://www.onlineservices.nsdl.com/paam/endUserRegisterContact.html"  target="_blank">NSDL</a>  
                                                  or on the Aadhaar Card from <a href="https://www.uidai.gov.in" target="_blank">UIDAI</a>.
                                              </p>
                                          </div>
                                          
                                          <div class="col-md-5 bg-info">
                                              <h4><b>What is DigiLocker?</b></h4>
                                              <p>
                                                 DigiLocker provides a secure online platform for Indian citizens to store and access digital versions of their important documents, such as driver's licenses, vehicle registration certificates, academic certificates, PAN cards, and more 
                                              </p>
                                              
                                              <h4><b>I am not registered with Digilocker!</b></h4>
                                              <p>
                                                  To fetch your Data, you need to be signed up with DigiLocker and your documents already
                                                  uploaded. So no worries! If you still continue with Digilocker here, you will be given
                                                  a chance to register with Digilocker and attach your Aadhaar and Pan.
                                              </p>
                                              <p>
                                                Remember, your Aadhaar number is never visible or available to us
                                              </p>

                                          </div>
                                      </div>
                                  </div>
                              </div>
                              <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                 <button type="button" class="btn btn-success btn-lg" id="btnContinue" onclick="ContinueDigiLocker('DigiLocker');" style="margin-top:5px" runat="server" ><i class="fa fa-cloud-download" aria-hidden="true"></i> Continue with DigiLocker</button>
                                  <span style="font-size:18px; font-weight:bold;">OR <a class="link-secondary" href="manuallyProcessing.aspx" id="btnManually" style="font-size:14px"> <i class="fa fa-edit" aria-hidden="true"></i> <u>Go through Manually</u></a></span> 
                                  
                                  <p>
                                      <br />
                                      <i>
                                        * By clicking the above 'Continue with DigiLocker' button, you acknowledge that you have read the
                                        <a href="terms.aspx?type=aadhaarconsent" target="_blank">
                                            Aadhaar user Consent Document
                                        </a> 
                                        and voluntarily consent to share your Aadhaar information [excluding the Aadhaar number] with <b><span id="spanBrokerName" runat="server">Standard Broker</span></b> for conducting 
                                        online KYC for opening a Trading and Demat account adhering to KRA regulation 2011 and PMLA guidelines 2002.
                                      </i>
                                  </p>
                                  <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                  </div>
                                  <br />
                                  <br />
                              </div>

                            </ContentTemplate>
                        </asp:UpdatePanel>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

                 <h4>Go to previous step </h4> 
                    <ul class="list-inline">
                    <li><a href="PANVerification.aspx"><i class="fa fa-id-card" aria-hidden="true"></i> PAN Verification</a></li>
                    <li><a href="selectSegments.aspx"><i class="fa fa-exchange" aria-hidden="true"></i> Segments</a></li>
                </ul>
            </div>
              <!--<div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>-->


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
			    </div>
             </div>

          </div>
        </section>

        <!-- Modal to display the fetched Aadhar and PAN details -->
        <div class="modal fade" id="detailsModal" tabindex="-1" aria-labelledby="detailsModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-md">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title" id="detailsModalLabel">We fetched your Data. Please check:</h3>
                    </div>

                    <!-- Aadhaar Details -->
                    <div class="modal-body">
                        <div id="divAadhaarDetails" class="bg-success" runat="server" style="display:none;padding:20px;border-radius: 8px;box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);">
                            <h4 style="margin:0px;"><i class="fa fa-id-card" aria-hidden="true"></i> Aadhaar Card details</h4>
                            <hr style="margin:5px 0px 5px 0px;"/>
                            <div class="row">
                                <div class="col-sm-7">
                                  <b>Name on Aadhaar:</b><h5><span id="aadhaarName" runat="server"></span></h5>
                                  <div class="row">
                                    <div class="col-md-12">
                                        <strong>Aadhaar Number :</strong> <span id="aadhaarNumber" runat="server"></span>
                                    </div>
                                    </div>
                                    <div class="row">
                                         <div class="col-md-12">
                                            <strong>Date of Birth:</strong> <span id="aadhaarDOB" runat="server"></span>
                                        </div>
                                    </div>
                                    <div class="row">
                                         <div class="col-md-12">
                                            <strong>Gender:</strong> <span id="aadhaarGender" runat="server"></span>
                                        </div>
                                    </div>  
                                    <div class="row">
                                         <div class="col-md-12">
                                            <strong>Address:</strong> <span id="aadhaarAddress" runat="server"></span>
                                         </div>
                                    </div>
                                </div>
                                
                                <div class="col-sm-5">
                                    <img id="aadhaarPhoto" runat="server" style="width:150px; height:165px;" src="https://via.placeholder.com/100" alt="Aadhaar Photo" class="img-thumbnail">
                                </div>
                            </div>
                        </div>
                        <br />
                        <!-- PAN Details -->
                        <div id="divPANDetails" class="bg-info" runat="server" style="display:none;padding:20px;border-radius: 8px;box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);">
                            <h4 style="margin:0px;"><i class="fa fa-id-card" aria-hidden="true"></i> PAN Card  details</h4>
                            <hr style="margin:5px 0px 5px 0px;"/>
                            <div class="border p-3 mb-3">
                                <b>Name on PAN:</b><h5><span id="panName" runat="server"></span></h5>
                                <p>
                                    <strong>PAN Number : </strong> <span id="panNumber" runat="server"></span>
                                    &nbsp; 
                                    <strong>Status:</strong> <span id="panStatus" runat="server"></span>
                                </p>
                                <p>
                                    <strong>Date of Birth:</strong> <span id="panDOB" runat="server"></span>
                                    &nbsp; &nbsp; &nbsp;
                                    <strong>Gender:</strong> <span id="panGender" runat="server"></span>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <a href="manuallyProcessing.aspx" class="btn btn-lg btn-secondary" data-bs-dismiss="modal"><i class="fa fa-edit" aria-hidden="true"></i> Go through Manually</a>
                        <button type="button" id="btnConfirmDetails" class="btn btn-lg btn-success" onclick="confirmDetails()"><i class="fa fa-check" aria-hidden="true"></i> Confirm & Continue</button>
                    </div>
                </div>
            </div>
        </div>

    </form>
     
</body>
</html>
