﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="capturePhoto.aspx.cs" Inherits="Connect_DotNet.eKYC.capturePhoto" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>Capture your photo</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="js/ekyc.js"></script>
    

    <style>
        .margineTop10{
            margin-top:10px
        }

    #videoContainer {
      position: relative;
      width: 100%; /* Adjust dimensions to match your video size */
      height: 100%;
    }

    #video {
      width: 100%;
      height: 100%;
      /* transform: scaleX(-1);*/ /* Flip the video horizontally */
    }

    #captureBox {
      position: absolute;
      border: 2px solid red; /* Adjust border style and color */
      width: 320px; /* Adjust square box dimensions */
      height: 320px;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      pointer-events: none; /* Ensures clicks pass through to the video element */
    }
  </style>
</head>
<body>
   
     <script>

        window.onload = function () {


            const videoElement = document.getElementById('video');
            const canvasElement = document.getElementById('canvas');
            const capturedImageElement = document.getElementById('capturedImage');
            const captureButton = document.getElementById('captureBtn');

            const captureBox = document.getElementById('captureBox');

            // Get user media - Access webcam
            navigator.mediaDevices.getUserMedia({ video: true })
                .then(function (stream) {
                    videoElement.srcObject = stream;

                    videoElement.onloadedmetadata = function (e) {
                        const actualWidth = videoElement.videoWidth;
                        const actualHeight = videoElement.videoHeight;
                        const aspectRatio = actualWidth / actualHeight;

                        //alert(actualWidth);
                        //alert(actualHeight);
                        //alert(aspectRatio);
                        //alert(actualWidth/aspectRatio);

                        document.getElementById('hdnActualWidth').value = actualWidth;
                        document.getElementById('hdnActualHeight').value = actualHeight;
                        document.getElementById('hdnActualAspectRatio').value = aspectRatio;

                        let captureBoxWidth = actualWidth*0.75;
                        
                        if (aspectRatio > 1) {
                            captureBoxWidth = actualHeight*0.75;
                        }

                        document.getElementById('hdnCaptureBoxWidth').value = captureBoxWidth;
                        

                        document.getElementById("captureBox").style = "position: absolute; border: 2px solid red; width: " + captureBoxWidth + "px; height: " + captureBoxWidth + "px; top: 50%; left: 50%; transform: translate(-50%, -50%); pointer-events: none; }";
                        // Here, you can use or display the obtained width, height, or aspect ratio as needed
                    };

                })
                .catch(function (error) {
                    console.error('Error accessing the webcam:', error);
                });



        }


         function saveData() {
             document.getElementById('hdnBtnContinueClicked').value = "Save";
             showModalLoading();
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
         }

         function sendCapturedlink(value) {
             document.getElementById('hdnBtnContinueClicked').value = value;

             showModalLoading();
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
         }

         function ReCapturedPhoto() {
             window.location.reload();
         }

         function CapturedPhoto() {
             const videoElement = document.getElementById('video');
             const canvasElement = document.getElementById('canvas');
             const capturedImageElement = document.getElementById('capturedImage');
             const captureButton = document.getElementById('captureBtn');

             let canvasElementHeight = 480;

                //canvasElement.width = canvasElementHeight*document.getElementById('hdnActualAspectRatio').value;
                //canvasElement.height = canvasElementHeight;

                canvasElement.width = document.getElementById('hdnActualWidth').value;
                canvasElement.height = document.getElementById('hdnActualHeight').value;

                canvasElement.getContext('2d').drawImage(videoElement, 0, 0, canvasElement.width, canvasElement.height);

                //capturedImageElement.src = canvasElement.toDataURL('image/png');
                //capturedImageElement.style.display = 'block';

                document.getElementById('hdnImage').value = canvasElement.toDataURL('image/png');

                showModalLoading();

                setTimeout(
                    function () {
                        document.getElementById('hdnBtnContinueClicked').value = "Capture";
                        document.getElementById('<%= btnContinueClick.UniqueID %>').click();
                    }
                 , 500);

             document.getElementById("videoContainer").style = "display:none";
             document.getElementById("divContinueNext").style = "display:none";
         }

         function alertModalLinkSendSuccessfully(title, body) {

             if (title == "Link send successfully") {

                 document.getElementById("divContinueIfDone").style = "display:block";
                 document.getElementById("divContinueNext").style = "display:none";
             }

             alertModal(title, body);
         }


    </script>

    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                <div class="col-md-3">
                    <center>
                    <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px; padding-top:10px">
                    </center>
                </div>
                <div class="col-md-6">
                    <h2  class="lblTopHeader"><i class="fa fa-camera" aria-hidden="true"></i> Let us take your Picture</h2>
                    <p>It is time to take your picture for our records and KRA, if required</p>
                </div>
                <div class="col-md-3" style="display:flex;flex-direction:column;align-items:flex-end;">
                    <h4 id="hFullName" runat="server" style="margin:0px;"></h4>
                    <span>DOB: <span id="spanDOB" runat="server"></span></span>
                    <span id="spanMobile" runat="server"></span>
                    <span id="spanEmail" runat="server"></span>
                </div>
              </div>
              <div class="progress" style="margin:0px;">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">
      
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div class="row">
                                          <div class="col-md-8">
                                              <div id="divData">
                                                
                                                <div class="row">
                                                    <div class="col-sm-12">

                                                        <div id="videoContainer">
                                                            <video id="video" autoplay></video>
                                                            <div id="captureBox"></div>
                                                        </div>
                                                        <canvas id="canvas" style="display: none;"></canvas>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm-12">
                                                        <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                                                            <ContentTemplate>
                                                                <div style="display:none">
                                                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                                                </div>
                                                                <div id="divContinueNext"  runat="server">
                                                                    <button id="captureBtn" class="btn btn-lg btn-primary" onclick="CapturedPhoto();"><i class="fa fa-camera" aria-hidden="true"></i> Capture my Photo</button>
                                                                    <a class="btn btn-lg btn-danger pull-right" href="javascript:sendCapturedlink('Send');" >
                                                                        I Don't have a Camera
                                                                    </a>
                                                                    <br />
                                                                    <br />
                                                                    <span style="font-size:smaller;">
                                                                        If you do not have a camera on this device, there is no need to worry. Just click on the
                                                                        "I Don't have a Camera" button and I will send you a link on your phone using WhatsApp, SMS and
                                                                        even eMail. Just click the link on your phone and I will use your phone's camera to capture
                                                                        your pic. Make sure to have a live Internet connection on your phone.
                                                                    </span>
                                                                </div>
                                                                <div id="divContinueIfDone" style="display:none">
                                                                    <a class="btn btn-success btn-lg" id="btnContinueIfDone" onclick="sendCapturedlink('Done');" style="margin-top:5px"><i class="fa fa-check" aria-hidden="true"></i> Continue</a>
                                                                </div>

                                                                <div id="divCapturedPhoto" runat="server" style="display:none">
                                                                    <h3>Your captured photo</h3>
                                                                    <div class="row">
                                                                        <div class="col-md-4">
                                                                            <img id="capturedImage" name="capturedImage" class="img-responsive" src="" alt="Captured Image" runat="server">
                                                                        </div>
                                                                        <div class="col-md-8">
                                                                             <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4">
                                                                                <div class="alert alert-warning">
                                                                                    <strong>Here is your captured photo. Please make sure: </strong><br /><br />
                                                                                    <span id="span1" runat="server">
                                                                                       The Captured Picture shows both edges of your face clearly;
                                                                                       the eyes are open, level and clearly visible; and are not covered by hair or eyeglass frames. 
                                                                                       Remember that your face should match with your picture on the Aadhaar Card.
                                                                                    </span>
                                                                                </div>
                                                                            </div>
                                                                              <div style="padding-left:10px;" id="divSaveButtons" runat="server">
                                                                                <button type="button" class="btn btn-primary btn-lg" id="btnSaveOnly" onclick="saveData('SaveOnly');" runat="server" style="margin-top:5px;display:none" ><i class="fa fa-file-import" aria-hidden="true"></i> Save this Photo</button> 
                                                                                <button type="button" class="btn btn-success btn-lg" id="btnSaveContinue" onclick="saveData('Save');" runat="server" style="margin-top:5px" ><i class="fa fa-check" aria-hidden="true"></i> Accept & Continue</button> 
                                                                                <button id="reCaptureBtn" class="btn btn-lg  btn-warning" onclick="ReCapturedPhoto();" style="margin-top:5px"><i class="fa fa-camera" aria-hidden="true"></i> Capture again</button>
                                                                                <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                                                                </div>
                                                                        </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                
                                                               <div style="display:none">
                                                                <input type="hidden" id="hdnImage" name="hdnImage" runat="server" value="">
                                                                 <input type="hidden" id="hdnActualWidth" name="hdnActualWidth" runat="server" value="">
                                                                 <input type="hidden" id="hdnActualHeight" name="hdnActualHeight" runat="server" value="">
                                                                 <input type="hidden" id="hdnActualAspectRatio" name="hdnActualAspectRatio" runat="server" value="">
                                                                 <input type="hidden" id="hdnCaptureBoxWidth" name="hdnCaptureBoxWidth" runat="server" value="">
                                                                </div>
                                                         </ContentTemplate>
                                                    </asp:UpdatePanel>
                                                    </div>
                                                </div>
                                            </div>
                                              <hr />
                                          </div>
                                          <div class="col-md-4">
                                              <div class="row">
                                                  <div class="col-xs-6">
                                                      <center>
                                                      <img id="ImgAadhaar" width="160" height="200" src="" alt="Aadhaar Photo" runat="server">
                                                      <br />
                                                      <span>Image from Aadhaar</span>
                                                       </center>
                                                  </div>
                                                  <div class="col-xs-6">
                                                      <center>
                                                      <img id="ImgLivePhotoCaptured" width="160" height="200" src="" alt="Aadhaar Photo" runat="server">
                                                      <br />
                                                      <span>Live Capture</span>
                                                       </center>
                                                  </div>
                                              </div>
                                              <br />
                                              <%--<h2 id="hFullName" runat="server"></h2>
                                              <p>
                                              Date of Birth : <u><span id="spanDOB" runat="server"></span></u>
                                              <br />
                                              Mobile : <u><span id="spanMobile" runat="server"></span></u>
                                              <br />
                                              Email : <u><span id="spanEmail" runat="server"></span></u>
                                              <br />
                                              Gender : <u><span id="spanGender" runat="server"></span></u>
                                              <br />
                                              Nationality : <u><span id="spanNationality" runat="server"></span></u>
                                              <br />
                                              <br />
                                              Permanent Address : <u><span id="spanPermanentAddress" runat="server"></span></u>
                                              <br />
                                              Correspondence Address : <u><span id="spanCorrespondenceAddress" runat="server"></span></u>
                                             </p>--%>
                                             <br />
                                             <p style="display:none">
                                                 <span id="spanBrokerName" runat="server" style="display:none;">Standard Broker</span> 
                                                 <span id="spanPAN" runat="server"></span>
                                             </p>
                                             <div style="padding:20px;border-radius: 8px;box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);">
                                                  <center>
                                                  <b>Please make sure of the following while we take your live-picture:</b>
                                                  </center>
                                                 <br />
                                                  <ol>
                                                      <li>Take off your glasses if you have them</li>
                                                      <li>Be in front of the camera <i>in person</i> and look straight at the camera</li>
                                                      <li>Do not wear a hat</li>
                                                      <li>You should be the only person captured</li>
                                                      <li>Ensure that the picture is clear and your eyes are open</li>
                                                      <li>Do not smile, please</li>
                                                  </ol>
                                             </div>

                                          </div>
                                      </div>

                                       <h4>Go to previous step </h4> 
                                             <ul class="list-inline">
                                                <li><a href="PANVerification.aspx"><i class="fa fa-id-card" aria-hidden="true"></i> PAN Verification</a></li>
                                                <li><a href="selectSegments.aspx"><i class="fa fa-exchange" aria-hidden="true"></i> Segments</a></li>
                                                <li><a href="aadhaarKYC.aspx"><i class="fa fa-user" aria-hidden="true"></i> Aadhaar Data</a></li>
                                            </ul>

                                  </div>
                              </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
                
            </div>


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
                      <br />
                      <br />
			    </div>
                
             </div>

          </div>
        </section>
    </form>

</body>
</html>
