/// <reference path="VideoHelp.html" />
/// <reference path="VideoHelp.html" />
var isIE = (document.all) ? 1 : 0;
var isNS4 = (document.layers) ? 1 : 0;
var isNS6 = ((document.getElementById) && (navigator.appName == 'Netscape')) ? 1 : 0;
var isNS = ((isNS4) || (isNS6)) ? 1 : 0;
var DHTML = (isIE || isNS4 || isNS6) ? 1 : 0;

// --------------------------------------------------------------------------------//
// Every AJAX call to the server sends a formatted XML to the server. The server in
//  turns returns another formatted XML. The returned XML could contain a lot of things
//  see "ssAjaxResponse" object. The returned XML is parsed and acted accordingly. For
//  instance, the returned XML could have pure Javascript code which is executed at the
//  server. The __lcXML variable below is the formatted XML that is sent to the server
// --------------------------------------------------------------------------------//
var __requestXML = "<ssajax>\r\n" +
	"	<sql></sql>\r\n" +
	"	<functionname></functionname>\r\n" +
	"	<functionparameters></functionparameters>\r\n" +
	"	<functionparamcount></functionparamcount>\r\n" +
	"	<sqlcursor></sqlcursor>\r\n" +
	"	<noschema>1</noschema>\r\n" +
	"	<utf8>1</utf8>\r\n" +
	"</ssajax>"

// -----------------------------------------------------------------------//
// Rev 12.12.2009 [Abs] - A very interesting concept is demonstrated below.
// This started with the problem that the JQUERY.JS engine also had a $ function
// like SSAJAX.JS. The functions actually behaved differently.
// The solution was introduced as below :
// 1. The $ function was made a property called $ of the
//    global ssajax object.
// 2. A Global variable called ssSjax was created.
// 3. The $ property in ssSjax was assigned the function "$".
//
// So now we can use the $ function in ssSjax by calling
// ssAjax.$ instead of simply $.
var ssajax = new ssajaxobject();

function ssajaxobject() {

	//this.GetName = GetName;    // Assign the GetName function to the GetName property


	//--------------------------------------------------------------------------------*
	//This small-little function returns the control whose ID is passed as a parameter.
	//--------------------------------------------------------------------------------*
	// Rev 12.12.2009 [Abs] - The function was renamed to _$ because another function
	// in JQUERY [included in WConnect] also has a similar function.
	this.$ = function (ElementId) {
		var oRetObject;
		oRetObject = document.getElementById(ElementId);

		// Debug Code
		if(oRetObject == null) {
			alert(ElementId + " is not found on the page !");
		}

		return oRetObject;
	}
	//--------------------------------------------------------------------------------*


	// --------------------------------------------------------------------------------*
	// This function hits 'cFunctionName' on the server, passing it the value of 'cParamValue' and
	// replacing the resultant text in the 'cLabelObject'.
	// --------------------------------------------------------------------------------*
	this.GetName = function (cfunctionname, clabelobject, cparam1, cparam2, cparam3, cparam4, cparam5, cparam6) {

		// We fire the AjaxFunction to get the returned text.
		creturntext = this.FireFunction(cfunctionname, cparam1, cparam2, cparam3, cparam4, cparam5, cparam6);

		// Now we set the clabelobjects innerhtml to the returned text
		if(typeof (creturntext) == "boolean" || creturntext == "") {
			//alert("Entered code not found !");
			ssajax.$(clabelobject).innerHTML = "<b>Not found!</b>";
		} else {
			ssajax.$(clabelobject).innerHTML = "<b>" + creturntext + "</b>";
		}

		return true;
	}
	// -----------------------------------------------------------------------------------

	//-------------------------------------------------------------------------*
	// This function fires any server function and returns the returned text.
	//-------------------------------------------------------------------------*
	this.FireFunction = function (cfunctionname, cparam1, cparam2, cparam3, cparam4, cparam5, cparam6) {

		var cParameters = '';
		var nParamcount = 0;
		for(var x = 1; x < arguments.length ; x++) {
			if(arguments[x] == null) {
				break;
			}

			nParamcount += 1;
			if(nParamcount > 1)
				cParameters = cParameters + ",";
			cParameters = cParameters + EncodeValue(arguments[x].toString());
		}

		// We fetch the XMLHttp Object.
		var oxmlrequest = getxmlhttp();

		// Now we set the properties of the XML so that we can send it to the server.
		setsinglenode(oxmlrequest, "functionname", cfunctionname);
		setsinglenode(oxmlrequest, "functionparameters", cParameters);
		setsinglenode(oxmlrequest, "functionparamcount", nParamcount);

		// Our xmlHttpRequest object is ready for delivery to the server. We process the oxmlrequest.
		// The returned text will be the text of the function [ex:Clientname,etc.]
		creturntext = sendajax(oxmlrequest);

		return creturntext;
	}

}

//-------------------------------------------------------------------------------------------------//
// This method fires a standalone function on the server and uses the QueryString as a part of the
// url to send data to the function. The called function must return an XML which will be handled
// by the function. Such functions on the Server are usually written specifically for the Web.
// Ex: 
//-------------------------------------------------------------------------------------------------//
function FireAjaxFunction(cfunctionname, cQueryString) {

	// We fetch the XMLHttp Object.
	var oxmlrequest = getxmlhttp();

	// Now we set the properties of the XML so that we can send it to the server.
	setsinglenode(oxmlrequest, "functionname", cfunctionname);

	// Our xmlHttpRequest object is ready for delivery to the server. We process the oxmlrequest.
	// The returned text will be the text of the function [ex:Clientname,etc.]
	creturntext = sendajax(oxmlrequest, cQueryString);

	return true;
}

// --------------------------------------------------------------------------------//
// This function returns the XMLHttp Object, loaded with the __requestXML. This XMLHTTP object
// is sent to the server's [ajaxCallback] method.
//
// Rev 7.6.2014 [Abs] - I found out that ActiveXObject was a functionality of only
//  IE. In other words, a number of functions didnt actually work in other browsers.
//  I made an attempt to convert the code to cross-browser by using JQuery instead.
// --------------------------------------------------------------------------------//
function getxmlhttp() {

	// Rev 7.6.2014 [Abs] - See notes. Lines suppressed.
	// var oXML = new ActiveXObject("Microsoft.XMLDom");
	// oXML.async = false;
	// oXML.loadXML(__requestXML);
	// return oXML;

	// Rev 7.6.2014 [Abs] - See notes above.
	var xmlDocument = $.parseXML(__requestXML);

	return xmlDocument;

}
// --------------------------------------------------------------------------------//
// This function sets the value of a single node in the oXML object. 
// --------------------------------------------------------------------------------//
function setsinglenode(oxmlrequest, cnodename, cvalue) {
	// Rev 7.6.2014 [Abs] - We now use CrossBrowse JQuery Syntax to do Ajax work.
	//oxmlrequest.selectSingleNode("/ssajax/" + cnodename ).text = cvalue;
	$(oxmlrequest).find(cnodename).text(cvalue);
	return;
}

// --------------------------------------------------------------------------------//
// This function actually sends the XMLHttp object to the server. The server then
// processes it and returns another XML which we shall process and act accordingly.
//
// Rev 7.6.2014 [Abs] - This function didnt work on chrome because "ActiveXObject" call
//  is a purely IE call. So, I used the JQuery method instead to make an Ajax Call and
//  handle the result.
// --------------------------------------------------------------------------------//
function sendajax(oxmlrequest, cquerystring) {

	if(cquerystring == null) {
		cquerystring = "";
	} else {
		cquerystring = "?" + cquerystring;
	}

	// Rev 7.6.14 [Abs] - See notes above. Lines suppressed and rewritten for JQuery
	//// We create the AJAX object
	//var httpOb = new ActiveXObject("MSXML2.XMLHTTP");
	// We set the parameters. Note that we hit the AjaxCallBack function on the server.
	//httpOb.open("POST","AjaxCallBack.ss" + cquerystring , false); 
	// *** And POST an XML string to the server 
	//httpOb.send(oxmlrequest);
	//return handlecallback(httpOb.responseText);

	var creturnText;
	try {
		$.ajax("AjaxCallBack.ss" + cquerystring,
            {
            	async: false,
            	type: "POST",
            	contentType: "text/xml",
            	processData: false,
            	data: oxmlrequest,
            	success: function (data, textStatus, jqXHR) {
            		// We handle the callback and set whatever it returns to the 
            		// returnText variable
            		//alert(data);
            		creturnText = handlecallback(data);
            	}
            });
	} catch(err) {
		alert("ssAjax.js/nError occurred in sendAjax(): " + err);
	}

	return creturnText;

}


// This function takes all the form variables and sends them back to the passed url. 
// Usually, the calling method should set the value of txtEventAction. When this happens
// an Event on the Server's calling PRG is fired. This Event should return a 
// ssAjaxResponseXML object. The HandleCallBack function then handles the returned xml.
function sendajaxform(curl, lasync) {

	// Handle whether the lasync parameter is passed at all
	if(lasync == null) {
		lasync = false;
	}

	// We create the AJAX object
	var httpOb = new ActiveXObject("MSXML2.XMLHTTP");

	if(lasync == true) {
		//httpOb.onreadystatechange = handlecallback;
		httpOb.onreadystatechange = function () {
			if(httpOb.readyState == 4) {
				handlecallback(httpOb.responseText);
			}
		}
	}

	// We tweak the Query String so that we also send a value called AJAXCALLBACK=Yes along
	// with the sent request. The called routine can then check whether this is a Ajax Callback
	// or simply an event processing [like command click, checkbox valid,etc., of a child form].
	//        if (curl.indexOf('?') > -1)
	//            curl = curl + "&" + "__AJAXCALLBACK=yes"
	//        else
	//            curl =  curl + '?' + "__AJAXCALLBACK=yes";   


	httpOb.open('POST', curl, lasync);
	httpOb.setRequestHeader('Pragma', 'no-cache');
	httpOb.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');

	var PostBuffer = EncodeFormVars();

	// We also add to the PostBuffer a parameter called AjaxCallBack=Yes telling the
	// calling function that this is an AjaxCallBack.
	PostBuffer = PostBuffer + "&AjaxCallBack=yes";

	httpOb.setRequestHeader('Content-length', PostBuffer.length.toString());
	httpOb.send(PostBuffer);

	// if this was an asyncronous call, we return. When the ready state will change, handlecallback
	// function will be fired automatically as it has been set in the onreadystatechange event.
	if(lasync == true) {
		return;
	}

	return handlecallback(httpOb.responseText);

}

// ------------------------------------------------------------------------------------------------*
// This function actually takes the returned XML from the server, parses it, and acts accordingly.
// ------------------------------------------------------------------------------------------------*
function handlecallback(creturnedxml) {

	// This could be an asynchronous handling, which means that cxml is not passed.
	if(creturnedxml == null) {
		if(httpOb.readyState != 4)
			return;
	}

	// We pickup the XML returned by the server.	
	// Rev 7.6.2014 [Abs] - Code changed for cross browser compatibility. ActiveXObject is a purely IE
	//  and microsoft tech. Need to use JQuery.
	// oxml = new ActiveXObject("Microsoft.XMLDom");
	oxml = $.parseXML(creturnedxml);

	// Rev 7.6.2014 [Abs] - Lines suppressed.
	//oxml.loadXML( creturnedxml );
	//if (oxml.parseError.errorCode != 0) {
	//   alert(oxml.parseError.reason + "\r\n" + oxml.parseError.srcText + "\r\n")
	//   return null;
	//}   

	//---------------------------------------------------------------------------------------//
	// The returned XML has been successfully parsed. Now we go ahead and find it's elements.
	//---------------------------------------------------------------------------------------//

	// Rev 7.6.2014 [Abs] - Cross Browser code added.  
	//cnewwindowurl = oxml.getElementsByTagName("cnewwindowurl").item(0).text;
	//nwindowwidth  = oxml.getElementsByTagName("nwindowwidth").item(0).text;
	//nwindowheight = oxml.getElementsByTagName("nwindowheight").item(0).text;
	//cwindowtitle = oxml.getElementsByTagName("cwindowtitle").item(0).text;
	//cnewwindowhtml = oxml.getElementsByTagName("cnewwindowhtml").item(0).text;
	//chtml = oxml.getElementsByTagName("chtml").item(0).text;
	//credirecturl = oxml.getElementsByTagName("credirecturl").item(0).text;
	//cjavascript = oxml.getElementsByTagName("cjavascript").item(0).text;
	//cerrortext = oxml.getElementsByTagName("cerrortext").item(0).text;
	//creturntext = oxml.getElementsByTagName("creturntext").item(0).text;
	cnewwindowurl = $(oxml).find("cnewwindowurl").text();
	nwindowwidth = $(oxml).find("nwindowwidth").text();
	nwindowheight = $(oxml).find("nwindowheight").text();
	cwindowtitle = $(oxml).find("cwindowtitle").text();
	cnewwindowhtml = $(oxml).find("cnewwindowhtml").text();
	chtml = $(oxml).find("chtml").text();
	credirecturl = $(oxml).find("credirecturl").text();
	cjavascript = $(oxml).find("cjavascript").text();
	cerrortext = $(oxml).find("cerrortext").text();
	creturntext = $(oxml).find("creturntext").text();

	if(cnewwindowurl != "") {
		// We also need to find the Window Height and Width
		newWindow = OpenBrowserWindow(cnewwindowurl, "", "", nwindowwidth, nwindowheight, true);
		newwindow.title = cwindowtitle;
	}

	// The calling function can also send a full fleged HTML instead of a URL. Has that been
	// sent?
	if(cnewwindowhtml != "") {
		//cnewwindowhtml=unescape(cnewwindowhtml);
		var newWindow = OpenBrowserWindow("about:blank", "", "", nwindowwidth, nwindowheight, true);
		// Note that simply putting innerHTML does not load any JS files,etc.
		// This is why open/close are used.
		// ******* The following line sometimes gives "unspecified error"
		// newWindow.document.title=cwindowtitle;
		newWindow.document.close();
		newWindow.document.open();
		newWindow.document.write(cnewwindowhtml);
		newWindow.document.close();
		// We make sure all the scrips are loaded by issuing reload. [For instance, the Calendar
		// control does not work in the newly opened window unless we reload].
		newWindow.location.reload()
	}

	// Has the callback function returned any HTML Code. If yes, it should replace the code
	// in the browser.
	if(chtml != "") {
		// We need to replace the existing HTML with the new HTML
		Window.document.close();
		Window.document.open();
		//Window.document.write(chtml);
		Window.document.write("Abhay");
		Window.document.close();
	}

	// Has the returned response sent any credirecturl?
	if(credirecturl != "") {
		window.location.replace(credirecturl)
	}

	// JavaScript Code ---------* 
	// Note that the JavaScript is executed at the end allowing it to manipulate the newly opened
	// window if required.
	if(cjavascript != "") {
		try {
			eval(cjavascript);
		}
		catch(err) {
			txt = "There was an error on this page.\n\n"
			txt += "Error description: " + err.description + "\n\n"
			txt += "Error message    : " + err.message + "\n\n"
			txt += "javascript code :\n" + cjavascript
			txt += "Click OK to continue.\n\n"
			alert(txt)

		}
	}

	// Has the called function returned any cerrortext
	if(cerrortext != "") {
		alert(cerrortext)
		// return null;
	}

	// Returned Text -----------* The returned XML could return a text. Example : ClientName,etc.,
	// which we return to the calling function.	
	if(creturntext != "") {
		return creturntext;
	}

	return true;
}

//--------------------------------------------------------------------------------*
// Kaka's Code --------------------------------------------------------------------*
// This function scans through the form on the page, collects the entered data and
// returns the encoded value of the variables to be posted back to the server.
function EncodeFormVars() {
	var PostData = '';

	Form = document.forms[0];
	var count = Form.length;
	var element;

	for(var i = 0; i < count; i++) {
		element = Form.elements[i];
		var tagName = element.tagName.toLowerCase();

		if(tagName == 'input') {
			var type = element.type;
			if(type == 'text' || type == 'hidden' || type == 'password' ||
               ((type == 'checkbox' || type == 'radio') && element.checked))
				PostData += element.name + '=' + EncodeValue(element.value) + '&';
		}
		else if(tagName == 'select') {
			if(element.options == null)
				continue;
			var selectCount = element.options.length;
			for(var j = 0; j < selectCount; j++) {
				var selectChild = element.options[j];
				if(selectChild.selected)
					PostData += element.name + '=' + EncodeValue(selectChild.text) + '&';
			}
		}
		else if(tagName == 'textarea')
			PostData += element.name + '=' + EncodeValue(element.value) + '&';
	}

	// alert(PostData);

	return PostData;
}
function EncodeValue(parameter) {
	if(encodeURIComponent)
		return encodeURIComponent(parameter);
	return escape(parameter);
}

//--------------------------------------------------------------------------------*
// This function by Rick opens a new Browser window.
// I changed the function so that the routine returned the window back to the calling function.
//--------------------------------------------------------------------------------*
function OpenBrowserWindow(URL, winName, features, Width, Height, isCenter) {
	if(window.screen)
		if(isCenter) {
			var myLeft = (screen.width - Width) / 2;
			var myTop = (screen.height - Height) / 2;
			features += (features != '') ? ',' : '';
			features += 'left=' + myLeft + ',top=' + myTop;
		}

	var cfeatures = features + ((features != '') ? ',' : '') + 'width=' + Width + ',height=' + Height;
	//var w=open(URL,winName,cfeatures);
	var w = window.open(URL, 'winName', cfeatures);
	//w.focus();

	//var w=window.open(URL);

	return w;
}

//--------------------------------------------------------------------------------*
function simplealert(cmess) {
	alert(cmess);
}

//--------------------------------------------------------------------------------*
// XML functions.
// These functions work on the Grid's ActiveX control [ListView] and also on the
// Grid's Data Island.
// The XML DataIsland has to be in the EBA format.
//--------------------------------------------------------------------------------*

// Updates the contents of the hidden "input" field with the value of the xml.
// Usually fired automatically from the "ondatasetcomplete" event of the xml data island.
// Whenever the data in the xml is changed using loadXML method, this event is fired
// automatically.
// In case of tables, the DataSrc XML [the one used as the source of the table] and the submitted
// XML [the one set in the hidden textbox] are separate. We use this method to also update the
// filtered XMl [dataSrc] using XSLT transformations to filter out any XK value having "DEL"
// specified.
function updatetxtwithxml(oxml, ctxtname, cgrid) {
	//alert(oxml.xml);
	ssajax.$(ctxtname).value = oxml.xml;

	// If this is a table, we also update the <<objname>>_filtered XML with data containing
	// the same XML WITHOUT the xk='DEL' values.
	ogrid = ssajax.$(cgrid);
	if(ogrid.rendertype != "table") return;

	// This is a table
	cxsl =
	    '<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">' +
	    '<xsl:output method="xml"/>' +
	    '<xsl:template match="/root">' +
	    '<root>' +
	    '<xsl:for-each select="e[not(starts-with(@xk,\'DEL\'))]" >' +
		    '<xsl:for-each select="." > ' +
			    '<e>' +
			    '<xsl:for-each select="@*" >' +
				    '<xsl:attribute name=\'{name()}\'>' +
					    '<xsl:value-of select="."/>' +
				    '</xsl:attribute>' +
			    '</xsl:for-each>' +
			    '</e>' +
		    '</xsl:for-each>' +
    '</xsl:for-each>' +
    '</root>' +
    '</xsl:template>' +
    '<xsl:template match="data">' +
    '<data>' +
	    '<xsl:apply-templates/>' +
    '</data>' +
    '</xsl:template>' +
    '</xsl:stylesheet>';

	// Now we use the above xsl definition to transform [i.e. Filter] the _data xml for
	// _filtered xml.
	var oxml2 = getxmlhttp();
	oxml2.async = false;
	oxml2.loadXML(cxsl);
	cfilteredxml = oxml.transformNode(oxml2)

	// The xml has been transformed, now we update the _resource XML so that the table
	// shows records NOT having the xk="DEL"
	otablexml = ssajax.$(cgrid + "_filtered");
	otablexml.loadXML(cfilteredxml);
}

// Adds a column to the passed Grid ActiveX object
function addcolumntogrid(cgrid, lcText, lnWidth, lnAlign) {
	// We get the Grid object
	var ogrid = ssajax.$(cgrid);
	var ncolumns = ogrid.ColumnHeaders.count + 1;
	onewcolumn = ogrid.ColumnHeaders.Add(ncolumns, "column" + ncolumns, lcText, lnWidth, lnAlign);
}

// Adds a complete row to the grid based on the passed texts.
function addrowtogrid(cgrid, cxkvalue, oxml, cparam1, cparam2, cparam3, cparam4, cparam5, cparam6, cparam7, cparam8, cparam9, cparam10, cparam11, cparam12, cparam13, cparam14) {

	// We will update the XML only if the oxml object has been passed at all. The same function
	// could be fired from populategridfromxml function also.
	if(typeof (oxml) != "boolean") {
		// oxml object has been passed. We need to add a new element to it.
		onew = oxml.createElement("e");
		// Now we set the attributes to the new element.
		onew.setAttribute("xk", cxkvalue);
		// Now we set the attributes for the actual data. i.e., "a","b",....
		for(var attr = 1; attr <= arguments.length - 3; attr++) {
			cattribute = String.fromCharCode(96 + attr);  // "a","b",etc...
			onew.setAttribute(cattribute, eval("cparam" + attr));
		}
		// The new element is ready to be added to the XMl.
		oxml.documentElement.appendChild(onew);
		// We refresh the oxml so that the textbox is populated.
		oxml.loadXML(oxml.xml);
	}

	// We get the grid object
	var ogrid = ssajax.$(cgrid);

	// If the grid is rendered as a table, we need not try to update any listview on the page.
	if(ogrid.rendertype == "table") return;

	var oitems = ssajax.$(cgrid).listitems;
	// Now we add all the items to the grid. Note that while adding row to the Grid, we use
	// column header count because that is the visible portion of the data. Additional parameters
	// could simply be hidden data.
	for(var x = 1; x <= ogrid.ColumnHeaders.count ; x++) {
		if(x == 1) {
			var orow = oitems.add(oitems.count + 1, cxkvalue, eval("cparam" + x));
		} else {
			orow.SubItems(x - 1) = eval("cparam" + x);
		}
	}
	// Now we make the new ListItem the selected one.
	ogrid.selectedItem = orow;
}

//-----------------------------------------------------------------------------------------------------/
// Updates and already existing record in the grid with new data. It updates the Grid and also updates
// the oXml.
//-----------------------------------------------------------------------------------------------------/
function updaterowingrid(cgrid, cxkvalue, oxml, cparam1, cparam2, cparam3, cparam4, cparam5, cparam6, cparam7, cparam8, cparam9, cparam10, cparam11, cparam12, cparam13, cparam14) {

	// First we need to update the XML.
	onode = findnode(oxml, cxkvalue);
	// If we could not find the node, we should ignore the rest of the
	// code
	if(onode == null) return;
	// Now we go ahead and update the row in the xml.Note that the data in the XML of the
	// node is stored in the a,b,c... attributes.
	for(var attr = 1; attr <= onode.attributes.length - 1; attr++) {
		cattribute = String.fromCharCode(96 + attr);  // "a","b",etc...
		var lctext = eval("cparam" + attr);
		onode.attributes(attr).text = lctext;
	}
	// We have changed the xml, now we refresh it so that the textbox is updated.
	oxml.loadXML(oxml.xml);

	// If the grid is rendered as a table, we need not try to update any listview control
	// on the web-page.
	ogrid = ssajax.$(cgrid);
	if(ogrid.rendertype == "table") return;

	// We get the grid object's ListItem that needs to be updated.
	var oitem = ssajax.$(cgrid).listitems.item(cxkvalue);

	// Now we update the ListItem with the new values.
	for(var x = 1; x <= ogrid.ColumnHeaders.count ; x++) {
		var lctext = eval("cparam" + x);
		if(x == 1) {
			oitem.text = lctext;
		} else {
			oitem.SubItems(x - 1) = lctext;
		}
	}
}


// This function removes the record identified by it's xkValue [Eba], and also updates the
// XML of the grid accordingly.
// The XML is updated only when it is passed as a parameter.
function deleterowfromgrid(cgrid, xkvalue, oxml) {

	// We get a reference to the Grid.
	ogrid = ssajax.$(cgrid);
	if(ogrid.rendertype == "table") {
		// The grid on the web page has been rendered as a table.
		// We will have to determine the node to be deleted and also the XkValue.
		xkvalue = ogrid.currentxkvalue;
		odeletenode = findnode(oxml, xkvalue);
		// We reset the current record to -1 to deselect any selected row.
		ogrid.currentrecord = -1;
	} else {
		// First we need to successfully remove the Node from the XML and update the
		// xml.
		odeletenode = findnode(oxml, xkvalue);
	}

	// If we could not find the node, we should ignore the rest of the
	// code
	if(odeletenode == null) return;

	// Note that instead of deleting the row from the XML, we update it's XK value with 
	// "DEL". However, in case if the XK is NEW (which means that the record was newly added
	// anyway) we remove it from the XML altogether.
	//  *!* Now we go ahead and delete the row from the xml.
	//  *!* oxml.documentElement.removeChild(odeletenode);
	if(xkvalue.indexOf("NEW") >= 0) {
		// This was a newly added row anyway. So, we delete it.
		oxml.documentElement.removeChild(odeletenode);
	} else {
		// This record is an already existing record in the table. Instead of actually
		// deleteing the row, we update it's XK value with DEL. This is done to ensure that
		// the server is able to actually delete THIS record without having to delete all
		// and then repopulate the table [which could lead to disasterous results].
		var coldxkvalue = odeletenode.getAttribute("xk");
		var cnewxkvalue = xkvalue.replace(/OLD/, "DEL");
		odeletenode.setAttribute("xk", cnewxkvalue)
	}

	// We refresh the XML so that it is posted into the textbox by the
	// ondatasetcomplete event of the xml.
	oxml.loadXML(oxml.xml);

	// If the grid is rendered as a table, updating the xml is enough.
	if(ogrid.rendertype == "table") return;

	// The grid is rendered as an ActiveX. We need to remove the item from the listview.
	// We identify the grid object.
	oItems = ssajax.$(cgrid).ListItems;
	// Now we remove the row from the Grid.
	oItems.Remove(xkvalue);
}

//-----------------------------------------------------------------------//
// finds a Node in the document root on the basis of the passed XK value
//-----------------------------------------------------------------------//
function findnode(oxml, xkvalue) {
	var oReturnNode = null
	for(nodenum = 0; nodenum < oxml.documentElement.childNodes.length; nodenum++) {
		onode = oxml.documentElement.childNodes(nodenum);
		if(onode.getAttribute("xk") == xkvalue)
			oReturnNode = onode;
	}
	return oReturnNode;
}


// This function updates a ActiveX grid with the passed XML. Note that the XML has to
// be in EBA format. Moreover, the hidden elements of the Grid should be in the last portion
// of the GCF file.
function populategridfromxml(cgrid, oxml) {

	// The calling routine could send a oxml object OR a oxml STRING containing the XMl.
	// if it sends a string, the routine should get the corresponding oxml object and
	// also update it while inserting the new records.
	var updatexmlobject = false;
	if(typeof (oxml) == "string") {

		// The calling routine has sent a XML string instead of a pointer to an xml
		// object. We need to load the xml.
		var cxml = oxml;
		var oxml = new ActiveXObject("Microsoft.XMLDom");
		oxml.async = false;
		oxml.loadXML(cxml);
		// We should also load the send xml string into the XML for the grid.
		var ogridxml = eval(cgrid + "_data");
		ogridxml.loadXML(cxml);
	}


	// We iterate through each of the "e" elements of the xml and populate the
	// grid with the "a","b".... attribute values. Note that since we populate only
	// the visible columns of the Grid, the invisible data which is in the last portion 
	// of the gcf file is ignored.
	// We iterate through all the "e" records in the XML.

	ogrid = ssajax.$(cgrid);

	// The ogrid object here could be a ListView Activex control or a Table depending on the
	// renderType property of the Grid. if the grid is a Table, we need not run through the
	// rest of the code to add items because simply loading the XML populates the Table.
	if(ogrid.rendertype == "table") return;

	// Before adding records to the Grid, we need to remove all the listItems of the grid.
	ogrid.listItems.clear();

	for(var nrecords = 1; nrecords <= oxml.documentElement.selectNodes("e").length; nrecords++) {

		// The basic idea is to create a javascript code that will call the addrowtogrid method.
		// The first parameter is the name of the grid, and the second is the KEY for the
		// row to be added. We use the EBA "_recordnumber" format.

		// We pickup the row
		orow = oxml.documentElement.selectNodes("e").item(nrecords - 1);

		// We also pickup the XK value from the node.
		// Since we do not want the XML to be updated (because we are using the already existing
		// xml to update the grid anyway, we pass the 3rd parameter as false).
		var cxkvalue = orow.getAttribute("xk");
		var caddrowcode = "addrowtogrid('" + ogrid.id + "','" + cxkvalue + "',false";

		// Now we iterate through each of the fields in the record.
		for(var nc = 1; nc <= ogrid.columnHeaders.count; nc++) {
			cattribute = String.fromCharCode(96 + nc);  // "a","b",etc...
			cvalue = orow.getAttribute(cattribute);
			caddrowcode += ",'" + cvalue + "'";
		}
		caddrowcode += ")";
		// Now we execute the code to add the row to the grid.
		eval(caddrowcode);
	}
}


function testfunction() {
	alert('test function is fired!');
}

function removechars(s) {
	var returnstring = s.replace(/&amp;/ig, "");
	returnstring = s.replace(/&lt;/ig, ">");
	return returnstring;
}

// -------------------------------------------------------------//
// EBA Combobox Helper functions
// -------------------------------------------------------------//
// This function gets/sets the value of a Eba Combobox text.
function ebacombo(cid, cnewvalue) {
	if(cnewvalue == null) {
		// The calling functions wants to GET the value
		var cval = document.getElementById(cid).object.GetTextValue();
		return cval;
	} else {
		// The calling function wants to SET the value
		document.getElementById(cid).object.SetTextValue(cnewvalue);
	}
}

// this Function enables/disables an EBA Combobox.
// By default, it enables the combo, but if lenable=false, it disables the combo.
function ebaenable(cid, lenable) {

	if(lenable == null) lenable = true;
	// Now we identify the combo.
	var ocombo;
	ocombo = ssajax.$(cid).object;
	// Now we enable/disable the combo.
	ocombo.SetEnabled(lenable);
}

// -----------------------------------------------------------------------------------//
// This function loads the passed xml string into all the elements of a form. Usually the data on a form
// on the server is placed into a xml by genformxml method of sh_form and then returned to this
// method which loads the form.
// -----------------------------------------------------------------------------------* 
function loadxmlintoform(cform, cxml) {

	// First we load the xml string and create an xml object.
	var oxml = new ActiveXObject("Microsoft.XMLDom");
	oxml.async = false;
	oxml.loadXML(cxml);
	if(oxml.parseError.errorCode != 0) {
		// The xml could not be parsed. We show the error.
		alert("The returned XML could not be parsed " + chr(10) + "Reason: " + oxml.parseError.reason + CHR(10) + "Source : " + oxml.parseError.srcText);
		return;
	}

	// Now we read all the child elements of the Top level element and change the
	// values of the controls in the form.
	for(var nchild = 0; nchild <= oxml.documentElement.childNodes.length - 1 ; nchild++) {
		cnodename = oxml.documentElement.childNodes(nchild).nodeName;
		cnodevalue = oxml.documentElement.childNodes(nchild).text;

		// Does the node contain an xml string? If it does, it must be the data of a grid object
		// and the xml needs to be loaded.
		onode = oxml.documentElement.childNodes(nchild);
		if(onode.hasChildNodes && onode.firstChild.hasChildNodes) {
			cnodexml = oxml.documentElement.childNodes(nchild).firstChild.xml;
			// this is an xml string
			ogrid = ssajax.$(cnodename);
			//ogrid.listItems.clear();
			// We load the xml into the XML-island of the Grid.
			ogridxml = eval(cnodename + "_data");

			ogridxml.loadXML(cnodexml);

			// We fire the populategridfromxml method in ssAjax.js file.
			populategridfromxml(cnodename, ogridxml);
		} else {
			// This is a simple text value. We load it into the the control identified by the nodename.
			try {

				// Rev 13.8.2009 [Abs] - IN case the control is a checkbox, we need to change the
				// checked property and not the value.
				if(document.getElementById(cnodename).type == "checkbox") {
					ssajax.$(cnodename).checked = cnodevalue;
					ssajax.$(cnodename).value = cnodevalue;
				}
				else if(document.getElementById(cnodename).type == "select-one") {
					ssajax.$(cnodename).selectedIndex = cnodevalue;
				}

				else if(document.getElementById(cnodename).className == "TEXT") {
					cnodevalue = unescape(cnodevalue);
					ssajax.$(cnodename).innerText = cnodevalue;
				}
				else {
					ssajax.$(cnodename).value = cnodevalue;
				}
			} catch(err) {
				alert(err.description + " ---" + cnodename + ' ' + ssajax.$(cnodename));
			}
		}

	}

}

// Opens a URL in a new window.
function openUrl(cUrl) {
	var w = open(cUrl, '', 'scrollbars,resizable,height=500,width=700');
	w.focus();
}

// --------------------------------- Jquery Related Functions ----------------------- //
// This method loads a URL in the center panel
function loadUrl(curl, lCollapseNorthAndEast) {

	if(lCollapseNorthAndEast == true) {
		// We close the North and East Panel
		layout.close("north");
		layout.close("east");
	}


	// THIS LINE GIVES PERMISSION ERROR IN WINDOWS 7 //
	// We show the loading Image
	//var chtml='<table height="100%" width="100%"><tr><td align="center"><img src="images/animated/loading.gif" /></td></tr></table>';
	//$("#center").html(chtml);
	//$("#center").contents().html(chtml);

	// We use Ajax to load the url
	$("#center").attr("src", curl);
};

// -------------------------------------------------------------------------------------- //
// Opens a Url in a Modal Dialog.
// The 2nd Parameter can be the TITLE of the dialg or an Object with the
// Jquery Dialog options.
// Note : It uses a dynamic IFRAME to load the new url. 
// The 3rd Parameter can be a string "div" to makesure that the dialog does not use
// an Iframe but instead uses a DIV element to load an external HTML document.
//
// This function returns a dialog object.
//
// Rev 10.7.2012 [Pinaki] - 4th parameter added to allow the Iframe to have a
//      specific name [ex: used in SMS/eMail].
//
// Rev 15.9.2014 [Abs] - Support for BootStrap added. A new property of the passed opt object
//  tells the routine whether to use JQueryUI dialog, or bootstrap.
// -------------------------------------------------------------------------------------- //
function urlDialog(curl, opts, cdiv, ciframeid) {

	// We shall return a reference to the dialog.
	var odialog;
	
	if(cdiv == null) {
		cdiv = 'iframe'
	}

	// If no Iframename is passed, we use a default name
	if(ciframeid == null) {
		ciframeid = "wiframe";
	}

	// Has the height and Width been sent at all? If not, BootStrap can automatically set the height
	// and width based on the contents of the URL.

	// A Client has been chosen, now we open a new window with the
	// url to show the signature.	
	// Rev 15.9.2014 [Abs] - We will now use extend.
	var settings = {
		library: getUILibrary(),     // jqueryui,bootstrap
		title: "Title",
		height: 500,
		width: 500,
		modal: true,
		hasCloseButton: true		// weather the close button of the window is required or not like password expired 
	}

	if(typeof (opts) != "object") {
		settings.title = opts;
	};
	$.extend(settings, opts);
	// ------------------- // 
	
	//--- Pinaki
	if(typeof (settings.height) == "string") {
		// Takeout 90 out of 90%
		nHeightPcnt = parseInt(settings.height.substr(0, settings.height.length - 1))
		// Calculate the Height
		// Rev Abs [30.9.2013] - Instead of Window, we should use Document object.
		//   opts.height = $(window).height() * nHeightPcnt / 100
		settings.height = $(document).height() * nHeightPcnt / 100
	};

	if(typeof (settings.width) == "string") {
		// Takeout 90 out of 90%
		nWidthPcnt = parseInt(settings.width.substr(0, settings.width.length - 1))
		// Calculate the Width
		// Rev Abs [30.9.2013] - Instead of Window, we should use Document object.
		// settings.width = $(window).width() * nWidthPcnt / 100
		settings.width = $(document).width() * nWidthPcnt / 100
	};

	// By default, the curl displayed may be cached. The only way [I found] to
	// circumvent this is to add the current time in the Url.
	curl = getNocacheUrl(curl);

	// We remove the already existing Frame.
	var newiframe = "#" + ciframeid;
	$(newiframe).remove();

	// Rev 15.9.2014 [Abs] - Now we handle the different libraries.
	if(settings.library == "jqueryui") {
		if(cdiv == 'iframe') {

			// Rev Abs [20.9.2013] - We remove the borders
			//odialog = $('<div id="' + newdiv + '"><iframe width="100%" height="100%" id="' + ciframeid + '"></iframe></div>').dialog(settings);
			// Rev Abs [29-4-2014] - Border:none changed to frameBorder="0">
			//odialog = $('<div id="' + newdiv + '"><iframe style="width:100%;height:100%;" frameBorder="0" id="' + ciframeid + '"></iframe></div>').dialog(settings);
			// Rev Abs [13-5-2014] - I spent hours and hours trying to figure out the solution. When the IFRAME was enclosed in
			// a DIV, the dialog sometimes opened with the wrong height and width. When I removed the DIV, the dialog opened
			// with the correct size, but the Iframe opened with its default width of 300px. I finally found the soution by
			// adding 100% call. See code below !!
			// Rev Abs [15-5-2014] - 100% width changed to the Width in pixels-15.
			// 

			// Rev 12.7.2014 [Abs] - We need to remove the iframe that we added. This is needed because say we
			// are playing a you video inside a dialog [like Video Tutorials] . When we close the dialog, 
			// the Video keeps playing.
			if(typeof (settings.close) != "function") {
				// The calling routine has not set an CLOSE code at all. We are free to overwrite it. In this
				// case, we will remove the new IFRAME that we created.
				settings.close = function () {
					$(newiframe).attr("src", "about:blank");
					$(newiframe).remove();
					$(this).dialog('destroy').remove();
				};
				//settings.close = function () { $(this).dialog('destroy').remove(); alert('ok!'); };
			};

			//settings.close = function () {$(newiframe).remove();};

			var dialogHtml = '<iframe style="width:100%;height:100%" allowFullScreen frameborder=0 id="' + ciframeid + '"></iframe>';
			odialog = $(dialogHtml).dialog(settings);
			$("#" + ciframeid).css("width", settings.width - 15);
			$(newiframe).attr("src", curl);
		} else {
			// We use a DIV element to load the contents of an external document.
			$("#wdiv").remove();
			$('<div id="wdiv" width="100%" height="100%"></div>').dialog(settings);
			$("#wdiv").load(curl);
		};
	} else {

		// ***********************************************************************
		//---------------------- BOOTSTRAP Dialog
		// ***********************************************************************

		/*
		Rev : 5.Sep.2016 - [Priyabrata Ghosh]
		In the var chtml the following line has been changed.
		Original ::
		'<iframe style="width:' + settings.width + 'px;height:' + (settings.height - 100) + 'px;" allowFullScreen frameborder="0" id="' + ciframeid + '" src=' + curl + '></iframe>' +
		Changed ::
		'<iframe style="width:100%;height:' + (settings.height - 100) + 'px;" allowFullScreen frameborder="0" id="' + ciframeid + '" src=' + curl + '></iframe>' +
		*/
		
		var cDisplay='block'
		if(!settings.hasCloseButton)
			cDisplay='none'

		var chtml = '<div class="modal" id="modalBootstrap" tabindex="-1" role="dialog" aria-labelledby="modalBootstrapLabel" aria-hidden="true">' +
          '<div class="modal-dialog">' +
            '<div class="modal-content">' +
              '<div class="modal-header">' +
                '<button type="button" style="display:' + cDisplay + ';"  class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>' +
                '<h4 class="modal-title" id="modalBootstrapLabel">' +
                settings.title +
                '</h4>' +
              '</div>' +
              '<div class="modal-body">' +
                '<iframe style="width:100%;height:' + (settings.height - 100) + 'px;" allowFullScreen frameborder="0" id="' + ciframeid + '" src=' + curl + '></iframe>' +
              '</div>' +
              '<div class="modal-footer">';
		

		// If the settings.buttons doesnt exit, we create a BLANK Array to avoid errors in the rest of the code.
		if(!settings.buttons) {
			settings.buttons = [];
		};

		// Now we need to construct the HTML to inject the buttons into the generated HTML.
		// We loop through each button and insert the button HTML.
		$.each(settings.buttons, function (key, button) {
			// We add the button.
			var cbuttonid = "btn" + key;
			chtml += '<button type="button" ' + 'id="' + cbuttonid + '" class="btn btn-primary">' + button.text + '</button>';
		});

		//'<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>'
		chtml += '</div>' +
            '</div>' +
          '</div>' +
        '</div>';

		$("#modalBootstrap").remove();
		$("body").append(chtml);

		// We will also create a javascript code that will bind the click events of the buttons with the passed
		// javascript attached to the button.click.
		$.each(settings.buttons, function (key, button) {
			// We add the button.
			var cbuttonid = "btn" + key;
			// Generate code to bind the Click event
			var cjavascript = '$("#' + cbuttonid + '").on("click" , button.click )';
			// execute the code.
			eval(cjavascript);
		});


		// Create and show the Modal form with the passed url in the iFrame inside.
		odialog = $("#modalBootstrap").modal({
			backdrop: 'static',
			keyboard: false
		});

		// Now that the Dialog is constructed, we need to resize the Width. Note that changing
		// the height is NOT working.
		$("#modalBootstrap .modal-dialog").css("width", settings.width + 20);

		$("#modalBootstrap").on('hidden.bs.modal', function (e) {
			$("#modalBootstrap").remove();
		})
	};

	// We return the Dialog
	return odialog;

};

// ----------------------------------------------------------------------------------------------------- //
// This function can be used to display an Jquery.UI Dialog with an Submit and a Close button.
// I found that in 90% cases, thee urlDialog function is called to show a Page which needs to
// be submitted [in which case there may be a success/failure] or simply closed. The webpages, I found,
// were writing extensive code to generate the Code for the buttons. I made a generic function to
// do the same
//`
// Opts Object :
// =============
// type [Optional] - OKCANCEL [Default] ,OK,""[No button]
// url [Mandatory] - The page that is displayed in the dialog
// frame_name [Optional] - Just in case a frame name is required. Otherwise a random frame name is used.
// title - Title of the Dialog
// savecaption - Caption of the SAVE button
// CancelCaption - Caption of the CANCEL button
// width - [Optional] - A number, representing pixels, or a %age
// height - [Optional] - A number, representing pixels, or a %age
// reload - If true, the calling page is refreshed on success [like Grid refreshing,etc]
//
// The page to which the POST is made with the formdata should return a string which starts with :
// "Error:<Error Message>", in which case, we show the error and keep the form open
// "Success:<Success Message>", in which case we show the message and close the dialog [ex: Update successful]
// "" . which is same as success, no message is shown and the dialog is closed.
// To handle the above, the page can take help of a helper class called "urlFormDialogResponse".
//
// Sample Usage
// ============
//  var opts = {
//      type:"OKCANCEL",    // Optional. OKCANCEL is the default
//      url:"html/WebPwdChange.swcx" ,
//      title:"Change Password for " + "<%= LEFT(App.AccYear,2)+"-"+RIGHT(App.AccYear,2) %>",
//      savecaption:"Change Password",
//      cancelcaption:"Not Now",
//      width: 400,
//      height: 300,
//      fnpostsuccess: function(data){alert("Data Saved!");},  // Code to execute POST success.
//      reload: true  // The calling page is refreshed [like Grid refreshing,etc].
//  };
//  urlFormDialog(opts);
// ----------------------------------------------------------------------------------------------------- //
//
// To return Data [response] from the called _PAGE.prg, use code like follows :
// ****** The server function now returns a JSON. ****
//
//  oResponse= CREATEOBJECT("urlFormDialogResponse")
//  IF <<Some validation Error>>
//      oResponse.AddError( "You have not selected a Client !")
//  ENDIF
//  IF <<Success - All conditions passed>>
//      oResponse.AddSuccess("Data Saved ! Congratulations ! The form will close !")
//  ENDIF
//  IF <<Some validation occured>>
//     oResponse.AddJs("JAVASCRIPT CODE TO BE EXECUTED ON THE CLIENT")
//  ENDIF
// 
// At the _PAGE level, we can determine that the SAVE button is pressed by checking for :
//		m.lIsSave  	= (Request.QueryString("buttonclicked") = "ok")   && The user has pressed the SAVE button. This
// -------------------------------------------------------------------------------------------- //
// Rev 24.9.2014 [Abs] - We are now accepting a JSON object from the server. This allows us to
//  get multiple types of responses. The server could send back an "error" message along with a 
// "javascript" to fire.

// Global Variable to save the instance of the dialog. Unfortunately, we required a variable to
// store the Dialog so that we can close it when we want. 
__urlFormDialog = null;

function urlFormDialog(opts) {

	// Opts is an Object that needs to be passed. We first create a template object.
	var settings = {
		library: getUILibrary(), // bootstrap,jqueryui
		type: "OKCANCEL",
		url: "",                      // The url of the Page which is displayed in the Dialog.
		frame_name: getRandomId(),     // If not passed, we will create a random Frame name.
		title: "",
		savecaption: "Ok",
		cancelcaption: "Cancel",
		okcaption: "Ok",
		width: "80%",
		height: "80%",
		reload: false,   // In some cases, the calling page may want to be refreshed once
		reloadwindow: null,	// Rev 3.9.2016 : By default, the current document is reloaded. But we may want
		// to reload another page. Wee WebChequeRequest.swcx for example.
		// a submit is successful. Example when a Grid may require to be refreshed.
		fnpostsuccess: function (data) { },
		hasCloseButton: true
	};

	// Now we use the extend method to Merge the contents of two or more objects together into the first object.
	$.extend(settings, opts);
	
	// Now we create a SaveFunction.
	var saveFunction = function () {

		// Rev 29.5.2014 [Abs] - The frames[] is IE only. The code was not working on Chrome
		//var form = window.frames[settings.frame_name].document.forms[0];
		var form = document.getElementById(settings.frame_name).contentWindow.document.forms[0];

		var formdata;
		formdata = $(form).serialize();
		formdata = formdata;

		// ----------------------------------- //
		// When the user clicks on "Ok", we save an additional QueryString Parameter called 
		// buttonclicked=ok to the Url. This way the calling routine can trap that the Ok button
		// was pressed. However, this is not necessary as IsPostback() itself means that the
		// form has been submitted.
		// ----------------------------------- //
		var cSaveUrl;
		cSaveUrl = settings.url;
		if(cSaveUrl.indexOf("?") == -1) {
			cSaveUrl = cSaveUrl + "?";
		}
		cSaveUrl = cSaveUrl + "&buttonclicked=ok";

		$.ajax(cSaveUrl, {
			async: false,
			cache: false,
			type: "POST",
			data: formdata,
			dataType: 'json',
			error: function (a, b, c) {
				alert("urlDialog Error : " + b);
			},
			success: function (data) {

				// If the word "Error" appears anywhere in the returned response, we display
				// the message and keep the dialog opened because there is an error.
				//var lErrorReturned;
				//lErrorReturned = (data.indexOf('Error') > -1);
				//if (lErrorReturned) {
				//    cErrorMsg = data.replace('Error:', '');
				//    // Yes an error has occured.
				//    showMessage(cErrorMsg );
				//    return;
				//};
				if(data.error) {
					showMessage(data.error);
				}

				// It may not be an error, the page to which the POST was made could return a string
				// starting with "Success:". If it does, the submit has been successful and the page
				// wants to display a message, like "Your new password has been emailed to you!". We
				// simply display the message and close the dialog.
				//if (data.indexOf('Success:') > -1) {
				//    cSuccessMsg = data.replace('Success:', '');
				//    showMessage(cSuccessMsg);
				//};
				if(data.success) {
					showMessage(data.success);
				}

				// If Javascript code is returned from the page on the server, we execute that JS
				// Note that if JS is passed, the window closes anyway becase no Error Message
				// was returned.
				//if (data.indexOf('javascript:') > -1) {
				//    cjavascript = data.replace('javascript:', '');
				//    eval(cjavascript);
				//};
				if(data.javascript) {
					eval(data.javascript);
				}

				// If an error occurred, we need to return at this stage.
				if(data.error) {
					return;
				}

				// If any code has been specified to be fired AFTER success, we execute it now.
				settings.fnpostsuccess(data);

				// The "dialog" variable is crucial. It is used to close the window. Whenever, the
				// function is called, the returned dialog should be saved in this variable.
				if(settings.library == "jqueryui") {
					// JQueryUI
					$(__urlFormDialog).dialog("close");
				} else {
					// Bootstrap
					$("#modalBootstrap").modal("hide");
				}

				__urlFormDialog = null;

				// We reload the calling page in case of success [only if it wants to, that is]
				if(settings.reload) {
					if(settings.reloadwindow == null) {
						window.location.reload(false);
					} else {
						// A document object has been passed to reload. See WebChequeRequest.swcx for usage example.
						settings.reloadwindow.location.reload(false);
					}
				};

				// Rev 3.9.2016 [ABS] - We may even want to reload the parent

				return;
			}
		});

	}; // End of saveFunction

	var cTitle = settings.title;

	var abuttons = []; // Blank Array

	// The number of buttons depend on the TYPE of the dialog being generated.
	if(settings.type.toLowerCase() == "okcancel") {
		abuttons = [{ text: settings.savecaption, click: saveFunction }];
		// The code for closing the dialog will be different for Bootstrap and JQueryUI
		if(settings.library == "jqueryui") {
			abuttons.push({
				text: settings.cancelcaption,
				click: function () {
					$(this).dialog("close");
				}
			});
		}
		else {
			// In case of Bootstrap, we always use the modalBootstrap id.
			abuttons.push({
				text: settings.cancelcaption,
				click: function () {
					$("#modalBootstrap").modal("hide");
				}
			});
		};

	} else if(settings.type.toLowerCase() == "ok") {
		abuttons = []; // Blank Array
		//The code for closing the dialog will be different for Bootstrap and JQueryUI
		if(settings.library == "jqueryui") {
			abuttons.push({
				text: settings.okcaption,
				click: function () {
					$(this).dialog("close");
				}
			});
		}
		else {
			// In case of Bootstrap, we always use the modalBootstrap id.
			abuttons.push({
				text: settings.okcaption,
				click: function () {
					$("#modalBootstrap").modal("hide");
				}
			});
		};
	} else if(settings.type.toLowerCase() == "okwithvalidation") {
		// Rev 30.11.2022 [Pinaki] - now only save button create and validation called saveFunction.. see Password Change
		abuttons = [{ text: settings.savecaption, click: saveFunction }];
	}
	else {
		// No button
		abuttons = null;
	}

	var opts = {
		width: settings.width,
		height: settings.height,
		title: settings.title,
		buttons: abuttons,
		modal: true,
		hasCloseButton: settings.hasCloseButton
	};

	// We need the Dialog to be able to close in during success. We have this Global variable
	__urlFormDialog = urlDialog(settings.url, opts, null, settings.frame_name);

	// Generate the Dialog and return a reference to it. The calling routine MAY use it
	// if it wants.
	return __urlFormDialog;

}

// Generic function to show any message in a modal window.
// The second parameter is optional and can contain an object representing
// the options of the dialog
// Rev 12-9-2014 [Abs] - The function now works with JQueryUI and Bootstrap, both.
// ------------------------------------------------------------------------------------- //
function showMessage(cMessage, opts) {

	// Opts is an Object that needs to be passed. We first create a template object.
	var settings = {
		library: getUILibrary(), // jqueryui,bootstrap
		title: "Message",
		modal: true,
		autoResize: true
	};
	// Now we use the extend method to Merge the contents of two or more objects together into the first object.
	$.extend(settings, opts);

	// We need to handle the Library
	if(settings.library == 'jqueryui') {
		// Jquery UI Dialog.
		var mess;
		mess = $('<div></div>').dialog(opts);
		mess.html(cMessage);
	} else {
		// Bootstrap
		// Step I : We will inject an HTML

		$("#modalmessageBootstrap").remove();

		var chtml = '<div class="modal" id="modalmessageBootstrap" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">' +
          '<div class="modal-dialog">' +
            '<div class="modal-content">' +
              '<div class="modal-header">' +
                '<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>' +
                '<h4 class="modal-title" id="myModalLabel">' +
                settings.title +
                '</h4>' +
              '</div>' +
              '<div class="modal-body">' +
                cMessage +
              '</div>' +
              '<div class="modal-footer">' +
                '<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>' +
              '</div>' +
            '</div>' +
          '</div>' +
        '</div>';

		$("body").append(chtml);

		$("#modalmessageBootstrap").modal();
	}

};

// This function hits a URL, fetches its contents and loads the contents into a DIV. Howevere,
// it does so WITHOUT caching the results , unlike the "Load" method of JQuery.
// 
// Example :
//    loadNoCache( "html/maintop.swc" , "#north")
function loadNoCache(cUrl, cItem) {
	$.ajax({
		url: cUrl,
		cache: false,
		success: function (result) {
			$(cItem).html(result);
		}
	});
};

//----------------------------------------------------------------//
// Javascript equivalent of SS Wyesno dialog
// The 3rd parameter is the Javascript function that is executed
// when a user chooses yes.
//----------------------------------------------------------------//
function wyesno(cMessage, opts, fnyes) {

	if(typeof (opts) != "object") {
		var opts = {
			title: "Question",
			modal: true,
			height: 200,
			width: 400,
			buttons: {
				"Yes": function () {
					$(this).dialog("close");
					fnyes();
				},
				"No": function () {
					$(this).dialog("close");
				}
			}
		};
	};

	// We construct the HTML
	var chtml = "<table height='100%' width='100%'><tr><td><img src='" +
        getRootWebSitePath() + "/images/question_64x64.png'/></td><td>" + cMessage + "</td></tr></table>";

	var mess;
	mess = $("<div></div>").dialog(opts);
	mess.html(chtml);

};


// -----------------------------------------------------------------------------------//
// Returns the Root Website Virtual path : 
// 
// Example : http://abhaydell/shrdbms
//
// This value can be important to construct url to images, etc., when we cannot be sure of the
// url of the page which fires the function
// -----------------------------------------------------------------------------------//
function getRootWebSitePath() {
	var _location = document.location.toString();
	var applicationNameIndex = _location.indexOf('/', _location.indexOf('://') + 3);
	var applicationName = _location.substring(0, applicationNameIndex) + '/';
	var webFolderIndex = _location.indexOf('/', _location.indexOf(applicationName) + applicationName.length);
	var webFolderFullPath = _location.substring(0, webFolderIndex);

	return webFolderFullPath;
}
//----------------------------------------------------------------//

// --------------------------------------------------------------------------------------------------- //
// Jquery Generic Code 
// --------------------------------------------------------------------------------------------------- //
// Note that the following commands are fired EVERYTIME the SSajax library is loaded. This means we
// can handle generic StanSoft classes - ex: sms, etc.
// --------------------------------------------------------------------------------------------------- //
$(function () {

	// Rev 13.8.2014 [Abs] - Bootstrap works with the latest version of JQuery. But, we use older version
	//  of JQuery in our normal application. As a result, if we include ssAjax.js in an application using
	// Bootstrap [ex:KYC], it crashes. So, I was forced to put the whole thing in try..catch. The main reason
	// is that the "live" method used in the following functions uses latest version.
	try {
		// SMS Class
		bindSMSClickEvent();

		// Email Class
		bindEmailClickEvent();

		// Bind CMClient Links. When a user clicks on the name of the Client, we
		// can show the entire history of the client
		bind_CMClientLinks();

		// Rev 11-7-2016 [Abs] - A new type of link added which connects a sharename to Yahoo page
		// for the share. Clicking on such a link opens up a urlDialog with the yahoo page for the share
		bind_YahooLinks();

	} catch(error) {
		// Just bypass the error.
	};

});

// --------------------------------------------------------------------------------------------------- //
// Sets the CLICK event for all <a> links of class "sms".
// Clicking opens up a form for sending SMS.
//
// The <a> tag must contain the following attributes :
//
//  idtype = CLIENT/BRANCH/SUBBROKER/PROSPECT
//  id     = The code of the person to whome the SMS is to be sent
//
// The function is kept separate because it may need to be fired separately when a new html is
// inserted containing a "sms" class <a> link.
// --------------------------------------------------------------------------------------------------- //
function bindSMSClickEvent() {

	// Rev 15.12.2014 [Abs] - Instead of "live", we use a new function "compatibleOn" which handles
	// the OLD and NEW JQuery versions.
	//$("a.sms").live("click", function (event) {
	compatibleOn("click", "a.sms", function (event) {

		// We pickup the Orgcode hit by the user
		var cIdType = $(this).attr("idtype");
		var cId = $(this).attr("id");

		var opts = {
			type: "OKCANCEL",    // Optional. OKCANCEL is the default
			url: "sendSMS.swcx?&idtype=" + $(this).attr("idtype") + "&id=" + $(this).attr("id"),
			title: "Send SMS",
			savecaption: "Send",
			cancelcaption: "Cancel",
			width: 600,
			height: 350
		};
		urlFormDialog(opts);
		event.preventDefault();  // Prevent following the BLANK Url.

	});
};

// --------------------------------------------------------------------------------------------------- //
// Sets the CLICK event for all <a> links of class "email".
// Clicking opens up a form for sending Email.
//
// The <a> tag must contain the following attributes :
//
//  idtype = CLIENT/BRANCH/SUBBROKER/PROSPECT
//  id     = The code of the person to whome the Email is to be sent
//
// The function is kept separate because it may need to be fired separately when a new html is
// inserted containing a "email" class <a> link.
// --------------------------------------------------------------------------------------------------- //
function bindEmailClickEvent() {

	// Rev 15.12.2014 [Abs] - Instead of "live", we use a new function "compatibleOn" which handles
	// the OLD and NEW JQuery versions.
	//$("a.email").live("click", function (event) {
	compatibleOn("click", "a.email", function (event) {

		// We pickup the Orgcode hit by the user
		var cIdType = $(this).attr("idtype");
		var cId = $(this).attr("id");

		var opts = {
			type: "OKCANCEL",    // Optional. OKCANCEL is the default
			url: "sendEmail.swcx?&_kjhgfds=foxpro&idtype=" + $(this).attr("idtype") + "&id=" + $(this).attr("id"),
			title: "Send Email",
			savecaption: "Send",
			cancelcaption: "Cancel",
			width: 900,
			height: 500
		};
		urlFormDialog(opts);
		event.preventDefault();  // Prevent following the BLANK Url.

	});

	// Let us declare the SAVE function
	//var saveFn = function(){

	//    // showMessage("email generation is still Work-in-Progress ! <br/> Please bear with us !");
	//    // return;

	//    // Here we have to pack the Data from the form and hit an Ajax request for 
	//    // saving the email.
	//    // var form = document.frames[0].document.forms[0];
	//    var form = document.frames["emailframe"].document.forms[0];

	//    var formdata;
	//    formdata = $(form).serialize();
	//    formdata = formdata;

	//    var cSaveUrl;
	//    cSaveUrl = "SendEmail.swcx?&mode=save&idtype=" + cIdType + "&Id=" + cId + "&" + formdata;

	//    // Rev 10.7.2012 [Pinaki] - We found that SMS/eMail were not going on second
	//    // hit. Reason : We needed to pass "cache:false"
	//    var opts = {cache:false};

	//    $.ajax(cSaveUrl,opts);

	//    $(dialog).dialog("close");

	//    // Now we modify the Client
	//    event.preventDefault();
	//};


	//// Create the Options for the dialog
	////                buttons: abuttons,
	//var abuttons =
	//      [{ text: "Send" ,click: saveFn },
	//       { text: "Cancel", click: function () { $(this).dialog("close");  } }];

	//var opts = { 
	//    width: 800,
	//    height: 500,
	//    title: "Send Email", 
	//    buttons:abuttons,
	//    modal: true };

	//// Create the url for sending custom Email
	//var curl = "sendEmail.swcx?&idtype=" + $(this).attr("idtype") + "&id=" + $(this).attr("id") ;

	//dialog = urlDialog(curl, opts, null, "emailframe");

	//// Prevent the default Link behavior.
	//event.preventDefault();
	//});

};

// This function binds all the a_prospect Links to the modification code for
// prospects
function bind_CMClientLinks() {

	$(".a_CMClient").click(function (event) {

		// We pickup the Orgcode hit by the user
		var cSubCd = $(this).attr("subcd");
		var curl = "OrgClientDetail.Swc?&subcd=" + cSubCd;

		// We create an array of buttons to be passed to the dialog
		var abuttons = [{ text: "Ok", click: function () { $(this).dialog("close"); } }];

		// Create the Options for the dialog
		var opts = {
			width: 900,
			height: 700,
			title: "Client Detail",
			buttons: abuttons,
			modal: true
		};

		dialog = urlDialog(curl, opts);

		// Now we modify the Client
		//modifyProspect("edit", cProspectId);
		event.preventDefault();
		event.stopPropagation();

		return
	});
};


// ---------------------------------------------------------------------------------------------------------- //
// Rev 11-7-2016 [Abs] - A new type of link added which connects a sharename to Yahoo page
// for the share. Clicking on such a link opens up a urlDialog with the yahoo page for the share
// ---------------------------------------------------------------------------------------------------------- //
//Abhay
function bind_YahooLinks() {

	$(".a_Yahoo").click(function (event) {
		var opts = { title: 'Scrip History', height: '82%', width: '92%', modal: true };

		// We pickup the Orgcode hit by the user
		var cItemcd = $(this).attr("itemcd");
		//var IsHttps = $(this).attr("IsHttps");
		//var curl = getRootWebSitePath() + "/html/webshareinfo.swc?ItemCd=" + cItemcd + "&IsHttps=" + IsHttps;
		var curl = getRootWebSitePath() + "/html/webshareinfo.swc?ItemCd=" + cItemcd;
		parent.urlDialog(curl, opts);
		return false;
	})
};

// ------------------------------ Jquery Plugin Template Code --------------------------- //
//(function( $ ){
//
//  $.fn.tooltip = function( options ) {  
//
//    // This is how to copy Default settings onto the options object.
//    var settings = {
//      'location'         : 'top',
//      'background-color' : 'blue'
//    };
//    // If options exist, lets merge them with our default settings
//    // However, in the Jquery.com documentation, the next 3 lines exist
//    // INSIDE the function code [this.each].
//    if ( options ) { 
//        $.extend( settings, options );
//    }

//    // Methods handling -- Create an object containing the various methods 
//    // of the plugin.
//    var methods = {
//       init : function( options ) {},
//       show : function( ) {},
//       hide : function( ) {},
//       update : function( content ) {}
//    };
//
//    return this.each(function() {        
//
//      // Method calling logic
//      if ( methods[method] ) {
//        return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
//      } else if ( typeof method === 'object' || ! method ) {
//        return methods.init.apply( this, arguments );
//      } else {
//        $.error( 'Method ' +  method + ' does not exist on jQuery.tooltip' );
//      }   
//
//      // Tooltip plugin code here
//
//    });
//
//  };
//})( jQuery );
// ---------------------------------------------------------------------------------------- //

// -------------- SS Autocomplete Plugin -----------------------------------//
// This is an extension of the Jquery.UI Autocomplete, except that it adds
// a "Label" in front of the Inputbox and shows the NAME of the entity.
//
// Rev 12.7.2014 [Abs] - A new option called nameFuncParams added. This can be set to
//  and array of expressions that the object will evaluate and send to the server foxpro
//  function as parameters. By default, the plugin sends the value of the textbox used
//  to create an autocomplete, but if nameFuncParams is specified, it evaluates each
//  expression and then hits the server function. This is useful when the server function
//  requires MORE than 1 parameter.
// -------------------------------------------------------------------------//
(function ($) {

	$.fn.ssautocomplete = function (options) {

		// This is how to copy Default settings onto the options object.
		var settings = {
			'source': '',
			'minLength': 2,
			'width': 400,
			'labelWidth': 200,
			'nameFunc': '',
			'nameFuncParams': []
		};

		// If options exist, lets merge them with our default settings
		// However, in the Jquery.com documentation, the next 3 lines exist
		// INSIDE the function code [this.each].
		if(options) {
			$.extend(settings, options);
		}

		return this.each(function () {

			var obj = $(this);

			// Generic function to show the name of the selected entity.
			var fn_showname = function () {
				// We need to create an array of parameters to be sent.
				var aParams = [null, null, null, null, null, null];
				// Has nameFuncParams been specified.
				if(settings.nameFuncParams.length == 0) {
					// No array been set, we will use the Value of the textbox used for autocomplete as
					// the parameter
					// THIS is not working here ---- WHY ???????????????????????????????????????????????????
					// aParams[0] = $(this).val();
					aParams[0] = obj.val();
				} else {
					// We read each element of the nameFuncParams and create an array of parameters
					// to pass to the server-end fox function.
					var index;
					for(index = 0; index < aParams.length; ++index) {
						aParams[index] = eval(settings.nameFuncParams[index]);
					}
				}

				//var cValue=$(this).val();
				//$("#" + cTempSpanid).innerHTML=''   //html('');
				//ssajax.$(cTempSpanid).innerHTML = "";

				// Hit the server-end FoxPro function.
				// Rev 12.7.2014 [Abs] - NameFunc can also be a javascript function.
				ssajax.GetName(settings.nameFunc, cTempSpanid, aParams[0], aParams[1], aParams[2], aParams[3], aParams[4], aParams[5]);

			};

			// Autocomplete Options
			var autoOpts = {
				source: settings.source,
				minLength: settings.minLength
			};

			// Now we add a label to the right of the Dropdown which will 
			// show the NAME of the chosen entity. The label has a temporary
			// ID allotted.
			var d = new Date();
			var cTempSpanid = "temp_" + obj.attr("id"); // d.getTime()

			// Remove the span, if it already exists
			$("#" + cTempSpanid).remove();
			// Now add the Span to show the name.
			obj.after('&nbsp;<span style="width:' + settings.labelWidth + 'px" id="' + cTempSpanid + '"></span>');

			// We get the NAME first.
			var cValue = obj.val();
			if(cValue && settings.nameFunc != '') {
				//cValue = ssajax.FireFunction( settings.nameFunc ,cValue );
				cValue = fn_showname();
				if(cValue) {
					$('#' + cTempSpanid).html('<strong>' + cValue + '</strong>');
				};
			}

			// We define teh Autocomplete.
			obj.autocomplete(autoOpts);

			// We set the width of the Dropdown.
			obj.bind("autocompleteopen", function (event, ui) {
				var $suggestionsDiv = $(event.target).autocomplete('widget');
				$suggestionsDiv.css('width', settings.width + 'px');
			});

			// If a NAME function is provided, it means that when a user
			// goes out of the Inputbox, we should hit the server function,
			// get the name and display it in the Label
			if(settings.nameFunc != '') {
				// A NameFunction has been specified. We must now bind the BLUR
				// event of the tagbox to hit the function, get the name, and 
				// show it in the label.
				obj.blur(fn_showname);
			};

		});

	};

})(jQuery);

// -------------------------------------------------------------------------------------//
// ssFixedPanel -- Plugin 
// One can create a fixed Panel on Top [Toolbar] or Left using this plugin.
//
// Sample usage :
//  This example creates a Layout with Top panel and left panel both. We could always 
//  work with just one.
////Create the toolbar
//  var opts = {
//        height: 100,
//        position: "top",
//        backgroundcolor: "yellow"
//  };
//  $(".toolbar").ssfixedpanel(opts);
//// Create a left Panel now
//// Note that 20 is added because the padding of 10px is automatically added to the 
//// panels [so top has 20 more height than specified].
//   var opts = { position: "left", top: 100+20, width: 100, backgroundcolor: "#F0F0F0" };
//   $("#leftpane").ssfixedpanel(opts);
// -------------------------------------------------------------------------------------//
(function ($) {

	$.fn.ssfixedpanel = function (options) {

		// This is how to copy Default settings onto the options object.
		var settings = {
			position: "top",               // Possible values - top/left.
			backgroundcolor: 'white',
			height: 35, // Used when creating the Top panel [Toolbar],
			width: 200, // Used when creating the Left panel
			top: 0,     // Required in Left/Right panes if a Top Fixed Pane is also present. Usually 
			// to create a detailed layout.
			border: "2px solid silver"  // Bottom border in Top Panel,Right border in Left-panel
		};

		// If options exist, lets merge them with our default settings
		// However, in the Jquery.com documentation, the next 3 lines exist
		// INSIDE the function code [this.each].
		if(options) {
			$.extend(settings, options);
		}

		return this.each(function () {

			// This is the DIV that the calling routine wants to convert into a Toolbar
			var obj = $(this);

			// We set the CSS for the DIV that needs to be converted to a Toolbar
			if(settings.position == "top") {
				// object to define the Panel's Div
				var cssobject = {
					"width": "99%",
					"background-color": settings.backgroundcolor,
					"padding": 10,
					"height": settings.height,
					"position": "fixed",
					"top": settings.top,
					"left": 0,
					"margin": 0,
					"border-bottom": settings.border
				};

				// Object to set the Body
				var cssbody = {
					"margin-top": settings.height + 20 + 10
				}
			} else if(settings.position == "left") {
				// object to define the Panel's Div
				var cssobject = {
					"width": settings.width,
					"background-color": settings.backgroundcolor,
					"padding": 10,
					"height": "100%",
					"position": "fixed",
					"top": settings.top,
					"left": 0,
					"margin": 0,
					"border-right": settings.border,
					overflow: "auto"
				};

				// Object to set the Body
				var cssbody = {
					"margin-left": settings.width + 20 + 10
				};
			} else if(settings.position == "right") {
				// object to define the Panel's Div
				var cssobject = {
					"width": settings.width,
					"right": 0,
					"background-color": settings.backgroundcolor,
					"padding": 10,
					"height": "100%",
					"position": "fixed",
					"top": settings.top,
					"margin": 0,
					"border-left": settings.border,
					overflow: "auto"
				};
				// Object to set the Body
				var cssbody = {
					"margin-right": settings.width + 20 + 10
				};
			};

			// Apply the CSS on the Div that needs to be Panelised
			$(obj).css(cssobject);

			//alert("Reached here 6!");

			// Apply CSS on the Body
			// We add 20 for the Padding and 10 for the additional margin after the toolbar
			// Rev 18.6.2014 [Abs] - Instead of hardcoding "body", we should take the parent
			// element. This way, we shall be able to fix a DIV inside another DIV also.
			$("body").css(cssbody);
			//$(obj).parent().css(cssbody);


			// Shadow is required
			//if (settings.shadow) {
			//    var cssobject={
			//        "box-shadow":"0px 5px 0px silver"
			//    };
			//    $(obj).css(cssobject);
			//}

			// We insert another Dummy Div "behind" the Toolbar Div.
			//obj.after("<div id='dummy_toolbar'></div>");
			//var dummyobj=$("#dummy_toolbar");

			// We apply a slightly different css on the DummyObj
			//var cssobject2={
			//    "display":"block",
			//    "width":"99%",
			//    "background-color":"white",
			//    "padding":"10px",
			//    "height":settings.height,
			//    "position":"relative",
			//    "top":"0",
			//    "left":"0",
			//    "margin":"0px",
			//    "z-index":"-1"
			//}
			//$(dummyobj).css(cssobject2);

		});

	};

})(jQuery);

// ---------------------------------------------------------- //
// Returns a Random Name of 5 characters
// ---------------------------------------------------------- //
function getRandomId() {
	var text = "";
	var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

	for(var i = 0; i < 5; i++)
		text += possible.charAt(Math.floor(Math.random() * possible.length));

	return text;
}

// 
function showVideo(options) {
	// This is how to copy Default settings onto the options object.
	var settings = {
		playerurl: "scripts/VideoHelp.html"  // Default video player HTML file.
	};

	// If options exist, lets merge them with our default settings
	// However, in the Jquery.com documentation, the next 3 lines exist
	// INSIDE the function code [this.each].
	if(options) {
		$.extend(settings, options);
	}

	// Now we construct a URL to the VideoHelp.html [or any other template file provided].
	//var curl = settings.playerurl + "?&menufile=" + settings.menufile + "&caption=" + settings.caption +
	//       "&initialvideo=" + settings.initialvideo;
	// We construct a full querystring from the passed object. The idea is basically to pass the entire
	//  object to the Videoplayer HTML file.
	var curl = settings.playerurl + "?&" + $.param(settings);

	// We set the size of the Dialog.
	if(settings.menufile) {
		// A menufile has been specified. this means that a full-fledged menu system needs to be
		// displayed.
		settings.height = 600;
		settings.width = 1100;
	} else {
		// A single video has to be displayed
		settings.height = 650;
		settings.width = 950;
	};

	// Now we open a new Dialog with the Tutorial.
	urlDialog(curl, settings);
}

// ------------------------------------------------------------------------------- //
// A Video help system. Totally based on a ".ul" file containing the UL-LI structure
// with a Treeview structure and the corresponding Videos from Youtube or any other
// site. It could also be an MP4 stored locally or remotely.
// ------------------------------------------------------------------------------- //
(function ($) {

	$.fn.ssvideohelp = function (options) {

		// This is how to copy Default settings onto the options object.
		var settings = {
			video: "",           //
			menufile: "",       // Either a single youtube/mp4 video is specified, or a menufile is specified.
			caption: "",
			initialvideo: "",
			language: "english",
			mp4location: "http://www.stansoftware.com/shrdbms/videos/",
			relative2scripts: "../",    // relative path to the Scipts folder from the page calling this plugin.
			width: 1100,
			height: 600,
			menuwidth: 300               // The Width of the Menu on the left
		};

		// If options exist, lets merge them with our default settings
		// However, in the Jquery.com documentation, the next 3 lines exist
		// INSIDE the function code [this.each].
		if(options) {
			$.extend(settings, options);
		}

		// The language should be in lower case for string comparison.
		settings.language = settings.language.toLowerCase();
		settings.relative2scripts = decodeURIComponent(settings.relative2scripts);

		//This function actually plays the file.
		var playvideo = function (videofile, playertype) {

			// We generate some variables based on Player Type.
			var opts = { left: 50, top: 50, width: 640, height: 390 };
			if(playertype == "single") {
				opts = { left: 0, top: 0, width: 890, height: 500 };
			};

			// we first need to deterine the type of video that is being displayed.
			var ext = videofile.split('.').pop();

			if(ext == "mp4") {
				// ** MP4 *--------------------------------------------*
				var chtml = '<video controls autoplay ' +
                               'style="position:relative;left:' + opts.left + 'px;top:' + opts.top + 'px;' +
                               'width:' + opts.width + 'px;height:' + opts.height + 'px">' +
                        '<source type="video/mp4" src="' + settings.mp4location + videofile + '">' +
                    '</video>'
				$("#videodiv").html(chtml);
				$("#videodiv").show();

				//} else if (ext == "html") {
				//    // ** HTML file *--------------------------------------------*
				//    // We make an Ajax call to the server and get the HTML file.
				//    var chtml = "";
				//    $.ajax({
				//        url: videofile,
				//        type: "get",
				//        async: false,
				//        success: function (data) {
				//            chtml = data;
				//        },
				//        error: function (jqXHR, textStatus, errorThrown) {
				//            alert(errorThrown);
				//        }
				//    });
				//    $("#videodiv").html(chtml);
				//    $("#videodiv").show();
			} else if(videofile.indexOf("http") > -1 || ext == "html") {

				var nWidth = $(window).width() - settings.menuwidth - 40;
				var cWidth = nWidth.toString() + "px";

				// ** Url *--------------------------------------------*
				//  Rev 11.12.2014 [Abs] - Width 100% is wrong. We need to calculate the total width
				//  available in the browser.
				var chtml = '<iframe style="width:' + cWidth + ';height:100%;"  frameborder=0 allowfullscreen ' +
                    'src="' + videofile + '">' +
                    '</iframe>';
				$("#videodiv").html(chtml);
				$("#videodiv").show();
			} else {
				// ** YOUTUBE *--------------------------------------------*
				// We create the HTML to show the video.
				// Rev 18.04.2016 [Abs] - http changed to https. The reason is that if a broker
				// has a https server, the page is served to the client in https mode, and 
				// the video hits a http youtube video, giving mixed mode security error.
				// ------------------------------------------------------------------------- *
				var chtml = '<iframe ' +
                    'style="position:relative;left:' + opts.left + 'px;top:' + opts.top + 'px;' +
                               'width:' + opts.width + 'px;height:' + opts.height + 'px" ' +
                    'frameborder=0 ' +
                    'src="https://www.youtube.com/embed/' + videofile + '?&autoplay=1&modestbranding=1" allowfullscreen>' +
                    '</iframe>';
				$("#videodiv").html(chtml);
				$("#videodiv").show();
			};
		};

		return this.each(function () {

			// This is the DIV that the calling routine wants to convert into a Toolbar
			var obj = $(this);

			// First we blankout the existing contents of the obj.
			obj.html("");

			// Do we need a help-system with a menu, or play a single video.
			var playerType;
			if(settings.menufile) {
				playertype = "help";
			} else {
				playertype = "single";
			};

			// For us to set the Height/Width to 100% of the DIV, we need to set the same for the
			// parents, i.e, body and html.
			$("html,body").css({ height: "100%", width: "100%" });

			// We load the dependent JavaScript and CSS files
			//$("head").append('<script src="' +settings.relative2scripts +'scripts/Jquery-plugins/TubePlayer/jQuery.tubeplayer.min.js"></script>');
			//$("head").append('<script type="text/Javascript" src="' + settings.relative2scripts + 'scripts/jquery-plugins/Treeview/jquery.treeview.js"></script>');
			//$("head").append('<link href="' + settings.relative2scripts + 'scripts/Jquery-plugins/treeview/jquery.treeview.css" rel="stylesheet" />');

			// Set the DIV
			obj.css({ height: "100%", width: "100%" });

			// If it is a menu based system, we need to add a pane on the left where the menu will be shown.
			if(playertype == "help") {

				var chtml = '<div id="leftpane">' +
                                '<div id="videos_caption" class="ss_orangeheader">' + settings.caption + '</div>' +
                                '<div id="menupane"></div>' +
                            '</div>' +
                            '<div id="videodiv">' +
                                    '<h1>Welcome to Video Help</h1>' +
                                    '<p>' +
                                    'Just click on any video link on the left to watch a video.' +
                                    '</p>' +
                            '</div>';
				obj.append(chtml);

				// Fix the Left Pane
				// Rev Abs [18.11.2014] - The top of the Left pane should be the top of the
				//   Video Div.
				var opts = {
					width: settings.menuwidth,
					position: "left",
					backgroundcolor: "white",
					top: obj.css("top")
				};
				$("#leftpane").ssfixedpanel(opts);

				// Load the video-list and convert it to a Treeview
				$("#menupane").load(settings.menufile,
                    function () {

                    	// We make a Treeview now.
                    	$("#videomenu").treeview({ animated: "medium" });

                    	// Any LINK item with a attribute called "video" should have a small Video icon
                    	// to its right.
                    	//$("a:not([video=''])").append("<img src='scripts/images/play-32x32.png' style='height:16px;width:16px;position:relative;top:3px;left:10px;' />'");
                    	$("a[video!='']").append("<img src='" + settings.relative2scripts + "scripts/images/play-32x32.png' style='height:16px;width:16px;position:relative;top:3px;left:10px;' />'");
                    	// The TXT file contains CITE tags which describe a video.
                    	$(".descr").css({ "color": "red" });

                    	// Now we hookup the Click events of the LIs inside the ULFILE.
                    	// Rev 15.12.2014 [Abs] - Instead of "live", we use a new function "compatibleOn" which handles
                    	// the OLD and NEW JQuery versions.
                    	//$(".menuitem").live("click",
                    	compatibleOn("click", ".menuitem",
                            function (e) {

                            	var video = $(this).attr("video");
                            	var videohindi = $(this).attr("hindi");
                            	var htmlpage = $(this).attr("href");

                            	// In case of another language, we use a different video.
                            	if(settings.language == "hindi" && videohindi != "") {
                            		video = videohindi;
                            	};
                            	// We could even have an HTML page link
                            	if(htmlpage != "") {
                            		video = htmlpage;
                            	};

                            	playvideo(video, playertype);
                            	e.preventDefault();
                            });
                    });

			} else {
				var chtml = '<div id="videodiv"></div>';
				obj.append(chtml);
				playvideo(settings.video, playertype);
			};

			// We make the VideoDiv height equal to 100% so that the IFRAMEs fit properly.
			$("#videodiv").css("height", "100%");

			// If an initialVideo [which can even be an HTML file] value is passed, we load it
			if(settings.initialvideo) {
				playVideo(settings.initialvideo);
			};

		});

	}
})(jQuery);
// ------------------------------------------------------------------------------- //

// Sometimes, we may need to access QueryString parameters from within a JavaScript file.
// This function returns and object which has its properties set to the parameters passed.
// Source : http://stackoverflow.com/questions/4656843/jquery-get-querystring-from-url
// --------------------------------------------------------------------------------//
function getUrlVars() {
	var vars = [], hash;
	var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
	for(var i = 0; i < hashes.length; i++) {
		hash = hashes[i].split('=');
		vars.push(hash[0]);
		vars[hash[0]] = hash[1];
	}
	return vars;
}

// --------------------------------------------------------------------------------//
// What if we want to redirect a user to a url , say userlogin.ss, in the top level browser and
// not inside an iframe. This function checks whether we are in an iFrame, in which case it
// redirects on the main browser.
// --------------------------------------------------------------------------------//
function redirectToNewLocation(newLocation) {
    // Check if the current window is an iframe
    if (window.self !== window.top) {
        // Inside an iframe, redirect the parent window
        window.top.location.href = newLocation;
    } else {
        // Not inside an iframe, redirect the current window
        window.location.href = newLocation;
    }
}


// --------------------------------------------------------------------------------//
// Alters the passed url string by adding a timestamp, so that when the url is
// hit to the server, the browser does not use the cache
// For example :
//   getNocacheUrl("form.ss?name=abhay")
//          returns form.ss?name=abhay&_time=1223002
// --------------------------------------------------------------------------------//
function getNocacheUrl(curl) {
	var d;
	d = new Date();
	if(curl.indexOf("?") == -1) {
		curl = curl + "?&_time=" + d.getTime()
	} else {
		curl = curl + "&_time=" + d.getTime()
	}
	return curl;
}

// -------------------------------------------------------- //
// Javascript does not have a RIGHT function on strings.
// We wrote our own
// ---------------------------------------------------------//
function getRightOfString(cstr, nchars) {
	return cstr.substr(cstr.length - nchars, cstr.length);
}


// Rev 19.9.2014 [Abs] - Currently, our systems support JqueryUI or BootStrap for most of its
//   UI. For instance, the urlDialog function works for both JqueryUI or Bootstrap. So,
//   we use this variable to see if Bootstrap is used.
function isBootstrap() {
	return (typeof $().modal == 'function');
}

// This function returns the UI library that is being used by a page.
function getUILibrary() {
	if(isBootstrap()) {
		return "bootstrap";
	}
	return "jqueryui";
};

// This function disables the right Click on a page. The function needs to be specifically
// fired from the web page.
function disableRightClick() {
	$(document).bind("contextmenu", function (e) {
		e.preventDefault();
	});
}

// =================================================================================================================//
// In one application I use JQuery v1.5.1, where the "Live" function works just fine, but in another application, 
// since I use Bootstrap, I use v2.1.1., where "on" works and "live" doesn't.
//
// Posted the issue in StackOverflow to get this solution. Basically, instead of using "on" or "live", if we
// use "compatibleOn", we can live with different versions of JQuery.
// =================================================================================================================//
// ****************** NO DIDNT WORK ! THIS IS A SERIOUS ISSUE IN TRYING TO HANDLE DYNAMICALLY ADDED ELEMENTS
//(function ($) {
//    $.fn.compatibleOn = function (event, handler) {

//        if (typeof jQuery().on === 'function') {
//            //$(this).on(event, handler);
//            $(document).on(event, this, handler);
//        }
//        else {
//            $(this).live(event, handler);
//        }
//    }
//})(jQuery);

function compatibleOn(event, selector, handler) {
	if(typeof jQuery().on === 'function') {
		//$(this).on(event, handler);
		$(document).on(event, selector, handler);
	}
	else {
		$(selector).live(event, handler);
	}
};


function SetFullScreen() {

	divObj = document.documentElement;

	if(divObj.requestFullscreen)
		if(document.fullScreenElement) {
			document.cancelFullScreen();
		} else {
			divObj.requestFullscreen();
		}
	else if(divObj.msRequestFullscreen)
		if(document.msFullscreenElement) {
			document.msExitFullscreen();
		} else {
			divObj.msRequestFullscreen();
		}
	else if(divObj.mozRequestFullScreen)
		if(document.mozFullScreenElement) {
			document.mozCancelFullScreen();
		} else {
			divObj.mozRequestFullScreen();
		}
	else if(divObj.webkitRequestFullscreen)
		if(document.webkitFullscreenElement) {
			document.webkitCancelFullScreen();
		} else {
			divObj.webkitRequestFullscreen();
		}
	//  stop bubbling so we don't get bounce back
	evt.stopPropagation();
};

// -------------------------------------------------------------------------------------------------------- //
// Returns the current Location of the page.
// For instance, may return 'http://backoffice.microsec.com/shrdbms'
// -------------------------------------------------------------------------------------------------------- //
function getCurrentLocation() {
	$url = window.location.href;
	$arr = $url.split("/");
	$cLocation = $arr[0] + "//" + $arr[2];
	return $cLocation;
};

//-----------------------------------------------------------------------------------------//
// This function is the loader function which Silently Logs in a Staff into osTicket
//-----------------------------------------------------------------------------------------//

function osticket_staffLogin(cUser, cPwd) {

	$__CSRFToken__ = "";

	// We get the current domain
	$cUrl = getCurrentLocation() + "/osticket/scp/login.php";
	//$cUrl = "http://localhost/osticket/scp/login.php";

	//alert($cUrl);
	// We make an ajax hit to the osTicket Login page to get the CSRFToken which is contained in the
	// login page. This token needs to be passed when the actuall login takes place.
	$lSuccess = true;
	$.ajax({
		url: $cUrl,
		async: false,
		success: function (data) {

			$__CSRFToken__ = $(data).find('[name="__CSRFToken__"]').val();
		},
		error: function (x, y, z) {
			// alert('error'+z);
			$lSuccess = false;
		}
	});

	// If we could not get the CRFToken, it means that either osTicket is not installed or
	// is not working properly.

	if(!$lSuccess) return false;

	var form = '<form id="dummyform" action="' + $cUrl + '" method="post"> ' +
		'<input type="hidden" name="__CSRFToken__" value="' + $__CSRFToken__ + '">' +
		'<input type="hidden" name="do" value="scplogin">'+
        '<input type="hidden" name="userid" id="name" value="' + cUser + '"/>' +
        '<input type="hidden" name="passwd" id="pass" value="' + cPwd + '" />' +
        '</form>';
	$('body').append(form);
	$("#dummyform").submit();       // Trigger a submit

	return true;
};

//-----------------------------------------------------------------------------------------//
// This function is the loader function which Silently Logs in a Client into osTicket
//-----------------------------------------------------------------------------------------//
function osticket_clientLogin(cSubcd) {
	// We will post ourexisting page into 
	// http://localhost/osticket/login.php
	$__CSRFToken__ = "";
	//$myname = 'JaaDhuke';
	// We get the current domain
	$cUrl = getCurrentLocation() + "/osticket/login.php";

	// We make an ajax hit to the osTicket Login page to get the CSRFToken which is contained in the
	// login page. This token needs to be passed when the actuall login takes place.
	$lSuccess = true;
	$.ajax({
		url: $cUrl,
		async: false,
		success: function (data) {
			//$dummy = '<div id="dummy" style="display:none">' + data + '</div>';
			//$('body').append($dummy);
			$__CSRFToken__ = $(data).find('[name="__CSRFToken__"]').val();
		},
		error: function (x, y, z) {
			// alert('error'+z);
			$lSuccess = false;
		}
	});
	// If we could not get the CRFToken, it means that either osTicket is not installed or
	// is not working properly.

	if(!$lSuccess) return false;

	var form = '<form id="dummyform" action="' + $cUrl + '" method="post"> ' +
		'<input type="hidden" name="__CSRFToken__" value="' + $__CSRFToken__ + '">' +
		'<input type="hidden" name="luser" value="' + cSubcd + '"/>' +
		'<input type="hidden" name="lpasswd" value="_abc$123" />' +
		'</form>';
	$('body').append(form);

	$("#dummyform").submit();

	//alert($('[name="__CSRFToken__"]').val()+" "+$('[name="luser"]').val()+" "+$('[name="lpasswd"]').val());

	return true;
};

// -------------------------------------------------------------------------------- //
// Removes Line Breaks [CRLF] from a passed string
// -------------------------------------------------------------------------------- //
function removeLineBreaks(cStr) {
	cStr = cStr.replace(/(?:\r\n|\r|\n)/g, '');
	return cStr;
}

// -------------------------------------------------------------------------------- //
// Mithun [7-10-2020]  return baseurl
// -------------------------------------------------------------------------------- //
function ssbaseurl() {
	
	//var cbaseurl = window.location.protocol + "//" + window.location.hostname + "/shrdbms/";
	//var cbaseurl = window.location.protocol + "//" + window.location.hostname + ":" + window.location.port + "/shrdbms/";
	var cbaseurl = location.origin+ "/shrdbms/";
	return cbaseurl;
}


// -------------------------------------------------------------------------------- //
// Returns true if the call is made from a page inside an iFrame.
// -------------------------------------------------------------------------------- //
function inIframe() {
    try {
        return window.self !== window.top;
    } catch (e) {
        return true;
    }
}

// --------------------------------------------------------------------------- //
// Toggles display of any element whose ID is passed
// --------------------------------------------------------------------------- //
function toggleDisplay(elementId) {
  
    // Get the element by its ID
    const element = document.getElementById(elementId);

    // Check if the element exists
    if (element) {
        // Toggle the display value between 'none' and 'block'
        if (element.style.display === "none" || element.style.display === "") {
			if (element.tagName === "TABLE") {
            	element.style.display = "table"; 
			} else {
            	element.style.display = "block"; 
			}

        } else {
            element.style.display = "none";
        }
    } else {
        console.error("Element with ID '" + elementId + "' not found.");
    }
}



function createSession(cShrdbmsSessionId) {

	// Assuming you have jQuery for simplicity
	$.ajax({
		type: 'POST',
		url: 'dotnet/dotnetConnect.aspx',
		data: {
			hjjdshhdhdsjskdkjhjjffd: cShrdbmsSessionId
		},
		success: function(data) {
			//console.log('Session created successfully');
			//alert('Session created successfully');
		},
		error: function(xhr, status, error) {
			//console.log('Error creating session: ' + error);
			alert('Error creating session');
		}
	});
}