﻿$(function () {

    if ($(window).scrollTop() < 10) {
        $('#divScrollUp').css({ opacity: 0 });
        $('#divScrollDown').css({ opacity: 1 });
    }

    //Scroll to buttom
    $('#scroll-down').click(function () {
        $('html,body').animate({ scrollTop: $(document).height() }, 2500);
    });
    // Scroll to top
    $('#scroll-up').click(function () {
        $("html, body").animate({ scrollTop: 0 }, 2500);
    });
    //When scrolling start
    $(document).on("scrollstart", function () {
        //if scrollTop have't max(document height - window height) and min(0) value then  ScrollUp and ScrollDown image should be visible
        if ($(window).scrollTop() < $(document).height() - $(window).height() && $(window).scrollTop() > 0) {
            $('#divScrollUp').css({ opacity: 1 });
            $('#divScrollDown').css({ opacity: 1 });
        }

    });
    //When scrolling stop
    $(document).on("scrollstop", function () {
        //if scrollTop have min(0) value then  ScrollUp image should not be visible and ScrollDown image should be visible
        if ($(window).scrollTop() == 0) {
            $('#divScrollUp').css({ opacity: 0 });
            $('#divScrollDown').css({ opacity: 1 });
        }
        //if scrollTop have max(document height - window height) value then  ScrollUp image should be visible and ScrollDown image should not be visible
        if ($(window).scrollTop() == $(document).height() - $(window).height()) {
            $('#divScrollUp').css({ opacity: 1 });
            $('#divScrollDown').css({ opacity: 0 });
        }
    });
})