﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="NSDL_BO_Registration.aspx.cs" Inherits="Connect_DotNet.BO_Registration.NSDL_BO_Registration" %>
<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>

	<!-- Basic Styles 
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">-->
	
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

    <link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-skins.min.css">

	<!-- BootComplete http://getwebhelp.com/bootcomplete/ -->
	<link href="../../scripts/BootStrap/plugins/bootcomplete/bootcomplete.css" rel="stylesheet" />

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">

	<link href="../../css/your_style.css" rel="stylesheet" />
	<link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />

	<style>
		body, table, td { font-size:11px }

		.dxtc-content { background-color:transparent !important }

		.alignRight { text-align:right }
		.alignLeft { text-align:left }
		.alignCenter { text-align:center }

		.borderless { border:none !important }
		.borderless td { border:none !important }
		.tblpadding td { padding:2px !important }

		.inputTable td:nth-child(odd) { text-align:right }
		.inputTable td:nth-child(even) { padding-right:5px !important }

		.dropDown td { text-align:left !important }
		.dateTime td { text-align:center !important }

		.displayTableCell { display:table-cell }
		.displayInlineBlock { display:inline-block }

		.subHeading { font-size:small; padding:5px 0; margin:0; border-bottom:1px solid lightgrey }
			.subHeading ~ table { border-left:1px solid lightgrey !important }

		.completionList {overflow-y:auto;background-color:white;border:1px solid silver;margin:0;padding:3px }
		.listItem { color:black;padding:3px }
		.itemHighlighted { background-color:lightyellow;padding:3px }

		#lstUncheckedClnt { overflow-y:scroll !important }
			#lstUncheckedClnt option { padding:5px }

		#modalSignature { text-align:left }
	</style>
</head>
<body>
	<div class="container-fluid">
	<br />
    <form id="frmNsdlClntReg" runat="server">
		<asp:HiddenField ID="hdnCompany" runat="server" />
		<asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>

		<div class="row">
			<asp:UpdatePanel ID=updPendingClntReg runat="server">
				<ContentTemplate>
					<div class="col-xs-2">
						<dx:ASPxButton ID="btnUncheckedClnt" runat="server" CausesValidation="false"
							Text="Unchecked Clients" HoverStyle-BackColor="Crimson" Theme="MetropolisBlue"
							OnClick="btnUncheckedClnt_Click">
							<ClientSideEvents Click="function(s,e) { 
									$('#divWait').css('visibility', 'visible');
								}" />
						</dx:ASPxButton>
					</div>
					<div class="modal fade" id="modalClntList" role="dialog">
						<div class="modal-dialog modal-md">
							<!-- Modal content-->
							<div class="modal-content">
								<div class="modal-header ">
									<h4 class="modal-title"><i class="fa fa-list" aria-hidden="true"></i> Unchecked Client List</h4>
								</div>
								<div class="modal-body">
									<input type="text" id="txtSearch" onkeyup="searchNames()" placeholder="Search for names.." class="form-control input-sm">
									<dx:ASPxListBox ID="lstUncheckedClnt" ClientInstanceName="lstUncheckedClnt" Theme="MetropolisBlue"
										SelectedIndex="-1" Width="100%" Height=250 runat="server" ValueType="System.String" Native="true">
									</dx:ASPxListBox>
								</div>
								<div class="modal-footer">
									<asp:Button ID=btnClntLstOk runat="server" Text="Ok" CssClass="btn btn-success" OnClick="btnClntLstOk_Click" />
									<button type="button" id="btnClntLstCancel" data-dismiss="modal" class="btn btn-danger">
										Cancel
									</button>
								</div>
							</div>
						</div>
					</div>
				</ContentTemplate>
			</asp:UpdatePanel>
			<div class="col-xs-2">
				<dx:ASPxButton ID="btnNew" runat="server" CausesValidation="false" AutoPostBack="false"
					Text="New Client Registration" Theme="MetropolisBlue" OnClick="btnNew_Click">
				</dx:ASPxButton>
			</div>
		</div>

		<hr style="border:none;border-top:1px solid lightgrey;margin:5px 0"/>

		<div class="row">
			<div class="col-xs-12">
				<table class="table table-responsive borderless tblpadding inputTable"  style="border-bottom:1px solid lightgray !important">
					<colgroup>
						<col /><col />
						<col /><col />
						<col />
					</colgroup>
					<tr>
						<td>Internal Code :</td>
						<td>
							<dx:ASPxTextBox ID="txtClntCode" runat="server" Width="50%" ReadOnly="true" Theme="MetropolisBlue"></dx:ASPxTextBox>
						</td>
						<td>Branch Id :</td>
						<td>
							<ajaxToolkit:AutoCompleteExtender ID=aceBranch runat="server"
								CompletionListCssClass="completionList"
								CompletionListItemCssClass="listItem"
								CompletionListHighlightedItemCssClass="itemHighlighted"
								ServiceMethod="GetBranchCompletionList"
								MinimumPrefixLength="1"
								CompletionInterval="10"
								EnableCaching="false"
								TargetControlID="txtClntBranch"
								FirstRowSelected="false"
								OnClientItemSelected="Branch_Selected">
							</ajaxToolkit:AutoCompleteExtender>
							<asp:HiddenField ID=hdnBranchCode runat="server" />
							<asp:TextBox ID="txtClntBranch" runat="server" AutoPostBack="true" Width="50%" Height="22px"
								Placeholder="Compusory Entry !" style="border:1px solid silver;padding:2px">
							</asp:TextBox>
							<span id="lblClntBranchErr" class="fa fa-exclamation-circle" style="color:crimson;font-size:16px;display:none;padding-left:3px"></span>
						</td>
						<td></td>
					</tr>
					<tr>
						<td>Name :</td>
						<td>
							<dx:ASPxTextBox ID="txtClntName" runat="server" Width="100%" Theme="MetropolisBlue" MaxLength="45"
								OnTextChanged="txtClntName_TextChanged" AutoPostBack="true">
								<ClientSideEvents TextChanged="function(s, e) { txtFHName.SetText(s.GetText()); }" />
								<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
									<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
								</ValidationSettings>
							</dx:ASPxTextBox>
						</td>
						<td>UCC :</td>
						<td>
							<dx:ASPxTextBox ID="txtClntUcc" runat="server" Width="50%" Theme="MetropolisBlue"></dx:ASPxTextBox>
						</td>
						<td>
							<dx:ASPxButton ID="btnSignature" runat="server" CausesValidation="false" AutoPostBack="false"
								Text="Upload Signature" HoverStyle-BackColor="Goldenrod" Theme="MetropolisBlue">
								<ClientSideEvents Click="function(s,e) { 
										$('#divWait').css('visibility', 'visible');
										$('#modalSignature').modal('show'); 
										$('#divWait').css('visibility', 'hidden');
									}" />
							</dx:ASPxButton>
							<div class="modal fade" id="modalSignature" role="dialog">
								<div class="modal-dialog modal-md">
									<!-- Modal content-->
									<div class="modal-content">
										<div class="modal-header ">
											<h4 class="modal-title"><i class="fa fa-pencil-square-o" aria-hidden="true"></i> Upload Signature</h4>
										</div>
										<div class="modal-body">
											<div class="row">
												<div class="col-xs-12">
													<asp:FileUpload ID="uldSignature" AllowMultiple="false" runat="server" CssClass="form-control input-sm" />
												</div>
											</div>
											<div class="row">
												<div class="col-xs-12">
													<img id="imgSignature" src="#" alt="Signature Preview Unavailable" class="img-responsive center-block" style="border:1px solid lightgray;padding:3px;width:100%" />
												</div>
											</div>
										</div>
										<div class="modal-footer">
											<button type="button" id="btnSigOk" data-dismiss="modal" class="btn btn-success" disabled="disabled"
												onclick="uploadImage_Ok_OnClick('tabClntReg_imgFHSignature')">
												Ok
											</button>
											<button type="button" id="btnSigRemove" data-dismiss="modal" class="btn btn-warning"
												onclick="
													document.getElementById('uldSignature').value = null;
													document.getElementById('imgSignature').src = '#';
													document.getElementById('imgFHSignature').src = '#';
												">
												Remove
											</button>
											<button type="button" id="btnSigCancel" data-dismiss="modal" class="btn btn-danger">
												Cancel
											</button>
										</div>
									</div>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</div>
		</div>

		<div class="row">
			<div class="col-xs-12">
				<dx:ASPxPageControl ID="tabClntReg" ClientInstanceName="tabClntReg" runat="server" TabPosition="Left" Theme="MetropolisBlue" Width="100%">
					<TabStyle HorizontalAlign="Right" HoverStyle-BackColor="LightSkyBlue" Width="120px" Wrap="True">
						<Paddings PaddingTop="10px" PaddingBottom="10px" PaddingLeft="5px" PaddingRight="5px"/>
					</TabStyle>
					<TabPages>
						<dx:TabPage Text="First Holder Details">
							<ContentCollection>
								<dx:ContentControl>
									<table class="table table-responsive borderless tblpadding inputTable">
										<colgroup>
											<col style="width:13%"/><col />
											<col style="width:12%"/><col />
											<col style="width:18%"/><col />
										</colgroup>
										<tr>
											<td>Ben Type :</td>
											<td class="dropDown">
												<dx:ASPxComboBox ID="cboBenType" ClientInstanceName="cboBenType" runat="server" Theme="MetropolisBlue" Width="100%" 
													OnSelectedIndexChanged="cboBenType_SelectedIndexChanged" AutoPostBack="true">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>
													<ClientSideEvents SelectedIndexChanged="function(s,e) { cboBenType_SelectedIndexChanged(); }" />
												</dx:ASPxComboBox>
											</td>
											<td>Ben Sub Type :</td>
											<td class="dropDown">
												<dx:ASPxComboBox ID="cboBenSubType" runat="server" Theme="MetropolisBlue" Width="100%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>
												</dx:ASPxComboBox>
											</td>
											<td></td>
											<td>
												<dx:ASPxCheckBox ID="chkResolution" runat="server" Text="Board of Resolution" Theme="MetropolisBlue"></dx:ASPxCheckBox>
												<dx:ASPxCheckBox ID="chkArticle" runat="server" Text="Memorandum of Article" Theme="MetropolisBlue"></dx:ASPxCheckBox>
											</td>
										</tr>
										<tr>
											<td>Ben Category :</td>
											<td class="dropDown">
												<dx:ASPxComboBox ID="cboCategory" runat="server" Theme="MetropolisBlue" Width="100%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>
												</dx:ASPxComboBox>
											</td>
											<td>Ben Occupation :</td>
											<td class="dropDown">
												<dx:ASPxComboBox ID="cboOccupation" runat="server" Theme="MetropolisBlue" Width="87%">
													<%--<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>--%>
												</dx:ASPxComboBox>
											</td>
											<td>Exchange Id :</td>
											<td class="dropDown">
												<dx:ASPxComboBox ID="cboExchangeId" runat="server" Theme="MetropolisBlue" Width="100%"></dx:ASPxComboBox>
											</td>
										</tr>
										<tr>
											<td>First Holder/Karta Name :</td>
											<td colspan="3">
												<dx:ASPxTextBox ID="txtFHName" ClientInstanceName="txtFHName" runat="server" Theme="MetropolisBlue" Width="95%" 
													ReadOnly="true" ReadOnlyStyle-ForeColor="dimgray">
												</dx:ASPxTextBox>
											</td>
											<td>Proof of Identity :</td>
											<td class="dropDown">
												<dx:ASPxComboBox ID="cboFHIdProof" runat="server" Theme="MetropolisBlue" Width="100%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>
												</dx:ASPxComboBox>
											</td>
										</tr>
										<tr>
											<td>Short Name :</td>
											<td colspan="3">
												<dx:ASPxTextBox ID="txtFHShName" runat="server" Theme="MetropolisBlue" Width="45%" MaxLength="16"></dx:ASPxTextBox>
											</td>
											<td>Proof of Address :</td>
											<td class="dropDown">
												<dx:ASPxComboBox ID="cboFHAdrProof" runat="server" Theme="MetropolisBlue" Width="100%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>
												</dx:ASPxComboBox>
											</td>
										</tr>
										<tr>
											<td>Father/Husband Name :</td>
											<td colspan="3">
												<dx:ASPxTextBox ID="txtFHFthrName" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="45">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Mother Name :</td>
											<td colspan="3">
												<dx:ASPxTextBox ID="txtFHMthrName" runat="server" Theme="MetropolisBlue" Width="95%" MaxLength="45"></dx:ASPxTextBox>
											</td>
											<td>No. of First Holder Signatories :</td>
											<td>
												<dx:ASPxSpinEdit ID="nudFHSigCount" runat="server" MinValue="0" MaxValue="10" Number="0" Width="30%" Theme="MetropolisBlue"></dx:ASPxSpinEdit>
											</td>
										</tr>
										<tr>
											<td>Email :</td>
											<td colspan="3">
												<dx:ASPxTextBox ID="txtFHEmail" ClientInstanceName="txtFHEmail" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
															ErrorText="Invalid Email !" />
														<RequiredField IsRequired="false" ErrorText="Compulsory Entry !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
													<ClientSideEvents TextChanged="function(s,e) { toLowerFields_TextChanged(s,e); txtFHEmail_TextChanged(); } " />
												</dx:ASPxTextBox>
											</td>
											<td>No. of Second Holder Signatories :</td>
											<td>
												<dx:ASPxSpinEdit ID="nudSHSigCount" runat="server" MinValue="0" MaxValue="10" Number="0" Width="30%" Theme="MetropolisBlue"></dx:ASPxSpinEdit>
											</td>
										</tr>
										<tr>
											<td>Alternate Email :</td>
											<td colspan="3">
												<dx:ASPxTextBox ID="txtFHAltEmail" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
															ErrorText="Invalid Alternate Email !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
												</dx:ASPxTextBox>
											</td>
											<td>No. of Third Holder Signatories :</td>
											<td>
												<dx:ASPxSpinEdit ID="nudTHSigCount" runat="server" MinValue="0" MaxValue="10" Number="0" Width="30%" Theme="MetropolisBlue"></dx:ASPxSpinEdit>
											</td>
										</tr>
										<tr>
											<td>Mapin :</td>
											<td colspan="3">
												<dx:ASPxTextBox ID="txtFHMapin" runat="server" Theme="MetropolisBlue" Width="45%" MaxLength="9"></dx:ASPxTextBox>
											</td>
											<td>No. of POA Mapping First Holder :</td>
											<td>
												<dx:ASPxSpinEdit ID="nudFHPoaCount" runat="server" MinValue="0" MaxValue="10" Number="0" Width="30%" Theme="MetropolisBlue"></dx:ASPxSpinEdit>
											</td>
										</tr>
										<tr>
											<td>Mobile :</td>
											<td colspan="3">
												<dx:ASPxTextBox ID="txtFHMobile" runat="server" ClientInstanceName="txtFHMobile" Theme="MetropolisBlue" MaxLength="10" Width="50%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[0-9]{10}$" 
															ErrorText="Invalid Mobile No. !" />
														<RequiredField IsRequired="false" ErrorText="Compulsory Entry !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
													<ClientSideEvents TextChanged="function(s,e) { txtFHMobile_TextChanged(); } " />
												</dx:ASPxTextBox>
											</td>
											<td>No. of POA Mapping Second Holder :</td>
											<td>
												<dx:ASPxSpinEdit ID="nudSHPoaCount" runat="server" MinValue="0" MaxValue="10" Number="0" Width="30%" Theme="MetropolisBlue"></dx:ASPxSpinEdit>
											</td>
										</tr>
										<tr>
											<td>Land Phone :</td>
											<td colspan="3">
												<dx:ASPxTextBox ID="txtFHPhone" ClientInstanceName="txtFHPhone" runat="server" Theme="MetropolisBlue" MaxLength="30" Width="50%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
															ErrorText="Invalid Phone No. !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
													<ClientSideEvents TextChanged="function(s,e) { txtFHPhone_TextChanged(); } " />
												</dx:ASPxTextBox>
											</td>
											<td>No. of POA Mapping Third Holder :</td>
											<td>
												<dx:ASPxSpinEdit ID="nudTHPoaCount" runat="server" MinValue="0" MaxValue="10" Number="0" Width="30%" Theme="MetropolisBlue"></dx:ASPxSpinEdit>
											</td>
										</tr>
										<tr>
											<td>PAN Flag :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnFHPanYes" ClientInstanceName="rbnFHPanYes" runat="server" GroupName="PanFlag" Checked="true" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell">
													<ClientSideEvents CheckedChanged="function(s, e) { rbnStateChanged(s, txtFHPan); }" />
												</dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnFHPanNo" runat="server" GroupName="PanFlag" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell">
												</dx:ASPxRadioButton>
											</td>
											<td>PAN :</td>
											<td>
												<dx:ASPxTextBox ID="txtFHPan" ClientInstanceName="txtFHPan" runat="server" Theme="MetropolisBlue" 
													MaxLength="10" Width="100%" DisabledStyle-BackColor="Control">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[A-Z]{5}[0-9]{4}[A-Z]{1}$" 
															ErrorText="Invalid PAN No. !" />
														<RequiredField IsRequired="true" ErrorText="Compulsory Entry !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
													<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); txtFHPan_TextChanged(); } " />
												</dx:ASPxTextBox>
											</td>
											<td>SMS :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnFHSmsYes" runat="server" GroupName="Sms" Checked="true" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnFHSmsNo" runat="server" GroupName="Sms" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
										</tr>
										<tr>
											<td>SEBI Regn. No. :</td>
											<td colspan="3">
												<dx:ASPxTextBox ID="txtFHSebiRegnNo" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="24"></dx:ASPxTextBox>
											</td>
											<td>Auth. Flag for First Holder :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnFHAuthYes" runat="server" GroupName="AuthFlag" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnFHAuthNo" runat="server" GroupName="AuthFlag" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
										</tr>
										<tr>
											<td>TDS :</td>
											<td colspan="3">
												<dx:ASPxTextBox ID="txtFHTds" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="20"></dx:ASPxTextBox>
											</td>
											<td>Standing Indicator :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnFHStandingYes" runat="server" GroupName="Standing" Checked="true" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnFHStandingNo" runat="server" GroupName="Standing" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
										</tr>
										<tr>
											<td>Sender Ref. No. 1 :</td>
											<td colspan="3">
												<dx:ASPxTextBox ID="txtFHSndrRef1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="35"></dx:ASPxTextBox>
											</td>
											<td>Signature Size :</td>
											<td>
												<div class="row">
													<div class="col-xs-6" style="margin-right:0; padding-right:0">
														<dx:ASPxTextBox ID="txtFHSigSize" ClientInstanceName="txtFHSigSize" runat="server" Theme="MetropolisBlue" 
															Width="100%" ReadOnly="true" ReadOnlyStyle-ForeColor="DimGray">
														</dx:ASPxTextBox>
													</div>
													<div class="col-xs-6" style="margin:0; padding-left:2px">
														<dx:ASPxBinaryImage id="imgFHSignature" ClientInstanceName="imgFHSignature" runat="server" 
															AlternateText="Signature" CssClass="img-responsive" Height="21px">
														</dx:ASPxBinaryImage>
													</div>
												</div>
											</td>
										</tr>
										<tr>
											<td>Sender Ref. No. 2 :</td>
											<td colspan="3">
												<dx:ASPxTextBox ID="txtFHSndrRef2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="35"></dx:ASPxTextBox>
											</td>
											<td>Despatch Basket :</td>
											<td>
												<ajaxToolkit:AutoCompleteExtender ID=AutoCompleteExtender1 runat="server"
													CompletionListCssClass="completionList"
													CompletionListItemCssClass="listItem"
													CompletionListHighlightedItemCssClass="itemHighlighted"
													ServiceMethod="GetDespatchBasketCompletionList"
													MinimumPrefixLength="1"
													CompletionInterval="10"
													EnableCaching="false"
													TargetControlID="txtFHDespBskt"
													FirstRowSelected="false"
													OnClientItemSelected="DespBskt_Selected">
												</ajaxToolkit:AutoCompleteExtender>
												<asp:HiddenField ID=hdnFHDespBskt runat="server" />
												<asp:TextBox ID="txtFHDespBskt" runat="server" AutoPostBack="true" Width="70%" Height="22px"
													style="border:1px solid silver;padding:2px">
												</asp:TextBox>
											</td>
										</tr>
										<tr>
											<td>Charge Basket :</td>
											<td>
												<ajaxToolkit:AutoCompleteExtender ID=AutoCompleteExtender2 runat="server"
													CompletionListCssClass="completionList"
													CompletionListItemCssClass="listItem"
													CompletionListHighlightedItemCssClass="itemHighlighted"
													ServiceMethod="GetChargeBasketCompletionList"
													MinimumPrefixLength="1"
													CompletionInterval="10"
													EnableCaching="false"
													TargetControlID="txtFHChrgBskt"
													FirstRowSelected="false"
													OnClientItemSelected="ChrgBskt_Selected">
												</ajaxToolkit:AutoCompleteExtender>
												<asp:HiddenField ID=hdnFHChrgBskt runat="server" />
												<asp:TextBox ID="txtFHChrgBskt" runat="server" AutoPostBack="true" Width="100%" Height="22px"
													style="border:1px solid silver;padding:2px">
												</asp:TextBox>
											</td>
											<td>Group Basket :</td>
											<td>
												<ajaxToolkit:AutoCompleteExtender ID=AutoCompleteExtender3 runat="server"
													CompletionListCssClass="completionList"
													CompletionListItemCssClass="listItem"
													CompletionListHighlightedItemCssClass="itemHighlighted"
													ServiceMethod="GetGroupBasketCompletionList"
													MinimumPrefixLength="1"
													CompletionInterval="10"
													EnableCaching="false"
													TargetControlID="txtFHGrpBskt"
													FirstRowSelected="false"
													OnClientItemSelected="GrpBskt_Selected">
												</ajaxToolkit:AutoCompleteExtender>
												<asp:HiddenField ID=hdnFHGrpBskt runat="server" />
												<asp:TextBox ID="txtFHGrpBskt" runat="server" AutoPostBack="true" Width="100%" Height="22px"
													style="border:1px solid silver;padding:2px">
												</asp:TextBox>
											</td>
											<td>Commission Basket :</td>
											<td>
												<ajaxToolkit:AutoCompleteExtender ID=AutoCompleteExtender4 runat="server"
													CompletionListCssClass="completionList"
													CompletionListItemCssClass="listItem"
													CompletionListHighlightedItemCssClass="itemHighlighted"
													ServiceMethod="GetCommissionBasketCompletionList"
													MinimumPrefixLength="1"
													CompletionInterval="10"
													EnableCaching="false"
													TargetControlID="txtFHCommBskt"
													FirstRowSelected="false"
													OnClientItemSelected="CommBskt_Selected">
												</ajaxToolkit:AutoCompleteExtender>
												<asp:HiddenField ID=hdnFHCommBskt runat="server" />
												<asp:TextBox ID="txtFHCommBskt" runat="server" AutoPostBack="true" Width="70%" Height="22px"
													style="border:1px solid silver;padding:2px">
												</asp:TextBox>
											</td>
										</tr>
									</table>
								</dx:ContentControl>
							</ContentCollection>
						</dx:TabPage>
						<dx:TabPage Text="First Holder Other Details">
							<ContentCollection>
								<dx:ContentControl>
									<table class="table table-responsive borderless tblpadding inputTable">
										<colgroup>
											<col style="width:18%"/><col />
											<col style="width:18%"/><col />
										</colgroup>
										<tr>
											<td>Minor Nominee Indicator :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnFHMnrNmnYes" runat="server" GroupName="Minor" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnFHMnrNmnNo" runat="server" GroupName="Minor" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
											<td>Nominee/Guardian Indicator :</td>
											<td class="dropDown">
												<dx:ASPxComboBox ID="cboFHHolderType" runat="server" Theme="MetropolisBlue" Width="50%">
													<Items>
														<dx:ListEditItem Text="No nominee" Value="" Selected="true" />
														<dx:ListEditItem Text="Nominee" Value="N" />
														<dx:ListEditItem Text="Guardian" Value="G" />
													</Items>
													<%--<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>--%>
												</dx:ASPxComboBox>
											</td>
										</tr>
										<tr>
											<td>First Holder/Minor DOB :</td>
											<td class="dateTime">
												<dx:ASPxDateEdit ID="dtFHDob" runat="server" Theme="MetropolisBlue"
													DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy" Width="50%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>
												</dx:ASPxDateEdit>
											</td>
											<td>Nominee DOB :</td>
											<td class="dateTime">
												<dx:ASPxDateEdit ID="dtFHNmnDob" runat="server" Theme="MetropolisBlue"
													DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy" Width="50%">
												</dx:ASPxDateEdit>
											</td>
										</tr>
										<tr>
											<td>Minor Name :</td>
											<td>
												<dx:ASPxTextBox ID="txtFHMnrName" runat="server" Theme="MetropolisBlue" Width="93%" MaxLength="45"></dx:ASPxTextBox>
											</td>
											<td>Nominee Name :</td>
											<td>
												<dx:ASPxTextBox ID="txtFHNmnName" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="45"></dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Minor Guardian Name :</td>
											<td>
												<dx:ASPxTextBox ID="txtFHMnrGrdnName" runat="server" Theme="MetropolisBlue" Width="93%" MaxLength="45"></dx:ASPxTextBox>
											</td>
											<td>Nominee Guardian Name :</td>
											<td>
												<dx:ASPxTextBox ID="txtFHNmnGrdnName" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="45"></dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Bank A/C Type :</td>
											<td class="dropDown">
												<dx:ASPxComboBox ID="cboFHBnkAcType" runat="server" Theme="MetropolisBlue" Width="50%">
													<Items>
														<dx:ListEditItem Text="Savings" Value="10" Selected="true" />
														<dx:ListEditItem Text="Current" Value="11" />
														<dx:ListEditItem Text="Others" Value="13" />
													</Items>
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>
												</dx:ASPxComboBox>
											</td>
										</tr>
										<tr>
											<td>Bank A/C No. :</td>
											<td>
												<dx:ASPxTextBox ID="txtFHBnkAcNo" runat="server" Theme="MetropolisBlue" Width="50%" MaxLength="30">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>IFSC :</td>
											<td>
												<dx:ASPxTextBox ID="txtFHIfsc" runat="server" Theme="MetropolisBlue" MaxLength="11" Width="50%"
													OnTextChanged="txtFHIfsc_TextChanged" AutoPostBack="true">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[A-Z]{4}0[0-9A-Z]{6}$" 
															ErrorText="Invalid IFSC !" />
														<RequiredField IsRequired="false" ErrorText="Compulsory Entry !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
												</dx:ASPxTextBox>
											</td>
											<td>MICR No. :</td>
											<td>
												<dx:ASPxTextBox ID="txtFHMicrNo" runat="server" Theme="MetropolisBlue" MaxLength="9" Width="70%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[0-9]{9}$" 
															ErrorText="Invalid MICR !" />
														<RequiredField IsRequired="false" ErrorText="Compulsory Entry !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Bank Name :</td>
											<td>
												<dx:ASPxTextBox ID="txtFHBnkName" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="35">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>
												</dx:ASPxTextBox>
											</td>
											<td>Family Email Flag :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnFHFmlyEmailYes" runat="server" GroupName="FmlyEmail" Checked="true" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnFHFlmyEmailNo" runat="server" GroupName="FmlyEmail" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
										</tr>
										<tr>
											<td>RBI Reference No. :</td>
											<td>
												<dx:ASPxTextBox ID="txtFHRbiRefNo" runat="server" Theme="MetropolisBlue" Width="93%" MaxLength="50"></dx:ASPxTextBox>
											</td>
											<td>Family SMS Flag :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnFHFmlyMobYes" runat="server" GroupName="FmlyMob" Checked="true" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnFHFmlyMobNo" runat="server" GroupName="FmlyMob" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
										</tr>
										<tr>
											<td>RBI Approved Date :</td>
											<td class="dateTime">
												<dx:ASPxDateEdit ID="dtFHRbiAprv" runat="server" Theme="MetropolisBlue"
													DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy" Width="50%">
												</dx:ASPxDateEdit>
											</td>
											<td>e-Statement Flag :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnFHStmntYes" runat="server" GroupName="eStatement" Checked="true" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnFHStmntNo" runat="server" GroupName="eStatement" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
										</tr>
										<tr>
											<td>Commodity :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnFHCmdtyYes" runat="server" GroupName="Commodity" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnFHCmdtyNo" runat="server" GroupName="Commodity" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
											<td>Bsda :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnFHBsdaYes" runat="server" GroupName="Bsda" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnFHBsdaNo" runat="server" GroupName="Bsda" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
										</tr>
										<tr>
											<td>Rgess :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnFHRgessYes" runat="server" GroupName="Regess" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnFHRgessNo" runat="server" GroupName="Regess" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
											<td>Beneficiary Address Local :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnFHLclAdrYes" runat="server" GroupName="BenLocalAdd" Checked="true" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnFHLclAdrNo" runat="server" GroupName="BenLocalAdd" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
										</tr>
										<tr>
											<td>Auto Pledge :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnFHPledgeYes" runat="server" GroupName="AtPldg" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnFHPledgeNo" runat="server" GroupName="AtPldg" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
											<td>Aadhaar :</td>
											<td>
												<dx:ASPxTextBox ID="txtFHAadhaar" ClientInstanceName="txtFHAadhaar" runat="server" Theme="MetropolisBlue" MaxLength="12" Width="70%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp" 
														EnableCustomValidation="true" ErrorText="Compulsory Entry !">
														<RegularExpression 
															ValidationExpression="^[0-9]{12}$" 
															ErrorText="Invalid Aadhaar No. !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
													<ClientSideEvents TextChanged="function(s,e) {  toUpperFields_TextChanged(s,e); txtFHAadhaar_TextChanged(); }" />
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td colspan="3">
												Receive Annual Reports, AGM notices and other communication from Issuers
												& RTAsin physical form for first holder :
											</td>
											<td>
												<dx:ASPxRadioButton ID="rbnFHRtaYes" runat="server" GroupName="FHRta" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnFHRtaNo" runat="server" GroupName="FHRta" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
										</tr>
									</table>
								</dx:ContentControl>
							</ContentCollection>
						</dx:TabPage>
						<dx:TabPage Text="Second Holder Details">
							<ContentCollection>
								<dx:ContentControl>
									<table class="table table-responsive borderless tblpadding inputTable">
										<colgroup>
											<col style="width:18%"/><col />
											<col style="width:14%"/><col />
										</colgroup>
										<tr>
											<td>Second Holder/HUF Name :</td>
											<td>
												<dx:ASPxTextBox ID="txtSHName" ClientInstanceName="txtSHName" runat="server" Theme="MetropolisBlue" Width="93%" MaxLength="45">
													<ClientSideEvents TextChanged="function(s,e) { txtSHName_TextChanged(); }" />
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Father/Husband Name:</td>
											<td>
												<dx:ASPxTextBox ID="txtSHFthrName" ClientInstanceName="txtSHFthrName" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="45">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp" 
														EnableCustomValidation="true" ErrorText="Compulsory Entry !">
													</ValidationSettings>
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Mother Name:</td>
											<td>
												<dx:ASPxTextBox ID="txtSHMthrName" runat="server" Theme="MetropolisBlue" Width="93%" MaxLength="45"></dx:ASPxTextBox>
											</td>
										</tr>
										<tr>											
											<td>DOB :</td>
											<td class="dateTime">
												<dx:ASPxDateEdit ID="dtSHDob" ClientInstanceName="dtSHDob" runat="server" Theme="MetropolisBlue"
													DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy" Width="50%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp" 
														EnableCustomValidation="true" ErrorText="Compulsory Entry !">
													</ValidationSettings>
												</dx:ASPxDateEdit>
											</td>
										</tr>
										<tr>
											<td>Email :</td>
											<td>
												<dx:ASPxTextBox ID="txtSHEmail" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
															ErrorText="Invalid Email !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
													<ClientSideEvents TextChanged="function(s,e) { toLowerFields_TextChanged(s,e); } " />
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Mapin :</td>
											<td>
												<dx:ASPxTextBox ID="txtSHMapin" runat="server" Theme="MetropolisBlue" Width="43%" MaxLength="9"></dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Mobile :</td>
											<td>
												<dx:ASPxTextBox ID="txtSHMobile" runat="server" Theme="MetropolisBlue" MaxLength="10" Width="50%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[0-9]{10}$" 
															ErrorText="Invalid Mobile No. !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
												</dx:ASPxTextBox>
											</td>
											<td>Land Phone :</td>
											<td>
												<dx:ASPxTextBox ID="txtSHPhone" runat="server" Theme="MetropolisBlue" MaxLength="30" Width="50%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
															ErrorText="Invalid Phone No. !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Aadhaar :</td>
											<td>
												<dx:ASPxTextBox ID="txtSHAadhaar" runat="server" Theme="MetropolisBlue" MaxLength="12" Width="50%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[0-9]{12}$" 
															ErrorText="Invalid Aadhaar No. !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
													<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>PAN Flag :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnSHPanYes" ClientInstanceName="rbnSHPanYes" runat="server" GroupName="SecHldrPan" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell">
													<ClientSideEvents CheckedChanged="function(s, e) { rbnStateChanged(s, txtSHPan); }" />
												</dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnSHPanNo" runat="server" GroupName="SecHldrPan" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell">
												</dx:ASPxRadioButton>
											</td>
											<td>PAN :</td>
											<td>
												<dx:ASPxTextBox ID="txtSHPan" ClientInstanceName="txtSHPan" runat="server" Theme="MetropolisBlue" 
													MaxLength="10" Width="50%" DisabledStyle-BackColor="Control">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[A-Z]{5}[0-9]{4}[A-Z]{1}$" 
															ErrorText="Invalid PAN No. !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
													<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>SMS :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnSHSmsYes" runat="server" GroupName="SecHldrSms" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnSHSmsNo" runat="server" GroupName="SecHldrSms" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
											<td>Email/RTA Download :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnSHRtaYes" runat="server" GroupName="SHRta" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnSHRtaNo" runat="server" GroupName="SHRta" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
										</tr>
										<tr>
											<td>Family Email Flag :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnSHFmlyEmailYes" runat="server" GroupName="SecHldrFmlyEmail" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnSHFmlyEmailNo" runat="server" GroupName="SecHldrFmlyEmail" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
											<td>Family Mobile Flag :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnSHFmlyMobYes" runat="server" GroupName="SecHldrFmlyMobile" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnSHFmlyMobNo" runat="server" GroupName="SecHldrFmlyMobile" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
										</tr>
									</table>
								</dx:ContentControl>
							</ContentCollection>
						</dx:TabPage>
						<dx:TabPage Text="Third Holder Details">
							<ContentCollection>
								<dx:ContentControl>
									<table class="table table-responsive borderless tblpadding inputTable">
										<colgroup>
											<col style="width:18%"/><col />
											<col style="width:14%"/><col />
										</colgroup>
										<tr>
											<td>Third Holder Name :</td>
											<td>
												<dx:ASPxTextBox ID="txtTHName" ClientInstanceName="txtTHName" runat="server" Theme="MetropolisBlue" Width="93%" MaxLength="45">
													<ClientSideEvents TextChanged="function(s,e) { txtTHName_TextChanged(); }" />
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Father/Husband Name:</td>
											<td>
												<dx:ASPxTextBox ID="txtTHFthrName" ClientInstanceName="txtTHFthrName" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="45">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp" 
														EnableCustomValidation="true" ErrorText="Compulsory Entry !">
													</ValidationSettings>
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Mother Name:</td>
											<td>
												<dx:ASPxTextBox ID="txtTHMthrName" runat="server" Theme="MetropolisBlue" Width="93%" MaxLength="45"></dx:ASPxTextBox>
											</td>
										</tr>
										<tr>											
											<td>DOB :</td>
											<td class="dateTime">
												<dx:ASPxDateEdit ID="dtTHDob" ClientInstanceName="dtTHDob" runat="server" Theme="MetropolisBlue"
													DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy" Width="50%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp" 
														EnableCustomValidation="true" ErrorText="Compulsory Entry !">
													</ValidationSettings>
												</dx:ASPxDateEdit>
											</td>
										</tr>
										<tr>
											<td>Email :</td>
											<td>
												<dx:ASPxTextBox ID="txtTHEmail" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
															ErrorText="Invalid Email !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
													<ClientSideEvents TextChanged="function(s,e) { toLowerFields_TextChanged(s,e); } " />
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Mapin :</td>
											<td>
												<dx:ASPxTextBox ID="txtTHMapin" runat="server" Theme="MetropolisBlue" Width="43%" MaxLength="9"></dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Mobile :</td>
											<td>
												<dx:ASPxTextBox ID="txtTHMobile" runat="server" Theme="MetropolisBlue" MaxLength="10" Width="50%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[0-9]{10}$" 
															ErrorText="Invalid Mobile No. !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
												</dx:ASPxTextBox>
											</td>
											<td>Land Phone :</td>
											<td>
												<dx:ASPxTextBox ID="txtTHPhone" runat="server" Theme="MetropolisBlue" MaxLength="30" Width="50%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
															ErrorText="Invalid Phone No. !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Aadhaar :</td>
											<td>
												<dx:ASPxTextBox ID="txtTHAadhaar" runat="server" Theme="MetropolisBlue" MaxLength="12" Width="50%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[0-9]{12}$" 
															ErrorText="Invalid Aadhaar No. !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
													<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>PAN Flag :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnTHPanYes" ClientInstanceName="rbnTHPanYes" runat="server" GroupName="ThrdHldrPan" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell">
													<ClientSideEvents CheckedChanged="function(s, e) { rbnStateChanged(s, txtTHPan); }" />
												</dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnTHPanNo" runat="server" GroupName="ThrdHldrPan" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
											<td>PAN :</td>
											<td>
												<dx:ASPxTextBox ID="txtTHPan" ClientInstanceName="txtTHPan" runat="server" Theme="MetropolisBlue" 
													MaxLength="10" Width="50%" DisabledStyle-BackColor="Control">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[A-Z]{5}[0-9]{4}[A-Z]{1}$" 
															ErrorText="Invalid PAN No. !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
													<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>SMS :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnTHSmsYes" runat="server" GroupName="ThrdHldrSms" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnTHSmsNo" runat="server" GroupName="ThrdHldrSms" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
											<td>Email/RTA Download :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnTHRtaYes" runat="server" GroupName="THRta" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnTHRtaNo" runat="server" GroupName="THRta" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
										</tr>
										<tr>
											<td>Family Email Flag :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnTHFmlyEmailYes" runat="server" GroupName="ThrdHldrFmlyEmail" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnTHFmlyEmailNo" runat="server" GroupName="ThrdHldrFmlyEmail" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
											<td>Family Mobile Flag :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnTHFmlyMobYes" runat="server" GroupName="ThrdHldrFmlyMobile" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnTHFmlyMobNo" runat="server" GroupName="ThrdHldrFmlyMobile" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
										</tr>
									</table>
								</dx:ContentControl>
							</ContentCollection>
						</dx:TabPage>
						<dx:TabPage Text="Address Details">
							<ContentCollection>
								<dx:ContentControl>
									<dx:ASPxPageControl ID="tabClntAddress" ClientInstanceName="tabClntAddress" runat="server" Theme="MetropolisBlue" Width="100%">
										<TabStyle HoverStyle-BackColor="LightSkyBlue">
											<HoverStyle BackColor="LightSkyBlue"></HoverStyle>
										</TabStyle>
										<TabPages>
											<dx:TabPage Text="First Holder">
												<ContentCollection>
													<dx:ContentControl>
														<dx:ASPxPageControl ID="tabClntAdrFstHldr" ClientInstanceName="tabClntAdrFstHldr" runat="server" TabPosition="Left" Theme="MetropolisBlue" Width="100%">
															<TabStyle HorizontalAlign="Right" HoverStyle-BackColor="LightSkyBlue" Width="220px" Wrap="True">
																<Paddings Padding="5px"/>
															</TabStyle>
															<TabPages>
																<dx:TabPage Text="Local">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHLclAdr1" ClientInstanceName="txtFHLclAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
																							</ValidationSettings>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHLclAdr2" ClientInstanceName="txtFHLclAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
																							</ValidationSettings>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHLclAdr3" ClientInstanceName="txtFHLclAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
																							</ValidationSettings>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHLclAdr4" ClientInstanceName="txtFHLclAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
																							</ValidationSettings>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboFHLclState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHLclPin" ClientInstanceName="txtFHLclPin" runat="server" Theme="MetropolisBlue" Width="50%" MaxLength="6">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																								<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Mobile :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHLclMob" ClientInstanceName="txtFHLclMob" ReadOnly="true" runat="server" MaxLength="10" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{10}$" 
																									ErrorText="Invalid Mobile No. !" />
																								<RequiredField  IsRequired="false" ErrorText="Compulsory Entry !"/>
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Email :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHLclEmail" ClientInstanceName="txtFHLclEmail" ReadOnly="true" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
																									ErrorText="Invalid Email !" />
																								<RequiredField  IsRequired="false" ErrorText="Compulsory Entry !"/>
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toLowerFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHLclPhone" ClientInstanceName="txtFHLclPhone" ReadOnly="true" runat="server" MaxLength="24" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHLclFax" ClientInstanceName="txtFHLclFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>PAN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHLclPan" ClientInstanceName="txtFHLclPan" ReadOnly="true" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="10">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[A-Z]{5}[0-9]{4}[A-Z]{1}$" 
																									ErrorText="Invalid PAN No. !" />
																								<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																					<td>Aadhaar :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHLclAadhaar" ClientInstanceName="txtFHLclAadhaar" runat="server" ReadOnly="true" Theme="MetropolisBlue" Width="70%" MaxLength="12">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp" 
																								EnableCustomValidation="true" ErrorText="Compulsory Entry !">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{12}$" 
																									ErrorText="Invalid Aadhaar No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>Share(%) :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHLclShare" runat="server" Theme="MetropolisBlue" Width="30%" MaxLength="3"></dx:ASPxTextBox>
																					</td>
																				</tr>--%>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="Bank">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHBnkAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
																							</ValidationSettings>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHBnkAdr2" runat="server" Theme="MetropolisBlue" Width="93%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHBnkAdr3" runat="server" Theme="MetropolisBlue" Width="93%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHBnkAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
																							</ValidationSettings>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboFHBnkState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHBnkPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																								<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<%--<td>Mobile :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHBnkMob" runat="server" MaxLength="10" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{10}$" 
																									ErrorText="Invalid Mobile No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>--%>
																					<td>Email :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHBnkEmail" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
																									ErrorText="Invalid Email !" />
																								<RequiredField  IsRequired="false" ErrorText="Compulsory Entry !"/>
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toLowerFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHBnkPhone" runat="server" MaxLength="24" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																								<RequiredField  IsRequired="false" ErrorText="Compulsory Entry !"/>
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHBnkFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>PAN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHBnkPan" runat="server" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[A-Z]{5}[0-9]{4}[A-Z]{1}$" 
																									ErrorText="Invalid PAN No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																					<td>Aadhaar :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHBnkAadhaar" runat="server" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{12}$" 
																									ErrorText="Invalid Aadhaar No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Share(%) :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHBnkShare" runat="server" Theme="MetropolisBlue" Width="30%"></dx:ASPxTextBox>
																					</td>
																				</tr>--%>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="1st Nominee Address">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td></td>
																					<td>
																						<dx:ASPxCheckBox ID="chkFHFstNmnSameLocal" ClientInstanceName="chkFHFstNmnSameLocal" runat="server" 
																							Text="1st Nominee Address same as Local Address" Theme="MetropolisBlue">
																							<ClientSideEvents CheckedChanged="function(s,e) { chkFHFstNmnSameLocal_CheckedChanged(); }" />
																						</dx:ASPxCheckBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHFstNmnAdr1" ClientInstanceName="txtFHFstNmnAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHFstNmnAdr2" ClientInstanceName="txtFHFstNmnAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHFstNmnAdr3" ClientInstanceName="txtFHFstNmnAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHFstNmnAdr4" ClientInstanceName="txtFHFstNmnAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboFHFstNmnState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstNmnPin" ClientInstanceName="txtFHFstNmnPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Mobile :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstNmnMob" runat="server" MaxLength="10" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{10}$" 
																									ErrorText="Invalid Mobile No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Email :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstNmnEmail" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
																									ErrorText="Invalid Email !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toLowerFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstNmnPhone" ClientInstanceName="txtFHFstNmnPhone" runat="server" MaxLength="24" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstNmnFax" ClientInstanceName="txtFHFstNmnFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>PAN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstNmnPan" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="10">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[A-Z]{5}[0-9]{4}[A-Z]{1}$" 
																									ErrorText="Invalid PAN No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																					<td>Aadhaar :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstNmnAadhaar" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="12">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{12}$" 
																									ErrorText="Invalid Aadhaar No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Share(%) :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstNmnShare" runat="server" Theme="MetropolisBlue" Width="30%" MaxLength="3"></dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="Foreign / Correspondence Address">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td></td>
																					<td>
																						<dx:ASPxCheckBox ID="chkFHCorrSameLocal" ClientInstanceName="chkFHCorrSameLocal" runat="server" 
																							Text="Foreign / Correspondence Address same as Local Address" Theme="MetropolisBlue">
																							<ClientSideEvents CheckedChanged="function(s,e) { chkFHCorrSameLocal_CheckedChanged(); }" />
																						</dx:ASPxCheckBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHCorrAdr1" ClientInstanceName="txtFHCorrAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHCorrAdr2" ClientInstanceName="txtFHCorrAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHCorrAdr3" ClientInstanceName="txtFHCorrAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHCorrAdr4" ClientInstanceName="txtFHCorrAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboFHCorrState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHCorrPin" ClientInstanceName="txtFHCorrPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Mobile :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHCorrMob" ClientInstanceName="txtFHCorrMob" runat="server" MaxLength="10" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{10}$" 
																									ErrorText="Invalid Mobile No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Email :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHCorrEmail" ClientInstanceName="txtFHCorrEmail" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
																									ErrorText="Invalid Email !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toLowerFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHCorrPhone" ClientInstanceName="txtFHCorrPhone" runat="server" MaxLength="24" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHCorrFax" ClientInstanceName="txtFHCorrFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>PAN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHCorrPan" ClientInstanceName="txtFHCorrPan" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="10">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[A-Z]{5}[0-9]{4}[A-Z]{1}$" 
																									ErrorText="Invalid PAN No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																					<td>Aadhaar :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHCorrAadhaar" ClientInstanceName="txtFHCorrAadhaar" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="12">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{12}$" 
																									ErrorText="Invalid Aadhaar No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>Share(%) :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHCorrShare" runat="server" Theme="MetropolisBlue" Width="30%" MaxLength="3"></dx:ASPxTextBox>
																					</td>
																				</tr>--%>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="1st Minor Nominee Guardian Address">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHFstGrdAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHFstGrdAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHFstGrdAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHFstGrdAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboFHFstGrdState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstGrdPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Mobile :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstGrdMob" runat="server" MaxLength="10" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{10}$" 
																									ErrorText="Invalid Mobile No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Email :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstGrdEmail" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
																									ErrorText="Invalid Email !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toLowerFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstGrdPhone" runat="server" MaxLength="24" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstGrdFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>PAN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstGrdPan" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="10">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[A-Z]{5}[0-9]{4}[A-Z]{1}$" 
																									ErrorText="Invalid PAN No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																					<td>Aadhaar :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstGrdAadhaar" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="12">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{12}$" 
																									ErrorText="Invalid Aadhaar No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Share(%) :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHFstGrdShare" runat="server" Theme="MetropolisBlue" Width="30%" MaxLength="3"></dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="2nd Nominee Address">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td></td>
																					<td>
																						<dx:ASPxCheckBox ID="chkFHSecNmnSameLocal" ClientInstanceName="chkFHSecNmnSameLocal" runat="server" 
																							Text="2nd Nominee Address same as Local Address" Theme="MetropolisBlue">
																							<ClientSideEvents CheckedChanged="function(s,e) { chkFHSecNmnSameLocal_CheckedChanged(); }" />
																						</dx:ASPxCheckBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHSecNmnAdr1" ClientInstanceName="txtFHSecNmnAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHSecNmnAdr2" ClientInstanceName="txtFHSecNmnAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHSecNmnAdr3" ClientInstanceName="txtFHSecNmnAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHSecNmnAdr4" ClientInstanceName="txtFHSecNmnAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboFHSecNmnState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecNmnPin" ClientInstanceName="txtFHSecNmnPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Mobile :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecNmnMob" runat="server" MaxLength="10" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{10}$" 
																									ErrorText="Invalid Mobile No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Email :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecNmnEmail" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
																									ErrorText="Invalid Email !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toLowerFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecNmnPhone" ClientInstanceName="txtFHSecNmnPhone" runat="server" MaxLength="24" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecNmnFax" ClientInstanceName="txtFHSecNmnFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>PAN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecNmnPan" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="10">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[A-Z]{5}[0-9]{4}[A-Z]{1}$" 
																									ErrorText="Invalid PAN No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																					<td>Aadhaar :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecNmnAadhaar" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="12">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{12}$" 
																									ErrorText="Invalid Aadhaar No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Share(%) :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecNmnShare" runat="server" Theme="MetropolisBlue" Width="30%" MaxLength="3"></dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="2nd Minor Nominee Guardian Address">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHSecGrdAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHSecGrdAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHSecGrdAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHSecGrdAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboFHSecGrdState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecGrdPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Mobile :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecGrdMob" runat="server" MaxLength="10" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{10}$" 
																									ErrorText="Invalid Mobile No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Email :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecGrdEmail" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
																									ErrorText="Invalid Email !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toLowerFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecGrdPhone" runat="server" MaxLength="24" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecGrdFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>PAN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecGrdPan" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="10">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[A-Z]{5}[0-9]{4}[A-Z]{1}$" 
																									ErrorText="Invalid PAN No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																					<td>Aadhaar :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecGrdAadhaar" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="12">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{12}$" 
																									ErrorText="Invalid Aadhaar No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Share(%) :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHSecGrdShare" runat="server" Theme="MetropolisBlue" Width="30%" MaxLength="3"></dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="3rd Nominee Address">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td></td>
																					<td>
																						<dx:ASPxCheckBox ID="chkFHThrdNmnSameLocal" ClientInstanceName="chkFHThrdNmnSameLocal" runat="server" 
																							Text="3rd Nominee Address same as Local Address" Theme="MetropolisBlue">
																							<ClientSideEvents CheckedChanged="function(s,e) { chkFHThrdNmnSameLocal_CheckedChanged(); }" />
																						</dx:ASPxCheckBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHThrdNmnAdr1" ClientInstanceName="txtFHThrdNmnAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHThrdNmnAdr2" ClientInstanceName="txtFHThrdNmnAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHThrdNmnAdr3" ClientInstanceName="txtFHThrdNmnAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHThrdNmnAdr4" ClientInstanceName="txtFHThrdNmnAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboFHThrdNmnState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdNmnPin" ClientInstanceName="txtFHThrdNmnPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Mobile :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdNmnMob" runat="server" MaxLength="10" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{10}$" 
																									ErrorText="Invalid Mobile No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Email :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdNmnEmail" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
																									ErrorText="Invalid Email !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toLowerFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdNmnPhone" ClientInstanceName="txtFHThrdNmnPhone" runat="server" MaxLength="24" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdNmnFax" ClientInstanceName="txtFHThrdNmnFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>PAN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdNmnPan" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="10">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[A-Z]{5}[0-9]{4}[A-Z]{1}$" 
																									ErrorText="Invalid PAN No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																					<td>Aadhaar :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdNmnAadhaar" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="12">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{12}$" 
																									ErrorText="Invalid Aadhaar No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Share(%) :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdNmnShare" runat="server" Theme="MetropolisBlue" Width="30%" MaxLength="3"></dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="3rd Minor Nominee Guardian Address">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHThrdGrdAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHThrdGrdAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHThrdGrdAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtFHThrdGrdAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboFHThrdGrdState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdGrdPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Mobile :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdGrdMob" runat="server" MaxLength="10" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{10}$" 
																									ErrorText="Invalid Mobile No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Email :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdGrdEmail" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
																									ErrorText="Invalid Email !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toLowerFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdGrdPhone" runat="server" MaxLength="24" Theme="MetropolisBlue" Width="70%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdGrdFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>PAN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdGrdPan" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="10">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[A-Z]{5}[0-9]{4}[A-Z]{1}$" 
																									ErrorText="Invalid PAN No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																					<td>Aadhaar :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdGrdAadhaar" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="12">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{12}$" 
																									ErrorText="Invalid Aadhaar No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																							<ClientSideEvents TextChanged="function(s,e) { toUpperFields_TextChanged(s,e); } " />
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Share(%) :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtFHThrdGrdShare" runat="server" Theme="MetropolisBlue" Width="30%" MaxLength="3"></dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
															</TabPages>
														</dx:ASPxPageControl>
													</dx:ContentControl>
												</ContentCollection>
											</dx:TabPage>
											<dx:TabPage Text="Second Holder">
												<ContentCollection>
													<dx:ContentControl>
														<dx:ASPxPageControl ID="tabClntAdrSecHldr" ClientInstanceName="tabClntAdrSecHldr" runat="server" TabPosition="Left" Theme="MetropolisBlue" Width="100%">
															<TabStyle HorizontalAlign="Right" HoverStyle-BackColor="LightSkyBlue" Width="220px" Wrap="True">
																<Paddings Padding="5px"/>
															</TabStyle>
															<TabPages>
																<dx:TabPage Text="Local">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHLclAdr1" ClientInstanceName="txtSHLclAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHLclAdr2" ClientInstanceName="txtSHLclAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHLclAdr3" ClientInstanceName="txtSHLclAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHLclAdr4" ClientInstanceName="txtSHLclAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboSHLclState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHLclPin" ClientInstanceName="txtSHLclPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHLclPhone" ClientInstanceName="txtSHLclPhone" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHLclFax" ClientInstanceName="txtSHLclFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="Bank">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHBnkAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHBnkAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHBnkAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHBnkAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboSHBnkState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHBnkPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHBnkPhone" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHBnkFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="Nominee Address">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHNmnAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHNmnAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHNmnAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHNmnAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboSHNmnState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHNmnPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHNmnPhone" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHNmnFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="Foreign / Correspondence Address">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td></td>
																					<td>
																						<dx:ASPxCheckBox ID="chkSHCorrSameLocal" ClientInstanceName="chkSHCorrSameLocal" runat="server" 
																							Text="Foreign / Correspondence Address same as Local Address" Theme="MetropolisBlue">
																							<ClientSideEvents CheckedChanged="function(s,e) { chkSHCorrSameLocal_CheckedChanged(); }" />
																						</dx:ASPxCheckBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHCorrAdr1" ClientInstanceName="txtSHCorrAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHCorrAdr2" ClientInstanceName="txtSHCorrAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHCorrAdr3" ClientInstanceName="txtSHCorrAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHCorrAdr4" ClientInstanceName="txtSHCorrAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboSHCorrState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHCorrPin" ClientInstanceName="txtSHCorrPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHCorrPhone" ClientInstanceName="txtSHCorrPhone" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHCorrFax" ClientInstanceName="txtSHCorrFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="Minor Nominee Guardian Address">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHGrdAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHGrdAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHGrdAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtSHGrdAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboSHGrdState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHGrdPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHGrdPhone" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtSHGrdFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
															</TabPages>
														</dx:ASPxPageControl>
													</dx:ContentControl>
												</ContentCollection>
											</dx:TabPage>
											<dx:TabPage Text="Third Holder">
												<ContentCollection>
													<dx:ContentControl>
														<dx:ASPxPageControl ID="tabClntAdrThrdHldr" ClientInstanceName="tabClntAdrThrdHldr" runat="server" TabPosition="Left" Theme="MetropolisBlue" Width="100%">
															<TabStyle HorizontalAlign="Right" HoverStyle-BackColor="LightSkyBlue" Width="220px" Wrap="True">
																<Paddings Padding="5px"/>
															</TabStyle>
															<TabPages>
																<dx:TabPage Text="Local">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHLclAdr1" ClientInstanceName="txtTHLclAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHLclAdr2" ClientInstanceName="txtTHLclAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHLclAdr3" ClientInstanceName="txtTHLclAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHLclAdr4" ClientInstanceName="txtTHLclAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboTHLclState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHLclPin" ClientInstanceName="txtTHLclPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHLclPhone" ClientInstanceName="txtTHLclPhone" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHLclFax" ClientInstanceName="txtTHLclFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="Bank">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHBnkAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHBnkAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHBnkAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHBnkAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboTHBnkState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHBnkPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHBnkPhone" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHBnkFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="Nominee Address">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHNmnAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHNmnAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHNmnAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHNmnAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboTHNmnState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHNmnPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHNmnPhone" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHNmnFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="Foreign / Correspondence Address">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td></td>
																					<td>
																						<dx:ASPxCheckBox ID="chkTHCorrSameLocal" ClientInstanceName="chkTHCorrSameLocal" runat="server" 
																							Text="Foreign / Correspondence Address same as Local Address" Theme="MetropolisBlue">
																							<ClientSideEvents CheckedChanged="function(s,e) { chkTHCorrSameLocal_CheckedChanged(); }" />
																						</dx:ASPxCheckBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHCorrAdr1" ClientInstanceName="txtTHCorrAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHCorrAdr2" ClientInstanceName="txtTHCorrAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHCorrAdr3" ClientInstanceName="txtTHCorrAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHCorrAdr4" ClientInstanceName="txtTHCorrAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboTHCorrState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHCorrPin" ClientInstanceName="txtTHCorrPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHCorrPhone" ClientInstanceName="txtTHCorrPhone" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHCorrFax" ClientInstanceName="txtTHCorrFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
																<dx:TabPage Text="Minor Nominee Guardian Address">
																	<ContentCollection>
																		<dx:ContentControl>
																			<table class="table table-responsive borderless tblpadding inputTable">
																				<colgroup>
																					<col style="width:10%"/><col />
																					<col style="width:10%"/><col />
																				</colgroup>
																				<tr>
																					<td>Address :</td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHGrdAdr1" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHGrdAdr2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHGrdAdr3" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td></td>
																					<td colspan="2">
																						<dx:ASPxTextBox ID="txtTHGrdAdr4" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="36"></dx:ASPxTextBox>
																					</td>
																				</tr>
																				<%--<tr>
																					<td>State :</td>
																					<td colspan="2" class="dropDown">
																						<dx:ASPxComboBox ID="cboTHGrdState" runat="server" Theme="MetropolisBlue" Width="70%"></dx:ASPxComboBox>
																					</td>
																				</tr>--%>
																				<tr>
																					<td>PIN :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHGrdPin" runat="server" MaxLength="6" Theme="MetropolisBlue" Width="50%">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^[0-9]{6}$" 
																									ErrorText="Invalid PIN Code !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																				<tr>
																					<td>Phone :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHGrdPhone" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Phone No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																					<td>Fax :</td>
																					<td>
																						<dx:ASPxTextBox ID="txtTHGrdFax" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="24">
																							<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
																								<RegularExpression 
																									ValidationExpression="^(([0-9]+)|([0-9]+\-[0-9]+)|([0-9]+\-[0-9]+\-[0-9]+))$" 
																									ErrorText="Invalid Fax No. !" />
																							</ValidationSettings>
																							<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
																						</dx:ASPxTextBox>
																					</td>
																				</tr>
																			</table>
																		</dx:ContentControl>
																	</ContentCollection>
																</dx:TabPage>
															</TabPages>
														</dx:ASPxPageControl>
													</dx:ContentControl>
												</ContentCollection>
											</dx:TabPage>
										</TabPages>
									</dx:ASPxPageControl>
								</dx:ContentControl>
							</ContentCollection>
						</dx:TabPage>
						<dx:TabPage Text="Authorised Signatory">
							<ContentCollection>
								<dx:ContentControl>
									<div class="row">
										<div class="col-sm-8">
											<h5 class="subHeading">First Holder</h5>
											<table class="table table-responsive borderless tblpadding inputTable" style="width:100%">
												<colgroup>
													<col style="width:20%"/><col />
												</colgroup>
												<tr><td colspan="2"></td></tr>
												<tr>
													<td>Name :</td>
													<td>
														<dx:ASPxTextBox ID="txtFHSig" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="135"></dx:ASPxTextBox>
													</td>
												</tr>
												<tr>
													<td>Reference No. :</td>
													<td>
														<dx:ASPxTextBox ID="txtFHSigRef" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="10"></dx:ASPxTextBox>
													</td>
												</tr>
												<tr>
													<td>Proof of Identity :</td>
													<td class="dropDown">
														<dx:ASPxComboBox ID="cboFHSigIdProof" runat="server" Theme="MetropolisBlue" Width="60%"></dx:ASPxComboBox>
													</td>
												</tr>
												<tr>
													<td>Proof of Address :</td>
													<td class="dropDown">
														<dx:ASPxComboBox ID="cboFHSigAdrProof" runat="server" Theme="MetropolisBlue" Width="60%"></dx:ASPxComboBox>
													</td>
												</tr>
											</table>
										</div>
									</div>
									<div class="row">
										<div class="col-sm-4"></div>
										<div class="col-sm-8">
											<h5 class="subHeading">Second Holder</h5>
											<table class="table table-responsive borderless tblpadding inputTable" style="width:100%">
												<colgroup>
													<col style="width:20%"/><col />
												</colgroup>
												<tr><td colspan="2"></td></tr>
												<tr>
													<td>Name :</td>
													<td>
														<dx:ASPxTextBox ID="txtSHSig" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="135"></dx:ASPxTextBox>
													</td>
												</tr>
												<tr>
													<td>Reference No. :</td>
													<td>
														<dx:ASPxTextBox ID="txtSHSigRef" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="10"></dx:ASPxTextBox>
													</td>
												</tr>
												<tr>
													<td>Proof of Identity :</td>
													<td class="dropDown">
														<dx:ASPxComboBox ID="cboSHSigIdProof" runat="server" Theme="MetropolisBlue" Width="60%"></dx:ASPxComboBox>
													</td>
												</tr>
												<tr>
													<td>Proof of Address :</td>
													<td class="dropDown">
														<dx:ASPxComboBox ID="cboSHSigAdrProof" runat="server" Theme="MetropolisBlue" Width="60%"></dx:ASPxComboBox>
													</td>
												</tr>
											</table>
										</div>
									</div>
									<div class="row">
										<div class="col-sm-8">
											<h5 class="subHeading">Third Holder</h5>
											<table class="table table-responsive borderless tblpadding inputTable" style="width:100%">
												<colgroup>
													<col style="width:20%"/><col />
												</colgroup>
												<tr><td colspan="2"></td></tr>
												<tr>
													<td>Name :</td>
													<td>
														<dx:ASPxTextBox ID="txtTHSig" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="135"></dx:ASPxTextBox>
													</td>
												</tr>
												<tr>
													<td>Reference No. :</td>
													<td>
														<dx:ASPxTextBox ID="txtTHSigRef" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="10"></dx:ASPxTextBox>
													</td>
												</tr>
												<tr>
													<td>Proof of Identity :</td>
													<td class="dropDown">
														<dx:ASPxComboBox ID="cboTHSigIdProof" runat="server" Theme="MetropolisBlue" Width="60%"></dx:ASPxComboBox>
													</td>
												</tr>
												<tr>
													<td>Proof of Address :</td>
													<td class="dropDown">
														<dx:ASPxComboBox ID="cboTHSigAdrProof" runat="server" Theme="MetropolisBlue" Width="60%"></dx:ASPxComboBox>
													</td>
												</tr>
											</table>
										</div>
									</div>
								</dx:ContentControl>
							</ContentCollection>
						</dx:TabPage>
						<dx:TabPage Text="POA Details">
							<ContentCollection>
								<dx:ContentControl>
									<dx:ASPxGridView ID="grdPoaDetails" ClientInstanceName="grdPoaDetails" runat="server" Width="90%" 
										Theme="MetropolisBlue" KeyFieldName="CO;BENCODE;HOLDERTYPE"
										OnRowDeleting="grdPoaDetails_RowDeleting" OnRowInserting="grdPoaDetails_RowInserting" 
										OnRowUpdating="grdPoaDetails_RowUpdating" OnRowValidating="grdPoaDetails_RowValidating"
										OnCellEditorInitialize="grdPoaDetails_CellEditorInitialize">
										<Columns>
											<dx:GridViewCommandColumn ShowNewButtonInHeader="true" ShowEditButton="true" CellStyle-ForeColor="Green" VisibleIndex="0">
											</dx:GridViewCommandColumn>
											<dx:GridViewDataColumn FieldName="CO" VisibleIndex="1" Visible="false"></dx:GridViewDataColumn>
											<dx:GridViewDataColumn FieldName="BENCODE" VisibleIndex="2" Visible="false"></dx:GridViewDataColumn>
											<dx:GridViewDataComboBoxColumn FieldName="HOLDERTYPE" VisibleIndex="3" Caption="Holder Type">
												<PropertiesComboBox>
													<Items>
														<dx:ListEditItem Text="First Holder" Value="11" />
														<dx:ListEditItem Text="Second Holder" Value="12" />
														<dx:ListEditItem Text="Third Holder" Value="13" />
													</Items>												
												</PropertiesComboBox>
											</dx:GridViewDataComboBoxColumn>
											<dx:GridViewDataComboBoxColumn FieldName="POATYPE" VisibleIndex="4" Caption="POA Type">
												<PropertiesComboBox>
													<Items>
														<dx:ListEditItem Text="POA - Individual" Value="H" />
														<dx:ListEditItem Text="POA - Corporate" Value="C" />
													</Items>												
												</PropertiesComboBox>
											</dx:GridViewDataComboBoxColumn>
											<dx:GridViewDataComboBoxColumn FieldName="POAID" VisibleIndex="5" Caption="POA Id">
											</dx:GridViewDataComboBoxColumn>
											<dx:GridViewDataDateColumn FieldName="ACTIVEDT" VisibleIndex="6" Caption="Active Date" PropertiesDateEdit-DisplayFormatString="dd/MM/yyyy">
											</dx:GridViewDataDateColumn>
											<dx:GridViewCommandColumn ShowDeleteButton="true" Caption="Delete POA" CellStyle-ForeColor="Crimson" VisibleIndex="7">
											</dx:GridViewCommandColumn>
										</Columns>
										<SettingsPager PageSize="10" />
										<SettingsBehavior ConfirmDelete="true" />
										<ClientSideEvents EndCallback="function(s,e) 
											{ 
												if(s.cpPoaInsertFailed != null) {
													alert(s.cpPoaInsertFailed);
													s.cpPoaInsertFailed = null;
												}

												if(s.cpPoaUpdateFailed != null) {
													alert(s.cpPoaUpdateFailed);
													s.cpPoaUpdateFailed = null;
												}
											}" />
									</dx:ASPxGridView>
								</dx:ContentControl>
							</ContentCollection>
						</dx:TabPage>
						<dx:TabPage Text="Additional Information">
							<ContentCollection>
								<dx:ContentControl>
									<table class="table table-responsive borderless tblpadding inputTable">
										<colgroup>
											<col style="width:35%"/><col />
											<col /><col />
										</colgroup>
										<tr>
											<td>Alternate Email for 1st Holder :</td>
											<td colspan="2">
												<dx:ASPxTextBox ID="txtFHAltEmail2" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
															ErrorText="Invalid 1st Holder Alternate Email !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Alternate Email for 2nd Holder :</td>
											<td colspan="2">
												<dx:ASPxTextBox ID="txtSHAltEmail" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
															ErrorText="Invalid 2nd Holder Alternate Email !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Alternate Email for 3rd Holder :</td>
											<td colspan="2">
												<dx:ASPxTextBox ID="txtTHAltEmail" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="50">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*@([0-9a-z]|[0-9a-z]+(\.[0-9a-z]+|_[0-9a-z]+)*)+\.(([a-z]{2}\.[a-z]{2})|[a-z]{2,3})$" 
															ErrorText="Invalid 3rd Holder Alternate Email !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
												</dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Second Nominee:</td>
											<td colspan="2">
												<dx:ASPxTextBox ID="txtSecNmn" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="45"></dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Second Minor Nominee Guardian Name:</td>
											<td colspan="2">
												<dx:ASPxTextBox ID="txtSecMnrGrdn" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="45"></dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Third Nominee:</td>
											<td colspan="2">
												<dx:ASPxTextBox ID="txtThrdNmn" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="45"></dx:ASPxTextBox>
											</td>
										</tr>
										<tr>
											<td>Third Minor Nominee Guardian Name:</td>
											<td colspan="2">
												<dx:ASPxTextBox ID="txtThrdMnrGrdn" runat="server" Theme="MetropolisBlue" Width="100%" MaxLength="45"></dx:ASPxTextBox>
											</td>
										</tr>
										<tr>											
											<td>1st Minor Nominee DOB :</td>
											<td colspan="2" class="dateTime">
												<dx:ASPxDateEdit ID="dtFstMnrDob" runat="server" Theme="MetropolisBlue"
													DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy" Width="50%">
												</dx:ASPxDateEdit>
											</td>
										</tr>
										<tr>											
											<td>2nd Minor Nominee DOB :</td>
											<td colspan="2" class="dateTime">
												<dx:ASPxDateEdit ID="dtSecMnrDob" runat="server" Theme="MetropolisBlue"
													DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy" Width="50%">
												</dx:ASPxDateEdit>
											</td>
										</tr>
										<tr>											
											<td>3rd Minor Nominee DOB :</td>
											<td colspan="2" class="dateTime">
												<dx:ASPxDateEdit ID="dtThrdMnrDob" runat="server" Theme="MetropolisBlue"
													DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy" Width="50%">
												</dx:ASPxDateEdit>
											</td>
										</tr>
										<tr>
											<td>Custodial Client Flag :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnCstdlClntYes" runat="server" GroupName="CstdlClnt" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnCstdlClntNo" runat="server" GroupName="CstdlClnt" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
											<td>Annual Income :</td>
											<td class="dropDown">
												<dx:ASPxComboBox ID="cboAnnualIncome" runat="server" Theme="MetropolisBlue" Width="70%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>
												</dx:ASPxComboBox>
												<!--
													<Items>
														<dx:ListEditItem Text="None" Value="''" Selected="true" />
														<dx:ListEditItem Text="UpTo 1 Lakhs" Value="1" />
														<dx:ListEditItem Text="1 Lakhs To 5 Lakhs" Value="6" />
														<dx:ListEditItem Text="5 Lakhs To 10 Lakhs" Value="7" />
														<dx:ListEditItem Text="10 Lakhs To 25 Lakhs" Value="8" />
														<dx:ListEditItem Text="Above 25 Lakhs" Value="9" />
														<dx:ListEditItem Text="25 Lakhs To 1 Crore" Value="10" />
														<dx:ListEditItem Text="Above 1 Crore" Value="11" />
													</Items>
												-->
											</td>
										</tr>
										<tr>
											<td>Equality Flag for Share(%) :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnEqualityShareYes" runat="server" GroupName="EqualityShare" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnEqualityShareNo" runat="server" GroupName="EqualityShare" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
											<td>Gender :</td>
											<td class="dropDown">
												<dx:ASPxComboBox ID="cboGender" runat="server" Theme="MetropolisBlue" Width="70%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>
												</dx:ASPxComboBox>
												<!--
													<Items>
														<dx:ListEditItem Text="Male" Value="M" Selected="true" />
														<dx:ListEditItem Text="Female" Value="F" />
														<dx:ListEditItem Text="None" Value="X" />
													</Items>
												-->
											</td>
										</tr>
										<tr>
											<td>2nd Nominee Guardian Detail same as 1st Nominee Guardian :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnSecSameFstYes" runat="server" GroupName="SecSameFst" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnSecSameFstNo" runat="server" GroupName="SecSameFst" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
											<td>Risk Profile :</td>
											<td class="dropDown">
												<dx:ASPxComboBox ID="cboRiskProfile" runat="server" Theme="MetropolisBlue" Width="70%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField  IsRequired="true" ErrorText="Compulsory Entry !"/>
													</ValidationSettings>
												</dx:ASPxComboBox>
												<!--
													<Items>
														<dx:ListEditItem Text="Low Risk" Value="Low Risk" Selected="true" />
														<dx:ListEditItem Text="Medium Risk" Value="Medium Risk" />
														<dx:ListEditItem Text="High Risk" Value="High Risk" />
													</Items>	
												-->
											</td>
										</tr>
										<tr>
											<td>3rd Nominee Guardian Detail same as 1st Nominee Guardian :</td>
											<td>
												<dx:ASPxRadioButton ID="rbnThrdSameFstYes" runat="server" GroupName="ThrdSameFst" Text="Yes" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
												<dx:ASPxRadioButton ID="rbnThrdSameFstNo" runat="server" GroupName="rbnThrdSameFstYes" Checked="true" Text="No" Theme="MetropolisBlue" CssClass="displayTableCell"></dx:ASPxRadioButton>
											</td>
											<td>RM Code :</td>
											<td>
												<ajaxToolkit:AutoCompleteExtender ID=aceRM runat="server"
													CompletionListCssClass="completionList"
													CompletionListItemCssClass="listItem"
													CompletionListHighlightedItemCssClass="itemHighlighted"
													ServiceMethod="GetRMCompletionList"
													MinimumPrefixLength="1"
													CompletionInterval="10"
													EnableCaching="false"
													TargetControlID="txtRM"
													FirstRowSelected="false"
													OnClientItemSelected="RM_Selected">
												</ajaxToolkit:AutoCompleteExtender>
												<asp:HiddenField ID=hdnRMCode runat="server" />
												<asp:TextBox ID="txtRM" runat="server" AutoPostBack="true" Width="80%" Height="22px"
													style="border:1px solid silver;padding:2px">
												</asp:TextBox>
											</td>
										</tr>
										<tr>
											<td>State :</td>
											<td colspan="2" class="dropDown">
												<dx:ASPxComboBox ID="cboStates" runat="server" Theme="MetropolisBlue" Width="60%">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RequiredField IsRequired="true" ErrorText="Compulsory Entry !" />
													</ValidationSettings>
												</dx:ASPxComboBox>
											</td>
										</tr>
										<tr>
											<td>GSTIN :</td>
											<td>
												<dx:ASPxTextBox ID="txtGSTIN" runat="server" Theme="MetropolisBlue" Width="70%" MaxLength="15">
													<ValidationSettings ErrorDisplayMode="ImageWithTooltip" ValidationGroup="clntRegGrp">
														<RegularExpression 
															ValidationExpression="^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[0-9]{1}[A-Z]{1}[0-9]{1}$" 
															ErrorText="Invalid GSTIN !" />
													</ValidationSettings>
													<InvalidStyle Border-BorderColor="crimson"></InvalidStyle>
												</dx:ASPxTextBox>
											</td>
											<td>GST Reg. Date :</td>
											<td>
												<dx:ASPxDateEdit ID="dtGSTReg" runat="server" Theme="MetropolisBlue"
													DisplayFormatString="dd/MM/yyyy" EditFormatString="dd/MM/yyyy" Width="60%">
												</dx:ASPxDateEdit>
											</td>
										</tr>
									</table>
								</dx:ContentControl>
							</ContentCollection>
						</dx:TabPage>
						<dx:TabPage Text="Finish">
							<ContentCollection>
								<dx:ContentControl>
									<div class="row">
										<div class="col-xs-2">
											<dx:ASPxButton ID="btnSave" runat="server" OnClick="btnSave_Click" ValidationGroup="clntRegGrp"
												HoverStyle-BackColor="Green" Text="Submit" Width="150px" Theme="MetropolisBlue">
												<ClientSideEvents Click="function(s, e) { btnSave_OnClick(s, e); }"/>
											</dx:ASPxButton>
										</div>
									</div>
									<br />
									<div class="row">
										<div class="col-xs-12">
											<dx:ASPxPanel ID="pnlSavedSuccessfully" runat="server" Width="100%" Visible="false">
												<PanelCollection>
													<dx:PanelContent>
														<h1 class="text-center text-success">
															<i class="fa fa-check"></i> Congratulations . . . !
															<br />
															<small>All data successfully submitted.</small>
															<br />
															<dx:ASPxLabel ID="lblSuccessText" runat="server" Theme="MetropolisBlue" 
																Font-Size="Medium" ForeColor="DimGray">
															</dx:ASPxLabel>
															<br />
															<small>Thank You !</small>
														</h1>
													</dx:PanelContent>
												</PanelCollection>
											</dx:ASPxPanel>
											<div id="divSubmittionRestricted" style="display:none">
												<h1 class="text-center text-danger">
													<i class="fa fa-times"></i> Data Not Submitted . . . !
													<br />
													<small>You have missed out some Compulsory Fields.</small>
													<br />
													<small>Please Check and Try Again !</small>
												</h1>
											</div>
											<dx:ASPxPanel ID="pnlSaveFailed" runat="server" Width="100%" Visible="false">
												<PanelCollection>
													<dx:PanelContent>
														<h1 class="text-center text-danger">
															<i class="fa fa-times"></i> Failed . . . !
															<br />
															<small>Data not saved due to Error(s).</small>
															<br />
															<small>Please Try Again !</small>
														</h1>
													</dx:PanelContent>
												</PanelCollection>
											</dx:ASPxPanel>
										</div>
									</div>
								</dx:ContentControl>
							</ContentCollection>
						</dx:TabPage>
					</TabPages>
				</dx:ASPxPageControl>
			</div>
   		</div>

	</form>

		<div id="divWait" style="text-align:center; position:fixed; top:30%; left:40%; visibility:hidden; z-index:100000; 
				border:1px solid lightgray; border-radius:15px; box-shadow:0px 0px 10px black; background-color:white; padding:10px">
			<i class="fa fa-spinner fa-4x fa-pulse fa-fw" aria-hidden="true"></i>
			<h6>Please Wait.....</h6>
		</div>

	</div>

	<!--================================================== 
	<script src="../../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../../js/bootstrap/bootstrap.min.js"></script>-->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>

	<!-- StanSoft Script -->
	<script src="../../scripts/ssajax.js"></script>

	<script>
		$(document).ready(function () {
			validateBranchEntry();
			txtSHName_TextChanged();
			txtTHName_TextChanged();
			cboBenType_SelectedIndexChanged();

			rbnStateChanged(rbnFHPanYes, txtFHPan);
			rbnStateChanged(rbnSHPanYes, txtSHPan);
			rbnStateChanged(rbnTHPanYes, txtTHPan);
		});

		function rbnStateChanged(rbn, txt) {
			txt.SetEnabled(rbn.GetChecked());
		}

		function btnSave_OnClick(s, e) {
			txtSHName_TextChanged();
			txtTHName_TextChanged();
			cboBenType_SelectedIndexChanged();

			document.getElementById("divSubmittionRestricted").style.display = "none"

			e.processOnServer = txtSHFthrName.GetIsValid()
								&& dtSHDob.GetIsValid()
								&& txtTHFthrName.GetIsValid()
								&& dtTHDob.GetIsValid()
								&& txtFHAadhaar.GetIsValid()
								&& txtFHLclAadhaar.GetIsValid()
								&& ASPxClientEdit.ValidateEditorsInContainer(null, "clntRegGrp", true);

			if(document.getElementById("txtClntBranch").value == "") {
				alert("Branch Id is compulsory.");
				e.processOnServer = false;
			}

			if(!e.processOnServer) {
				document.getElementById("divSubmittionRestricted").style.display = "block"
			}
		}

		function validateBranchEntry() {
			if($("#txtClntBranch").val().trim() == "") {
				$("#txtClntBranch").css("border-color", "crimson");
				$("#lblClntBranchErr").css("display", "inline");
				return;
			}
			$("#txtClntBranch").css("border-color", "silver");
			$("#lblClntBranchErr").css("display", "none");
		}

		function Branch_Selected(source, eventArgs) {
			document.getElementById("hdnBranchCode").value = eventArgs.get_value();

			validateBranchEntry();
		}

		function RM_Selected(source, eventArgs) {
			document.getElementById("hdnRMCode").value = eventArgs.get_value();
		}

		function DespBskt_Selected(source, eventArgs) {
			document.getElementById("hdnFHDespBskt").value = eventArgs.get_value();
		}

		function ChrgBskt_Selected(source, eventArgs) {
			document.getElementById("hdnFHChrgBskt").value = eventArgs.get_value();
		}

		function GrpBskt_Selected(source, eventArgs) {
			document.getElementById("hdnFHGrpBskt").value = eventArgs.get_value();
		}

		function CommBskt_Selected(source, eventArgs) {
			document.getElementById("hdnFHCommBskt").value = eventArgs.get_value();
		}

		function txtFHMobile_TextChanged() {
			txtFHLclMob.SetText(txtFHMobile.GetText());
			txtFHLclMob.Validate();
		}

		function txtFHEmail_TextChanged() {
			txtFHLclEmail.SetText(txtFHEmail.GetText());
			txtFHLclEmail.Validate();
		}

		function txtFHPhone_TextChanged() {
			txtFHLclPhone.SetText(txtFHPhone.GetText());
			txtFHLclPhone.Validate();
		}

		function txtFHPan_TextChanged() {
			txtFHLclPan.SetText(txtFHPan.GetText());
			txtFHLclPan.Validate();
		}

		function txtFHAadhaar_TextChanged() {
			txtFHLclAadhaar.SetText(txtFHAadhaar.GetText());
			txtFHLclAadhaar.Validate();
		}
		
		function chkFHCorrSameLocal_CheckedChanged() {
			if(chkFHCorrSameLocal.GetChecked() == true) {
				txtFHCorrAdr1.SetText(txtFHLclAdr1.GetText());
				txtFHCorrAdr2.SetText(txtFHLclAdr2.GetText());
				txtFHCorrAdr3.SetText(txtFHLclAdr3.GetText());
				txtFHCorrAdr4.SetText(txtFHLclAdr4.GetText());
				txtFHCorrPin.SetText(txtFHLclPin.GetText());
				txtFHCorrMob.SetText(txtFHLclMob.GetText());
				txtFHCorrEmail.SetText(txtFHLclEmail.GetText());
				txtFHCorrPhone.SetText(txtFHLclPhone.GetText());
				txtFHCorrFax.SetText(txtFHLclFax.GetText());
				txtFHCorrPan.SetText(txtFHLclPan.GetText());
				txtFHCorrAadhaar.SetText(txtFHLclAadhaar.GetText());
			}
			else {
				txtFHCorrAdr1.SetText("");
				txtFHCorrAdr2.SetText("");
				txtFHCorrAdr3.SetText("");
				txtFHCorrAdr4.SetText("");
				txtFHCorrPin.SetText("");
				txtFHCorrMob.SetText("");
				txtFHCorrEmail.SetText("");
				txtFHCorrPhone.SetText("");
				txtFHCorrFax.SetText("");
				txtFHCorrPan.SetText("");
				txtFHCorrAadhaar.SetText("");
			}
		}
		
		function chkSHCorrSameLocal_CheckedChanged() {
			if(chkSHCorrSameLocal.GetChecked() == true) {
				txtSHCorrAdr1.SetText(txtFHLclAdr1.GetText());
				txtSHCorrAdr2.SetText(txtFHLclAdr2.GetText());
				txtSHCorrAdr3.SetText(txtFHLclAdr3.GetText());
				txtSHCorrAdr4.SetText(txtFHLclAdr4.GetText());
				txtSHCorrPin.SetText(txtFHLclPin.GetText());
				txtSHCorrPhone.SetText(txtFHLclPhone.GetText());
				txtSHCorrFax.SetText(txtFHLclFax.GetText());
			}
			else {
				txtSHCorrAdr1.SetText("");
				txtSHCorrAdr2.SetText("");
				txtSHCorrAdr3.SetText("");
				txtSHCorrAdr4.SetText("");
				txtSHCorrPin.SetText("");
				txtSHCorrPhone.SetText("");
				txtSHCorrFax.SetText("");
			}
		}
		
		function chkTHCorrSameLocal_CheckedChanged() {
			if(chkTHCorrSameLocal.GetChecked() == true) {
				txtTHCorrAdr1.SetText(txtFHLclAdr1.GetText());
				txtTHCorrAdr2.SetText(txtFHLclAdr2.GetText());
				txtTHCorrAdr3.SetText(txtFHLclAdr3.GetText());
				txtTHCorrAdr4.SetText(txtFHLclAdr4.GetText());
				txtTHCorrPin.SetText(txtFHLclPin.GetText());
				txtTHCorrPhone.SetText(txtFHLclPhone.GetText());
				txtTHCorrFax.SetText(txtFHLclFax.GetText());
			}
			else {
				txtTHCorrAdr1.SetText("");
				txtTHCorrAdr2.SetText("");
				txtTHCorrAdr3.SetText("");
				txtTHCorrAdr4.SetText("");
				txtTHCorrPin.SetText("");
				txtTHCorrPhone.SetText("");
				txtTHCorrFax.SetText("");
			}
		}

		function chkFHFstNmnSameLocal_CheckedChanged() {
			if(chkFHFstNmnSameLocal.GetChecked() == true) {
				txtFHFstNmnAdr1.SetText(txtFHLclAdr1.GetText());
				txtFHFstNmnAdr2.SetText(txtFHLclAdr2.GetText());
				txtFHFstNmnAdr3.SetText(txtFHLclAdr3.GetText());
				txtFHFstNmnAdr4.SetText(txtFHLclAdr4.GetText());
				txtFHFstNmnPin.SetText(txtFHLclPin.GetText());
				txtFHFstNmnPhone.SetText(txtFHLclPhone.GetText());
				txtFHFstNmnFax.SetText(txtFHLclFax.GetText());
			}
			else {
				txtFHFstNmnAdr1.SetText("");
				txtFHFstNmnAdr2.SetText("");
				txtFHFstNmnAdr3.SetText("");
				txtFHFstNmnAdr4.SetText("");
				txtFHFstNmnPin.SetText("");
				txtFHFstNmnPhone.SetText("");
				txtFHFstNmnFax.SetText("");
			}
		}

		function chkFHSecNmnSameLocal_CheckedChanged() {
			if(chkFHSecNmnSameLocal.GetChecked() == true) {
				txtFHSecNmnAdr1.SetText(txtFHLclAdr1.GetText());
				txtFHSecNmnAdr2.SetText(txtFHLclAdr2.GetText());
				txtFHSecNmnAdr3.SetText(txtFHLclAdr3.GetText());
				txtFHSecNmnAdr4.SetText(txtFHLclAdr4.GetText());
				txtFHSecNmnPin.SetText(txtFHLclPin.GetText());
				txtFHSecNmnPhone.SetText(txtFHLclPhone.GetText());
				txtFHSecNmnFax.SetText(txtFHLclFax.GetText());
			}
			else {
				txtFHSecNmnAdr1.SetText("");
				txtFHSecNmnAdr2.SetText("");
				txtFHSecNmnAdr3.SetText("");
				txtFHSecNmnAdr4.SetText("");
				txtFHSecNmnPin.SetText("");
				txtFHSecNmnPhone.SetText("");
				txtFHSecNmnFax.SetText("");
			}
		}

		function chkFHThrdNmnSameLocal_CheckedChanged() {
			if(chkFHThrdNmnSameLocal.GetChecked() == true) {
				txtFHThrdNmnAdr1.SetText(txtFHLclAdr1.GetText());
				txtFHThrdNmnAdr2.SetText(txtFHLclAdr2.GetText());
				txtFHThrdNmnAdr3.SetText(txtFHLclAdr3.GetText());
				txtFHThrdNmnAdr4.SetText(txtFHLclAdr4.GetText());
				txtFHThrdNmnPin.SetText(txtFHLclPin.GetText());
				txtFHThrdNmnPhone.SetText(txtFHLclPhone.GetText());
				txtFHThrdNmnFax.SetText(txtFHLclFax.GetText());
			}
			else {
				txtFHThrdNmnAdr1.SetText("");
				txtFHThrdNmnAdr2.SetText("");
				txtFHThrdNmnAdr3.SetText("");
				txtFHThrdNmnAdr4.SetText("");
				txtFHThrdNmnPin.SetText("");
				txtFHThrdNmnPhone.SetText("");
				txtFHThrdNmnFax.SetText("");
			}
		}

		function searchNames() {
			// Declare variables
			var input, filter, select, option, i;
			input = document.getElementById('txtSearch');
			filter = input.value.toUpperCase();
			select = document.getElementById("lstUncheckedClnt");
			option = select.getElementsByTagName('option');

			// Loop through all list items, and hide those who don't match the search query
			for(i = 0; i < option.length; i++) {
				if(option[i].innerHTML.toUpperCase().indexOf(filter) > -1) {
					option[i].style.display = "";
				} 
				else {
					option[i].style.display = "none";
				}
			}
		}

		// ----------------------- Image Upload ----------------------- //
		function uploadImage_Ok_OnClick(previewControlId) {
			var uldImage = document.getElementById("uldSignature");
			var uploadFile = uldImage.files[0];

			txtFHSigSize.SetText(
				Math.round(uploadFile.size / 1024 * 100) / 100 +
				' KB'
			);

			previewImage(previewControlId, uploadFile);
		}

		document.getElementById("uldSignature").onchange = function () {
			var uldImage = document.getElementById("uldSignature");
			var uploadFile = uldImage.files[0];

			var permittedExt = [".tif", ".tiff", ".jpg", ".jpeg", ".png", ".bmp"];
			var extAllowed = false;
			for(var index = 0; index < permittedExt.length; index++) {
				var extension = uldImage.value.substr(uldImage.value.length - permittedExt[index].length).toLowerCase();
				extAllowed = permittedExt.includes(extension);
				if(extAllowed) break;
			}

			if(uploadFile.size/1024 > 64) {
				alert("Signature file size must be within 64KB")
				uldImage.value = null;
				return;
			}
			else if(extAllowed == false) {
				alert("Signature file format allowed are .tif, .tiff, .jpg, .jpeg, .png or .bmp")
				uldImage.value = null;
				return;
			}
			else {
				document.getElementById("btnSigOk").disabled = false
			}

			previewImage("imgSignature", uploadFile);
		}

		function previewImage(controlId, image) {
			var reader = new FileReader();

			reader.onload = function (e) {
				// get loaded data and render thumbnail.
				document.getElementById(controlId).src = e.target.result;
			};

			// read the image file as a data URL.
			reader.readAsDataURL(image);
		}

		function toLowerFields_TextChanged(s, e) {
			s.SetText(s.GetText().toLowerCase());
			s.Validate();
		}

		function toUpperFields_TextChanged(s, e) {
			s.SetText(s.GetText().toUpperCase());
			s.Validate();
		}

		function txtSHName_TextChanged() {
			if(txtSHName.GetText().trim() != "" && (txtSHFthrName.GetText().trim() == "" || dtSHDob.GetText().trim() == "")) {
				txtSHFthrName.SetIsValid(false);
				dtSHDob.SetIsValid(false);
				return;
			}
			txtSHFthrName.SetIsValid(true);
			dtSHDob.SetIsValid(true);
		}

		function txtTHName_TextChanged() {
			if(txtTHName.GetText().trim() != "" && (txtTHFthrName.GetText().trim() == "" || dtTHDob.GetText().trim() == "")) {
				txtTHFthrName.SetIsValid(false);
				dtTHDob.SetIsValid(false);
				return;
			}
			txtTHFthrName.SetIsValid(true);
			dtTHDob.SetIsValid(true);
		}

		function cboBenType_SelectedIndexChanged() {
			if(cboBenType.GetValue() == "01" && (txtFHAadhaar.GetText().trim() == "" || txtFHLclAadhaar.GetText().trim() == "")) {
				txtFHAadhaar.SetIsValid(false);
				txtFHLclAadhaar.SetIsValid(false);
				return;
			}
			txtFHAadhaar.SetIsValid(true);
			txtFHLclAadhaar.SetIsValid(true);
		}
		// ------------------------------------------------------------ //

	</script>
</body>
</html>
