﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ChequeEntries.aspx.cs" Inherits="Connect_DotNet.ChequeEntries" %>

<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<!DOCTYPE html>

<html>
<head runat="server">
	<title></title>

	<!-- Basic Styles -->
    <!-- 
	<link rel="stylesheet" type="text/css" media="screen" href="../css/bootstrap.min.css">
        -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

	<link href="../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../css/smartadmin-skins.min.css">

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">
	
	<link href="../css/your_style.css" rel="stylesheet" />

	<style>
		#tblInput td, #tblInput th { border: none; vertical-align: middle; padding: 2px !important; }
	</style>
</head>
<body>
	<div class="container-fluid">
		<h2><i class="fa fa-money" aria-hidden="true"></i> Cheque Entries</h2>
		<div class="row">
			<div class="col-sm-12">
				<button onclick="AddChequeEntry()" class="btn btn-primary">
					<i class="fa fa-plus"></i> New Cheque Entry
				</button>
                <button onclick="openChequeEntriesStatus()" class="btn btn-success">
                    <i class="fa fa-bars" aria-hidden="true"></i> Cheque Entries Status
				</button>
				<br />
				<br />
				<form id="frmChequeEntries" runat="server">
					<dx:ASPxGridView ID=grdPendingEntries KeyFieldName="idn" ClientInstanceName="grdPendingEntries" runat="server" 
						AutoGenerateColumns="False" Width="100%" Theme=MetropolisBlue>
						<Styles>
							<AlternatingRow BackColor="#f4f4f4"></AlternatingRow>
						</Styles>
						<Columns>
							<dx:GridViewDataTextColumn FieldName="idn" ReadOnly="true" Visible="false" VisibleIndex="0">
							</dx:GridViewDataTextColumn>
							<dx:GridViewDataHyperLinkColumn Caption="Action" VisibleIndex="1" CellStyle-Cursor="pointer" HeaderStyle-Cursor="default">
								<DataItemTemplate>
									<a onclick='UpdateChequeEntry(<%# Eval("idn") %>);'>Edit</a>
								</DataItemTemplate>
							</dx:GridViewDataHyperLinkColumn>
							<dx:GridViewDataTextColumn Caption="Request Date" PropertiesTextEdit-DisplayFormatString="dd/MM/yyyy" FieldName="vrdt" ReadOnly="true" VisibleIndex="2" HeaderStyle-Cursor="default">
							</dx:GridViewDataTextColumn>
							<dx:GridViewDataColumn Caption="Segment" FieldName="segment" VisibleIndex="3" HeaderStyle-Cursor="default">
							</dx:GridViewDataColumn>
							<dx:GridViewDataColumn Caption="Client ID" FieldName="nse_alias" VisibleIndex="4" HeaderStyle-Cursor="default">
							</dx:GridViewDataColumn>
							<dx:GridViewDataColumn Caption="Client Name" FieldName="descr" VisibleIndex="5" HeaderStyle-Cursor="default">
							</dx:GridViewDataColumn>
							<dx:GridViewDataTextColumn Caption="Amount" FieldName="amtcr" CellStyle-HorizontalAlign="Right" HeaderStyle-HorizontalAlign="Right" ReadOnly="true" VisibleIndex="6" HeaderStyle-Cursor="default">
							</dx:GridViewDataTextColumn>
							<dx:GridViewDataColumn Caption="Bank" FieldName="bank" VisibleIndex="7" HeaderStyle-Cursor="default">
							</dx:GridViewDataColumn>
							<dx:GridViewDataTextColumn Caption="Account#" FieldName="accno" CellStyle-HorizontalAlign="Right" HeaderStyle-HorizontalAlign="Right" ReadOnly="true" VisibleIndex="8" HeaderStyle-Cursor="default">
							</dx:GridViewDataTextColumn>
							<dx:GridViewDataHyperLinkColumn Caption="Action" VisibleIndex="9" CellStyle-Cursor="pointer" HeaderStyle-Cursor="default">
								<DataItemTemplate>
									<a onclick='DeleteChequeEntry(<%# Eval("idn") %>);'>Delete</a>
								</DataItemTemplate>
							</dx:GridViewDataHyperLinkColumn>
						</Columns>
					</dx:ASPxGridView>
				</form>
			</div>
		</div>
	</div>

    <!--
	<script src="../js/libs/jquery-2.1.1.min.js"></script>
    -->
	<!-- BOOTSTRAP JS 
	<script src="../js/bootstrap/bootstrap.min.js"></script>
        -->

    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>


	<!-- ssAjax : StanSoft Javascript Library -->
	<script type="text/javascript" src="../scripts/ssajax.js"></script>

	<script>

        function openChequeEntriesStatus() {
			var opts = {
				type: "XOKCANCEL",
				url: "html/ChequeEntriesStatus.swc",
				title: "<i class='fa fa-bars'></i> Cheque Entries Status",
				height: 720,
				reload: false,
				fnpostsuccess: function () { grdPendingEntries.Refresh(); },
				reloadwindow: window
			};
			parent.urlFormDialog(opts);
        }

		function AddChequeEntry() {
			var opts = {
				type: "OKCANCEL",
				//url: "ChequeEntryAddEdit.aspx?sessionid=<%= Request.QueryString["sessionid"] %>",
				url: "dotnet/ChequeEntryAddEdit.aspx",
				title: "<i class='fa fa-money'></i> Cheque Entry",
				savecaption: "<i class=\"fa fa-floppy-o\"></i> Save",
				cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
				width: 630,
				height: 545,
				reload: false,
				fnpostsuccess: function () { grdPendingEntries.Refresh(); },
				reloadwindow: window
			};
			parent.urlFormDialog(opts);
		}

		function UpdateChequeEntry(idn) {
			var opts = {
				type: "OKCANCEL",
				//url: "ChequeEntryAddEdit.aspx?sessionid=<%= Request.QueryString["sessionid"] %>&idn=" + idn,
				url: "dotnet/ChequeEntryAddEdit.aspx?idn=" + idn,
				title: "<i class='fa fa-money'></i> Cheque Entry",
				savecaption: "<i class=\"fa fa-floppy-o\"></i> Save",
				cancelcaption: "<i class=\"fa fa-times\"></i> Cancel",
				width: 630,
				height: 545,
				reload: false,
				fnpostsuccess: function () { grdPendingEntries.Refresh(); },
				reloadwindow: window
			};
			parent.urlFormDialog(opts);
		}

		function DeleteChequeEntry(idn) {
			var result = confirm("Do you really want to delete this entry?");
			if(result) {
				$.ajax({
					type: "POST",
					url: "ChequeEntries.aspx/DeleteChequeEntry",
					data: "{cIdn:'" + idn + "'}",
					contentType: "application/json; charset=utf-8",
					dataType: "json",
					success: function () {
						grdPendingEntries.Refresh();
					},
					failure: function (response) {
						alert(response.d);
					}
				})
			}
		}

		//AddStyleToGrid();
		//setInterval(AddStyleToGrid, 500);

		//function AddStyleToGrid() {
		//	$('[id*="_DXMainTable"]').removeClass($('[id*="_DXMainTable"]').attr("class")).addClass("table table-hover table-condensed table-responsive table-striped ssGrid");
		//	$('[class*="dxgvControl"]').removeClass($('[class*="dxgvControl"]').attr("class"));
		//}
	</script>

</body>
</html>
