﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="InventoryTransfer.aspx.cs" Inherits="Connect_DotNet.InventoryTransfer" %>

<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<%@ Register Assembly="ssCommon" Namespace="ssCommon.Controls.BrowserControls" TagPrefix="ss" %>

<!DOCTYPE html>

<html>
<head runat="server">
	<title></title>

	<!-- #CSS Links -->
	<!-- Basic Styles 
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
        -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<!-- Optional theme -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-skins.min.css"> -->

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">

	<link href="../../css/your_style.css" rel="stylesheet" />

	<style>
		#tblInput { border: none !important; }
		.NoBorder td { border: none !important; }
		.AlignMiddle td { vertical-align: middle !important; }

		.completionList { overflow-y:auto;background-color:white;border:1px solid silver;margin:0;padding:3px }
		.listItem { color:black;padding:3px }
		.itemHighlighted { background-color:lightyellow;padding:3px }
	</style>
</head>
<body>
	<div class=container-fluid>
		<br />
		<form id="frmTransfer" runat="server">
			<asp:ScriptManager ID=ScriptManager1 runat="server" EnablePageMethods="true" EnablePartialRendering="true"></asp:ScriptManager>
			<div class=row>
				<div class=col-sm-12>
					<table id=tblInput class="table table-condensed table-responsive NoBorder AlignMiddle">
						<colgroup><col style="width: 15%" /><col /></colgroup>
						<tr>
							<td style="text-align: right">Product :</td>
							<td>
								<ss:ASPxTextBox ID=txtProduct runat="server" CssClass="form-control input-sm" Theme=MetropolisBlue ReadOnly=true></ss:ASPxTextBox>
							</td>
						</tr>
						<tr>
							<td></td>
							<td>
								Stock In Hand : <dx:ASPxLabel ID=lblStockInHand runat="server" Text="0"></dx:ASPxLabel>
							</td>
						</tr>
						<tr>
							<td style="text-align: right">Type :</td>
							<td>
								<dx:aspxcombobox id=cboEntities runat="server" cssclass="form-control input-sm" AutoPostBack=true
									Theme=MetropolisBlue OnSelectedIndexChanged=cboEntities_SelectedIndexChanged>
								</dx:aspxcombobox>
							</td>
						</tr>
						<tr>
							<td style="text-align: right">
								<dx:ASPxLabel ID=lblBranch runat="server" Text="Branch :" Visible=false></dx:ASPxLabel>
							</td>
							<td>
								<dx:aspxcombobox id=cboBranches runat="server" cssclass="form-control input-sm" AutoPostBack=true
									Theme=MetropolisBlue OnSelectedIndexChanged=cboBranches_SelectedIndexChanged Visible=false>
								</dx:aspxcombobox>
							</td>
						</tr>
						<tr>
							<td>Transfer To :</td>
							<td>
								<ajaxToolkit:AutoCompleteExtender ID=AutoCompleteExtender1 runat="server"
									CompletionListCssClass="completionList"
									CompletionListItemCssClass="listItem"
									CompletionListHighlightedItemCssClass="itemHighlighted"
									ServiceMethod="GetCompletionList"
									MinimumPrefixLength="1"
									CompletionInterval="10"
									EnableCaching="false"
									TargetControlID="txtEntity"
									FirstRowSelected="false"
									OnClientItemSelected="SelectedItem">
								</ajaxToolkit:AutoCompleteExtender>
								<asp:HiddenField ID=hdnEntity runat="server" />
								<asp:TextBox ID=txtEntity runat="server" CssClass="form-control input-sm">
								</asp:TextBox>
							</td>
						</tr>
						<tr>
							<td style="text-align: right">Quantity :</td>
							<td>
								<ss:ASPxTextBox ID=txtQuantity runat="server" CssClass="form-control input-sm"
									Width=50% Theme=MetropolisBlue HorizontalAlign=Right>
									<MaskSettings Mask="<0..99999999999999g>.<00..99>" />
								</ss:ASPxTextBox>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</form>
	</div>

	<!--================================================== 

	<script src="../../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../../js/bootstrap/bootstrap.min.js"></script>
        -->


    <script  src="https://code.jquery.com/jquery-3.7.1.min.js"  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="  crossorigin="anonymous"></script>
    <script  src="https://code.jquery.com/ui/1.14.0/jquery-ui.min.js"  integrity="sha256-Fb0zP4jE3JHqu+IBB9YktLcSjI1Zc6J2b6gTjB0LpoM="  crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>

	<script type="text/javascript" src="../../scripts/ssajax.js"></script>

	<script>
		function SelectedItem(source, eventArgs) {
			document.getElementById("hdnEntity").value = eventArgs.get_value();
		}
	</script>
</body>
</html>
