﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="AnnualIncomeAddEdit.aspx.cs" Inherits="Connect_DotNet.AnnualIncomeAddEdit" %>

<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<%@ Register Assembly="ssCommon" Namespace="ssCommon.Controls.BrowserControls" TagPrefix="ss" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>
	
	<!-- #CSS Links -->
	<!-- Basic Styles -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">

	<link href="../../css/your_style.css" rel="stylesheet" />
	<link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />

	<style>
		table td { vertical-align:middle !important; padding:2px !important }
		.alignRight { text-align:right }
		.noBorder { border:none !important }
			.noBorder td { border:none !important }
	</style>
</head>
<body>
	<br />
    <form id="frmAnnualIncome" runat="server">
    <table id=tblInput class="table table-responsive table-condensed noBorder">
		<colgroup><col style="width:30%"/><col style="width:35%"/><col style="width:35%"/></colgroup>
		<tr>
			<td class=alignRight>Financial Year</td>
			<td>
				<dx:ASPxComboBox ID=cboAccYear ClientInstanceName=cboAccYear runat="server" 
					CssClass="form-control input-sm" Theme=MetropolisBlue>
				</dx:ASPxComboBox>
			</td>
			<td></td>
		</tr>
		<tr>
			<td class=alignRight>Annual Income</td>
			<td>
				<dx:ASPxComboBox ID=cboAnnualIncome runat="server" 
					CssClass="form-control input-sm" Theme=MetropolisBlue>
					<Items>
						<dx:ListEditItem Selected="true" Text="Below Rs. 100000" Value="Below Rs. 100000" />
						<dx:ListEditItem Text="Rs. 100000 - 500000" Value="Rs. 100000 - 500000" />
						<dx:ListEditItem Text="Rs. 500000 - 1000000" Value="Rs. 500000 - 1000000" />
						<dx:ListEditItem Text="Rs. 1000000 - 2500000" Value="Rs. 1000000 - 2500000" />
						<dx:ListEditItem Text="Above Rs. 2500000" Value="Above Rs. 2500000" />
					</Items>
				</dx:ASPxComboBox>
			</td>
			<td></td>
		</tr>
		<tr>
			<td class=alignRight>Net Worth</td>
			<td>
				<ss:ASPxTextBox ID=txtNetWorth runat="server" CssClass="form-control input-sm" 
					Theme=MetropolisBlue  HorizontalAlign=Right>
					<MaskSettings Mask="<0..99999999999999g>.<00..99>" />
					<ValidationSettings CausesValidation=false ErrorDisplayMode=None>
					</ValidationSettings>
				</ss:ASPxTextBox>
			</td>
			<td></td>
		</tr>
		<tr>
			<td class=alignRight>Net Worth Date-Time</td>
			<td>
				<dx:ASPxDateEdit ID=dtNetWorth runat="server" EditFormat=Date EditFormatString="dd/MM/yyyy" 
					DisplayFormatString="dd/MM/yyyy" CssClass="form-control input-sm" Theme=MetropolisBlue>
				</dx:ASPxDateEdit>
			</td>
			<td>
				<dx:ASPxTimeEdit ID=tmNetWorth runat="server" EditFormat=Time EditFormatString="hh:mm:ss tt" 
					DisplayFormatString="hh:mm:ss tt" CssClass="form-control input-sm" Width=75% Theme=MetropolisBlue>
				</dx:ASPxTimeEdit>
			</td>
		</tr>
		<tr>
			<td></td>
			<td>
				<ss:ASPxCheckBox ID=chkCompleted runat="server" Text="Completed" Theme=MetropolisBlue>
				</ss:ASPxCheckBox>
			</td>
			<td></td>
		</tr>
    </table>
    </form>
</body>
</html>
