﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="KYCEmailVerificationReport.aspx.cs" Inherits="Connect_DotNet.KYCEmailVerificationReport" %>
<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title></title>

    <!-- #CSS Links -->
	<!-- Basic Styles -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/bootstrap.min.css">
	<link href="../../css/font-awesome.min.css" rel="stylesheet" />

	<!-- SmartAdmin Styles : Caution! DO NOT change the order -->
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production-plugins.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-production.min.css">
	<link rel="stylesheet" type="text/css" media="screen" href="../../css/smartadmin-skins.min.css">

	<!-- BootComplete http://getwebhelp.com/bootcomplete/ -->
	<link href="../../scripts/BootStrap/plugins/bootcomplete/bootcomplete.css" rel="stylesheet" />
	
	<!-- #GOOGLE FONT -->
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,700italic,300,400,700">
	
	<link href="../../css/your_style.css" rel="stylesheet" />
    <link href="../../css/font-awesome-animation.min.css" rel="stylesheet" />

    <style>
		
         .borderless td, .borderless th {
            border:none !important ;
        }
        .borderless > thead > tr > th, .borderless > tbody > tr > th, .borderless > tfoot > tr > th, .borderless > thead > tr > td, .borderless > tbody > tr > td, .borderless > tfoot > tr > td {
            padding: 1px !important ;
        }
      
        
         .dxgvCSD /*For grid*/
        {

             border-top: 1px solid;
             border-bottom: 1px solid;

             height: auto !important;
             max-height: 500px !important; /*Custom grid size*/

        }


	</style>

</head>
<body>
<div class="container-fluid">
		<h2><i class="fa fa-newspaper-o " aria-hidden="true"></i> KYC Verification Status</h2>
				<form id="frmLeadList" class="form-inline"  runat="server">
					<table id="tblInput" class="table table-condensed table-responsive">
						<tr>
							<td style="text-align:left">
                                <dx:ASPxComboBox ID=cboType runat="server" Native="true" CssClass="form-control input-sm">
                                    <Items>
                                        <%-- Add 'All' option for My Booked and Not Booked Leads--%>
                                        <dx:ListEditItem Selected="true" Text="Email Send but Verification Pending" Value="0" />
                                        <dx:ListEditItem Text="Email Verification Done" Value="1" />
                                        <dx:ListEditItem Text="Email in Queue" Value="2" />
                                        <dx:ListEditItem Text="Cross Verification Done" Value="3" />
                                    </Items>
                                    <ClientSideEvents SelectedIndexChanged="function(s, e) {
                                        grdKYCEmailVerificationList.Refresh();
                                        
                                        }">

                                    </ClientSideEvents>
                                </dx:ASPxComboBox>
							</td>
							<td style="text-align:right">
                            </td>
							<td style="text-align:left">
                                <dx:ASPxTextBox ID=txtSearch runat="server" Width="293px" MaxLength="100" ClientInstanceName="txtSearch" NullText="Search Client By Name, Mobile, Email, PAN" Native="true" CssClass="form-control input-sm">
                                    <ClientSideEvents KeyUp="function(s, e) {
                                                                        
                                                                        grdKYCEmailVerificationList.Refresh();}" TextChanged="function(s, e) {
                                                                        grdKYCEmailVerificationList.Refresh();}">
                                    </ClientSideEvents>
                                </dx:ASPxTextBox>
                                
							</td>
                            
						</tr>
						<tr>
							<td colspan="5">
                                <dx:ASPxGridView   ID="grdKYCEmailVerificationList" ClientInstanceName="grdKYCEmailVerificationList" runat="server" Theme="Office2010Silver" AutoGenerateColumns="False" KeyFieldName="SUBCD" Width="100%" PreviewFieldName="DESCR" OnHtmlRowCreated="grdKYCEmailVerificationList_HtmlRowCreated"  >
                                    <Settings  GridLines="Horizontal" ShowColumnHeaders="False" />
                                    <Columns>
                                        <dx:GridViewDataTextColumn Name="Client" VisibleIndex="1">
                                            <DataItemTemplate>
                                                <table class="table-condensed table-responsive borderless" style=" border: none">
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxLabel ID="ASPxLabel10" runat="server" Text='UCC' >
                                                            </dx:ASPxLabel>
                                                            :
                                                            <dx:ASPxLabel ID="ASPxLabel11" runat="server" Text='<%# Eval("NSE_ALIAS") %>' Font-Size="Small"></dx:ASPxLabel>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxLabel ID="ASPxLabel9" runat="server" Text='Name' >
                                                            </dx:ASPxLabel>
                                                            :
                                                            <dx:ASPxLabel ID="lblClient" runat="server" Text='<%# Eval("DESCR") %>' Font-Size="Small"></dx:ASPxLabel>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxLabel ID="ASPxLabel1" runat="server" Text='Email' >
                                                            </dx:ASPxLabel>
                                                            :
                                                            <dx:ASPxLabel ID="ASPxLabel2" runat="server" Text='<%# Eval("EMAIL") %>' ></dx:ASPxLabel>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxLabel ID="ASPxLabel3" runat="server" Text='Mobile' >
                                                            </dx:ASPxLabel>
                                                            :
                                                            <dx:ASPxLabel ID="ASPxLabel7" runat="server" Text='<%# Eval("PhoneCall") %>' ></dx:ASPxLabel>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxLabel ID="ASPxLabel5" runat="server" Text='Pan No' >
                                                            </dx:ASPxLabel>
                                                            :
                                                            <dx:ASPxLabel ID="ASPxLabel8" runat="server" Text='<%# Eval("PAN_NO") %>' ></dx:ASPxLabel>
                                                        </td>
                                                    </tr>
                                                    
                                                    </table>
                                            </DataItemTemplate>
                                        </dx:GridViewDataTextColumn>
                                        <dx:GridViewDataTextColumn Name="Branch"  VisibleIndex="2">
                                                <DataItemTemplate>
                                                    <table class="table-condensed table-responsive borderless">
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxLabel ID="ASPxLabel4" runat="server" Text='Branch' >
                                                            </dx:ASPxLabel>
                                                            :
                                                            <dx:ASPxLabel ID="ASPxLabel6" runat="server" Text='<%# Eval("BranchID") %>' ></dx:ASPxLabel>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxPanel ID="ASPxPanelAP" runat="server">
                                                                <PanelCollection>
                                                                    <dx:PanelContent runat="server">
                                                            <dx:ASPxLabel ID="lblAPText" runat="server" Text='AP' >
                                                            </dx:ASPxLabel>
                                                            :
                                                            <dx:ASPxLabel ID="lblAP" runat="server" Text='<%# Eval("AP") %>' ></dx:ASPxLabel>
                                                                        </dx:PanelContent>
                                                                </PanelCollection>
                                                            </dx:ASPxPanel>
                                                        </td>
                                                    </tr>
                                                    
                                                </table>
                                            </DataItemTemplate>
                                        </dx:GridViewDataTextColumn>
                                            <dx:GridViewDataTextColumn Name="Status"  VisibleIndex="3">
                                                <DataItemTemplate>
                                                    <table class="table-condensed table-responsive borderless">
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxLabel ID="lblStatustext" runat="server" Text='Status' >
                                                            </dx:ASPxLabel>
                                                            :
                                                            <dx:ASPxLabel ID="lblStatus" runat="server"  Text='<%# Eval("STATUS") %>' ></dx:ASPxLabel>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <dx:ASPxPanel ID="ASPxPanelCreateBy" runat="server">
                                                                <PanelCollection>
                                                                    <dx:PanelContent runat="server">
                                                                        <dx:ASPxLabel ID="lblCreateBytext" runat="server" Text="Create By">
                                                                        </dx:ASPxLabel>
                                                                        :
                                                                        <dx:ASPxLabel ID="lblCreateBy" runat="server" Text='<%# Eval("StaffName") %>'>
                                                                        </dx:ASPxLabel>
                                                                    </dx:PanelContent>
                                                                </PanelCollection>
                                                            </dx:ASPxPanel>
                                                        </td>
                                                    </tr>
                                                    <tr id="trButtons" runat="server" >
                                                        <td>
                                                             <a href="#"  title="Resend Email !" onclick="ResendEmail('<%# Eval("SUBCD") %>','<%# Eval("DESCR") %>', '<%# Eval("EMAIL") %>','<%= Session["orgcode"]%>', '<%= Session["cocd"]%>');" ><i class="fa fa-envelope" aria-hidden="true"></i> Resend</a>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </DataItemTemplate>
                                        </dx:GridViewDataTextColumn>
                                    </Columns>
                                    <SettingsPager Mode="EndlessPaging">
                                    </SettingsPager>
                                    <SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
                                    <Templates>
                                    </Templates>
                            
                                </dx:ASPxGridView>
							</td>
						</tr>
					</table>
				</form>
	</div>

	<!--================================================== -->
		
	<script src="../../js/libs/jquery-2.1.1.min.js"></script>
	<script src="../../js/bootstrap/bootstrap.min.js"></script>

	<!-- StanSoft Script -->
	<script src="../../scripts/ssajax.js"></script>
    <script>
        AddStyleToGrid();
            setInterval(AddStyleToGrid, 500);

            function AddStyleToGrid() {

                $('[id*="_DXMainTable"]').removeClass($('[id*="_DXMainTable"]').attr("class")).addClass("table table-hover table-condensed table-responsive ssGrid dataTable no-footer "); //body
                $('[class*="dxgvControl_"]').removeClass($('[class*="dxgvControl_"]').attr("class"));

            }


            function ResendEmail(subcd, name, email, user, cocd) {

                var result = confirm("Do you really want to Resend Email?");

                if (result) {
                    $.ajax({
                        type: "POST",
                        url: "KYCEmailVerificationReport.aspx/ResendEmail",
                        data: "{cSubcd:'" + subcd + "', cName:'" + name + "', cEmail:'" + email + "', cUser:'" + user + "', cCocd:'" + cocd + "'}",
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function () {
                            grdKYCEmailVerificationList.Refresh();
                        },
                        failure: function (response) {
                            alert(response.d);
                        }
                    })
                }
            }

    </script>
</body>
</html>
