﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="contact.aspx.cs" Inherits="Connect_DotNet.ReActivation.contact" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>Verify your Mobile and Email</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
</head>
<body>
    <style>
        .margineTop10{
            margin-top:10px
        }

    </style>
     <script>


         function requestData(reqType) {

             if (document.getElementById('divMobileNew').style.display == "block") {

                 if (!IsMobileNumber(document.getElementById('txtMobileNew'))) {
                     return;
                 }

             }
             
             if (document.getElementById('divEmailNew').style.display == "block") {

                 if (!ValidateEmail(document.getElementById('txtEmailNew'))) {
                     return;
                 }

             }

            document.getElementById('hdnBtnRequestClicked').value = reqType;
             $('#modalLoading').modal('show');
             document.getElementById('<%= btnRequest.UniqueID %>').click();


         }


         function IsMobileNumber(number) {

              if (number.value == "") {
                 alertModal("Error", "Please enter mobile!");
                 number.focus();
                 return false;
             }

                var val = number.value
                if (/^\d{10}$/.test(val)) {
                    // value is ok, use it
                    return true
                } else {
                    alertModal("Error", "Invalid number; must be 10 digits!");
                    //alert("Invalid number; must be 10 digits!")
                    number.focus()
                    return false
                }
         }

         function ValidateEmail(input) {

             if (input.value == "") {
                 alertModal("Error", "Please enter Email id!");
                 input.focus();
                 return false;
             }

            var validRegex = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;

            if (input.value.match(validRegex)) {

                input.focus();
                return true;

            } else {

                alertModal("Error", "Invalid email address!");

                input.focus();

                return false;

            }

        }


         function alertModal(title, body) {
              // Display error message to the user in a modal
              $('#alert-modal-title').html(title);
            $('#alert-modal-body').html(body);

            if (title.match("Error") == "Error") {
                $('#alert-modal-body').addClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-success");
            }

            else if (title == "Request added") {
                $('#alert-modal-body').addClass("alert-success");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
            }
            else
            {
                $('#alert-modal-body').addClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-success");
            }
            
             $('#alert-modal').modal('show');
             $('#modalLoading').modal('hide');
         }

        
    </script>

    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                    <div class="col-md-3">
                        <center>
                        <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:200px; padding-top:10px">
                        </center>
                    </div>
                    <div class="col-md-9">
                        <h2 class="lblTopHeader">Verify mobile/email <i class="fas fa-envelope fa-lg me-3 fa-fw"></i></h2>
                        <p>Please verify your <b>mobile number</b> and <b>email address</b>.</p>
                    </div>
                </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-10 col-lg-6">

                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnRequest" runat="server" Text="" OnClick="btnRequest_Click" /> 
                                    <input type="hidden" id="hdnBtnRequestClicked" name="hdnBtnRequestClicked" runat="server" value="">
                                </div>
                                <div class="d-flex flex-row align-items-center mb-4" id="divMobile"  runat="server"  style="display:none">
                                    <div class="form-outline flex-fill mb-0 margineTop10">
                                        <label class="form-label" for="txtMobile"><i class="fas fa-mobile fa-lg me-3 fa-fw"></i> Mobile</label>
                                        <input type="number"  class="form-control" id="txtMobile" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" readonly="readonly" placeholder="NA">
                                    </div>
                                </div>
                                <div class="d-flex flex-row align-items-center mb-4" id="divMobileNew"  runat="server">
                                    <div class="form-outline flex-fill mb-0 margineTop10">
                                      <label class="form-label" for="txtMobileNew"><i class="fas fa-mobile fa-lg me-3 fa-fw"></i> Mobile</label>
                                      <input type="number"  class="form-control" id="txtMobileNew" maxlength="10" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Mobile">
                                    </div>
                                </div>
                                <div class="d-flex flex-row align-items-center mb-4">
                                    <div class="form-outline flex-fill mb-0 margineTop10"  id="divEmail"  runat="server" style="display:none">
                                        <label class="form-label" for="txtEmail"><i class="fas fa-envelope fa-lg me-3 fa-fw"></i> Email</label>
                                        <input type="email"  class="form-control" id="txtEmail" maxlength="300" runat="server" readonly="readonly" placeholder="NA">
                                    </div>
                                </div>
                                <div class="d-flex flex-row align-items-center mb-4" id="divEmailNew"  runat="server">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                  <label class="form-label" for="txtEmailNew"><i class="fas fa-envelope fa-lg me-3 fa-fw"></i> Email</label>
                                  <input type="email"  class="form-control" id="txtEmailNew" maxlength="300" runat="server" placeholder="Enter Email">
                                  </div>
                              </div>
                              <div id="divButton"  runat="server">
                                  <small id="smMsg" runat="server">You will receive separate OTP on your <b>mobile</b> and <b>email</b></small>
                                  <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                    <button type="button" class="btn btn-primary btn-lg" id="btnSendOTP" onclick="requestData('Sent OTP')" runat="server" ><i class="fa fa-share-square" aria-hidden="true"></i> Continue</button>
                                  </div>
                                </div>
                                <div id="divOTP"  runat="server"  style="display:none">
                                    <h5 style="color:green" id="msgOTPSentSuccessfully" runat="server">OTP has been sent successfully to your Mobile number and Email id.</h5>
                                    <div class="row justify-content-center">
                                    <div class="col-lg-6">
                                        <div class="form-outline flex-fill mb-0 margineTop10">
                                            <label class="form-label" for="txtMobileOTP"><i class="fas fa-mobile fa-lg me-3 fa-fw"></i> Mobile OTP</label>
                                            <input type="number" class="form-control" id="txtMobileOTP" maxlength="6" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Mobile OTP">
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-outline flex-fill mb-0 margineTop10">
                                            <label class="form-label" for="txtEmailOTP"><i class="fas fa-envelope fa-lg me-3 fa-fw"></i> Email OTP</label>
                                            <input type="number" class="form-control" id="txtEmailOTP" maxlength="6" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Email OTP">
                                                                        
                                        </div>
                                    </div>
                                    </div>
                                                          
                                    <div style="text-align:left">
                                        <button type="button" class="btn btn-lg btn-success margineTop10" id="btnOTPEmailValidate" onclick="requestData('Validate OTP')"><i class="fa fa-check" aria-hidden="true"></i> Verify and confirm OTP</button>
                                        <button type="button" class="btn btn-lg btn-primary margineTop10" id="btnOTPEmailResend" onclick="requestData('Sent OTP')"><i class="fa fa-repeat" aria-hidden="true"></i> Resend OTP</button>
                                    </div>
                                    <br />
                                    <br />
                                    <span id="spanDebugOTP" runat="server" style="display:none"></span>
                                </div>

                            </ContentTemplate>
                        </asp:UpdatePanel>

                      </div>
                      <div class="col-md-10 col-lg-6 ">
                          <div class="YourDetailsPage_FeaturedImage FeaturedImage modal-content rounded-4 shadow">
                              <img src="../ekyc/images/ekyc-Aadhaar.png" class="YourDetailsPage_FeaturedIMG Featuredimg img-fluid" alt="FeaturedImage" style="width:100%">
                          </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
              <!--<div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>-->


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span></br>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
			    </div>
             </div>

          </div>
        </section>
        
    </form>

    <div id="alert-modal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="alert-modal-title" class="modal-title"></h4>
              </div>
              <div id="alert-modal-body" class="modal-body"></div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">OK</button>
              </div>
            </div>
          </div>
        </div>

    <div class="modal fade" id="modalLoading" tabindex="-1" role="dialog" aria-labelledby="modalLoadingLabel">
      <div class="modal-dialog modal-md">
        <div class="modal-content">
          <div class="modal-header">
          </div>
          <div class="modal-body">
              <center>
                    <h4>Please wait..Your request is being processed..</h4>
                    <p>Do not close browser window....</p>
                    <img src="../ekyc/images/Loading.gif" alt="Loading" style="width:150px;" />
               </center>
          </div>

          <div class="modal-footer">
          </div>
        </div>
      </div>
    </div>
</body>
</html>
