﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="capturePhoto.aspx.cs" Inherits="Connect_DotNet.ReKYC.capturePhoto" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>Capture your photo</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>


  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <style>
        .margineTop10{
            margin-top:10px
        }

    #videoContainer {
      position: relative;
      width: 100%; /* Adjust dimensions to match your video size */
      height: 100%;
    }

    #video {
      width: 100%;
      height: 100%;
      /* transform: scaleX(-1);*/ /* Flip the video horizontally */
    }

    #captureBox {
      position: absolute;
      border: 2px solid red; /* Adjust border style and color */
      width: 320px; /* Adjust square box dimensions */
      height: 320px;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      pointer-events: none; /* Ensures clicks pass through to the video element */
    }
  </style>
</head>
<body>
   
     <script>

        window.onload = function () {


            const videoElement = document.getElementById('video');
            const canvasElement = document.getElementById('canvas');
            const capturedImageElement = document.getElementById('capturedImage');
            const captureButton = document.getElementById('captureBtn');

            const captureBox = document.getElementById('captureBox');

            // Get user media - Access webcam
            navigator.mediaDevices.getUserMedia({ video: true })
                .then(function (stream) {
                    videoElement.srcObject = stream;

                    videoElement.onloadedmetadata = function (e) {
                        const actualWidth = videoElement.videoWidth;
                        const actualHeight = videoElement.videoHeight;
                        const aspectRatio = actualWidth / actualHeight;

                        //alert(actualWidth);
                        //alert(actualHeight);
                        //alert(aspectRatio);
                        //alert(actualWidth/aspectRatio);

                        document.getElementById('hdnActualWidth').value = actualWidth;
                        document.getElementById('hdnActualHeight').value = actualHeight;
                        document.getElementById('hdnActualAspectRatio').value = aspectRatio;

                        let captureBoxWidth = actualWidth*0.75;
                        
                        if (aspectRatio > 1) {
                            captureBoxWidth = actualHeight*0.75;
                        }

                        document.getElementById('hdnCaptureBoxWidth').value = captureBoxWidth;
                        

                        document.getElementById("captureBox").style = "position: absolute; border: 2px solid red; width: " + captureBoxWidth + "px; height: " + captureBoxWidth + "px; top: 50%; left: 50%; transform: translate(-50%, -50%); pointer-events: none; }";
                        // Here, you can use or display the obtained width, height, or aspect ratio as needed
                    };

                })
                .catch(function (error) {
                    console.error('Error accessing the webcam:', error);
                });



        }


         function saveData() {
             document.getElementById('hdnBtnContinueClicked').value = "Save";
             $('#modalLoading').modal('show');
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
         }

         function sendCapturedlink(value) {
             document.getElementById('hdnBtnContinueClicked').value = value;

             $('#modalLoading').modal('show');
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
         }

         function CapturedPhoto() {
             const videoElement = document.getElementById('video');
             const canvasElement = document.getElementById('canvas');
             const capturedImageElement = document.getElementById('capturedImage');
             const captureButton = document.getElementById('captureBtn');

             let canvasElementHeight = 480;

                //canvasElement.width = canvasElementHeight*document.getElementById('hdnActualAspectRatio').value;
                //canvasElement.height = canvasElementHeight;

                canvasElement.width = document.getElementById('hdnActualWidth').value;
                canvasElement.height = document.getElementById('hdnActualHeight').value;

                canvasElement.getContext('2d').drawImage(videoElement, 0, 0, canvasElement.width, canvasElement.height);

                //capturedImageElement.src = canvasElement.toDataURL('image/png');
                //capturedImageElement.style.display = 'block';

                document.getElementById('hdnImage').value = canvasElement.toDataURL('image/png');

                setTimeout(
                    function () {
                        document.getElementById('hdnBtnContinueClicked').value = "Capture";
                        document.getElementById('<%= btnContinueClick.UniqueID %>').click();
                    }
                    , 500);
         }

         function alertModal(title, body) {


             // Display error message to the user in a modal
             $('#alert-modal-title').html(title);
             $('#alert-modal-body').html(body);

             if (title.match("Error") == "Error") {
                 
                 $('#alert-modal-body').addClass("alert-danger");
                 $('#alert-modal-body').removeClass("alert-info");
                 $('#alert-modal-body').removeClass("alert-success");

             }

             else if (title.match("success") == "success") {
                 $('#alert-modal-body').addClass("alert-success");
                 $('#alert-modal-body').removeClass("alert-info");
                 $('#alert-modal-body').removeClass("alert-danger");

                 if (title == "Link send successfully") {

                     document.getElementById("divContinueIfDone").style = "display:block";
                     document.getElementById("divContinueNext").style = "display:none";
                 }

             }
             else {
                 $('#alert-modal-body').addClass("alert-info");
                 $('#alert-modal-body').removeClass("alert-danger");
                 $('#alert-modal-body').removeClass("alert-success");
             }

             $('#alert-modal').modal('show');
             $('#modalLoading').modal('hide');
         }

    </script>

    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <h2><i class="fa fa-camera" aria-hidden="true"></i> Capture your photo</h2>
              <p>Requesting to capture your photo. Your recent photo need to be submitted</p>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">
      
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div class="row">
                                          <div class="col-md-8">
                                              <div id="divData">
                                                
                                                <div class="row">
                                                    <div class="col-sm-12">

                                                        <div id="videoContainer">
                                                            <video id="video" autoplay></video>
                                                            <div id="captureBox"></div>
                                                        </div>
                                                        <canvas id="canvas" style="display: none;"></canvas>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm-12">
                                                        <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                                                            <ContentTemplate>
                                                                <div style="display:none">
                                                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                                                </div>
                                                                <div id="divContinueNext">
                                                                    <button id="captureBtn" class="btn btn-lg btn-primary" onclick="CapturedPhoto();"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</button>
                                                                    <a href="javascript:sendCapturedlink('Send');" >Don't have a camera? Send Webcam verification (IPV) link to your mobile and email</a>
                                                                </div>
                                                                <div id="divContinueIfDone" style="display:none">
                                                                    <a class="btn btn-success btn-lg" id="btnContinueIfDone" onclick="sendCapturedlink('Done');" style="margin-top:5px"><i class="fa fa-check" aria-hidden="true"></i> Continue</a>
                                                                </div>
                                                                <br />
                                                                <br />
                                                                <div id="divCapturedPhoto" runat="server" style="display:none">
                                                                    <h3>Your captured photo</h3>
                                                                    <div class="row">
                                                                        <div class="col-md-4">
                                                                            <img id="capturedImage" name="capturedImage" class="img-responsive" src="" alt="Captured Image" runat="server">
                                                                        </div>
                                                                        <div class="col-md-8">
                                                                             <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4">
                                                                                <div class="alert alert-warning">
                                                                                    <strong>Warning!</strong> Please remember that: <br />
                                                                                    <span id="span1" runat="server">
                                                                                       Photo must show both edges of the face clearly. The eyes must be open, level and clearly visible and must not be covered by hairs or eyeglass frames. And your face should be match with your Aadhaar otherwise your application will be rejected
                                                                                    </span>
                                                                                </div>
                                                                            </div>
                                                                              <div style="padding-left:10px;">
                                                                                <button type="button" class="btn btn-success btn-lg" id="btnSaveContinue" onclick="saveData();" runat="server" style="margin-top:5px" ><i class="fa fa-check" aria-hidden="true"></i> Save & Continue</button> 
                                                                                <button id="reCaptureBtn" class="btn btn-lg  btn-warning" onclick="CapturedPhoto();" style="margin-top:5px"><i class="fa fa-camera" aria-hidden="true"></i> Capture again</button>
                                                                                <p>
                                                                                        <br />
                                                                                        <i>
                                                                                        *By clicking the above <b>'Save and Continue'</b> button, I agree that i have read <a href="#">Terms & Conditions</a>.
                                                                                        </i>
                                                                                    </p>

                                                                                    <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                                                                    </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                
                                                               <div style="display:none">
                                                                <input type="hidden" id="hdnImage" name="hdnImage" runat="server" value="">
                                                                 <input type="hidden" id="hdnActualWidth" name="hdnActualWidth" runat="server" value="">
                                                                 <input type="hidden" id="hdnActualHeight" name="hdnActualHeight" runat="server" value="">
                                                                 <input type="hidden" id="hdnActualAspectRatio" name="hdnActualAspectRatio" runat="server" value="">
                                                                 <input type="hidden" id="hdnCaptureBoxWidth" name="hdnCaptureBoxWidth" runat="server" value="">
                                                                </div>
                                                         </ContentTemplate>
                                                    </asp:UpdatePanel>
                                                    </div>
                                                </div>
                                            </div>
                                              <hr />
                                          </div>
                                          <div class="col-md-4">
                                              <div class="row">
                                                  <div class="col-xs-6">
                                                      <center>
                                                      <img id="ImgAadhaar" width="160" height="200" src="" alt="Aadhaar Photo" runat="server">
                                                      <br />
                                                      <span>Fetch from Aadhaar</span>
                                                       </center>
                                                  </div>
                                                  <div class="col-xs-6">
                                                      <center>
                                                      <img id="ImgLivePhotoCaptured" width="160" height="200" src="" alt="Aadhaar Photo" runat="server">
                                                      <br />
                                                      <span>Live photo captured</span>
                                                       </center>
                                                  </div>
                                              </div>
                                              <br />
                                              <h2 id="hFullName" runat="server"></h2>
                                              <p>
                                              Date of Birth : <u><span id="spanDOB" runat="server"></span></u>
                                              <br />
                                              Mobile : <u><span id="spanMobile" runat="server"></span></u>
                                              <br />
                                              Email : <u><span id="spanEmail" runat="server"></span></u>
                                              <br />
                                              Permanent Address : <u><span id="spanPermanentAddress" runat="server"></span></u>
                                              <br />
                                              Correspondence Address : <u><span id="spanCorrespondenceAddress" runat="server"></span></u>
                                             </p>

                                          </div>
                                      </div>
                                  </div>
                              </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
                
            </div>


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
                      <br />
                      <br />
			    </div>
                
             </div>

          </div>
        </section>
    </form>
     <div id="alert-modal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="alert-modal-title" class="modal-title"></h4>
              </div>
              <div id="alert-modal-body" class="modal-body"></div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">OK</button>
              </div>
            </div>
          </div>
        </div>

     <div class="modal fade" id="modalLoading" tabindex="-1" role="dialog" aria-labelledby="modalLoadingLabel">
      <div class="modal-dialog modal-md">
        <div class="modal-content">
          <div class="modal-header">
          </div>
          <div class="modal-body">
              <center>
                    <h4>Please wait..Your request is being processed..</h4>
                    <p>Do not close browser window....</p>
                    <img src="Loading.gif" alt="Loading" style="width:150px;" />
               </center>
          </div>

          <div class="modal-footer">
          </div>
        </div>
      </div>
    </div>

</body>
</html>
