﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="dematAccount.aspx.cs" Inherits="Connect_DotNet.ReKYC.dematAccount" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Assembly="DevExpress.Web.v14.2, Version=14.2.3.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<!DOCTYPE html>

<html>
<head runat="server">
  <title>DP Details</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <link href="../eKyc/css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="../eKyc/js/ekyc.js"></script>

</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }


    </style>
     <script>

         window.onload = function () {

              if (document.getElementById('hdnMsgModalOpen').value != "") {

                 const hdnMsgModalOpenArray = document.getElementById('hdnMsgModalOpen').value.split("####");
                 var titleMsg = hdnMsgModalOpenArray[0];
                 var Msg = hdnMsgModalOpenArray[1];

                 document.getElementById('hdnMsgModalOpen').value = "";
                 alertModal(titleMsg, Msg);

             }

         }

         function disableCopyPaste(event) {
             event.preventDefault();
             alert("Copy-paste is disabled for this field.");
         }

         function CleanExistingFileData() {

             document.getElementById('spanDPClientMasterAsyncFileUpload').innerHTML = "";
             document.getElementById('spanDPClientMasterAsyncFileUpload').style.backgroundColor = "white";

             document.getElementById('spanUnfreezeDPClientMasterAsyncFileUpload').innerHTML = "";
             document.getElementById('spanUnfreezeDPClientMasterAsyncFileUpload').style.backgroundColor = "white";

             CleanExistingFileFileUpload('<%= dpClientMasterAsyncFileUpload.ClientID %>');
             CleanExistingFileFileUpload('<%= UnfreezeDPClientMasterAsyncFileUpload.ClientID %>');

         }

         function CleanExistingFileFileUpload(asyncFileUploadID) {

               // Find the file upload control by its ID
             var asyncFileUpload = document.getElementById(asyncFileUploadID);

             // Find the input of type 'file' inside the div
             const fileInput = asyncFileUpload.querySelector("input[type='file']");

             // Find the input of type 'hidden' inside the div
             const hiddenInput = asyncFileUpload.querySelector("input[type='hidden']");

             fileInput.value = ''; // Clear the input
             hiddenInput.value = '';
         }

         function addDP() {

             if (document.getElementById('selectDPType').value == "") {
                 alertModal("Oops! Problem with Demat Account", "Please select DP Type");
                 return;
             }

             if (document.getElementById('txtDPName').value == "") {
                 alertModal("Oops! Problem with Demat Account", "Please enter your DP Name");
                 return;
             }

             if (document.getElementById('txtDPID').value == "") {
                 alertModal("Oops! Problem with Demat Account", "Please enter your DPID");
                 return;
             }

             if (document.getElementById('txtDPClientID').value == "") {
                 alertModal("Oops! Problem with Demat Account", "Please enter your DP Client ID");
                 return;
             }

             if (validateFileExtensionByFileName(document.getElementById('spanDPClientMasterAsyncFileUpload').innerHTML, "DP Client Master", "JPG,PNG,JPEG,PDF") == false) {
                 return;
             }

             document.getElementById('hdnBtnContinueClicked').value = "Add DP" + "#" + document.getElementById('txtDPID').value + "#" + document.getElementById('txtDPClientID').value;
             $('#AddDPModal').modal('hide');
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();

         }

          function SetPrimaryDP() {
             document.getElementById('hdnBtnContinueClicked').value = "Set Primary DP" + "#" + document.getElementById("txtSetPrimaryDPID").value + document.getElementById("txtSetPrimaryDPClientID").value;
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
         }

         function UnfreezeDP() {

             if (document.getElementById('spanUnfreezeDPClientMasterAsyncFileUpload').innerHTML == "") {
                 
             }

             if (validateFileExtensionByFileName(document.getElementById('spanUnfreezeDPClientMasterAsyncFileUpload').innerHTML, "DP Client Master", "JPG,PNG,JPEG,PDF") == false) {
                 return;
             }

             document.getElementById('hdnBtnContinueClicked').value = "Unfreeze DP" + "#" + document.getElementById("txtUnfreezeDPID").value + document.getElementById("txtUnfreezeDPClientID").value;
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
         }

         function addDPPopup() {

            document.getElementById("txtDPID").value = "";
            document.getElementById("txtDPClientID").value = "";
            document.getElementById("txtDPName").value = "";
            document.getElementById("selectDPType").value = "Secondary";
            document.getElementById("spanDPClientMasterAsyncFileUpload").innerHTML = "";

            $('#AddDPModal').modal('toggle');
         }

         function removeDPPopup(TYPE, DPID, CLIENTID, DPName) {

             $('#confirmRemoveDPModalbody').html("Do you really want to remove DP ID" + DPID + " - ClientID: " + CLIENTID + "?");
            
             document.getElementById("hdnRemoveDPID").value = DPID;
             document.getElementById("hdnRemoveDPClientID").value = CLIENTID;

             $('#confirmRemoveDPModal').modal('show');
         }

         function removeDP(DPID, ClientID) {

              $('#confirmRemoveDPModal').modal('hide');

             document.getElementById('hdnBtnContinueClicked').value = "Remove DP" + "#" + hdnRemoveDPID + "#"+ hdnRemoveDPClientID;

             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
         }

         function unfreezeDPPopup(TYPE, DPID, CLIENTID, DPName) {

             document.getElementById("txtUnfreezeDPName").value = DPName;
             document.getElementById("txtUnfreezeDPID").value = DPID
             document.getElementById("txtUnfreezeDPClientID").value = CLIENTID;
             document.getElementById("hdnUnfreezeDPID").value = DPID;

             $('#confirmUnfreezeDPModal').modal('show');
         }


         function setPrimaryDPPopup(TYPE,DPID,CLIENTID,DPName) {

            if (TYPE == "Primary") {
                alertModal("Change this DP type as Primary", "Your available primary DP will be automatically changed as <b>secondary</b>");
            }

            document.getElementById("txtSetPrimaryDPName").value = DPName;
            document.getElementById("txtSetPrimaryDPID").value = DPID
            document.getElementById("txtSetPrimaryDPClientID").value = CLIENTID;
            document.getElementById("hdnSetPrimaryDPID").value = DPID;

            $('#confirmSetPrimaryDPModal').modal('show');
        }






         function dematAccountSelect() {

             if (document.getElementById('selectOpenDematAccount').value == "No") {
                 document.getElementById('divDepository').style.display = "none";
                 document.getElementById('divExistingDematAccount').style.display = "block";
                 document.getElementById('selectExistingDematAccount').value = "Yes";
             }
             else {
                 document.getElementById('divDepository').style.display = "block";
             }

             
         }

         function existingDematAccountSelect() {

             if (document.getElementById('selectExistingDematAccount').value == "No") {
                 document.getElementById('selectOpenDematAccount').value = "Yes";
                 document.getElementById('divDepository').style.display = "block";
                 document.getElementById('divExistingDematAccount').style.display = "none";
             }
             else {
                 document.getElementById('divExistingDematAccount').style.display = "block";
             }

         }

         function saveData() {


             if (document.getElementById('selectDDPI').value == "Yes" && document.getElementById("divDDPI").style.display === "block") {

                 $('#modalDDPITerms').modal('show');
                 return;
             }

             saveDataFinally();
             
         }

         function saveDataFinally() {

             document.getElementById('hdnBtnContinueClicked').value = "SaveDPDetals";

             showModalLoading();
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
         }


         function validateFileExtensionByFileName(fileName, uploadType, fileTypes) {


             if (fileName == "") {
                 alertModal("Oops! Problem with DP Master file upload", "Please select and upload the DP Master file in " + fileTypes + " format");
                 return false;
             }

             const fileTypesArray = fileTypes.split(",");

             let matchesNameExtns = "";
             for (let i = 0; i < fileTypesArray.length; i++) {

                 if (i == fileTypesArray.length - 1) {
                     matchesNameExtns += "." + fileTypesArray[i] + "$";
                 }
                 else {
                     matchesNameExtns += "." + fileTypesArray[i] + "$|";
                 }

             }

             var fileElementFileName = fileName.toUpperCase();

             if (fileElementFileName.match(matchesNameExtns) == null) {
                 alertModal("Oops! Problem with DP Master file upload", "Invalid file selected! Please select and upload the DP Master file in " + fileTypes + " format!");
                 return false;
             }

             return true;

         }


         function successAsyncFileUpload(sender, args) {

             const contolName = $(sender._element).find('input').attr('id');
             $(sender._element).find('input').css("background-color", "white");

             var filename = $(sender._element).find('input').val().replace("C:\\fakepath\\", "");

             if ($(sender._element).find('input').attr('id').match("dpClientMasterAsyncFileUpload") == "dpClientMasterAsyncFileUpload") {
                 document.getElementById('spanDPClientMasterAsyncFileUpload').innerHTML = filename;
                 document.getElementById('spanDPClientMasterAsyncFileUpload').style.backgroundColor = "lime";
             }

             if ($(sender._element).find('input').attr('id').match("UnfreezeDPClientMasterAsyncFileUpload") == "UnfreezeDPClientMasterAsyncFileUpload") {
                 document.getElementById('spanUnfreezeDPClientMasterAsyncFileUpload').innerHTML = filename;
                 document.getElementById('spanUnfreezeDPClientMasterAsyncFileUpload').style.backgroundColor = "lime";
             }

         }


        
    </script>
    


    <form id="form1" runat="server" enctype="multipart/form-data">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                    <div class="col-md-3">
                        <center>
                        <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:180px; height:80px; padding-top:10px">
                        </center>
                    </div>
                    <div class="col-md-6">
                        <h2 class="lblTopHeader"><i class="fa fa-university" aria-hidden="true"></i> Demat Account</h2>
                        <p>Reactive your existing demat account</p>
                    </div>
                    <div class="col-md-3" style="display:flex;flex-direction:column;align-items:flex-end;">
                        <h5 id="hFullName" style="margin:0px;" runat="server"></h5>
                        <span>UCC: <span id="spanUCC" runat="server"></span></span>
                        <span>DOB: <span id="spanDOB" runat="server"></span></span>
                        <span>PAN: <span id="spanPAN" runat="server"></span></span>
                        <span style="display:none">Aadhaar: <span id="spanAadhaar" runat="server"></span></span>
                        <span style="display:none" id="spanMobile" runat="server"></span>
                        <span style="display:none" id="spanEmail" runat="server"></span>
                   </div>
                </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">
                            <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                                <ContentTemplate>
                                    <div style="display:none">
                                        <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                        <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                        <input type="hidden" id="hdnMsgModalOpen" name="hdnMsgModalOpen" runat="server" value="">
                                    </div>
                                  <div class="d-flex flex-row align-items-center mb-4">
                                      <div class="form-outline flex-fill mb-0 margineTop10">
                                          <div class="row">
                                              <div class="col-md-8">
                                                <div class="form-outline flex-fill mb-0">
                                                    <div id="divDDPI" runat="server">
                                                        <p>By activing DDPI you can skip TPIN or OTP forever for sell orders</p>
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <h3>Do you wish to activate DDPI?</h3>
                                                                <p>Sell without TPIN. <a href="../ekyc/terms.aspx?type=DDPI" target="_blank">Read More..</a></p>
                                                            </div>
                                                            <div class="col-md-5">
                                                                <select class="form-control" style="width:50%; margin-top:10px" disabled="disabled" id="selectDDPI" runat="server">
                                                                    <option>Yes</option>  
                                                                    <option>No</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                  <h4>Choose a Demat account to activate DDPI:</h4>
                                                            </div>
                                                            <div class="col-sm-5">
                                                                <asp:DropDownList ID="cmbDDPIdpClientId" CssClass="form-control" runat="server">
                                                                </asp:DropDownList>
                                                            </div>
                                                        </div>
                                                        
                                                    </div>
                                                </div>
                                                  <hr />
                                                  <div id="divDematAccounts" runat="server">
                                                      <h2><i class="fa fa-list-alt" aria-hidden="true"></i> <b>Demat</b> Accounts</h2>   
                                                      <div class="row">
                                                        <div class="col-md-12">
                                                            <div id="divAddDP" runat="server">
                                                                <button type="button" class="btn btn-primary btn-sm" id="btnAddDP" style="margin-bottom:20px" onclick="addDPPopup();"><i class="fa fa-plus" aria-hidden="true"></i> Add New DP</button>
                                                            </div>
                                                            <dx:ASPxGridView ID="grdDP" OnHtmlRowPrepared="grdDP_HtmlRowPrepared"  ClientInstanceName="grdDP" AutoGenerateColumns="False" CssClass="table" Theme="MetropolisBlue" Width="100%" runat="server">
                                                                <Columns>
                                                                    <dx:GridViewDataMemoColumn FieldName="DPName" CellStyle-HorizontalAlign="Left" Caption="DP Name" Width="35%" VisibleIndex="0">
                                                                        <CellStyle HorizontalAlign="Left"></CellStyle>
                                                                          <DataItemTemplate>
                                                                            <span><%# Eval("TYPE") %></span> : <span><%# Eval("DPName") %></span>
                                                                            <div >
                                                                                <button type="button" class="btn btn-default btn-xs" style=" display:<%# Eval("btnDisplay") %>" onclick="setPrimaryDPPopup('<%# Eval("TYPE") %>','<%# Eval("DPID") %>','<%# Eval("CLIENTID") %>','<%# Eval("DPName") %>')"><i class="fa fa-edit" aria-hidden="true"></i> Set Primary</button>
                                                                                <button type="button" class="btn btn-info btn-xs" style=" display:<%# Eval("unfreezeDisplay") %>" onclick="unfreezeDPPopup('<%# Eval("TYPE") %>','<%# Eval("DPID") %>','<%# Eval("CLIENTID") %>','<%# Eval("DPName") %>')"><i class="fa fa-unlock" aria-hidden="true"></i> Unfreeze</button>
                                                                                <button type="button" class="btn btn-danger btn-xs" style=" display:<%# Eval("removebtnDisplay") %>" onclick="removeDPPopup('<%# Eval("TYPE") %>','<%# Eval("DPID") %>','<%# Eval("CLIENTID") %>','<%# Eval("DPName") %>')"><i class="fa fa-unlock" aria-hidden="true"></i> Remove</button>
                                                                            </div>
                                                                        </DataItemTemplate>
                                                                    </dx:GridViewDataMemoColumn>
                                                                    <dx:GridViewDataTextColumn FieldName="DPID" Width="30%" Caption="DP Id" VisibleIndex="2">
                                                                        <DataItemTemplate>
                                                                            <span><%# Eval("DPID") %></span>
                                                                        </DataItemTemplate>
                                                                    </dx:GridViewDataTextColumn>
                                                                    <dx:GridViewDataTextColumn FieldName="CLIENTID" Width="25%" Caption="Client ID" VisibleIndex="3">
                                                                        <DataItemTemplate>
                                                                            <span><%# Eval("ClientID") %></span>
                                                                        </DataItemTemplate>
                                                                    </dx:GridViewDataTextColumn>
                                                                    <dx:GridViewDataTextColumn Width="60px" FieldName="modStatus" Caption="Status" VisibleIndex="4">
                                                                            <CellStyle HorizontalAlign="Center"></CellStyle>
                                                                        <DataItemTemplate>
                                                                            <span><%# Eval("modStatus") %></span>
                                                                        </DataItemTemplate>
                                                                    </dx:GridViewDataTextColumn>
                                                                  </Columns>
                                                                  <SettingsBehavior AllowFocusedRow="True"></SettingsBehavior>
                                                                  <SettingsPager Mode="EndlessPaging">
                                                                  </SettingsPager>
                                                                  <Settings ShowGroupedColumns="True" ShowGroupPanel="False" GridLines="Horizontal" />
                                                                  <SettingsDetail ShowDetailRow="false" />
                                                                  <SettingsDataSecurity AllowDelete="False" AllowEdit="False" AllowInsert="False" />
                                                                  <Styles>
                                                                    <Header Font-Bold="False" Font-Underline="False" VerticalAlign="Middle">
                                                                    </Header>
                                                                    <Cell>
                                                                        <BorderBottom BorderColor="#336666" BorderStyle="Solid" BorderWidth="1px" />
                                                                    </Cell>
                                                                    <FocusedRow BackColor="WhiteSmoke">
                                                                    </FocusedRow>
                                                                    <Cell ForeColor="Black"></Cell>
                                                                </Styles>
                                                              </dx:ASPxGridView>
                                                        </div>
                                                      </div>
                                                  </div>
                                                   <div id="divButton" runat="server">
                                                      <br />
                                                      <button type="button" class="btn btn-success btn-lg" id="btnContinue" onclick="saveData();" runat="server" ><i class="fa fa-check" aria-hidden="true"></i> Save & Continue</button>
                                                        <p>
                                                            <br />
                                                            <i>
                                                            *By clicking the above button, I agree that i have read <a href="../ekyc/terms.aspx" target="_blank">Terms & Conditions</a>.
                                                            </i>
                                                        </p>
                                                   </div>
                                                    <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                                    </div>
                                                    <br />
                                              </div>
                                              <div class="col-md-4">
                                                  <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                                    <br />
                                                  <div class="alert alert-info" id="divAlertInfoMsg" runat="server" style="margin-top:10px;padding-top:10px; display:none">
                                                  </div>
                                                  <div class="alert alert-info" >
                                                      A <b>Demat account</b> (short for dematerialized account) is necessary for opening a trading account because it serves as the repository for holding and managing your securities (such as shares, bonds, mutual funds, ETFs, etc.) in an electronic format. 
                                                      <hr />
                                                      <b>DDPI</b> stands for Demat Debit and Pledge Instruction. It is an authorization given by an investor to their Depository Participant (DP) or broker to debit securities from their Demat account for the purpose of trading, pledging, or other transactions.
                                                  </div>
                                                  <div class="alert alert-warning" style="margin-top:10px;padding-top:10px">
                                                     <strong>Warning!</strong> If you already have an <b>existing Demat account</b>, you’ll need to upload a signed and stamped copy of your <b>client master</b>, obtained from your Depository Participant (DP). If the document is not uploaded, your request may be rejected. 
                                                      <hr />
                                                      Please ensure that the files you upload are <b>not password-protected</b> and <b>not corrupted</b>
                                                  </div>
                                              </div>
                                                 <p style="display:none">
                                                   Address : <u><span id="spanAddress" runat="server"></span></u>
                                                 </p>
                                                 <br />
                                                 <p style="display:none">
                                                     <b><span id="spanBrokerName" runat="server">Standard Broker</span></b> for conducting online ReKYC for trading and demat account
                                                 </p>
                                                 
                                              </div>
                                          </div>

                                      </div>
                                  </div>
                                </ContentTemplate>
                            </asp:UpdatePanel>
                               <hr />
                              <div id="divPreviousSteps" runat="server">
                                <h4>Go to previous step </h4> 
                                <ul class="list-inline">
                                    <li><a href="ConfirmDetails.aspx?cnfmrset=1" id="hlinkChooseParameters" runat="server"><i class="fa fa-solid fa-list-check" aria-hidden="true"></i> Reset Modifications</a></li>
                                    <li><a href="contact.aspx" id="hlinkContact" runat="server"><i class="fas fa-envelope fa-lg me-3 fa-fw" aria-hidden="true"></i> Contact</a></li>
                                    <li><a href="DigiLockerKYC.aspx" id="hlinkDigiLocker" runat="server"><i class="fa fa-cloud-download" aria-hidden="true"></i> DigiLocker</a></li>
                                    <li><a href="manuallyProcessing.aspx" id="hlinkManuallyProcessing" runat="server"><i class="fa fa-id-card" aria-hidden="true"></i> <span id="spanManuallyProcessing" runat="server">Address|DOB</span> </a></li>
                                    <li><a href="takePhoto.aspx" id="hlinkCapturePhoto" runat="server"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                    <li><a href="incomeProfile.aspx" id="hlinkIncomeProfile" runat="server"><i class="fa fa-inr" aria-hidden="true"></i> Income Profile</a></li>
                                    <li><a href="TradingPreference.aspx" id="hlinkTradingPreference" runat="server"><i class="fa fa-exchange" aria-hidden="true"></i> Trading Preference</a></li>
                                    <li><a href="BankDetails.aspx" id="hlinkBankDetails" runat="server"><i class="fa fa-university" aria-hidden="true"></i> Bank</a></li>
                                    <li><a href="Nomination.aspx" id="hlinkNomination" runat="server"><i class="fa fa-users" aria-hidden="true"></i> Nomination</a></li>
                                    <li><a href="AuthorizedRepresentative.aspx" id="hlinkAuthorizedRepresentative" runat="server"><i class="fa fa-user-circle" aria-hidden="true"></i> Authorized Representative</a></li>
                                    <li><a href="uploadDocuments.aspx" id="hlinkUploadDocuments" runat="server"><i class="fa fa-upload" aria-hidden="true"></i> Upload documents</a></li>
                                </ul>
                            </div>

                      </div>
                    </div>
                  </div>
                </div>
              </div>
                
            </div>


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
                      <br />
                      <br />
			    </div>
                
             </div>

          </div>
        </section>

        <div id="AddDPModal" class="modal fade">
            <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="AddDPHeader"><i class="fa fa-plus" aria-hidden="true"></i> Add DP</h4>
                </div>
                <div class="modal-body">
                    
                    <div class="row" style="padding-top:10px">
                        
                      <div class="col-sm-6">
                          <div class="form-group">
                              <label for="selectDPType" class="control-label col-sm-4">Type:</label>
                              <div class="col-sm-8">
                                <select class="form-control" id="selectDPType" onchange="if(this.value=='Primary'){alertModal('New DP selected as Primary', 'Your available primary DP will be automatically changed as <b>secondary</b>');}" runat="server">
                                    <option>Primary</option>
                                    <option selected="selected">Secondary</option>
                                </select>
                              </div>
                           </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="txtDPName" class="control-label col-sm-4">DP Name*:</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" id="txtDPName" runat="server" placeholder="DP Name" maxlength="40">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" style="padding-top:10px">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="txtDPID" class="control-label col-sm-4">DP ID*:</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" id="txtDPID" runat="server" maxlength="8" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" 
                                        onkeypress="CleanExistingFileData();"   oncopy="disableCopyPaste(event)" 
                                        onpaste="disableCopyPaste(event)" 
                                        oncut="disableCopyPaste(event)" 
                                        placeholder="DP ID">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="txtDPClientID" class="control-label col-sm-4">Client ID*:</label>
                                <div class="col-sm-8">
                                    <input  type="number" class="form-control" id="txtDPClientID" maxlength="8" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"
                                        onkeypress="CleanExistingFileData();"   oncopy="disableCopyPaste(event)" 
                                        onpaste="disableCopyPaste(event)" 
                                        oncut="disableCopyPaste(event)" 
                                        runat="server" placeholder="Client ID">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" style="padding-top:10px">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="dpClientMasterAsyncFileUpload" class="control-label col-sm-4">Upload Client Master*:</label>
                                <div class="col-sm-8">
                                    <ajaxToolkit:AsyncFileUpload ID="dpClientMasterAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="dpClientMasterAsyncFileUpload_UploadedComplete" runat="server" />
                                    <span id="spanDPClientMasterAsyncFileUpload" runat="server"></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                        </div>
                    </div>
                    <div class="row" style="padding-top:10px">
                        <div class="col-sm-2">
                        </div>
                        <div class="col-sm-10">
                            <span class="explanation">WARNING: If the account you are adding is not held with our DP, you must upload a signed and stamped copy of the Client Master provided by your DP. Failure to upload the document may result in the rejection of your request.</span>
                        </div>
                    </div>
                </div>

                <div class="modal-footer" style="text-align:center">
                    <div id="divAddDPModalFooter">
                        <button type="button" class="btn btn-primary" onclick="addDP()">Add DP</button>
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </div>
            </div>
        </div>    

        <div id="confirmSetPrimaryDPModal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                  <h3 id="confirmSetPrimaryDPModalHeader"><i class="fa fa-university" aria-hidden="true"></i> Set Primary DP </h3>
              </div>
              <div class="modal-body">
                  <p id="confirmSetPrimaryDPModalbody">Do you really want to set this DP as Primary?</p>
                  <br />
                  <div class="row" style="padding-top:10px">
                       <div class="col-sm-12">
                            <div class="form-group">
                               <label for="txtSetPrimaryDPName" class="control-label col-sm-4">DP Name:</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly="readonly" class="form-control" id="txtSetPrimaryDPName" runat="server">
                                </div>
                            </div>
                        </div>
                   </div>
                  <div class="row" style="padding-top:10px">
                        <div class="col-sm-12">
                            <div class="form-group">
                               <label for="txtSetPrimaryDPID" class="control-label col-sm-4">DPID:</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly="readonly" class="form-control" id="txtSetPrimaryDPID" runat="server">
                                </div>
                            </div>
                        </div>
                   </div>
                  <div class="row" style="padding-top:10px">
                        <div class="col-sm-12">
                            <div class="form-group">
                               <label for="txtSetPrimaryDPClientID" class="control-label col-sm-4">Client ID:</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly="readonly" class="form-control" id="txtSetPrimaryDPClientID" runat="server">
                                </div>
                            </div>
                        </div>
                     </div>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <input type="hidden" id="hdnSetPrimaryDPID" runat="server" name="hdnSetPrimaryDPID" value="">
                  <button type="button" class="btn btn-success" data-dismiss="modal" id="btnSetPrimaryDPModalYes" onclick="SetPrimaryDP()">Set Primary</button>
                  <button type="button" class="btn btn-danger" data-dismiss="modal">No</button>
              </div>
            </div>
          </div>
        </div>

        <div id="confirmUnfreezeDPModal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                  <h3 id="confirmUnfreezeDPModalHeader"><i class="fa fa-unlock" aria-hidden="true"></i> Unfreeze DP </h3>
              </div>
              <div class="modal-body">
                  <p id="confirmUnfreezeDPModalbody">Do you really want to Unfreeze this DP?</p>
                  <br />
                  <div class="row" style="padding-top:10px">
                       <div class="col-sm-12">
                            <div class="form-group">
                               <label for="txtUnfreezeDPName" class="control-label col-sm-4">DP Name:</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly="readonly" class="form-control" id="txtUnfreezeDPName" runat="server">
                                </div>
                            </div>
                        </div>
                   </div>
                  <div class="row" style="padding-top:10px">
                        <div class="col-sm-12">
                            <div class="form-group">
                               <label for="txtUnfreezeDPID" class="control-label col-sm-4">DPID:</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly="readonly" class="form-control" id="txtUnfreezeDPID" runat="server">
                                </div>
                            </div>
                        </div>
                   </div>
                  <div class="row" style="padding-top:10px">
                        <div class="col-sm-12">
                            <div class="form-group">
                               <label for="txtUnfreezeDPClientID" class="control-label col-sm-4">Client ID:</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly="readonly" class="form-control" id="txtUnfreezeDPClientID" runat="server">
                                </div>
                            </div>
                        </div>
                     </div>
                  <div class="row" style="padding-top:10px">
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label for="UnfreezeDPClientMasterAsyncFileUpload" class="control-label col-sm-4">Upload Client Master:</label>
                                <div class="col-sm-8">
                                    <ajaxToolkit:AsyncFileUpload ID="UnfreezeDPClientMasterAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="UnfreezeDPClientMasterAsyncFileUpload_UploadedComplete" runat="server" />
                                    <span id="spanUnfreezeDPClientMasterAsyncFileUpload" runat="server"></span>
                                </div>
                            </div>
                        </div>
                    </div>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <input type="hidden" id="hdnUnfreezeDPID" runat="server" name="hdnUnfreezeDPID" value="">
                  <button type="button" class="btn btn-success" id="btnUnfreezeDPModalYes" onclick="UnfreezeDP()">Unfreeze</button>
                  <button type="button" class="btn btn-danger" data-dismiss="modal">No</button>
              </div>
            </div>
          </div>
        </div>

        <div id="confirmRemoveDPModal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"> Remove DP</h4>
              </div>
              <div class="modal-body">
                  <p id="confirmRemoveDPModalbody">Do you really want to remove DP?</p>
              </div>
              <div class="modal-footer" style="text-align:center">
                  <input type="hidden" id="hdnRemoveDPID" runat="server" name="hdnRemoveDPID" value="">
                  <input type="hidden" id="hdnRemoveDPClientID" runat="server" name="hdnRemoveDPClientID" value="">
                  <button type="button" class="btn btn-primary" data-dismiss="modal" id="btnConfirmRemoveDPModalNo">No</button>
                  <button type="button" class="btn btn-danger" data-dismiss="modal" id="btnRemoveDPModalYes" onclick="removeDP(document.getElementById('hdnRemoveDPID').value, document.getElementById('hdnRemoveDPClientID').value)">Yes</button>
              </div>
            </div>
          </div>
        </div>

    </form>

    <div class="modal fade" id="modalDDPITerms" tabindex="-1" role="dialog" aria-labelledby="modalDDPITermsLabel">
      <div class="modal-dialog modal-lg" style=" height: 97%;">
        <div class="modal-content" style=" height: 97%;">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h2 class="modal-title" id="modalDDPITermsLabel">DDPI Terms and Conditions</h2>
          </div>
          <div class="modal-body" style="max-height: calc(75%);  overflow-y: scroll;">
            <div id="divDDPItermsandconditionsHTML" runat="server">
                
            </div>
          </div>

          <div class="modal-footer">
              <div id="divSubmitBtns">
                <p id="divLocation" style="font-size:10px"></p>
                <button type="button" class="btn btn-success btn-lg" onclick="saveDataFinally();"><i class="fa fa-check" aria-hidden="true"></i> I agree and continue</button>
              </div>
          </div>
        </div>
      </div>
    </div>

</body>
</html>
