﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="brokerageScheme.aspx.cs" Inherits="Connect_DotNet.eKYC.brokerageScheme" %>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Share Brokerage - Choose Your Scheme</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
        }

        .header {
            text-align: center;
            margin-bottom: 40px;
            border-bottom: 2px solid #eee;
            padding-bottom: 30px;
        }

        .header h1 {
            color: #2c3e50;
            font-size: 2.5rem;
            margin-bottom: 10px;
            font-weight: 700;
        }

        .header p {
            color: #7f8c8d;
            font-size: 1.1rem;
            max-width: 600px;
            margin: 0 auto;
            line-height: 1.6;
        }

        .schemes-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 30px;
            margin-bottom: 40px;
        }

        .scheme-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            border: 3px solid transparent;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            cursor: pointer;
            position: relative;
            overflow: hidden;
        }

        .scheme-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: linear-gradient(90deg, #3498db, #2ecc71);
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }

        .scheme-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.15);
        }

        .scheme-card:hover::before {
            transform: scaleX(1);
        }

        .scheme-card.selected {
            border-color: #3498db;
            background: linear-gradient(135deg, #f8f9ff 0%, #e8f4fd 100%);
            transform: translateY(-3px);
        }

        .scheme-card.selected::before {
            transform: scaleX(1);
            background: linear-gradient(90deg, #3498db, #2980b9);
        }

        .scheme-header {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }

        .scheme-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin-right: 15px;
            background: linear-gradient(135deg, #3498db, #2ecc71);
            color: white;
        }

        .scheme-title {
            font-size: 1.4rem;
            font-weight: 600;
            color: #2c3e50;
            flex: 1;
        }

        .scheme-badge {
            background: #e74c3c;
            color: white;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 500;
        }

        .premium .scheme-badge {
            background: #f39c12;
        }

        .professional .scheme-badge {
            background: #9b59b6;
        }

        .scheme-description {
            color: #666;
            line-height: 1.6;
            margin-bottom: 20px;
        }

        .scheme-features {
            list-style: none;
            margin-bottom: 20px;
        }

        .scheme-features li {
            padding: 8px 0;
            color: #555;
            position: relative;
            padding-left: 25px;
        }

        .scheme-features li::before {
            content: '✓';
            position: absolute;
            left: 0;
            color: #27ae60;
            font-weight: bold;
        }

        .scheme-pricing {
            text-align: center;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 10px;
            margin-bottom: 20px;
        }

        .brokerage-rate {
            font-size: 2rem;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 5px;
        }

        .pricing-note {
            font-size: 0.9rem;
            color: #7f8c8d;
        }

        .radio-wrapper {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-top: 20px;
        }

        .radio-input {
            appearance: none;
            width: 20px;
            height: 20px;
            border: 2px solid #ddd;
            border-radius: 50%;
            margin-right: 10px;
            position: relative;
            transition: all 0.3s ease;
        }

        .radio-input:checked {
            border-color: #3498db;
            background: #3498db;
        }

        .radio-input:checked::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: white;
        }

        .radio-label {
            font-weight: 500;
            color: #2c3e50;
            cursor: pointer;
        }

        .action-buttons {
            text-align: center;
            margin-top: 40px;
        }

        .btn {
            padding: 15px 40px;
            font-size: 1.1rem;
            font-weight: 600;
            border: none;
            border-radius: 50px;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
            margin: 0 10px;
        }

        .btn-primary {
            background: linear-gradient(135deg, #3498db, #2980b9);
            color: white;
            box-shadow: 0 10px 30px rgba(52, 152, 219, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 15px 40px rgba(52, 152, 219, 0.4);
        }

        .btn-secondary {
            background: #ecf0f1;
            color: #2c3e50;
        }

        .btn-secondary:hover {
            background: #d5dbdb;
            transform: translateY(-2px);
        }

        .selected-scheme-info {
            background: linear-gradient(135deg, #2ecc71, #27ae60);
            color: white;
            padding: 20px;
            border-radius: 15px;
            margin-top: 30px;
            text-align: center;
            display: none;
        }

        .selected-scheme-info.show {
            display: block;
            animation: slideUp 0.5s ease;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @media (max-width: 768px) {
            .container {
                padding: 20px;
                margin: 10px;
            }
            
            .schemes-grid {
                grid-template-columns: 1fr;
                gap: 20px;
            }
            
            .header h1 {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🏦 Brokerage Scheme</h1>
            <p>Choose the perfect brokerage scheme tailored to your trading needs. Select from our competitive plans designed for different trading volumes and preferences.</p>
        </div>

        <form id="schemeForm" runat="server">
            <div class="schemes-grid" id="schemesGrid" runat="server">

                <!--
                <div class="scheme-card" data-scheme="basic">
                    <div class="scheme-header">
                        <div class="scheme-icon">💼</div>
                        <div class="scheme-title">Basic Plan</div>
                        <div class="scheme-badge">STARTER</div>
                    </div>
                    
                    <div class="scheme-description">
                        Perfect for new investors and occasional traders. Get started with competitive rates and essential trading features.
                    </div>
                    
                    <ul class="scheme-features">
                        <li>Free account opening</li>
                        <li>Basic research reports</li>
                        <li>Mobile & web trading platform</li>
                        <li>Customer support (email)</li>
                        <li>No minimum balance required</li>
                    </ul>
                    
                    <div class="scheme-pricing">
                        <div class="brokerage-rate">0.50%</div>
                        <div class="pricing-note">Per transaction (Both sides)</div>
                    </div>
                    <div class="radio-wrapper">
                        <input type="radio" name="scheme" value="basic" id="basic" class="radio-input">
                        <label for="basic" class="radio-label">Select Basic Plan</label>
                    </div>
                </div>

                <div class="scheme-card premium" data-scheme="premium">
                    <div class="scheme-header">
                        <div class="scheme-icon">⭐</div>
                        <div class="scheme-title">Premium Plan</div>
                        <div class="scheme-badge">POPULAR</div>
                    </div>
                    
                    <div class="scheme-description">
                        Ideal for regular traders seeking better rates and enhanced features. Most popular choice among active investors.
                    </div>
                    
                    <ul class="scheme-features">
                        <li>Reduced brokerage rates</li>
                        <li>Advanced charting tools</li>
                        <li>Premium research & tips</li>
                        <li>Priority customer support</li>
                        <li>Multiple trading platforms</li>
                        <li>Free AMC for first year</li>
                    </ul>
                    
                    <div class="scheme-pricing">
                        <div class="brokerage-rate">0.30%</div>
                        <div class="pricing-note">Per transaction (Both sides)</div>
                    </div>
                    
                    <div class="radio-wrapper">
                        <input type="radio" name="scheme" value="premium" id="premium" class="radio-input">
                        <label for="premium" class="radio-label">Select Premium Plan</label>
                    </div>
                </div>

                <div class="scheme-card professional" data-scheme="professional">
                    <div class="scheme-header">
                        <div class="scheme-icon">🚀</div>
                        <div class="scheme-title">Professional Plan</div>
                        <div class="scheme-badge">PRO</div>
                    </div>
                    
                    <div class="scheme-description">
                        For high-volume traders and professional investors. Lowest rates with premium features and dedicated support.
                    </div>
                    
                    <ul class="scheme-features">
                        <li>Ultra-low brokerage rates</li>
                        <li>Professional trading terminal</li>
                        <li>Dedicated relationship manager</li>
                        <li>Advanced analytics & reports</li>
                        <li>API access for algo trading</li>
                        <li>Free AMC for 2 years</li>
                        <li>Priority order execution</li>
                    </ul>
                    
                    <div class="scheme-pricing">
                        <div class="brokerage-rate">0.15%</div>
                        <div class="pricing-note">Per transaction (Both sides)</div>
                    </div>
                    
                    <div class="radio-wrapper">
                        <input type="radio" name="scheme" value="professional" id="professional" class="radio-input">
                        <label for="professional" class="radio-label">Select Professional Plan</label>
                    </div>
                </div>
                -->
            </div>
            
            <div class="selected-scheme-info" id="selectedInfo">
                <h3>✅ Selected Scheme: <span id="selectedSchemeName" runat="server"></span></h3>
                <p>You have successfully selected your brokerage scheme. Click continue to proceed with your eKYC process.</p>
            </div>

            <div class="action-buttons">
                <button type="button" class="btn btn-secondary" style="margin-top:5px" onclick="resetSelection()">Reset Selection</button>
                <button type="button" class="btn btn-primary" style="margin-top:5px" onclick="continueToKYC()"  id="continueBtn">Save and Continue</button>
            </div>
            <input id="hdnSelectedScheme" type="hidden" runat="server" />
            <div style="display:none">
                <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click" />
            </div>

        </form>
    </div>

    <script>
        let selectedScheme = null;
        const schemeCards = document.querySelectorAll('.scheme-card');
        const radioInputs = document.querySelectorAll('input[name="scheme"]');
        const continueBtn = document.getElementById('continueBtn');
        const selectedInfo = document.getElementById('selectedInfo');
        const selectedSchemeName = document.getElementById('selectedSchemeName');
       
        const schemeNames = {
            basic: 'Basic Plan',
            premium: 'Premium Plan',
            professional: 'Professional Plan'
        };

        // Add click listeners to scheme cards
        schemeCards.forEach(card => {
            card.addEventListener('click', function() {
                const scheme = this.getAttribute('data-scheme');
                selectScheme(scheme);
            });
        });

        // Add change listeners to radio inputs
        radioInputs.forEach(radio => {
            radio.addEventListener('change', function() {
                if (this.checked) {
                    selectScheme(this.value);
                }
            });
        });

        function selectScheme(scheme) {
            selectedScheme = scheme;
            
            // Update card appearances
            schemeCards.forEach(card => {
                card.classList.remove('selected');
                if (card.getAttribute('data-scheme') === scheme) {
                    card.classList.add('selected');
                }
            });
            
            // Update radio buttons
            radioInputs.forEach(radio => {
                radio.checked = radio.value === scheme;
            });
            
            // Enable continue button and show selected info
            continueBtn.disabled = false;
            selectedSchemeName.textContent = scheme;
            document.getElementById('hdnSelectedScheme').value = scheme;
            selectedInfo.classList.add('show');
            
            // Smooth scroll to selected info
            setTimeout(() => {
                selectedInfo.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
            }, 100);
        }

        function resetSelection() {
            selectedScheme = null;
            
            // Remove selected class from all cards
            schemeCards.forEach(card => {
                card.classList.remove('selected');
            });
            
            // Uncheck all radio buttons
            radioInputs.forEach(radio => {
                radio.checked = false;
            });
            
            // Disable continue button and hide selected info
            continueBtn.disabled = true;
            selectedInfo.classList.remove('show');
        }

        function continueToKYC() {
            if (!selectedScheme) {
                alert('Please select a brokerage scheme first.');
                return;
            }

            document.getElementById('<%= btnContinueClick.UniqueID %>').click();

            //// Store selected scheme in memory (since we can't use localStorage)
            //const schemeData = {
            //    scheme: selectedScheme,
            //    schemeName: schemeNames[selectedScheme],
            //    timestamp: new Date().toISOString()
            //};
            
            //// Simulate navigation to eKYC process
            ////alert(`Proceeding to eKYC with ${schemeNames[selectedScheme]}!\n\nIn a real application, this would redirect to the eKYC verification process.`);
            //alert(`Proceeding with ${schemeNames[selectedScheme]}`);
            
            // You can add actual navigation logic here
            // window.location.href = '/ekyc-process?scheme=' + selectedScheme;
        }

        // Add some entrance animations
        window.addEventListener('load', function() {
            schemeCards.forEach((card, index) => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(30px)';
                
                setTimeout(() => {
                    card.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
                    card.style.opacity = '1';
                    card.style.transform = 'translateY(0)';
                }, 200 * index);
            });
        });
    </script>
</body>
</html>
