﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="dematAccount.aspx.cs" Inherits="Connect_DotNet.eKYC.dematAccount" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<!DOCTYPE html>

<html>
<head runat="server">
  <title>DP Details</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>


  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

        <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />

</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }


    </style>
     <script>

         window.onload = function () {

         }

         function dematAccountSelect() {

             if (document.getElementById('selectOpenDematAccount').value == "No") {
                 document.getElementById('divDepository').style.display = "none";
                 document.getElementById('divExistingDematAccount').style.display = "block";
                 document.getElementById('selectExistingDematAccount').value = "Yes";
             }
             else {
                 document.getElementById('divDepository').style.display = "block";
             }

             
         }

         function existingDematAccountSelect() {

             if (document.getElementById('selectExistingDematAccount').value == "No") {
                 document.getElementById('selectOpenDematAccount').value = "Yes";
                 document.getElementById('divDepository').style.display = "block";
                 document.getElementById('divExistingDematAccount').style.display = "none";
             }
             else {
                 document.getElementById('divExistingDematAccount').style.display = "block";
             }

         }

         function saveData() {

             if (document.getElementById('selectOpenDematAccount').value == "Yes") {

                 if (document.getElementById('selectDepository').value == "") {
                     alertModal("Error : Open demat account", "Please select Depository!");
                     return;
                 }

             }

             if (document.getElementById('selectExistingDematAccount').value == "Yes") {


                  if (document.getElementById('txtDPName').value == "") {
                    alertModal("Error : Existing demat account", "Please enter DP Name!");
                    return;
                }

                if (document.getElementById('txtDPID').value == "") {
                    alertModal("Error : Existing demat account", "Please enter DP ID!");
                    return;
                }

                if (document.getElementById('txtDPClientID').value == "") {
                    alertModal("Error : Existing demat account", "Please enter Client ID!");
                    return;
                }

                 if (validateFileExtensionByFileName(document.getElementById('spanDPClientMasterAsyncFileUpload').innerHTML, "Existing demat account's Client Master", "JPG,PNG,JPEG,PDF") == false) {
                     return;
                 }


             }

             

             document.getElementById('hdnBtnContinueClicked').value = "Continue";

             $('#modalLoading').modal('show');
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
             
         }


         function validateFileExtensionByFileName(fileName, uploadType, fileTypes) {


             if (fileName == "") {
                 alertModal("Error : " + uploadType + " file upload", "Please select for upload " + uploadType + " file in " + fileTypes + " format!");
                 return false;
             }

             const fileTypesArray = fileTypes.split(",");

             let matchesNameExtns = "";
             for (let i = 0; i < fileTypesArray.length; i++) {

                 if (i == fileTypesArray.length - 1) {
                     matchesNameExtns += "." + fileTypesArray[i] + "$";
                 }
                 else {
                     matchesNameExtns += "." + fileTypesArray[i] + "$|";
                 }

             }

             var fileElementFileName = fileName.toUpperCase();

             if (fileElementFileName.match(matchesNameExtns) == null) {
                 alertModal("Error : " + uploadType + " file upload", "Invalid file selected! Please select for upload " + uploadType + " file in " + fileTypes + " format!");
                 return false;
             }

             return true;

         }

         function successAsyncFileUpload(sender, args) {

             const contolName = $(sender._element).find('input').attr('id');
             $(sender._element).find('input').css("background-color", "white");

             var filename = $(sender._element).find('input').val().replace("C:\\fakepath\\", "");

             document.getElementById('spanDPClientMasterAsyncFileUpload').innerHTML = filename;
             document.getElementById('spanDPClientMasterAsyncFileUpload').style.backgroundColor = "lime";


         }

         function alertModal(title, body) {
              // Display error message to the user in a modal
              $('#alert-modal-title').html(title);
            $('#alert-modal-body').html(body);

            if (title.match("Error") == "Error") {
                $('#alert-modal-body').addClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-success");
            }

            else if (title == "Request added") {
                $('#alert-modal-body').addClass("alert-success");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
            }
            else
            {
                $('#alert-modal-body').addClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-success");
            }
            
             $('#alert-modal').modal('show');
             $('#modalLoading').modal('hide');
         }

        
    </script>
    


    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                <div class="col-md-3">
                    <center>
                    <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:200px; padding-top:10px">
                    </center>
                </div>
                <div class="col-md-9">
                    <h2 class="lblTopHeader"><i class="fa fa-university" aria-hidden="true"></i> Demat Account</h2>
                    <p>Open a demat account, or save your existing demat account</p>
                </div>
              </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">

                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div class="row">
                                          <div class="col-md-7">
                                              <div class="form-outline flex-fill mb-0">
                                                    <div class="row">
                                                        <div class="col-md-8">
                                                            <h4>Do you wish to open a demat account with us?</h4>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <select class="form-control" style="width:50%" onchange="dematAccountSelect();" id="selectOpenDematAccount" runat="server">
                                                                <option>Yes</option>  
                                                                <option>No</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                              <div id="divDepository" runat="server">
                                                  <div class="form-group" style="margin-left:-10px; padding-top:10px">
                                                      <div class="row">
                                                          <div class="col-md-8">
                                                              <label for="selectDepository" class="control-label col-sm-5"><i class="fa fa-lg me-3 fa-university fa-fw" aria-hidden="true"></i> Select Depository</label>
                                                                <div class="col-sm-7">
                                                                    <select class="form-control" style="width:50%" id="selectDepository" runat="server">
                                                                    </select>
                                                                </div>
                                                          </div>
                                                      </div>
                                                    </div>
                                              </div>
                                              <hr />
                                              <div class="form-outline flex-fill mb-0">
                                                    <div class="row">
                                                        <div class="col-md-8">
                                                            <h4>Do you have an existing demat account?</h4>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <select class="form-control" style="width:50%" onchange="existingDematAccountSelect();" id="selectExistingDematAccount" runat="server">
                                                                <option>No</option>
                                                                <option>Yes</option>  
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                              <hr />
                                              <div id="divExistingDematAccount" runat="server" style="display:none">
                                                  <h4>Existing demat account details</h4>
                                                  <div class="form-outline flex-fill mb-0" style="padding-top:15px">
                                                    <label class="form-label" for="txtDPName"><i class="fa fa-lg me-3 fa-university fa-fw" aria-hidden="true"></i> DP Name</label>
                                                    <input type="text" class="form-control" id="txtDPName" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="DP Name" maxlength="40">
                                                  </div>
                                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                                    <label class="form-label" for="txtDPID"><i class="fa fa-university fa-lg me-3 fa-fw"></i> DP ID</label>
                                                    <input type="text" class="form-control" id="txtDPID" runat="server" maxlength="8" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" placeholder="DP ID">
                                                  </div>
                                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                                    <label class="form-label" for="txtDPClientID"><i class="fa  fa-lg me-3 fa-id-card fa-fw" aria-hidden="true"></i> Client ID</label>
                                                    <input  type="number" class="form-control" id="txtDPClientID" maxlength="8" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"  runat="server" placeholder="Client ID">
                                                  </div>
                                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                                    <label class="form-label" for="dpClientMasterAsyncFileUpload"><i class="fa fa-address-card fa-lg me-3 fa-fw"></i> Upload Client Master</label>
                                                      <div>
                                                          <div class="row">
                                                            <div class="col-sm-12" style="padding-left:15px; padding-top:10px">
                                                                <div class="form-group">
                                                                     <ajaxToolkit:AsyncFileUpload ID="dpClientMasterAsyncFileUpload" OnClientUploadComplete="successAsyncFileUpload" OnUploadedComplete="dpClientMasterAsyncFileUpload_UploadedComplete" runat="server" />
                                                                    <span id="spanDPClientMasterAsyncFileUpload" runat="server"></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                      </div>
                                                  </div>
                                              <hr />
                                              </div>
                                              <div class="form-outline flex-fill mb-0">
                                                    <div class="row">
                                                        <div class="col-md-8">
                                                            <h4>Do you wish to add DDPI?</h4>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <select class="form-control" style="width:50%" id="selectDDPI" runat="server">
                                                                <option>Yes</option>  
                                                                <option>No</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <hr />
                                                   <div class="row">
                                                        <div class="col-md-8">
                                                            <h5>I instruct the DP to receive each and every credit in my account</h5>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <select class="form-control" style="width:50%" id="selectAutomaticCredit" runat="server">
                                                                <option>Yes</option>  
                                                                <option>No</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                  <div class="row">
                                                    <div class="col-md-8">
                                                        <h5>I would like to instruct the DP to accept all the pledge instructions in my account without any other further instruction from my end</h5>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <select class="form-control" style="width:50%" id="selectInstructPledgeInstructions" runat="server">
                                                            <option>Yes</option>  
                                                            <option>No</option>
                                                        </select>
                                                    </div>
                                                  </div>
                                                  <div class="row">
                                                        <div class="col-md-8">
                                                            <h5>I would like to share the email ID with the <b>RTA</b></h5>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <select class="form-control" style="width:50%" id="selectShareEmailRTA" runat="server">
                                                                <option>Yes</option>  
                                                                <option>No</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                  <div class="row">
                                                    <div class="col-md-8">
                                                        <h5>I request you to send Electronic Transaction-cum-Holding Statement at the registered email</h5>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <select class="form-control" style="width:50%" id="selectElectronicHoldingStatement" runat="server">
                                                            <option>Yes</option>  
                                                            <option>No</option>
                                                        </select>
                                                    </div>
                                                  </div>
                                                  <div class="row">
                                                    <div class="col-md-8">
                                                        <h5>I wish to receive dividend/interest directly in to my bank account as given below through ECS</h5>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <select class="form-control" style="width:50%" id="selectDividendInterestDirectly" runat="server">
                                                            <option>Yes</option>  
                                                            <option>No</option>
                                                        </select>
                                                    </div>
                                                  </div>
                                                </div>
                                              <hr />
                                                <h4>Go to previous step </h4> 
                                                      <ul class="list-inline">
                                                        <li><a href="PANVerification.aspx"><i class="fa fa-id-card" aria-hidden="true"></i> PAN</a></li>
                                                        <li><a href="selectSegments.aspx"><i class="fa fa-exchange" aria-hidden="true"></i> Segments</a></li>
                                                        <li><a href="aadhaarKYC.aspx"><i class="fa fa-user" aria-hidden="true"></i> Aadhaar Data</a></li>
                                                        <li><a href="capturePhoto.aspx"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                                        <li><a href="profile.aspx"><i class="fa fa-user" aria-hidden="true"></i> Profile</a></li>
                                                        <li><a href="addBank.aspx"><i class="fa fa-university" aria-hidden="true"></i> Bank</a></li>
                                                        <li><a href="Nomination.aspx"><i class="fa fa-users" aria-hidden="true"></i> Nomination</a></li>
                                                    </ul>
                                          </div>
                                          <div class="col-md-5">
                                             <h3 id="hFullName" runat="server"></h3>
                                              <p>
                                              Date of Birth : <u><span id="spanDOB" runat="server"></span></u>
                                              <br />
                                              Gender : <u><span id="spanGender" runat="server"></span></u>
                                              <br />
                                              Nationality : <u><span id="spanNationality" runat="server"></span></u>
                                              <br />
                                             </p>
                                             <br />
                                             <p>
                                                 <b><span id="spanBrokerName" runat="server">Standard Broker</span></b> for conducting online KYC for openinig a trading and demat account
                                             </p>
                                             <p>
                                                The Aadhaar and the PAN [<span id="spanPAN" runat="server"></span>] should belong to you, the applicant, if it does not, <a href="PANVerification.aspx">start over</a>.
                                             </p>
                                              <p>
                                                  Your name also must match in both documents Aadhaar and PAN , if it does not, then you can resolve the name mismatch issue by changing your name on the PAN Card from <a href="https://www.onlineservices.nsdl.com/paam/endUserRegisterContact.html">NSDL</a>  or on the Aadhaar Card from <a href="https://www.uidai.gov.in">UIDAI</a>.
                                             </p>

                                              <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                                    <br />
                                                  <div class="alert alert-info" id="divAlertInfoMsg" runat="server" style="margin-top:10px;padding-top:10px">
                                                  </div>
                                                  <div class="alert alert-warning" style="margin-top:10px;padding-top:10px">
                                                      <strong>Warning!</strong> If you have existing demat account, then a signed and stamped copy of the <b>Client Master</b> arranged from your DP will have to be uploaded here. If not uploaded, your request will be rejected.
                                                  </div>
                                                  <button type="button" class="btn btn-success btn-lg" id="btnContinue" onclick="saveData();" runat="server" ><i class="fa fa-check" aria-hidden="true"></i> Save and Continue</button>
                                                  <p>
                                                      <br />
                                                      <i>
                                                        *By clicking the above button, I agree that i have read <a href="#">Terms & Conditions</a>.
                                                      </i>
                                                  </p>

                                                  <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                                  </div>
                                                  <br />
                                                
                                              </div>
                                          </div>
                                      </div>

                                  </div>
                              </div>
                              

                            </ContentTemplate>
                        </asp:UpdatePanel>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
                
            </div>


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
                      <br />
                      <br />
			    </div>
                
             </div>

          </div>
        </section>
    </form>
     <div id="alert-modal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="alert-modal-title" class="modal-title"></h4>
              </div>
              <div id="alert-modal-body" class="modal-body"></div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">OK</button>
              </div>
            </div>
          </div>
        </div>

     <div class="modal fade" id="modalLoading" tabindex="-1" role="dialog" aria-labelledby="modalLoadingLabel">
      <div class="modal-dialog modal-md">
        <div class="modal-content">
          <div class="modal-header">
          </div>
          <div class="modal-body">
              <center>
                    <h4>Please wait..Your request is being processed..</h4>
                    <p>Do not close browser window....</p>
                    <img src="images/Loading.gif" alt="Loading" style="width:150px;" />
               </center>
          </div>

          <div class="modal-footer">
          </div>
        </div>
      </div>
    </div>

</body>
</html>
