﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="manuallyProcessing.aspx.cs" Inherits="Connect_DotNet.eKYC.manuallyProcessing" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<!DOCTYPE html>

<html>
<head runat="server">
  <title> Manually processing</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>


  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

        <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />

</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }


    </style>
     <script>

          window.onload = function () {

             
         }

         function saveData() {


             if (document.getElementById('cmbGender').value == "") {
                 alertModal("Error", "Please select Gender!");
                 return;
             }

             if (document.getElementById('txtNationality').value == "") {
                 alertModal("Error", "Please enter Nationality!");
                 return;
             }


             if (document.getElementById('txtAadhaar').value == "") {
                 alertModal("Error", "Please enter Aadhaar!");
                 return;
             }

             if (document.getElementById('txtAdd1').value == "") {
                 alertModal("Error", "Please enter Nominee Address" + nomNo + "!");
                 return false;
             }
             if (document.getElementById('txtPincode').value == "") {
                 alertModal("Error", "Please enter Nominee Pincode!");
                 return false;
             }

             if (document.getElementById('cmbState').value == "") {
                 alertModal("Error", "Please select Nominee State!");
                 return false;
             }

             if (document.getElementById('cmbCountry').value == "") {
                 alertModal("Error", "Please enter Nominee Country!");
                 return false;
             }


             $('#modalLoading').modal('show');
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();

         }

         function alertModal(title, body) {
              // Display error message to the user in a modal
              $('#alert-modal-title').html(title);
            $('#alert-modal-body').html(body);

            if (title.match("Error") == "Error") {
                $('#alert-modal-body').addClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-success");
            }

            else if (title == "Request added") {
                $('#alert-modal-body').addClass("alert-success");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
            }
            else
            {
                $('#alert-modal-body').addClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-success");
            }
            
             $('#alert-modal').modal('show');
             $('#modalLoading').modal('hide');
         }

        
    </script>
    


    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                <div class="col-md-3">
                    <center>
                    <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:200px; padding-top:10px">
                    </center>
                </div>
                <div class="col-md-9">
                    <h2 class="lblTopHeader"><i class="fa fa-user" aria-hidden="true"></i> Manually processing</h2>
                    <p>The following information of your need to be submitted</p>
                </div>
               </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">

                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div class="row">
                                          <div class="col-md-8">
                                              <div id="divData">
                                                
                                                <div class="row" style="padding-top:20px">
                                                    <div class="col-sm-6">
                                                            <div class="form-group">
                                                            <label for="cmbGender" class="control-label col-sm-4">Gender*:</label>
                                                                <div class="col-sm-8">
                                                                    <asp:DropDownList ID="cmbGender" CssClass="form-control" runat="server">
                                                                        <asp:ListItem Value="M">Male</asp:ListItem>
                                                                        <asp:ListItem Value="F">Female</asp:ListItem>
                                                                        <asp:ListItem Value="T">Transgender</asp:ListItem>
                                                                    </asp:DropDownList>
                                                                </div>
                                                            </div>
                                                    </div>
                                                    <div class="col-sm-6">
                                                            <div class="form-group">
                                                            <label for="txtNationality" class="control-label col-sm-4">Nationality*:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="text" class="form-control" id="txtNationality" runat="server" maxlength="100">
                                                                </div>
                                                            </div>
                                                    </div>
                                                </div>
                                              <div class="row" style="padding-top:20px">
                                                    <div class="col-sm-6">
                                                            <div class="form-group">
                                                            <label for="txtAadhaar" class="control-label col-sm-4">Last 4 digits of Aadhaar*:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="number" class="form-control" runat="server" id="txtAadhaar" maxlength="4" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                                                                </div>
                                                            </div>
                                                    </div>
                                                </div>
                                                    <div class="row" style="padding-top:10px">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label for="txtAdd1" class="control-label col-sm-4">Address 1*:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="text" class="form-control" id="txtAdd1" runat="server" placeholder="Address 1" maxlength="50">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                            <label for="txtAdd2" class="control-label col-sm-4">Address 2:</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" class="form-control" id="txtAdd2" runat="server" placeholder="Address 2" maxlength="50">
                                                            </div>
                                                        </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label for="txtAdd3" class="control-label col-sm-4">Address 3:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="text" class="form-control" id="txtAdd3" runat="server" placeholder="Address 3" maxlength="50">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label for="txtCity" class="control-label col-sm-4">City:</label>
                                                                <div class="col-sm-8">
                                                                    <input type="text" class="form-control" id="txtCity" runat="server" placeholder="City" maxlength="50">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label for="txtPincode" class="control-label col-sm-4">Pincode*:</label>
                                                                <div class="col-sm-8">
                                                                    <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"    type = "number"  maxlength = "6" class="form-control" id="txtPincode" runat="server" placeholder="Pincode">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label for="cmbState" class="control-label col-sm-4">State*:</label>
                                                                <div class="col-sm-8">
                                                                    <asp:DropDownList ID="cmbState" CssClass="form-control" runat="server">
                                                                    </asp:DropDownList>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label for="cmbCountry" class="control-label col-sm-4">Country*:</label>
                                                                <div class="col-sm-8">
                                                                    <asp:DropDownList ID="cmbCountry" CssClass="form-control" runat="server">
                                                                    </asp:DropDownList>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <div class="row">
                                                    <div class="col-sm-12">
                                                        <div style="padding-top:10px; padding-left:10px;">
                                                            <button type="button" class="btn btn-success btn-lg" id="btnSaveContinue" onclick="saveData();" runat="server" style="margin-top:5px" ><i class="fa fa-check" aria-hidden="true"></i> Save & Continue</button> 
                                                            <span style="font-size:18px; font-weight:bold;">OR <a class="link-info" href="aadhaarKYC.aspx" id="btnContinueDigiLocker" style="font-size:14px"> <i class="fa fa-cloud-download" aria-hidden="true"></i> <u>Go through DigiLocker</u></a></span> 
                                                            <p>
                                                                  <br />
                                                                  <i>
                                                                    *By clicking the above <b>'Save and Continue'</b> button, I agree that i have read <a href="#">Terms & Conditions</a>.
                                                                  </i>
                                                              </p>

                                                              <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                                              </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                              <hr />
                                              <h4>Go to previous step </h4> 
                                                <ul class="list-inline">
                                                <li><a href="PANVerification.aspx"><i class="fa fa-id-card" aria-hidden="true"></i> PAN Verification</a></li>
                                                <li><a href="selectSegments.aspx"><i class="fa fa-exchange" aria-hidden="true"></i> Segments</a></li>
                                            </ul>
                                          </div>
                                          <div class="col-md-4">
                                            <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4">
                                                <div class="alert alert-warning">
                                                    <strong>Warning!</strong> Please remember that: <br />
                                                    <span id="spanAadhaarUploadNotes" runat="server">
                                                        If your entered data doesn't match with your PAN and Aadhaar then your application will be rejected
                                                    </span>
                                                </div>
                                            </div>

                                             <h3 id="hFullName" runat="server"></h3>
                                              <p>
                                              Date of Birth : <u><span id="spanDOB" runat="server"></span></u>
                                              <br />
                                              Mobile : <u><span id="spanMobile" runat="server"></span></u>
                                              <br />
                                              Email : <u><span id="spanEmail" runat="server"></span></u>
                                              <br />
                                             </p>
                                             <br />
                                             <p>
                                                 <b><span id="spanBrokerName" runat="server">Standard Broker</span></b> for conducting online KYC for openinig a trading and demat account
                                             </p>
                                             <p>
                                                The Aadhaar and the PAN [<span id="spanPAN" runat="server"></span>] should belong to you, the applicant, if it does not, <a href="PANVerification.aspx">start over</a>.
                                             </p>
                                              <p>
                                                  Your name also must match in both documents Aadhaar and PAN , if it does not, then you can resolve the name mismatch issue by changing your name on the PAN Card from <a href="https://www.onlineservices.nsdl.com/paam/endUserRegisterContact.html">NSDL</a>  or on the Aadhaar Card from <a href="https://www.uidai.gov.in">UIDAI</a>.
                                             </p>

                                          </div>
                                      </div>
                                  </div>
                              </div>
                              

                            </ContentTemplate>
                        </asp:UpdatePanel>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
                
            </div>


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
                      <br />
                      <br />
			    </div>
                
             </div>

          </div>
        </section>
    </form>
     <div id="alert-modal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="alert-modal-title" class="modal-title"></h4>
              </div>
              <div id="alert-modal-body" class="modal-body"></div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">OK</button>
              </div>
            </div>
          </div>
        </div>

     <div class="modal fade" id="modalLoading" tabindex="-1" role="dialog" aria-labelledby="modalLoadingLabel">
      <div class="modal-dialog modal-md">
        <div class="modal-content">
          <div class="modal-header">
          </div>
          <div class="modal-body">
              <center>
                    <h4>Please wait..Your request is being processed..</h4>
                    <p>Do not close browser window....</p>
                    <img src="images/Loading.gif" alt="Loading" style="width:150px;" />
               </center>
          </div>

          <div class="modal-footer">
          </div>
        </div>
      </div>
    </div>

</body>
</html>
