﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="profile.aspx.cs" Inherits="Connect_DotNet.eKYC.profile" %>

<!DOCTYPE html>

<html>
<head>
  <title>Aadhaar KYC (DigiLocker)</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>


  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

  <!--
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/js/bootstrap.bundle.min.js"></script>
  -->
  
    <!--<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.slim.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
      -->

    <link href="css/ekyc.css" rel="stylesheet" />
    <link href="../custom/ekyc_override.css" rel="stylesheet" />

</head>
<body>
     <style>
        .margineTop10{
            margin-top:10px
        }


    </style>
     <script>

         function displayElement(actualValue, displayValue, element) {

             if (actualValue == displayValue) {
                 element.style.display = "block";
             } else {
                 element.style.display = "none";
             }
         }

         function saveData() {
             
             if (document.getElementById('txtFatherFirstName').value == "") {
                 alertModal("Error", "Please enter Father First Name!");
                 return;
             }

             if (document.getElementById('txtFatherLastName').value == "") {
                 alertModal("Error", "Please enter Father Last Name!");
                 return;
             }

             if (document.getElementById('txtMotherFirstName').value == "") {
                 alertModal("Error", "Please enter Mother First Name!");
                 return;
             }

             if (document.getElementById('txtMotherLastName').value == "") {
                 alertModal("Error", "Please enter Mother Last Name!");
                 return;
             }

             if (document.getElementById('txtAnnualIncome').value == "") {
                 alertModal("Error", "Please enter your Annual Income!");
                 return;
             }

             if (document.getElementById('txtAnnualIncome').value < 1) {
                 alertModal("Error", "Annual Income can't be 0 or negetive!");
                 return;
             }

             if (document.getElementById('txtTradingExperience').value == "") {
                 document.getElementById('txtTradingExperience').value = 0;
             }

             if (document.getElementById('txtTradingExperience').value != "") {

                 if (document.getElementById('txtTradingExperience').value < 0) {
                     alertModal("Error", "Trading Experience can't negetive!");
                     return;
                 }

             }
             

             if (document.getElementById('selectOccupation').value == "") {
                 alertModal("Error", "Please select Occupation!");
                 return;
             }
             

             document.getElementById('hdnBtnContinueClicked').value = "Continue";
             
             $('#modalLoading').modal('show');
             document.getElementById('<%= btnContinueClick.UniqueID %>').click();
             
         }

         

         function alertModal(title, body) {
              // Display error message to the user in a modal
              $('#alert-modal-title').html(title);
            $('#alert-modal-body').html(body);

            if (title.match("Error") == "Error") {
                $('#alert-modal-body').addClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-success");
            }

            else if (title == "Request added") {
                $('#alert-modal-body').addClass("alert-success");
                $('#alert-modal-body').removeClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
            }
            else
            {
                $('#alert-modal-body').addClass("alert-info");
                $('#alert-modal-body').removeClass("alert-danger");
                $('#alert-modal-body').removeClass("alert-success");
            }
            
             $('#alert-modal').modal('show');
             $('#modalLoading').modal('hide');
         }

        
    </script>
    


    <form id="form1" runat="server">
        <asp:ScriptManager runat="server"></asp:ScriptManager>
        <br />
        <section class="vh-100">
          <div class="container h-100">
              <div class="row">
                <div class="col-md-3">
                    <center>
                    <img src="../../custom/your_logo_large.png" class="img-responsive" style="width:200px; padding-top:10px">
                    </center>
                </div>
                <div class="col-md-9">
                    <h2 class="lblTopHeader"><i class="fa fa-user" aria-hidden="true"></i> Your Profile</h2>
                    <p>Fill your profile other data.</p>
                </div>
               </div>
              <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>

            <div class="row d-flex justify-content-center align-items-center">
              <div class="col-lg-12 col-xl-11">
                <div class="card text-black" style="border-radius: 25px;">
                  <div class="card-body p-md-5">
                    <div class="row justify-content-center">
                      <div class="col-md-12">

                          <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                            <ContentTemplate>
                                <div style="display:none">
                                    <asp:Button ID="btnContinueClick" runat="server" Text="" OnClick="btnContinueClick_Click"/> 
                                    <input type="hidden" id="hdnBtnContinueClicked" name="hdnBtnContinueClicked" runat="server" value="">
                                </div>
                              <div class="d-flex flex-row align-items-center mb-4">
                                  <div class="form-outline flex-fill mb-0 margineTop10">
                                      <div class="row">
                                          <div class="col-md-8">
                                              <div class="form-outline flex-fill mb-0">
                                                  <label class="form-label" for="rdblMaritalStatus"><i class="fa fa-users fa-lg" aria-hidden="true"></i> Marital status*: </label>
                                                  <asp:RadioButtonList ID="rdblMaritalStatus" RepeatLayout="Flow" RepeatDirection="Horizontal" runat="server">
                                                    <asp:ListItem class="radio-inline" Value="S" Text="Single" Selected="True"></asp:ListItem>
                                                    <asp:ListItem class="radio-inline" Value="M" Text="Married"></asp:ListItem>
                                                    <asp:ListItem class="radio-inline" Value="W" Text="Widowed"></asp:ListItem>
                                                    <asp:ListItem class="radio-inline" Value="D" Text="Divorced"></asp:ListItem>
                                                    <asp:ListItem class="radio-inline" Value="SE" Text="Separated"></asp:ListItem>
                                                   </asp:RadioButtonList>
                                              </div>
                                              <br />
                                              <div class="row">
                                                  <div class="col-sm-4">
                                                      <div class="form-outline flex-fill mb-0">
                                                        <label class="form-label" for="txtFatherFirstName"><i class="fa  fa-lg me-3 fa-male fa-fw" aria-hidden="true"></i> Father First name*</label>
                                                        <input type="text"  class="form-control" id="txtFatherFirstName" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="Enter Father First name">
                                                      </div>
                                                  </div>
                                                  <div class="col-sm-4">
                                                      <div class="form-outline flex-fill mb-0">
                                                        <label class="form-label" for="txtFatherMiddleName">Father Middle name</label>
                                                        <input type="text"  class="form-control" id="txtFatherMiddleName" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="Enter Father Middle name">
                                                      </div>
                                                  </div>
                                                  <div class="col-sm-4">
                                                      <div class="form-outline flex-fill mb-0">
                                                        <label class="form-label" for="txtFatherLastName">Father Last name*</label>
                                                        <input type="text"  class="form-control" id="txtFatherLastName" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="Enter Father Last name">
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="row">
                                                  <div class="col-sm-4">
                                                      <div class="form-outline flex-fill mb-0 margineTop10">
                                                        <label class="form-label" for="txtMotherFirstName"><i class="fa fa-female fa-lg me-3 fa-fw"></i> Mother First name*</label>
                                                        <input type="text"  class="form-control" id="txtMotherFirstName" runat="server" onkeydown="return /[a-z ]/i.test(event.key)" placeholder="Enter Mother First name">
                                                      </div>
                                                  </div>
                                                  <div class="col-sm-4">
                                                      <div class="form-outline flex-fill mb-0 margineTop10">
                                                        <label class="form-label" for="txtMotherMiddleName">Mother Middle name</label>
                                                        <input type="text"  class="form-control" id="txtMotherMiddleName" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="Enter Mother Middle name">
                                                      </div>
                                                  </div>
                                                  <div class="col-sm-4">
                                                      <div class="form-outline flex-fill mb-0 margineTop10">
                                                        <label class="form-label" for="txtMotherLastName">Mother Last name*</label>
                                                        <input type="text"  class="form-control" id="txtMotherLastName" runat="server" onkeydown="return /[a-z ]/i.test(event.key)" placeholder="Enter Mother Last name">
                                                      </div>
                                                  </div>
                                              </div>
                                              <br />
                                              <hr />
                                              <h3><u>Background</u></h3>
                                              <div class="row">
                                                  <div class="col-md-6">
                                                      <div class="form-outline flex-fill mb-0">
                                                          <label class="form-label" for="txtAnnualIncome"><i class="fa fa-inr fa-lg" aria-hidden="true"></i> Annual Income*</label>
                                                          <input type="number"  class="form-control" id="txtAnnualIncome" maxlength="30" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Annual Income in Rs.">
                                                       </div>
                                                  </div>
                                                  <div class="col-md-6">
                                                      <div class="form-outline flex-fill mb-0">
                                                        <label class="form-label" for="selectOccupation"><i class="fa fa-briefcase fa-lg me-3 fa-fw"></i> Occupation</label>
                                                          <select class="form-control" id="selectOccupation" runat="server">
                                                              <option>Service</option>
                                                              <option>Student</option>
                                                              <option>Housewife</option>
                                                              <option>Retired</option>
                                                              <option>Business</option>
                                                              <option>Professional</option>
                                                              <option>Agriculture</option>
                                                              <option>Landlord</option>
                                                              <option>Private Sector</option>
                                                              <option>Public Sector</option>
                                                              <option>Government Sector</option>
                                                              <option>Others</option>
                                                           </select>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="row">
                                                  <div class="col-md-6">
                                                      <div class="form-outline flex-fill mb-0 margineTop10">
                                                          <label class="form-label" for="txtTradingExperience"><i class="fa fa-calendar" aria-hidden="true"></i> Trading Experience (in years)</label>
                                                          <input type="number"  class="form-control" id="txtTradingExperience" maxlength="2" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" runat="server" placeholder="Enter Trading Experience in Years.">
                                                       </div>
                                                  </div>
                                              </div>
                                              <br />
                                              <div class="form-check form-switch">
                                                  <label class="form-check-label" for="checkTaxResidentOtherThanIndia">Are you a tax resident of any country other than India?</label>
                                                  <input class="form-check-input" type="checkbox" id="checkTaxResidentOtherThanIndia" runat="server" name="darkmode" value="yes">
                                              </div>
                                              <br />
                                              <div class="form-check form-switch">
                                                  <label class="form-check-label" for="checkPoliticallyExposed">Are you politically exposed?</label>
                                                  <input class="form-check-input" type="checkbox" id="checkPoliticallyExposed" runat="server" name="darkmode" value="yes">
                                              </div>
                                              <hr />
                                              <h3><u>Other Preferences</u></h3>
                                              <div class="row">
                                                <div class="col-md-8">
                                                    <h5>Account Statement Requirement</h5>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control" style="width:90%" id="selectAccountStatementRequirement" runat="server">
                                                        <option>As per SEBI Regulation</option>  
                                                        <option>Daily</option>  
                                                        <option>Weekly</option>
                                                        <option>Fortnightly</option>
                                                        <option>Monthly</option>
                                                    </select>
                                                </div>
                                            </div>
                                              <div class="row">
                                                <div class="col-md-8">
                                                    <h5>I would like to receive the Annual Report</h5>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control" style="width:90%" id="selectReceiveAnnualReport" runat="server">
                                                        <option>Electronic</option>
                                                        <option>Physical</option>
                                                        <option>Both Physical and Electronic</option>
                                                    </select>
                                                </div>
                                             </div>
                                              <hr style="margin-top: 5px; margin-bottom: 5px;" />
                                              <div class="row">
                                                <div class="col-md-8">
                                                    <h5>Details of any action/proceedings initiated/pending/taken by SEBI/Stock Exchange/any other authority against the applicant/constituent or its Partners/promoters/whole time directors/authorized persons in charge of dealing in securities during the last 3 years</h5>
                                                    <div id="divActionTakenBySEBIExplain" runat="server"  style="display:none">
                                                        <label class="form-label" for="txtActionTakenBySEBIExplain">Please explain:</label>
                                                        <textarea class="form-control" rows="2" id="txtActionTakenBySEBIExplain" runat="server" placeholder="Please Explain"></textarea>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control" style="width:90%" id="selectActionTakenBySEBI" onchange="displayElement(this.value,'Yes', document.getElementById('divActionTakenBySEBIExplain'))" runat="server">
                                                        <option>No</option>
                                                        <option>Yes</option>
                                                    </select>
                                                </div>
                                             </div>
                                              <hr style="margin-top: 5px; margin-bottom: 5px;" />
                                              <div class="row">
                                                <div class="col-md-8">
                                                    <h5>INFORMATION PROVIDED BY THE CLIENT IN RELATION TO THE PREVENTION OF MONEY LAUNDERING ACT, 2002 Details of my Relatives, having account with <span id="spanBroker" style="font-weight:bold" runat="server"></span></h5>
                                                    <div id="divRelativeHavingAccount" runat="server"  style="display:none">
                                                        <div class="row">
                                                          <div class="col-sm-6">
                                                              <div class="form-outline flex-fill mb-0">
                                                                <label class="form-label" for="txtRelativeAccountName">Name</label>
                                                                <input type="text"  class="form-control" id="txtRelativeAccountName" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="Name">
                                                              </div>
                                                          </div>
                                                          <div class="col-sm-3">
                                                              <div class="form-outline flex-fill mb-0">
                                                                <label class="form-label" for="txtRelativeRelationship">Relationship</label>
                                                                <input type="text"  class="form-control" id="txtRelativeRelationship" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="Relationship">
                                                              </div>
                                                          </div>
                                                          <div class="col-sm-3">
                                                              <div class="form-outline flex-fill mb-0">
                                                                <label class="form-label" for="txtRelativeUCC">UCC</label>
                                                                <input type="text"  class="form-control" id="txtRelativeUCC"  runat="server" placeholder="UCC">
                                                              </div>
                                                          </div>
                                                      </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control" style="width:90%" id="selectRelativeHavingAccount" onchange="displayElement(this.value,'Yes', document.getElementById('divRelativeHavingAccount'))" runat="server">
                                                        <option>No</option>
                                                        <option>Yes</option>
                                                    </select>
                                                </div>
                                             </div>
                                              <hr style="margin-top: 5px; margin-bottom: 5px;" />
                                               <div class="row">
                                                <div class="col-md-8">
                                                    <h5>I intend to invest in the stock market with</h5>
                                                    <div id="divInvestFromBorrowedFunds" runat="server"  style="display:none">
                                                        <div class="row">
                                                          <div class="col-sm-6">
                                                              <div class="form-outline flex-fill mb-0">
                                                                <label class="form-label" for="txtInvestFromBorrowedFundsSources">Sources of Borrowed Funds</label>
                                                                <input type="text"  class="form-control" id="txtInvestFromBorrowedFundsSources" onkeydown="return /[a-z ]/i.test(event.key)" runat="server" placeholder="Sources of Borrowed Funds">
                                                              </div>
                                                          </div>
                                                          <div class="col-sm-6">
                                                              <div class="form-outline flex-fill mb-0">
                                                                <label class="form-label" for="txtInvestFromBorrowedFundsAmount">Amount</label>
                                                                <input type="number"  maxlength="30" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" class="form-control" id="txtInvestFromBorrowedFundsAmount" runat="server" placeholder="Amount">
                                                              </div>
                                                          </div>
                                                      </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control" style="width:90%" id="selectInvestFundsFrom" onchange="displayElement(this.value,'Borrowed Funds', document.getElementById('divInvestFromBorrowedFunds'))" runat="server">
                                                        <option>Own Funds</option>
                                                        <option>Borrowed Funds</option>
                                                    </select>
                                                </div>
                                             </div>
                                              <hr style="margin-top: 2px; margin-bottom: 2px;" />
                                              <div class="row">
                                                <div class="col-md-8">
                                                    <h5>Settlements of Running Accounts</h5>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control" style="width:90%" id="selectSettlementsRunningAccounts" runat="server">
                                                        <option>Quarterly</option>
                                                        <option>Monthly</option>
                                                        <option>Regular/None</option>
                                                    </select>
                                                </div>
                                             </div>
                                          </div>
                                          <div class="col-md-4">
                                             <div class="row">
                                                  <div class="col-xs-6">
                                                      <center>
                                                      <img id="ImgAadhaar" width="160" height="200" src="" alt="Aadhaar Photo" runat="server">
                                                      <br />
                                                      <span>Fetch from Aadhaar</span>
                                                       </center>
                                                  </div>
                                                  <div class="col-xs-6">
                                                      <center>
                                                      <img id="ImgLivePhotoCaptured" width="160" height="200" src="" alt="Aadhaar Photo" runat="server">
                                                      <br />
                                                      <span>Live photo captured</span>
                                                       </center>
                                                  </div>
                                              </div>
                                              <br />
                                              <h2 id="hFullName" runat="server"></h2>
                                              <p>
                                              Date of Birth : <u><span id="spanDOB" runat="server"></span></u>
                                              <br />
                                              Gender : <u><span id="spanGender" runat="server"></span></u>
                                              <br />
                                              Nationality : <u><span id="spanNationality" runat="server"></span></u>
                                              <br />
                                              <br />
                                              Permanent Address : <u><span id="spanPermanentAddress" runat="server"></span></u>
                                              <br />
                                              Correspondence Address : <u><span id="spanCorrespondenceAddress" runat="server"></span></u>
                                             </p>
                                             <br />
                                             <p>
                                                 <b><span id="spanBrokerName" runat="server">Standard Broker</span></b> for conducting online KYC for openinig a trading and demat account
                                             </p>
                                             <p>
                                                The Aadhaar and the PAN [<span id="spanPAN" runat="server"></span>] should belong to you, the applicant, if it does not, <a href="PANVerification.aspx">start over</a>.
                                             </p>
                                              <p>
                                                  Your name also must match in both documents Aadhaar and PAN , if it does not, then you can resolve the name mismatch issue by changing your name on the PAN Card from <a href="https://www.onlineservices.nsdl.com/paam/endUserRegisterContact.html">NSDL</a>  or on the Aadhaar Card from <a href="https://www.uidai.gov.in">UIDAI</a>.
                                             </p>
                                              <br />
                                              <br />
                                              <h4>Why do we need your Aadhaar?</h4>
                                              <p>
                                                  Name, Gender, Address and Date of Birth from Aadhaar for KYC registration
                                              </p>
                                              <p>
                                                Your Aadhaar number is never visible or available to us.
                                              </p>

                                              <div class="d-flex justify-content-center mx-4 mb-3 mb-lg-4 margineTop10">
                                                  <button type="button" class="btn btn-success btn-lg" id="btnContinue" onclick="saveData();" runat="server" ><i class="fa fa-check" aria-hidden="true"></i> Continue</button>
                                  
                                                  <div id="divAlertMsg" runat="server" style="display:none" class="margineTop10" >
                                                  </div>
                                                  <br />
                                                  <br />
                                              </div>
                                          </div>
                                      </div>
                                       <h4>Go to previous step </h4> 
                                             <ul class="list-inline">
                                                <li><a href="PANVerification.aspx"><i class="fa fa-id-card" aria-hidden="true"></i> PAN</a></li>
                                                <li><a href="selectSegments.aspx"><i class="fa fa-exchange" aria-hidden="true"></i> Segments</a></li>
                                                <li><a href="aadhaarKYC.aspx"><i class="fa fa-user" aria-hidden="true"></i> Aadhaar Data</a></li>
                                                <li><a href="capturePhoto.aspx"><i class="fa fa-camera" aria-hidden="true"></i> Capture Photo</a></li>
                                            </ul>
                                  </div>
                              </div>
                              

                            </ContentTemplate>
                        </asp:UpdatePanel>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
              <!--<div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:100%; height:5px">
                </div>
              </div>-->


              <div class="row">
                <div class="col-sm-6" >

                </div>
                <div class="col-sm-6 poweredBy" style="text-align:right;">
                    <span style="font-size:small;text-align:right">Powered by</span><br/>
				    <a href="http://www.stansoftware.com">
					    <img src="../../images/Logos/sharepro.png" class="img-responsive pull-right" style="max-height:20px">
						    </a>
                      <br />
                      <br />
			    </div>
                
             </div>

          </div>
        </section>
    </form>
     <div id="alert-modal" class="modal fade">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="alert-modal-title" class="modal-title"></h4>
              </div>
              <div id="alert-modal-body" class="modal-body"></div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">OK</button>
              </div>
            </div>
          </div>
        </div>

     <div class="modal fade" id="modalLoading" tabindex="-1" role="dialog" aria-labelledby="modalLoadingLabel">
      <div class="modal-dialog modal-md">
        <div class="modal-content">
          <div class="modal-header">
          </div>
          <div class="modal-body">
              <center>
                    <h4>Please wait..Your request is being processed..</h4>
                    <p>Do not close browser window....</p>
                    <img src="images/Loading.gif" alt="Loading" style="width:150px;" />
               </center>
          </div>

          <div class="modal-footer">
          </div>
        </div>
      </div>
    </div>

</body>
</html>
